
#ifndef IIRSCRAM_DESIGNATOR_EXPLICIT_HH
#define IIRSCRAM_DESIGNATOR_EXPLICIT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Narayanan Thondugulam 
//          Umesh Kumar V. Rajasekaran 
//          Timothy J. McBrayer
//          Krishnan Subramani 

#include "IIRBase_DesignatorExplicit.hh"
class IIR_List;
template <class type> class set;
class IIR_TypeDefinition;
class IIR_Declaration;
class IIR_AboveAttribute;

class IIRScram_DesignatorExplicit : public IIRBase_DesignatorExplicit {
public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_entity_class( ostream & );
  void _publish_entity_class(ostream &);

  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_designator( published_file &_cc_out );
  void _publish_cc_entity_class( published_file &_cc_out );

  void _add_decl_into_cgen_symbol_table();
  void _get_list_of_input_signals( set<IIR> *list );

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);

  IIR *_semantic_transform( set<IIR_TypeDefinition> * );
  void _type_check( set<IIR_TypeDefinition> * );
  IIR *_rval_to_decl( IIR_TypeDefinition * );

  IIR *_get_name();

  // This method looks up the name, and then eliminates declarations that
  // don't match the signature.
  set<IIR_Declaration> *_symbol_lookup();

  IIR *_clone();

  IIR_Boolean _is_resolved();
  IIR_Boolean _is_signal();
  IIR_SignalKind _get_signal_kind();

  ostream &_print( ostream &os );

  IIR_Boolean _is_locally_static();
  IIR_Boolean _is_globally_static();

  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_DesignatorExplicit() {}
  virtual ~IIRScram_DesignatorExplicit() = 0;
    
private:
};
#endif
