
#ifndef IIRSCRAM_DOT_ATTRIBUTE_HH
#define IIRSCRAM_DOT_ATTRIBUTE_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRBase_DotAttribute.hh"
class IIR_Declaration;
template <class type> class dl_list;
class IIR_DotAttribute;

/** The extension base for Dot attribute of quantities (Q'dot).  For a
    Quantity Q, the attribute Q'Dot yields a quantity of type as Q. */
class IIRScram_DotAttribute : public IIRBase_DotAttribute {

public:

  /** @name Method for publishing VHDL code. */
  void _publish_vhdl(ostream &);
  
  /** This returns an IIR_TextLiteral when a Dot attribute is
      instantiated. */
  IIR_TextLiteral *_build_attribute_name();
  
  /** Returns the type of the quantity. The implicit quantity is of the
      same type as the quantity Q.*/
  IIR_TypeDefinition *get_subtype();

  /** Returns a pointer to the implicit quantity created using
      build_free_quantity_declaration or
      build_branch_quantity_declaration. */
  IIR_Declaration *_get_implicit_declaration( const string & , 
					      IIR_TypeDefinition * );

  /** Uses the index assigned to each quantity and publishes the quantities
      present in the simultaneous statement. */
  void _publish_cc_ams_function(published_file &);
  
  /** Sets an index to equation node in the equation. */
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);

  /** Sets an index to each quantity in the equation. */
  void _set_stmt_qty_index(IIR_Int32 *, set<IIR_Declaration> *);
  
  /** Checks if a Q'dot is found in a Simultaneous Statement. If so, an
      implicit quantity has to be created.*/
  IIR_Boolean _differential_quantity_found();
  
  /** If one or more Q'dot is present in a Simultaneous Statement, a
      quantity of the same type as Q is implicitly created for each and all
      such quantities are appended to a list.*/
  void _build_differential_quantity_list(dl_list<IIR_DotAttribute>*);
  
protected:
  IIRScram_DotAttribute() {}
  virtual ~IIRScram_DotAttribute() = 0;
  
private:
  
};
#endif
