// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIR_Expression.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "published_file.hh"

IIRScram_Expression::~IIRScram_Expression() {}

void 
IIRScram_Expression::_publish_cc_bounds( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_Expression::_publish_cc_bounds" );

  ASSERT( get_subtype() != 0 );
  get_subtype()->_publish_cc_bounds( _cc_out );
}

void
IIRScram_Expression::_publish_cc_state_object_init( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_Expression::_publish_cc_state_object_init" );
  
  _cc_out << "new ";
  _cc_out << get_subtype()->_get_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << ")";
}

void
IIRScram_Expression::_publish_cc_elaborate( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_Expression::_publish_cc_elaborate" );
  
  _publish_cc_lvalue( _cc_out );
}

void 
IIRScram_Expression::_publish_cc_universal_value( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_Expression::_publish_cc_universal_value" );
  
  ASSERT(get_subtype() != NULL);
  _cc_out << "((";
  get_subtype()->_publish_cc_universal_type( _cc_out );
  _cc_out << "&) ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << ".readVal())";
}

void 
IIRScram_Expression::_publish_cc_value( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_Expression::_publish_cc_value" );
  _publish_cc_universal_value( _cc_out );
}

IIR_Boolean
IIRScram_Expression::_is_array_type(){
  ASSERT (get_subtype() != NULL);
  return get_subtype()->_is_array_type();
}

IIR *
IIRScram_Expression::_rval_to_decl( IIR_TypeDefinition *my_type ){
  set_subtype( my_type );
  ASSERT( _is_resolved() == TRUE );

  return this;
}


void
IIRScram_Expression::_clone( IIR *copy_into ){
  ASSERT( copy_into->_is_iir_expression() == TRUE );
  IIR_Expression *as_expression = (IIR_Expression *)copy_into;
  IIRScram::_clone( copy_into );
  // clone IIR_Expression info
  as_expression->set_subtype( get_subtype() );
}
