
#ifndef IIRSCRAM_FLOATING_TYPE_DEFINITION_HH
#define IIRSCRAM_FLOATING_TYPE_DEFINITION_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_FloatingTypeDefinition.hh"

class IIR_FloatingSubtypeDefinition;

class IIRScram_FloatingTypeDefinition : public IIRBase_FloatingTypeDefinition {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  IIR_Boolean _is_numeric_type() { return true; }
  IIR_Boolean _is_floating_type() { return true; }

  void _publish_cc_decl_cc( published_file &_cc_out );

  void _publish_cc_left( published_file &_cc_out );
  void _publish_cc_right( published_file &_cc_out );
  void _publish_cc_universal_type( published_file &_cc_out );
  const string _get_cc_kernel_type();

  virtual void _publish_cc_data_members( published_file &_cc_out );

  void _publish_cc_type_info( published_file &_cc_out );
  void _publish_cc_extern_type_info( published_file &_cc_out );
  void _publish_cc_type_string( published_file &_cc_out );

  IIR_TypeDefinition *_check_special_compatible( IIR_TypeDefinition * );

  IIR_TypeDefinition *_get_new_subtype();
  IIR *_clone();

  IIR_Boolean _is_iir_floating_type_definition(){ return TRUE; }
  
  void _set_resolution_function( IIR_FunctionDeclaration * );

  static IIR_FloatingSubtypeDefinition *_construct_new_type( IIR_RangeTypeDefinition *init_info,
							     IIR_TypeDeclaration *type_decl );

protected:
  
  IIRScram_FloatingTypeDefinition() {};
  virtual ~IIRScram_FloatingTypeDefinition() = 0;

  void _build_implicit_operators( set<IIR_Declaration> * );
    
private:
  

};

#endif
