// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_HighAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "error_func.hh"
#include "set.hh"
#include "sstream-wrap.hh"
#include "published_file.hh"

IIRScram_HighAttribute::~IIRScram_HighAttribute() {}

void 
IIRScram_HighAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  ASSERT(get_prefix()->_is_resolved() == TRUE);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'HIGH(";
  if(get_suffix() != NULL) {
    ASSERT(get_suffix()->_is_resolved() == TRUE);
    get_suffix()->_publish_vhdl(_vhdl_out);
  } else {
    _vhdl_out << "1";
  }
  _vhdl_out << ")";
}


void 
IIRScram_HighAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _publish_cc_type_attribute( _cc_out, "HIGH" );
}

IIR_TextLiteral *
IIRScram_HighAttribute::_build_attribute_name() {
  char *name = "high";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_HighAttribute::get_subtype(){
  return _get_subtype_high_low_left_right();
}

set<IIR_TypeDefinition> *
IIRScram_HighAttribute::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  return _get_rval_set_high_low_left_right( constraint_function );
}

IIR_Declaration *
IIRScram_HighAttribute::_get_implicit_declaration( const string &decl_name,
						   IIR_TypeDefinition *decl_type ){
  IIR_Declaration *retval;

  if( get_suffix() == NULL ){
    IIR_ConstantDeclaration *const_decl = _build_constant_declaration( decl_name, decl_type );

    ASSERT( decl_type->_is_scalar_type() == TRUE );
    IIR_ScalarTypeDefinition *as_scalar = (IIR_ScalarTypeDefinition *)decl_type;

    // If the direction is NULL, then this must be deteremined at runtime.  See
    // billowitch tc404.vhdl
    if( as_scalar->get_direction() != NULL ){
      if( as_scalar->_is_ascending_range() == TRUE ){
	const_decl->set_value( as_scalar->get_right() );
      }
      else{
	const_decl->set_value( as_scalar->get_left() );
      }
    }

    retval = const_decl;
  }
  else{
    retval = _build_function_declaration( decl_name, decl_type );
  }

  return retval;
}


void 
IIRScram_HighAttribute::_resolve_suffix_special(){
  _resolve_suffix_local_static_int();
}


IIR_Boolean 
IIRScram_HighAttribute::_is_value_attribute(){
  ASSERT( _is_resolved() == TRUE );
  if( get_prefix()->_is_scalar_type() == TRUE ){
    ASSERT( get_suffix() == NULL );
    return TRUE;
  }
  else{
    ASSERT( get_prefix()->_is_array_type() == TRUE );
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_HighAttribute::_is_function_attribute(){
  if( _is_value_attribute() == TRUE ){
    return FALSE;
  }
  else{
    return TRUE;
  }
}

void
IIRScram_HighAttribute::_publish_cc_type_cast( published_file &_cc_out ) {
  _cc_out << "(UniversalInteger &)";
}

IIR *
IIRScram_HighAttribute::_clone(){
  IIR_HighAttribute *retval = new IIR_HighAttribute();
  
  retval->set_prefix( get_prefix() );
  retval->set_suffix( get_suffix() );
  
  IIR_Attribute::_clone( retval );

  return retval;
}

visitor_return_type *IIRScram_HighAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_HighAttribute(this, arg);
};
