// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "IIR_IntegerLiteral.hh"
#include "IIR_FunctionDeclaration.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_IntegerSubtypeDefinition::~IIRScram_IntegerSubtypeDefinition() {}

void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_universal_value( published_file &_cc_out ) {
  _publish_cc_array_info( _cc_out );
}


void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_left( published_file &_cc_out ) {
  if (_is_anonymous()) {
    get_left()->_publish_cc_lvalue( _cc_out );
  }
  else {
    _cc_out << _get_cc_type_name();
    _cc_out << "::LEFT(";
    _publish_cc_object_type_info( _cc_out, false );
    _cc_out << ")";
  }    
}

void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_right( published_file &_cc_out ) {
  if (_is_anonymous()) {
    get_right()->_publish_cc_lvalue( _cc_out );
  }
  else {
    if (_is_kernel_type() == TRUE){
      _cc_out << _get_cc_type_name();
      _cc_out << "::RIGHT()";
    }
    else {
      if (get_left() != NULL && get_right() != NULL){
	_cc_out << "IntegerType::RIGHT(";
	if (_is_scalar_type() == TRUE) {
	  _publish_cc_object_type_info( _cc_out, false );
	}
      }
      _cc_out << ")";
    }
  }
}

void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_universal_type( published_file &_cc_out ) {
  _cc_out << "UniversalInteger";
}

IIR_Boolean
IIRScram_IntegerSubtypeDefinition::_is_subtype() {
  return TRUE;
}

void
IIRScram_IntegerSubtypeDefinition::_publish_cc_type_info( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_IntegerSubtypeDefinition::_publish_cc_type_info" );
  ASSERT (_is_scalar_type() == TRUE);

  if( _get_currently_publishing_unit() == PROCEDURE ||
      _get_currently_publishing_unit() == FUNCTION  ||
      _get_currently_publishing_unit() == PACKAGE_BODY ||
      _get_currently_publishing_unit() == PACKAGE_PUB ){
    _cc_out << "  IntegerTypeInfo ";
  }
  else {
    _cc_out << "  ";
  }
  
  _publish_cc_lvalue( _cc_out );
  _cc_out << "_info(";
  get_left()->_publish_cc_value( _cc_out );
  _cc_out << ", ";
  if(get_direction()->_is_ascending_range() == TRUE) {
    _cc_out << "ArrayInfo::to, ";
  }
  else {
    _cc_out << "ArrayInfo::downto, ";
  }
  get_right()->_publish_cc_value( _cc_out );
  _cc_out << ")";

  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB)) {
    _cc_out << ";\n  TypeInfo& get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "Info()";
    _cc_out << " {\n"
	    << "    return ";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;\n"
	    << "  }\n\n";
  }
}    

void
IIRScram_IntegerSubtypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_IntegerSubtypeDefinition::_publish_cc_extern_type_info" );
  ASSERT ( _is_scalar_type() == TRUE );
  
  if (_is_anonymous() == FALSE) {
    if ((_get_currently_publishing_unit() == PACKAGE_PUB) ||
	(_get_currently_publishing_unit() == PACKAGE_BODY)) {
      _cc_out << "  extern IntegerTypeInfo ";
      
    }
    else {
      _cc_out << "  IntegerTypeInfo ";
    }
    
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;\n";
    
    
    _cc_out << "  TypeInfo& get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "Info()";
    
    if ((_get_currently_publishing_unit() != PACKAGE_PUB) &&
	(_get_currently_publishing_unit() != PACKAGE_BODY)) {
      _cc_out << " const {\n"
	      << "    return (TypeInfo &) ";
      _publish_cc_lvalue( _cc_out );
      _cc_out << "_info;\n"
	      << "  }\n\n";
    }
    else {
      _cc_out << ";\n";
    }
  }
  else {
    ASSERT (_get_base_type() != NULL);
    if (_get_base_type()->_is_anonymous() == FALSE) {
      _get_base_type()->_publish_cc_extern_type_info( _cc_out );
    }
  }
}    

IIR *
IIRScram_IntegerSubtypeDefinition::_clone(){
  IIR_IntegerSubtypeDefinition *my_clone = new IIR_IntegerSubtypeDefinition();
  IIR_IntegerTypeDefinition::_clone( my_clone );
  my_clone->set_resolution_function( get_resolution_function() );
  return my_clone;
}

void 
IIRScram_IntegerSubtypeDefinition::_type_check(){
  if( get_resolution_function() != NULL ){
    get_resolution_function()->_type_check_resolution_function( this );
  }
  IIR_IntegerTypeDefinition::_type_check();
}

visitor_return_type *
IIRScram_IntegerSubtypeDefinition::_accept_visitor( node_visitor *visitor,
						    visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_IntegerSubtypeDefinition(this, arg);
};
