#ifndef IIRSCRAM_LIBRARY_UNIT_HH
#define IIRSCRAM_LIBRARY_UNIT_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_LibraryUnit.hh"
class IIR_EntityDeclaration;

class IIRScram_LibraryUnit : public IIRBase_LibraryUnit {

public:
  virtual void _publish_vhdl_binding_name(ostream &);
  virtual void _publish_vhdl_with_library_name(ostream &_vhdl_out);
  virtual IIR_EntityDeclaration* _get_entity();

  IIR_Boolean _is_iir_library_unit(){ return TRUE; }
  IIR_Boolean _is_homograph_of( IIR_Declaration * );

  virtual void _clone( IIR * );

  IIR_AttributeSpecificationList* _get_attribute_specification_list() { return &attributes; }

  /**
     Returns the library declaration that this unit is declared in.  Should
     never be NULL.  
  */
  IIR_LibraryDeclaration *_get_library();

  /**
     Returns the directory that this unit's library directory corresponds
     to.  Should never be NULL.
  */
  const string _get_library_directory();


  /** This method builds the main part of a file name for a "_decls"
      file.   */
  virtual void _publish_cc_include_decls_prefix( ostream &os ) = 0;

  /** The following function is used for code generation that does runtime
      elaboration.  This version is used for nodes that generate new
      files. */
  virtual void _publish_cc_elaborate();

  void _publish_cc_include( published_file &_cc_out );

  /** Publish an include that is sufficient for another file to include
      this unit's declarations in the generated code.  There is a
      default implementation here that can be explicitly called, even
      though this method is pure virtual. */
  virtual void _publish_cc_include_decls( published_file &_cc_out );

  /** Publish an include that is sufficient for another file to include
      this unit's elaboration headers in the generated code. There is a
      default implementation here that can be explicitly called, even
      though this method is pure virtual. */
  virtual void _publish_cc_include_elab( published_file &_cc_out );

  /**
     Library units generally publish their own files, and this is an entry
     point for the library unit list to call those functions.
  */
  virtual void _publish_cc( ) = 0;

  /**
     Library Units don't have subtypes.
  */
  IIR_TypeDefinition *get_subtype(){ return NULL; }

protected:
  IIRScram_LibraryUnit() {}
  virtual ~IIRScram_LibraryUnit() = 0;
  
private:
  
  /**
     A helper for the other _publish_cc_include methods.
   */
  virtual void _publish_cc_include( published_file &_cc_out, const char * const );

};
#endif

