
#ifndef IIRSCRAM_NATURE_DECLARATION_HH
#define IIRSCRAM_NATURE_DECLARATION_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.
  
// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Vinod Chamarty                    chamarv@ececs.uc.edu
//          Vasudevan Shanmugasundaram
//          Kathiresan Nellayappan
 
//---------------------------------------------------------------------------

#include "IIRBase_NatureDeclaration.hh"
class IIR_TerminalDeclaration;

class IIRScram_NatureDeclaration : public IIRBase_NatureDeclaration { 

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_cc_lvalue(published_file &);
  void _publish_cc_type_info(published_file &);  
  
  /** Returns the type of declaration - nature in this case */
  declaration_type _get_type();

  IIR_TypeDefinition *_get_rval();

  /** Returns the reference terminal */
  IIR_TerminalDeclaration *_get_reference_terminal();

  /** Set the reference terminal */
  void _set_reference_terminal(IIR_TerminalDeclaration*);

  /** Returns False if it is not array nature */
  //currently incomplete. until array natures are implemented.
  IIR_Boolean _is_array_type();

  /** Used to do some book keeping functions for different type of definitions */
  void _type_check();

  /** Returns the nature of the subtype */ 
  IIR_TypeDefinition *get_subtype();
  
  /** Returns the number of indexes in a array definition.
      Actually the function defined here makes a reference 
      to the _get_num_indexes() in the IIR_ArrayNatureDefinition class */
  IIR_Int32 _get_num_indexes();

  IIR_TypeDefinition *_get_final_subtype();

protected:
  IIRScram_NatureDeclaration();
  virtual ~IIRScram_NatureDeclaration() = 0;

private:
  IIR_TerminalDeclaration* reference_terminal;

};
#endif
