#ifndef IIRSCRAM_RECORD_TYPE_DEFINITION_HH
#define IIRSCRAM_RECORD_TYPE_DEFINITION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_RecordTypeDefinition.hh"
#include "set.hh"

class IIR_RecordTypeDefinition;

class IIRScram_RecordTypeDefinition : public IIRBase_RecordTypeDefinition {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_subtype_decl(ostream &);

  virtual IIR_Boolean _is_record_type() { return TRUE; }
  virtual IIR_Boolean _is_iir_record_type_definition() { return TRUE; }

  virtual IIR_Boolean _has_access_type();

  // This method returns the subtype of the "nth" element.
  IIR_TypeDefinition *_get_element_subtype( int );

  virtual IIR_Boolean _is_subtype();

  IIR_ElementDeclarationList *_get_element_declarations(){ return &element_declarations; }

  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  //The following methods needed for publishing 
  //the record types .hh and .cc files
  virtual const string _get_cc_kernel_type();
  virtual void _publish_cc_headers( published_file &_cc_out );

  virtual void _publish_cc_constructor_args( published_file &_cc_out );
  
  void _publish_cc_decl_type_attributes( published_file &_cc_out );
  void _publish_cc_necessary_decl_in_state( published_file &_cc_out );
  
  //The following methods needed for the initializations in _state.hh files
  void _publish_cc_init_signal( published_file &_cc_out );
  void _publish_cc_composite_init( published_file &_cc_out );

  void _publish_cc_init_fields_for_signals( published_file &_cc_out );

  void _publish_cc_universal_type( published_file &_cc_out );

  void  _publish_cc_element_objtypes( published_file &_cc_out );
  void  _publish_cc_element_objtypes_event( published_file &_cc_out );

  void _publish_cc_extern_type_info( published_file &_cc_out );
  void _publish_cc_constructor_args_type_info( published_file &_cc_out,
					       IIR *initializer );

  void _publish_cc_type_info( published_file &_cc_out, char* = NULL, char* = NULL );
  void _publish_cc_type_info( published_file &_cc_out );
  const string _get_cc_type_name( );

  int _get_field_number(IIR *);
  
  IIR_FunctionDeclaration* _get_resolution_function(){ return get_resolution_function(); }
  void _set_resolution_function(IIR_FunctionDeclaration *new_function ){
    set_resolution_function( new_function );
  }
  
  ostream &_print( ostream & );

  IIR_TypeDefinition *_get_new_subtype();

  IIR_ScalarTypeDefinition *_get_index_subtype();
  
  IIR_TypeDefinition *
  _construct_new_subtype( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );

  void _make_interface_visible( symbol_table * );

  virtual void _type_check();

  virtual IIR *_clone();
  virtual void _clone( IIR * );

  IIR_Boolean _is_locally_static();
  IIR_Boolean _is_globally_static();

  void _come_into_scope( symbol_table *, IIR_TypeDeclaration * );
  void _come_out_of_scope( symbol_table * );

protected:
  IIRScram_RecordTypeDefinition();
  virtual ~IIRScram_RecordTypeDefinition() = 0;
    
private:
};
#endif


