#ifndef PLUGIN_CLASS_FACTORY_HH
#define PLUGIN_CLASS_FACTORY_HH

// Copyright (c) 2003-2004 The University of Cincinnati.  
// All rights reserved.
// 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
// 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.
// 
// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
// 
// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
// 	    Dale E. Martin	dmartin@cliftonlabs.com
// 
// --------------------------------------------------------------------------

#include "IRKind.hh"

class IIR_AbsoluteOperator;
class IIR_AccessSubtypeDefinition;
class IIR_AccessTypeDefinition;
class IIR_AcrossAttribute;
class IIR_ActiveAttribute;
class IIR_AdditionOperator;
class IIR_Aggregate;
class IIR_AliasDeclaration;
class IIR_Allocator;
class IIR_AndOperator;
class IIR_ArchitectureDeclaration;
class IIR_ArchitectureStatement;
class IIR_ArchitectureStatementList;
class IIR_ArrayNatureDefinition;
class IIR_ArraySubnatureDefinition;
class IIR_ArraySubtypeDefinition;
class IIR_ArrayTypeDefinition;
class IIR_AscendingAttribute;
class IIR_AssertionStatement;
class IIR_AssociationElementByExpression;
class IIR_AssociationElementOpen;
class IIR_AssociationList;
class IIR_AttributeDeclaration;
class IIR_Attribute;
class IIR_AttributeSpecification;
class IIR_AttributeSpecificationList;
class IIR_BaseAttribute;
class IIR_BitStringLiteral;
class IIR_BlockConfiguration;
class IIR_BlockStatement;
class IIR_BranchQuantityDeclaration;
class IIR_BreakElement;
class IIR_BreakStatement;
class IIR_CaseStatementAlternativeByChoices;
class IIR_CaseStatementAlternativeByExpression;
class IIR_CaseStatementAlternativeByOthers;
class IIR_CaseStatementAlternativeList;
class IIR_CaseStatement;
class IIR_CharacterLiteral;
class IIR_Choice;
class IIR_ChoiceList;
class IIR_Comment;
class IIR_CommentList;
class IIR_ComponentConfiguration;
class IIR_ComponentDeclaration;
class IIR_ComponentInstantiationStatement;
class IIR_ConcatenationOperator;
class IIR_ConcurrentAssertionStatement;
class IIR_ConcurrentBreakStatement;
class IIR_ConcurrentConditionalSignalAssignment;
class IIR_ConcurrentGenerateForStatement;
class IIR_ConcurrentGenerateIfStatement;
class IIR_ConcurrentProcedureCallStatement;
class IIR_ConcurrentSelectedSignalAssignment;
class IIR_ConcurrentStatement;
class IIR_ConditionalWaveform;
class IIR_ConditionalWaveformList;
class IIR_ConfigurationDeclaration;
class IIR_ConfigurationItem;
class IIR_ConfigurationItemList;
class IIR_ConfigurationSpecification;
class IIR_ContributionAttribute;
class IIR_ConstantDeclaration;
class IIR_ConstantInterfaceDeclaration;
class IIR_Declaration;
class IIR_DeclarationList;
class IIR_DelayedAttribute;
class IIR_DesignatorByAll;
class IIR_DesignatorByOthers;
class IIR_DesignatorExplicit;
class IIR_Designator;
class IIR_DesignatorList;
class IIR_DesignFile;
class IIR_DesignFileList;
class IIR_DesignUnitList;
class IIR_DisconnectSpecification;
class IIR_DivisionOperator;
class IIR_DotAttribute;
class IIR_DrivingAttribute;
class IIR_DrivingValueAttribute;
class IIR_DyadicOperator;
class IIR_ElementDeclaration;
class IIR_ElementDeclarationList;
class IIR_Elsif;
class IIR_EntityClassEntry;
class IIR_EntityClassEntryList;
class IIR_EntityDeclaration;
class IIR_EntityNameList;
class IIR_EnumerationLiteral;
class IIR_EnumerationLiteralList;
class IIR_EnumerationSubtypeDefinition;
class IIR_EnumerationTypeDefinition;
class IIR_EqualityOperator;
class IIR_EventAttribute;
class IIR_ExitStatement;
class IIR_ExponentiationOperator;
class IIR_Expression;
class IIR_FileDeclaration;
class IIR_FileInterfaceDeclaration;
class IIR_FileTypeDefinition;
class IIR_FloatingPointLiteral32;
class IIR_FloatingPointLiteral64;
class IIR_FloatingPointLiteral;
class IIR_FloatingSubtypeDefinition;
class IIR_FloatingTypeDefinition;
class IIR_ForLoopStatement;
class IIR_FreeQuantityDeclaration;
class IIR_FunctionCall;
class IIR_FunctionDeclaration;
class IIR_GenericList;
class IIR_GreaterThanOperator;
class IIR_GreaterThanOrEqualOperator;
class IIR_GroupConstituent;
class IIR_GroupDeclaration;
class IIR_GroupTemplateDeclaration;
class IIR;
class IIR_HighAttribute;
class IIR_Identifier;
class IIR_IdentifierList;
class IIR_IdentityOperator;
class IIR_IfStatement;
class IIR_ImageAttribute;
class IIR_IncompleteTypeDefinition;
class IIR_IndexedName;
class IIR_InequalityOperator;
class IIR_InstanceNameAttribute;
class IIR_IntegerLiteral32;
class IIR_IntegerLiteral64;
class IIR_IntegerLiteral;
class IIR_IntegerSubtypeDefinition;
class IIR_IntegerTypeDefinition;
class IIR_InterfaceDeclaration;
class IIR_InterfaceList;
class IIR_Label;
class IIR_LastActiveAttribute;
class IIR_LastEventAttribute;
class IIR_LastValueAttribute;
class IIR_LeftAttribute;
class IIR_LeftOfAttribute;
class IIR_LengthAttribute;
class IIR_LessThanOperator;
class IIR_LessThanOrEqualOperator;
class IIR_LibraryClause;
class IIR_LibraryDeclaration;
class IIR_LibraryUnit;
class IIR_LibraryUnitList;
class IIR_List;
class IIR_Literal;
class IIR_LTFAttribute;
class IIR_LowAttribute;
class IIR_ModulusOperator;
class IIR_MonadicOperator;
class IIR_MultiplicationOperator;
class IIR_Name;
class IIR_NameList;
class IIR_NandOperator;
class IIR_NatureDeclaration;
class IIR_NatureDefinition;
class IIR_NegationOperator;
class IIR_NextStatement;
class IIR_NorOperator;
class IIR_NotOperator;
class IIR_NullStatement;
class IIR_ObjectDeclaration;
class IIR_OrOperator;
class IIR_OthersInitialization;
class IIR_PackageBodyDeclaration;
class IIR_PackageDeclaration;
class IIR_PathNameAttribute;
class IIR_PhysicalLiteral;
class IIR_PhysicalSubtypeDefinition;
class IIR_PhysicalTypeDefinition;
class IIR_PhysicalUnit;
class IIR_PortList;
class IIR_PosAttribute;
class IIR_PredAttribute;
class IIR_ProcedureCallStatement;
class IIR_ProcedureDeclaration;
class IIR_ProcessStatement;
class IIR_QualifiedExpression;
class IIR_QuantityDeclaration;
class IIR_QuietAttribute;
class IIR_RangeAttribute;
class IIR_RangeTypeDefinition;
class IIR_RecordTypeDefinition;
class IIR_ReferenceAttribute;
class IIR_RemainderOperator;
class IIR_ReportStatement;
class IIR_ReturnStatement;
class IIR_ReverseRangeAttribute;
class IIR_RightAttribute;
class IIR_RightOfAttribute;
class IIR_ROLOperator;
class IIR_ROROperator;
class IIR_ScalarNatureDefinition;
class IIR_ScalarTypeDefinition;
class IIR_SelectedNameByAll;
class IIR_SelectedName;
class IIR_SelectedWaveform;
class IIR_SelectedWaveformList;
class IIR_SensitizedProcessStatement;
class IIR_SequentialStatement;
class IIR_SequentialStatementList;
class IIR_SharedVariableDeclaration;
class IIR_SignalAssignmentStatement;
class IIR_SignalDeclaration;
class IIR_SignalInterfaceDeclaration;
class IIR_Signature;
class IIR_SimpleNameAttribute;
class IIR_SimpleName;
class IIR_SimpleSimultaneousStatement;
class IIR_SimultaneousElsif;
class IIR_SimultaneousIfStatement;
class IIR_SimultaneousStatement;
class IIR_SourceQuantityDeclaration;
class IIR_SLAOperator;
class IIR_SliceName;
class IIR_SLLOperator;
class IIR_SRAOperator;
class IIR_SRLOperator;
class IIR_StableAttribute;
class IIR_Statement;
class IIR_StringLiteral;
class IIR_SubprogramDeclaration;
class IIR_SubtractionOperator;
class IIR_SubtypeDeclaration;
class IIR_SuccAttribute;
class IIR_TerminalDeclaration;
class IIR_TerminalInterfaceDeclaration;
class IIR_TextLiteral;
class IIR_ThroughAttribute;
class IIR_TransactionAttribute;
class IIR_Tuple;
class IIR_TypeConversion;
class IIR_TypeDeclaration;
class IIR_TypeDefinition;
class IIR_UnitList;
class IIR_UseClause;
class IIR_UserAttribute;
class IIR_ValAttribute;
class IIR_ValueAttribute;
class IIR_VariableAssignmentStatement;
class IIR_VariableDeclaration;
class IIR_VariableInterfaceDeclaration;
class IIR_WaitStatement;
class IIR_WaveformElement;
class IIR_WaveformList;
class IIR_WhileLoopStatement;
class IIR_XnorOperator;
class IIR_XorOperator;
class IIR_ZTFAttribute;
class StandardPackage;

/** Interface version of the plugin class factory.  This provides an interface which is then implemented for
    each plugin, and allows the system to create AIRE node for that extension without knowing the specific details */
class plugin_class_factory {
public:
  /** Returns the standard package singleton for this plugin type. */
  virtual StandardPackage *get_standard_package() = 0;

  /** @name Create nodes
      Methods for creating specific nodes
  */
  //@{
  /** Returns the new class based on the passed in IIR_Kind type. */
  virtual IIR* get_new_class(IIR_Kind) = 0;

  virtual IIR_AbsoluteOperator                          *new_IIR_AbsoluteOperator() = 0;
  virtual IIR_AccessSubtypeDefinition                   *new_IIR_AccessSubtypeDefinition() = 0;
  virtual IIR_AccessTypeDefinition                      *new_IIR_AccessTypeDefinition() = 0;
  virtual IIR_AcrossAttribute                           *new_IIR_AcrossAttribute() = 0;
  virtual IIR_ActiveAttribute                           *new_IIR_ActiveAttribute() = 0;
  virtual IIR_AdditionOperator                          *new_IIR_AdditionOperator() = 0;
  virtual IIR_Aggregate                                 *new_IIR_Aggregate() = 0;
  virtual IIR_AliasDeclaration                          *new_IIR_AliasDeclaration() = 0;
  virtual IIR_Allocator                                 *new_IIR_Allocator() = 0;
  virtual IIR_AndOperator                               *new_IIR_AndOperator() = 0;
  virtual IIR_ArchitectureDeclaration                   *new_IIR_ArchitectureDeclaration() = 0;
  virtual IIR_ArchitectureStatement                     *new_IIR_ArchitectureStatement() = 0;
  virtual IIR_ArchitectureStatementList                 *new_IIR_ArchitectureStatementList() = 0;
  virtual IIR_ArrayNatureDefinition                     *new_IIR_ArrayNatureDefinition() = 0;
  virtual IIR_ArraySubnatureDefinition                  *new_IIR_ArraySubnatureDefinition() = 0;
  virtual IIR_ArraySubtypeDefinition                    *new_IIR_ArraySubtypeDefinition() = 0;
  virtual IIR_ArrayTypeDefinition                       *new_IIR_ArrayTypeDefinition() = 0;
  virtual IIR_AscendingAttribute                        *new_IIR_AscendingAttribute() = 0;
  virtual IIR_AssertionStatement                        *new_IIR_AssertionStatement() = 0;
  virtual IIR_AssociationElementByExpression            *new_IIR_AssociationElementByExpression() = 0;
  virtual IIR_AssociationElementOpen                    *new_IIR_AssociationElementOpen() = 0;
  virtual IIR_AssociationList                           *new_IIR_AssociationList() = 0;
  virtual IIR_AttributeDeclaration                      *new_IIR_AttributeDeclaration() = 0;
  virtual IIR_AttributeSpecification                    *new_IIR_AttributeSpecification() = 0;
  virtual IIR_AttributeSpecificationList                *new_IIR_AttributeSpecificationList() = 0;
  virtual IIR_BaseAttribute                             *new_IIR_BaseAttribute() = 0;
  virtual IIR_BitStringLiteral                          *new_IIR_BitStringLiteral() = 0;
  virtual IIR_BlockConfiguration                        *new_IIR_BlockConfiguration() = 0;
  virtual IIR_BlockStatement                            *new_IIR_BlockStatement() = 0;
  virtual IIR_BranchQuantityDeclaration                 *new_IIR_BranchQuantityDeclaration() = 0;
  virtual IIR_BreakElement                              *new_IIR_BreakElement() = 0;
  virtual IIR_BreakStatement                            *new_IIR_BreakStatement() = 0;
  virtual IIR_CaseStatementAlternativeByChoices         *new_IIR_CaseStatementAlternativeByChoices() = 0;
  virtual IIR_CaseStatementAlternativeByExpression      *new_IIR_CaseStatementAlternativeByExpression() = 0;
  virtual IIR_CaseStatementAlternativeByOthers          *new_IIR_CaseStatementAlternativeByOthers() = 0;
  virtual IIR_CaseStatementAlternativeList              *new_IIR_CaseStatementAlternativeList() = 0;
  virtual IIR_CaseStatement                             *new_IIR_CaseStatement() = 0;
  virtual IIR_CharacterLiteral                          *new_IIR_CharacterLiteral() = 0;
  virtual IIR_Choice                                    *new_IIR_Choice() = 0;
  virtual IIR_ChoiceList                                *new_IIR_ChoiceList() = 0;
  virtual IIR_Comment                                   *new_IIR_Comment() = 0;
  virtual IIR_CommentList                               *new_IIR_CommentList() = 0;
  virtual IIR_ComponentConfiguration                    *new_IIR_ComponentConfiguration() = 0;
  virtual IIR_ComponentDeclaration                      *new_IIR_ComponentDeclaration() = 0;
  virtual IIR_ComponentInstantiationStatement           *new_IIR_ComponentInstantiationStatement() = 0;
  virtual IIR_ConcatenationOperator                     *new_IIR_ConcatenationOperator() = 0;
  virtual IIR_ConcurrentAssertionStatement              *new_IIR_ConcurrentAssertionStatement() = 0;
  virtual IIR_ConcurrentBreakStatement                  *new_IIR_ConcurrentBreakStatement() = 0;
  virtual IIR_ConcurrentConditionalSignalAssignment     *new_IIR_ConcurrentConditionalSignalAssignment() = 0;
  virtual IIR_ConcurrentGenerateForStatement            *new_IIR_ConcurrentGenerateForStatement() = 0;
  virtual IIR_ConcurrentGenerateIfStatement             *new_IIR_ConcurrentGenerateIfStatement() = 0;
  virtual IIR_ConcurrentProcedureCallStatement          *new_IIR_ConcurrentProcedureCallStatement() = 0;
  virtual IIR_ConcurrentSelectedSignalAssignment        *new_IIR_ConcurrentSelectedSignalAssignment() = 0;
  virtual IIR_ConditionalWaveform                       *new_IIR_ConditionalWaveform() = 0;
  virtual IIR_ConditionalWaveformList                   *new_IIR_ConditionalWaveformList() = 0;
  virtual IIR_ConfigurationDeclaration                  *new_IIR_ConfigurationDeclaration() = 0;
  virtual IIR_ConfigurationItem                         *new_IIR_ConfigurationItem() = 0;
  virtual IIR_ConfigurationItemList                     *new_IIR_ConfigurationItemList() = 0;
  virtual IIR_ConfigurationSpecification                *new_IIR_ConfigurationSpecification() = 0;
  virtual IIR_ContributionAttribute                     *new_IIR_ContributionAttribute() = 0;
  virtual IIR_ConstantDeclaration                       *new_IIR_ConstantDeclaration() = 0;
  virtual IIR_ConstantInterfaceDeclaration              *new_IIR_ConstantInterfaceDeclaration() = 0;
  virtual IIR_DeclarationList                           *new_IIR_DeclarationList() = 0;
  virtual IIR_DelayedAttribute                          *new_IIR_DelayedAttribute() = 0;
  virtual IIR_DesignatorByAll                           *new_IIR_DesignatorByAll() = 0;
  virtual IIR_DesignatorByOthers                        *new_IIR_DesignatorByOthers() = 0;
  virtual IIR_DesignatorExplicit                        *new_IIR_DesignatorExplicit() = 0;
  virtual IIR_Designator                                *new_IIR_Designator() = 0;
  virtual IIR_DesignatorList                            *new_IIR_DesignatorList() = 0;
  virtual IIR_DesignFile                                *new_IIR_DesignFile() = 0;
  virtual IIR_DesignFileList                            *new_IIR_DesignFileList() = 0;
  virtual IIR_DesignUnitList                            *new_IIR_DesignUnitList() = 0;
  virtual IIR_DisconnectSpecification                   *new_IIR_DisconnectSpecification() = 0;
  virtual IIR_DivisionOperator                          *new_IIR_DivisionOperator() = 0;
  virtual IIR_DotAttribute                              *new_IIR_DotAttribute() = 0;
  virtual IIR_DrivingAttribute                          *new_IIR_DrivingAttribute() = 0;
  virtual IIR_DrivingValueAttribute                     *new_IIR_DrivingValueAttribute() = 0;
  virtual IIR_ElementDeclaration                        *new_IIR_ElementDeclaration() = 0;
  virtual IIR_ElementDeclarationList                    *new_IIR_ElementDeclarationList() = 0;
  virtual IIR_Elsif                                     *new_IIR_Elsif() = 0;
  virtual IIR_EntityClassEntry                          *new_IIR_EntityClassEntry() = 0;
  virtual IIR_EntityClassEntryList                      *new_IIR_EntityClassEntryList() = 0;
  virtual IIR_EntityDeclaration                         *new_IIR_EntityDeclaration() = 0;
  virtual IIR_EntityNameList                            *new_IIR_EntityNameList() = 0;
  virtual IIR_EnumerationLiteral                        *new_IIR_EnumerationLiteral() = 0;
  virtual IIR_EnumerationLiteralList                    *new_IIR_EnumerationLiteralList() = 0;
  virtual IIR_EnumerationSubtypeDefinition              *new_IIR_EnumerationSubtypeDefinition() = 0;
  virtual IIR_EnumerationTypeDefinition                 *new_IIR_EnumerationTypeDefinition() = 0;
  virtual IIR_EqualityOperator                          *new_IIR_EqualityOperator() = 0;
  virtual IIR_EventAttribute                            *new_IIR_EventAttribute() = 0;
  virtual IIR_ExitStatement                             *new_IIR_ExitStatement() = 0;
  virtual IIR_ExponentiationOperator                    *new_IIR_ExponentiationOperator() = 0;
  virtual IIR_FileDeclaration                           *new_IIR_FileDeclaration() = 0;
  virtual IIR_FileInterfaceDeclaration                  *new_IIR_FileInterfaceDeclaration() = 0;
  virtual IIR_FileTypeDefinition                        *new_IIR_FileTypeDefinition() = 0;
  virtual IIR_FloatingPointLiteral32                    *new_IIR_FloatingPointLiteral32() = 0;
  virtual IIR_FloatingPointLiteral64                    *new_IIR_FloatingPointLiteral64() = 0;
  virtual IIR_FloatingPointLiteral                      *new_IIR_FloatingPointLiteral() = 0;
  virtual IIR_FloatingSubtypeDefinition                 *new_IIR_FloatingSubtypeDefinition() = 0;
  virtual IIR_FloatingTypeDefinition                    *new_IIR_FloatingTypeDefinition() = 0;
  virtual IIR_ForLoopStatement                          *new_IIR_ForLoopStatement() = 0;
  virtual IIR_FreeQuantityDeclaration                   *new_IIR_FreeQuantityDeclaration() = 0;
  virtual IIR_FunctionCall                              *new_IIR_FunctionCall() = 0;
  virtual IIR_FunctionDeclaration                       *new_IIR_FunctionDeclaration() = 0;
  virtual IIR_GenericList                               *new_IIR_GenericList() = 0;
  virtual IIR_GreaterThanOperator                       *new_IIR_GreaterThanOperator() = 0;
  virtual IIR_GreaterThanOrEqualOperator                *new_IIR_GreaterThanOrEqualOperator() = 0;
  virtual IIR_GroupConstituent                          *new_IIR_GroupConstituent() = 0;
  virtual IIR_GroupDeclaration                          *new_IIR_GroupDeclaration() = 0;
  virtual IIR_GroupTemplateDeclaration                  *new_IIR_GroupTemplateDeclaration() = 0;
  virtual IIR_HighAttribute                             *new_IIR_HighAttribute() = 0;
  virtual IIR_Identifier                                *new_IIR_Identifier() = 0;
  virtual IIR_IdentifierList                            *new_IIR_IdentifierList() = 0;
  virtual IIR_IdentityOperator                          *new_IIR_IdentityOperator() = 0;
  virtual IIR_IfStatement                               *new_IIR_IfStatement() = 0;
  virtual IIR_ImageAttribute                            *new_IIR_ImageAttribute() = 0;
  virtual IIR_IncompleteTypeDefinition                  *new_IIR_IncompleteTypeDefinition() = 0;
  virtual IIR_IndexedName                               *new_IIR_IndexedName() = 0;
  virtual IIR_InequalityOperator                        *new_IIR_InequalityOperator() = 0;
  virtual IIR_InstanceNameAttribute                     *new_IIR_InstanceNameAttribute() = 0;
  virtual IIR_IntegerLiteral32                          *new_IIR_IntegerLiteral32() = 0;
  virtual IIR_IntegerLiteral64                          *new_IIR_IntegerLiteral64() = 0;
  virtual IIR_IntegerLiteral                            *new_IIR_IntegerLiteral() = 0;
  virtual IIR_IntegerSubtypeDefinition                  *new_IIR_IntegerSubtypeDefinition() = 0;
  virtual IIR_IntegerTypeDefinition                     *new_IIR_IntegerTypeDefinition() = 0;
  virtual IIR_InterfaceList                             *new_IIR_InterfaceList() = 0;
  virtual IIR_Label                                     *new_IIR_Label() = 0;
  virtual IIR_LastActiveAttribute                       *new_IIR_LastActiveAttribute() = 0;
  virtual IIR_LastEventAttribute                        *new_IIR_LastEventAttribute() = 0;
  virtual IIR_LastValueAttribute                        *new_IIR_LastValueAttribute() = 0;
  virtual IIR_LeftAttribute                             *new_IIR_LeftAttribute() = 0;
  virtual IIR_LeftOfAttribute                           *new_IIR_LeftOfAttribute() = 0;
  virtual IIR_LengthAttribute                           *new_IIR_LengthAttribute() = 0;
  virtual IIR_LessThanOperator                          *new_IIR_LessThanOperator() = 0;
  virtual IIR_LessThanOrEqualOperator                   *new_IIR_LessThanOrEqualOperator() = 0;
  virtual IIR_LibraryClause                             *new_IIR_LibraryClause() = 0;
  virtual IIR_LibraryDeclaration                        *new_IIR_LibraryDeclaration() = 0;
  virtual IIR_LibraryUnitList                           *new_IIR_LibraryUnitList() = 0;
  virtual IIR_Literal                                   *new_IIR_Literal() = 0;
  virtual IIR_LowAttribute                              *new_IIR_LowAttribute() = 0;
  virtual IIR_LTFAttribute                              *new_IIR_LTFAttribute() = 0;
  virtual IIR_ModulusOperator                           *new_IIR_ModulusOperator() = 0;
  virtual IIR_MultiplicationOperator                    *new_IIR_MultiplicationOperator() = 0;
  virtual IIR_Name                                      *new_IIR_Name() = 0;
  virtual IIR_NameList                                  *new_IIR_NameList() = 0;
  virtual IIR_NandOperator                              *new_IIR_NandOperator() = 0;
  virtual IIR_NatureDeclaration                         *new_IIR_NatureDeclaration() = 0;
  virtual IIR_NatureDefinition                          *new_IIR_NatureDefinition() = 0;
  virtual IIR_NegationOperator                          *new_IIR_NegationOperator() = 0;
  virtual IIR_NextStatement                             *new_IIR_NextStatement() = 0;
  virtual IIR_NorOperator                               *new_IIR_NorOperator() = 0;
  virtual IIR_NotOperator                               *new_IIR_NotOperator() = 0;
  virtual IIR_NullStatement                             *new_IIR_NullStatement() = 0;
  virtual IIR_OrOperator                                *new_IIR_OrOperator() = 0;
  virtual IIR_OthersInitialization                      *new_IIR_OthersInitialization() = 0;
  virtual IIR_PackageBodyDeclaration                    *new_IIR_PackageBodyDeclaration() = 0;
  virtual IIR_PackageDeclaration                        *new_IIR_PackageDeclaration() = 0;
  virtual IIR_PathNameAttribute                         *new_IIR_PathNameAttribute() = 0;
  virtual IIR_PhysicalLiteral                           *new_IIR_PhysicalLiteral() = 0;
  virtual IIR_PhysicalSubtypeDefinition                 *new_IIR_PhysicalSubtypeDefinition() = 0;
  virtual IIR_PhysicalTypeDefinition                    *new_IIR_PhysicalTypeDefinition() = 0;
  virtual IIR_PhysicalUnit                              *new_IIR_PhysicalUnit() = 0;
  virtual IIR_PortList                                  *new_IIR_PortList() = 0;
  virtual IIR_PosAttribute                              *new_IIR_PosAttribute() = 0;
  virtual IIR_PredAttribute                             *new_IIR_PredAttribute() = 0;
  virtual IIR_ProcedureCallStatement                    *new_IIR_ProcedureCallStatement() = 0;
  virtual IIR_ProcedureDeclaration                      *new_IIR_ProcedureDeclaration() = 0;
  virtual IIR_ProcessStatement                          *new_IIR_ProcessStatement() = 0;
  virtual IIR_QualifiedExpression                       *new_IIR_QualifiedExpression() = 0;
  virtual IIR_QuantityDeclaration                       *new_IIR_QuantityDeclaration() = 0;
  virtual IIR_QuietAttribute                            *new_IIR_QuietAttribute() = 0;
  virtual IIR_RangeAttribute                            *new_IIR_RangeAttribute() = 0;
  virtual IIR_RangeTypeDefinition                       *new_IIR_RangeTypeDefinition() = 0;
  virtual IIR_RecordTypeDefinition                      *new_IIR_RecordTypeDefinition() = 0;
  virtual IIR_ReferenceAttribute                        *new_IIR_ReferenceAttribute() = 0;
  virtual IIR_RemainderOperator                         *new_IIR_RemainderOperator() = 0;
  virtual IIR_ReportStatement                           *new_IIR_ReportStatement() = 0;
  virtual IIR_ReturnStatement                           *new_IIR_ReturnStatement() = 0;
  virtual IIR_ReverseRangeAttribute                     *new_IIR_ReverseRangeAttribute() = 0;
  virtual IIR_RightAttribute                            *new_IIR_RightAttribute() = 0;
  virtual IIR_RightOfAttribute                          *new_IIR_RightOfAttribute() = 0;
  virtual IIR_ROLOperator                               *new_IIR_ROLOperator() = 0;
  virtual IIR_ROROperator                               *new_IIR_ROROperator() = 0;
  virtual IIR_ScalarNatureDefinition                    *new_IIR_ScalarNatureDefinition() = 0;
  virtual IIR_SelectedNameByAll                         *new_IIR_SelectedNameByAll() = 0;
  virtual IIR_SelectedName                              *new_IIR_SelectedName() = 0;
  virtual IIR_SelectedWaveform                          *new_IIR_SelectedWaveform() = 0;
  virtual IIR_SelectedWaveformList                      *new_IIR_SelectedWaveformList() = 0;
  virtual IIR_SensitizedProcessStatement                *new_IIR_SensitizedProcessStatement() = 0;
  virtual IIR_SequentialStatementList                   *new_IIR_SequentialStatementList() = 0;
  virtual IIR_SharedVariableDeclaration                 *new_IIR_SharedVariableDeclaration() = 0;
  virtual IIR_SignalAssignmentStatement                 *new_IIR_SignalAssignmentStatement() = 0;
  virtual IIR_SignalDeclaration                         *new_IIR_SignalDeclaration() = 0;
  virtual IIR_SignalInterfaceDeclaration                *new_IIR_SignalInterfaceDeclaration() = 0;
  virtual IIR_Signature                                 *new_IIR_Signature() = 0;
  virtual IIR_SimpleNameAttribute                       *new_IIR_SimpleNameAttribute() = 0;
  virtual IIR_SimpleName                                *new_IIR_SimpleName() = 0;
  virtual IIR_SimpleSimultaneousStatement               *new_IIR_SimpleSimultaneousStatement() = 0;
  virtual IIR_SimultaneousElsif                         *new_IIR_SimultaneousElsif() = 0;
  virtual IIR_SimultaneousIfStatement                   *new_IIR_SimultaneousIfStatement() = 0;
  virtual IIR_SLAOperator                               *new_IIR_SLAOperator() = 0;
  virtual IIR_SliceName                                 *new_IIR_SliceName() = 0;
  virtual IIR_SLLOperator                               *new_IIR_SLLOperator() = 0;
  virtual IIR_SourceQuantityDeclaration                 *new_IIR_SourceQuantityDeclaration() = 0;
  virtual IIR_SRAOperator                               *new_IIR_SRAOperator() = 0;
  virtual IIR_SRLOperator                               *new_IIR_SRLOperator() = 0;
  virtual IIR_StableAttribute                           *new_IIR_StableAttribute() = 0;
  virtual IIR_StringLiteral                             *new_IIR_StringLiteral() = 0;
  virtual IIR_SubprogramDeclaration                     *new_IIR_SubprogramDeclaration() = 0;
  virtual IIR_SubtractionOperator                       *new_IIR_SubtractionOperator() = 0;
  virtual IIR_SubtypeDeclaration                        *new_IIR_SubtypeDeclaration() = 0;
  virtual IIR_SuccAttribute                             *new_IIR_SuccAttribute() = 0;
  virtual IIR_TerminalDeclaration                       *new_IIR_TerminalDeclaration() = 0;
  virtual IIR_TerminalInterfaceDeclaration              *new_IIR_TerminalInterfaceDeclaration() = 0;
  virtual IIR_TextLiteral                               *new_IIR_TextLiteral() = 0;
  virtual IIR_ThroughAttribute                          *new_IIR_ThroughAttribute() = 0;
  virtual IIR_TransactionAttribute                      *new_IIR_TransactionAttribute() = 0;
  virtual IIR_Tuple                                     *new_IIR_Tuple() = 0;
  virtual IIR_TypeConversion                            *new_IIR_TypeConversion() = 0;
  virtual IIR_TypeDeclaration                           *new_IIR_TypeDeclaration() = 0;
  virtual IIR_UnitList                                  *new_IIR_UnitList() = 0;
  virtual IIR_UseClause                                 *new_IIR_UseClause() = 0;
  virtual IIR_UserAttribute                             *new_IIR_UserAttribute() = 0;
  virtual IIR_ValAttribute                              *new_IIR_ValAttribute() = 0;
  virtual IIR_ValueAttribute                            *new_IIR_ValueAttribute() = 0;
  virtual IIR_VariableAssignmentStatement               *new_IIR_VariableAssignmentStatement() = 0;
  virtual IIR_VariableDeclaration                       *new_IIR_VariableDeclaration() = 0;
  virtual IIR_VariableInterfaceDeclaration              *new_IIR_VariableInterfaceDeclaration() = 0;
  virtual IIR_WaitStatement                             *new_IIR_WaitStatement() = 0;
  virtual IIR_WaveformElement                           *new_IIR_WaveformElement() = 0;
  virtual IIR_WaveformList                              *new_IIR_WaveformList() = 0;
  virtual IIR_WhileLoopStatement                        *new_IIR_WhileLoopStatement() = 0;
  virtual IIR_XnorOperator                              *new_IIR_XnorOperator() = 0;
  virtual IIR_XorOperator                               *new_IIR_XorOperator() = 0;
  virtual IIR_ZTFAttribute                              *new_IIR_ZTFAttribute() = 0;
  //@}
    
  virtual ~plugin_class_factory(){}

private:
  friend class IIRBase;
  /** When cloning the StandardPackage, we do really need to allocate a new
      one, and not just access a singleton.  This method allows for
      this. */
  virtual StandardPackage *new_StandardPackage() = 0; 
};
#endif
