(in-package "SB!IMPL")

(let ((ucs-to-eucjp-table (make-hash-table))
      (eucjp-to-ucs-table (make-hash-table)))
  (let ((ucs<->eucjp		 ; bi-directional table UCS <-> EUC-JP
	 ;; based on eucJP-ascii in
	 ;; <http://www.opengroup.or.jp/jvc/cde/appendix.html>
	 '((#x00A1 . #x8FA2C2)
	   (#x00A2 . #xA1F1)
	   (#x00A3 . #xA1F2)
	   (#x00A4 . #x8FA2F0)
	   (#x00A5 . #xA1EF)
	   (#x00A6 . #x8FA2C3)
	   (#x00A7 . #xA1F8)
	   (#x00A8 . #xA1AF)
	   (#x00A9 . #x8FA2ED)
	   (#x00AA . #x8FA2EC)
	   (#x00AC . #xA2CC)
	   (#x00AE . #x8FA2EE)
	   (#x00AF . #x8FA2B4)
	   (#x00B0 . #xA1EB)
	   (#x00B1 . #xA1DE)
	   (#x00B4 . #xA1AD)
	   (#x00B6 . #xA2F9)
	   (#x00B8 . #x8FA2B1)
	   (#x00BA . #x8FA2EB)
	   (#x00BF . #x8FA2C4)
	   (#x00C0 . #x8FAAA2)
	   (#x00C1 . #x8FAAA1)
	   (#x00C2 . #x8FAAA4)
	   (#x00C3 . #x8FAAAA)
	   (#x00C4 . #x8FAAA3)
	   (#x00C5 . #x8FAAA9)
	   (#x00C6 . #x8FA9A1)
	   (#x00C7 . #x8FAAAE)
	   (#x00C8 . #x8FAAB2)
	   (#x00C9 . #x8FAAB1)
	   (#x00CA . #x8FAAB4)
	   (#x00CB . #x8FAAB3)
	   (#x00CC . #x8FAAC0)
	   (#x00CD . #x8FAABF)
	   (#x00CE . #x8FAAC2)
	   (#x00CF . #x8FAAC1)
	   (#x00D1 . #x8FAAD0)
	   (#x00D2 . #x8FAAD2)
	   (#x00D3 . #x8FAAD1)
	   (#x00D4 . #x8FAAD4)
	   (#x00D5 . #x8FAAD8)
	   (#x00D6 . #x8FAAD3)
	   (#x00D7 . #xA1DF)
	   (#x00D8 . #x8FA9AC)
	   (#x00D9 . #x8FAAE3)
	   (#x00DA . #x8FAAE2)
	   (#x00DB . #x8FAAE5)
	   (#x00DC . #x8FAAE4)
	   (#x00DD . #x8FAAF2)
	   (#x00DE . #x8FA9B0)
	   (#x00DF . #x8FA9CE)
	   (#x00E0 . #x8FABA2)
	   (#x00E1 . #x8FABA1)
	   (#x00E2 . #x8FABA4)
	   (#x00E3 . #x8FABAA)
	   (#x00E4 . #x8FABA3)
	   (#x00E5 . #x8FABA9)
	   (#x00E6 . #x8FA9C1)
	   (#x00E7 . #x8FABAE)
	   (#x00E8 . #x8FABB2)
	   (#x00E9 . #x8FABB1)
	   (#x00EA . #x8FABB4)
	   (#x00EB . #x8FABB3)
	   (#x00EC . #x8FABC0)
	   (#x00ED . #x8FABBF)
	   (#x00EE . #x8FABC2)
	   (#x00EF . #x8FABC1)
	   (#x00F0 . #x8FA9C3)
	   (#x00F1 . #x8FABD0)
	   (#x00F2 . #x8FABD2)
	   (#x00F3 . #x8FABD1)
	   (#x00F4 . #x8FABD4)
	   (#x00F5 . #x8FABD8)
	   (#x00F6 . #x8FABD3)
	   (#x00F7 . #xA1E0)
	   (#x00F8 . #x8FA9CC)
	   (#x00F9 . #x8FABE3)
	   (#x00FA . #x8FABE2)
	   (#x00FB . #x8FABE5)
	   (#x00FC . #x8FABE4)
	   (#x00FD . #x8FABF2)
	   (#x00FE . #x8FA9D0)
	   (#x00FF . #x8FABF3)
	   (#x0100 . #x8FAAA7)
	   (#x0101 . #x8FABA7)
	   (#x0102 . #x8FAAA5)
	   (#x0103 . #x8FABA5)
	   (#x0104 . #x8FAAA8)
	   (#x0105 . #x8FABA8)
	   (#x0106 . #x8FAAAB)
	   (#x0107 . #x8FABAB)
	   (#x0108 . #x8FAAAC)
	   (#x0109 . #x8FABAC)
	   (#x010A . #x8FAAAF)
	   (#x010B . #x8FABAF)
	   (#x010C . #x8FAAAD)
	   (#x010D . #x8FABAD)
	   (#x010E . #x8FAAB0)
	   (#x010F . #x8FABB0)
	   (#x0110 . #x8FA9A2)
	   (#x0111 . #x8FA9C2)
	   (#x0112 . #x8FAAB7)
	   (#x0113 . #x8FABB7)
	   (#x0116 . #x8FAAB6)
	   (#x0117 . #x8FABB6)
	   (#x0118 . #x8FAAB8)
	   (#x0119 . #x8FABB8)
	   (#x011A . #x8FAAB5)
	   (#x011B . #x8FABB5)
	   (#x011C . #x8FAABA)
	   (#x011D . #x8FABBA)
	   (#x011E . #x8FAABB)
	   (#x011F . #x8FABBB)
	   (#x0120 . #x8FAABD)
	   (#x0121 . #x8FABBD)
	   (#x0122 . #x8FAABC)
	   (#x0124 . #x8FAABE)
	   (#x0125 . #x8FABBE)
	   (#x0126 . #x8FA9A4)
	   (#x0127 . #x8FA9C4)
	   (#x0128 . #x8FAAC7)
	   (#x0129 . #x8FABC7)
	   (#x012A . #x8FAAC5)
	   (#x012B . #x8FABC5)
	   (#x012E . #x8FAAC6)
	   (#x012F . #x8FABC6)
	   (#x0130 . #x8FAAC4)
	   (#x0131 . #x8FA9C5)
	   (#x0132 . #x8FA9A6)
	   (#x0133 . #x8FA9C6)
	   (#x0134 . #x8FAAC8)
	   (#x0135 . #x8FABC8)
	   (#x0136 . #x8FAAC9)
	   (#x0137 . #x8FABC9)
	   (#x0138 . #x8FA9C7)
	   (#x0139 . #x8FAACA)
	   (#x013A . #x8FABCA)
	   (#x013B . #x8FAACC)
	   (#x013C . #x8FABCC)
	   (#x013D . #x8FAACB)
	   (#x013E . #x8FABCB)
	   (#x013F . #x8FA9A9)
	   (#x0140 . #x8FA9C9)
	   (#x0141 . #x8FA9A8)
	   (#x0142 . #x8FA9C8)
	   (#x0143 . #x8FAACD)
	   (#x0144 . #x8FABCD)
	   (#x0145 . #x8FAACF)
	   (#x0146 . #x8FABCF)
	   (#x0147 . #x8FAACE)
	   (#x0148 . #x8FABCE)
	   (#x0149 . #x8FA9CA)
	   (#x014A . #x8FA9AB)
	   (#x014B . #x8FA9CB)
	   (#x014C . #x8FAAD7)
	   (#x014D . #x8FABD7)
	   (#x0150 . #x8FAAD6)
	   (#x0151 . #x8FABD6)
	   (#x0152 . #x8FA9AD)
	   (#x0153 . #x8FA9CD)
	   (#x0154 . #x8FAAD9)
	   (#x0155 . #x8FABD9)
	   (#x0156 . #x8FAADB)
	   (#x0157 . #x8FABDB)
	   (#x0158 . #x8FAADA)
	   (#x0159 . #x8FABDA)
	   (#x015A . #x8FAADC)
	   (#x015B . #x8FABDC)
	   (#x015C . #x8FAADD)
	   (#x015D . #x8FABDD)
	   (#x015E . #x8FAADF)
	   (#x015F . #x8FABDF)
	   (#x0160 . #x8FAADE)
	   (#x0161 . #x8FABDE)
	   (#x0162 . #x8FAAE1)
	   (#x0163 . #x8FABE1)
	   (#x0164 . #x8FAAE0)
	   (#x0165 . #x8FABE0)
	   (#x0166 . #x8FA9AF)
	   (#x0167 . #x8FA9CF)
	   (#x0168 . #x8FAAEC)
	   (#x0169 . #x8FABEC)
	   (#x016A . #x8FAAE9)
	   (#x016B . #x8FABE9)
	   (#x016C . #x8FAAE6)
	   (#x016D . #x8FABE6)
	   (#x016E . #x8FAAEB)
	   (#x016F . #x8FABEB)
	   (#x0170 . #x8FAAE8)
	   (#x0171 . #x8FABE8)
	   (#x0172 . #x8FAAEA)
	   (#x0173 . #x8FABEA)
	   (#x0174 . #x8FAAF1)
	   (#x0175 . #x8FABF1)
	   (#x0176 . #x8FAAF4)
	   (#x0177 . #x8FABF4)
	   (#x0178 . #x8FAAF3)
	   (#x0179 . #x8FAAF5)
	   (#x017A . #x8FABF5)
	   (#x017B . #x8FAAF7)
	   (#x017C . #x8FABF7)
	   (#x017D . #x8FAAF6)
	   (#x017E . #x8FABF6)
	   (#x01CD . #x8FAAA6)
	   (#x01CE . #x8FABA6)
	   (#x01CF . #x8FAAC3)
	   (#x01D0 . #x8FABC3)
	   (#x01D1 . #x8FAAD5)
	   (#x01D2 . #x8FABD5)
	   (#x01D3 . #x8FAAE7)
	   (#x01D4 . #x8FABE7)
	   (#x01D5 . #x8FAAF0)
	   (#x01D6 . #x8FABF0)
	   (#x01D7 . #x8FAAED)
	   (#x01D8 . #x8FABED)
	   (#x01D9 . #x8FAAEF)
	   (#x01DA . #x8FABEF)
	   (#x01DB . #x8FAAEE)
	   (#x01DC . #x8FABEE)
	   (#x01F5 . #x8FABB9)
	   (#x02C7 . #x8FA2B0)
	   (#x02D8 . #x8FA2AF)
	   (#x02D9 . #x8FA2B2)
	   (#x02DA . #x8FA2B6)
	   (#x02DB . #x8FA2B5)
	   (#x02DD . #x8FA2B3)
	   (#x0384 . #x8FA2B8)
	   (#x0385 . #x8FA2B9)
	   (#x0386 . #x8FA6E1)
	   (#x0388 . #x8FA6E2)
	   (#x0389 . #x8FA6E3)
	   (#x038A . #x8FA6E4)
	   (#x038C . #x8FA6E7)
	   (#x038E . #x8FA6E9)
	   (#x038F . #x8FA6EC)
	   (#x0390 . #x8FA6F6)
	   (#x0391 . #xA6A1)
	   (#x0392 . #xA6A2)
	   (#x0393 . #xA6A3)
	   (#x0394 . #xA6A4)
	   (#x0395 . #xA6A5)
	   (#x0396 . #xA6A6)
	   (#x0397 . #xA6A7)
	   (#x0398 . #xA6A8)
	   (#x0399 . #xA6A9)
	   (#x039A . #xA6AA)
	   (#x039B . #xA6AB)
	   (#x039C . #xA6AC)
	   (#x039D . #xA6AD)
	   (#x039E . #xA6AE)
	   (#x039F . #xA6AF)
	   (#x03A0 . #xA6B0)
	   (#x03A1 . #xA6B1)
	   (#x03A3 . #xA6B2)
	   (#x03A4 . #xA6B3)
	   (#x03A5 . #xA6B4)
	   (#x03A6 . #xA6B5)
	   (#x03A7 . #xA6B6)
	   (#x03A8 . #xA6B7)
	   (#x03A9 . #xA6B8)
	   (#x03AA . #x8FA6E5)
	   (#x03AB . #x8FA6EA)
	   (#x03AC . #x8FA6F1)
	   (#x03AD . #x8FA6F2)
	   (#x03AE . #x8FA6F3)
	   (#x03AF . #x8FA6F4)
	   (#x03B0 . #x8FA6FB)
	   (#x03B1 . #xA6C1)
	   (#x03B2 . #xA6C2)
	   (#x03B3 . #xA6C3)
	   (#x03B4 . #xA6C4)
	   (#x03B5 . #xA6C5)
	   (#x03B6 . #xA6C6)
	   (#x03B7 . #xA6C7)
	   (#x03B8 . #xA6C8)
	   (#x03B9 . #xA6C9)
	   (#x03BA . #xA6CA)
	   (#x03BB . #xA6CB)
	   (#x03BC . #xA6CC)
	   (#x03BD . #xA6CD)
	   (#x03BE . #xA6CE)
	   (#x03BF . #xA6CF)
	   (#x03C0 . #xA6D0)
	   (#x03C1 . #xA6D1)
	   (#x03C2 . #x8FA6F8)
	   (#x03C3 . #xA6D2)
	   (#x03C4 . #xA6D3)
	   (#x03C5 . #xA6D4)
	   (#x03C6 . #xA6D5)
	   (#x03C7 . #xA6D6)
	   (#x03C8 . #xA6D7)
	   (#x03C9 . #xA6D8)
	   (#x03CA . #x8FA6F5)
	   (#x03CB . #x8FA6FA)
	   (#x03CC . #x8FA6F7)
	   (#x03CD . #x8FA6F9)
	   (#x03CE . #x8FA6FC)
	   (#x0401 . #xA7A7)
	   (#x0402 . #x8FA7C2)
	   (#x0403 . #x8FA7C3)
	   (#x0404 . #x8FA7C4)
	   (#x0405 . #x8FA7C5)
	   (#x0406 . #x8FA7C6)
	   (#x0407 . #x8FA7C7)
	   (#x0408 . #x8FA7C8)
	   (#x0409 . #x8FA7C9)
	   (#x040A . #x8FA7CA)
	   (#x040B . #x8FA7CB)
	   (#x040C . #x8FA7CC)
	   (#x040E . #x8FA7CD)
	   (#x040F . #x8FA7CE)
	   (#x0410 . #xA7A1)
	   (#x0411 . #xA7A2)
	   (#x0412 . #xA7A3)
	   (#x0413 . #xA7A4)
	   (#x0414 . #xA7A5)
	   (#x0415 . #xA7A6)
	   (#x0416 . #xA7A8)
	   (#x0417 . #xA7A9)
	   (#x0418 . #xA7AA)
	   (#x0419 . #xA7AB)
	   (#x041A . #xA7AC)
	   (#x041B . #xA7AD)
	   (#x041C . #xA7AE)
	   (#x041D . #xA7AF)
	   (#x041E . #xA7B0)
	   (#x041F . #xA7B1)
	   (#x0420 . #xA7B2)
	   (#x0421 . #xA7B3)
	   (#x0422 . #xA7B4)
	   (#x0423 . #xA7B5)
	   (#x0424 . #xA7B6)
	   (#x0425 . #xA7B7)
	   (#x0426 . #xA7B8)
	   (#x0427 . #xA7B9)
	   (#x0428 . #xA7BA)
	   (#x0429 . #xA7BB)
	   (#x042A . #xA7BC)
	   (#x042B . #xA7BD)
	   (#x042C . #xA7BE)
	   (#x042D . #xA7BF)
	   (#x042E . #xA7C0)
	   (#x042F . #xA7C1)
	   (#x0430 . #xA7D1)
	   (#x0431 . #xA7D2)
	   (#x0432 . #xA7D3)
	   (#x0433 . #xA7D4)
	   (#x0434 . #xA7D5)
	   (#x0435 . #xA7D6)
	   (#x0436 . #xA7D8)
	   (#x0437 . #xA7D9)
	   (#x0438 . #xA7DA)
	   (#x0439 . #xA7DB)
	   (#x043A . #xA7DC)
	   (#x043B . #xA7DD)
	   (#x043C . #xA7DE)
	   (#x043D . #xA7DF)
	   (#x043E . #xA7E0)
	   (#x043F . #xA7E1)
	   (#x0440 . #xA7E2)
	   (#x0441 . #xA7E3)
	   (#x0442 . #xA7E4)
	   (#x0443 . #xA7E5)
	   (#x0444 . #xA7E6)
	   (#x0445 . #xA7E7)
	   (#x0446 . #xA7E8)
	   (#x0447 . #xA7E9)
	   (#x0448 . #xA7EA)
	   (#x0449 . #xA7EB)
	   (#x044A . #xA7EC)
	   (#x044B . #xA7ED)
	   (#x044C . #xA7EE)
	   (#x044D . #xA7EF)
	   (#x044E . #xA7F0)
	   (#x044F . #xA7F1)
	   (#x0451 . #xA7D7)
	   (#x0452 . #x8FA7F2)
	   (#x0453 . #x8FA7F3)
	   (#x0454 . #x8FA7F4)
	   (#x0455 . #x8FA7F5)
	   (#x0456 . #x8FA7F6)
	   (#x0457 . #x8FA7F7)
	   (#x0458 . #x8FA7F8)
	   (#x0459 . #x8FA7F9)
	   (#x045A . #x8FA7FA)
	   (#x045B . #x8FA7FB)
	   (#x045C . #x8FA7FC)
	   (#x045E . #x8FA7FD)
	   (#x045F . #x8FA7FE)
	   (#x2010 . #xA1BE)
	   (#x2014 . #xA1BD)
	   (#x2016 . #xA1C2)
	   (#x2018 . #xA1C6)
	   (#x2019 . #xA1C7)
	   (#x201C . #xA1C8)
	   (#x201D . #xA1C9)
	   (#x2020 . #xA2F7)
	   (#x2021 . #xA2F8)
	   (#x2025 . #xA1C5)
	   (#x2026 . #xA1C4)
	   (#x2030 . #xA2F3)
	   (#x2032 . #xA1EC)
	   (#x2033 . #xA1ED)
	   (#x203B . #xA2A8)
	   (#x203E . #xA1B1)
	   (#x2103 . #xA1EE)
	   (#x2116 . #x8FA2F1)
	   (#x2122 . #x8FA2EF)
	   (#x212B . #xA2F2)
	   (#x2190 . #xA2AB)
	   (#x2191 . #xA2AC)
	   (#x2192 . #xA2AA)
	   (#x2193 . #xA2AD)
	   (#x21D2 . #xA2CD)
	   (#x21D4 . #xA2CE)
	   (#x2200 . #xA2CF)
	   (#x2202 . #xA2DF)
	   (#x2203 . #xA2D0)
	   (#x2207 . #xA2E0)
	   (#x2208 . #xA2BA)
	   (#x220B . #xA2BB)
	   (#x2212 . #xA1DD)
	   (#x221A . #xA2E5)
	   (#x221D . #xA2E7)
	   (#x221E . #xA1E7)
	   (#x2220 . #xA2DC)
	   (#x2227 . #xA2CA)
	   (#x2228 . #xA2CB)
	   (#x2229 . #xA2C1)
	   (#x222A . #xA2C0)
	   (#x222B . #xA2E9)
	   (#x222C . #xA2EA)
	   (#x2234 . #xA1E8)
	   (#x2235 . #xA2E8)
	   (#x223D . #xA2E6)
	   (#x2252 . #xA2E2)
	   (#x2260 . #xA1E2)
	   (#x2261 . #xA2E1)
	   (#x2266 . #xA1E5)
	   (#x2267 . #xA1E6)
	   (#x226A . #xA2E3)
	   (#x226B . #xA2E4)
	   (#x2282 . #xA2BE)
	   (#x2283 . #xA2BF)
	   (#x2286 . #xA2BC)
	   (#x2287 . #xA2BD)
	   (#x22A5 . #xA2DD)
	   (#x2312 . #xA2DE)
	   (#x2500 . #xA8A1)
	   (#x2501 . #xA8AC)
	   (#x2502 . #xA8A2)
	   (#x2503 . #xA8AD)
	   (#x250C . #xA8A3)
	   (#x250F . #xA8AE)
	   (#x2510 . #xA8A4)
	   (#x2513 . #xA8AF)
	   (#x2514 . #xA8A6)
	   (#x2517 . #xA8B1)
	   (#x2518 . #xA8A5)
	   (#x251B . #xA8B0)
	   (#x251C . #xA8A7)
	   (#x251D . #xA8BC)
	   (#x2520 . #xA8B7)
	   (#x2523 . #xA8B2)
	   (#x2524 . #xA8A9)
	   (#x2525 . #xA8BE)
	   (#x2528 . #xA8B9)
	   (#x252B . #xA8B4)
	   (#x252C . #xA8A8)
	   (#x252F . #xA8B8)
	   (#x2530 . #xA8BD)
	   (#x2533 . #xA8B3)
	   (#x2534 . #xA8AA)
	   (#x2537 . #xA8BA)
	   (#x2538 . #xA8BF)
	   (#x253B . #xA8B5)
	   (#x253C . #xA8AB)
	   (#x253F . #xA8BB)
	   (#x2542 . #xA8C0)
	   (#x254B . #xA8B6)
	   (#x25A0 . #xA2A3)
	   (#x25A1 . #xA2A2)
	   (#x25B2 . #xA2A5)
	   (#x25B3 . #xA2A4)
	   (#x25BC . #xA2A7)
	   (#x25BD . #xA2A6)
	   (#x25C6 . #xA2A1)
	   (#x25C7 . #xA1FE)
	   (#x25CB . #xA1FB)
	   (#x25CE . #xA1FD)
	   (#x25CF . #xA1FC)
	   (#x25EF . #xA2FE)
	   (#x2605 . #xA1FA)
	   (#x2606 . #xA1F9)
	   (#x2640 . #xA1EA)
	   (#x2642 . #xA1E9)
	   (#x266A . #xA2F6)
	   (#x266D . #xA2F5)
	   (#x266F . #xA2F4)
	   (#x3000 . #xA1A1)
	   (#x3001 . #xA1A2)
	   (#x3002 . #xA1A3)
	   (#x3003 . #xA1B7)
	   (#x3005 . #xA1B9)
	   (#x3006 . #xA1BA)
	   (#x3007 . #xA1BB)
	   (#x3008 . #xA1D2)
	   (#x3009 . #xA1D3)
	   (#x300A . #xA1D4)
	   (#x300B . #xA1D5)
	   (#x300C . #xA1D6)
	   (#x300D . #xA1D7)
	   (#x300E . #xA1D8)
	   (#x300F . #xA1D9)
	   (#x3010 . #xA1DA)
	   (#x3011 . #xA1DB)
	   (#x3012 . #xA2A9)
	   (#x3013 . #xA2AE)
	   (#x3014 . #xA1CC)
	   (#x3015 . #xA1CD)
	   (#x301C . #xA1C1)
	   (#x3041 . #xA4A1)
	   (#x3042 . #xA4A2)
	   (#x3043 . #xA4A3)
	   (#x3044 . #xA4A4)
	   (#x3045 . #xA4A5)
	   (#x3046 . #xA4A6)
	   (#x3047 . #xA4A7)
	   (#x3048 . #xA4A8)
	   (#x3049 . #xA4A9)
	   (#x304A . #xA4AA)
	   (#x304B . #xA4AB)
	   (#x304C . #xA4AC)
	   (#x304D . #xA4AD)
	   (#x304E . #xA4AE)
	   (#x304F . #xA4AF)
	   (#x3050 . #xA4B0)
	   (#x3051 . #xA4B1)
	   (#x3052 . #xA4B2)
	   (#x3053 . #xA4B3)
	   (#x3054 . #xA4B4)
	   (#x3055 . #xA4B5)
	   (#x3056 . #xA4B6)
	   (#x3057 . #xA4B7)
	   (#x3058 . #xA4B8)
	   (#x3059 . #xA4B9)
	   (#x305A . #xA4BA)
	   (#x305B . #xA4BB)
	   (#x305C . #xA4BC)
	   (#x305D . #xA4BD)
	   (#x305E . #xA4BE)
	   (#x305F . #xA4BF)
	   (#x3060 . #xA4C0)
	   (#x3061 . #xA4C1)
	   (#x3062 . #xA4C2)
	   (#x3063 . #xA4C3)
	   (#x3064 . #xA4C4)
	   (#x3065 . #xA4C5)
	   (#x3066 . #xA4C6)
	   (#x3067 . #xA4C7)
	   (#x3068 . #xA4C8)
	   (#x3069 . #xA4C9)
	   (#x306A . #xA4CA)
	   (#x306B . #xA4CB)
	   (#x306C . #xA4CC)
	   (#x306D . #xA4CD)
	   (#x306E . #xA4CE)
	   (#x306F . #xA4CF)
	   (#x3070 . #xA4D0)
	   (#x3071 . #xA4D1)
	   (#x3072 . #xA4D2)
	   (#x3073 . #xA4D3)
	   (#x3074 . #xA4D4)
	   (#x3075 . #xA4D5)
	   (#x3076 . #xA4D6)
	   (#x3077 . #xA4D7)
	   (#x3078 . #xA4D8)
	   (#x3079 . #xA4D9)
	   (#x307A . #xA4DA)
	   (#x307B . #xA4DB)
	   (#x307C . #xA4DC)
	   (#x307D . #xA4DD)
	   (#x307E . #xA4DE)
	   (#x307F . #xA4DF)
	   (#x3080 . #xA4E0)
	   (#x3081 . #xA4E1)
	   (#x3082 . #xA4E2)
	   (#x3083 . #xA4E3)
	   (#x3084 . #xA4E4)
	   (#x3085 . #xA4E5)
	   (#x3086 . #xA4E6)
	   (#x3087 . #xA4E7)
	   (#x3088 . #xA4E8)
	   (#x3089 . #xA4E9)
	   (#x308A . #xA4EA)
	   (#x308B . #xA4EB)
	   (#x308C . #xA4EC)
	   (#x308D . #xA4ED)
	   (#x308E . #xA4EE)
	   (#x308F . #xA4EF)
	   (#x3090 . #xA4F0)
	   (#x3091 . #xA4F1)
	   (#x3092 . #xA4F2)
	   (#x3093 . #xA4F3)
	   (#x309B . #xA1AB)
	   (#x309C . #xA1AC)
	   (#x309D . #xA1B5)
	   (#x309E . #xA1B6)
	   (#x30A1 . #xA5A1)
	   (#x30A2 . #xA5A2)
	   (#x30A3 . #xA5A3)
	   (#x30A4 . #xA5A4)
	   (#x30A5 . #xA5A5)
	   (#x30A6 . #xA5A6)
	   (#x30A7 . #xA5A7)
	   (#x30A8 . #xA5A8)
	   (#x30A9 . #xA5A9)
	   (#x30AA . #xA5AA)
	   (#x30AB . #xA5AB)
	   (#x30AC . #xA5AC)
	   (#x30AD . #xA5AD)
	   (#x30AE . #xA5AE)
	   (#x30AF . #xA5AF)
	   (#x30B0 . #xA5B0)
	   (#x30B1 . #xA5B1)
	   (#x30B2 . #xA5B2)
	   (#x30B3 . #xA5B3)
	   (#x30B4 . #xA5B4)
	   (#x30B5 . #xA5B5)
	   (#x30B6 . #xA5B6)
	   (#x30B7 . #xA5B7)
	   (#x30B8 . #xA5B8)
	   (#x30B9 . #xA5B9)
	   (#x30BA . #xA5BA)
	   (#x30BB . #xA5BB)
	   (#x30BC . #xA5BC)
	   (#x30BD . #xA5BD)
	   (#x30BE . #xA5BE)
	   (#x30BF . #xA5BF)
	   (#x30C0 . #xA5C0)
	   (#x30C1 . #xA5C1)
	   (#x30C2 . #xA5C2)
	   (#x30C3 . #xA5C3)
	   (#x30C4 . #xA5C4)
	   (#x30C5 . #xA5C5)
	   (#x30C6 . #xA5C6)
	   (#x30C7 . #xA5C7)
	   (#x30C8 . #xA5C8)
	   (#x30C9 . #xA5C9)
	   (#x30CA . #xA5CA)
	   (#x30CB . #xA5CB)
	   (#x30CC . #xA5CC)
	   (#x30CD . #xA5CD)
	   (#x30CE . #xA5CE)
	   (#x30CF . #xA5CF)
	   (#x30D0 . #xA5D0)
	   (#x30D1 . #xA5D1)
	   (#x30D2 . #xA5D2)
	   (#x30D3 . #xA5D3)
	   (#x30D4 . #xA5D4)
	   (#x30D5 . #xA5D5)
	   (#x30D6 . #xA5D6)
	   (#x30D7 . #xA5D7)
	   (#x30D8 . #xA5D8)
	   (#x30D9 . #xA5D9)
	   (#x30DA . #xA5DA)
	   (#x30DB . #xA5DB)
	   (#x30DC . #xA5DC)
	   (#x30DD . #xA5DD)
	   (#x30DE . #xA5DE)
	   (#x30DF . #xA5DF)
	   (#x30E0 . #xA5E0)
	   (#x30E1 . #xA5E1)
	   (#x30E2 . #xA5E2)
	   (#x30E3 . #xA5E3)
	   (#x30E4 . #xA5E4)
	   (#x30E5 . #xA5E5)
	   (#x30E6 . #xA5E6)
	   (#x30E7 . #xA5E7)
	   (#x30E8 . #xA5E8)
	   (#x30E9 . #xA5E9)
	   (#x30EA . #xA5EA)
	   (#x30EB . #xA5EB)
	   (#x30EC . #xA5EC)
	   (#x30ED . #xA5ED)
	   (#x30EE . #xA5EE)
	   (#x30EF . #xA5EF)
	   (#x30F0 . #xA5F0)
	   (#x30F1 . #xA5F1)
	   (#x30F2 . #xA5F2)
	   (#x30F3 . #xA5F3)
	   (#x30F4 . #xA5F4)
	   (#x30F5 . #xA5F5)
	   (#x30F6 . #xA5F6)
	   (#x30FB . #xA1A6)
	   (#x30FC . #xA1BC)
	   (#x30FD . #xA1B3)
	   (#x30FE . #xA1B4)
	   (#x4E00 . #xB0EC)
	   (#x4E01 . #xC3FA)
	   (#x4E02 . #x8FB0A1)
	   (#x4E03 . #xBCB7)
	   (#x4E04 . #x8FB0A2)
	   (#x4E05 . #x8FB0A3)
	   (#x4E07 . #xCBFC)
	   (#x4E08 . #xBEE6)
	   (#x4E09 . #xBBB0)
	   (#x4E0A . #xBEE5)
	   (#x4E0B . #xB2BC)
	   (#x4E0C . #x8FB0A4)
	   (#x4E0D . #xC9D4)
	   (#x4E0E . #xCDBF)
	   (#x4E10 . #xD0A2)
	   (#x4E11 . #xB1AF)
	   (#x4E12 . #x8FB0A5)
	   (#x4E14 . #xB3EE)
	   (#x4E15 . #xD0A3)
	   (#x4E16 . #xC0A4)
	   (#x4E17 . #xD2C2)
	   (#x4E18 . #xB5D6)
	   (#x4E19 . #xCABA)
	   (#x4E1E . #xBEE7)
	   (#x4E1F . #x8FB0A6)
	   (#x4E21 . #xCEBE)
	   (#x4E23 . #x8FB0A7)
	   (#x4E24 . #x8FB0A8)
	   (#x4E26 . #xCAC2)
	   (#x4E28 . #x8FB0A9)
	   (#x4E2A . #xD0A4)
	   (#x4E2B . #x8FB0AA)
	   (#x4E2D . #xC3E6)
	   (#x4E2E . #x8FB0AB)
	   (#x4E2F . #x8FB0AC)
	   (#x4E30 . #x8FB0AD)
	   (#x4E31 . #xD0A5)
	   (#x4E32 . #xB6FA)
	   (#x4E35 . #x8FB0AE)
	   (#x4E36 . #xD0A6)
	   (#x4E38 . #xB4DD)
	   (#x4E39 . #xC3B0)
	   (#x4E3B . #xBCE7)
	   (#x4E3C . #xD0A7)
	   (#x4E3F . #xD0A8)
	   (#x4E40 . #x8FB0AF)
	   (#x4E41 . #x8FB0B0)
	   (#x4E42 . #xD0A9)
	   (#x4E43 . #xC7B5)
	   (#x4E44 . #x8FB0B1)
	   (#x4E45 . #xB5D7)
	   (#x4E47 . #x8FB0B2)
	   (#x4E4B . #xC7B7)
	   (#x4E4D . #xC6E3)
	   (#x4E4E . #xB8C3)
	   (#x4E4F . #xCBB3)
	   (#x4E51 . #x8FB0B3)
	   (#x4E55 . #xE9C9)
	   (#x4E56 . #xD0AA)
	   (#x4E57 . #xBEE8)
	   (#x4E58 . #xD0AB)
	   (#x4E59 . #xB2B5)
	   (#x4E5A . #x8FB0B4)
	   (#x4E5C . #x8FB0B5)
	   (#x4E5D . #xB6E5)
	   (#x4E5E . #xB8F0)
	   (#x4E5F . #xCCE9)
	   (#x4E62 . #xD6A6)
	   (#x4E63 . #x8FB0B6)
	   (#x4E68 . #x8FB0B7)
	   (#x4E69 . #x8FB0B8)
	   (#x4E71 . #xCDF0)
	   (#x4E73 . #xC6FD)
	   (#x4E74 . #x8FB0B9)
	   (#x4E75 . #x8FB0BA)
	   (#x4E79 . #x8FB0BB)
	   (#x4E7E . #xB4A5)
	   (#x4E7F . #x8FB0BC)
	   (#x4E80 . #xB5B5)
	   (#x4E82 . #xD0AC)
	   (#x4E85 . #xD0AD)
	   (#x4E86 . #xCEBB)
	   (#x4E88 . #xCDBD)
	   (#x4E89 . #xC1E8)
	   (#x4E8A . #xD0AF)
	   (#x4E8B . #xBBF6)
	   (#x4E8C . #xC6F3)
	   (#x4E8D . #x8FB0BD)
	   (#x4E8E . #xD0B2)
	   (#x4E91 . #xB1BE)
	   (#x4E92 . #xB8DF)
	   (#x4E94 . #xB8DE)
	   (#x4E95 . #xB0E6)
	   (#x4E96 . #x8FB0BE)
	   (#x4E97 . #x8FB0BF)
	   (#x4E98 . #xCFCB)
	   (#x4E99 . #xCFCA)
	   (#x4E9B . #xBAB3)
	   (#x4E9C . #xB0A1)
	   (#x4E9D . #x8FB0C0)
	   (#x4E9E . #xD0B3)
	   (#x4E9F . #xD0B4)
	   (#x4EA0 . #xD0B5)
	   (#x4EA1 . #xCBB4)
	   (#x4EA2 . #xD0B6)
	   (#x4EA4 . #xB8F2)
	   (#x4EA5 . #xB0E7)
	   (#x4EA6 . #xCBF2)
	   (#x4EA8 . #xB5FC)
	   (#x4EAB . #xB5FD)
	   (#x4EAC . #xB5FE)
	   (#x4EAD . #xC4E2)
	   (#x4EAE . #xCEBC)
	   (#x4EAF . #x8FB0C1)
	   (#x4EB0 . #xD0B7)
	   (#x4EB3 . #xD0B8)
	   (#x4EB6 . #xD0B9)
	   (#x4EB9 . #x8FB0C2)
	   (#x4EBA . #xBFCD)
	   (#x4EC0 . #xBDBA)
	   (#x4EC1 . #xBFCE)
	   (#x4EC2 . #xD0BE)
	   (#x4EC3 . #x8FB0C3)
	   (#x4EC4 . #xD0BC)
	   (#x4EC6 . #xD0BD)
	   (#x4EC7 . #xB5D8)
	   (#x4ECA . #xBAA3)
	   (#x4ECB . #xB2F0)
	   (#x4ECD . #xD0BB)
	   (#x4ECE . #xD0BA)
	   (#x4ECF . #xCAA9)
	   (#x4ED0 . #x8FB0C4)
	   (#x4ED4 . #xBBC6)
	   (#x4ED5 . #xBBC5)
	   (#x4ED6 . #xC2BE)
	   (#x4ED7 . #xD0BF)
	   (#x4ED8 . #xC9D5)
	   (#x4ED9 . #xC0E7)
	   (#x4EDA . #x8FB0C5)
	   (#x4EDB . #x8FB0C6)
	   (#x4EDD . #xA1B8)
	   (#x4EDE . #xD0C0)
	   (#x4EDF . #xD0C2)
	   (#x4EE0 . #x8FB0C7)
	   (#x4EE1 . #x8FB0C8)
	   (#x4EE2 . #x8FB0C9)
	   (#x4EE3 . #xC2E5)
	   (#x4EE4 . #xCEE1)
	   (#x4EE5 . #xB0CA)
	   (#x4EE8 . #x8FB0CA)
	   (#x4EED . #xD0C1)
	   (#x4EEE . #xB2BE)
	   (#x4EEF . #x8FB0CB)
	   (#x4EF0 . #xB6C4)
	   (#x4EF1 . #x8FB0CC)
	   (#x4EF2 . #xC3E7)
	   (#x4EF3 . #x8FB0CD)
	   (#x4EF5 . #x8FB0CE)
	   (#x4EF6 . #xB7EF)
	   (#x4EF7 . #xD0C3)
	   (#x4EFB . #xC7A4)
	   (#x4EFD . #x8FB0CF)
	   (#x4EFE . #x8FB0D0)
	   (#x4EFF . #x8FB0D1)
	   (#x4F00 . #x8FB0D2)
	   (#x4F01 . #xB4EB)
	   (#x4F02 . #x8FB0D3)
	   (#x4F03 . #x8FB0D4)
	   (#x4F08 . #x8FB0D5)
	   (#x4F09 . #xD0C4)
	   (#x4F0A . #xB0CB)
	   (#x4F0B . #x8FB0D6)
	   (#x4F0C . #x8FB0D7)
	   (#x4F0D . #xB8E0)
	   (#x4F0E . #xB4EC)
	   (#x4F0F . #xC9FA)
	   (#x4F10 . #xC8B2)
	   (#x4F11 . #xB5D9)
	   (#x4F12 . #x8FB0D8)
	   (#x4F15 . #x8FB0D9)
	   (#x4F16 . #x8FB0DA)
	   (#x4F17 . #x8FB0DB)
	   (#x4F19 . #x8FB0DC)
	   (#x4F1A . #xB2F1)
	   (#x4F1C . #xD0E7)
	   (#x4F1D . #xC5C1)
	   (#x4F2E . #x8FB0DD)
	   (#x4F2F . #xC7EC)
	   (#x4F30 . #xD0C6)
	   (#x4F31 . #x8FB0DE)
	   (#x4F33 . #x8FB0E0)
	   (#x4F34 . #xC8BC)
	   (#x4F35 . #x8FB0E1)
	   (#x4F36 . #xCEE2)
	   (#x4F37 . #x8FB0E2)
	   (#x4F38 . #xBFAD)
	   (#x4F39 . #x8FB0E3)
	   (#x4F3A . #xBBC7)
	   (#x4F3B . #x8FB0E4)
	   (#x4F3C . #xBBF7)
	   (#x4F3D . #xB2C0)
	   (#x4F3E . #x8FB0E5)
	   (#x4F40 . #x8FB0E6)
	   (#x4F42 . #x8FB0E7)
	   (#x4F43 . #xC4D1)
	   (#x4F46 . #xC3A2)
	   (#x4F47 . #xD0CA)
	   (#x4F48 . #x8FB0E8)
	   (#x4F49 . #x8FB0E9)
	   (#x4F4B . #x8FB0EA)
	   (#x4F4C . #x8FB0EB)
	   (#x4F4D . #xB0CC)
	   (#x4F4E . #xC4E3)
	   (#x4F4F . #xBDBB)
	   (#x4F50 . #xBAB4)
	   (#x4F51 . #xCDA4)
	   (#x4F52 . #x8FB0EC)
	   (#x4F53 . #xC2CE)
	   (#x4F54 . #x8FB0ED)
	   (#x4F55 . #xB2BF)
	   (#x4F56 . #x8FB0EE)
	   (#x4F57 . #xD0C9)
	   (#x4F58 . #x8FB0EF)
	   (#x4F59 . #xCDBE)
	   (#x4F5A . #xD0C5)
	   (#x4F5B . #xD0C7)
	   (#x4F5C . #xBAEE)
	   (#x4F5D . #xD0C8)
	   (#x4F5E . #xD5A4)
	   (#x4F5F . #x8FB0F0)
	   (#x4F60 . #x8FB0DF)
	   (#x4F63 . #x8FB0F1)
	   (#x4F69 . #xD0D0)
	   (#x4F6A . #x8FB0F2)
	   (#x4F6C . #x8FB0F3)
	   (#x4F6E . #x8FB0F4)
	   (#x4F6F . #xD0D3)
	   (#x4F70 . #xD0D1)
	   (#x4F71 . #x8FB0F5)
	   (#x4F73 . #xB2C2)
	   (#x4F75 . #xCABB)
	   (#x4F76 . #xD0CB)
	   (#x4F77 . #x8FB0F6)
	   (#x4F78 . #x8FB0F7)
	   (#x4F79 . #x8FB0F8)
	   (#x4F7A . #x8FB0F9)
	   (#x4F7B . #xD0CF)
	   (#x4F7C . #xB8F3)
	   (#x4F7D . #x8FB0FA)
	   (#x4F7E . #x8FB0FB)
	   (#x4F7F . #xBBC8)
	   (#x4F81 . #x8FB0FC)
	   (#x4F82 . #x8FB0FD)
	   (#x4F83 . #xB4A6)
	   (#x4F84 . #x8FB0FE)
	   (#x4F85 . #x8FB1A1)
	   (#x4F86 . #xD0D4)
	   (#x4F88 . #xD0CC)
	   (#x4F89 . #x8FB1A2)
	   (#x4F8A . #x8FB1A3)
	   (#x4F8B . #xCEE3)
	   (#x4F8C . #x8FB1A4)
	   (#x4F8D . #xBBF8)
	   (#x4F8E . #x8FB1A5)
	   (#x4F8F . #xD0CD)
	   (#x4F90 . #x8FB1A6)
	   (#x4F91 . #xD0D2)
	   (#x4F92 . #x8FB1A7)
	   (#x4F93 . #x8FB1A8)
	   (#x4F94 . #x8FB1A9)
	   (#x4F96 . #xD0D5)
	   (#x4F97 . #x8FB1AA)
	   (#x4F98 . #xD0CE)
	   (#x4F99 . #x8FB1AB)
	   (#x4F9A . #x8FB1AC)
	   (#x4F9B . #xB6A1)
	   (#x4F9D . #xB0CD)
	   (#x4F9E . #x8FB1AD)
	   (#x4F9F . #x8FB1AE)
	   (#x4FA0 . #xB6A2)
	   (#x4FA1 . #xB2C1)
	   (#x4FAB . #xD5A5)
	   (#x4FAD . #xCBF9)
	   (#x4FAE . #xC9EE)
	   (#x4FAF . #xB8F4)
	   (#x4FB2 . #x8FB1AF)
	   (#x4FB5 . #xBFAF)
	   (#x4FB6 . #xCEB7)
	   (#x4FB7 . #x8FB1B0)
	   (#x4FB9 . #x8FB1B1)
	   (#x4FBB . #x8FB1B2)
	   (#x4FBC . #x8FB1B3)
	   (#x4FBD . #x8FB1B4)
	   (#x4FBE . #x8FB1B5)
	   (#x4FBF . #xCAD8)
	   (#x4FC0 . #x8FB1B6)
	   (#x4FC1 . #x8FB1B7)
	   (#x4FC2 . #xB7B8)
	   (#x4FC3 . #xC2A5)
	   (#x4FC4 . #xB2E4)
	   (#x4FC5 . #x8FB1B8)
	   (#x4FC6 . #x8FB1B9)
	   (#x4FC8 . #x8FB1BA)
	   (#x4FC9 . #x8FB1BB)
	   (#x4FCA . #xBDD3)
	   (#x4FCB . #x8FB1BC)
	   (#x4FCC . #x8FB1BD)
	   (#x4FCD . #x8FB1BE)
	   (#x4FCE . #xD0D9)
	   (#x4FCF . #x8FB1BF)
	   (#x4FD0 . #xD0DE)
	   (#x4FD1 . #xD0DC)
	   (#x4FD2 . #x8FB1C0)
	   (#x4FD4 . #xD0D7)
	   (#x4FD7 . #xC2AF)
	   (#x4FD8 . #xD0DA)
	   (#x4FDA . #xD0DD)
	   (#x4FDB . #xD0DB)
	   (#x4FDC . #x8FB1C1)
	   (#x4FDD . #xCADD)
	   (#x4FDF . #xD0D8)
	   (#x4FE0 . #x8FB1C2)
	   (#x4FE1 . #xBFAE)
	   (#x4FE2 . #x8FB1C3)
	   (#x4FE3 . #xCBF3)
	   (#x4FE4 . #xD0DF)
	   (#x4FE5 . #xD0E0)
	   (#x4FEE . #xBDA4)
	   (#x4FEF . #xD0ED)
	   (#x4FF0 . #x8FB1C4)
	   (#x4FF2 . #x8FB1C5)
	   (#x4FF3 . #xC7D0)
	   (#x4FF5 . #xC9B6)
	   (#x4FF6 . #xD0E8)
	   (#x4FF8 . #xCAF0)
	   (#x4FFA . #xB2B6)
	   (#x4FFC . #x8FB1C6)
	   (#x4FFD . #x8FB1C7)
	   (#x4FFE . #xD0EC)
	   (#x4FFF . #x8FB1C8)
	   (#x5000 . #x8FB1C9)
	   (#x5001 . #x8FB1CA)
	   (#x5004 . #x8FB1CB)
	   (#x5005 . #xD0E6)
	   (#x5006 . #xD0EF)
	   (#x5007 . #x8FB1CC)
	   (#x5009 . #xC1D2)
	   (#x500A . #x8FB1CD)
	   (#x500B . #xB8C4)
	   (#x500C . #x8FB1CE)
	   (#x500D . #xC7DC)
	   (#x500E . #x8FB1CF)
	   (#x500F . #xE0C7)
	   (#x5010 . #x8FB1D0)
	   (#x5011 . #xD0EE)
	   (#x5012 . #xC5DD)
	   (#x5013 . #x8FB1D1)
	   (#x5014 . #xD0E3)
	   (#x5016 . #xB8F6)
	   (#x5017 . #x8FB1D2)
	   (#x5018 . #x8FB1D3)
	   (#x5019 . #xB8F5)
	   (#x501A . #xD0E1)
	   (#x501B . #x8FB1D4)
	   (#x501C . #x8FB1D5)
	   (#x501D . #x8FB1D6)
	   (#x501E . #x8FB1D7)
	   (#x501F . #xBCDA)
	   (#x5021 . #xD0E9)
	   (#x5022 . #x8FB1D8)
	   (#x5023 . #xCAEF)
	   (#x5024 . #xC3CD)
	   (#x5025 . #xD0E5)
	   (#x5026 . #xB7F1)
	   (#x5027 . #x8FB1D9)
	   (#x5028 . #xD0E2)
	   (#x5029 . #xD0EA)
	   (#x502A . #xD0E4)
	   (#x502B . #xCED1)
	   (#x502C . #xD0EB)
	   (#x502D . #xCFC1)
	   (#x502E . #x8FB1DA)
	   (#x5030 . #x8FB1DB)
	   (#x5032 . #x8FB1DC)
	   (#x5033 . #x8FB1DD)
	   (#x5035 . #x8FB1DE)
	   (#x5036 . #xB6E6)
	   (#x5039 . #xB7F0)
	   (#x503B . #x8FB1F6)
	   (#x5040 . #x8FB1DF)
	   (#x5041 . #x8FB1E0)
	   (#x5042 . #x8FB1E1)
	   (#x5043 . #xD0F0)
	   (#x5045 . #x8FB1E2)
	   (#x5046 . #x8FB1E3)
	   (#x5047 . #xD0F1)
	   (#x5048 . #xD0F5)
	   (#x5049 . #xB0CE)
	   (#x504A . #x8FB1E4)
	   (#x504C . #x8FB1E5)
	   (#x504E . #x8FB1E6)
	   (#x504F . #xCAD0)
	   (#x5050 . #xD0F4)
	   (#x5051 . #x8FB1E7)
	   (#x5052 . #x8FB1E8)
	   (#x5053 . #x8FB1E9)
	   (#x5055 . #xD0F3)
	   (#x5056 . #xD0F7)
	   (#x5057 . #x8FB1EA)
	   (#x5059 . #x8FB1EB)
	   (#x505A . #xD0F6)
	   (#x505C . #xC4E4)
	   (#x505F . #x8FB1EC)
	   (#x5060 . #x8FB1ED)
	   (#x5062 . #x8FB1EE)
	   (#x5063 . #x8FB1EF)
	   (#x5065 . #xB7F2)
	   (#x5066 . #x8FB1F0)
	   (#x5067 . #x8FB1F1)
	   (#x506A . #x8FB1F2)
	   (#x506C . #xD0F8)
	   (#x506D . #x8FB1F3)
	   (#x5070 . #x8FB1F4)
	   (#x5071 . #x8FB1F5)
	   (#x5072 . #xBCC5)
	   (#x5074 . #xC2A6)
	   (#x5075 . #xC4E5)
	   (#x5076 . #xB6F6)
	   (#x5078 . #xD0F9)
	   (#x507D . #xB5B6)
	   (#x5080 . #xD0FA)
	   (#x5081 . #x8FB1F7)
	   (#x5083 . #x8FB1F8)
	   (#x5084 . #x8FB1F9)
	   (#x5085 . #xD0FC)
	   (#x5086 . #x8FB1FA)
	   (#x508A . #x8FB1FB)
	   (#x508D . #xCBB5)
	   (#x508E . #x8FB1FC)
	   (#x508F . #x8FB1FD)
	   (#x5090 . #x8FB1FE)
	   (#x5091 . #xB7E6)
	   (#x5092 . #x8FB2A1)
	   (#x5093 . #x8FB2A2)
	   (#x5094 . #x8FB2A3)
	   (#x5096 . #x8FB2A4)
	   (#x5098 . #xBBB1)
	   (#x5099 . #xC8F7)
	   (#x509A . #xD0FB)
	   (#x509B . #x8FB2A5)
	   (#x509C . #x8FB2A6)
	   (#x509E . #x8FB2A7)
	   (#x509F . #x8FB2A8)
	   (#x50A0 . #x8FB2A9)
	   (#x50A1 . #x8FB2AA)
	   (#x50A2 . #x8FB2AB)
	   (#x50AA . #x8FB2AC)
	   (#x50AC . #xBAC5)
	   (#x50AD . #xCDC3)
	   (#x50AF . #x8FB2AD)
	   (#x50B0 . #x8FB2AE)
	   (#x50B2 . #xD0FE)
	   (#x50B3 . #xD1A3)
	   (#x50B4 . #xD0FD)
	   (#x50B5 . #xBAC4)
	   (#x50B7 . #xBDFD)
	   (#x50B9 . #x8FB2AF)
	   (#x50BA . #x8FB2B0)
	   (#x50BD . #x8FB2B1)
	   (#x50BE . #xB7B9)
	   (#x50C0 . #x8FB2B2)
	   (#x50C2 . #xD1A4)
	   (#x50C3 . #x8FB2B3)
	   (#x50C4 . #x8FB2B4)
	   (#x50C5 . #xB6CF)
	   (#x50C7 . #x8FB2B5)
	   (#x50C9 . #xD1A1)
	   (#x50CA . #xD1A2)
	   (#x50CC . #x8FB2B6)
	   (#x50CD . #xC6AF)
	   (#x50CE . #x8FB2B7)
	   (#x50CF . #xC1FC)
	   (#x50D0 . #x8FB2B8)
	   (#x50D1 . #xB6A3)
	   (#x50D3 . #x8FB2B9)
	   (#x50D4 . #x8FB2BA)
	   (#x50D5 . #xCBCD)
	   (#x50D6 . #xD1A5)
	   (#x50D8 . #x8FB2BB)
	   (#x50DA . #xCEBD)
	   (#x50DC . #x8FB2BC)
	   (#x50DD . #x8FB2BD)
	   (#x50DE . #xD1A6)
	   (#x50DF . #x8FB2BE)
	   (#x50E2 . #x8FB2BF)
	   (#x50E3 . #xD1A9)
	   (#x50E4 . #x8FB2C0)
	   (#x50E5 . #xD1A7)
	   (#x50E6 . #x8FB2C1)
	   (#x50E7 . #xC1CE)
	   (#x50E8 . #x8FB2C2)
	   (#x50E9 . #x8FB2C3)
	   (#x50ED . #xD1A8)
	   (#x50EE . #xD1AA)
	   (#x50EF . #x8FB2C4)
	   (#x50F1 . #x8FB2C5)
	   (#x50F2 . #x8FB2D1)
	   (#x50F5 . #xD1AC)
	   (#x50F6 . #x8FB2C6)
	   (#x50F9 . #xD1AB)
	   (#x50FA . #x8FB2C7)
	   (#x50FB . #xCAC8)
	   (#x50FE . #x8FB2C8)
	   (#x5100 . #xB5B7)
	   (#x5101 . #xD1AE)
	   (#x5102 . #xD1AF)
	   (#x5103 . #x8FB2C9)
	   (#x5104 . #xB2AF)
	   (#x5106 . #x8FB2CA)
	   (#x5107 . #x8FB2CB)
	   (#x5108 . #x8FB2CC)
	   (#x5109 . #xD1AD)
	   (#x510B . #x8FB2CD)
	   (#x510C . #x8FB2CE)
	   (#x510D . #x8FB2CF)
	   (#x510E . #x8FB2D0)
	   (#x5110 . #x8FB2D2)
	   (#x5112 . #xBCF4)
	   (#x5114 . #xD1B2)
	   (#x5115 . #xD1B1)
	   (#x5116 . #xD1B0)
	   (#x5117 . #x8FB2D3)
	   (#x5118 . #xD0D6)
	   (#x5119 . #x8FB2D4)
	   (#x511A . #xD1B3)
	   (#x511B . #x8FB2D5)
	   (#x511C . #x8FB2D6)
	   (#x511D . #x8FB2D7)
	   (#x511E . #x8FB2D8)
	   (#x511F . #xBDFE)
	   (#x5121 . #xD1B4)
	   (#x5123 . #x8FB2D9)
	   (#x5127 . #x8FB2DA)
	   (#x5128 . #x8FB2DB)
	   (#x512A . #xCDA5)
	   (#x512C . #x8FB2DC)
	   (#x512D . #x8FB2DD)
	   (#x512F . #x8FB2DE)
	   (#x5131 . #x8FB2DF)
	   (#x5132 . #xCCD9)
	   (#x5133 . #x8FB2E0)
	   (#x5134 . #x8FB2E1)
	   (#x5135 . #x8FB2E2)
	   (#x5137 . #xD1B6)
	   (#x5138 . #x8FB2E3)
	   (#x5139 . #x8FB2E4)
	   (#x513A . #xD1B5)
	   (#x513B . #xD1B8)
	   (#x513C . #xD1B7)
	   (#x513F . #xD1B9)
	   (#x5140 . #xD1BA)
	   (#x5141 . #xB0F4)
	   (#x5142 . #x8FB2E5)
	   (#x5143 . #xB8B5)
	   (#x5144 . #xB7BB)
	   (#x5145 . #xBDBC)
	   (#x5146 . #xC3FB)
	   (#x5147 . #xB6A4)
	   (#x5148 . #xC0E8)
	   (#x5149 . #xB8F7)
	   (#x514A . #x8FB2E6)
	   (#x514B . #xB9EE)
	   (#x514C . #xD1BC)
	   (#x514D . #xCCC8)
	   (#x514E . #xC5C6)
	   (#x514F . #x8FB2E7)
	   (#x5150 . #xBBF9)
	   (#x5152 . #xD1BB)
	   (#x5153 . #x8FB2E8)
	   (#x5154 . #xD1BD)
	   (#x5155 . #x8FB2E9)
	   (#x5157 . #x8FB2EA)
	   (#x5158 . #x8FB2EB)
	   (#x515A . #xC5DE)
	   (#x515C . #xB3F5)
	   (#x515F . #x8FB2EC)
	   (#x5162 . #xD1BE)
	   (#x5164 . #x8FB2ED)
	   (#x5165 . #xC6FE)
	   (#x5166 . #x8FB2EE)
	   (#x5168 . #xC1B4)
	   (#x5169 . #xD1C0)
	   (#x516A . #xD1C1)
	   (#x516B . #xC8AC)
	   (#x516C . #xB8F8)
	   (#x516D . #xCFBB)
	   (#x516E . #xD1C2)
	   (#x5171 . #xB6A6)
	   (#x5175 . #xCABC)
	   (#x5176 . #xC2B6)
	   (#x5177 . #xB6F1)
	   (#x5178 . #xC5B5)
	   (#x517C . #xB7F3)
	   (#x517E . #x8FB2EF)
	   (#x5180 . #xD1C3)
	   (#x5182 . #xD1C4)
	   (#x5183 . #x8FB2F0)
	   (#x5184 . #x8FB2F1)
	   (#x5185 . #xC6E2)
	   (#x5186 . #xB1DF)
	   (#x5189 . #xD1C7)
	   (#x518A . #xBAFD)
	   (#x518B . #x8FB2F2)
	   (#x518C . #xD1C6)
	   (#x518D . #xBAC6)
	   (#x518E . #x8FB2F3)
	   (#x518F . #xD1C8)
	   (#x5190 . #xE6EE)
	   (#x5191 . #xD1C9)
	   (#x5192 . #xCBC1)
	   (#x5193 . #xD1CA)
	   (#x5195 . #xD1CB)
	   (#x5196 . #xD1CC)
	   (#x5197 . #xBEE9)
	   (#x5198 . #x8FB2F4)
	   (#x5199 . #xBCCC)
	   (#x519D . #x8FB2F5)
	   (#x51A0 . #xB4A7)
	   (#x51A1 . #x8FB2F6)
	   (#x51A2 . #xD1CF)
	   (#x51A3 . #x8FB2F7)
	   (#x51A4 . #xD1CD)
	   (#x51A5 . #xCCBD)
	   (#x51A6 . #xD1CE)
	   (#x51A8 . #xC9DA)
	   (#x51A9 . #xD1D0)
	   (#x51AA . #xD1D1)
	   (#x51AB . #xD1D2)
	   (#x51AC . #xC5DF)
	   (#x51AD . #x8FB2F8)
	   (#x51B0 . #xD1D6)
	   (#x51B1 . #xD1D4)
	   (#x51B2 . #xD1D5)
	   (#x51B3 . #xD1D3)
	   (#x51B4 . #xBAE3)
	   (#x51B5 . #xD1D7)
	   (#x51B6 . #xCCEA)
	   (#x51B7 . #xCEE4)
	   (#x51B8 . #x8FB2F9)
	   (#x51BA . #x8FB2FA)
	   (#x51BC . #x8FB2FB)
	   (#x51BD . #xD1D8)
	   (#x51BE . #x8FB2FC)
	   (#x51BF . #x8FB2FD)
	   (#x51C2 . #x8FB2FE)
	   (#x51C4 . #xC0A8)
	   (#x51C5 . #xD1D9)
	   (#x51C6 . #xBDDA)
	   (#x51C8 . #x8FB3A1)
	   (#x51C9 . #xD1DA)
	   (#x51CB . #xC3FC)
	   (#x51CC . #xCEBF)
	   (#x51CD . #xC5E0)
	   (#x51CF . #x8FB3A2)
	   (#x51D1 . #x8FB3A3)
	   (#x51D2 . #x8FB3A4)
	   (#x51D3 . #x8FB3A5)
	   (#x51D5 . #x8FB3A6)
	   (#x51D6 . #xD2C5)
	   (#x51D8 . #x8FB3A7)
	   (#x51DB . #xD1DB)
	   (#x51DC . #xF4A5)
	   (#x51DD . #xB6C5)
	   (#x51DE . #x8FB3A8)
	   (#x51E0 . #xD1DC)
	   (#x51E1 . #xCBDE)
	   (#x51E2 . #x8FB3A9)
	   (#x51E5 . #x8FB3AA)
	   (#x51E6 . #xBDE8)
	   (#x51E7 . #xC2FC)
	   (#x51E9 . #xD1DE)
	   (#x51EA . #xC6E4)
	   (#x51ED . #xD1DF)
	   (#x51EE . #x8FB3AB)
	   (#x51F0 . #xD1E0)
	   (#x51F1 . #xB3AE)
	   (#x51F2 . #x8FB3AC)
	   (#x51F3 . #x8FB3AD)
	   (#x51F4 . #x8FB3AE)
	   (#x51F5 . #xD1E1)
	   (#x51F6 . #xB6A7)
	   (#x51F7 . #x8FB3AF)
	   (#x51F8 . #xC6CC)
	   (#x51F9 . #xB1FA)
	   (#x51FA . #xBDD0)
	   (#x51FD . #xC8A1)
	   (#x51FE . #xD1E2)
	   (#x5200 . #xC5E1)
	   (#x5201 . #x8FB3B0)
	   (#x5202 . #x8FB3B1)
	   (#x5203 . #xBFCF)
	   (#x5204 . #xD1E3)
	   (#x5205 . #x8FB3B2)
	   (#x5206 . #xCAAC)
	   (#x5207 . #xC0DA)
	   (#x5208 . #xB4A2)
	   (#x520A . #xB4A9)
	   (#x520B . #xD1E4)
	   (#x520E . #xD1E6)
	   (#x5211 . #xB7BA)
	   (#x5212 . #x8FB3B3)
	   (#x5213 . #x8FB3B4)
	   (#x5214 . #xD1E5)
	   (#x5215 . #x8FB3B5)
	   (#x5216 . #x8FB3B6)
	   (#x5217 . #xCEF3)
	   (#x5218 . #x8FB3B7)
	   (#x521D . #xBDE9)
	   (#x5222 . #x8FB3B8)
	   (#x5224 . #xC8BD)
	   (#x5225 . #xCACC)
	   (#x5227 . #xD1E7)
	   (#x5228 . #x8FB3B9)
	   (#x5229 . #xCDF8)
	   (#x522A . #xD1E8)
	   (#x522E . #xD1E9)
	   (#x5230 . #xC5FE)
	   (#x5231 . #x8FB3BA)
	   (#x5232 . #x8FB3BB)
	   (#x5233 . #xD1EA)
	   (#x5235 . #x8FB3BC)
	   (#x5236 . #xC0A9)
	   (#x5237 . #xBAFE)
	   (#x5238 . #xB7F4)
	   (#x5239 . #xD1EB)
	   (#x523A . #xBBC9)
	   (#x523B . #xB9EF)
	   (#x523C . #x8FB3BD)
	   (#x5243 . #xC4E6)
	   (#x5244 . #xD1ED)
	   (#x5245 . #x8FB3BE)
	   (#x5247 . #xC2A7)
	   (#x5249 . #x8FB3BF)
	   (#x524A . #xBAEF)
	   (#x524B . #xD1EE)
	   (#x524C . #xD1EF)
	   (#x524D . #xC1B0)
	   (#x524F . #xD1EC)
	   (#x5254 . #xD1F1)
	   (#x5255 . #x8FB3C0)
	   (#x5256 . #xCBB6)
	   (#x5257 . #x8FB3C1)
	   (#x5258 . #x8FB3C2)
	   (#x525A . #x8FB3C3)
	   (#x525B . #xB9E4)
	   (#x525C . #x8FB3C4)
	   (#x525E . #xD1F0)
	   (#x525F . #x8FB3C5)
	   (#x5260 . #x8FB3C6)
	   (#x5261 . #x8FB3C7)
	   (#x5263 . #xB7F5)
	   (#x5264 . #xBADE)
	   (#x5265 . #xC7ED)
	   (#x5266 . #x8FB3C8)
	   (#x5269 . #xD1F4)
	   (#x526A . #xD1F2)
	   (#x526E . #x8FB3C9)
	   (#x526F . #xC9FB)
	   (#x5270 . #xBEEA)
	   (#x5271 . #xD1FB)
	   (#x5272 . #xB3E4)
	   (#x5273 . #xD1F5)
	   (#x5274 . #xD1F3)
	   (#x5275 . #xC1CF)
	   (#x5277 . #x8FB3CA)
	   (#x5278 . #x8FB3CB)
	   (#x5279 . #x8FB3CC)
	   (#x527D . #xD1F7)
	   (#x527F . #xD1F6)
	   (#x5280 . #x8FB3CD)
	   (#x5282 . #x8FB3CE)
	   (#x5283 . #xB3C4)
	   (#x5285 . #x8FB3CF)
	   (#x5287 . #xB7E0)
	   (#x5288 . #xD1FC)
	   (#x5289 . #xCEAD)
	   (#x528A . #x8FB3D0)
	   (#x528C . #x8FB3D1)
	   (#x528D . #xD1F8)
	   (#x5291 . #xD1FD)
	   (#x5292 . #xD1FA)
	   (#x5293 . #x8FB3D2)
	   (#x5294 . #xD1F9)
	   (#x5295 . #x8FB3D3)
	   (#x5296 . #x8FB3D4)
	   (#x5297 . #x8FB3D5)
	   (#x5298 . #x8FB3D6)
	   (#x529A . #x8FB3D7)
	   (#x529B . #xCECF)
	   (#x529C . #x8FB3D8)
	   (#x529F . #xB8F9)
	   (#x52A0 . #xB2C3)
	   (#x52A3 . #xCEF4)
	   (#x52A4 . #x8FB3D9)
	   (#x52A5 . #x8FB3DA)
	   (#x52A6 . #x8FB3DB)
	   (#x52A7 . #x8FB3DC)
	   (#x52A9 . #xBDF5)
	   (#x52AA . #xC5D8)
	   (#x52AB . #xB9E5)
	   (#x52AC . #xD2A2)
	   (#x52AD . #xD2A3)
	   (#x52AF . #x8FB3DD)
	   (#x52B0 . #x8FB3DE)
	   (#x52B1 . #xCEE5)
	   (#x52B4 . #xCFAB)
	   (#x52B5 . #xD2A5)
	   (#x52B6 . #x8FB3DF)
	   (#x52B7 . #x8FB3E0)
	   (#x52B8 . #x8FB3E1)
	   (#x52B9 . #xB8FA)
	   (#x52BA . #x8FB3E2)
	   (#x52BB . #x8FB3E3)
	   (#x52BC . #xD2A4)
	   (#x52BD . #x8FB3E4)
	   (#x52BE . #xB3AF)
	   (#x52C0 . #x8FB3E5)
	   (#x52C1 . #xD2A6)
	   (#x52C3 . #xCBD6)
	   (#x52C4 . #x8FB3E6)
	   (#x52C5 . #xC4BC)
	   (#x52C6 . #x8FB3E7)
	   (#x52C7 . #xCDA6)
	   (#x52C8 . #x8FB3E8)
	   (#x52C9 . #xCAD9)
	   (#x52CC . #x8FB3E9)
	   (#x52CD . #xD2A7)
	   (#x52CF . #x8FB3EA)
	   (#x52D1 . #x8FB3EB)
	   (#x52D2 . #xF0D5)
	   (#x52D4 . #x8FB3EC)
	   (#x52D5 . #xC6B0)
	   (#x52D6 . #x8FB3ED)
	   (#x52D7 . #xD2A8)
	   (#x52D8 . #xB4AA)
	   (#x52D9 . #xCCB3)
	   (#x52DB . #x8FB3EE)
	   (#x52DC . #x8FB3EF)
	   (#x52DD . #xBEA1)
	   (#x52DE . #xD2A9)
	   (#x52DF . #xCAE7)
	   (#x52E0 . #xD2AD)
	   (#x52E1 . #x8FB3F0)
	   (#x52E2 . #xC0AA)
	   (#x52E3 . #xD2AA)
	   (#x52E4 . #xB6D0)
	   (#x52E5 . #x8FB3F1)
	   (#x52E6 . #xD2AB)
	   (#x52E7 . #xB4AB)
	   (#x52E8 . #x8FB3F2)
	   (#x52E9 . #x8FB3F3)
	   (#x52EA . #x8FB3F4)
	   (#x52EC . #x8FB3F5)
	   (#x52F0 . #x8FB3F6)
	   (#x52F1 . #x8FB3F7)
	   (#x52F2 . #xB7AE)
	   (#x52F3 . #xD2AE)
	   (#x52F4 . #x8FB3F8)
	   (#x52F5 . #xD2AF)
	   (#x52F6 . #x8FB3F9)
	   (#x52F7 . #x8FB3FA)
	   (#x52F8 . #xD2B0)
	   (#x52F9 . #xD2B1)
	   (#x52FA . #xBCDB)
	   (#x52FE . #xB8FB)
	   (#x52FF . #xCCDE)
	   (#x5300 . #x8FB3FB)
	   (#x5301 . #xCCE8)
	   (#x5302 . #xC6F7)
	   (#x5303 . #x8FB3FC)
	   (#x5305 . #xCAF1)
	   (#x5306 . #xD2B2)
	   (#x5308 . #xD2B3)
	   (#x530A . #x8FB3FD)
	   (#x530B . #x8FB3FE)
	   (#x530C . #x8FB4A1)
	   (#x530D . #xD2B5)
	   (#x530F . #xD2B7)
	   (#x5310 . #xD2B6)
	   (#x5311 . #x8FB4A2)
	   (#x5313 . #x8FB4A3)
	   (#x5315 . #xD2B8)
	   (#x5316 . #xB2BD)
	   (#x5317 . #xCBCC)
	   (#x5318 . #x8FB4A4)
	   (#x5319 . #xBAFC)
	   (#x531A . #xD2B9)
	   (#x531B . #x8FB4A5)
	   (#x531C . #x8FB4A6)
	   (#x531D . #xC1D9)
	   (#x531E . #x8FB4A7)
	   (#x531F . #x8FB4A8)
	   (#x5320 . #xBEA2)
	   (#x5321 . #xB6A9)
	   (#x5323 . #xD2BA)
	   (#x5325 . #x8FB4A9)
	   (#x5327 . #x8FB4AA)
	   (#x5328 . #x8FB4AB)
	   (#x5329 . #x8FB4AC)
	   (#x532A . #xC8DB)
	   (#x532B . #x8FB4AD)
	   (#x532C . #x8FB4AE)
	   (#x532D . #x8FB4AF)
	   (#x532F . #xD2BB)
	   (#x5330 . #x8FB4B0)
	   (#x5331 . #xD2BC)
	   (#x5332 . #x8FB4B1)
	   (#x5333 . #xD2BD)
	   (#x5335 . #x8FB4B2)
	   (#x5338 . #xD2BE)
	   (#x5339 . #xC9A4)
	   (#x533A . #xB6E8)
	   (#x533B . #xB0E5)
	   (#x533C . #x8FB4B3)
	   (#x533D . #x8FB4B4)
	   (#x533E . #x8FB4B5)
	   (#x533F . #xC6BF)
	   (#x5340 . #xD2BF)
	   (#x5341 . #xBDBD)
	   (#x5342 . #x8FB4B6)
	   (#x5343 . #xC0E9)
	   (#x5345 . #xD2C1)
	   (#x5346 . #xD2C0)
	   (#x5347 . #xBEA3)
	   (#x5348 . #xB8E1)
	   (#x5349 . #xD2C3)
	   (#x534A . #xC8BE)
	   (#x534B . #x8FB4B8)
	   (#x534C . #x8FB4B7)
	   (#x534D . #xD2C4)
	   (#x5351 . #xC8DC)
	   (#x5352 . #xC2B4)
	   (#x5353 . #xC2EE)
	   (#x5354 . #xB6A8)
	   (#x5357 . #xC6EE)
	   (#x5358 . #xC3B1)
	   (#x5359 . #x8FB4B9)
	   (#x535A . #xC7EE)
	   (#x535B . #x8FB4BA)
	   (#x535C . #xCBCE)
	   (#x535E . #xD2C6)
	   (#x5360 . #xC0EA)
	   (#x5361 . #x8FB4BB)
	   (#x5363 . #x8FB4BC)
	   (#x5365 . #x8FB4BD)
	   (#x5366 . #xB7B5)
	   (#x5369 . #xD2C7)
	   (#x536C . #x8FB4BE)
	   (#x536D . #x8FB4BF)
	   (#x536E . #xD2C8)
	   (#x536F . #xB1AC)
	   (#x5370 . #xB0F5)
	   (#x5371 . #xB4ED)
	   (#x5372 . #x8FB4C0)
	   (#x5373 . #xC2A8)
	   (#x5374 . #xB5D1)
	   (#x5375 . #xCDF1)
	   (#x5377 . #xD2CB)
	   (#x5378 . #xB2B7)
	   (#x5379 . #x8FB4C1)
	   (#x537B . #xD2CA)
	   (#x537E . #x8FB4C2)
	   (#x537F . #xB6AA)
	   (#x5382 . #xD2CC)
	   (#x5383 . #x8FB4C3)
	   (#x5384 . #xCCF1)
	   (#x5387 . #x8FB4C4)
	   (#x5388 . #x8FB4C5)
	   (#x538E . #x8FB4C6)
	   (#x5393 . #x8FB4C7)
	   (#x5394 . #x8FB4C8)
	   (#x5396 . #xD2CD)
	   (#x5398 . #xCED2)
	   (#x5399 . #x8FB4C9)
	   (#x539A . #xB8FC)
	   (#x539D . #x8FB4CA)
	   (#x539F . #xB8B6)
	   (#x53A0 . #xD2CE)
	   (#x53A1 . #x8FB4CB)
	   (#x53A4 . #x8FB4CC)
	   (#x53A5 . #xD2D0)
	   (#x53A6 . #xD2CF)
	   (#x53A8 . #xBFDF)
	   (#x53A9 . #xB1B9)
	   (#x53AA . #x8FB4CD)
	   (#x53AB . #x8FB4CE)
	   (#x53AD . #xB1DE)
	   (#x53AE . #xD2D1)
	   (#x53AF . #x8FB4CF)
	   (#x53B0 . #xD2D2)
	   (#x53B2 . #x8FB4D0)
	   (#x53B3 . #xB8B7)
	   (#x53B4 . #x8FB4D1)
	   (#x53B5 . #x8FB4D2)
	   (#x53B6 . #xD2D3)
	   (#x53B7 . #x8FB4D3)
	   (#x53B8 . #x8FB4D4)
	   (#x53BA . #x8FB4D5)
	   (#x53BB . #xB5EE)
	   (#x53BD . #x8FB4D6)
	   (#x53C0 . #x8FB4D7)
	   (#x53C2 . #xBBB2)
	   (#x53C3 . #xD2D4)
	   (#x53C5 . #x8FB4D8)
	   (#x53C8 . #xCBF4)
	   (#x53C9 . #xBAB5)
	   (#x53CA . #xB5DA)
	   (#x53CB . #xCDA7)
	   (#x53CC . #xC1D0)
	   (#x53CD . #xC8BF)
	   (#x53CE . #xBCFD)
	   (#x53CF . #x8FB4D9)
	   (#x53D2 . #x8FB4DA)
	   (#x53D3 . #x8FB4DB)
	   (#x53D4 . #xBDC7)
	   (#x53D5 . #x8FB4DC)
	   (#x53D6 . #xBCE8)
	   (#x53D7 . #xBCF5)
	   (#x53D9 . #xBDF6)
	   (#x53DA . #x8FB4DD)
	   (#x53DB . #xC8C0)
	   (#x53DD . #x8FB4DE)
	   (#x53DE . #x8FB4DF)
	   (#x53DF . #xD2D7)
	   (#x53E0 . #x8FB4E0)
	   (#x53E1 . #xB1C3)
	   (#x53E2 . #xC1D1)
	   (#x53E3 . #xB8FD)
	   (#x53E4 . #xB8C5)
	   (#x53E5 . #xB6E7)
	   (#x53E6 . #x8FB4E1)
	   (#x53E7 . #x8FB4E2)
	   (#x53E8 . #xD2DB)
	   (#x53E9 . #xC3A1)
	   (#x53EA . #xC2FE)
	   (#x53EB . #xB6AB)
	   (#x53EC . #xBEA4)
	   (#x53ED . #xD2DC)
	   (#x53EE . #xD2DA)
	   (#x53EF . #xB2C4)
	   (#x53F0 . #xC2E6)
	   (#x53F1 . #xBCB8)
	   (#x53F2 . #xBBCB)
	   (#x53F3 . #xB1A6)
	   (#x53F5 . #x8FB4E3)
	   (#x53F6 . #xB3F0)
	   (#x53F7 . #xB9E6)
	   (#x53F8 . #xBBCA)
	   (#x53FA . #xD2DD)
	   (#x5401 . #xD2DE)
	   (#x5402 . #x8FB4E4)
	   (#x5403 . #xB5C9)
	   (#x5404 . #xB3C6)
	   (#x5408 . #xB9E7)
	   (#x5409 . #xB5C8)
	   (#x540A . #xC4DF)
	   (#x540B . #xB1A5)
	   (#x540C . #xC6B1)
	   (#x540D . #xCCBE)
	   (#x540E . #xB9A1)
	   (#x540F . #xCDF9)
	   (#x5410 . #xC5C7)
	   (#x5411 . #xB8FE)
	   (#x5413 . #x8FB4E5)
	   (#x541A . #x8FB4E6)
	   (#x541B . #xB7AF)
	   (#x541D . #xD2E7)
	   (#x541F . #xB6E3)
	   (#x5420 . #xCBCA)
	   (#x5421 . #x8FB4E7)
	   (#x5426 . #xC8DD)
	   (#x5427 . #x8FB4E8)
	   (#x5428 . #x8FB4E9)
	   (#x5429 . #xD2E6)
	   (#x542A . #x8FB4EA)
	   (#x542B . #xB4DE)
	   (#x542C . #xD2E1)
	   (#x542D . #xD2E2)
	   (#x542E . #xD2E4)
	   (#x542F . #x8FB4EB)
	   (#x5431 . #x8FB4EC)
	   (#x5434 . #x8FB4ED)
	   (#x5435 . #x8FB4EE)
	   (#x5436 . #xD2E5)
	   (#x5438 . #xB5DB)
	   (#x5439 . #xBFE1)
	   (#x543B . #xCAAD)
	   (#x543C . #xD2E3)
	   (#x543D . #xD2DF)
	   (#x543E . #xB8E3)
	   (#x5440 . #xD2E0)
	   (#x5442 . #xCFA4)
	   (#x5443 . #x8FB4EF)
	   (#x5444 . #x8FB4F0)
	   (#x5446 . #xCAF2)
	   (#x5447 . #x8FB4F1)
	   (#x5448 . #xC4E8)
	   (#x5449 . #xB8E2)
	   (#x544A . #xB9F0)
	   (#x544D . #x8FB4F2)
	   (#x544E . #xD2E8)
	   (#x544F . #x8FB4F3)
	   (#x5451 . #xC6DD)
	   (#x545E . #x8FB4F4)
	   (#x545F . #xD2EC)
	   (#x5462 . #x8FB4F5)
	   (#x5464 . #x8FB4F6)
	   (#x5466 . #x8FB4F7)
	   (#x5467 . #x8FB4F8)
	   (#x5468 . #xBCFE)
	   (#x5469 . #x8FB4F9)
	   (#x546A . #xBCF6)
	   (#x546B . #x8FB4FA)
	   (#x546D . #x8FB4FB)
	   (#x546E . #x8FB4FC)
	   (#x5470 . #xD2EF)
	   (#x5471 . #xD2ED)
	   (#x5473 . #xCCA3)
	   (#x5474 . #x8FB4FD)
	   (#x5475 . #xD2EA)
	   (#x5476 . #xD2F3)
	   (#x5477 . #xD2EE)
	   (#x547B . #xD2F1)
	   (#x547C . #xB8C6)
	   (#x547D . #xCCBF)
	   (#x547F . #x8FB4FE)
	   (#x5480 . #xD2F2)
	   (#x5481 . #x8FB5A1)
	   (#x5483 . #x8FB5A2)
	   (#x5484 . #xD2F4)
	   (#x5485 . #x8FB5A3)
	   (#x5486 . #xD2F6)
	   (#x5488 . #x8FB5A4)
	   (#x5489 . #x8FB5A5)
	   (#x548B . #xBAF0)
	   (#x548C . #xCFC2)
	   (#x548D . #x8FB5A6)
	   (#x548E . #xD2EB)
	   (#x548F . #xD2E9)
	   (#x5490 . #xD2F5)
	   (#x5491 . #x8FB5A7)
	   (#x5492 . #xD2F0)
	   (#x5495 . #x8FB5A8)
	   (#x5496 . #x8FB5A9)
	   (#x549C . #x8FB5AA)
	   (#x549F . #x8FB5AB)
	   (#x54A1 . #x8FB5AC)
	   (#x54A2 . #xD2F8)
	   (#x54A4 . #xD3A3)
	   (#x54A5 . #xD2FA)
	   (#x54A6 . #x8FB5AD)
	   (#x54A7 . #x8FB5AE)
	   (#x54A8 . #xD2FE)
	   (#x54A9 . #x8FB5AF)
	   (#x54AA . #x8FB5B0)
	   (#x54AB . #xD3A1)
	   (#x54AC . #xD2FB)
	   (#x54AD . #x8FB5B1)
	   (#x54AE . #x8FB5B2)
	   (#x54AF . #xD3BE)
	   (#x54B1 . #x8FB5B3)
	   (#x54B2 . #xBAE9)
	   (#x54B3 . #xB3B1)
	   (#x54B7 . #x8FB5B4)
	   (#x54B8 . #xD2F9)
	   (#x54B9 . #x8FB5B5)
	   (#x54BA . #x8FB5B6)
	   (#x54BB . #x8FB5B7)
	   (#x54BC . #xD3A5)
	   (#x54BD . #xB0F6)
	   (#x54BE . #xD3A4)
	   (#x54BF . #x8FB5B8)
	   (#x54C0 . #xB0A5)
	   (#x54C1 . #xC9CA)
	   (#x54C2 . #xD3A2)
	   (#x54C4 . #xD2FC)
	   (#x54C6 . #x8FB5B9)
	   (#x54C7 . #xD2F7)
	   (#x54C8 . #xD2FD)
	   (#x54C9 . #xBAC8)
	   (#x54CA . #x8FB5BA)
	   (#x54CD . #x8FB5BB)
	   (#x54CE . #x8FB5BC)
	   (#x54D8 . #xD3A6)
	   (#x54E0 . #x8FB5BD)
	   (#x54E1 . #xB0F7)
	   (#x54E2 . #xD3AF)
	   (#x54E5 . #xD3A7)
	   (#x54E6 . #xD3A8)
	   (#x54E8 . #xBEA5)
	   (#x54E9 . #xCBE9)
	   (#x54EA . #x8FB5BE)
	   (#x54EC . #x8FB5BF)
	   (#x54ED . #xD3AD)
	   (#x54EE . #xD3AC)
	   (#x54EF . #x8FB5C0)
	   (#x54F2 . #xC5AF)
	   (#x54F6 . #x8FB5C1)
	   (#x54FA . #xD3AE)
	   (#x54FC . #x8FB5C2)
	   (#x54FD . #xD3AB)
	   (#x54FE . #x8FB5C3)
	   (#x54FF . #x8FB5C4)
	   (#x5500 . #x8FB5C5)
	   (#x5501 . #x8FB5C6)
	   (#x5504 . #xB1B4)
	   (#x5505 . #x8FB5C7)
	   (#x5506 . #xBAB6)
	   (#x5507 . #xBFB0)
	   (#x5508 . #x8FB5C8)
	   (#x5509 . #x8FB5C9)
	   (#x550C . #x8FB5CA)
	   (#x550D . #x8FB5CB)
	   (#x550E . #x8FB5CC)
	   (#x550F . #xD3A9)
	   (#x5510 . #xC5E2)
	   (#x5514 . #xD3AA)
	   (#x5515 . #x8FB5CD)
	   (#x5516 . #xB0A2)
	   (#x552A . #x8FB5CE)
	   (#x552B . #x8FB5CF)
	   (#x552E . #xD3B4)
	   (#x552F . #xCDA3)
	   (#x5531 . #xBEA7)
	   (#x5532 . #x8FB5D0)
	   (#x5533 . #xD3BA)
	   (#x5535 . #x8FB5D1)
	   (#x5536 . #x8FB5D2)
	   (#x5538 . #xD3B9)
	   (#x5539 . #xD3B0)
	   (#x553B . #x8FB5D3)
	   (#x553C . #x8FB5D4)
	   (#x553D . #x8FB5D5)
	   (#x553E . #xC2C3)
	   (#x5540 . #xD3B1)
	   (#x5541 . #x8FB5D6)
	   (#x5544 . #xC2EF)
	   (#x5545 . #xD3B6)
	   (#x5546 . #xBEA6)
	   (#x5547 . #x8FB5D7)
	   (#x5549 . #x8FB5D8)
	   (#x554A . #x8FB5D9)
	   (#x554C . #xD3B3)
	   (#x554D . #x8FB5DA)
	   (#x554F . #xCCE4)
	   (#x5550 . #x8FB5DB)
	   (#x5551 . #x8FB5DC)
	   (#x5553 . #xB7BC)
	   (#x5556 . #xD3B7)
	   (#x5557 . #xD3B8)
	   (#x5558 . #x8FB5DD)
	   (#x555A . #x8FB5DE)
	   (#x555B . #x8FB5DF)
	   (#x555C . #xD3B5)
	   (#x555D . #xD3BB)
	   (#x555E . #x8FB5E0)
	   (#x5560 . #x8FB5E1)
	   (#x5561 . #x8FB5E2)
	   (#x5563 . #xD3B2)
	   (#x5564 . #x8FB5E3)
	   (#x5566 . #x8FB5E4)
	   (#x557B . #xD3C1)
	   (#x557C . #xD3C6)
	   (#x557E . #xD3C2)
	   (#x557F . #x8FB5E5)
	   (#x5580 . #xD3BD)
	   (#x5581 . #x8FB5E6)
	   (#x5582 . #x8FB5E7)
	   (#x5583 . #xD3C7)
	   (#x5584 . #xC1B1)
	   (#x5586 . #x8FB5E8)
	   (#x5587 . #xD3C9)
	   (#x5588 . #x8FB5E9)
	   (#x5589 . #xB9A2)
	   (#x558A . #xD3BF)
	   (#x558B . #xC3FD)
	   (#x558E . #x8FB5EA)
	   (#x558F . #x8FB5EB)
	   (#x5591 . #x8FB5EC)
	   (#x5592 . #x8FB5ED)
	   (#x5593 . #x8FB5EE)
	   (#x5594 . #x8FB5EF)
	   (#x5597 . #x8FB5F0)
	   (#x5598 . #xD3C3)
	   (#x5599 . #xD3BC)
	   (#x559A . #xB4AD)
	   (#x559C . #xB4EE)
	   (#x559D . #xB3E5)
	   (#x559E . #xD3C4)
	   (#x559F . #xD3C0)
	   (#x55A3 . #x8FB5F1)
	   (#x55A4 . #x8FB5F2)
	   (#x55A7 . #xB7F6)
	   (#x55A8 . #xD3CA)
	   (#x55A9 . #xD3C8)
	   (#x55AA . #xC1D3)
	   (#x55AB . #xB5CA)
	   (#x55AC . #xB6AC)
	   (#x55AD . #x8FB5F3)
	   (#x55AE . #xD3C5)
	   (#x55B0 . #xB6F4)
	   (#x55B2 . #x8FB5F4)
	   (#x55B6 . #xB1C4)
	   (#x55BF . #x8FB5F5)
	   (#x55C1 . #x8FB5F6)
	   (#x55C3 . #x8FB5F7)
	   (#x55C4 . #xD3CE)
	   (#x55C5 . #xD3CC)
	   (#x55C6 . #x8FB5F8)
	   (#x55C7 . #xD4A7)
	   (#x55C9 . #x8FB5F9)
	   (#x55CB . #x8FB5FA)
	   (#x55CC . #x8FB5FB)
	   (#x55CE . #x8FB5FC)
	   (#x55D1 . #x8FB5FD)
	   (#x55D2 . #x8FB5FE)
	   (#x55D3 . #x8FB6A1)
	   (#x55D4 . #xD3D1)
	   (#x55D7 . #x8FB6A2)
	   (#x55D8 . #x8FB6A3)
	   (#x55DA . #xD3CB)
	   (#x55DB . #x8FB6A4)
	   (#x55DC . #xD3CF)
	   (#x55DE . #x8FB6A5)
	   (#x55DF . #xD3CD)
	   (#x55E2 . #x8FB6A6)
	   (#x55E3 . #xBBCC)
	   (#x55E4 . #xD3D0)
	   (#x55E9 . #x8FB6A7)
	   (#x55F6 . #x8FB6A8)
	   (#x55F7 . #xD3D3)
	   (#x55F9 . #xD3D8)
	   (#x55FD . #xD3D6)
	   (#x55FE . #xD3D5)
	   (#x55FF . #x8FB6A9)
	   (#x5605 . #x8FB6AA)
	   (#x5606 . #xC3B2)
	   (#x5608 . #x8FB6AB)
	   (#x5609 . #xB2C5)
	   (#x560A . #x8FB6AC)
	   (#x560D . #x8FB6AD)
	   (#x560E . #x8FB6AE)
	   (#x560F . #x8FB6AF)
	   (#x5610 . #x8FB6B0)
	   (#x5611 . #x8FB6B1)
	   (#x5612 . #x8FB6B2)
	   (#x5614 . #xD3D2)
	   (#x5616 . #xD3D4)
	   (#x5617 . #xBEA8)
	   (#x5618 . #xB1B3)
	   (#x5619 . #x8FB6B3)
	   (#x561B . #xD3D7)
	   (#x5629 . #xB2DE)
	   (#x562C . #x8FB6B4)
	   (#x562F . #xD3E2)
	   (#x5630 . #x8FB6B5)
	   (#x5631 . #xBEFC)
	   (#x5632 . #xD3DE)
	   (#x5633 . #x8FB6B6)
	   (#x5634 . #xD3DC)
	   (#x5635 . #x8FB6B7)
	   (#x5636 . #xD3DD)
	   (#x5637 . #x8FB6B8)
	   (#x5638 . #xD3DF)
	   (#x5639 . #x8FB6B9)
	   (#x563B . #x8FB6BA)
	   (#x563C . #x8FB6BB)
	   (#x563D . #x8FB6BC)
	   (#x563F . #x8FB6BD)
	   (#x5640 . #x8FB6BE)
	   (#x5641 . #x8FB6BF)
	   (#x5642 . #xB1BD)
	   (#x5643 . #x8FB6C0)
	   (#x5644 . #x8FB6C1)
	   (#x5646 . #x8FB6C2)
	   (#x5649 . #x8FB6C3)
	   (#x564B . #x8FB6C4)
	   (#x564C . #xC1B9)
	   (#x564D . #x8FB6C5)
	   (#x564E . #xD3D9)
	   (#x564F . #x8FB6C6)
	   (#x5650 . #xD3DA)
	   (#x5654 . #x8FB6C7)
	   (#x565B . #xB3FA)
	   (#x565E . #x8FB6C8)
	   (#x5660 . #x8FB6C9)
	   (#x5661 . #x8FB6CA)
	   (#x5662 . #x8FB6CB)
	   (#x5663 . #x8FB6CC)
	   (#x5664 . #xD3E1)
	   (#x5666 . #x8FB6CD)
	   (#x5668 . #xB4EF)
	   (#x5669 . #x8FB6CE)
	   (#x566A . #xD3E4)
	   (#x566B . #xD3E0)
	   (#x566C . #xD3E3)
	   (#x566D . #x8FB6CF)
	   (#x566F . #x8FB6D0)
	   (#x5671 . #x8FB6D1)
	   (#x5672 . #x8FB6D2)
	   (#x5674 . #xCAAE)
	   (#x5675 . #x8FB6D3)
	   (#x5678 . #xC6D5)
	   (#x567A . #xC8B8)
	   (#x5680 . #xD3E6)
	   (#x5684 . #x8FB6D4)
	   (#x5685 . #x8FB6D5)
	   (#x5686 . #xD3E5)
	   (#x5687 . #xB3C5)
	   (#x5688 . #x8FB6D6)
	   (#x568A . #xD3E7)
	   (#x568B . #x8FB6D7)
	   (#x568C . #x8FB6D8)
	   (#x568F . #xD3EA)
	   (#x5694 . #xD3E9)
	   (#x5695 . #x8FB6D9)
	   (#x5699 . #x8FB6DA)
	   (#x569A . #x8FB6DB)
	   (#x569D . #x8FB6DC)
	   (#x569E . #x8FB6DD)
	   (#x569F . #x8FB6DE)
	   (#x56A0 . #xD3E8)
	   (#x56A2 . #xC7B9)
	   (#x56A5 . #xD3EB)
	   (#x56A6 . #x8FB6DF)
	   (#x56A7 . #x8FB6E0)
	   (#x56A8 . #x8FB6E1)
	   (#x56A9 . #x8FB6E2)
	   (#x56AB . #x8FB6E3)
	   (#x56AC . #x8FB6E4)
	   (#x56AD . #x8FB6E5)
	   (#x56AE . #xD3EC)
	   (#x56B1 . #x8FB6E6)
	   (#x56B3 . #x8FB6E7)
	   (#x56B4 . #xD3EE)
	   (#x56B6 . #xD3ED)
	   (#x56B7 . #x8FB6E8)
	   (#x56BC . #xD3F0)
	   (#x56BE . #x8FB6E9)
	   (#x56C0 . #xD3F3)
	   (#x56C1 . #xD3F1)
	   (#x56C2 . #xD3EF)
	   (#x56C3 . #xD3F2)
	   (#x56C5 . #x8FB6EA)
	   (#x56C8 . #xD3F4)
	   (#x56C9 . #x8FB6EB)
	   (#x56CA . #x8FB6EC)
	   (#x56CB . #x8FB6ED)
	   (#x56CC . #x8FB6F0)
	   (#x56CD . #x8FB6F1)
	   (#x56CE . #xD3F5)
	   (#x56CF . #x8FB6EE)
	   (#x56D0 . #x8FB6EF)
	   (#x56D1 . #xD3F6)
	   (#x56D3 . #xD3F7)
	   (#x56D7 . #xD3F8)
	   (#x56D8 . #xD1C5)
	   (#x56D9 . #x8FB6F2)
	   (#x56DA . #xBCFC)
	   (#x56DB . #xBBCD)
	   (#x56DC . #x8FB6F3)
	   (#x56DD . #x8FB6F4)
	   (#x56DE . #xB2F3)
	   (#x56DF . #x8FB6F5)
	   (#x56E0 . #xB0F8)
	   (#x56E1 . #x8FB6F6)
	   (#x56E3 . #xC3C4)
	   (#x56E4 . #x8FB6F7)
	   (#x56E5 . #x8FB6F8)
	   (#x56E6 . #x8FB6F9)
	   (#x56E7 . #x8FB6FA)
	   (#x56E8 . #x8FB6FB)
	   (#x56EB . #x8FB6FD)
	   (#x56ED . #x8FB6FE)
	   (#x56EE . #xD3F9)
	   (#x56F0 . #xBAA4)
	   (#x56F1 . #x8FB6FC)
	   (#x56F2 . #xB0CF)
	   (#x56F3 . #xBFDE)
	   (#x56F6 . #x8FB7A1)
	   (#x56F7 . #x8FB7A2)
	   (#x56F9 . #xD3FA)
	   (#x56FA . #xB8C7)
	   (#x56FD . #xB9F1)
	   (#x56FF . #xD3FC)
	   (#x5700 . #xD3FB)
	   (#x5701 . #x8FB7A3)
	   (#x5702 . #x8FB7A4)
	   (#x5703 . #xCAE0)
	   (#x5704 . #xD3FD)
	   (#x5707 . #x8FB7A5)
	   (#x5708 . #xD4A1)
	   (#x5709 . #xD3FE)
	   (#x570A . #x8FB7A6)
	   (#x570B . #xD4A2)
	   (#x570C . #x8FB7A7)
	   (#x570D . #xD4A3)
	   (#x570F . #xB7F7)
	   (#x5711 . #x8FB7A8)
	   (#x5712 . #xB1E0)
	   (#x5713 . #xD4A4)
	   (#x5715 . #x8FB7A9)
	   (#x5716 . #xD4A6)
	   (#x5718 . #xD4A5)
	   (#x571A . #x8FB7AA)
	   (#x571B . #x8FB7AB)
	   (#x571C . #xD4A8)
	   (#x571D . #x8FB7AC)
	   (#x571F . #xC5DA)
	   (#x5720 . #x8FB7AD)
	   (#x5722 . #x8FB7AE)
	   (#x5723 . #x8FB7AF)
	   (#x5724 . #x8FB7B0)
	   (#x5725 . #x8FB7B1)
	   (#x5726 . #xD4A9)
	   (#x5727 . #xB0B5)
	   (#x5728 . #xBADF)
	   (#x5729 . #x8FB7B2)
	   (#x572A . #x8FB7B3)
	   (#x572C . #x8FB7B4)
	   (#x572D . #xB7BD)
	   (#x572E . #x8FB7B5)
	   (#x572F . #x8FB7B6)
	   (#x5730 . #xC3CF)
	   (#x5733 . #x8FB7B7)
	   (#x5734 . #x8FB7B8)
	   (#x5737 . #xD4AA)
	   (#x5738 . #xD4AB)
	   (#x573B . #xD4AD)
	   (#x573D . #x8FB7B9)
	   (#x573E . #x8FB7BA)
	   (#x573F . #x8FB7BB)
	   (#x5740 . #xD4AE)
	   (#x5742 . #xBAE4)
	   (#x5745 . #x8FB7BC)
	   (#x5746 . #x8FB7BD)
	   (#x5747 . #xB6D1)
	   (#x574A . #xCBB7)
	   (#x574C . #x8FB7BE)
	   (#x574D . #x8FB7BF)
	   (#x574E . #xD4AC)
	   (#x574F . #xD4AF)
	   (#x5750 . #xBAC1)
	   (#x5751 . #xB9A3)
	   (#x5752 . #x8FB7C0)
	   (#x5761 . #xD4B3)
	   (#x5762 . #x8FB7C1)
	   (#x5764 . #xBAA5)
	   (#x5765 . #x8FB7C2)
	   (#x5766 . #xC3B3)
	   (#x5767 . #x8FB7C3)
	   (#x5768 . #x8FB7C4)
	   (#x5769 . #xD4B0)
	   (#x576A . #xC4DA)
	   (#x576B . #x8FB7C5)
	   (#x576D . #x8FB7C6)
	   (#x576E . #x8FB7C7)
	   (#x576F . #x8FB7C8)
	   (#x5770 . #x8FB7C9)
	   (#x5771 . #x8FB7CA)
	   (#x5773 . #x8FB7CB)
	   (#x5774 . #x8FB7CC)
	   (#x5775 . #x8FB7CD)
	   (#x5777 . #x8FB7CE)
	   (#x5779 . #x8FB7CF)
	   (#x577A . #x8FB7D0)
	   (#x577B . #x8FB7D1)
	   (#x577C . #x8FB7D2)
	   (#x577E . #x8FB7D3)
	   (#x577F . #xD4B4)
	   (#x5781 . #x8FB7D4)
	   (#x5782 . #xBFE2)
	   (#x5783 . #x8FB7D5)
	   (#x5788 . #xD4B2)
	   (#x5789 . #xD4B5)
	   (#x578B . #xB7BF)
	   (#x578C . #x8FB7D6)
	   (#x5793 . #xD4B6)
	   (#x5794 . #x8FB7D7)
	   (#x5795 . #x8FB7E0)
	   (#x5797 . #x8FB7D8)
	   (#x5799 . #x8FB7D9)
	   (#x579A . #x8FB7DA)
	   (#x579C . #x8FB7DB)
	   (#x579D . #x8FB7DC)
	   (#x579E . #x8FB7DD)
	   (#x579F . #x8FB7DE)
	   (#x57A0 . #xD4B7)
	   (#x57A1 . #x8FB7DF)
	   (#x57A2 . #xB9A4)
	   (#x57A3 . #xB3C0)
	   (#x57A4 . #xD4B9)
	   (#x57A7 . #x8FB7E1)
	   (#x57A8 . #x8FB7E2)
	   (#x57A9 . #x8FB7E3)
	   (#x57AA . #xD4BA)
	   (#x57AC . #x8FB7E4)
	   (#x57B0 . #xD4BB)
	   (#x57B3 . #xD4B8)
	   (#x57B8 . #x8FB7E5)
	   (#x57BD . #x8FB7E6)
	   (#x57C0 . #xD4B1)
	   (#x57C3 . #xD4BC)
	   (#x57C6 . #xD4BD)
	   (#x57C7 . #x8FB7E7)
	   (#x57C8 . #x8FB7E8)
	   (#x57CB . #xCBE4)
	   (#x57CC . #x8FB7E9)
	   (#x57CE . #xBEEB)
	   (#x57CF . #x8FB7EA)
	   (#x57D2 . #xD4BF)
	   (#x57D3 . #xD4C0)
	   (#x57D4 . #xD4BE)
	   (#x57D5 . #x8FB7EB)
	   (#x57D6 . #xD4C2)
	   (#x57DC . #xC7B8)
	   (#x57DD . #x8FB7EC)
	   (#x57DE . #x8FB7ED)
	   (#x57DF . #xB0E8)
	   (#x57E0 . #xC9D6)
	   (#x57E1 . #x8FB7FE)
	   (#x57E3 . #xD4C3)
	   (#x57E4 . #x8FB7EE)
	   (#x57E6 . #x8FB7EF)
	   (#x57E7 . #x8FB7F0)
	   (#x57E9 . #x8FB7F1)
	   (#x57ED . #x8FB7F2)
	   (#x57F0 . #x8FB7F3)
	   (#x57F4 . #xBEFD)
	   (#x57F5 . #x8FB7F4)
	   (#x57F6 . #x8FB7F5)
	   (#x57F7 . #xBCB9)
	   (#x57F8 . #x8FB7F6)
	   (#x57F9 . #xC7DD)
	   (#x57FA . #xB4F0)
	   (#x57FC . #xBAEB)
	   (#x57FD . #x8FB7F7)
	   (#x57FE . #x8FB7F8)
	   (#x57FF . #x8FB7F9)
	   (#x5800 . #xCBD9)
	   (#x5802 . #xC6B2)
	   (#x5803 . #x8FB7FA)
	   (#x5804 . #x8FB7FB)
	   (#x5805 . #xB7F8)
	   (#x5806 . #xC2CF)
	   (#x5808 . #x8FB7FC)
	   (#x5809 . #x8FB7FD)
	   (#x580A . #xD4C1)
	   (#x580B . #xD4C4)
	   (#x580C . #x8FB8A1)
	   (#x580D . #x8FB8A2)
	   (#x5815 . #xC2C4)
	   (#x5819 . #xD4C5)
	   (#x581B . #x8FB8A3)
	   (#x581D . #xD4C6)
	   (#x581E . #x8FB8A4)
	   (#x581F . #x8FB8A5)
	   (#x5820 . #x8FB8A6)
	   (#x5821 . #xD4C8)
	   (#x5824 . #xC4E9)
	   (#x5826 . #x8FB8A7)
	   (#x5827 . #x8FB8A8)
	   (#x582A . #xB4AE)
	   (#x582D . #x8FB8A9)
	   (#x582F . #xF4A1)
	   (#x5830 . #xB1E1)
	   (#x5831 . #xCAF3)
	   (#x5832 . #x8FB8AA)
	   (#x5834 . #xBEEC)
	   (#x5835 . #xC5C8)
	   (#x5839 . #x8FB8AB)
	   (#x583A . #xBAE6)
	   (#x583D . #xD4CE)
	   (#x583F . #x8FB8AC)
	   (#x5840 . #xCABD)
	   (#x5841 . #xCEDD)
	   (#x5849 . #x8FB8AD)
	   (#x584A . #xB2F4)
	   (#x584B . #xD4CA)
	   (#x584C . #x8FB8AE)
	   (#x584D . #x8FB8AF)
	   (#x584F . #x8FB8B0)
	   (#x5850 . #x8FB8B1)
	   (#x5851 . #xC1BA)
	   (#x5852 . #xD4CD)
	   (#x5854 . #xC5E3)
	   (#x5855 . #x8FB8B2)
	   (#x5857 . #xC5C9)
	   (#x5858 . #xC5E4)
	   (#x5859 . #xC8B9)
	   (#x585A . #xC4CD)
	   (#x585E . #xBAC9)
	   (#x585F . #x8FB8B3)
	   (#x5861 . #x8FB8B4)
	   (#x5862 . #xD4C9)
	   (#x5864 . #x8FB8B5)
	   (#x5867 . #x8FB8B6)
	   (#x5868 . #x8FB8B7)
	   (#x5869 . #xB1F6)
	   (#x586B . #xC5B6)
	   (#x5870 . #xD4CB)
	   (#x5872 . #xD4C7)
	   (#x5875 . #xBFD0)
	   (#x5878 . #x8FB8B8)
	   (#x5879 . #xD4CF)
	   (#x587C . #x8FB8B9)
	   (#x587E . #xBDCE)
	   (#x587F . #x8FB8BA)
	   (#x5880 . #x8FB8BB)
	   (#x5881 . #x8FB8BC)
	   (#x5883 . #xB6AD)
	   (#x5885 . #xD4D0)
	   (#x5887 . #x8FB8BD)
	   (#x5888 . #x8FB8BE)
	   (#x5889 . #x8FB8BF)
	   (#x588A . #x8FB8C0)
	   (#x588C . #x8FB8C1)
	   (#x588D . #x8FB8C2)
	   (#x588F . #x8FB8C3)
	   (#x5890 . #x8FB8C4)
	   (#x5893 . #xCAE8)
	   (#x5894 . #x8FB8C5)
	   (#x5896 . #x8FB8C6)
	   (#x5897 . #xC1FD)
	   (#x589C . #xC4C6)
	   (#x589D . #x8FB8C7)
	   (#x589F . #xD4D2)
	   (#x58A0 . #x8FB8C8)
	   (#x58A1 . #x8FB8C9)
	   (#x58A2 . #x8FB8CA)
	   (#x58A6 . #x8FB8CB)
	   (#x58A8 . #xCBCF)
	   (#x58A9 . #x8FB8CC)
	   (#x58AB . #xD4D3)
	   (#x58AE . #xD4D8)
	   (#x58B1 . #x8FB8CD)
	   (#x58B2 . #x8FB8CE)
	   (#x58B3 . #xCAAF)
	   (#x58B8 . #xD4D7)
	   (#x58B9 . #xD4D1)
	   (#x58BA . #xD4D4)
	   (#x58BB . #xD4D6)
	   (#x58BC . #x8FB8D0)
	   (#x58BE . #xBAA6)
	   (#x58C1 . #xCAC9)
	   (#x58C2 . #x8FB8D1)
	   (#x58C4 . #x8FB8CF)
	   (#x58C5 . #xD4D9)
	   (#x58C7 . #xC3C5)
	   (#x58C8 . #x8FB8D2)
	   (#x58CA . #xB2F5)
	   (#x58CC . #xBEED)
	   (#x58CD . #x8FB8D3)
	   (#x58CE . #x8FB8D4)
	   (#x58D0 . #x8FB8D5)
	   (#x58D1 . #xD4DB)
	   (#x58D2 . #x8FB8D6)
	   (#x58D3 . #xD4DA)
	   (#x58D4 . #x8FB8D7)
	   (#x58D5 . #xB9E8)
	   (#x58D6 . #x8FB8D8)
	   (#x58D7 . #xD4DC)
	   (#x58D8 . #xD4DE)
	   (#x58D9 . #xD4DD)
	   (#x58DA . #x8FB8D9)
	   (#x58DC . #xD4E0)
	   (#x58DD . #x8FB8DA)
	   (#x58DE . #xD4D5)
	   (#x58DF . #xD4E2)
	   (#x58E1 . #x8FB8DB)
	   (#x58E2 . #x8FB8DC)
	   (#x58E4 . #xD4E1)
	   (#x58E5 . #xD4DF)
	   (#x58E9 . #x8FB8DD)
	   (#x58EB . #xBBCE)
	   (#x58EC . #xBFD1)
	   (#x58EE . #xC1D4)
	   (#x58EF . #xD4E3)
	   (#x58F0 . #xC0BC)
	   (#x58F1 . #xB0ED)
	   (#x58F2 . #xC7E4)
	   (#x58F3 . #x8FB8DE)
	   (#x58F7 . #xC4DB)
	   (#x58F9 . #xD4E5)
	   (#x58FA . #xD4E4)
	   (#x58FB . #xD4E6)
	   (#x58FC . #xD4E7)
	   (#x58FD . #xD4E8)
	   (#x5902 . #xD4E9)
	   (#x5905 . #x8FB8DF)
	   (#x5906 . #x8FB8E0)
	   (#x5909 . #xCAD1)
	   (#x590A . #xD4EA)
	   (#x590B . #x8FB8E1)
	   (#x590C . #x8FB8E2)
	   (#x590F . #xB2C6)
	   (#x5910 . #xD4EB)
	   (#x5912 . #x8FB8E3)
	   (#x5913 . #x8FB8E4)
	   (#x5914 . #x8FB8E5)
	   (#x5915 . #xCDBC)
	   (#x5916 . #xB3B0)
	   (#x5918 . #xD2C9)
	   (#x5919 . #xBDC8)
	   (#x591A . #xC2BF)
	   (#x591B . #xD4EC)
	   (#x591C . #xCCEB)
	   (#x591D . #x8FB8E7)
	   (#x5921 . #x8FB8E8)
	   (#x5922 . #xCCB4)
	   (#x5923 . #x8FB8E9)
	   (#x5924 . #x8FB8EA)
	   (#x5925 . #xD4EE)
	   (#x5927 . #xC2E7)
	   (#x5928 . #x8FB8EB)
	   (#x5929 . #xC5B7)
	   (#x592A . #xC2C0)
	   (#x592B . #xC9D7)
	   (#x592C . #xD4EF)
	   (#x592D . #xD4F0)
	   (#x592E . #xB1FB)
	   (#x592F . #x8FB8EC)
	   (#x5930 . #x8FB8ED)
	   (#x5931 . #xBCBA)
	   (#x5932 . #xD4F1)
	   (#x5933 . #x8FB8EE)
	   (#x5935 . #x8FB8EF)
	   (#x5936 . #x8FB8F0)
	   (#x5937 . #xB0D0)
	   (#x5938 . #xD4F2)
	   (#x593E . #xD4F3)
	   (#x593F . #x8FB8F1)
	   (#x5943 . #x8FB8F2)
	   (#x5944 . #xB1E2)
	   (#x5946 . #x8FB8F3)
	   (#x5947 . #xB4F1)
	   (#x5948 . #xC6E0)
	   (#x5949 . #xCAF4)
	   (#x594E . #xD4F7)
	   (#x594F . #xC1D5)
	   (#x5950 . #xD4F6)
	   (#x5951 . #xB7C0)
	   (#x5952 . #x8FB8F4)
	   (#x5953 . #x8FB8F5)
	   (#x5954 . #xCBDB)
	   (#x5955 . #xD4F5)
	   (#x5957 . #xC5E5)
	   (#x5958 . #xD4F9)
	   (#x5959 . #x8FB8F6)
	   (#x595A . #xD4F8)
	   (#x595B . #x8FB8F7)
	   (#x595D . #x8FB8F8)
	   (#x595E . #x8FB8F9)
	   (#x595F . #x8FB8FA)
	   (#x5960 . #xD4FB)
	   (#x5961 . #x8FB8FB)
	   (#x5962 . #xD4FA)
	   (#x5963 . #x8FB8FC)
	   (#x5965 . #xB1FC)
	   (#x5967 . #xD4FC)
	   (#x5968 . #xBEA9)
	   (#x5969 . #xD4FE)
	   (#x596A . #xC3A5)
	   (#x596B . #x8FB8FD)
	   (#x596C . #xD4FD)
	   (#x596D . #x8FB8FE)
	   (#x596E . #xCAB3)
	   (#x596F . #x8FB9A1)
	   (#x5972 . #x8FB9A2)
	   (#x5973 . #xBDF7)
	   (#x5974 . #xC5DB)
	   (#x5975 . #x8FB9A3)
	   (#x5976 . #x8FB9A4)
	   (#x5978 . #xD5A1)
	   (#x5979 . #x8FB9A5)
	   (#x597B . #x8FB9A6)
	   (#x597C . #x8FB9A7)
	   (#x597D . #xB9A5)
	   (#x5981 . #xD5A2)
	   (#x5982 . #xC7A1)
	   (#x5983 . #xC8DE)
	   (#x5984 . #xCCD1)
	   (#x598A . #xC7A5)
	   (#x598B . #x8FB9A8)
	   (#x598C . #x8FB9A9)
	   (#x598D . #xD5AB)
	   (#x598E . #x8FB9AA)
	   (#x5992 . #x8FB9AB)
	   (#x5993 . #xB5B8)
	   (#x5995 . #x8FB9AC)
	   (#x5996 . #xCDC5)
	   (#x5997 . #x8FB9AD)
	   (#x5999 . #xCCAF)
	   (#x599B . #xD6AC)
	   (#x599D . #xD5A3)
	   (#x599F . #x8FB9AE)
	   (#x59A3 . #xD5A6)
	   (#x59A4 . #x8FB9AF)
	   (#x59A5 . #xC2C5)
	   (#x59A7 . #x8FB9B0)
	   (#x59A8 . #xCBB8)
	   (#x59AC . #xC5CA)
	   (#x59AD . #x8FB9B1)
	   (#x59AE . #x8FB9B2)
	   (#x59AF . #x8FB9B3)
	   (#x59B0 . #x8FB9B4)
	   (#x59B2 . #xD5A7)
	   (#x59B3 . #x8FB9B5)
	   (#x59B7 . #x8FB9B6)
	   (#x59B9 . #xCBE5)
	   (#x59BA . #x8FB9B7)
	   (#x59BB . #xBACA)
	   (#x59BC . #x8FB9B8)
	   (#x59BE . #xBEAA)
	   (#x59C1 . #x8FB9B9)
	   (#x59C3 . #x8FB9BA)
	   (#x59C4 . #x8FB9BB)
	   (#x59C6 . #xD5A8)
	   (#x59C8 . #x8FB9BC)
	   (#x59C9 . #xBBD0)
	   (#x59CA . #x8FB9BD)
	   (#x59CB . #xBBCF)
	   (#x59CD . #x8FB9BE)
	   (#x59D0 . #xB0B9)
	   (#x59D1 . #xB8C8)
	   (#x59D2 . #x8FB9BF)
	   (#x59D3 . #xC0AB)
	   (#x59D4 . #xB0D1)
	   (#x59D9 . #xD5AC)
	   (#x59DA . #xD5AD)
	   (#x59DC . #xD5AA)
	   (#x59DD . #x8FB9C0)
	   (#x59DE . #x8FB9C1)
	   (#x59DF . #x8FB9C2)
	   (#x59E3 . #x8FB9C3)
	   (#x59E4 . #x8FB9C4)
	   (#x59E5 . #xB1B8)
	   (#x59E6 . #xB4AF)
	   (#x59E7 . #x8FB9C5)
	   (#x59E8 . #xD5A9)
	   (#x59EA . #xCCC5)
	   (#x59EB . #xC9B1)
	   (#x59EE . #x8FB9C6)
	   (#x59EF . #x8FB9C7)
	   (#x59F1 . #x8FB9C8)
	   (#x59F2 . #x8FB9C9)
	   (#x59F4 . #x8FB9CA)
	   (#x59F6 . #xB0A8)
	   (#x59F7 . #x8FB9CB)
	   (#x59FB . #xB0F9)
	   (#x59FF . #xBBD1)
	   (#x5A00 . #x8FB9CC)
	   (#x5A01 . #xB0D2)
	   (#x5A03 . #xB0A3)
	   (#x5A04 . #x8FB9CD)
	   (#x5A09 . #xD5B2)
	   (#x5A0C . #x8FB9CE)
	   (#x5A0D . #x8FB9CF)
	   (#x5A0E . #x8FB9D0)
	   (#x5A11 . #xD5B0)
	   (#x5A12 . #x8FB9D1)
	   (#x5A13 . #x8FB9D2)
	   (#x5A18 . #xCCBC)
	   (#x5A1A . #xD5B3)
	   (#x5A1C . #xD5B1)
	   (#x5A1E . #x8FB9D3)
	   (#x5A1F . #xD5AF)
	   (#x5A20 . #xBFB1)
	   (#x5A23 . #x8FB9D4)
	   (#x5A24 . #x8FB9D5)
	   (#x5A25 . #xD5AE)
	   (#x5A27 . #x8FB9D6)
	   (#x5A28 . #x8FB9D7)
	   (#x5A29 . #xCADA)
	   (#x5A2A . #x8FB9D8)
	   (#x5A2D . #x8FB9D9)
	   (#x5A2F . #xB8E4)
	   (#x5A30 . #x8FB9DA)
	   (#x5A35 . #xD5B7)
	   (#x5A36 . #xD5B8)
	   (#x5A3C . #xBEAB)
	   (#x5A40 . #xD5B4)
	   (#x5A41 . #xCFAC)
	   (#x5A44 . #x8FB9DB)
	   (#x5A45 . #x8FB9DC)
	   (#x5A46 . #xC7CC)
	   (#x5A47 . #x8FB9DD)
	   (#x5A48 . #x8FB9DE)
	   (#x5A49 . #xD5B6)
	   (#x5A4C . #x8FB9DF)
	   (#x5A50 . #x8FB9E0)
	   (#x5A55 . #x8FB9E1)
	   (#x5A5A . #xBAA7)
	   (#x5A5E . #x8FB9E2)
	   (#x5A62 . #xD5B9)
	   (#x5A63 . #x8FB9E3)
	   (#x5A65 . #x8FB9E4)
	   (#x5A66 . #xC9D8)
	   (#x5A67 . #x8FB9E5)
	   (#x5A6A . #xD5BA)
	   (#x5A6C . #xD5B5)
	   (#x5A6D . #x8FB9E6)
	   (#x5A77 . #x8FB9E7)
	   (#x5A7A . #x8FB9E8)
	   (#x5A7B . #x8FB9E9)
	   (#x5A7E . #x8FB9EA)
	   (#x5A7F . #xCCBB)
	   (#x5A8B . #x8FB9EB)
	   (#x5A90 . #x8FB9EC)
	   (#x5A92 . #xC7DE)
	   (#x5A93 . #x8FB9ED)
	   (#x5A96 . #x8FB9EE)
	   (#x5A99 . #x8FB9EF)
	   (#x5A9A . #xD5BB)
	   (#x5A9B . #xC9B2)
	   (#x5A9C . #x8FB9F0)
	   (#x5A9E . #x8FB9F1)
	   (#x5A9F . #x8FB9F2)
	   (#x5AA0 . #x8FB9F3)
	   (#x5AA2 . #x8FB9F4)
	   (#x5AA7 . #x8FB9F5)
	   (#x5AAC . #x8FB9F6)
	   (#x5AB1 . #x8FB9F7)
	   (#x5AB2 . #x8FB9F8)
	   (#x5AB3 . #x8FB9F9)
	   (#x5AB5 . #x8FB9FA)
	   (#x5AB8 . #x8FB9FB)
	   (#x5ABA . #x8FB9FC)
	   (#x5ABB . #x8FB9FD)
	   (#x5ABC . #xD5BC)
	   (#x5ABD . #xD5C0)
	   (#x5ABE . #xD5BD)
	   (#x5ABF . #x8FB9FE)
	   (#x5AC1 . #xB2C7)
	   (#x5AC2 . #xD5BF)
	   (#x5AC4 . #x8FBAA1)
	   (#x5AC6 . #x8FBAA2)
	   (#x5AC8 . #x8FBAA3)
	   (#x5AC9 . #xBCBB)
	   (#x5ACB . #xD5BE)
	   (#x5ACC . #xB7F9)
	   (#x5ACF . #x8FBAA4)
	   (#x5AD0 . #xD5CC)
	   (#x5AD6 . #xD5C5)
	   (#x5AD7 . #xD5C2)
	   (#x5ADA . #x8FBAA5)
	   (#x5ADC . #x8FBAA6)
	   (#x5AE0 . #x8FBAA7)
	   (#x5AE1 . #xC3E4)
	   (#x5AE3 . #xD5C1)
	   (#x5AE5 . #x8FBAA8)
	   (#x5AE6 . #xD5C3)
	   (#x5AE9 . #xD5C4)
	   (#x5AEA . #x8FBAA9)
	   (#x5AEE . #x8FBAAA)
	   (#x5AF5 . #x8FBAAB)
	   (#x5AF6 . #x8FBAAC)
	   (#x5AFA . #xD5C6)
	   (#x5AFB . #xD5C7)
	   (#x5AFD . #x8FBAAD)
	   (#x5B00 . #x8FBAAE)
	   (#x5B01 . #x8FBAAF)
	   (#x5B08 . #x8FBAB0)
	   (#x5B09 . #xB4F2)
	   (#x5B0B . #xD5C9)
	   (#x5B0C . #xD5C8)
	   (#x5B16 . #xD5CA)
	   (#x5B17 . #x8FBAB1)
	   (#x5B19 . #x8FBAB3)
	   (#x5B1B . #x8FBAB4)
	   (#x5B1D . #x8FBAB5)
	   (#x5B21 . #x8FBAB6)
	   (#x5B22 . #xBEEE)
	   (#x5B25 . #x8FBAB7)
	   (#x5B2A . #xD5CD)
	   (#x5B2C . #xC4DC)
	   (#x5B2D . #x8FBAB8)
	   (#x5B30 . #xB1C5)
	   (#x5B32 . #xD5CB)
	   (#x5B34 . #x8FBAB2)
	   (#x5B36 . #xD5CE)
	   (#x5B38 . #x8FBAB9)
	   (#x5B3E . #xD5CF)
	   (#x5B40 . #xD5D2)
	   (#x5B41 . #x8FBABA)
	   (#x5B43 . #xD5D0)
	   (#x5B45 . #xD5D1)
	   (#x5B4B . #x8FBABB)
	   (#x5B4C . #x8FBABC)
	   (#x5B50 . #xBBD2)
	   (#x5B51 . #xD5D3)
	   (#x5B52 . #x8FBABD)
	   (#x5B54 . #xB9A6)
	   (#x5B55 . #xD5D4)
	   (#x5B56 . #x8FBABE)
	   (#x5B57 . #xBBFA)
	   (#x5B58 . #xC2B8)
	   (#x5B5A . #xD5D5)
	   (#x5B5B . #xD5D6)
	   (#x5B5C . #xBBDA)
	   (#x5B5D . #xB9A7)
	   (#x5B5E . #x8FBABF)
	   (#x5B5F . #xCCD2)
	   (#x5B63 . #xB5A8)
	   (#x5B64 . #xB8C9)
	   (#x5B65 . #xD5D7)
	   (#x5B66 . #xB3D8)
	   (#x5B68 . #x8FBAC0)
	   (#x5B69 . #xD5D8)
	   (#x5B6B . #xC2B9)
	   (#x5B6E . #x8FBAC1)
	   (#x5B6F . #x8FBAC2)
	   (#x5B70 . #xD5D9)
	   (#x5B71 . #xD6A3)
	   (#x5B73 . #xD5DA)
	   (#x5B75 . #xD5DB)
	   (#x5B78 . #xD5DC)
	   (#x5B7A . #xD5DE)
	   (#x5B7C . #x8FBAC3)
	   (#x5B7D . #x8FBAC4)
	   (#x5B7E . #x8FBAC5)
	   (#x5B7F . #x8FBAC6)
	   (#x5B80 . #xD5DF)
	   (#x5B81 . #x8FBAC7)
	   (#x5B83 . #xD5E0)
	   (#x5B84 . #x8FBAC8)
	   (#x5B85 . #xC2F0)
	   (#x5B86 . #x8FBAC9)
	   (#x5B87 . #xB1A7)
	   (#x5B88 . #xBCE9)
	   (#x5B89 . #xB0C2)
	   (#x5B8A . #x8FBACA)
	   (#x5B8B . #xC1D7)
	   (#x5B8C . #xB4B0)
	   (#x5B8D . #xBCB5)
	   (#x5B8E . #x8FBACB)
	   (#x5B8F . #xB9A8)
	   (#x5B90 . #x8FBACC)
	   (#x5B91 . #x8FBACD)
	   (#x5B93 . #x8FBACE)
	   (#x5B94 . #x8FBACF)
	   (#x5B95 . #xC5E6)
	   (#x5B96 . #x8FBAD0)
	   (#x5B97 . #xBDA1)
	   (#x5B98 . #xB4B1)
	   (#x5B99 . #xC3E8)
	   (#x5B9A . #xC4EA)
	   (#x5B9B . #xB0B8)
	   (#x5B9C . #xB5B9)
	   (#x5B9D . #xCAF5)
	   (#x5B9F . #xBCC2)
	   (#x5BA2 . #xB5D2)
	   (#x5BA3 . #xC0EB)
	   (#x5BA4 . #xBCBC)
	   (#x5BA5 . #xCDA8)
	   (#x5BA6 . #xD5E1)
	   (#x5BA8 . #x8FBAD1)
	   (#x5BA9 . #x8FBAD2)
	   (#x5BAC . #x8FBAD3)
	   (#x5BAD . #x8FBAD4)
	   (#x5BAE . #xB5DC)
	   (#x5BAF . #x8FBAD5)
	   (#x5BB0 . #xBACB)
	   (#x5BB1 . #x8FBAD6)
	   (#x5BB2 . #x8FBAD7)
	   (#x5BB3 . #xB3B2)
	   (#x5BB4 . #xB1E3)
	   (#x5BB5 . #xBEAC)
	   (#x5BB6 . #xB2C8)
	   (#x5BB7 . #x8FBAD8)
	   (#x5BB8 . #xD5E2)
	   (#x5BB9 . #xCDC6)
	   (#x5BBA . #x8FBAD9)
	   (#x5BBC . #x8FBADA)
	   (#x5BBF . #xBDC9)
	   (#x5BC0 . #x8FBADB)
	   (#x5BC1 . #x8FBADC)
	   (#x5BC2 . #xBCE4)
	   (#x5BC3 . #xD5E3)
	   (#x5BC4 . #xB4F3)
	   (#x5BC5 . #xC6D2)
	   (#x5BC6 . #xCCA9)
	   (#x5BC7 . #xD5E4)
	   (#x5BC9 . #xD5E5)
	   (#x5BCC . #xC9D9)
	   (#x5BCD . #x8FBADD)
	   (#x5BCF . #x8FBADE)
	   (#x5BD0 . #xD5E7)
	   (#x5BD2 . #xB4A8)
	   (#x5BD3 . #xB6F7)
	   (#x5BD4 . #xD5E6)
	   (#x5BD6 . #x8FBADF)
	   (#x5BD7 . #x8FBAE0)
	   (#x5BD8 . #x8FBAE1)
	   (#x5BD9 . #x8FBAE2)
	   (#x5BDA . #x8FBAE3)
	   (#x5BDB . #xB4B2)
	   (#x5BDD . #xBFB2)
	   (#x5BDE . #xD5EB)
	   (#x5BDF . #xBBA1)
	   (#x5BE0 . #x8FBAE4)
	   (#x5BE1 . #xB2C9)
	   (#x5BE2 . #xD5EA)
	   (#x5BE4 . #xD5E8)
	   (#x5BE5 . #xD5EC)
	   (#x5BE6 . #xD5E9)
	   (#x5BE7 . #xC7AB)
	   (#x5BE8 . #xDCCD)
	   (#x5BE9 . #xBFB3)
	   (#x5BEB . #xD5ED)
	   (#x5BEE . #xCEC0)
	   (#x5BEF . #x8FBAE5)
	   (#x5BF0 . #xD5EE)
	   (#x5BF1 . #x8FBAE6)
	   (#x5BF3 . #xD5F0)
	   (#x5BF4 . #x8FBAE7)
	   (#x5BF5 . #xC3FE)
	   (#x5BF6 . #xD5EF)
	   (#x5BF8 . #xC0A3)
	   (#x5BFA . #xBBFB)
	   (#x5BFD . #x8FBAE8)
	   (#x5BFE . #xC2D0)
	   (#x5BFF . #xBCF7)
	   (#x5C01 . #xC9F5)
	   (#x5C02 . #xC0EC)
	   (#x5C04 . #xBCCD)
	   (#x5C05 . #xD5F1)
	   (#x5C06 . #xBEAD)
	   (#x5C07 . #xD5F2)
	   (#x5C08 . #xD5F3)
	   (#x5C09 . #xB0D3)
	   (#x5C0A . #xC2BA)
	   (#x5C0B . #xBFD2)
	   (#x5C0C . #x8FBAE9)
	   (#x5C0D . #xD5F4)
	   (#x5C0E . #xC6B3)
	   (#x5C0F . #xBEAE)
	   (#x5C11 . #xBEAF)
	   (#x5C13 . #xD5F5)
	   (#x5C16 . #xC0ED)
	   (#x5C17 . #x8FBAEA)
	   (#x5C1A . #xBEB0)
	   (#x5C1E . #x8FBAEB)
	   (#x5C1F . #x8FBAEC)
	   (#x5C20 . #xD5F6)
	   (#x5C22 . #xD5F7)
	   (#x5C23 . #x8FBAED)
	   (#x5C24 . #xCCE0)
	   (#x5C26 . #x8FBAEE)
	   (#x5C28 . #xD5F8)
	   (#x5C29 . #x8FBAEF)
	   (#x5C2B . #x8FBAF0)
	   (#x5C2C . #x8FBAF1)
	   (#x5C2D . #xB6C6)
	   (#x5C2E . #x8FBAF2)
	   (#x5C30 . #x8FBAF3)
	   (#x5C31 . #xBDA2)
	   (#x5C32 . #x8FBAF4)
	   (#x5C35 . #x8FBAF5)
	   (#x5C36 . #x8FBAF6)
	   (#x5C38 . #xD5F9)
	   (#x5C39 . #xD5FA)
	   (#x5C3A . #xBCDC)
	   (#x5C3B . #xBFAC)
	   (#x5C3C . #xC6F4)
	   (#x5C3D . #xBFD4)
	   (#x5C3E . #xC8F8)
	   (#x5C3F . #xC7A2)
	   (#x5C40 . #xB6C9)
	   (#x5C41 . #xD5FB)
	   (#x5C45 . #xB5EF)
	   (#x5C46 . #xD5FC)
	   (#x5C48 . #xB6FE)
	   (#x5C4A . #xC6CF)
	   (#x5C4B . #xB2B0)
	   (#x5C4D . #xBBD3)
	   (#x5C4E . #xD5FD)
	   (#x5C4F . #xD6A2)
	   (#x5C50 . #xD6A1)
	   (#x5C51 . #xB6FD)
	   (#x5C53 . #xD5FE)
	   (#x5C55 . #xC5B8)
	   (#x5C59 . #x8FBAF7)
	   (#x5C5A . #x8FBAF8)
	   (#x5C5C . #x8FBAF9)
	   (#x5C5E . #xC2B0)
	   (#x5C60 . #xC5CB)
	   (#x5C61 . #xBCC8)
	   (#x5C62 . #x8FBAFA)
	   (#x5C63 . #x8FBAFB)
	   (#x5C64 . #xC1D8)
	   (#x5C65 . #xCDFA)
	   (#x5C67 . #x8FBAFC)
	   (#x5C68 . #x8FBAFD)
	   (#x5C69 . #x8FBAFE)
	   (#x5C6C . #xD6A4)
	   (#x5C6D . #x8FBBA1)
	   (#x5C6E . #xD6A5)
	   (#x5C6F . #xC6D6)
	   (#x5C70 . #x8FBBA2)
	   (#x5C71 . #xBBB3)
	   (#x5C74 . #x8FBBA3)
	   (#x5C75 . #x8FBBA4)
	   (#x5C76 . #xD6A7)
	   (#x5C79 . #xD6A8)
	   (#x5C7A . #x8FBBA5)
	   (#x5C7B . #x8FBBA6)
	   (#x5C7C . #x8FBBA7)
	   (#x5C7D . #x8FBBA8)
	   (#x5C87 . #x8FBBA9)
	   (#x5C88 . #x8FBBAA)
	   (#x5C8A . #x8FBBAB)
	   (#x5C8C . #xD6A9)
	   (#x5C8F . #x8FBBAC)
	   (#x5C90 . #xB4F4)
	   (#x5C91 . #xD6AA)
	   (#x5C92 . #x8FBBAD)
	   (#x5C94 . #xD6AB)
	   (#x5C9D . #x8FBBAE)
	   (#x5C9F . #x8FBBAF)
	   (#x5CA0 . #x8FBBB0)
	   (#x5CA1 . #xB2AC)
	   (#x5CA2 . #x8FBBB1)
	   (#x5CA3 . #x8FBBB2)
	   (#x5CA6 . #x8FBBB3)
	   (#x5CA8 . #xC1BB)
	   (#x5CA9 . #xB4E4)
	   (#x5CAA . #x8FBBB4)
	   (#x5CAB . #xD6AD)
	   (#x5CAC . #xCCA8)
	   (#x5CB1 . #xC2D2)
	   (#x5CB2 . #x8FBBB5)
	   (#x5CB3 . #xB3D9)
	   (#x5CB4 . #x8FBBB6)
	   (#x5CB5 . #x8FBBB7)
	   (#x5CB6 . #xD6AF)
	   (#x5CB7 . #xD6B1)
	   (#x5CB8 . #xB4DF)
	   (#x5CBA . #x8FBBB8)
	   (#x5CBB . #xD6AE)
	   (#x5CBC . #xD6B0)
	   (#x5CBE . #xD6B3)
	   (#x5CC5 . #xD6B2)
	   (#x5CC7 . #xD6B4)
	   (#x5CC9 . #x8FBBB9)
	   (#x5CCB . #x8FBBBA)
	   (#x5CD2 . #x8FBBBB)
	   (#x5CD7 . #x8FBBBD)
	   (#x5CD9 . #xD6B5)
	   (#x5CDD . #x8FBBBC)
	   (#x5CE0 . #xC6BD)
	   (#x5CE1 . #xB6AE)
	   (#x5CE8 . #xB2E5)
	   (#x5CE9 . #xD6B6)
	   (#x5CEA . #xD6BB)
	   (#x5CED . #xD6B9)
	   (#x5CEE . #x8FBBBE)
	   (#x5CEF . #xCAF7)
	   (#x5CF0 . #xCAF6)
	   (#x5CF1 . #x8FBBBF)
	   (#x5CF2 . #x8FBBC0)
	   (#x5CF4 . #x8FBBC1)
	   (#x5CF6 . #xC5E7)
	   (#x5CFA . #xD6B8)
	   (#x5CFB . #xBDD4)
	   (#x5CFD . #xD6B7)
	   (#x5D01 . #x8FBBC2)
	   (#x5D06 . #x8FBBC3)
	   (#x5D07 . #xBFF2)
	   (#x5D0B . #xD6BC)
	   (#x5D0D . #x8FBBC4)
	   (#x5D0E . #xBAEA)
	   (#x5D11 . #xD6C2)
	   (#x5D12 . #x8FBBC5)
	   (#x5D14 . #xD6C3)
	   (#x5D15 . #xD6BD)
	   (#x5D16 . #xB3B3)
	   (#x5D17 . #xD6BE)
	   (#x5D18 . #xD6C7)
	   (#x5D19 . #xD6C6)
	   (#x5D1A . #xD6C5)
	   (#x5D1B . #xD6C1)
	   (#x5D1F . #xD6C0)
	   (#x5D22 . #xD6C4)
	   (#x5D23 . #x8FBBC7)
	   (#x5D24 . #x8FBBC8)
	   (#x5D26 . #x8FBBC9)
	   (#x5D27 . #x8FBBCA)
	   (#x5D29 . #xCAF8)
	   (#x5D2B . #x8FBBC6)
	   (#x5D31 . #x8FBBCB)
	   (#x5D34 . #x8FBBCC)
	   (#x5D39 . #x8FBBCD)
	   (#x5D3D . #x8FBBCE)
	   (#x5D3F . #x8FBBCF)
	   (#x5D42 . #x8FBBD0)
	   (#x5D43 . #x8FBBD1)
	   (#x5D46 . #x8FBBD2)
	   (#x5D48 . #x8FBBD3)
	   (#x5D4A . #x8FBBD7)
	   (#x5D4B . #xD6CB)
	   (#x5D4C . #xD6C8)
	   (#x5D4E . #xD6CA)
	   (#x5D50 . #xCDF2)
	   (#x5D51 . #x8FBBD5)
	   (#x5D52 . #xD6C9)
	   (#x5D55 . #x8FBBD4)
	   (#x5D59 . #x8FBBD6)
	   (#x5D5C . #xD6BF)
	   (#x5D5F . #x8FBBD8)
	   (#x5D60 . #x8FBBD9)
	   (#x5D61 . #x8FBBDA)
	   (#x5D62 . #x8FBBDB)
	   (#x5D64 . #x8FBBDC)
	   (#x5D69 . #xBFF3)
	   (#x5D6A . #x8FBBDD)
	   (#x5D6C . #xD6CC)
	   (#x5D6D . #x8FBBDE)
	   (#x5D6F . #xBAB7)
	   (#x5D70 . #x8FBBDF)
	   (#x5D73 . #xD6CD)
	   (#x5D76 . #xD6CE)
	   (#x5D79 . #x8FBBE0)
	   (#x5D7A . #x8FBBE1)
	   (#x5D7E . #x8FBBE2)
	   (#x5D7F . #x8FBBE3)
	   (#x5D81 . #x8FBBE4)
	   (#x5D82 . #xD6D1)
	   (#x5D83 . #x8FBBE5)
	   (#x5D84 . #xD6D0)
	   (#x5D87 . #xD6CF)
	   (#x5D88 . #x8FBBE6)
	   (#x5D8A . #x8FBBE7)
	   (#x5D8B . #xC5E8)
	   (#x5D8C . #xD6BA)
	   (#x5D90 . #xD6D7)
	   (#x5D92 . #x8FBBE8)
	   (#x5D93 . #x8FBBE9)
	   (#x5D94 . #x8FBBEA)
	   (#x5D95 . #x8FBBEB)
	   (#x5D99 . #x8FBBEC)
	   (#x5D9B . #x8FBBED)
	   (#x5D9D . #xD6D3)
	   (#x5D9F . #x8FBBEE)
	   (#x5DA0 . #x8FBBEF)
	   (#x5DA2 . #xD6D2)
	   (#x5DA7 . #x8FBBF0)
	   (#x5DAB . #x8FBBF1)
	   (#x5DAC . #xD6D4)
	   (#x5DAE . #xD6D5)
	   (#x5DB0 . #x8FBBF2)
	   (#x5DB2 . #x8FE6F4)
	   (#x5DB4 . #x8FBBF3)
	   (#x5DB7 . #xD6D8)
	   (#x5DB8 . #x8FBBF4)
	   (#x5DB9 . #x8FBBF5)
	   (#x5DBA . #xCEE6)
	   (#x5DBC . #xD6D9)
	   (#x5DBD . #xD6D6)
	   (#x5DC3 . #x8FBBF6)
	   (#x5DC7 . #x8FBBF7)
	   (#x5DC9 . #xD6DA)
	   (#x5DCB . #x8FBBF8)
	   (#x5DCC . #xB4E0)
	   (#x5DCD . #xD6DB)
	   (#x5DCE . #x8FBBFA)
	   (#x5DD0 . #x8FBBF9)
	   (#x5DD2 . #xD6DD)
	   (#x5DD3 . #xD6DC)
	   (#x5DD6 . #xD6DE)
	   (#x5DD8 . #x8FBBFB)
	   (#x5DD9 . #x8FBBFC)
	   (#x5DDB . #xD6DF)
	   (#x5DDD . #xC0EE)
	   (#x5DDE . #xBDA3)
	   (#x5DE0 . #x8FBBFD)
	   (#x5DE1 . #xBDE4)
	   (#x5DE3 . #xC1E3)
	   (#x5DE4 . #x8FBBFE)
	   (#x5DE5 . #xB9A9)
	   (#x5DE6 . #xBAB8)
	   (#x5DE7 . #xB9AA)
	   (#x5DE8 . #xB5F0)
	   (#x5DE9 . #x8FBCA1)
	   (#x5DEB . #xD6E0)
	   (#x5DEE . #xBAB9)
	   (#x5DF1 . #xB8CA)
	   (#x5DF2 . #xD6E1)
	   (#x5DF3 . #xCCA6)
	   (#x5DF4 . #xC7C3)
	   (#x5DF5 . #xD6E2)
	   (#x5DF7 . #xB9AB)
	   (#x5DF8 . #x8FBCA2)
	   (#x5DF9 . #x8FBCA3)
	   (#x5DFB . #xB4AC)
	   (#x5DFD . #xC3A7)
	   (#x5DFE . #xB6D2)
	   (#x5E00 . #x8FBCA4)
	   (#x5E02 . #xBBD4)
	   (#x5E03 . #xC9DB)
	   (#x5E06 . #xC8C1)
	   (#x5E07 . #x8FBCA5)
	   (#x5E0B . #xD6E3)
	   (#x5E0C . #xB4F5)
	   (#x5E0D . #x8FBCA6)
	   (#x5E11 . #xD6E6)
	   (#x5E12 . #x8FBCA7)
	   (#x5E14 . #x8FBCA8)
	   (#x5E15 . #x8FBCA9)
	   (#x5E16 . #xC4A1)
	   (#x5E18 . #x8FBCAA)
	   (#x5E19 . #xD6E5)
	   (#x5E1A . #xD6E4)
	   (#x5E1B . #xD6E7)
	   (#x5E1D . #xC4EB)
	   (#x5E1F . #x8FBCAB)
	   (#x5E20 . #x8FBCAC)
	   (#x5E25 . #xBFE3)
	   (#x5E28 . #x8FBCAE)
	   (#x5E2B . #xBBD5)
	   (#x5E2D . #xC0CA)
	   (#x5E2E . #x8FBCAD)
	   (#x5E2F . #xC2D3)
	   (#x5E30 . #xB5A2)
	   (#x5E32 . #x8FBCAF)
	   (#x5E33 . #xC4A2)
	   (#x5E35 . #x8FBCB0)
	   (#x5E36 . #xD6E8)
	   (#x5E37 . #xD6E9)
	   (#x5E38 . #xBEEF)
	   (#x5E3D . #xCBB9)
	   (#x5E3E . #x8FBCB1)
	   (#x5E40 . #xD6EC)
	   (#x5E43 . #xD6EB)
	   (#x5E44 . #xD6EA)
	   (#x5E45 . #xC9FD)
	   (#x5E47 . #xD6F3)
	   (#x5E49 . #x8FBCB4)
	   (#x5E4B . #x8FBCB2)
	   (#x5E4C . #xCBDA)
	   (#x5E4E . #xD6ED)
	   (#x5E50 . #x8FBCB3)
	   (#x5E51 . #x8FBCB5)
	   (#x5E54 . #xD6EF)
	   (#x5E55 . #xCBEB)
	   (#x5E56 . #x8FBCB6)
	   (#x5E57 . #xD6EE)
	   (#x5E58 . #x8FBCB7)
	   (#x5E5B . #x8FBCB8)
	   (#x5E5C . #x8FBCB9)
	   (#x5E5E . #x8FBCBA)
	   (#x5E5F . #xD6F0)
	   (#x5E61 . #xC8A8)
	   (#x5E62 . #xD6F1)
	   (#x5E63 . #xCABE)
	   (#x5E64 . #xD6F2)
	   (#x5E68 . #x8FBCBB)
	   (#x5E6A . #x8FBCBC)
	   (#x5E6B . #x8FBCBD)
	   (#x5E6C . #x8FBCBE)
	   (#x5E6D . #x8FBCBF)
	   (#x5E6E . #x8FBCC0)
	   (#x5E70 . #x8FBCC1)
	   (#x5E72 . #xB4B3)
	   (#x5E73 . #xCABF)
	   (#x5E74 . #xC7AF)
	   (#x5E75 . #xD6F4)
	   (#x5E76 . #xD6F5)
	   (#x5E78 . #xB9AC)
	   (#x5E79 . #xB4B4)
	   (#x5E7A . #xD6F6)
	   (#x5E7B . #xB8B8)
	   (#x5E7C . #xCDC4)
	   (#x5E7D . #xCDA9)
	   (#x5E7E . #xB4F6)
	   (#x5E7F . #xD6F8)
	   (#x5E80 . #x8FBCC2)
	   (#x5E81 . #xC4A3)
	   (#x5E83 . #xB9AD)
	   (#x5E84 . #xBEB1)
	   (#x5E87 . #xC8DF)
	   (#x5E8A . #xBEB2)
	   (#x5E8B . #x8FBCC3)
	   (#x5E8E . #x8FBCC4)
	   (#x5E8F . #xBDF8)
	   (#x5E95 . #xC4EC)
	   (#x5E96 . #xCAF9)
	   (#x5E97 . #xC5B9)
	   (#x5E9A . #xB9AE)
	   (#x5E9C . #xC9DC)
	   (#x5EA0 . #xD6F9)
	   (#x5EA2 . #x8FBCC5)
	   (#x5EA4 . #x8FBCC6)
	   (#x5EA5 . #x8FBCC7)
	   (#x5EA6 . #xC5D9)
	   (#x5EA7 . #xBAC2)
	   (#x5EA8 . #x8FBCC8)
	   (#x5EAA . #x8FBCC9)
	   (#x5EAB . #xB8CB)
	   (#x5EAC . #x8FBCCA)
	   (#x5EAD . #xC4ED)
	   (#x5EB1 . #x8FBCCB)
	   (#x5EB3 . #x8FBCCC)
	   (#x5EB5 . #xB0C3)
	   (#x5EB6 . #xBDEE)
	   (#x5EB7 . #xB9AF)
	   (#x5EB8 . #xCDC7)
	   (#x5EBD . #x8FBCCD)
	   (#x5EBE . #x8FBCCE)
	   (#x5EBF . #x8FBCCF)
	   (#x5EC1 . #xD6FA)
	   (#x5EC2 . #xD6FB)
	   (#x5EC3 . #xC7D1)
	   (#x5EC6 . #x8FBCD0)
	   (#x5EC8 . #xD6FC)
	   (#x5EC9 . #xCEF7)
	   (#x5ECA . #xCFAD)
	   (#x5ECB . #x8FBCD2)
	   (#x5ECC . #x8FBCD1)
	   (#x5ECE . #x8FBCD3)
	   (#x5ECF . #xD6FE)
	   (#x5ED0 . #xD6FD)
	   (#x5ED1 . #x8FBCD4)
	   (#x5ED2 . #x8FBCD5)
	   (#x5ED3 . #xB3C7)
	   (#x5ED4 . #x8FBCD6)
	   (#x5ED5 . #x8FBCD7)
	   (#x5ED6 . #xD7A1)
	   (#x5EDA . #xD7A4)
	   (#x5EDB . #xD7A5)
	   (#x5EDC . #x8FBCD8)
	   (#x5EDD . #xD7A3)
	   (#x5EDE . #x8FBCD9)
	   (#x5EDF . #xC9C0)
	   (#x5EE0 . #xBEB3)
	   (#x5EE1 . #xD7A7)
	   (#x5EE2 . #xD7A6)
	   (#x5EE3 . #xD7A2)
	   (#x5EE5 . #x8FBCDA)
	   (#x5EE8 . #xD7A8)
	   (#x5EE9 . #xD7A9)
	   (#x5EEB . #x8FBCDB)
	   (#x5EEC . #xD7AA)
	   (#x5EF0 . #xD7AD)
	   (#x5EF1 . #xD7AB)
	   (#x5EF3 . #xD7AC)
	   (#x5EF4 . #xD7AE)
	   (#x5EF6 . #xB1E4)
	   (#x5EF7 . #xC4EE)
	   (#x5EF8 . #xD7AF)
	   (#x5EFA . #xB7FA)
	   (#x5EFB . #xB2F6)
	   (#x5EFC . #xC7B6)
	   (#x5EFE . #xD7B0)
	   (#x5EFF . #xC6FB)
	   (#x5F01 . #xCADB)
	   (#x5F02 . #x8FBCDC)
	   (#x5F03 . #xD7B1)
	   (#x5F04 . #xCFAE)
	   (#x5F06 . #x8FBCDD)
	   (#x5F07 . #x8FBCDE)
	   (#x5F08 . #x8FBCDF)
	   (#x5F09 . #xD7B2)
	   (#x5F0A . #xCAC0)
	   (#x5F0B . #xD7B5)
	   (#x5F0C . #xD0A1)
	   (#x5F0D . #xD0B1)
	   (#x5F0E . #x8FBCE0)
	   (#x5F0F . #xBCB0)
	   (#x5F10 . #xC6F5)
	   (#x5F11 . #xD7B6)
	   (#x5F13 . #xB5DD)
	   (#x5F14 . #xC4A4)
	   (#x5F15 . #xB0FA)
	   (#x5F16 . #xD7B7)
	   (#x5F17 . #xCAA6)
	   (#x5F18 . #xB9B0)
	   (#x5F19 . #x8FBCE1)
	   (#x5F1B . #xC3D0)
	   (#x5F1C . #x8FBCE2)
	   (#x5F1D . #x8FBCE3)
	   (#x5F1F . #xC4EF)
	   (#x5F21 . #x8FBCE4)
	   (#x5F22 . #x8FBCE5)
	   (#x5F23 . #x8FBCE6)
	   (#x5F24 . #x8FBCE7)
	   (#x5F25 . #xCCEF)
	   (#x5F26 . #xB8B9)
	   (#x5F27 . #xB8CC)
	   (#x5F28 . #x8FBCE8)
	   (#x5F29 . #xD7B8)
	   (#x5F2B . #x8FBCE9)
	   (#x5F2C . #x8FBCEA)
	   (#x5F2D . #xD7B9)
	   (#x5F2E . #x8FBCEB)
	   (#x5F2F . #xD7BF)
	   (#x5F30 . #x8FBCEC)
	   (#x5F31 . #xBCE5)
	   (#x5F34 . #x8FBCED)
	   (#x5F35 . #xC4A5)
	   (#x5F36 . #x8FBCEE)
	   (#x5F37 . #xB6AF)
	   (#x5F38 . #xD7BA)
	   (#x5F3B . #x8FBCEF)
	   (#x5F3C . #xC9AB)
	   (#x5F3D . #x8FBCF0)
	   (#x5F3E . #xC3C6)
	   (#x5F3F . #x8FBCF1)
	   (#x5F40 . #x8FBCF2)
	   (#x5F41 . #xD7BB)
	   (#x5F44 . #x8FBCF3)
	   (#x5F45 . #x8FBCF4)
	   (#x5F47 . #x8FBCF5)
	   (#x5F48 . #xD7BC)
	   (#x5F4A . #xB6B0)
	   (#x5F4C . #xD7BD)
	   (#x5F4D . #x8FBCF6)
	   (#x5F4E . #xD7BE)
	   (#x5F50 . #x8FBCF7)
	   (#x5F51 . #xD7C0)
	   (#x5F53 . #xC5F6)
	   (#x5F54 . #x8FBCF8)
	   (#x5F56 . #xD7C1)
	   (#x5F57 . #xD7C2)
	   (#x5F58 . #x8FBCF9)
	   (#x5F59 . #xD7C3)
	   (#x5F5B . #x8FBCFA)
	   (#x5F5C . #xD7B4)
	   (#x5F5D . #xD7B3)
	   (#x5F60 . #x8FBCFB)
	   (#x5F61 . #xD7C4)
	   (#x5F62 . #xB7C1)
	   (#x5F63 . #x8FBCFC)
	   (#x5F64 . #x8FBCFD)
	   (#x5F66 . #xC9A7)
	   (#x5F67 . #x8FBCFE)
	   (#x5F69 . #xBACC)
	   (#x5F6A . #xC9B7)
	   (#x5F6B . #xC4A6)
	   (#x5F6C . #xC9CB)
	   (#x5F6D . #xD7C5)
	   (#x5F6F . #x8FBDA1)
	   (#x5F70 . #xBEB4)
	   (#x5F71 . #xB1C6)
	   (#x5F72 . #x8FBDA2)
	   (#x5F73 . #xD7C6)
	   (#x5F74 . #x8FBDA3)
	   (#x5F75 . #x8FBDA4)
	   (#x5F77 . #xD7C7)
	   (#x5F78 . #x8FBDA5)
	   (#x5F79 . #xCCF2)
	   (#x5F7A . #x8FBDA6)
	   (#x5F7C . #xC8E0)
	   (#x5F7D . #x8FBDA7)
	   (#x5F7E . #x8FBDA8)
	   (#x5F7F . #xD7CA)
	   (#x5F80 . #xB1FD)
	   (#x5F81 . #xC0AC)
	   (#x5F82 . #xD7C9)
	   (#x5F83 . #xD7C8)
	   (#x5F84 . #xB7C2)
	   (#x5F85 . #xC2D4)
	   (#x5F87 . #xD7CE)
	   (#x5F88 . #xD7CC)
	   (#x5F89 . #x8FBDA9)
	   (#x5F8A . #xD7CB)
	   (#x5F8B . #xCEA7)
	   (#x5F8C . #xB8E5)
	   (#x5F8D . #x8FBDAA)
	   (#x5F8F . #x8FBDAB)
	   (#x5F90 . #xBDF9)
	   (#x5F91 . #xD7CD)
	   (#x5F92 . #xC5CC)
	   (#x5F93 . #xBDBE)
	   (#x5F96 . #x8FBDAC)
	   (#x5F97 . #xC6C0)
	   (#x5F98 . #xD7D1)
	   (#x5F99 . #xD7D0)
	   (#x5F9C . #x8FBDAD)
	   (#x5F9D . #x8FBDAE)
	   (#x5F9E . #xD7CF)
	   (#x5FA0 . #xD7D2)
	   (#x5FA1 . #xB8E6)
	   (#x5FA2 . #x8FBDAF)
	   (#x5FA4 . #x8FBDB2)
	   (#x5FA7 . #x8FBDB0)
	   (#x5FA8 . #xD7D3)
	   (#x5FA9 . #xC9FC)
	   (#x5FAA . #xBDDB)
	   (#x5FAB . #x8FBDB1)
	   (#x5FAC . #x8FBDB3)
	   (#x5FAD . #xD7D4)
	   (#x5FAE . #xC8F9)
	   (#x5FAF . #x8FBDB4)
	   (#x5FB0 . #x8FBDB5)
	   (#x5FB1 . #x8FBDB6)
	   (#x5FB3 . #xC6C1)
	   (#x5FB4 . #xC4A7)
	   (#x5FB8 . #x8FBDB7)
	   (#x5FB9 . #xC5B0)
	   (#x5FBC . #xD7D5)
	   (#x5FBD . #xB5AB)
	   (#x5FC3 . #xBFB4)
	   (#x5FC4 . #x8FBDB8)
	   (#x5FC5 . #xC9AC)
	   (#x5FC7 . #x8FBDB9)
	   (#x5FC8 . #x8FBDBA)
	   (#x5FC9 . #x8FBDBB)
	   (#x5FCB . #x8FBDBC)
	   (#x5FCC . #xB4F7)
	   (#x5FCD . #xC7A6)
	   (#x5FD0 . #x8FBDBD)
	   (#x5FD1 . #x8FBDBE)
	   (#x5FD2 . #x8FBDBF)
	   (#x5FD3 . #x8FBDC0)
	   (#x5FD4 . #x8FBDC1)
	   (#x5FD6 . #xD7D6)
	   (#x5FD7 . #xBBD6)
	   (#x5FD8 . #xCBBA)
	   (#x5FD9 . #xCBBB)
	   (#x5FDC . #xB1FE)
	   (#x5FDD . #xD7DB)
	   (#x5FDE . #x8FBDC2)
	   (#x5FE0 . #xC3E9)
	   (#x5FE1 . #x8FBDC3)
	   (#x5FE2 . #x8FBDC4)
	   (#x5FE4 . #xD7D8)
	   (#x5FE8 . #x8FBDC5)
	   (#x5FE9 . #x8FBDC6)
	   (#x5FEA . #x8FBDC7)
	   (#x5FEB . #xB2F7)
	   (#x5FEC . #x8FBDC8)
	   (#x5FED . #x8FBDC9)
	   (#x5FEE . #x8FBDCA)
	   (#x5FEF . #x8FBDCB)
	   (#x5FF0 . #xD8AD)
	   (#x5FF1 . #xD7DA)
	   (#x5FF2 . #x8FBDCC)
	   (#x5FF3 . #x8FBDCD)
	   (#x5FF5 . #xC7B0)
	   (#x5FF6 . #x8FBDCE)
	   (#x5FF8 . #xD7D9)
	   (#x5FFA . #x8FBDCF)
	   (#x5FFB . #xD7D7)
	   (#x5FFC . #x8FBDD0)
	   (#x5FFD . #xB9FA)
	   (#x5FFF . #xD7DD)
	   (#x6007 . #x8FBDD1)
	   (#x600A . #x8FBDD2)
	   (#x600D . #x8FBDD3)
	   (#x600E . #xD7E3)
	   (#x600F . #xD7E9)
	   (#x6010 . #xD7E1)
	   (#x6012 . #xC5DC)
	   (#x6013 . #x8FBDD4)
	   (#x6014 . #x8FBDD5)
	   (#x6015 . #xD7E6)
	   (#x6016 . #xC9DD)
	   (#x6017 . #x8FBDD6)
	   (#x6018 . #x8FBDD7)
	   (#x6019 . #xD7E0)
	   (#x601A . #x8FBDD8)
	   (#x601B . #xD7E5)
	   (#x601C . #xCEE7)
	   (#x601D . #xBBD7)
	   (#x601F . #x8FBDD9)
	   (#x6020 . #xC2D5)
	   (#x6021 . #xD7DE)
	   (#x6024 . #x8FBDDA)
	   (#x6025 . #xB5DE)
	   (#x6026 . #xD7E8)
	   (#x6027 . #xC0AD)
	   (#x6028 . #xB1E5)
	   (#x6029 . #xD7E2)
	   (#x602A . #xB2F8)
	   (#x602B . #xD7E7)
	   (#x602D . #x8FBDDB)
	   (#x602F . #xB6B1)
	   (#x6031 . #xD7E4)
	   (#x6033 . #x8FBDDC)
	   (#x6035 . #x8FBDDD)
	   (#x603A . #xD7EA)
	   (#x6040 . #x8FBDDE)
	   (#x6041 . #xD7EC)
	   (#x6042 . #xD7F6)
	   (#x6043 . #xD7F4)
	   (#x6046 . #xD7F1)
	   (#x6047 . #x8FBDDF)
	   (#x6048 . #x8FBDE0)
	   (#x6049 . #x8FBDE1)
	   (#x604A . #xD7F0)
	   (#x604B . #xCEF8)
	   (#x604C . #x8FBDE2)
	   (#x604D . #xD7F2)
	   (#x6050 . #xB6B2)
	   (#x6051 . #x8FBDE3)
	   (#x6052 . #xB9B1)
	   (#x6054 . #x8FBDE4)
	   (#x6055 . #xBDFA)
	   (#x6056 . #x8FBDE5)
	   (#x6057 . #x8FBDE6)
	   (#x6059 . #xD7F9)
	   (#x605A . #xD7EB)
	   (#x605D . #x8FBDE7)
	   (#x605F . #xD7EF)
	   (#x6060 . #xD7DF)
	   (#x6061 . #x8FBDE8)
	   (#x6062 . #xB2FA)
	   (#x6063 . #xD7F3)
	   (#x6064 . #xD7F5)
	   (#x6065 . #xC3D1)
	   (#x6067 . #x8FBDE9)
	   (#x6068 . #xBAA8)
	   (#x6069 . #xB2B8)
	   (#x606A . #xD7ED)
	   (#x606B . #xD7F8)
	   (#x606C . #xD7F7)
	   (#x606D . #xB6B3)
	   (#x606F . #xC2A9)
	   (#x6070 . #xB3E6)
	   (#x6071 . #x8FBDEA)
	   (#x6075 . #xB7C3)
	   (#x6077 . #xD7EE)
	   (#x607E . #x8FBDEB)
	   (#x607F . #x8FBDEC)
	   (#x6081 . #xD7FA)
	   (#x6082 . #x8FBDED)
	   (#x6083 . #xD7FD)
	   (#x6084 . #xD8A1)
	   (#x6086 . #x8FBDEE)
	   (#x6088 . #x8FBDEF)
	   (#x6089 . #xBCBD)
	   (#x608A . #x8FBDF0)
	   (#x608B . #xD8A7)
	   (#x608C . #xC4F0)
	   (#x608D . #xD7FB)
	   (#x608E . #x8FBDF1)
	   (#x6091 . #x8FBDF2)
	   (#x6092 . #xD8A5)
	   (#x6093 . #x8FBDF3)
	   (#x6094 . #xB2F9)
	   (#x6095 . #x8FBDF4)
	   (#x6096 . #xD8A3)
	   (#x6097 . #xD8A4)
	   (#x6098 . #x8FBDF5)
	   (#x609A . #xD7FE)
	   (#x609B . #xD8A2)
	   (#x609D . #x8FBDF6)
	   (#x609E . #x8FBDF7)
	   (#x609F . #xB8E7)
	   (#x60A0 . #xCDAA)
	   (#x60A2 . #x8FBDF8)
	   (#x60A3 . #xB4B5)
	   (#x60A4 . #x8FBDF9)
	   (#x60A5 . #x8FBDFA)
	   (#x60A6 . #xB1D9)
	   (#x60A7 . #xD8A6)
	   (#x60A8 . #x8FBDFB)
	   (#x60A9 . #xC7BA)
	   (#x60AA . #xB0AD)
	   (#x60B0 . #x8FBDFC)
	   (#x60B1 . #x8FBDFD)
	   (#x60B2 . #xC8E1)
	   (#x60B3 . #xD7DC)
	   (#x60B4 . #xD8AC)
	   (#x60B5 . #xD8B0)
	   (#x60B6 . #xCCE5)
	   (#x60B7 . #x8FBDFE)
	   (#x60B8 . #xD8A9)
	   (#x60BB . #x8FBEA1)
	   (#x60BC . #xC5E9)
	   (#x60BD . #xD8AE)
	   (#x60BE . #x8FBEA2)
	   (#x60C2 . #x8FBEA3)
	   (#x60C4 . #x8FBEA4)
	   (#x60C5 . #xBEF0)
	   (#x60C6 . #xD8AF)
	   (#x60C7 . #xC6D7)
	   (#x60C8 . #x8FBEA5)
	   (#x60C9 . #x8FBEA6)
	   (#x60CA . #x8FBEA7)
	   (#x60CB . #x8FBEA8)
	   (#x60CE . #x8FBEA9)
	   (#x60CF . #x8FBEAA)
	   (#x60D1 . #xCFC7)
	   (#x60D3 . #xD8AB)
	   (#x60D4 . #x8FBEAB)
	   (#x60D5 . #x8FBEAC)
	   (#x60D8 . #xD8B1)
	   (#x60D9 . #x8FBEAD)
	   (#x60DA . #xB9FB)
	   (#x60DB . #x8FBEAE)
	   (#x60DC . #xC0CB)
	   (#x60DD . #x8FBEAF)
	   (#x60DE . #x8FBEB0)
	   (#x60DF . #xB0D4)
	   (#x60E0 . #xD8AA)
	   (#x60E1 . #xD8A8)
	   (#x60E2 . #x8FBEB1)
	   (#x60E3 . #xC1DA)
	   (#x60E5 . #x8FBEB2)
	   (#x60E7 . #xD7FC)
	   (#x60E8 . #xBBB4)
	   (#x60F0 . #xC2C6)
	   (#x60F1 . #xD8BD)
	   (#x60F2 . #x8FBEB3)
	   (#x60F3 . #xC1DB)
	   (#x60F4 . #xD8B8)
	   (#x60F5 . #x8FBEB4)
	   (#x60F6 . #xD8B5)
	   (#x60F7 . #xD8B6)
	   (#x60F8 . #x8FBEB5)
	   (#x60F9 . #xBCE6)
	   (#x60FA . #xD8B9)
	   (#x60FB . #xD8BC)
	   (#x60FC . #x8FBEB6)
	   (#x60FD . #x8FBEB7)
	   (#x6100 . #xD8B7)
	   (#x6101 . #xBDA5)
	   (#x6102 . #x8FBEB8)
	   (#x6103 . #xD8BA)
	   (#x6106 . #xD8B4)
	   (#x6107 . #x8FBEB9)
	   (#x6108 . #xCCFC)
	   (#x6109 . #xCCFB)
	   (#x610A . #x8FBEBA)
	   (#x610C . #x8FBEBB)
	   (#x610D . #xD8BE)
	   (#x610E . #xD8BF)
	   (#x610F . #xB0D5)
	   (#x6110 . #x8FBEBC)
	   (#x6111 . #x8FBEBD)
	   (#x6112 . #x8FBEBE)
	   (#x6113 . #x8FBEBF)
	   (#x6114 . #x8FBEC0)
	   (#x6115 . #xD8B3)
	   (#x6116 . #x8FBEC1)
	   (#x6117 . #x8FBEC2)
	   (#x6119 . #x8FBEC3)
	   (#x611A . #xB6F2)
	   (#x611B . #xB0A6)
	   (#x611C . #x8FBEC4)
	   (#x611E . #x8FBEC5)
	   (#x611F . #xB4B6)
	   (#x6121 . #xD8BB)
	   (#x6122 . #x8FBEC6)
	   (#x6127 . #xD8C3)
	   (#x6128 . #xD8C2)
	   (#x612A . #x8FBEC7)
	   (#x612B . #x8FBEC8)
	   (#x612C . #xD8C7)
	   (#x6130 . #x8FBEC9)
	   (#x6131 . #x8FBECA)
	   (#x6134 . #xD8C8)
	   (#x6135 . #x8FBECB)
	   (#x6136 . #x8FBECC)
	   (#x6137 . #x8FBECD)
	   (#x6139 . #x8FBECE)
	   (#x613C . #xD8C6)
	   (#x613D . #xD8C9)
	   (#x613E . #xD8C1)
	   (#x613F . #xD8C5)
	   (#x6141 . #x8FBECF)
	   (#x6142 . #xD8CA)
	   (#x6144 . #xD8CB)
	   (#x6145 . #x8FBED0)
	   (#x6146 . #x8FBED1)
	   (#x6147 . #xD8C0)
	   (#x6148 . #xBBFC)
	   (#x6149 . #x8FBED2)
	   (#x614A . #xD8C4)
	   (#x614B . #xC2D6)
	   (#x614C . #xB9B2)
	   (#x614D . #xD8B2)
	   (#x614E . #xBFB5)
	   (#x6153 . #xD8D8)
	   (#x6155 . #xCAE9)
	   (#x6158 . #xD8CE)
	   (#x6159 . #xD8CF)
	   (#x615A . #xD8D0)
	   (#x615D . #xD8D7)
	   (#x615E . #x8FBED3)
	   (#x615F . #xD8D6)
	   (#x6160 . #x8FBED4)
	   (#x6162 . #xCBFD)
	   (#x6163 . #xB4B7)
	   (#x6165 . #xD8D4)
	   (#x6167 . #xB7C5)
	   (#x6168 . #xB3B4)
	   (#x616B . #xD8D1)
	   (#x616C . #x8FBED5)
	   (#x616E . #xCEB8)
	   (#x616F . #xD8D3)
	   (#x6170 . #xB0D6)
	   (#x6171 . #xD8D5)
	   (#x6172 . #x8FBED6)
	   (#x6173 . #xD8CC)
	   (#x6174 . #xD8D2)
	   (#x6175 . #xD8D9)
	   (#x6176 . #xB7C4)
	   (#x6177 . #xD8CD)
	   (#x6178 . #x8FBED7)
	   (#x617B . #x8FBED8)
	   (#x617C . #x8FBED9)
	   (#x617E . #xCDDD)
	   (#x617F . #x8FBEDA)
	   (#x6180 . #x8FBEDB)
	   (#x6181 . #x8FBEDC)
	   (#x6182 . #xCDAB)
	   (#x6183 . #x8FBEDD)
	   (#x6184 . #x8FBEDE)
	   (#x6187 . #xD8DC)
	   (#x618A . #xD8E0)
	   (#x618B . #x8FBEDF)
	   (#x618D . #x8FBEE0)
	   (#x618E . #xC1FE)
	   (#x6190 . #xCEF9)
	   (#x6191 . #xD8E1)
	   (#x6192 . #x8FBEE1)
	   (#x6193 . #x8FBEE2)
	   (#x6194 . #xD8DE)
	   (#x6196 . #xD8DB)
	   (#x6197 . #x8FBEE3)
	   (#x6198 . #x8FBEE4)
	   (#x6199 . #xD8DA)
	   (#x619A . #xD8DF)
	   (#x619C . #x8FBEE5)
	   (#x619D . #x8FBEE6)
	   (#x619F . #x8FBEE7)
	   (#x61A0 . #x8FBEE8)
	   (#x61A4 . #xCAB0)
	   (#x61A5 . #x8FBEE9)
	   (#x61A7 . #xC6B4)
	   (#x61A8 . #x8FBEEA)
	   (#x61A9 . #xB7C6)
	   (#x61AA . #x8FBEEB)
	   (#x61AB . #xD8E2)
	   (#x61AC . #xD8DD)
	   (#x61AD . #x8FBEEC)
	   (#x61AE . #xD8E3)
	   (#x61B2 . #xB7FB)
	   (#x61B6 . #xB2B1)
	   (#x61B8 . #x8FBEED)
	   (#x61B9 . #x8FBEEE)
	   (#x61BA . #xD8EB)
	   (#x61BC . #x8FBEEF)
	   (#x61BE . #xB4B8)
	   (#x61C0 . #x8FBEF0)
	   (#x61C1 . #x8FBEF1)
	   (#x61C2 . #x8FBEF2)
	   (#x61C3 . #xD8E9)
	   (#x61C6 . #xD8EA)
	   (#x61C7 . #xBAA9)
	   (#x61C8 . #xD8E8)
	   (#x61C9 . #xD8E6)
	   (#x61CA . #xD8E5)
	   (#x61CB . #xD8EC)
	   (#x61CC . #xD8E4)
	   (#x61CD . #xD8EE)
	   (#x61CE . #x8FBEF3)
	   (#x61CF . #x8FBEF4)
	   (#x61D0 . #xB2FB)
	   (#x61D5 . #x8FBEF5)
	   (#x61DC . #x8FBEF6)
	   (#x61DD . #x8FBEF7)
	   (#x61DE . #x8FBEF8)
	   (#x61DF . #x8FBEF9)
	   (#x61E1 . #x8FBEFA)
	   (#x61E2 . #x8FBEFB)
	   (#x61E3 . #xD8F0)
	   (#x61E5 . #x8FBEFE)
	   (#x61E6 . #xD8EF)
	   (#x61E7 . #x8FBEFC)
	   (#x61E9 . #x8FBEFD)
	   (#x61EC . #x8FBFA1)
	   (#x61ED . #x8FBFA2)
	   (#x61EF . #x8FBFA3)
	   (#x61F2 . #xC4A8)
	   (#x61F4 . #xD8F3)
	   (#x61F6 . #xD8F1)
	   (#x61F7 . #xD8E7)
	   (#x61F8 . #xB7FC)
	   (#x61FA . #xD8F2)
	   (#x61FC . #xD8F6)
	   (#x61FD . #xD8F5)
	   (#x61FE . #xD8F7)
	   (#x61FF . #xD8F4)
	   (#x6200 . #xD8F8)
	   (#x6201 . #x8FBFA4)
	   (#x6203 . #x8FBFA5)
	   (#x6204 . #x8FBFA6)
	   (#x6207 . #x8FBFA7)
	   (#x6208 . #xD8F9)
	   (#x6209 . #xD8FA)
	   (#x620A . #xCAEA)
	   (#x620C . #xD8FC)
	   (#x620D . #xD8FB)
	   (#x620E . #xBDBF)
	   (#x6210 . #xC0AE)
	   (#x6211 . #xB2E6)
	   (#x6212 . #xB2FC)
	   (#x6213 . #x8FBFA8)
	   (#x6214 . #xD8FD)
	   (#x6215 . #x8FBFA9)
	   (#x6216 . #xB0BF)
	   (#x621A . #xC0CC)
	   (#x621B . #xD8FE)
	   (#x621C . #x8FBFAA)
	   (#x621D . #xECC3)
	   (#x621E . #xD9A1)
	   (#x621F . #xB7E1)
	   (#x6220 . #x8FBFAB)
	   (#x6221 . #xD9A2)
	   (#x6222 . #x8FBFAC)
	   (#x6223 . #x8FBFAD)
	   (#x6226 . #xC0EF)
	   (#x6227 . #x8FBFAE)
	   (#x6229 . #x8FBFAF)
	   (#x622A . #xD9A3)
	   (#x622B . #x8FBFB0)
	   (#x622E . #xD9A4)
	   (#x622F . #xB5BA)
	   (#x6230 . #xD9A5)
	   (#x6232 . #xD9A6)
	   (#x6233 . #xD9A7)
	   (#x6234 . #xC2D7)
	   (#x6238 . #xB8CD)
	   (#x6239 . #x8FBFB1)
	   (#x623B . #xCCE1)
	   (#x623D . #x8FBFB2)
	   (#x623F . #xCBBC)
	   (#x6240 . #xBDEA)
	   (#x6241 . #xD9A8)
	   (#x6242 . #x8FBFB3)
	   (#x6243 . #x8FBFB4)
	   (#x6244 . #x8FBFB5)
	   (#x6246 . #x8FBFB6)
	   (#x6247 . #xC0F0)
	   (#x6248 . #xEEBD)
	   (#x6249 . #xC8E2)
	   (#x624B . #xBCEA)
	   (#x624C . #x8FBFB7)
	   (#x624D . #xBACD)
	   (#x624E . #xD9A9)
	   (#x6250 . #x8FBFB8)
	   (#x6251 . #x8FBFB9)
	   (#x6252 . #x8FBFBA)
	   (#x6253 . #xC2C7)
	   (#x6254 . #x8FBFBB)
	   (#x6255 . #xCAA7)
	   (#x6256 . #x8FBFBC)
	   (#x6258 . #xC2F1)
	   (#x625A . #x8FBFBD)
	   (#x625B . #xD9AC)
	   (#x625C . #x8FBFBE)
	   (#x625E . #xD9AA)
	   (#x6260 . #xD9AD)
	   (#x6263 . #xD9AB)
	   (#x6264 . #x8FBFBF)
	   (#x6268 . #xD9AE)
	   (#x626D . #x8FBFC0)
	   (#x626E . #xCAB1)
	   (#x626F . #x8FBFC1)
	   (#x6271 . #xB0B7)
	   (#x6273 . #x8FBFC2)
	   (#x6276 . #xC9DE)
	   (#x6279 . #xC8E3)
	   (#x627A . #x8FBFC3)
	   (#x627C . #xD9AF)
	   (#x627D . #x8FBFC4)
	   (#x627E . #xD9B2)
	   (#x627F . #xBEB5)
	   (#x6280 . #xB5BB)
	   (#x6282 . #xD9B0)
	   (#x6283 . #xD9B7)
	   (#x6284 . #xBEB6)
	   (#x6289 . #xD9B1)
	   (#x628A . #xC7C4)
	   (#x628D . #x8FBFC5)
	   (#x628E . #x8FBFC6)
	   (#x628F . #x8FBFC7)
	   (#x6290 . #x8FBFC8)
	   (#x6291 . #xCDDE)
	   (#x6292 . #xD9B3)
	   (#x6293 . #xD9B4)
	   (#x6294 . #xD9B8)
	   (#x6295 . #xC5EA)
	   (#x6296 . #xD9B5)
	   (#x6297 . #xB9B3)
	   (#x6298 . #xC0DE)
	   (#x629B . #xD9C6)
	   (#x629C . #xC8B4)
	   (#x629E . #xC2F2)
	   (#x62A6 . #x8FBFC9)
	   (#x62A8 . #x8FBFCA)
	   (#x62AB . #xC8E4)
	   (#x62AC . #xDAAD)
	   (#x62B1 . #xCAFA)
	   (#x62B3 . #x8FBFCB)
	   (#x62B5 . #xC4F1)
	   (#x62B6 . #x8FBFCC)
	   (#x62B7 . #x8FBFCD)
	   (#x62B9 . #xCBF5)
	   (#x62BA . #x8FBFCE)
	   (#x62BB . #xD9BB)
	   (#x62BC . #xB2A1)
	   (#x62BD . #xC3EA)
	   (#x62BE . #x8FBFCF)
	   (#x62BF . #x8FBFD0)
	   (#x62C2 . #xD9C4)
	   (#x62C4 . #x8FBFD1)
	   (#x62C5 . #xC3B4)
	   (#x62C6 . #xD9BE)
	   (#x62C7 . #xD9C5)
	   (#x62C8 . #xD9C0)
	   (#x62C9 . #xD9C7)
	   (#x62CA . #xD9C3)
	   (#x62CC . #xD9C2)
	   (#x62CD . #xC7EF)
	   (#x62CE . #x8FBFD2)
	   (#x62CF . #xD9BC)
	   (#x62D0 . #xB2FD)
	   (#x62D1 . #xD9BA)
	   (#x62D2 . #xB5F1)
	   (#x62D3 . #xC2F3)
	   (#x62D4 . #xD9B6)
	   (#x62D5 . #x8FBFD3)
	   (#x62D6 . #x8FBFD4)
	   (#x62D7 . #xD9B9)
	   (#x62D8 . #xB9B4)
	   (#x62D9 . #xC0DB)
	   (#x62DA . #x8FBFD5)
	   (#x62DB . #xBEB7)
	   (#x62DC . #xD9C1)
	   (#x62DD . #xC7D2)
	   (#x62E0 . #xB5F2)
	   (#x62E1 . #xB3C8)
	   (#x62EA . #x8FBFD6)
	   (#x62EC . #xB3E7)
	   (#x62ED . #xBFA1)
	   (#x62EE . #xD9C9)
	   (#x62EF . #xD9CE)
	   (#x62F1 . #xD9CA)
	   (#x62F2 . #x8FBFD7)
	   (#x62F3 . #xB7FD)
	   (#x62F4 . #x8FBFD8)
	   (#x62F5 . #xD9CF)
	   (#x62F6 . #xBBA2)
	   (#x62F7 . #xB9E9)
	   (#x62FC . #x8FBFD9)
	   (#x62FD . #x8FBFDA)
	   (#x62FE . #xBDA6)
	   (#x62FF . #xD9BD)
	   (#x6301 . #xBBFD)
	   (#x6302 . #xD9CC)
	   (#x6303 . #x8FBFDB)
	   (#x6304 . #x8FBFDC)
	   (#x6307 . #xBBD8)
	   (#x6308 . #xD9CD)
	   (#x6309 . #xB0C4)
	   (#x630A . #x8FBFDD)
	   (#x630B . #x8FBFDE)
	   (#x630C . #xD9C8)
	   (#x630D . #x8FBFDF)
	   (#x6310 . #x8FBFE0)
	   (#x6311 . #xC4A9)
	   (#x6313 . #x8FBFE1)
	   (#x6316 . #x8FBFE2)
	   (#x6318 . #x8FBFE3)
	   (#x6319 . #xB5F3)
	   (#x631F . #xB6B4)
	   (#x6327 . #xD9CB)
	   (#x6328 . #xB0A7)
	   (#x6329 . #x8FBFE4)
	   (#x632A . #x8FBFE5)
	   (#x632B . #xBAC3)
	   (#x632D . #x8FBFE6)
	   (#x632F . #xBFB6)
	   (#x6335 . #x8FBFE7)
	   (#x6336 . #x8FBFE8)
	   (#x6339 . #x8FBFE9)
	   (#x633A . #xC4F2)
	   (#x633C . #x8FBFEA)
	   (#x633D . #xC8D4)
	   (#x633E . #xD9D1)
	   (#x633F . #xC1DE)
	   (#x6341 . #x8FBFEB)
	   (#x6342 . #x8FBFEC)
	   (#x6343 . #x8FBFED)
	   (#x6344 . #x8FBFEE)
	   (#x6346 . #x8FBFEF)
	   (#x6349 . #xC2AA)
	   (#x634A . #x8FBFF0)
	   (#x634B . #x8FBFF1)
	   (#x634C . #xBBAB)
	   (#x634D . #xD9D2)
	   (#x634E . #x8FBFF2)
	   (#x634F . #xD9D4)
	   (#x6350 . #xD9D0)
	   (#x6352 . #x8FBFF3)
	   (#x6353 . #x8FBFF4)
	   (#x6354 . #x8FBFF5)
	   (#x6355 . #xCAE1)
	   (#x6357 . #xC4BD)
	   (#x6358 . #x8FBFF6)
	   (#x635B . #x8FBFF7)
	   (#x635C . #xC1DC)
	   (#x6365 . #x8FBFF8)
	   (#x6366 . #x8FBFF9)
	   (#x6367 . #xCAFB)
	   (#x6368 . #xBCCE)
	   (#x6369 . #xD9E0)
	   (#x636B . #xD9DF)
	   (#x636C . #x8FBFFA)
	   (#x636D . #x8FBFFB)
	   (#x636E . #xBFF8)
	   (#x6371 . #x8FBFFC)
	   (#x6372 . #xB7FE)
	   (#x6374 . #x8FBFFD)
	   (#x6375 . #x8FBFFE)
	   (#x6376 . #xD9D9)
	   (#x6377 . #xBEB9)
	   (#x6378 . #x8FC0A1)
	   (#x637A . #xC6E8)
	   (#x637B . #xC7B1)
	   (#x637C . #x8FC0A2)
	   (#x637D . #x8FC0A3)
	   (#x637F . #x8FC0A4)
	   (#x6380 . #xD9D7)
	   (#x6382 . #x8FC0A5)
	   (#x6383 . #xC1DD)
	   (#x6384 . #x8FC0A6)
	   (#x6387 . #x8FC0A7)
	   (#x6388 . #xBCF8)
	   (#x6389 . #xD9DC)
	   (#x638A . #x8FC0A8)
	   (#x638C . #xBEB8)
	   (#x638E . #xD9D6)
	   (#x638F . #xD9DB)
	   (#x6390 . #x8FC0A9)
	   (#x6392 . #xC7D3)
	   (#x6394 . #x8FC0AA)
	   (#x6395 . #x8FC0AB)
	   (#x6396 . #xD9D5)
	   (#x6398 . #xB7A1)
	   (#x6399 . #x8FC0AC)
	   (#x639A . #x8FC0AD)
	   (#x639B . #xB3DD)
	   (#x639E . #x8FC0AE)
	   (#x639F . #xD9DD)
	   (#x63A0 . #xCEAB)
	   (#x63A1 . #xBACE)
	   (#x63A2 . #xC3B5)
	   (#x63A3 . #xD9DA)
	   (#x63A4 . #x8FC0AF)
	   (#x63A5 . #xC0DC)
	   (#x63A6 . #x8FC0B0)
	   (#x63A7 . #xB9B5)
	   (#x63A8 . #xBFE4)
	   (#x63A9 . #xB1E6)
	   (#x63AA . #xC1BC)
	   (#x63AB . #xD9D8)
	   (#x63AC . #xB5C5)
	   (#x63AD . #x8FC0B1)
	   (#x63AE . #x8FC0B2)
	   (#x63AF . #x8FC0B3)
	   (#x63B2 . #xB7C7)
	   (#x63B4 . #xC4CF)
	   (#x63B5 . #xD9DE)
	   (#x63BB . #xC1DF)
	   (#x63BD . #x8FC0B4)
	   (#x63BE . #xD9E1)
	   (#x63C0 . #xD9E3)
	   (#x63C1 . #x8FC0B5)
	   (#x63C3 . #xC2B7)
	   (#x63C4 . #xD9E9)
	   (#x63C5 . #x8FC0B6)
	   (#x63C6 . #xD9E4)
	   (#x63C8 . #x8FC0B7)
	   (#x63C9 . #xD9E6)
	   (#x63CE . #x8FC0B8)
	   (#x63CF . #xC9C1)
	   (#x63D0 . #xC4F3)
	   (#x63D1 . #x8FC0B9)
	   (#x63D2 . #xD9E7)
	   (#x63D3 . #x8FC0BA)
	   (#x63D4 . #x8FC0BB)
	   (#x63D5 . #x8FC0BC)
	   (#x63D6 . #xCDAC)
	   (#x63DA . #xCDC8)
	   (#x63DB . #xB4B9)
	   (#x63DC . #x8FC0BD)
	   (#x63E0 . #x8FC0BE)
	   (#x63E1 . #xB0AE)
	   (#x63E3 . #xD9E5)
	   (#x63E5 . #x8FC0BF)
	   (#x63E9 . #xD9E2)
	   (#x63EA . #x8FC0C0)
	   (#x63EC . #x8FC0C1)
	   (#x63EE . #xB4F8)
	   (#x63F2 . #x8FC0C2)
	   (#x63F3 . #x8FC0C3)
	   (#x63F4 . #xB1E7)
	   (#x63F5 . #x8FC0C4)
	   (#x63F6 . #xD9E8)
	   (#x63F8 . #x8FC0C5)
	   (#x63F9 . #x8FC0C6)
	   (#x63FA . #xCDC9)
	   (#x6406 . #xD9EC)
	   (#x6409 . #x8FC0C7)
	   (#x640A . #x8FC0C8)
	   (#x640D . #xC2BB)
	   (#x640F . #xD9F3)
	   (#x6410 . #x8FC0C9)
	   (#x6412 . #x8FC0CA)
	   (#x6413 . #xD9ED)
	   (#x6414 . #x8FC0CB)
	   (#x6416 . #xD9EA)
	   (#x6417 . #xD9F1)
	   (#x6418 . #x8FC0CC)
	   (#x641C . #xD9D3)
	   (#x641E . #x8FC0CD)
	   (#x6420 . #x8FC0CE)
	   (#x6422 . #x8FC0CF)
	   (#x6424 . #x8FC0D0)
	   (#x6425 . #x8FC0D1)
	   (#x6426 . #xD9EE)
	   (#x6428 . #xD9F2)
	   (#x6429 . #x8FC0D2)
	   (#x642A . #x8FC0D3)
	   (#x642C . #xC8C2)
	   (#x642D . #xC5EB)
	   (#x642F . #x8FC0D4)
	   (#x6430 . #x8FC0D5)
	   (#x6434 . #xD9EB)
	   (#x6435 . #x8FC0D6)
	   (#x6436 . #xD9EF)
	   (#x643A . #xB7C8)
	   (#x643D . #x8FC0D7)
	   (#x643E . #xBAF1)
	   (#x643F . #x8FC0D8)
	   (#x6442 . #xC0DD)
	   (#x644B . #x8FC0D9)
	   (#x644E . #xD9F7)
	   (#x644F . #x8FC0DA)
	   (#x6451 . #x8FC0DB)
	   (#x6452 . #x8FC0DC)
	   (#x6453 . #x8FC0DD)
	   (#x6454 . #x8FC0DE)
	   (#x6458 . #xC5A6)
	   (#x645A . #x8FC0DF)
	   (#x645B . #x8FC0E0)
	   (#x645C . #x8FC0E1)
	   (#x645D . #x8FC0E2)
	   (#x645F . #x8FC0E3)
	   (#x6460 . #x8FC0E4)
	   (#x6461 . #x8FC0E5)
	   (#x6463 . #x8FC0E6)
	   (#x6467 . #xD9F4)
	   (#x6469 . #xCBE0)
	   (#x646D . #x8FC0E7)
	   (#x646F . #xD9F5)
	   (#x6473 . #x8FC0E8)
	   (#x6474 . #x8FC0E9)
	   (#x6476 . #xD9F6)
	   (#x6478 . #xCCCE)
	   (#x647A . #xC0A2)
	   (#x647B . #x8FC0EA)
	   (#x647D . #x8FC0EB)
	   (#x6483 . #xB7E2)
	   (#x6485 . #x8FC0EC)
	   (#x6487 . #x8FC0ED)
	   (#x6488 . #xD9FD)
	   (#x648F . #x8FC0EE)
	   (#x6490 . #x8FC0EF)
	   (#x6491 . #x8FC0F0)
	   (#x6492 . #xBBB5)
	   (#x6493 . #xD9FA)
	   (#x6495 . #xD9F9)
	   (#x6498 . #x8FC0F1)
	   (#x6499 . #x8FC0F2)
	   (#x649A . #xC7B2)
	   (#x649B . #x8FC0F3)
	   (#x649D . #x8FC0F4)
	   (#x649E . #xC6B5)
	   (#x649F . #x8FC0F5)
	   (#x64A1 . #x8FC0F6)
	   (#x64A3 . #x8FC0F7)
	   (#x64A4 . #xC5B1)
	   (#x64A5 . #xD9FB)
	   (#x64A6 . #x8FC0F8)
	   (#x64A8 . #x8FC0F9)
	   (#x64A9 . #xD9FC)
	   (#x64AB . #xC9EF)
	   (#x64AC . #x8FC0FA)
	   (#x64AD . #xC7C5)
	   (#x64AE . #xBBA3)
	   (#x64B0 . #xC0F1)
	   (#x64B2 . #xCBD0)
	   (#x64B3 . #x8FC0FB)
	   (#x64B9 . #xB3C9)
	   (#x64BB . #xDAA5)
	   (#x64BC . #xD9FE)
	   (#x64BD . #x8FC0FC)
	   (#x64BE . #x8FC0FD)
	   (#x64BF . #x8FC0FE)
	   (#x64C1 . #xCDCA)
	   (#x64C2 . #xDAA7)
	   (#x64C4 . #x8FC1A1)
	   (#x64C5 . #xDAA3)
	   (#x64C7 . #xDAA4)
	   (#x64C9 . #x8FC1A2)
	   (#x64CA . #x8FC1A3)
	   (#x64CB . #x8FC1A4)
	   (#x64CC . #x8FC1A5)
	   (#x64CD . #xC1E0)
	   (#x64CE . #x8FC1A6)
	   (#x64D0 . #x8FC1A7)
	   (#x64D1 . #x8FC1A8)
	   (#x64D2 . #xDAA2)
	   (#x64D4 . #xD9BF)
	   (#x64D5 . #x8FC1A9)
	   (#x64D7 . #x8FC1AA)
	   (#x64D8 . #xDAA6)
	   (#x64DA . #xDAA1)
	   (#x64E0 . #xDAAB)
	   (#x64E1 . #xDAAC)
	   (#x64E2 . #xC5A7)
	   (#x64E3 . #xDAAE)
	   (#x64E4 . #x8FC1AB)
	   (#x64E5 . #x8FC1AC)
	   (#x64E6 . #xBBA4)
	   (#x64E7 . #xDAA9)
	   (#x64E9 . #x8FC1AD)
	   (#x64EA . #x8FC1AE)
	   (#x64EC . #xB5BC)
	   (#x64ED . #x8FC1AF)
	   (#x64EF . #xDAAF)
	   (#x64F0 . #x8FC1B0)
	   (#x64F1 . #xDAA8)
	   (#x64F2 . #xDAB3)
	   (#x64F4 . #xDAB2)
	   (#x64F5 . #x8FC1B1)
	   (#x64F6 . #xDAB1)
	   (#x64F7 . #x8FC1B2)
	   (#x64FA . #xDAB4)
	   (#x64FB . #x8FC1B3)
	   (#x64FD . #xDAB6)
	   (#x64FE . #xBEF1)
	   (#x64FF . #x8FC1B4)
	   (#x6500 . #xDAB5)
	   (#x6501 . #x8FC1B5)
	   (#x6504 . #x8FC1B6)
	   (#x6505 . #xDAB9)
	   (#x6508 . #x8FC1B7)
	   (#x6509 . #x8FC1B8)
	   (#x650A . #x8FC1B9)
	   (#x650F . #x8FC1BA)
	   (#x6513 . #x8FC1BB)
	   (#x6514 . #x8FC1BC)
	   (#x6516 . #x8FC1BD)
	   (#x6518 . #xDAB7)
	   (#x6519 . #x8FC1BE)
	   (#x651B . #x8FC1BF)
	   (#x651C . #xDAB8)
	   (#x651D . #xD9F0)
	   (#x651E . #x8FC1C0)
	   (#x651F . #x8FC1C1)
	   (#x6522 . #x8FC1C2)
	   (#x6523 . #xDABB)
	   (#x6524 . #xDABA)
	   (#x6526 . #x8FC1C3)
	   (#x6529 . #x8FC1C4)
	   (#x652A . #xD9F8)
	   (#x652B . #xDABC)
	   (#x652C . #xDAB0)
	   (#x652E . #x8FC1C5)
	   (#x652F . #xBBD9)
	   (#x6531 . #x8FC1C6)
	   (#x6534 . #xDABD)
	   (#x6535 . #xDABE)
	   (#x6536 . #xDAC0)
	   (#x6537 . #xDABF)
	   (#x6538 . #xDAC1)
	   (#x6539 . #xB2FE)
	   (#x653A . #x8FC1C7)
	   (#x653B . #xB9B6)
	   (#x653C . #x8FC1C8)
	   (#x653D . #x8FC1C9)
	   (#x653E . #xCAFC)
	   (#x653F . #xC0AF)
	   (#x6543 . #x8FC1CA)
	   (#x6545 . #xB8CE)
	   (#x6547 . #x8FC1CB)
	   (#x6548 . #xDAC3)
	   (#x6549 . #x8FC1CC)
	   (#x654D . #xDAC6)
	   (#x654F . #xC9D2)
	   (#x6550 . #x8FC1CD)
	   (#x6551 . #xB5DF)
	   (#x6552 . #x8FC1CE)
	   (#x6554 . #x8FC1CF)
	   (#x6555 . #xDAC5)
	   (#x6556 . #xDAC4)
	   (#x6557 . #xC7D4)
	   (#x6558 . #xDAC7)
	   (#x6559 . #xB6B5)
	   (#x655D . #xDAC9)
	   (#x655E . #xDAC8)
	   (#x655F . #x8FC1D0)
	   (#x6560 . #x8FC1D1)
	   (#x6562 . #xB4BA)
	   (#x6563 . #xBBB6)
	   (#x6566 . #xC6D8)
	   (#x6567 . #x8FC1D2)
	   (#x656B . #x8FC1D3)
	   (#x656C . #xB7C9)
	   (#x6570 . #xBFF4)
	   (#x6572 . #xDACA)
	   (#x6574 . #xC0B0)
	   (#x6575 . #xC5A8)
	   (#x6577 . #xC9DF)
	   (#x6578 . #xDACB)
	   (#x657A . #x8FC1D4)
	   (#x657D . #x8FC1D5)
	   (#x6581 . #x8FC1D6)
	   (#x6582 . #xDACC)
	   (#x6583 . #xDACD)
	   (#x6585 . #x8FC1D7)
	   (#x6587 . #xCAB8)
	   (#x6588 . #xD5DD)
	   (#x6589 . #xC0C6)
	   (#x658A . #x8FC1D8)
	   (#x658C . #xC9CC)
	   (#x658E . #xBAD8)
	   (#x6590 . #xC8E5)
	   (#x6591 . #xC8C3)
	   (#x6592 . #x8FC1D9)
	   (#x6595 . #x8FC1DA)
	   (#x6597 . #xC5CD)
	   (#x6598 . #x8FC1DB)
	   (#x6599 . #xCEC1)
	   (#x659B . #xDACF)
	   (#x659C . #xBCD0)
	   (#x659D . #x8FC1DC)
	   (#x659F . #xDAD0)
	   (#x65A0 . #x8FC1DD)
	   (#x65A1 . #xB0B6)
	   (#x65A3 . #x8FC1DE)
	   (#x65A4 . #xB6D4)
	   (#x65A5 . #xC0CD)
	   (#x65A6 . #x8FC1DF)
	   (#x65A7 . #xC9E0)
	   (#x65AB . #xDAD1)
	   (#x65AC . #xBBC2)
	   (#x65AD . #xC3C7)
	   (#x65AE . #x8FC1E0)
	   (#x65AF . #xBBDB)
	   (#x65B0 . #xBFB7)
	   (#x65B2 . #x8FC1E1)
	   (#x65B3 . #x8FC1E2)
	   (#x65B4 . #x8FC1E3)
	   (#x65B7 . #xDAD2)
	   (#x65B9 . #xCAFD)
	   (#x65BC . #xB1F7)
	   (#x65BD . #xBBDC)
	   (#x65BF . #x8FC1E4)
	   (#x65C1 . #xDAD5)
	   (#x65C2 . #x8FC1E5)
	   (#x65C3 . #xDAD3)
	   (#x65C4 . #xDAD6)
	   (#x65C5 . #xCEB9)
	   (#x65C6 . #xDAD4)
	   (#x65C8 . #x8FC1E6)
	   (#x65C9 . #x8FC1E7)
	   (#x65CB . #xC0FB)
	   (#x65CC . #xDAD7)
	   (#x65CE . #x8FC1E8)
	   (#x65CF . #xC2B2)
	   (#x65D0 . #x8FC1E9)
	   (#x65D2 . #xDAD8)
	   (#x65D4 . #x8FC1EA)
	   (#x65D6 . #x8FC1EB)
	   (#x65D7 . #xB4FA)
	   (#x65D8 . #x8FC1EC)
	   (#x65D9 . #xDADA)
	   (#x65DB . #xDAD9)
	   (#x65DF . #x8FC1ED)
	   (#x65E0 . #xDADB)
	   (#x65E1 . #xDADC)
	   (#x65E2 . #xB4FB)
	   (#x65E5 . #xC6FC)
	   (#x65E6 . #xC3B6)
	   (#x65E7 . #xB5EC)
	   (#x65E8 . #xBBDD)
	   (#x65E9 . #xC1E1)
	   (#x65EC . #xBDDC)
	   (#x65ED . #xB0B0)
	   (#x65F0 . #x8FC1EE)
	   (#x65F1 . #xDADD)
	   (#x65F2 . #x8FC1EF)
	   (#x65F4 . #x8FC1F0)
	   (#x65F5 . #x8FC1F1)
	   (#x65F9 . #x8FC1F2)
	   (#x65FA . #xB2A2)
	   (#x65FB . #xDAE1)
	   (#x65FE . #x8FC1F3)
	   (#x65FF . #x8FC1F4)
	   (#x6600 . #x8FC1F5)
	   (#x6602 . #xB9B7)
	   (#x6603 . #xDAE0)
	   (#x6604 . #x8FC1F6)
	   (#x6606 . #xBAAB)
	   (#x6607 . #xBEBA)
	   (#x6608 . #x8FC1F7)
	   (#x6609 . #x8FC1F8)
	   (#x660A . #xDADF)
	   (#x660C . #xBEBB)
	   (#x660D . #x8FC1F9)
	   (#x660E . #xCCC0)
	   (#x660F . #xBAAA)
	   (#x6611 . #x8FC1FA)
	   (#x6612 . #x8FC1FB)
	   (#x6613 . #xB0D7)
	   (#x6614 . #xC0CE)
	   (#x6615 . #x8FC1FC)
	   (#x6616 . #x8FC1FD)
	   (#x661C . #xDAE6)
	   (#x661D . #x8FC1FE)
	   (#x661E . #x8FC2A1)
	   (#x661F . #xC0B1)
	   (#x6620 . #xB1C7)
	   (#x6621 . #x8FC2A2)
	   (#x6622 . #x8FC2A3)
	   (#x6623 . #x8FC2A4)
	   (#x6624 . #x8FC2A5)
	   (#x6625 . #xBDD5)
	   (#x6626 . #x8FC2A6)
	   (#x6627 . #xCBE6)
	   (#x6628 . #xBAF2)
	   (#x6629 . #x8FC2A7)
	   (#x662A . #x8FC2A8)
	   (#x662B . #x8FC2A9)
	   (#x662C . #x8FC2AA)
	   (#x662D . #xBEBC)
	   (#x662E . #x8FC2AB)
	   (#x662F . #xC0A7)
	   (#x6630 . #x8FC2AC)
	   (#x6631 . #x8FC2AD)
	   (#x6633 . #x8FC2AE)
	   (#x6634 . #xDAE5)
	   (#x6635 . #xDAE3)
	   (#x6636 . #xDAE4)
	   (#x6637 . #x8FC2B0)
	   (#x6639 . #x8FC2AF)
	   (#x663C . #xC3EB)
	   (#x663F . #xDBA6)
	   (#x6640 . #x8FC2B1)
	   (#x6641 . #xDAEA)
	   (#x6642 . #xBBFE)
	   (#x6643 . #xB9B8)
	   (#x6644 . #xDAE8)
	   (#x6645 . #x8FC2B2)
	   (#x6646 . #x8FC2B3)
	   (#x6649 . #xDAE9)
	   (#x664A . #x8FC2B4)
	   (#x664B . #xBFB8)
	   (#x664C . #x8FC2B5)
	   (#x664E . #x8FC2B7)
	   (#x664F . #xDAE7)
	   (#x6651 . #x8FC2B6)
	   (#x6652 . #xBBAF)
	   (#x6657 . #x8FC2B8)
	   (#x6658 . #x8FC2B9)
	   (#x6659 . #x8FC2BA)
	   (#x665B . #x8FC2BB)
	   (#x665C . #x8FC2BC)
	   (#x665D . #xDAEC)
	   (#x665E . #xDAEB)
	   (#x665F . #xDAF0)
	   (#x6660 . #x8FC2BD)
	   (#x6661 . #x8FC2BE)
	   (#x6662 . #xDAF1)
	   (#x6664 . #xDAED)
	   (#x6666 . #xB3A2)
	   (#x6667 . #xDAEE)
	   (#x6668 . #xDAEF)
	   (#x6669 . #xC8D5)
	   (#x666A . #x8FC2C0)
	   (#x666B . #x8FC2C1)
	   (#x666C . #x8FC2C2)
	   (#x666E . #xC9E1)
	   (#x666F . #xB7CA)
	   (#x6670 . #xDAF2)
	   (#x6673 . #x8FC2C4)
	   (#x6674 . #xC0B2)
	   (#x6675 . #x8FC2C5)
	   (#x6676 . #xBEBD)
	   (#x6677 . #x8FC2C7)
	   (#x6678 . #x8FC2C8)
	   (#x6679 . #x8FC2C9)
	   (#x667A . #xC3D2)
	   (#x667B . #x8FC2CA)
	   (#x667C . #x8FC2CC)
	   (#x667E . #x8FC2C3)
	   (#x667F . #x8FC2C6)
	   (#x6680 . #x8FC2CB)
	   (#x6681 . #xB6C7)
	   (#x6683 . #xDAF3)
	   (#x6684 . #xDAF7)
	   (#x6687 . #xB2CB)
	   (#x6688 . #xDAF4)
	   (#x6689 . #xDAF6)
	   (#x668B . #x8FC2CD)
	   (#x668C . #x8FC2CE)
	   (#x668D . #x8FC2CF)
	   (#x668E . #xDAF5)
	   (#x6690 . #x8FC2D0)
	   (#x6691 . #xBDEB)
	   (#x6692 . #x8FC2D1)
	   (#x6696 . #xC3C8)
	   (#x6697 . #xB0C5)
	   (#x6698 . #xDAF8)
	   (#x6699 . #x8FC2D2)
	   (#x669A . #x8FC2D3)
	   (#x669B . #x8FC2D4)
	   (#x669C . #x8FC2D5)
	   (#x669D . #xDAF9)
	   (#x669F . #x8FC2D6)
	   (#x66A0 . #x8FC2D7)
	   (#x66A2 . #xC4AA)
	   (#x66A4 . #x8FC2D8)
	   (#x66A6 . #xCEF1)
	   (#x66AB . #xBBC3)
	   (#x66AD . #x8FC2D9)
	   (#x66AE . #xCAEB)
	   (#x66B1 . #x8FC2DA)
	   (#x66B2 . #x8FC2DB)
	   (#x66B4 . #xCBBD)
	   (#x66B5 . #x8FC2DC)
	   (#x66B8 . #xDBA2)
	   (#x66B9 . #xDAFB)
	   (#x66BB . #x8FC2DD)
	   (#x66BC . #xDAFE)
	   (#x66BE . #xDAFD)
	   (#x66BF . #x8FC2DE)
	   (#x66C0 . #x8FC2DF)
	   (#x66C1 . #xDAFA)
	   (#x66C2 . #x8FC2E0)
	   (#x66C3 . #x8FC2E1)
	   (#x66C4 . #xDBA1)
	   (#x66C7 . #xC6DE)
	   (#x66C8 . #x8FC2E2)
	   (#x66C9 . #xDAFC)
	   (#x66CC . #x8FC2E3)
	   (#x66CE . #x8FC2E4)
	   (#x66CF . #x8FC2E5)
	   (#x66D4 . #x8FC2E6)
	   (#x66D6 . #xDBA3)
	   (#x66D9 . #xBDEC)
	   (#x66DA . #xDBA4)
	   (#x66DB . #x8FC2E7)
	   (#x66DC . #xCDCB)
	   (#x66DD . #xC7F8)
	   (#x66DF . #x8FC2E8)
	   (#x66E0 . #xDBA5)
	   (#x66E6 . #xDBA7)
	   (#x66E8 . #x8FC2E9)
	   (#x66E9 . #xDBA8)
	   (#x66EB . #x8FC2EA)
	   (#x66EC . #x8FC2EB)
	   (#x66EE . #x8FC2EC)
	   (#x66F0 . #xDBA9)
	   (#x66F2 . #xB6CA)
	   (#x66F3 . #xB1C8)
	   (#x66F4 . #xB9B9)
	   (#x66F5 . #xDBAA)
	   (#x66F7 . #xDBAB)
	   (#x66F8 . #xBDF1)
	   (#x66F9 . #xC1E2)
	   (#x66FA . #x8FC2ED)
	   (#x66FB . #x8FC2BF)
	   (#x66FC . #xD2D8)
	   (#x66FD . #xC1BE)
	   (#x66FE . #xC1BD)
	   (#x66FF . #xC2D8)
	   (#x6700 . #xBAC7)
	   (#x6703 . #xD0F2)
	   (#x6705 . #x8FC2EE)
	   (#x6707 . #x8FC2EF)
	   (#x6708 . #xB7EE)
	   (#x6709 . #xCDAD)
	   (#x670B . #xCAFE)
	   (#x670D . #xC9FE)
	   (#x670E . #x8FC2F0)
	   (#x670F . #xDBAC)
	   (#x6713 . #x8FC2F1)
	   (#x6714 . #xBAF3)
	   (#x6715 . #xC4BF)
	   (#x6716 . #xDBAD)
	   (#x6717 . #xCFAF)
	   (#x6719 . #x8FC2F2)
	   (#x671B . #xCBBE)
	   (#x671C . #x8FC2F3)
	   (#x671D . #xC4AB)
	   (#x671E . #xDBAE)
	   (#x671F . #xB4FC)
	   (#x6720 . #x8FC2F4)
	   (#x6722 . #x8FC2F5)
	   (#x6726 . #xDBAF)
	   (#x6727 . #xDBB0)
	   (#x6728 . #xCCDA)
	   (#x672A . #xCCA4)
	   (#x672B . #xCBF6)
	   (#x672C . #xCBDC)
	   (#x672D . #xBBA5)
	   (#x672E . #xDBB2)
	   (#x6731 . #xBCEB)
	   (#x6733 . #x8FC2F6)
	   (#x6734 . #xCBD1)
	   (#x6736 . #xDBB4)
	   (#x6737 . #xDBB7)
	   (#x6738 . #xDBB6)
	   (#x673A . #xB4F9)
	   (#x673D . #xB5E0)
	   (#x673E . #x8FC2F7)
	   (#x673F . #xDBB3)
	   (#x6741 . #xDBB5)
	   (#x6745 . #x8FC2F8)
	   (#x6746 . #xDBB8)
	   (#x6747 . #x8FC2F9)
	   (#x6748 . #x8FC2FA)
	   (#x6749 . #xBFF9)
	   (#x674C . #x8FC2FB)
	   (#x674E . #xCDFB)
	   (#x674F . #xB0C9)
	   (#x6750 . #xBAE0)
	   (#x6751 . #xC2BC)
	   (#x6753 . #xBCDD)
	   (#x6754 . #x8FC2FC)
	   (#x6755 . #x8FC2FD)
	   (#x6756 . #xBEF3)
	   (#x6759 . #xDBBB)
	   (#x675C . #xC5CE)
	   (#x675D . #x8FC2FE)
	   (#x675E . #xDBB9)
	   (#x675F . #xC2AB)
	   (#x6760 . #xDBBA)
	   (#x6761 . #xBEF2)
	   (#x6762 . #xCCDD)
	   (#x6763 . #xDBBC)
	   (#x6764 . #xDBBD)
	   (#x6765 . #xCDE8)
	   (#x6766 . #x8FC3A1)
	   (#x676A . #xDBC2)
	   (#x676C . #x8FC3A2)
	   (#x676D . #xB9BA)
	   (#x676E . #x8FC3A3)
	   (#x676F . #xC7D5)
	   (#x6770 . #xDBBF)
	   (#x6771 . #xC5EC)
	   (#x6772 . #xDADE)
	   (#x6773 . #xDAE2)
	   (#x6774 . #x8FC3A4)
	   (#x6775 . #xB5CF)
	   (#x6776 . #x8FC3A5)
	   (#x6777 . #xC7C7)
	   (#x677B . #x8FC3A6)
	   (#x677C . #xDBC1)
	   (#x677E . #xBEBE)
	   (#x677F . #xC8C4)
	   (#x6781 . #x8FC3A7)
	   (#x6784 . #x8FC3A8)
	   (#x6785 . #xDBC7)
	   (#x6787 . #xC8FA)
	   (#x6789 . #xDBBE)
	   (#x678B . #xDBC4)
	   (#x678C . #xDBC3)
	   (#x678E . #x8FC3A9)
	   (#x678F . #x8FC3AA)
	   (#x6790 . #xC0CF)
	   (#x6791 . #x8FC3AB)
	   (#x6793 . #x8FC3AC)
	   (#x6795 . #xCBED)
	   (#x6796 . #x8FC3AD)
	   (#x6797 . #xCED3)
	   (#x6798 . #x8FC3AE)
	   (#x6799 . #x8FC3AF)
	   (#x679A . #xCBE7)
	   (#x679B . #x8FC3B0)
	   (#x679C . #xB2CC)
	   (#x679D . #xBBDE)
	   (#x67A0 . #xCFC8)
	   (#x67A1 . #xDBC6)
	   (#x67A2 . #xBFF5)
	   (#x67A6 . #xDBC5)
	   (#x67A9 . #xDBC0)
	   (#x67AF . #xB8CF)
	   (#x67B0 . #x8FC3B1)
	   (#x67B1 . #x8FC3B2)
	   (#x67B2 . #x8FC3B3)
	   (#x67B3 . #xDBCC)
	   (#x67B4 . #xDBCA)
	   (#x67B5 . #x8FC3B4)
	   (#x67B6 . #xB2CD)
	   (#x67B7 . #xDBC8)
	   (#x67B8 . #xDBCE)
	   (#x67B9 . #xDBD4)
	   (#x67BB . #x8FC3B5)
	   (#x67BC . #x8FC3B6)
	   (#x67BD . #x8FC3B7)
	   (#x67C0 . #x8FC3B9)
	   (#x67C1 . #xC2C8)
	   (#x67C2 . #x8FC3BA)
	   (#x67C3 . #x8FC3BB)
	   (#x67C4 . #xCAC1)
	   (#x67C5 . #x8FC3BC)
	   (#x67C6 . #xDBD6)
	   (#x67C8 . #x8FC3BD)
	   (#x67C9 . #x8FC3BE)
	   (#x67CA . #xC9A2)
	   (#x67CE . #xDBD5)
	   (#x67CF . #xC7F0)
	   (#x67D0 . #xCBBF)
	   (#x67D1 . #xB4BB)
	   (#x67D2 . #x8FC3BF)
	   (#x67D3 . #xC0F7)
	   (#x67D4 . #xBDC0)
	   (#x67D7 . #x8FC3C0)
	   (#x67D8 . #xC4D3)
	   (#x67D9 . #x8FC3C1)
	   (#x67DA . #xCDAE)
	   (#x67DC . #x8FC3C2)
	   (#x67DD . #xDBD1)
	   (#x67DE . #xDBD0)
	   (#x67E1 . #x8FC3C3)
	   (#x67E2 . #xDBD2)
	   (#x67E4 . #xDBCF)
	   (#x67E6 . #x8FC3C4)
	   (#x67E7 . #xDBD7)
	   (#x67E9 . #xDBCD)
	   (#x67EC . #xDBCB)
	   (#x67EE . #xDBD3)
	   (#x67EF . #xDBC9)
	   (#x67F0 . #x8FC3C5)
	   (#x67F1 . #xC3EC)
	   (#x67F2 . #x8FC3C6)
	   (#x67F3 . #xCCF8)
	   (#x67F4 . #xBCC6)
	   (#x67F5 . #xBAF4)
	   (#x67F6 . #x8FC3C7)
	   (#x67F7 . #x8FC3C8)
	   (#x67F9 . #x8FC3B8)
	   (#x67FB . #xBABA)
	   (#x67FE . #xCBEF)
	   (#x67FF . #xB3C1)
	   (#x6802 . #xC4CE)
	   (#x6803 . #xC6CA)
	   (#x6804 . #xB1C9)
	   (#x6813 . #xC0F2)
	   (#x6814 . #x8FC3CA)
	   (#x6816 . #xC0B4)
	   (#x6817 . #xB7AA)
	   (#x6819 . #x8FC3CB)
	   (#x681D . #x8FC3CC)
	   (#x681E . #xDBD9)
	   (#x681F . #x8FC3CD)
	   (#x6821 . #xB9BB)
	   (#x6822 . #xB3FC)
	   (#x6827 . #x8FC3CF)
	   (#x6828 . #x8FC3CE)
	   (#x6829 . #xDBDB)
	   (#x682A . #xB3F4)
	   (#x682B . #xDBE1)
	   (#x682C . #x8FC3D0)
	   (#x682D . #x8FC3D1)
	   (#x682F . #x8FC3D2)
	   (#x6830 . #x8FC3D3)
	   (#x6831 . #x8FC3D4)
	   (#x6832 . #xDBDE)
	   (#x6833 . #x8FC3D5)
	   (#x6834 . #xC0F3)
	   (#x6838 . #xB3CB)
	   (#x6839 . #xBAAC)
	   (#x683B . #x8FC3D6)
	   (#x683C . #xB3CA)
	   (#x683D . #xBACF)
	   (#x683F . #x8FC3D7)
	   (#x6840 . #xDBDC)
	   (#x6841 . #xB7E5)
	   (#x6842 . #xB7CB)
	   (#x6843 . #xC5ED)
	   (#x6844 . #x8FC3D8)
	   (#x6845 . #x8FC3D9)
	   (#x6846 . #xDBDA)
	   (#x6848 . #xB0C6)
	   (#x684A . #x8FC3DA)
	   (#x684C . #x8FC3DB)
	   (#x684D . #xDBDD)
	   (#x684E . #xDBDF)
	   (#x6850 . #xB6CD)
	   (#x6851 . #xB7AC)
	   (#x6852 . #x8FC3C9)
	   (#x6853 . #xB4BC)
	   (#x6854 . #xB5CB)
	   (#x6855 . #x8FC3DC)
	   (#x6857 . #x8FC3DD)
	   (#x6858 . #x8FC3DE)
	   (#x6859 . #xDBE2)
	   (#x685B . #x8FC3DF)
	   (#x685C . #xBAF9)
	   (#x685D . #xCBF1)
	   (#x685F . #xBBB7)
	   (#x6863 . #xDBE3)
	   (#x6867 . #xC9B0)
	   (#x686B . #x8FC3E0)
	   (#x686E . #x8FC3E1)
	   (#x686F . #x8FC3E2)
	   (#x6870 . #x8FC3E3)
	   (#x6871 . #x8FC3E4)
	   (#x6872 . #x8FC3E5)
	   (#x6874 . #xDBEF)
	   (#x6875 . #x8FC3E6)
	   (#x6876 . #xB2B3)
	   (#x6877 . #xDBE4)
	   (#x6879 . #x8FC3E7)
	   (#x687A . #x8FC3E8)
	   (#x687B . #x8FC3E9)
	   (#x687C . #x8FC3EA)
	   (#x687E . #xDBF5)
	   (#x687F . #xDBE5)
	   (#x6881 . #xCEC2)
	   (#x6882 . #x8FC3EB)
	   (#x6883 . #xDBEC)
	   (#x6884 . #x8FC3EC)
	   (#x6885 . #xC7DF)
	   (#x6886 . #x8FC3ED)
	   (#x6888 . #x8FC3EE)
	   (#x688D . #xDBF4)
	   (#x688F . #xDBE7)
	   (#x6893 . #xB0B4)
	   (#x6894 . #xDBE9)
	   (#x6896 . #x8FC3EF)
	   (#x6897 . #xB9BC)
	   (#x6898 . #x8FC3F0)
	   (#x689A . #x8FC3F1)
	   (#x689B . #xDBEB)
	   (#x689C . #x8FC3F2)
	   (#x689D . #xDBEA)
	   (#x689F . #xDBE6)
	   (#x68A0 . #xDBF1)
	   (#x68A1 . #x8FC3F3)
	   (#x68A2 . #xBEBF)
	   (#x68A3 . #x8FC3F4)
	   (#x68A5 . #x8FC3F5)
	   (#x68A6 . #xD4ED)
	   (#x68A7 . #xB8E8)
	   (#x68A8 . #xCDFC)
	   (#x68A9 . #x8FC3F6)
	   (#x68AA . #x8FC3F7)
	   (#x68AD . #xDBE8)
	   (#x68AE . #x8FC3F8)
	   (#x68AF . #xC4F4)
	   (#x68B0 . #xB3A3)
	   (#x68B1 . #xBAAD)
	   (#x68B2 . #x8FC3F9)
	   (#x68B3 . #xDBE0)
	   (#x68B5 . #xDBF0)
	   (#x68B6 . #xB3E1)
	   (#x68B9 . #xDBEE)
	   (#x68BA . #xDBF2)
	   (#x68BB . #x8FC3FA)
	   (#x68BC . #xC5EE)
	   (#x68C4 . #xB4FE)
	   (#x68C5 . #x8FC3FB)
	   (#x68C6 . #xDCB2)
	   (#x68C8 . #x8FC3FC)
	   (#x68C9 . #xCCC9)
	   (#x68CA . #xDBF7)
	   (#x68CB . #xB4FD)
	   (#x68CC . #x8FC3FD)
	   (#x68CD . #xDBFE)
	   (#x68CF . #x8FC3FE)
	   (#x68D0 . #x8FC4A1)
	   (#x68D1 . #x8FC4A2)
	   (#x68D2 . #xCBC0)
	   (#x68D3 . #x8FC4A3)
	   (#x68D4 . #xDCA1)
	   (#x68D5 . #xDCA3)
	   (#x68D6 . #x8FC4A4)
	   (#x68D7 . #xDCA7)
	   (#x68D8 . #xDBF9)
	   (#x68D9 . #x8FC4A5)
	   (#x68DA . #xC3AA)
	   (#x68DC . #x8FC4A6)
	   (#x68DD . #x8FC4A7)
	   (#x68DF . #xC5EF)
	   (#x68E0 . #xDCAB)
	   (#x68E1 . #xDBFC)
	   (#x68E3 . #xDCA8)
	   (#x68E5 . #x8FC4A8)
	   (#x68E7 . #xDCA2)
	   (#x68E8 . #x8FC4A9)
	   (#x68EA . #x8FC4AA)
	   (#x68EB . #x8FC4AB)
	   (#x68EC . #x8FC4AC)
	   (#x68ED . #x8FC4AD)
	   (#x68EE . #xBFB9)
	   (#x68EF . #xDCAC)
	   (#x68F0 . #x8FC4AE)
	   (#x68F1 . #x8FC4AF)
	   (#x68F2 . #xC0B3)
	   (#x68F5 . #x8FC4B0)
	   (#x68F6 . #x8FC4B1)
	   (#x68F9 . #xDCAA)
	   (#x68FA . #xB4BD)
	   (#x68FB . #x8FC4B2)
	   (#x68FC . #x8FC4B3)
	   (#x68FD . #x8FC4B4)
	   (#x6900 . #xCFD0)
	   (#x6901 . #xDBF6)
	   (#x6904 . #xDCA6)
	   (#x6905 . #xB0D8)
	   (#x6906 . #x8FC4B5)
	   (#x6908 . #xDBF8)
	   (#x6909 . #x8FC4B6)
	   (#x690A . #x8FC4B7)
	   (#x690B . #xCCBA)
	   (#x690C . #xDBFD)
	   (#x690D . #xBFA2)
	   (#x690E . #xC4C7)
	   (#x690F . #xDBF3)
	   (#x6910 . #x8FC4B8)
	   (#x6911 . #x8FC4B9)
	   (#x6912 . #xDCA5)
	   (#x6913 . #x8FC4BA)
	   (#x6916 . #x8FC4BB)
	   (#x6917 . #x8FC4BC)
	   (#x6919 . #xBFFA)
	   (#x691A . #xDCAF)
	   (#x691B . #xB3F1)
	   (#x691C . #xB8A1)
	   (#x6921 . #xDCB1)
	   (#x6922 . #xDBFA)
	   (#x6923 . #xDCB0)
	   (#x6925 . #xDCA9)
	   (#x6926 . #xDBFB)
	   (#x6928 . #xDCAD)
	   (#x692A . #xDCAE)
	   (#x6930 . #xDCBF)
	   (#x6931 . #x8FC4BD)
	   (#x6933 . #x8FC4BE)
	   (#x6934 . #xC6CE)
	   (#x6935 . #x8FC4BF)
	   (#x6936 . #xDCA4)
	   (#x6938 . #x8FC4C0)
	   (#x6939 . #xDCBB)
	   (#x693B . #x8FC4C1)
	   (#x693D . #xDCBD)
	   (#x693F . #xC4D8)
	   (#x6942 . #x8FC4C2)
	   (#x6945 . #x8FC4C3)
	   (#x6949 . #x8FC4C4)
	   (#x694A . #xCDCC)
	   (#x694E . #x8FC4C5)
	   (#x6953 . #xC9F6)
	   (#x6954 . #xDCB8)
	   (#x6955 . #xC2CA)
	   (#x6957 . #x8FC4C6)
	   (#x6959 . #xDCBE)
	   (#x695A . #xC1BF)
	   (#x695B . #x8FC4C7)
	   (#x695C . #xDCB5)
	   (#x695D . #xDCC2)
	   (#x695E . #xDCC1)
	   (#x6960 . #xC6EF)
	   (#x6961 . #xDCC0)
	   (#x6962 . #xC6EA)
	   (#x6963 . #x8FC4C8)
	   (#x6964 . #x8FC4C9)
	   (#x6965 . #x8FC4CA)
	   (#x6966 . #x8FC4CB)
	   (#x6968 . #x8FC4CC)
	   (#x6969 . #x8FC4CD)
	   (#x696A . #xDCC4)
	   (#x696B . #xDCB7)
	   (#x696C . #x8FC4CE)
	   (#x696D . #xB6C8)
	   (#x696E . #xDCBA)
	   (#x696F . #xBDDD)
	   (#x6970 . #x8FC4CF)
	   (#x6971 . #x8FC4D0)
	   (#x6972 . #x8FC4D1)
	   (#x6973 . #xC7E0)
	   (#x6974 . #xDCBC)
	   (#x6975 . #xB6CB)
	   (#x6977 . #xDCB4)
	   (#x6978 . #xDCB6)
	   (#x6979 . #xDCB3)
	   (#x697A . #x8FC4D2)
	   (#x697B . #x8FC4D3)
	   (#x697C . #xCFB0)
	   (#x697D . #xB3DA)
	   (#x697E . #xDCB9)
	   (#x697F . #x8FC4D4)
	   (#x6980 . #x8FC4D5)
	   (#x6981 . #xDCC3)
	   (#x6982 . #xB3B5)
	   (#x698A . #xBAE7)
	   (#x698D . #x8FC4D6)
	   (#x698E . #xB1DD)
	   (#x6991 . #xDCD4)
	   (#x6992 . #x8FC4D7)
	   (#x6994 . #xCFB1)
	   (#x6995 . #xDCD7)
	   (#x6996 . #x8FC4D8)
	   (#x6998 . #x8FC4D9)
	   (#x699B . #xBFBA)
	   (#x699C . #xDCD6)
	   (#x69A0 . #xDCD5)
	   (#x69A1 . #x8FC4DA)
	   (#x69A5 . #x8FC4DB)
	   (#x69A6 . #x8FC4DC)
	   (#x69A7 . #xDCD2)
	   (#x69A8 . #x8FC4DD)
	   (#x69AB . #x8FC4DE)
	   (#x69AD . #x8FC4DF)
	   (#x69AE . #xDCC6)
	   (#x69AF . #x8FC4E0)
	   (#x69B1 . #xDCE3)
	   (#x69B2 . #xDCC5)
	   (#x69B4 . #xDCD8)
	   (#x69B7 . #x8FC4E1)
	   (#x69B8 . #x8FC4E2)
	   (#x69BA . #x8FC4E3)
	   (#x69BB . #xDCD0)
	   (#x69BC . #x8FC4E4)
	   (#x69BE . #xDCCB)
	   (#x69BF . #xDCC8)
	   (#x69C1 . #xDCC9)
	   (#x69C3 . #xDCD1)
	   (#x69C5 . #x8FC4E5)
	   (#x69C7 . #xF4A2)
	   (#x69C8 . #x8FC4E6)
	   (#x69CA . #xDCCE)
	   (#x69CB . #xB9BD)
	   (#x69CC . #xC4C8)
	   (#x69CD . #xC1E4)
	   (#x69CE . #xDCCC)
	   (#x69D0 . #xDCC7)
	   (#x69D1 . #x8FC4E7)
	   (#x69D3 . #xDCCA)
	   (#x69D6 . #x8FC4E8)
	   (#x69D7 . #x8FC4E9)
	   (#x69D8 . #xCDCD)
	   (#x69D9 . #xCBEA)
	   (#x69DD . #xDCCF)
	   (#x69DE . #xDCD9)
	   (#x69E2 . #x8FC4EA)
	   (#x69E5 . #x8FC4EB)
	   (#x69E7 . #xDCE1)
	   (#x69E8 . #xDCDA)
	   (#x69EB . #xDCE7)
	   (#x69ED . #xDCE5)
	   (#x69EE . #x8FC4EC)
	   (#x69EF . #x8FC4ED)
	   (#x69F1 . #x8FC4EE)
	   (#x69F2 . #xDCE0)
	   (#x69F3 . #x8FC4EF)
	   (#x69F5 . #x8FC4F0)
	   (#x69F9 . #xDCDF)
	   (#x69FB . #xC4D0)
	   (#x69FD . #xC1E5)
	   (#x69FE . #x8FC4F1)
	   (#x69FF . #xDCDD)
	   (#x6A00 . #x8FC4F2)
	   (#x6A01 . #x8FC4F3)
	   (#x6A02 . #xDCDB)
	   (#x6A03 . #x8FC4F4)
	   (#x6A05 . #xDCE2)
	   (#x6A0A . #xDCE8)
	   (#x6A0B . #xC8F5)
	   (#x6A0C . #xDCEE)
	   (#x6A0F . #x8FC4F5)
	   (#x6A11 . #x8FC4F6)
	   (#x6A12 . #xDCE9)
	   (#x6A13 . #xDCEC)
	   (#x6A14 . #xDCE6)
	   (#x6A15 . #x8FC4F7)
	   (#x6A17 . #xC3F4)
	   (#x6A19 . #xC9B8)
	   (#x6A1A . #x8FC4F8)
	   (#x6A1B . #xDCDC)
	   (#x6A1D . #x8FC4F9)
	   (#x6A1E . #xDCE4)
	   (#x6A1F . #xBEC0)
	   (#x6A20 . #x8FC4FA)
	   (#x6A21 . #xCCCF)
	   (#x6A22 . #xDCF8)
	   (#x6A23 . #xDCEB)
	   (#x6A24 . #x8FC4FB)
	   (#x6A28 . #x8FC4FC)
	   (#x6A29 . #xB8A2)
	   (#x6A2A . #xB2A3)
	   (#x6A2B . #xB3DF)
	   (#x6A2E . #xDCD3)
	   (#x6A30 . #x8FC4FD)
	   (#x6A32 . #x8FC4FE)
	   (#x6A34 . #x8FC5A1)
	   (#x6A35 . #xBEC1)
	   (#x6A36 . #xDCF0)
	   (#x6A37 . #x8FC5A2)
	   (#x6A38 . #xDCF7)
	   (#x6A39 . #xBCF9)
	   (#x6A3A . #xB3F2)
	   (#x6A3B . #x8FC5A3)
	   (#x6A3D . #xC3AE)
	   (#x6A3E . #x8FC5A4)
	   (#x6A3F . #x8FC5A5)
	   (#x6A44 . #xDCED)
	   (#x6A45 . #x8FC5A6)
	   (#x6A46 . #x8FC5A7)
	   (#x6A47 . #xDCF2)
	   (#x6A48 . #xDCF6)
	   (#x6A49 . #x8FC5A8)
	   (#x6A4A . #x8FC5A9)
	   (#x6A4B . #xB6B6)
	   (#x6A4E . #x8FC5AA)
	   (#x6A50 . #x8FC5AB)
	   (#x6A51 . #x8FC5AC)
	   (#x6A52 . #x8FC5AD)
	   (#x6A55 . #x8FC5AE)
	   (#x6A56 . #x8FC5AF)
	   (#x6A58 . #xB5CC)
	   (#x6A59 . #xDCF4)
	   (#x6A5B . #x8FC5B0)
	   (#x6A5F . #xB5A1)
	   (#x6A61 . #xC6CB)
	   (#x6A62 . #xDCF3)
	   (#x6A64 . #x8FC5B1)
	   (#x6A66 . #xDCF5)
	   (#x6A67 . #x8FC5B2)
	   (#x6A6A . #x8FC5B3)
	   (#x6A71 . #x8FC5B4)
	   (#x6A72 . #xDCEF)
	   (#x6A73 . #x8FC5B5)
	   (#x6A78 . #xDCF1)
	   (#x6A7E . #x8FC5B6)
	   (#x6A7F . #xB3E0)
	   (#x6A80 . #xC3C9)
	   (#x6A81 . #x8FC5B7)
	   (#x6A83 . #x8FC5B8)
	   (#x6A84 . #xDCFC)
	   (#x6A86 . #x8FC5B9)
	   (#x6A87 . #x8FC5BA)
	   (#x6A89 . #x8FC5BB)
	   (#x6A8B . #x8FC5BC)
	   (#x6A8D . #xDCFA)
	   (#x6A8E . #xB8E9)
	   (#x6A90 . #xDCF9)
	   (#x6A91 . #x8FC5BD)
	   (#x6A97 . #xDDA1)
	   (#x6A9B . #x8FC5BE)
	   (#x6A9C . #xDBD8)
	   (#x6A9D . #x8FC5BF)
	   (#x6A9E . #x8FC5C0)
	   (#x6A9F . #x8FC5C1)
	   (#x6AA0 . #xDCFB)
	   (#x6AA2 . #xDCFD)
	   (#x6AA3 . #xDCFE)
	   (#x6AA5 . #x8FC5C2)
	   (#x6AAA . #xDDAC)
	   (#x6AAB . #x8FC5C3)
	   (#x6AAC . #xDDA8)
	   (#x6AAE . #xDBED)
	   (#x6AAF . #x8FC5C4)
	   (#x6AB0 . #x8FC5C5)
	   (#x6AB1 . #x8FC5C6)
	   (#x6AB3 . #xDDA7)
	   (#x6AB4 . #x8FC5C7)
	   (#x6AB8 . #xDDA6)
	   (#x6ABB . #xDDA3)
	   (#x6ABD . #x8FC5C8)
	   (#x6ABE . #x8FC5C9)
	   (#x6ABF . #x8FC5CA)
	   (#x6AC1 . #xDCEA)
	   (#x6AC2 . #xDDA5)
	   (#x6AC3 . #xDDA4)
	   (#x6AC6 . #x8FC5CB)
	   (#x6AC8 . #x8FC5CD)
	   (#x6AC9 . #x8FC5CC)
	   (#x6ACC . #x8FC5CE)
	   (#x6AD0 . #x8FC5CF)
	   (#x6AD1 . #xDDAA)
	   (#x6AD3 . #xCFA6)
	   (#x6AD4 . #x8FC5D0)
	   (#x6AD5 . #x8FC5D1)
	   (#x6AD6 . #x8FC5D2)
	   (#x6ADA . #xDDAD)
	   (#x6ADB . #xB6FB)
	   (#x6ADC . #x8FC5D3)
	   (#x6ADD . #x8FC5D4)
	   (#x6ADE . #xDDA9)
	   (#x6ADF . #xDDAB)
	   (#x6AE4 . #x8FC5D5)
	   (#x6AE7 . #x8FC5D6)
	   (#x6AE8 . #xC8A7)
	   (#x6AEA . #xDDAE)
	   (#x6AEC . #x8FC5D7)
	   (#x6AF0 . #x8FC5D8)
	   (#x6AF1 . #x8FC5D9)
	   (#x6AF2 . #x8FC5DA)
	   (#x6AFA . #xDDB2)
	   (#x6AFB . #xDDAF)
	   (#x6AFC . #x8FC5DB)
	   (#x6AFD . #x8FC5DC)
	   (#x6B02 . #x8FC5DD)
	   (#x6B03 . #x8FC5DE)
	   (#x6B04 . #xCDF3)
	   (#x6B05 . #xDDB0)
	   (#x6B06 . #x8FC5DF)
	   (#x6B07 . #x8FC5E0)
	   (#x6B09 . #x8FC5E1)
	   (#x6B0A . #xDCDE)
	   (#x6B0F . #x8FC5E2)
	   (#x6B10 . #x8FC5E3)
	   (#x6B11 . #x8FC5E4)
	   (#x6B12 . #xDDB3)
	   (#x6B16 . #xDDB4)
	   (#x6B17 . #x8FC5E5)
	   (#x6B1B . #x8FC5E6)
	   (#x6B1D . #xB1B5)
	   (#x6B1E . #x8FC5E7)
	   (#x6B1F . #xDDB6)
	   (#x6B20 . #xB7E7)
	   (#x6B21 . #xBCA1)
	   (#x6B23 . #xB6D5)
	   (#x6B24 . #x8FC5E8)
	   (#x6B27 . #xB2A4)
	   (#x6B28 . #x8FC5E9)
	   (#x6B2B . #x8FC5EA)
	   (#x6B2C . #x8FC5EB)
	   (#x6B2F . #x8FC5EC)
	   (#x6B32 . #xCDDF)
	   (#x6B35 . #x8FC5ED)
	   (#x6B36 . #x8FC5EE)
	   (#x6B37 . #xDDB8)
	   (#x6B38 . #xDDB7)
	   (#x6B39 . #xDDBA)
	   (#x6B3A . #xB5BD)
	   (#x6B3B . #x8FC5EF)
	   (#x6B3D . #xB6D6)
	   (#x6B3E . #xB4BE)
	   (#x6B3F . #x8FC5F0)
	   (#x6B43 . #xDDBD)
	   (#x6B46 . #x8FC5F1)
	   (#x6B47 . #xDDBC)
	   (#x6B49 . #xDDBE)
	   (#x6B4A . #x8FC5F2)
	   (#x6B4C . #xB2CE)
	   (#x6B4D . #x8FC5F3)
	   (#x6B4E . #xC3B7)
	   (#x6B50 . #xDDBF)
	   (#x6B52 . #x8FC5F4)
	   (#x6B53 . #xB4BF)
	   (#x6B54 . #xDDC1)
	   (#x6B56 . #x8FC5F5)
	   (#x6B58 . #x8FC5F6)
	   (#x6B59 . #xDDC0)
	   (#x6B5B . #xDDC2)
	   (#x6B5D . #x8FC5F7)
	   (#x6B5F . #xDDC3)
	   (#x6B60 . #x8FC5F8)
	   (#x6B61 . #xDDC4)
	   (#x6B62 . #xBBDF)
	   (#x6B63 . #xC0B5)
	   (#x6B64 . #xBAA1)
	   (#x6B66 . #xC9F0)
	   (#x6B67 . #x8FC5F9)
	   (#x6B69 . #xCAE2)
	   (#x6B6A . #xCFC4)
	   (#x6B6B . #x8FC5FA)
	   (#x6B6E . #x8FC5FB)
	   (#x6B6F . #xBBF5)
	   (#x6B70 . #x8FC5FC)
	   (#x6B73 . #xBAD0)
	   (#x6B74 . #xCEF2)
	   (#x6B75 . #x8FC5FD)
	   (#x6B78 . #xDDC5)
	   (#x6B79 . #xDDC6)
	   (#x6B7B . #xBBE0)
	   (#x6B7D . #x8FC5FE)
	   (#x6B7E . #x8FC6A1)
	   (#x6B7F . #xDDC7)
	   (#x6B80 . #xDDC8)
	   (#x6B82 . #x8FC6A2)
	   (#x6B83 . #xDDCA)
	   (#x6B84 . #xDDC9)
	   (#x6B85 . #x8FC6A3)
	   (#x6B86 . #xCBD8)
	   (#x6B89 . #xBDDE)
	   (#x6B8A . #xBCEC)
	   (#x6B8B . #xBBC4)
	   (#x6B8D . #xDDCB)
	   (#x6B95 . #xDDCD)
	   (#x6B96 . #xBFA3)
	   (#x6B97 . #x8FC6A4)
	   (#x6B98 . #xDDCC)
	   (#x6B9B . #x8FC6A5)
	   (#x6B9E . #xDDCE)
	   (#x6B9F . #x8FC6A6)
	   (#x6BA0 . #x8FC6A7)
	   (#x6BA2 . #x8FC6A8)
	   (#x6BA3 . #x8FC6A9)
	   (#x6BA4 . #xDDCF)
	   (#x6BA8 . #x8FC6AA)
	   (#x6BA9 . #x8FC6AB)
	   (#x6BAA . #xDDD0)
	   (#x6BAB . #xDDD1)
	   (#x6BAC . #x8FC6AC)
	   (#x6BAD . #x8FC6AD)
	   (#x6BAE . #x8FC6AE)
	   (#x6BAF . #xDDD2)
	   (#x6BB0 . #x8FC6AF)
	   (#x6BB1 . #xDDD4)
	   (#x6BB2 . #xDDD3)
	   (#x6BB3 . #xDDD5)
	   (#x6BB4 . #xB2A5)
	   (#x6BB5 . #xC3CA)
	   (#x6BB7 . #xDDD6)
	   (#x6BB8 . #x8FC6B0)
	   (#x6BB9 . #x8FC6B1)
	   (#x6BBA . #xBBA6)
	   (#x6BBB . #xB3CC)
	   (#x6BBC . #xDDD7)
	   (#x6BBD . #x8FC6B2)
	   (#x6BBE . #x8FC6B3)
	   (#x6BBF . #xC5C2)
	   (#x6BC0 . #xD4CC)
	   (#x6BC3 . #x8FC6B4)
	   (#x6BC4 . #x8FC6B5)
	   (#x6BC5 . #xB5A3)
	   (#x6BC6 . #xDDD8)
	   (#x6BC9 . #x8FC6B6)
	   (#x6BCB . #xDDD9)
	   (#x6BCC . #x8FC6B7)
	   (#x6BCD . #xCAEC)
	   (#x6BCE . #xCBE8)
	   (#x6BD2 . #xC6C7)
	   (#x6BD3 . #xDDDA)
	   (#x6BD4 . #xC8E6)
	   (#x6BD6 . #x8FC6B8)
	   (#x6BD8 . #xC8FB)
	   (#x6BDA . #x8FC6B9)
	   (#x6BDB . #xCCD3)
	   (#x6BDF . #xDDDB)
	   (#x6BE1 . #x8FC6BA)
	   (#x6BE3 . #x8FC6BB)
	   (#x6BE6 . #x8FC6BC)
	   (#x6BE7 . #x8FC6BD)
	   (#x6BEB . #xDDDD)
	   (#x6BEC . #xDDDC)
	   (#x6BEE . #x8FC6BE)
	   (#x6BEF . #xDDDF)
	   (#x6BF1 . #x8FC6BF)
	   (#x6BF3 . #xDDDE)
	   (#x6BF7 . #x8FC6C0)
	   (#x6BF9 . #x8FC6C1)
	   (#x6BFF . #x8FC6C2)
	   (#x6C02 . #x8FC6C3)
	   (#x6C04 . #x8FC6C4)
	   (#x6C05 . #x8FC6C5)
	   (#x6C08 . #xDDE1)
	   (#x6C09 . #x8FC6C6)
	   (#x6C0D . #x8FC6C7)
	   (#x6C0E . #x8FC6C8)
	   (#x6C0F . #xBBE1)
	   (#x6C10 . #x8FC6C9)
	   (#x6C11 . #xCCB1)
	   (#x6C12 . #x8FC6CA)
	   (#x6C13 . #xDDE2)
	   (#x6C14 . #xDDE3)
	   (#x6C17 . #xB5A4)
	   (#x6C19 . #x8FC6CB)
	   (#x6C1B . #xDDE4)
	   (#x6C1F . #x8FC6CC)
	   (#x6C23 . #xDDE6)
	   (#x6C24 . #xDDE5)
	   (#x6C26 . #x8FC6CD)
	   (#x6C27 . #x8FC6CE)
	   (#x6C28 . #x8FC6CF)
	   (#x6C2C . #x8FC6D0)
	   (#x6C2E . #x8FC6D1)
	   (#x6C33 . #x8FC6D2)
	   (#x6C34 . #xBFE5)
	   (#x6C35 . #x8FC6D3)
	   (#x6C36 . #x8FC6D4)
	   (#x6C37 . #xC9B9)
	   (#x6C38 . #xB1CA)
	   (#x6C3A . #x8FC6D5)
	   (#x6C3B . #x8FC6D6)
	   (#x6C3E . #xC8C5)
	   (#x6C3F . #x8FC6D7)
	   (#x6C40 . #xC4F5)
	   (#x6C41 . #xBDC1)
	   (#x6C42 . #xB5E1)
	   (#x6C4A . #x8FC6D8)
	   (#x6C4B . #x8FC6D9)
	   (#x6C4D . #x8FC6DA)
	   (#x6C4E . #xC8C6)
	   (#x6C4F . #x8FC6DB)
	   (#x6C50 . #xBCAE)
	   (#x6C52 . #x8FC6DC)
	   (#x6C54 . #x8FC6DD)
	   (#x6C55 . #xDDE8)
	   (#x6C57 . #xB4C0)
	   (#x6C59 . #x8FC6DE)
	   (#x6C5A . #xB1F8)
	   (#x6C5B . #x8FC6DF)
	   (#x6C5C . #x8FC6E0)
	   (#x6C5D . #xC6F2)
	   (#x6C5E . #xDDE7)
	   (#x6C5F . #xB9BE)
	   (#x6C60 . #xC3D3)
	   (#x6C62 . #xDDE9)
	   (#x6C67 . #x8FC7B6)
	   (#x6C68 . #xDDF1)
	   (#x6C6A . #xDDEA)
	   (#x6C6B . #x8FC6E1)
	   (#x6C6D . #x8FC6E2)
	   (#x6C6F . #x8FC6E3)
	   (#x6C70 . #xC2C1)
	   (#x6C72 . #xB5E2)
	   (#x6C73 . #xDDF2)
	   (#x6C74 . #x8FC6E4)
	   (#x6C76 . #x8FC6E5)
	   (#x6C78 . #x8FC6E6)
	   (#x6C79 . #x8FC6E7)
	   (#x6C7A . #xB7E8)
	   (#x6C7B . #x8FC6E8)
	   (#x6C7D . #xB5A5)
	   (#x6C7E . #xDDF0)
	   (#x6C81 . #xDDEE)
	   (#x6C82 . #xDDEB)
	   (#x6C83 . #xCDE0)
	   (#x6C85 . #x8FC6E9)
	   (#x6C86 . #x8FC6EA)
	   (#x6C87 . #x8FC6EB)
	   (#x6C88 . #xC4C0)
	   (#x6C89 . #x8FC6EC)
	   (#x6C8C . #xC6D9)
	   (#x6C8D . #xDDEC)
	   (#x6C90 . #xDDF4)
	   (#x6C92 . #xDDF3)
	   (#x6C93 . #xB7A3)
	   (#x6C94 . #x8FC6ED)
	   (#x6C95 . #x8FC6EE)
	   (#x6C96 . #xB2AD)
	   (#x6C97 . #x8FC6EF)
	   (#x6C98 . #x8FC6F0)
	   (#x6C99 . #xBABB)
	   (#x6C9A . #xDDED)
	   (#x6C9B . #xDDEF)
	   (#x6C9C . #x8FC6F1)
	   (#x6C9F . #x8FC6F2)
	   (#x6CA1 . #xCBD7)
	   (#x6CA2 . #xC2F4)
	   (#x6CAB . #xCBF7)
	   (#x6CAE . #xDDFC)
	   (#x6CB0 . #x8FC6F3)
	   (#x6CB1 . #xDDFD)
	   (#x6CB2 . #x8FC6F4)
	   (#x6CB3 . #xB2CF)
	   (#x6CB4 . #x8FC6F5)
	   (#x6CB8 . #xCAA8)
	   (#x6CB9 . #xCCFD)
	   (#x6CBA . #xDEA1)
	   (#x6CBB . #xBCA3)
	   (#x6CBC . #xBEC2)
	   (#x6CBD . #xDDF8)
	   (#x6CBE . #xDDFE)
	   (#x6CBF . #xB1E8)
	   (#x6CC1 . #xB6B7)
	   (#x6CC2 . #x8FC6F6)
	   (#x6CC4 . #xDDF5)
	   (#x6CC5 . #xDDFA)
	   (#x6CC6 . #x8FC6F7)
	   (#x6CC9 . #xC0F4)
	   (#x6CCA . #xC7F1)
	   (#x6CCC . #xC8E7)
	   (#x6CCD . #x8FC6F8)
	   (#x6CCF . #x8FC6F9)
	   (#x6CD0 . #x8FC6FA)
	   (#x6CD1 . #x8FC6FB)
	   (#x6CD2 . #x8FC6FC)
	   (#x6CD3 . #xDDF7)
	   (#x6CD4 . #x8FC6FD)
	   (#x6CD5 . #xCBA1)
	   (#x6CD6 . #x8FC6FE)
	   (#x6CD7 . #xDDF9)
	   (#x6CD9 . #xDEA4)
	   (#x6CDA . #x8FC7A1)
	   (#x6CDB . #xDEA2)
	   (#x6CDC . #x8FC7A2)
	   (#x6CDD . #xDDFB)
	   (#x6CE0 . #x8FC7A3)
	   (#x6CE1 . #xCBA2)
	   (#x6CE2 . #xC7C8)
	   (#x6CE3 . #xB5E3)
	   (#x6CE5 . #xC5A5)
	   (#x6CE7 . #x8FC7A4)
	   (#x6CE8 . #xC3ED)
	   (#x6CE9 . #x8FC7A5)
	   (#x6CEA . #xDEA5)
	   (#x6CEB . #x8FC7A6)
	   (#x6CEC . #x8FC7A7)
	   (#x6CEE . #x8FC7A8)
	   (#x6CEF . #xDEA3)
	   (#x6CF0 . #xC2D9)
	   (#x6CF1 . #xDDF6)
	   (#x6CF2 . #x8FC7A9)
	   (#x6CF3 . #xB1CB)
	   (#x6CF4 . #x8FC7AA)
	   (#x6D04 . #x8FC7AB)
	   (#x6D07 . #x8FC7AC)
	   (#x6D0A . #x8FC7AD)
	   (#x6D0B . #xCDCE)
	   (#x6D0C . #xDEB0)
	   (#x6D0E . #x8FC7AE)
	   (#x6D0F . #x8FC7AF)
	   (#x6D11 . #x8FC7B0)
	   (#x6D12 . #xDEAF)
	   (#x6D13 . #x8FC7B1)
	   (#x6D17 . #xC0F6)
	   (#x6D19 . #xDEAC)
	   (#x6D1A . #x8FC7B2)
	   (#x6D1B . #xCDEC)
	   (#x6D1E . #xC6B6)
	   (#x6D1F . #xDEA6)
	   (#x6D25 . #xC4C5)
	   (#x6D26 . #x8FC7B3)
	   (#x6D27 . #x8FC7B4)
	   (#x6D28 . #x8FC7B5)
	   (#x6D29 . #xB1CC)
	   (#x6D2A . #xB9BF)
	   (#x6D2B . #xDEA9)
	   (#x6D2E . #x8FC7B7)
	   (#x6D2F . #x8FC7B8)
	   (#x6D31 . #x8FC7B9)
	   (#x6D32 . #xBDA7)
	   (#x6D33 . #xDEAE)
	   (#x6D35 . #xDEAD)
	   (#x6D36 . #xDEA8)
	   (#x6D38 . #xDEAB)
	   (#x6D39 . #x8FC7BA)
	   (#x6D3B . #xB3E8)
	   (#x6D3C . #x8FC7BB)
	   (#x6D3D . #xDEAA)
	   (#x6D3E . #xC7C9)
	   (#x6D3F . #x8FC7BC)
	   (#x6D41 . #xCEAE)
	   (#x6D44 . #xBEF4)
	   (#x6D45 . #xC0F5)
	   (#x6D57 . #x8FC7BD)
	   (#x6D59 . #xDEB6)
	   (#x6D5A . #xDEB4)
	   (#x6D5C . #xC9CD)
	   (#x6D5E . #x8FC7BE)
	   (#x6D5F . #x8FC7BF)
	   (#x6D61 . #x8FC7C0)
	   (#x6D63 . #xDEB1)
	   (#x6D64 . #xDEB3)
	   (#x6D65 . #x8FC7C1)
	   (#x6D66 . #xB1BA)
	   (#x6D67 . #x8FC7C2)
	   (#x6D69 . #xB9C0)
	   (#x6D6A . #xCFB2)
	   (#x6D6C . #xB3BD)
	   (#x6D6E . #xC9E2)
	   (#x6D6F . #x8FC7C3)
	   (#x6D70 . #x8FC7C4)
	   (#x6D74 . #xCDE1)
	   (#x6D77 . #xB3A4)
	   (#x6D78 . #xBFBB)
	   (#x6D79 . #xDEB5)
	   (#x6D7C . #x8FC7C5)
	   (#x6D82 . #x8FC7C6)
	   (#x6D85 . #xDEBA)
	   (#x6D87 . #x8FC7C7)
	   (#x6D88 . #xBEC3)
	   (#x6D8C . #xCDB0)
	   (#x6D8E . #xDEB7)
	   (#x6D91 . #x8FC7C8)
	   (#x6D92 . #x8FC7C9)
	   (#x6D93 . #xDEB2)
	   (#x6D94 . #x8FC7CA)
	   (#x6D95 . #xDEB8)
	   (#x6D96 . #x8FC7CB)
	   (#x6D97 . #x8FC7CC)
	   (#x6D98 . #x8FC7CD)
	   (#x6D99 . #xCEDE)
	   (#x6D9B . #xC5F3)
	   (#x6D9C . #xC6C2)
	   (#x6DAA . #x8FC7CE)
	   (#x6DAC . #x8FC7CF)
	   (#x6DAF . #xB3B6)
	   (#x6DB2 . #xB1D5)
	   (#x6DB4 . #x8FC7D0)
	   (#x6DB5 . #xDEBE)
	   (#x6DB7 . #x8FC7D1)
	   (#x6DB8 . #xDEC1)
	   (#x6DB9 . #x8FC7D2)
	   (#x6DBC . #xCEC3)
	   (#x6DBD . #x8FC7D3)
	   (#x6DBF . #x8FC7D4)
	   (#x6DC0 . #xCDE4)
	   (#x6DC4 . #x8FC7D5)
	   (#x6DC5 . #xDEC8)
	   (#x6DC6 . #xDEC2)
	   (#x6DC7 . #xDEBF)
	   (#x6DC8 . #x8FC7D6)
	   (#x6DCA . #x8FC7D7)
	   (#x6DCB . #xCED4)
	   (#x6DCC . #xDEC5)
	   (#x6DCE . #x8FC7D8)
	   (#x6DCF . #x8FC7D9)
	   (#x6DD1 . #xBDCA)
	   (#x6DD2 . #xDEC7)
	   (#x6DD5 . #xDECC)
	   (#x6DD6 . #x8FC7DA)
	   (#x6DD8 . #xC5F1)
	   (#x6DD9 . #xDECA)
	   (#x6DDB . #x8FC7DB)
	   (#x6DDD . #x8FC7DC)
	   (#x6DDE . #xDEC4)
	   (#x6DDF . #x8FC7DD)
	   (#x6DE0 . #x8FC7DE)
	   (#x6DE1 . #xC3B8)
	   (#x6DE2 . #x8FC7DF)
	   (#x6DE4 . #xDECB)
	   (#x6DE5 . #x8FC7E0)
	   (#x6DE6 . #xDEC0)
	   (#x6DE8 . #xDEC6)
	   (#x6DE9 . #x8FC7E1)
	   (#x6DEA . #xDECD)
	   (#x6DEB . #xB0FC)
	   (#x6DEC . #xDEC3)
	   (#x6DEE . #xDECE)
	   (#x6DEF . #x8FC7E2)
	   (#x6DF0 . #x8FC7E3)
	   (#x6DF1 . #xBFBC)
	   (#x6DF3 . #xBDDF)
	   (#x6DF4 . #x8FC7E4)
	   (#x6DF5 . #xCAA5)
	   (#x6DF6 . #x8FC7E5)
	   (#x6DF7 . #xBAAE)
	   (#x6DF9 . #xDEBB)
	   (#x6DFA . #xDEC9)
	   (#x6DFB . #xC5BA)
	   (#x6DFC . #x8FC7E6)
	   (#x6E00 . #x8FC7E7)
	   (#x6E04 . #x8FC7E8)
	   (#x6E05 . #xC0B6)
	   (#x6E07 . #xB3E9)
	   (#x6E08 . #xBAD1)
	   (#x6E09 . #xBEC4)
	   (#x6E0A . #xDEBD)
	   (#x6E0B . #xBDC2)
	   (#x6E13 . #xB7CC)
	   (#x6E15 . #xDEBC)
	   (#x6E19 . #xDED2)
	   (#x6E1A . #xBDED)
	   (#x6E1B . #xB8BA)
	   (#x6E1D . #xDEE1)
	   (#x6E1E . #x8FC7E9)
	   (#x6E1F . #xDEDB)
	   (#x6E20 . #xB5F4)
	   (#x6E21 . #xC5CF)
	   (#x6E22 . #x8FC7EA)
	   (#x6E23 . #xDED6)
	   (#x6E24 . #xDEDF)
	   (#x6E25 . #xB0AF)
	   (#x6E26 . #xB1B2)
	   (#x6E27 . #x8FC7EB)
	   (#x6E29 . #xB2B9)
	   (#x6E2B . #xDED8)
	   (#x6E2C . #xC2AC)
	   (#x6E2D . #xDECF)
	   (#x6E2E . #xDED1)
	   (#x6E2F . #xB9C1)
	   (#x6E32 . #x8FC7EC)
	   (#x6E36 . #x8FC7ED)
	   (#x6E38 . #xDEE2)
	   (#x6E39 . #x8FC7EE)
	   (#x6E3A . #xDEDD)
	   (#x6E3B . #x8FC7EF)
	   (#x6E3C . #x8FC7F0)
	   (#x6E3E . #xDED5)
	   (#x6E43 . #xDEDC)
	   (#x6E44 . #x8FC7F1)
	   (#x6E45 . #x8FC7F2)
	   (#x6E48 . #x8FC7F3)
	   (#x6E49 . #x8FC7F4)
	   (#x6E4A . #xCCAB)
	   (#x6E4B . #x8FC7F5)
	   (#x6E4D . #xDEDA)
	   (#x6E4E . #xDEDE)
	   (#x6E4F . #x8FC7F6)
	   (#x6E51 . #x8FC7F7)
	   (#x6E52 . #x8FC7F8)
	   (#x6E53 . #x8FC7F9)
	   (#x6E54 . #x8FC7FA)
	   (#x6E56 . #xB8D0)
	   (#x6E57 . #x8FC7FB)
	   (#x6E58 . #xBEC5)
	   (#x6E5B . #xC3B9)
	   (#x6E5C . #x8FC7FC)
	   (#x6E5D . #x8FC7FD)
	   (#x6E5E . #x8FC7FE)
	   (#x6E5F . #xDED4)
	   (#x6E62 . #x8FC8A1)
	   (#x6E63 . #x8FC8A2)
	   (#x6E67 . #xCDAF)
	   (#x6E68 . #x8FC8A3)
	   (#x6E6B . #xDED7)
	   (#x6E6E . #xDED0)
	   (#x6E6F . #xC5F2)
	   (#x6E72 . #xDED3)
	   (#x6E73 . #x8FC8A4)
	   (#x6E76 . #xDED9)
	   (#x6E7B . #x8FC8A5)
	   (#x6E7D . #x8FC8A6)
	   (#x6E7E . #xCFD1)
	   (#x6E7F . #xBCBE)
	   (#x6E80 . #xCBFE)
	   (#x6E82 . #xDEE3)
	   (#x6E8C . #xC8AE)
	   (#x6E8D . #x8FC8A7)
	   (#x6E8F . #xDEEF)
	   (#x6E90 . #xB8BB)
	   (#x6E93 . #x8FC8A8)
	   (#x6E96 . #xBDE0)
	   (#x6E98 . #xDEE5)
	   (#x6E99 . #x8FC8A9)
	   (#x6E9C . #xCEAF)
	   (#x6E9D . #xB9C2)
	   (#x6E9F . #xDEF2)
	   (#x6EA0 . #x8FC8AA)
	   (#x6EA2 . #xB0EE)
	   (#x6EA5 . #xDEF0)
	   (#x6EA7 . #x8FC8AB)
	   (#x6EAA . #xDEE4)
	   (#x6EAD . #x8FC8AC)
	   (#x6EAE . #x8FC8AD)
	   (#x6EAF . #xDEEA)
	   (#x6EB1 . #x8FC8AE)
	   (#x6EB2 . #xDEEC)
	   (#x6EB3 . #x8FC8AF)
	   (#x6EB6 . #xCDCF)
	   (#x6EB7 . #xDEE7)
	   (#x6EBA . #xC5AE)
	   (#x6EBB . #x8FC8B0)
	   (#x6EBD . #xDEE9)
	   (#x6EBF . #x8FC8B1)
	   (#x6EC0 . #x8FC8B2)
	   (#x6EC1 . #x8FC8B3)
	   (#x6EC2 . #xDEF1)
	   (#x6EC3 . #x8FC8B4)
	   (#x6EC4 . #xDEEB)
	   (#x6EC5 . #xCCC7)
	   (#x6EC7 . #x8FC8B5)
	   (#x6EC8 . #x8FC8B6)
	   (#x6EC9 . #xDEE6)
	   (#x6ECA . #x8FC8B7)
	   (#x6ECB . #xBCA2)
	   (#x6ECC . #xDEFE)
	   (#x6ECD . #x8FC8B8)
	   (#x6ECE . #x8FC8B9)
	   (#x6ECF . #x8FC8BA)
	   (#x6ED1 . #xB3EA)
	   (#x6ED3 . #xDEE8)
	   (#x6ED4 . #xDEED)
	   (#x6ED5 . #xDEEE)
	   (#x6EDD . #xC2EC)
	   (#x6EDE . #xC2DA)
	   (#x6EEB . #x8FC8BB)
	   (#x6EEC . #xDEF6)
	   (#x6EED . #x8FC8BC)
	   (#x6EEE . #x8FC8BD)
	   (#x6EEF . #xDEFC)
	   (#x6EF2 . #xDEFA)
	   (#x6EF4 . #xC5A9)
	   (#x6EF7 . #xDFA3)
	   (#x6EF8 . #xDEF7)
	   (#x6EF9 . #x8FC8BE)
	   (#x6EFB . #x8FC8BF)
	   (#x6EFD . #x8FC8C0)
	   (#x6EFE . #xDEF8)
	   (#x6EFF . #xDEE0)
	   (#x6F01 . #xB5F9)
	   (#x6F02 . #xC9BA)
	   (#x6F04 . #x8FC8C1)
	   (#x6F06 . #xBCBF)
	   (#x6F08 . #x8FC8C2)
	   (#x6F09 . #xB9F7)
	   (#x6F0A . #x8FC8C3)
	   (#x6F0C . #x8FC8C4)
	   (#x6F0D . #x8FC8C5)
	   (#x6F0F . #xCFB3)
	   (#x6F11 . #xDEF4)
	   (#x6F13 . #xDFA2)
	   (#x6F14 . #xB1E9)
	   (#x6F15 . #xC1E6)
	   (#x6F16 . #x8FC8C6)
	   (#x6F18 . #x8FC8C7)
	   (#x6F1A . #x8FC8C8)
	   (#x6F1B . #x8FC8C9)
	   (#x6F20 . #xC7F9)
	   (#x6F22 . #xB4C1)
	   (#x6F23 . #xCEFA)
	   (#x6F26 . #x8FC8CA)
	   (#x6F29 . #x8FC8CB)
	   (#x6F2A . #x8FC8CC)
	   (#x6F2B . #xCCA1)
	   (#x6F2C . #xC4D2)
	   (#x6F2D . #x8FC8D3)
	   (#x6F2F . #x8FC8CD)
	   (#x6F30 . #x8FC8CE)
	   (#x6F31 . #xDEFB)
	   (#x6F32 . #xDEFD)
	   (#x6F33 . #x8FC8CF)
	   (#x6F36 . #x8FC8D0)
	   (#x6F38 . #xC1B2)
	   (#x6F3B . #x8FC8D1)
	   (#x6F3C . #x8FC8D2)
	   (#x6F3E . #xDFA1)
	   (#x6F3F . #xDEF9)
	   (#x6F41 . #xDEF3)
	   (#x6F45 . #xB4C3)
	   (#x6F4F . #x8FC8D4)
	   (#x6F51 . #x8FC8D5)
	   (#x6F52 . #x8FC8D6)
	   (#x6F53 . #x8FC8D7)
	   (#x6F54 . #xB7E9)
	   (#x6F57 . #x8FC8D8)
	   (#x6F58 . #xDFAF)
	   (#x6F59 . #x8FC8D9)
	   (#x6F5A . #x8FC8DA)
	   (#x6F5B . #xDFAA)
	   (#x6F5C . #xC0F8)
	   (#x6F5D . #x8FC8DB)
	   (#x6F5E . #x8FC8DC)
	   (#x6F5F . #xB3E3)
	   (#x6F61 . #x8FC8DD)
	   (#x6F62 . #x8FC8DE)
	   (#x6F64 . #xBDE1)
	   (#x6F66 . #xDFB3)
	   (#x6F68 . #x8FC8DF)
	   (#x6F6C . #x8FC8E0)
	   (#x6F6D . #xDFAC)
	   (#x6F6E . #xC4AC)
	   (#x6F6F . #xDFA9)
	   (#x6F70 . #xC4D9)
	   (#x6F74 . #xDFCC)
	   (#x6F78 . #xDFA6)
	   (#x6F7A . #xDFA5)
	   (#x6F7C . #xDFAE)
	   (#x6F7D . #x8FC8E1)
	   (#x6F7E . #x8FC8E2)
	   (#x6F80 . #xDFA8)
	   (#x6F81 . #xDFA7)
	   (#x6F82 . #xDFAD)
	   (#x6F83 . #x8FC8E3)
	   (#x6F84 . #xC0A1)
	   (#x6F86 . #xDFA4)
	   (#x6F87 . #x8FC8E4)
	   (#x6F88 . #x8FC8E5)
	   (#x6F8B . #x8FC8E6)
	   (#x6F8C . #x8FC8E7)
	   (#x6F8D . #x8FC8E8)
	   (#x6F8E . #xDFB0)
	   (#x6F90 . #x8FC8E9)
	   (#x6F91 . #xDFB1)
	   (#x6F92 . #x8FC8EA)
	   (#x6F93 . #x8FC8EB)
	   (#x6F94 . #x8FC8EC)
	   (#x6F96 . #x8FC8ED)
	   (#x6F97 . #xB4C2)
	   (#x6F9A . #x8FC8EE)
	   (#x6F9F . #x8FC8EF)
	   (#x6FA0 . #x8FC8F0)
	   (#x6FA1 . #xDFB6)
	   (#x6FA3 . #xDFB5)
	   (#x6FA4 . #xDFB7)
	   (#x6FA5 . #x8FC8F1)
	   (#x6FA6 . #x8FC8F2)
	   (#x6FA7 . #x8FC8F3)
	   (#x6FA8 . #x8FC8F4)
	   (#x6FAA . #xDFBA)
	   (#x6FAE . #x8FC8F5)
	   (#x6FAF . #x8FC8F6)
	   (#x6FB0 . #x8FC8F7)
	   (#x6FB1 . #xC5C3)
	   (#x6FB3 . #xDFB4)
	   (#x6FB5 . #x8FC8F8)
	   (#x6FB6 . #x8FC8F9)
	   (#x6FB9 . #xDFB8)
	   (#x6FBC . #x8FC8FA)
	   (#x6FC0 . #xB7E3)
	   (#x6FC1 . #xC2F9)
	   (#x6FC2 . #xDFB2)
	   (#x6FC3 . #xC7BB)
	   (#x6FC5 . #x8FC8FB)
	   (#x6FC6 . #xDFB9)
	   (#x6FC7 . #x8FC8FC)
	   (#x6FC8 . #x8FC8FD)
	   (#x6FCA . #x8FC8FE)
	   (#x6FD4 . #xDFBE)
	   (#x6FD5 . #xDFBC)
	   (#x6FD8 . #xDFBF)
	   (#x6FDA . #x8FC9A1)
	   (#x6FDB . #xDFC2)
	   (#x6FDE . #x8FC9A2)
	   (#x6FDF . #xDFBB)
	   (#x6FE0 . #xB9EA)
	   (#x6FE1 . #xC7A8)
	   (#x6FE4 . #xDEB9)
	   (#x6FE8 . #x8FC9A3)
	   (#x6FE9 . #x8FC9A4)
	   (#x6FEB . #xCDF4)
	   (#x6FEC . #xDFBD)
	   (#x6FEE . #xDFC1)
	   (#x6FEF . #xC2F5)
	   (#x6FF0 . #x8FC9A5)
	   (#x6FF1 . #xDFC0)
	   (#x6FF3 . #xDFAB)
	   (#x6FF5 . #x8FC9A6)
	   (#x6FF6 . #xEFE9)
	   (#x6FF9 . #x8FC9A7)
	   (#x6FFA . #xDFC5)
	   (#x6FFC . #x8FC9A8)
	   (#x6FFD . #x8FC9A9)
	   (#x6FFE . #xDFC9)
	   (#x7000 . #x8FC9AA)
	   (#x7001 . #xDFC7)
	   (#x7005 . #x8FC9AB)
	   (#x7006 . #x8FC9AC)
	   (#x7007 . #x8FC9AD)
	   (#x7009 . #xDFC3)
	   (#x700B . #xDFC4)
	   (#x700D . #x8FC9AE)
	   (#x700F . #xDFC8)
	   (#x7011 . #xDFC6)
	   (#x7015 . #xC9CE)
	   (#x7017 . #x8FC9AF)
	   (#x7018 . #xDFCE)
	   (#x701A . #xDFCB)
	   (#x701B . #xDFCA)
	   (#x701D . #xDFCD)
	   (#x701E . #xC6D4)
	   (#x701F . #xDFCF)
	   (#x7020 . #x8FC9B0)
	   (#x7023 . #x8FC9B1)
	   (#x7026 . #xC3F5)
	   (#x7027 . #xC2ED)
	   (#x702C . #xC0A5)
	   (#x702F . #x8FC9B2)
	   (#x7030 . #xDFD0)
	   (#x7032 . #xDFD2)
	   (#x7034 . #x8FC9B3)
	   (#x7037 . #x8FC9B4)
	   (#x7039 . #x8FC9B5)
	   (#x703C . #x8FC9B6)
	   (#x703E . #xDFD1)
	   (#x7043 . #x8FC9B7)
	   (#x7044 . #x8FC9B8)
	   (#x7048 . #x8FC9B9)
	   (#x7049 . #x8FC9BA)
	   (#x704A . #x8FC9BB)
	   (#x704B . #x8FC9BC)
	   (#x704C . #xDEF5)
	   (#x704E . #x8FC9C1)
	   (#x7051 . #xDFD3)
	   (#x7054 . #x8FC9BD)
	   (#x7055 . #x8FC9BE)
	   (#x7058 . #xC6E7)
	   (#x705D . #x8FC9BF)
	   (#x705E . #x8FC9C0)
	   (#x7063 . #xDFD4)
	   (#x7064 . #x8FC9C2)
	   (#x7065 . #x8FC9C3)
	   (#x706B . #xB2D0)
	   (#x706C . #x8FC9C4)
	   (#x706E . #x8FC9C5)
	   (#x706F . #xC5F4)
	   (#x7070 . #xB3A5)
	   (#x7075 . #x8FC9C6)
	   (#x7076 . #x8FC9C7)
	   (#x7078 . #xB5E4)
	   (#x707C . #xBCDE)
	   (#x707D . #xBAD2)
	   (#x707E . #x8FC9C8)
	   (#x7081 . #x8FC9C9)
	   (#x7085 . #x8FC9CA)
	   (#x7086 . #x8FC9CB)
	   (#x7089 . #xCFA7)
	   (#x708A . #xBFE6)
	   (#x708E . #xB1EA)
	   (#x7092 . #xDFD6)
	   (#x7094 . #x8FC9CC)
	   (#x7095 . #x8FC9CD)
	   (#x7096 . #x8FC9CE)
	   (#x7097 . #x8FC9CF)
	   (#x7098 . #x8FC9D0)
	   (#x7099 . #xDFD5)
	   (#x709B . #x8FC9D1)
	   (#x70A4 . #x8FC9D2)
	   (#x70AB . #x8FC9D3)
	   (#x70AC . #xDFD9)
	   (#x70AD . #xC3BA)
	   (#x70AE . #xDFDC)
	   (#x70AF . #xDFD7)
	   (#x70B0 . #x8FC9D4)
	   (#x70B1 . #x8FC9D5)
	   (#x70B3 . #xDFDB)
	   (#x70B4 . #x8FC9D6)
	   (#x70B7 . #x8FC9D7)
	   (#x70B8 . #xDFDA)
	   (#x70B9 . #xC5C0)
	   (#x70BA . #xB0D9)
	   (#x70C8 . #xCEF5)
	   (#x70CA . #x8FC9D8)
	   (#x70CB . #xDFDE)
	   (#x70CF . #xB1A8)
	   (#x70D1 . #x8FC9D9)
	   (#x70D3 . #x8FC9DA)
	   (#x70D4 . #x8FC9DB)
	   (#x70D5 . #x8FC9DC)
	   (#x70D6 . #x8FC9DD)
	   (#x70D8 . #x8FC9DE)
	   (#x70D9 . #xDFE0)
	   (#x70DC . #x8FC9DF)
	   (#x70DD . #xDFDF)
	   (#x70DF . #xDFDD)
	   (#x70E4 . #x8FC9E0)
	   (#x70F1 . #xDFD8)
	   (#x70F9 . #xCBA3)
	   (#x70FA . #x8FC9E1)
	   (#x70FD . #xDFE2)
	   (#x7103 . #x8FC9E2)
	   (#x7104 . #x8FC9E3)
	   (#x7105 . #x8FC9E4)
	   (#x7106 . #x8FC9E5)
	   (#x7107 . #x8FC9E6)
	   (#x7109 . #xDFE1)
	   (#x710B . #x8FC9E7)
	   (#x710C . #x8FC9E8)
	   (#x710F . #x8FC9E9)
	   (#x7114 . #xB1EB)
	   (#x7119 . #xDFE4)
	   (#x711A . #xCAB2)
	   (#x711C . #xDFE3)
	   (#x711E . #x8FC9EA)
	   (#x7120 . #x8FC9EB)
	   (#x7121 . #xCCB5)
	   (#x7126 . #xBEC7)
	   (#x712B . #x8FC9EC)
	   (#x712D . #x8FC9ED)
	   (#x712F . #x8FC9EE)
	   (#x7130 . #x8FC9EF)
	   (#x7131 . #x8FC9F0)
	   (#x7136 . #xC1B3)
	   (#x7138 . #x8FC9F1)
	   (#x713C . #xBEC6)
	   (#x7141 . #x8FC9F2)
	   (#x7145 . #x8FC9F3)
	   (#x7146 . #x8FC9F4)
	   (#x7147 . #x8FC9F5)
	   (#x7149 . #xCEFB)
	   (#x714A . #x8FC9F6)
	   (#x714B . #x8FC9F7)
	   (#x714C . #xDFEA)
	   (#x714E . #xC0F9)
	   (#x7150 . #x8FC9F8)
	   (#x7152 . #x8FC9F9)
	   (#x7155 . #xDFE6)
	   (#x7156 . #xDFEB)
	   (#x7157 . #x8FC9FA)
	   (#x7159 . #xB1EC)
	   (#x715A . #x8FC9FB)
	   (#x715C . #x8FC9FC)
	   (#x715E . #x8FC9FD)
	   (#x7160 . #x8FC9FE)
	   (#x7162 . #xDFE9)
	   (#x7164 . #xC7E1)
	   (#x7165 . #xDFE5)
	   (#x7166 . #xDFE8)
	   (#x7167 . #xBEC8)
	   (#x7168 . #x8FCAA1)
	   (#x7169 . #xC8D1)
	   (#x716C . #xDFEC)
	   (#x716E . #xBCD1)
	   (#x7179 . #x8FCAA2)
	   (#x717D . #xC0FA)
	   (#x7180 . #x8FCAA3)
	   (#x7184 . #xDFEF)
	   (#x7185 . #x8FCAA4)
	   (#x7187 . #x8FCAA5)
	   (#x7188 . #xDFE7)
	   (#x718A . #xB7A7)
	   (#x718C . #x8FCAA6)
	   (#x718F . #xDFED)
	   (#x7192 . #x8FCAA7)
	   (#x7194 . #xCDD0)
	   (#x7195 . #xDFF0)
	   (#x7199 . #xF4A6)
	   (#x719A . #x8FCAA8)
	   (#x719B . #x8FCAA9)
	   (#x719F . #xBDCF)
	   (#x71A0 . #x8FCAAA)
	   (#x71A2 . #x8FCAAB)
	   (#x71A8 . #xDFF1)
	   (#x71AC . #xDFF2)
	   (#x71AF . #x8FCAAC)
	   (#x71B0 . #x8FCAAD)
	   (#x71B1 . #xC7AE)
	   (#x71B2 . #x8FCAAE)
	   (#x71B3 . #x8FCAAF)
	   (#x71B9 . #xDFF4)
	   (#x71BA . #x8FCAB0)
	   (#x71BE . #xDFF5)
	   (#x71BF . #x8FCAB1)
	   (#x71C0 . #x8FCAB2)
	   (#x71C1 . #x8FCAB3)
	   (#x71C3 . #xC7B3)
	   (#x71C4 . #x8FCAB4)
	   (#x71C8 . #xC5F5)
	   (#x71C9 . #xDFF7)
	   (#x71CB . #x8FCAB5)
	   (#x71CC . #x8FCAB6)
	   (#x71CE . #xDFF9)
	   (#x71D0 . #xCED5)
	   (#x71D2 . #xDFF6)
	   (#x71D3 . #x8FCAB7)
	   (#x71D4 . #xDFF8)
	   (#x71D5 . #xB1ED)
	   (#x71D6 . #x8FCAB8)
	   (#x71D7 . #xDFF3)
	   (#x71D9 . #x8FCAB9)
	   (#x71DA . #x8FCABA)
	   (#x71DC . #x8FCABB)
	   (#x71DF . #xD3DB)
	   (#x71E0 . #xDFFA)
	   (#x71E5 . #xC1E7)
	   (#x71E6 . #xBBB8)
	   (#x71E7 . #xDFFC)
	   (#x71EC . #xDFFB)
	   (#x71ED . #xBFA4)
	   (#x71EE . #xD2D9)
	   (#x71F5 . #xDFFD)
	   (#x71F8 . #x8FCABC)
	   (#x71F9 . #xE0A1)
	   (#x71FB . #xDFEE)
	   (#x71FC . #xDFFE)
	   (#x71FE . #x8FCABD)
	   (#x71FF . #xE0A2)
	   (#x7200 . #x8FCABE)
	   (#x7206 . #xC7FA)
	   (#x7207 . #x8FCABF)
	   (#x7208 . #x8FCAC0)
	   (#x7209 . #x8FCAC1)
	   (#x720D . #xE0A3)
	   (#x7210 . #xE0A4)
	   (#x7213 . #x8FCAC2)
	   (#x7217 . #x8FCAC3)
	   (#x721A . #x8FCAC4)
	   (#x721B . #xE0A5)
	   (#x721D . #x8FCAC5)
	   (#x721F . #x8FCAC6)
	   (#x7224 . #x8FCAC7)
	   (#x7228 . #xE0A6)
	   (#x722A . #xC4DE)
	   (#x722B . #x8FCAC8)
	   (#x722C . #xE0A8)
	   (#x722D . #xE0A7)
	   (#x722F . #x8FCAC9)
	   (#x7230 . #xE0A9)
	   (#x7232 . #xE0AA)
	   (#x7234 . #x8FCACA)
	   (#x7235 . #xBCDF)
	   (#x7236 . #xC9E3)
	   (#x7238 . #x8FCACB)
	   (#x7239 . #x8FCACC)
	   (#x723A . #xCCEC)
	   (#x723B . #xE0AB)
	   (#x723C . #xE0AC)
	   (#x723D . #xC1D6)
	   (#x723E . #xBCA4)
	   (#x723F . #xE0AD)
	   (#x7240 . #xE0AE)
	   (#x7241 . #x8FCACD)
	   (#x7242 . #x8FCACE)
	   (#x7243 . #x8FCACF)
	   (#x7245 . #x8FCAD0)
	   (#x7246 . #xE0AF)
	   (#x7247 . #xCAD2)
	   (#x7248 . #xC8C7)
	   (#x724B . #xE0B0)
	   (#x724C . #xC7D7)
	   (#x724E . #x8FCAD1)
	   (#x724F . #x8FCAD2)
	   (#x7250 . #x8FCAD3)
	   (#x7252 . #xC4AD)
	   (#x7253 . #x8FCAD4)
	   (#x7255 . #x8FCAD5)
	   (#x7256 . #x8FCAD6)
	   (#x7258 . #xE0B1)
	   (#x7259 . #xB2E7)
	   (#x725A . #x8FCAD7)
	   (#x725B . #xB5ED)
	   (#x725C . #x8FCAD8)
	   (#x725D . #xCCC6)
	   (#x725E . #x8FCAD9)
	   (#x725F . #xCCB6)
	   (#x7260 . #x8FCADA)
	   (#x7261 . #xB2B4)
	   (#x7262 . #xCFB4)
	   (#x7263 . #x8FCADB)
	   (#x7267 . #xCBD2)
	   (#x7268 . #x8FCADC)
	   (#x7269 . #xCAAA)
	   (#x726B . #x8FCADD)
	   (#x726E . #x8FCADE)
	   (#x726F . #x8FCADF)
	   (#x7271 . #x8FCAE0)
	   (#x7272 . #xC0B7)
	   (#x7274 . #xE0B2)
	   (#x7277 . #x8FCAE1)
	   (#x7278 . #x8FCAE2)
	   (#x7279 . #xC6C3)
	   (#x727B . #x8FCAE3)
	   (#x727C . #x8FCAE4)
	   (#x727D . #xB8A3)
	   (#x727E . #xE0B3)
	   (#x727F . #x8FCAE5)
	   (#x7280 . #xBAD4)
	   (#x7281 . #xE0B5)
	   (#x7282 . #xE0B4)
	   (#x7284 . #x8FCAE6)
	   (#x7287 . #xE0B6)
	   (#x7289 . #x8FCAE7)
	   (#x728D . #x8FCAE8)
	   (#x728E . #x8FCAE9)
	   (#x7292 . #xE0B7)
	   (#x7293 . #x8FCAEA)
	   (#x7296 . #xE0B8)
	   (#x729B . #x8FCAEB)
	   (#x72A0 . #xB5BE)
	   (#x72A2 . #xE0B9)
	   (#x72A7 . #xE0BA)
	   (#x72A8 . #x8FCAEC)
	   (#x72AC . #xB8A4)
	   (#x72AD . #x8FCAED)
	   (#x72AE . #x8FCAEE)
	   (#x72AF . #xC8C8)
	   (#x72B1 . #x8FCAEF)
	   (#x72B2 . #xE0BC)
	   (#x72B4 . #x8FCAF0)
	   (#x72B6 . #xBEF5)
	   (#x72B9 . #xE0BB)
	   (#x72BE . #x8FCAF1)
	   (#x72C1 . #x8FCAF2)
	   (#x72C2 . #xB6B8)
	   (#x72C3 . #xE0BD)
	   (#x72C4 . #xE0BF)
	   (#x72C6 . #xE0BE)
	   (#x72C7 . #x8FCAF3)
	   (#x72C9 . #x8FCAF4)
	   (#x72CC . #x8FCAF5)
	   (#x72CE . #xE0C0)
	   (#x72D0 . #xB8D1)
	   (#x72D2 . #xE0C1)
	   (#x72D5 . #x8FCAF6)
	   (#x72D6 . #x8FCAF7)
	   (#x72D7 . #xB6E9)
	   (#x72D8 . #x8FCAF8)
	   (#x72D9 . #xC1C0)
	   (#x72DB . #xB9FD)
	   (#x72DF . #x8FCAF9)
	   (#x72E0 . #xE0C3)
	   (#x72E1 . #xE0C4)
	   (#x72E2 . #xE0C2)
	   (#x72E5 . #x8FCAFA)
	   (#x72E9 . #xBCED)
	   (#x72EC . #xC6C8)
	   (#x72ED . #xB6B9)
	   (#x72F3 . #x8FCAFB)
	   (#x72F4 . #x8FCAFC)
	   (#x72F7 . #xE0C6)
	   (#x72F8 . #xC3AC)
	   (#x72F9 . #xE0C5)
	   (#x72FA . #x8FCAFD)
	   (#x72FB . #x8FCAFE)
	   (#x72FC . #xCFB5)
	   (#x72FD . #xC7E2)
	   (#x72FE . #x8FCBA1)
	   (#x7302 . #x8FCBA2)
	   (#x7304 . #x8FCBA3)
	   (#x7305 . #x8FCBA4)
	   (#x7307 . #x8FCBA5)
	   (#x730A . #xE0C9)
	   (#x730B . #x8FCBA6)
	   (#x730D . #x8FCBA7)
	   (#x7312 . #x8FCBA8)
	   (#x7313 . #x8FCBA9)
	   (#x7316 . #xE0CB)
	   (#x7317 . #xE0C8)
	   (#x7318 . #x8FCBAA)
	   (#x7319 . #x8FCBAB)
	   (#x731B . #xCCD4)
	   (#x731C . #xE0CA)
	   (#x731D . #xE0CC)
	   (#x731E . #x8FCBAC)
	   (#x731F . #xCEC4)
	   (#x7322 . #x8FCBAD)
	   (#x7324 . #x8FCBAE)
	   (#x7325 . #xE0D0)
	   (#x7327 . #x8FCBAF)
	   (#x7328 . #x8FCBB0)
	   (#x7329 . #xE0CF)
	   (#x732A . #xC3F6)
	   (#x732B . #xC7AD)
	   (#x732C . #x8FCBB1)
	   (#x732E . #xB8A5)
	   (#x732F . #xE0CE)
	   (#x7331 . #x8FCBB2)
	   (#x7332 . #x8FCBB3)
	   (#x7334 . #xE0CD)
	   (#x7335 . #x8FCBB4)
	   (#x7336 . #xCDB1)
	   (#x7337 . #xCDB2)
	   (#x733A . #x8FCBB5)
	   (#x733B . #x8FCBB6)
	   (#x733D . #x8FCBB7)
	   (#x733E . #xE0D1)
	   (#x733F . #xB1EE)
	   (#x7343 . #x8FCBB8)
	   (#x7344 . #xB9F6)
	   (#x7345 . #xBBE2)
	   (#x734D . #x8FCBB9)
	   (#x734E . #xE0D2)
	   (#x734F . #xE0D3)
	   (#x7350 . #x8FCBBA)
	   (#x7352 . #x8FCBBB)
	   (#x7356 . #x8FCBBC)
	   (#x7357 . #xE0D5)
	   (#x7358 . #x8FCBBD)
	   (#x735D . #x8FCBBE)
	   (#x735E . #x8FCBBF)
	   (#x735F . #x8FCBC0)
	   (#x7360 . #x8FCBC1)
	   (#x7363 . #xBDC3)
	   (#x7366 . #x8FCBC2)
	   (#x7367 . #x8FCBC3)
	   (#x7368 . #xE0D7)
	   (#x7369 . #x8FCBC4)
	   (#x736A . #xE0D6)
	   (#x736B . #x8FCBC5)
	   (#x736C . #x8FCBC6)
	   (#x736E . #x8FCBC7)
	   (#x736F . #x8FCBC8)
	   (#x7370 . #xE0D8)
	   (#x7371 . #x8FCBC9)
	   (#x7372 . #xB3CD)
	   (#x7375 . #xE0DA)
	   (#x7377 . #x8FCBCA)
	   (#x7378 . #xE0D9)
	   (#x7379 . #x8FCBCB)
	   (#x737A . #xE0DC)
	   (#x737B . #xE0DB)
	   (#x737C . #x8FCBCC)
	   (#x7380 . #x8FCBCD)
	   (#x7381 . #x8FCBCE)
	   (#x7383 . #x8FCBCF)
	   (#x7384 . #xB8BC)
	   (#x7385 . #x8FCBD0)
	   (#x7386 . #x8FCBD1)
	   (#x7387 . #xCEA8)
	   (#x7389 . #xB6CC)
	   (#x738B . #xB2A6)
	   (#x738E . #x8FCBD2)
	   (#x7390 . #x8FCBD3)
	   (#x7393 . #x8FCBD4)
	   (#x7395 . #x8FCBD5)
	   (#x7396 . #xB6EA)
	   (#x7397 . #x8FCBD6)
	   (#x7398 . #x8FCBD7)
	   (#x739C . #x8FCBD8)
	   (#x739E . #x8FCBD9)
	   (#x739F . #x8FCBDA)
	   (#x73A0 . #x8FCBDB)
	   (#x73A2 . #x8FCBDC)
	   (#x73A5 . #x8FCBDD)
	   (#x73A6 . #x8FCBDE)
	   (#x73A9 . #xB4E1)
	   (#x73AA . #x8FCBDF)
	   (#x73AB . #x8FCBE0)
	   (#x73AD . #x8FCBE1)
	   (#x73B2 . #xCEE8)
	   (#x73B3 . #xE0DE)
	   (#x73B5 . #x8FCBE2)
	   (#x73B7 . #x8FCBE3)
	   (#x73B9 . #x8FCBE4)
	   (#x73BB . #xE0E0)
	   (#x73BC . #x8FCBE5)
	   (#x73BD . #x8FCBE6)
	   (#x73BF . #x8FCBE7)
	   (#x73C0 . #xE0E1)
	   (#x73C2 . #xB2D1)
	   (#x73C5 . #x8FCBE8)
	   (#x73C6 . #x8FCBE9)
	   (#x73C8 . #xE0DD)
	   (#x73C9 . #x8FCBEA)
	   (#x73CA . #xBBB9)
	   (#x73CB . #x8FCBEB)
	   (#x73CC . #x8FCBEC)
	   (#x73CD . #xC4C1)
	   (#x73CE . #xE0DF)
	   (#x73CF . #x8FCBED)
	   (#x73D2 . #x8FCBEE)
	   (#x73D3 . #x8FCBEF)
	   (#x73D6 . #x8FCBF0)
	   (#x73D9 . #x8FCBF1)
	   (#x73DD . #x8FCBF2)
	   (#x73DE . #xE0E4)
	   (#x73E0 . #xBCEE)
	   (#x73E1 . #x8FCBF3)
	   (#x73E3 . #x8FCBF4)
	   (#x73E5 . #xE0E2)
	   (#x73E6 . #x8FCBF5)
	   (#x73E7 . #x8FCBF6)
	   (#x73E9 . #x8FCBF7)
	   (#x73EA . #xB7BE)
	   (#x73ED . #xC8C9)
	   (#x73EE . #xE0E3)
	   (#x73F1 . #xE0FE)
	   (#x73F4 . #x8FCBF8)
	   (#x73F5 . #x8FCBF9)
	   (#x73F7 . #x8FCBFA)
	   (#x73F8 . #xE0E9)
	   (#x73F9 . #x8FCBFB)
	   (#x73FA . #x8FCBFC)
	   (#x73FB . #x8FCBFD)
	   (#x73FD . #x8FCBFE)
	   (#x73FE . #xB8BD)
	   (#x73FF . #x8FCCA1)
	   (#x7400 . #x8FCCA2)
	   (#x7401 . #x8FCCA3)
	   (#x7403 . #xB5E5)
	   (#x7404 . #x8FCCA4)
	   (#x7405 . #xE0E6)
	   (#x7406 . #xCDFD)
	   (#x7407 . #x8FCCA5)
	   (#x7409 . #xCEB0)
	   (#x740A . #x8FCCA6)
	   (#x7411 . #x8FCCA7)
	   (#x741A . #x8FCCA8)
	   (#x741B . #x8FCCA9)
	   (#x7422 . #xC2F6)
	   (#x7424 . #x8FCCAA)
	   (#x7425 . #xE0E8)
	   (#x7426 . #x8FCCAB)
	   (#x7428 . #x8FCCAC)
	   (#x7429 . #x8FCCAD)
	   (#x742A . #x8FCCAE)
	   (#x742B . #x8FCCAF)
	   (#x742C . #x8FCCB0)
	   (#x742D . #x8FCCB1)
	   (#x742E . #x8FCCB2)
	   (#x742F . #x8FCCB3)
	   (#x7430 . #x8FCCB4)
	   (#x7431 . #x8FCCB5)
	   (#x7432 . #xE0EA)
	   (#x7433 . #xCED6)
	   (#x7434 . #xB6D7)
	   (#x7435 . #xC8FC)
	   (#x7436 . #xC7CA)
	   (#x7439 . #x8FCCB6)
	   (#x743A . #xE0EB)
	   (#x743F . #xE0ED)
	   (#x7440 . #x8FCCB7)
	   (#x7441 . #xE0F0)
	   (#x7443 . #x8FCCB8)
	   (#x7444 . #x8FCCB9)
	   (#x7446 . #x8FCCBA)
	   (#x7447 . #x8FCCBB)
	   (#x744B . #x8FCCBC)
	   (#x744D . #x8FCCBD)
	   (#x7451 . #x8FCCBE)
	   (#x7452 . #x8FCCBF)
	   (#x7455 . #xE0EC)
	   (#x7457 . #x8FCCC0)
	   (#x7459 . #xE0EF)
	   (#x745A . #xB8EA)
	   (#x745B . #xB1CD)
	   (#x745C . #xE0F1)
	   (#x745D . #x8FCCC1)
	   (#x745E . #xBFF0)
	   (#x745F . #xE0EE)
	   (#x7460 . #xCEDC)
	   (#x7462 . #x8FCCC2)
	   (#x7463 . #xE0F4)
	   (#x7464 . #xF4A4)
	   (#x7466 . #x8FCCC3)
	   (#x7467 . #x8FCCC4)
	   (#x7468 . #x8FCCC5)
	   (#x7469 . #xE0F2)
	   (#x746A . #xE0F5)
	   (#x746B . #x8FCCC6)
	   (#x746D . #x8FCCC7)
	   (#x746E . #x8FCCC8)
	   (#x746F . #xE0E7)
	   (#x7470 . #xE0F3)
	   (#x7471 . #x8FCCC9)
	   (#x7472 . #x8FCCCA)
	   (#x7473 . #xBABC)
	   (#x7476 . #xE0F6)
	   (#x747E . #xE0F7)
	   (#x7480 . #x8FCCCB)
	   (#x7481 . #x8FCCCC)
	   (#x7483 . #xCDFE)
	   (#x7485 . #x8FCCCD)
	   (#x7486 . #x8FCCCE)
	   (#x7487 . #x8FCCCF)
	   (#x7489 . #x8FCCD0)
	   (#x748B . #xE0F8)
	   (#x748F . #x8FCCD1)
	   (#x7490 . #x8FCCD2)
	   (#x7491 . #x8FCCD3)
	   (#x7492 . #x8FCCD4)
	   (#x7498 . #x8FCCD5)
	   (#x7499 . #x8FCCD6)
	   (#x749A . #x8FCCD7)
	   (#x749C . #x8FCCD8)
	   (#x749E . #xE0F9)
	   (#x749F . #x8FCCD9)
	   (#x74A0 . #x8FCCDA)
	   (#x74A1 . #x8FCCDB)
	   (#x74A2 . #xE0E5)
	   (#x74A3 . #x8FCCDC)
	   (#x74A6 . #x8FCCDD)
	   (#x74A7 . #xE0FA)
	   (#x74A8 . #x8FCCDE)
	   (#x74A9 . #x8FCCDF)
	   (#x74AA . #x8FCCE0)
	   (#x74AB . #x8FCCE1)
	   (#x74AE . #x8FCCE2)
	   (#x74AF . #x8FCCE3)
	   (#x74B0 . #xB4C4)
	   (#x74B1 . #x8FCCE4)
	   (#x74B2 . #x8FCCE5)
	   (#x74B5 . #x8FCCE6)
	   (#x74B9 . #x8FCCE7)
	   (#x74BB . #x8FCCE8)
	   (#x74BD . #xBCA5)
	   (#x74BF . #x8FCCE9)
	   (#x74C8 . #x8FCCEA)
	   (#x74C9 . #x8FCCEB)
	   (#x74CA . #xE0FB)
	   (#x74CC . #x8FCCEC)
	   (#x74CF . #xE0FC)
	   (#x74D0 . #x8FCCED)
	   (#x74D3 . #x8FCCEE)
	   (#x74D4 . #xE0FD)
	   (#x74D8 . #x8FCCEF)
	   (#x74DA . #x8FCCF0)
	   (#x74DB . #x8FCCF1)
	   (#x74DC . #xB1BB)
	   (#x74DE . #x8FCCF2)
	   (#x74DF . #x8FCCF3)
	   (#x74E0 . #xE1A1)
	   (#x74E2 . #xC9BB)
	   (#x74E3 . #xE1A2)
	   (#x74E4 . #x8FCCF4)
	   (#x74E6 . #xB4A4)
	   (#x74E7 . #xE1A3)
	   (#x74E8 . #x8FCCF5)
	   (#x74E9 . #xE1A4)
	   (#x74EA . #x8FCCF6)
	   (#x74EB . #x8FCCF7)
	   (#x74EE . #xE1A5)
	   (#x74EF . #x8FCCF8)
	   (#x74F0 . #xE1A7)
	   (#x74F1 . #xE1A8)
	   (#x74F2 . #xE1A6)
	   (#x74F4 . #x8FCCF9)
	   (#x74F6 . #xC9D3)
	   (#x74F7 . #xE1AA)
	   (#x74F8 . #xE1A9)
	   (#x74FA . #x8FCCFA)
	   (#x74FB . #x8FCCFB)
	   (#x74FC . #x8FCCFC)
	   (#x74FF . #x8FCCFD)
	   (#x7503 . #xE1AC)
	   (#x7504 . #xE1AB)
	   (#x7505 . #xE1AD)
	   (#x7506 . #x8FCCFE)
	   (#x750C . #xE1AE)
	   (#x750D . #xE1B0)
	   (#x750E . #xE1AF)
	   (#x7511 . #xB9F9)
	   (#x7512 . #x8FCDA1)
	   (#x7513 . #xE1B2)
	   (#x7515 . #xE1B1)
	   (#x7516 . #x8FCDA2)
	   (#x7517 . #x8FCDA3)
	   (#x7518 . #xB4C5)
	   (#x751A . #xBFD3)
	   (#x751C . #xC5BC)
	   (#x751E . #xE1B3)
	   (#x751F . #xC0B8)
	   (#x7520 . #x8FCDA4)
	   (#x7521 . #x8FCDA5)
	   (#x7523 . #xBBBA)
	   (#x7524 . #x8FCDA6)
	   (#x7525 . #xB1F9)
	   (#x7526 . #xE1B4)
	   (#x7527 . #x8FCDA7)
	   (#x7528 . #xCDD1)
	   (#x7529 . #x8FCDA8)
	   (#x752A . #x8FCDA9)
	   (#x752B . #xCAE3)
	   (#x752C . #xE1B5)
	   (#x752F . #x8FCDAA)
	   (#x7530 . #xC5C4)
	   (#x7531 . #xCDB3)
	   (#x7532 . #xB9C3)
	   (#x7533 . #xBFBD)
	   (#x7536 . #x8FCDAB)
	   (#x7537 . #xC3CB)
	   (#x7538 . #xD2B4)
	   (#x7539 . #x8FCDAC)
	   (#x753A . #xC4AE)
	   (#x753B . #xB2E8)
	   (#x753C . #xE1B6)
	   (#x753D . #x8FCDAD)
	   (#x753E . #x8FCDAE)
	   (#x753F . #x8FCDAF)
	   (#x7540 . #x8FCDB0)
	   (#x7543 . #x8FCDB1)
	   (#x7544 . #xE1B7)
	   (#x7546 . #xE1BC)
	   (#x7547 . #x8FCDB2)
	   (#x7548 . #x8FCDB3)
	   (#x7549 . #xE1BA)
	   (#x754A . #xE1B9)
	   (#x754B . #xDAC2)
	   (#x754C . #xB3A6)
	   (#x754D . #xE1B8)
	   (#x754E . #x8FCDB4)
	   (#x754F . #xB0DA)
	   (#x7550 . #x8FCDB5)
	   (#x7551 . #xC8AA)
	   (#x7552 . #x8FCDB6)
	   (#x7554 . #xC8CA)
	   (#x7557 . #x8FCDB7)
	   (#x7559 . #xCEB1)
	   (#x755A . #xE1BD)
	   (#x755B . #xE1BB)
	   (#x755C . #xC3DC)
	   (#x755D . #xC0A6)
	   (#x755E . #x8FCDB8)
	   (#x755F . #x8FCDB9)
	   (#x7560 . #xC8AB)
	   (#x7561 . #x8FCDBA)
	   (#x7562 . #xC9AD)
	   (#x7564 . #xE1BF)
	   (#x7565 . #xCEAC)
	   (#x7566 . #xB7CD)
	   (#x7567 . #xE1C0)
	   (#x7569 . #xE1BE)
	   (#x756A . #xC8D6)
	   (#x756B . #xE1C1)
	   (#x756D . #xE1C2)
	   (#x756F . #x8FCDBB)
	   (#x7570 . #xB0DB)
	   (#x7571 . #x8FCDBC)
	   (#x7573 . #xBEF6)
	   (#x7574 . #xE1C7)
	   (#x7576 . #xE1C4)
	   (#x7577 . #xC6ED)
	   (#x7578 . #xE1C3)
	   (#x7579 . #x8FCDBD)
	   (#x757A . #x8FCDBE)
	   (#x757B . #x8FCDBF)
	   (#x757C . #x8FCDC0)
	   (#x757D . #x8FCDC1)
	   (#x757E . #x8FCDC2)
	   (#x757F . #xB5A6)
	   (#x7581 . #x8FCDC3)
	   (#x7582 . #xE1CA)
	   (#x7585 . #x8FCDC4)
	   (#x7586 . #xE1C5)
	   (#x7587 . #xE1C6)
	   (#x7589 . #xE1C9)
	   (#x758A . #xE1C8)
	   (#x758B . #xC9A5)
	   (#x758E . #xC1C2)
	   (#x758F . #xC1C1)
	   (#x7590 . #x8FCDC5)
	   (#x7591 . #xB5BF)
	   (#x7592 . #x8FCDC6)
	   (#x7593 . #x8FCDC7)
	   (#x7594 . #xE1CB)
	   (#x7595 . #x8FCDC8)
	   (#x7599 . #x8FCDC9)
	   (#x759A . #xE1CC)
	   (#x759C . #x8FCDCA)
	   (#x759D . #xE1CD)
	   (#x75A2 . #x8FCDCB)
	   (#x75A3 . #xE1CF)
	   (#x75A4 . #x8FCDCC)
	   (#x75A5 . #xE1CE)
	   (#x75AB . #xB1D6)
	   (#x75B1 . #xE1D7)
	   (#x75B2 . #xC8E8)
	   (#x75B3 . #xE1D1)
	   (#x75B4 . #x8FCDCD)
	   (#x75B5 . #xE1D3)
	   (#x75B8 . #xE1D5)
	   (#x75B9 . #xBFBE)
	   (#x75BA . #x8FCDCE)
	   (#x75BC . #xE1D6)
	   (#x75BD . #xE1D4)
	   (#x75BE . #xBCC0)
	   (#x75BF . #x8FCDCF)
	   (#x75C0 . #x8FCDD0)
	   (#x75C1 . #x8FCDD1)
	   (#x75C2 . #xE1D0)
	   (#x75C3 . #xE1D2)
	   (#x75C4 . #x8FCDD2)
	   (#x75C5 . #xC9C2)
	   (#x75C6 . #x8FCDD3)
	   (#x75C7 . #xBEC9)
	   (#x75CA . #xE1D9)
	   (#x75CC . #x8FCDD4)
	   (#x75CD . #xE1D8)
	   (#x75CE . #x8FCDD5)
	   (#x75CF . #x8FCDD6)
	   (#x75D2 . #xE1DA)
	   (#x75D4 . #xBCA6)
	   (#x75D5 . #xBAAF)
	   (#x75D7 . #x8FCDD7)
	   (#x75D8 . #xC5F7)
	   (#x75D9 . #xE1DB)
	   (#x75DB . #xC4CB)
	   (#x75DC . #x8FCDD8)
	   (#x75DE . #xE1DD)
	   (#x75DF . #x8FCDD9)
	   (#x75E0 . #x8FCDDA)
	   (#x75E1 . #x8FCDDB)
	   (#x75E2 . #xCEA1)
	   (#x75E3 . #xE1DC)
	   (#x75E4 . #x8FCDDC)
	   (#x75E7 . #x8FCDDD)
	   (#x75E9 . #xC1E9)
	   (#x75EC . #x8FCDDE)
	   (#x75EE . #x8FCDDF)
	   (#x75EF . #x8FCDE0)
	   (#x75F0 . #xE1E2)
	   (#x75F1 . #x8FCDE1)
	   (#x75F2 . #xE1E4)
	   (#x75F3 . #xE1E5)
	   (#x75F4 . #xC3D4)
	   (#x75F9 . #x8FCDE2)
	   (#x75FA . #xE1E3)
	   (#x75FC . #xE1E0)
	   (#x75FE . #xE1DE)
	   (#x75FF . #xE1DF)
	   (#x7600 . #x8FCDE3)
	   (#x7601 . #xE1E1)
	   (#x7602 . #x8FCDE4)
	   (#x7603 . #x8FCDE5)
	   (#x7604 . #x8FCDE6)
	   (#x7607 . #x8FCDE7)
	   (#x7608 . #x8FCDE8)
	   (#x7609 . #xE1E8)
	   (#x760A . #x8FCDE9)
	   (#x760B . #xE1E6)
	   (#x760C . #x8FCDEA)
	   (#x760D . #xE1E7)
	   (#x760F . #x8FCDEB)
	   (#x7612 . #x8FCDEC)
	   (#x7613 . #x8FCDED)
	   (#x7615 . #x8FCDEE)
	   (#x7616 . #x8FCDEF)
	   (#x7619 . #x8FCDF0)
	   (#x761B . #x8FCDF1)
	   (#x761C . #x8FCDF2)
	   (#x761D . #x8FCDF3)
	   (#x761E . #x8FCDF4)
	   (#x761F . #xE1E9)
	   (#x7620 . #xE1EB)
	   (#x7621 . #xE1EC)
	   (#x7622 . #xE1ED)
	   (#x7623 . #x8FCDF5)
	   (#x7624 . #xE1EE)
	   (#x7625 . #x8FCDF6)
	   (#x7626 . #x8FCDF7)
	   (#x7627 . #xE1EA)
	   (#x7629 . #x8FCDF8)
	   (#x762D . #x8FCDF9)
	   (#x7630 . #xE1F0)
	   (#x7632 . #x8FCDFA)
	   (#x7633 . #x8FCDFB)
	   (#x7634 . #xE1EF)
	   (#x7635 . #x8FCDFC)
	   (#x7638 . #x8FCDFD)
	   (#x7639 . #x8FCDFE)
	   (#x763A . #x8FCEA1)
	   (#x763B . #xE1F1)
	   (#x763C . #x8FCEA2)
	   (#x7640 . #x8FCEA4)
	   (#x7641 . #x8FCEA5)
	   (#x7642 . #xCEC5)
	   (#x7643 . #x8FCEA6)
	   (#x7644 . #x8FCEA7)
	   (#x7645 . #x8FCEA8)
	   (#x7646 . #xE1F4)
	   (#x7647 . #xE1F2)
	   (#x7648 . #xE1F3)
	   (#x7649 . #x8FCEA9)
	   (#x764A . #x8FCEA3)
	   (#x764B . #x8FCEAA)
	   (#x764C . #xB4E2)
	   (#x7652 . #xCCFE)
	   (#x7655 . #x8FCEAB)
	   (#x7656 . #xCACA)
	   (#x7658 . #xE1F6)
	   (#x7659 . #x8FCEAC)
	   (#x765C . #xE1F5)
	   (#x765F . #x8FCEAD)
	   (#x7661 . #xE1F7)
	   (#x7662 . #xE1F8)
	   (#x7664 . #x8FCEAE)
	   (#x7665 . #x8FCEAF)
	   (#x7667 . #xE1FC)
	   (#x7668 . #xE1F9)
	   (#x7669 . #xE1FA)
	   (#x766A . #xE1FB)
	   (#x766C . #xE1FD)
	   (#x766D . #x8FCEB0)
	   (#x766E . #x8FCEB1)
	   (#x766F . #x8FCEB2)
	   (#x7670 . #xE1FE)
	   (#x7671 . #x8FCEB3)
	   (#x7672 . #xE2A1)
	   (#x7674 . #x8FCEB4)
	   (#x7676 . #xE2A2)
	   (#x7678 . #xE2A3)
	   (#x767A . #xC8AF)
	   (#x767B . #xC5D0)
	   (#x767C . #xE2A4)
	   (#x767D . #xC7F2)
	   (#x767E . #xC9B4)
	   (#x7680 . #xE2A5)
	   (#x7681 . #x8FCEB5)
	   (#x7683 . #xE2A6)
	   (#x7684 . #xC5AA)
	   (#x7685 . #x8FCEB6)
	   (#x7686 . #xB3A7)
	   (#x7687 . #xB9C4)
	   (#x7688 . #xE2A7)
	   (#x768B . #xE2A8)
	   (#x768C . #x8FCEB7)
	   (#x768D . #x8FCEB8)
	   (#x768E . #xE2A9)
	   (#x7690 . #xBBA9)
	   (#x7693 . #xE2AB)
	   (#x7695 . #x8FCEB9)
	   (#x7696 . #xE2AA)
	   (#x7699 . #xE2AC)
	   (#x769A . #xE2AD)
	   (#x769B . #x8FCEBA)
	   (#x769C . #x8FCEBB)
	   (#x769D . #x8FCEBC)
	   (#x769F . #x8FCEBD)
	   (#x76A0 . #x8FCEBE)
	   (#x76A2 . #x8FCEBF)
	   (#x76A3 . #x8FCEC0)
	   (#x76A4 . #x8FCEC1)
	   (#x76A5 . #x8FCEC2)
	   (#x76A6 . #x8FCEC3)
	   (#x76A7 . #x8FCEC4)
	   (#x76A8 . #x8FCEC5)
	   (#x76AA . #x8FCEC6)
	   (#x76AD . #x8FCEC7)
	   (#x76AE . #xC8E9)
	   (#x76B0 . #xE2AE)
	   (#x76B4 . #xE2AF)
	   (#x76B7 . #xF3E9)
	   (#x76B8 . #xE2B0)
	   (#x76B9 . #xE2B1)
	   (#x76BA . #xE2B2)
	   (#x76BD . #x8FCEC8)
	   (#x76BF . #xBBAE)
	   (#x76C1 . #x8FCEC9)
	   (#x76C2 . #xE2B3)
	   (#x76C3 . #xC7D6)
	   (#x76C5 . #x8FCECA)
	   (#x76C6 . #xCBDF)
	   (#x76C8 . #xB1CE)
	   (#x76C9 . #x8FCECB)
	   (#x76CA . #xB1D7)
	   (#x76CB . #x8FCECC)
	   (#x76CC . #x8FCECD)
	   (#x76CD . #xE2B4)
	   (#x76CE . #x8FCECE)
	   (#x76D2 . #xE2B6)
	   (#x76D4 . #x8FCECF)
	   (#x76D6 . #xE2B5)
	   (#x76D7 . #xC5F0)
	   (#x76D9 . #x8FCED0)
	   (#x76DB . #xC0B9)
	   (#x76DC . #xDDB9)
	   (#x76DE . #xE2B7)
	   (#x76DF . #xCCC1)
	   (#x76E0 . #x8FCED1)
	   (#x76E1 . #xE2B8)
	   (#x76E3 . #xB4C6)
	   (#x76E4 . #xC8D7)
	   (#x76E5 . #xE2B9)
	   (#x76E6 . #x8FCED2)
	   (#x76E7 . #xE2BA)
	   (#x76E8 . #x8FCED3)
	   (#x76EA . #xE2BB)
	   (#x76EC . #x8FCED4)
	   (#x76EE . #xCCDC)
	   (#x76F0 . #x8FCED5)
	   (#x76F1 . #x8FCED6)
	   (#x76F2 . #xCCD5)
	   (#x76F4 . #xC4BE)
	   (#x76F6 . #x8FCED7)
	   (#x76F8 . #xC1EA)
	   (#x76F9 . #x8FCED8)
	   (#x76FB . #xE2BD)
	   (#x76FC . #x8FCED9)
	   (#x76FE . #xBDE2)
	   (#x7700 . #x8FCEDA)
	   (#x7701 . #xBECA)
	   (#x7704 . #xE2C0)
	   (#x7706 . #x8FCEDB)
	   (#x7707 . #xE2BF)
	   (#x7708 . #xE2BE)
	   (#x7709 . #xC8FD)
	   (#x770A . #x8FCEDC)
	   (#x770B . #xB4C7)
	   (#x770C . #xB8A9)
	   (#x770E . #x8FCEDD)
	   (#x7712 . #x8FCEDE)
	   (#x7714 . #x8FCEDF)
	   (#x7715 . #x8FCEE0)
	   (#x7717 . #x8FCEE1)
	   (#x7719 . #x8FCEE2)
	   (#x771A . #x8FCEE3)
	   (#x771B . #xE2C6)
	   (#x771C . #x8FCEE4)
	   (#x771E . #xE2C3)
	   (#x771F . #xBFBF)
	   (#x7720 . #xCCB2)
	   (#x7722 . #x8FCEE5)
	   (#x7724 . #xE2C2)
	   (#x7725 . #xE2C4)
	   (#x7726 . #xE2C5)
	   (#x7728 . #x8FCEE6)
	   (#x7729 . #xE2C1)
	   (#x772D . #x8FCEE7)
	   (#x772E . #x8FCEE8)
	   (#x772F . #x8FCEE9)
	   (#x7734 . #x8FCEEA)
	   (#x7735 . #x8FCEEB)
	   (#x7736 . #x8FCEEC)
	   (#x7737 . #xE2C7)
	   (#x7738 . #xE2C8)
	   (#x7739 . #x8FCEED)
	   (#x773A . #xC4AF)
	   (#x773C . #xB4E3)
	   (#x773D . #x8FCEEE)
	   (#x773E . #x8FCEEF)
	   (#x7740 . #xC3E5)
	   (#x7742 . #x8FCEF0)
	   (#x7745 . #x8FCEF1)
	   (#x7746 . #x8FCEF2)
	   (#x7747 . #xE2C9)
	   (#x774A . #x8FCEF3)
	   (#x774D . #x8FCEF4)
	   (#x774E . #x8FCEF5)
	   (#x774F . #x8FCEF6)
	   (#x7752 . #x8FCEF7)
	   (#x7756 . #x8FCEF8)
	   (#x7757 . #x8FCEF9)
	   (#x775A . #xE2CA)
	   (#x775B . #xE2CD)
	   (#x775C . #x8FCEFA)
	   (#x775E . #x8FCEFB)
	   (#x775F . #x8FCEFC)
	   (#x7760 . #x8FCEFD)
	   (#x7761 . #xBFE7)
	   (#x7762 . #x8FCEFE)
	   (#x7763 . #xC6C4)
	   (#x7764 . #x8FCFA1)
	   (#x7765 . #xE2CE)
	   (#x7766 . #xCBD3)
	   (#x7767 . #x8FCFA2)
	   (#x7768 . #xE2CB)
	   (#x776A . #x8FCFA3)
	   (#x776B . #xE2CC)
	   (#x776C . #x8FCFA4)
	   (#x7770 . #x8FCFA5)
	   (#x7772 . #x8FCFA6)
	   (#x7773 . #x8FCFA7)
	   (#x7774 . #x8FCFA8)
	   (#x7779 . #xE2D1)
	   (#x777A . #x8FCFA9)
	   (#x777D . #x8FCFAA)
	   (#x777E . #xE2D0)
	   (#x777F . #xE2CF)
	   (#x7780 . #x8FCFAB)
	   (#x7784 . #x8FCFAC)
	   (#x778B . #xE2D3)
	   (#x778C . #x8FCFAD)
	   (#x778D . #x8FCFAE)
	   (#x778E . #xE2D2)
	   (#x7791 . #xE2D4)
	   (#x7794 . #x8FCFAF)
	   (#x7795 . #x8FCFB0)
	   (#x7796 . #x8FCFB1)
	   (#x779A . #x8FCFB2)
	   (#x779E . #xE2D6)
	   (#x779F . #x8FCFB3)
	   (#x77A0 . #xE2D5)
	   (#x77A2 . #x8FCFB4)
	   (#x77A5 . #xCACD)
	   (#x77A7 . #x8FCFB5)
	   (#x77AA . #x8FCFB6)
	   (#x77AC . #xBDD6)
	   (#x77AD . #xCEC6)
	   (#x77AE . #x8FCFB7)
	   (#x77AF . #x8FCFB8)
	   (#x77B0 . #xE2D7)
	   (#x77B1 . #x8FCFB9)
	   (#x77B3 . #xC6B7)
	   (#x77B5 . #x8FCFBA)
	   (#x77B6 . #xE2D8)
	   (#x77B9 . #xE2D9)
	   (#x77BB . #xE2DD)
	   (#x77BC . #xE2DB)
	   (#x77BD . #xE2DC)
	   (#x77BE . #x8FCFBB)
	   (#x77BF . #xE2DA)
	   (#x77C3 . #x8FCFBC)
	   (#x77C7 . #xE2DE)
	   (#x77C9 . #x8FCFBD)
	   (#x77CD . #xE2DF)
	   (#x77D1 . #x8FCFBE)
	   (#x77D2 . #x8FCFBF)
	   (#x77D5 . #x8FCFC0)
	   (#x77D7 . #xE2E0)
	   (#x77D9 . #x8FCFC1)
	   (#x77DA . #xE2E1)
	   (#x77DB . #xCCB7)
	   (#x77DC . #xE2E2)
	   (#x77DE . #x8FCFC2)
	   (#x77DF . #x8FCFC3)
	   (#x77E0 . #x8FCFC4)
	   (#x77E2 . #xCCF0)
	   (#x77E3 . #xE2E3)
	   (#x77E4 . #x8FCFC5)
	   (#x77E5 . #xC3CE)
	   (#x77E6 . #x8FCFC6)
	   (#x77E7 . #xC7EA)
	   (#x77E9 . #xB6EB)
	   (#x77EA . #x8FCFC7)
	   (#x77EC . #x8FCFC8)
	   (#x77ED . #xC3BB)
	   (#x77EE . #xE2E4)
	   (#x77EF . #xB6BA)
	   (#x77F0 . #x8FCFC9)
	   (#x77F1 . #x8FCFCA)
	   (#x77F3 . #xC0D0)
	   (#x77F4 . #x8FCFCB)
	   (#x77F8 . #x8FCFCC)
	   (#x77FB . #x8FCFCD)
	   (#x77FC . #xE2E5)
	   (#x7802 . #xBABD)
	   (#x7805 . #x8FCFCE)
	   (#x7806 . #x8FCFCF)
	   (#x7809 . #x8FCFD0)
	   (#x780C . #xE2E6)
	   (#x780D . #x8FCFD1)
	   (#x780E . #x8FCFD2)
	   (#x7811 . #x8FCFD3)
	   (#x7812 . #xE2E7)
	   (#x7814 . #xB8A6)
	   (#x7815 . #xBAD5)
	   (#x781D . #x8FCFD4)
	   (#x7820 . #xE2E9)
	   (#x7821 . #x8FCFD5)
	   (#x7822 . #x8FCFD6)
	   (#x7823 . #x8FCFD7)
	   (#x7825 . #xC5D6)
	   (#x7826 . #xBAD6)
	   (#x7827 . #xB5CE)
	   (#x782D . #x8FCFD8)
	   (#x782E . #x8FCFD9)
	   (#x7830 . #x8FCFDA)
	   (#x7832 . #xCBA4)
	   (#x7834 . #xC7CB)
	   (#x7835 . #x8FCFDB)
	   (#x7837 . #x8FCFDC)
	   (#x783A . #xC5D7)
	   (#x783F . #xB9DC)
	   (#x7843 . #x8FCFDD)
	   (#x7844 . #x8FCFDE)
	   (#x7845 . #xE2EB)
	   (#x7847 . #x8FCFDF)
	   (#x7848 . #x8FCFE0)
	   (#x784C . #x8FCFE1)
	   (#x784E . #x8FCFE2)
	   (#x7852 . #x8FCFE3)
	   (#x785C . #x8FCFE4)
	   (#x785D . #xBECB)
	   (#x785E . #x8FCFE5)
	   (#x7860 . #x8FCFE6)
	   (#x7861 . #x8FCFE7)
	   (#x7863 . #x8FCFE8)
	   (#x7864 . #x8FCFE9)
	   (#x7868 . #x8FCFEA)
	   (#x786A . #x8FCFEB)
	   (#x786B . #xCEB2)
	   (#x786C . #xB9C5)
	   (#x786E . #x8FCFEC)
	   (#x786F . #xB8A7)
	   (#x7872 . #xC8A3)
	   (#x7874 . #xE2ED)
	   (#x787A . #x8FCFED)
	   (#x787C . #xE2EF)
	   (#x787E . #x8FCFEE)
	   (#x7881 . #xB8EB)
	   (#x7886 . #xE2EE)
	   (#x7887 . #xC4F6)
	   (#x788A . #x8FCFEF)
	   (#x788C . #xE2F1)
	   (#x788D . #xB3B7)
	   (#x788E . #xE2EC)
	   (#x788F . #x8FCFF0)
	   (#x7891 . #xC8EA)
	   (#x7893 . #xB1B0)
	   (#x7894 . #x8FCFF1)
	   (#x7895 . #xBAEC)
	   (#x7897 . #xCFD2)
	   (#x7898 . #x8FCFF2)
	   (#x789A . #xE2F0)
	   (#x789D . #x8FCFF4)
	   (#x789E . #x8FCFF5)
	   (#x789F . #x8FCFF6)
	   (#x78A1 . #x8FCFF3)
	   (#x78A3 . #xE2F2)
	   (#x78A4 . #x8FCFF7)
	   (#x78A7 . #xCACB)
	   (#x78A8 . #x8FCFF8)
	   (#x78A9 . #xC0D9)
	   (#x78AA . #xE2F4)
	   (#x78AC . #x8FCFF9)
	   (#x78AD . #x8FCFFA)
	   (#x78AF . #xE2F5)
	   (#x78B0 . #x8FCFFB)
	   (#x78B1 . #x8FCFFC)
	   (#x78B2 . #x8FCFFD)
	   (#x78B3 . #x8FCFFE)
	   (#x78B5 . #xE2F3)
	   (#x78BA . #xB3CE)
	   (#x78BB . #x8FD0A1)
	   (#x78BC . #xE2FB)
	   (#x78BD . #x8FD0A2)
	   (#x78BE . #xE2FA)
	   (#x78BF . #x8FD0A3)
	   (#x78C1 . #xBCA7)
	   (#x78C5 . #xE2FC)
	   (#x78C6 . #xE2F7)
	   (#x78C7 . #x8FD0A4)
	   (#x78C8 . #x8FD0A5)
	   (#x78C9 . #x8FD0A6)
	   (#x78CA . #xE2FD)
	   (#x78CB . #xE2F8)
	   (#x78CC . #x8FD0A7)
	   (#x78CE . #x8FD0A8)
	   (#x78D0 . #xC8D8)
	   (#x78D1 . #xE2F6)
	   (#x78D2 . #x8FD0A9)
	   (#x78D3 . #x8FD0AA)
	   (#x78D4 . #xE2F9)
	   (#x78D5 . #x8FD0AB)
	   (#x78D6 . #x8FD0AC)
	   (#x78DA . #xE3A2)
	   (#x78DB . #x8FD0AE)
	   (#x78DF . #x8FD0AF)
	   (#x78E0 . #x8FD0B0)
	   (#x78E1 . #x8FD0B1)
	   (#x78E4 . #x8FD0AD)
	   (#x78E6 . #x8FD0B2)
	   (#x78E7 . #xE3A1)
	   (#x78E8 . #xCBE1)
	   (#x78EA . #x8FD0B3)
	   (#x78EC . #xE2FE)
	   (#x78EF . #xB0EB)
	   (#x78F2 . #x8FD0B4)
	   (#x78F3 . #x8FD0B5)
	   (#x78F4 . #xE3A4)
	   (#x78F6 . #x8FD0B7)
	   (#x78F7 . #x8FD0B8)
	   (#x78FA . #x8FD0B9)
	   (#x78FB . #x8FD0BA)
	   (#x78FD . #xE3A3)
	   (#x78FF . #x8FD0BB)
	   (#x7900 . #x8FD0B6)
	   (#x7901 . #xBECC)
	   (#x7906 . #x8FD0BC)
	   (#x7907 . #xE3A5)
	   (#x790C . #x8FD0BD)
	   (#x790E . #xC1C3)
	   (#x7910 . #x8FD0BE)
	   (#x7911 . #xE3A7)
	   (#x7912 . #xE3A6)
	   (#x7919 . #xE3A8)
	   (#x791A . #x8FD0BF)
	   (#x791C . #x8FD0C0)
	   (#x791E . #x8FD0C1)
	   (#x791F . #x8FD0C2)
	   (#x7920 . #x8FD0C3)
	   (#x7925 . #x8FD0C4)
	   (#x7926 . #xE2E8)
	   (#x7927 . #x8FD0C5)
	   (#x7929 . #x8FD0C6)
	   (#x792A . #xE2EA)
	   (#x792B . #xE3AA)
	   (#x792C . #xE3A9)
	   (#x792D . #x8FD0C7)
	   (#x7931 . #x8FD0C8)
	   (#x7934 . #x8FD0C9)
	   (#x7935 . #x8FD0CA)
	   (#x793A . #xBCA8)
	   (#x793B . #x8FD0CB)
	   (#x793C . #xCEE9)
	   (#x793D . #x8FD0CC)
	   (#x793E . #xBCD2)
	   (#x793F . #x8FD0CD)
	   (#x7940 . #xE3AB)
	   (#x7941 . #xB7B7)
	   (#x7944 . #x8FD0CE)
	   (#x7945 . #x8FD0CF)
	   (#x7946 . #x8FD0D0)
	   (#x7947 . #xB5C0)
	   (#x7948 . #xB5A7)
	   (#x7949 . #xBBE3)
	   (#x794A . #x8FD0D1)
	   (#x794B . #x8FD0D2)
	   (#x794F . #x8FD0D3)
	   (#x7950 . #xCDB4)
	   (#x7951 . #x8FD0D4)
	   (#x7953 . #xE3B1)
	   (#x7954 . #x8FD0D5)
	   (#x7955 . #xE3B0)
	   (#x7956 . #xC1C4)
	   (#x7957 . #xE3AD)
	   (#x7958 . #x8FD0D6)
	   (#x795A . #xE3AF)
	   (#x795B . #x8FD0D7)
	   (#x795C . #x8FD0D8)
	   (#x795D . #xBDCB)
	   (#x795E . #xBFC0)
	   (#x795F . #xE3AE)
	   (#x7960 . #xE3AC)
	   (#x7962 . #xC7AA)
	   (#x7965 . #xBECD)
	   (#x7967 . #x8FD0D9)
	   (#x7968 . #xC9BC)
	   (#x7969 . #x8FD0DA)
	   (#x796B . #x8FD0DB)
	   (#x796D . #xBAD7)
	   (#x7972 . #x8FD0DC)
	   (#x7977 . #xC5F8)
	   (#x7979 . #x8FD0DD)
	   (#x797A . #xE3B2)
	   (#x797B . #x8FD0DE)
	   (#x797C . #x8FD0DF)
	   (#x797E . #x8FD0E0)
	   (#x797F . #xE3B3)
	   (#x7980 . #xE3C9)
	   (#x7981 . #xB6D8)
	   (#x7984 . #xCFBD)
	   (#x7985 . #xC1B5)
	   (#x798A . #xE3B4)
	   (#x798B . #x8FD0E1)
	   (#x798C . #x8FD0E2)
	   (#x798D . #xB2D2)
	   (#x798E . #xC4F7)
	   (#x798F . #xCAA1)
	   (#x7991 . #x8FD0E3)
	   (#x7993 . #x8FD0E4)
	   (#x7994 . #x8FD0E5)
	   (#x7995 . #x8FD0E6)
	   (#x7996 . #x8FD0E7)
	   (#x7998 . #x8FD0E8)
	   (#x799B . #x8FD0E9)
	   (#x799C . #x8FD0EA)
	   (#x799D . #xE3B5)
	   (#x79A1 . #x8FD0EB)
	   (#x79A6 . #xB5FA)
	   (#x79A7 . #xE3B6)
	   (#x79A8 . #x8FD0EC)
	   (#x79A9 . #x8FD0ED)
	   (#x79AA . #xE3B8)
	   (#x79AB . #x8FD0EE)
	   (#x79AE . #xE3B9)
	   (#x79AF . #x8FD0EF)
	   (#x79B0 . #xC7A9)
	   (#x79B1 . #x8FD0F0)
	   (#x79B3 . #xE3BA)
	   (#x79B4 . #x8FD0F1)
	   (#x79B8 . #x8FD0F2)
	   (#x79B9 . #xE3BB)
	   (#x79BA . #xE3BC)
	   (#x79BB . #x8FD0F3)
	   (#x79BD . #xB6D9)
	   (#x79BE . #xB2D3)
	   (#x79BF . #xC6C5)
	   (#x79C0 . #xBDA8)
	   (#x79C1 . #xBBE4)
	   (#x79C2 . #x8FD0F4)
	   (#x79C4 . #x8FD0F5)
	   (#x79C7 . #x8FD0F6)
	   (#x79C8 . #x8FD0F7)
	   (#x79C9 . #xE3BD)
	   (#x79CA . #x8FD0F8)
	   (#x79CB . #xBDA9)
	   (#x79CF . #x8FD0F9)
	   (#x79D1 . #xB2CA)
	   (#x79D2 . #xC9C3)
	   (#x79D4 . #x8FD0FA)
	   (#x79D5 . #xE3BE)
	   (#x79D6 . #x8FD0FB)
	   (#x79D8 . #xC8EB)
	   (#x79DA . #x8FD0FC)
	   (#x79DD . #x8FD0FD)
	   (#x79DE . #x8FD0FE)
	   (#x79DF . #xC1C5)
	   (#x79E0 . #x8FD1A1)
	   (#x79E1 . #xE3C1)
	   (#x79E2 . #x8FD1A2)
	   (#x79E3 . #xE3C2)
	   (#x79E4 . #xC7E9)
	   (#x79E5 . #x8FD1A3)
	   (#x79E6 . #xBFC1)
	   (#x79E7 . #xE3BF)
	   (#x79E9 . #xC3E1)
	   (#x79EA . #x8FD1A4)
	   (#x79EB . #x8FD1A5)
	   (#x79EC . #xE3C0)
	   (#x79ED . #x8FD1A6)
	   (#x79F0 . #xBECE)
	   (#x79F1 . #x8FD1A7)
	   (#x79F8 . #x8FD1A8)
	   (#x79FB . #xB0DC)
	   (#x79FC . #x8FD1A9)
	   (#x7A00 . #xB5A9)
	   (#x7A02 . #x8FD1AA)
	   (#x7A03 . #x8FD1AB)
	   (#x7A07 . #x8FD1AC)
	   (#x7A08 . #xE3C3)
	   (#x7A09 . #x8FD1AD)
	   (#x7A0A . #x8FD1AE)
	   (#x7A0B . #xC4F8)
	   (#x7A0C . #x8FD1AF)
	   (#x7A0D . #xE3C4)
	   (#x7A0E . #xC0C7)
	   (#x7A11 . #x8FD1B0)
	   (#x7A14 . #xCCAD)
	   (#x7A15 . #x8FD1B1)
	   (#x7A17 . #xC9A3)
	   (#x7A18 . #xE3C5)
	   (#x7A19 . #xE3C6)
	   (#x7A1A . #xC3D5)
	   (#x7A1B . #x8FD1B2)
	   (#x7A1C . #xCEC7)
	   (#x7A1E . #x8FD1B3)
	   (#x7A1F . #xE3C8)
	   (#x7A20 . #xE3C7)
	   (#x7A21 . #x8FD1B4)
	   (#x7A27 . #x8FD1B5)
	   (#x7A2B . #x8FD1B6)
	   (#x7A2D . #x8FD1B7)
	   (#x7A2E . #xBCEF)
	   (#x7A2F . #x8FD1B8)
	   (#x7A30 . #x8FD1B9)
	   (#x7A31 . #xE3CA)
	   (#x7A32 . #xB0F0)
	   (#x7A34 . #x8FD1BA)
	   (#x7A35 . #x8FD1BB)
	   (#x7A37 . #xE3CD)
	   (#x7A38 . #x8FD1BC)
	   (#x7A39 . #x8FD1BD)
	   (#x7A3A . #x8FD1BE)
	   (#x7A3B . #xE3CB)
	   (#x7A3C . #xB2D4)
	   (#x7A3D . #xB7CE)
	   (#x7A3E . #xE3CC)
	   (#x7A3F . #xB9C6)
	   (#x7A40 . #xB9F2)
	   (#x7A42 . #xCAE6)
	   (#x7A43 . #xE3CE)
	   (#x7A44 . #x8FD1BF)
	   (#x7A45 . #x8FD1C0)
	   (#x7A46 . #xCBD4)
	   (#x7A47 . #x8FD1C1)
	   (#x7A48 . #x8FD1C2)
	   (#x7A49 . #xE3D0)
	   (#x7A4C . #x8FD1C3)
	   (#x7A4D . #xC0D1)
	   (#x7A4E . #xB1CF)
	   (#x7A4F . #xB2BA)
	   (#x7A50 . #xB0AC)
	   (#x7A55 . #x8FD1C4)
	   (#x7A56 . #x8FD1C5)
	   (#x7A57 . #xE3CF)
	   (#x7A59 . #x8FD1C6)
	   (#x7A5C . #x8FD1C7)
	   (#x7A5D . #x8FD1C8)
	   (#x7A5F . #x8FD1C9)
	   (#x7A60 . #x8FD1CA)
	   (#x7A61 . #xE3D1)
	   (#x7A62 . #xE3D2)
	   (#x7A63 . #xBEF7)
	   (#x7A65 . #x8FD1CB)
	   (#x7A67 . #x8FD1CC)
	   (#x7A69 . #xE3D3)
	   (#x7A6A . #x8FD1CD)
	   (#x7A6B . #xB3CF)
	   (#x7A6D . #x8FD1CE)
	   (#x7A70 . #xE3D5)
	   (#x7A74 . #xB7EA)
	   (#x7A75 . #x8FD1CF)
	   (#x7A76 . #xB5E6)
	   (#x7A78 . #x8FD1D0)
	   (#x7A79 . #xE3D6)
	   (#x7A7A . #xB6F5)
	   (#x7A7D . #xE3D7)
	   (#x7A7E . #x8FD1D1)
	   (#x7A7F . #xC0FC)
	   (#x7A80 . #x8FD1D2)
	   (#x7A81 . #xC6CD)
	   (#x7A82 . #x8FD1D3)
	   (#x7A83 . #xC0E0)
	   (#x7A84 . #xBAF5)
	   (#x7A85 . #x8FD1D4)
	   (#x7A86 . #x8FD1D5)
	   (#x7A88 . #xE3D8)
	   (#x7A8A . #x8FD1D6)
	   (#x7A8B . #x8FD1D7)
	   (#x7A90 . #x8FD1D8)
	   (#x7A91 . #x8FD1D9)
	   (#x7A92 . #xC3E2)
	   (#x7A93 . #xC1EB)
	   (#x7A94 . #x8FD1DA)
	   (#x7A95 . #xE3DA)
	   (#x7A96 . #xE3DC)
	   (#x7A97 . #xE3D9)
	   (#x7A98 . #xE3DB)
	   (#x7A9E . #x8FD1DB)
	   (#x7A9F . #xB7A2)
	   (#x7AA0 . #x8FD1DC)
	   (#x7AA3 . #x8FD1DD)
	   (#x7AA9 . #xE3DD)
	   (#x7AAA . #xB7A6)
	   (#x7AAC . #x8FD1DE)
	   (#x7AAE . #xB5E7)
	   (#x7AAF . #xCDD2)
	   (#x7AB0 . #xE3DF)
	   (#x7AB3 . #x8FD1DF)
	   (#x7AB5 . #x8FD1E0)
	   (#x7AB6 . #xE3E0)
	   (#x7AB9 . #x8FD1E1)
	   (#x7ABA . #xB1AE)
	   (#x7ABB . #x8FD1E2)
	   (#x7ABC . #x8FD1E3)
	   (#x7ABF . #xE3E3)
	   (#x7AC3 . #xB3F6)
	   (#x7AC4 . #xE3E2)
	   (#x7AC5 . #xE3E1)
	   (#x7AC6 . #x8FD1E4)
	   (#x7AC7 . #xE3E5)
	   (#x7AC8 . #xE3DE)
	   (#x7AC9 . #x8FD1E5)
	   (#x7ACA . #xE3E6)
	   (#x7ACB . #xCEA9)
	   (#x7ACC . #x8FD1E6)
	   (#x7ACD . #xE3E7)
	   (#x7ACE . #x8FD1E7)
	   (#x7ACF . #xE3E8)
	   (#x7AD1 . #x8FD1E8)
	   (#x7AD2 . #xD4F4)
	   (#x7AD3 . #xE3EA)
	   (#x7AD5 . #xE3E9)
	   (#x7AD9 . #xE3EB)
	   (#x7ADA . #xE3EC)
	   (#x7ADB . #x8FD1E9)
	   (#x7ADC . #xCEB5)
	   (#x7ADD . #xE3ED)
	   (#x7ADF . #xF0EF)
	   (#x7AE0 . #xBECF)
	   (#x7AE1 . #xE3EE)
	   (#x7AE2 . #xE3EF)
	   (#x7AE3 . #xBDD7)
	   (#x7AE5 . #xC6B8)
	   (#x7AE6 . #xE3F0)
	   (#x7AE8 . #x8FD1EA)
	   (#x7AE9 . #x8FD1EB)
	   (#x7AEA . #xC3A8)
	   (#x7AEB . #x8FD1EC)
	   (#x7AEC . #x8FD1ED)
	   (#x7AED . #xE3F1)
	   (#x7AEF . #xC3BC)
	   (#x7AF0 . #xE3F2)
	   (#x7AF1 . #x8FD1EE)
	   (#x7AF4 . #x8FD1EF)
	   (#x7AF6 . #xB6A5)
	   (#x7AF8 . #xD1BF)
	   (#x7AF9 . #xC3DD)
	   (#x7AFA . #xBCB3)
	   (#x7AFB . #x8FD1F0)
	   (#x7AFD . #x8FD1F1)
	   (#x7AFE . #x8FD1F2)
	   (#x7AFF . #xB4C8)
	   (#x7B02 . #xE3F3)
	   (#x7B04 . #xE4A2)
	   (#x7B06 . #xE3F6)
	   (#x7B07 . #x8FD1F3)
	   (#x7B08 . #xB5E8)
	   (#x7B0A . #xE3F5)
	   (#x7B0B . #xE4A4)
	   (#x7B0F . #xE3F4)
	   (#x7B11 . #xBED0)
	   (#x7B14 . #x8FD1F4)
	   (#x7B18 . #xE3F8)
	   (#x7B19 . #xE3F9)
	   (#x7B1B . #xC5AB)
	   (#x7B1E . #xE3FA)
	   (#x7B1F . #x8FD1F5)
	   (#x7B20 . #xB3DE)
	   (#x7B23 . #x8FD1F6)
	   (#x7B25 . #xBFDA)
	   (#x7B26 . #xC9E4)
	   (#x7B27 . #x8FD1F7)
	   (#x7B28 . #xE3FC)
	   (#x7B29 . #x8FD1F8)
	   (#x7B2A . #x8FD1F9)
	   (#x7B2B . #x8FD1FA)
	   (#x7B2C . #xC2E8)
	   (#x7B2D . #x8FD1FB)
	   (#x7B2E . #x8FD1FC)
	   (#x7B2F . #x8FD1FD)
	   (#x7B30 . #x8FD1FE)
	   (#x7B31 . #x8FD2A1)
	   (#x7B33 . #xE3F7)
	   (#x7B34 . #x8FD2A2)
	   (#x7B35 . #xE3FB)
	   (#x7B36 . #xE3FD)
	   (#x7B39 . #xBAFB)
	   (#x7B3D . #x8FD2A3)
	   (#x7B3F . #x8FD2A4)
	   (#x7B40 . #x8FD2A5)
	   (#x7B41 . #x8FD2A6)
	   (#x7B45 . #xE4A6)
	   (#x7B46 . #xC9AE)
	   (#x7B47 . #x8FD2A7)
	   (#x7B48 . #xC8A6)
	   (#x7B49 . #xC5F9)
	   (#x7B4B . #xB6DA)
	   (#x7B4C . #xE4A5)
	   (#x7B4D . #xE4A3)
	   (#x7B4E . #x8FD2A8)
	   (#x7B4F . #xC8B5)
	   (#x7B50 . #xE3FE)
	   (#x7B51 . #xC3DE)
	   (#x7B52 . #xC5FB)
	   (#x7B54 . #xC5FA)
	   (#x7B55 . #x8FD2A9)
	   (#x7B56 . #xBAF6)
	   (#x7B5D . #xE4B8)
	   (#x7B60 . #x8FD2AA)
	   (#x7B64 . #x8FD2AB)
	   (#x7B65 . #xE4A8)
	   (#x7B66 . #x8FD2AC)
	   (#x7B67 . #xE4AA)
	   (#x7B69 . #x8FD2AD)
	   (#x7B6A . #x8FD2AE)
	   (#x7B6C . #xE4AD)
	   (#x7B6D . #x8FD2AF)
	   (#x7B6E . #xE4AE)
	   (#x7B6F . #x8FD2B0)
	   (#x7B70 . #xE4AB)
	   (#x7B71 . #xE4AC)
	   (#x7B72 . #x8FD2B1)
	   (#x7B73 . #x8FD2B2)
	   (#x7B74 . #xE4A9)
	   (#x7B75 . #xE4A7)
	   (#x7B77 . #x8FD2B3)
	   (#x7B7A . #xE4A1)
	   (#x7B84 . #x8FD2B4)
	   (#x7B86 . #xCACF)
	   (#x7B87 . #xB2D5)
	   (#x7B89 . #x8FD2B5)
	   (#x7B8B . #xE4B5)
	   (#x7B8D . #xE4B2)
	   (#x7B8E . #x8FD2B6)
	   (#x7B8F . #xE4B7)
	   (#x7B90 . #x8FD2B7)
	   (#x7B91 . #x8FD2B8)
	   (#x7B92 . #xE4B6)
	   (#x7B94 . #xC7F3)
	   (#x7B95 . #xCCA7)
	   (#x7B96 . #x8FD2B9)
	   (#x7B97 . #xBBBB)
	   (#x7B98 . #xE4B0)
	   (#x7B99 . #xE4B9)
	   (#x7B9A . #xE4B4)
	   (#x7B9B . #x8FD2BA)
	   (#x7B9C . #xE4B3)
	   (#x7B9D . #xE4AF)
	   (#x7B9E . #x8FD2BB)
	   (#x7B9F . #xE4B1)
	   (#x7BA0 . #x8FD2BC)
	   (#x7BA1 . #xB4C9)
	   (#x7BA5 . #x8FD2BD)
	   (#x7BAA . #xC3BD)
	   (#x7BAC . #x8FD2BE)
	   (#x7BAD . #xC0FD)
	   (#x7BAF . #x8FD2BF)
	   (#x7BB0 . #x8FD2C0)
	   (#x7BB1 . #xC8A2)
	   (#x7BB2 . #x8FD2C1)
	   (#x7BB4 . #xE4BE)
	   (#x7BB5 . #x8FD2C2)
	   (#x7BB6 . #x8FD2C3)
	   (#x7BB8 . #xC8A4)
	   (#x7BBA . #x8FD2C4)
	   (#x7BBB . #x8FD2C5)
	   (#x7BBC . #x8FD2C6)
	   (#x7BBD . #x8FD2C7)
	   (#x7BC0 . #xC0E1)
	   (#x7BC1 . #xE4BB)
	   (#x7BC2 . #x8FD2C8)
	   (#x7BC4 . #xC8CF)
	   (#x7BC5 . #x8FD2C9)
	   (#x7BC6 . #xE4BF)
	   (#x7BC7 . #xCAD3)
	   (#x7BC8 . #x8FD2CA)
	   (#x7BC9 . #xC3DB)
	   (#x7BCA . #x8FD2CB)
	   (#x7BCB . #xE4BA)
	   (#x7BCC . #xE4BC)
	   (#x7BCF . #xE4BD)
	   (#x7BD4 . #x8FD2CC)
	   (#x7BD6 . #x8FD2CD)
	   (#x7BD7 . #x8FD2CE)
	   (#x7BD9 . #x8FD2CF)
	   (#x7BDA . #x8FD2D0)
	   (#x7BDB . #x8FD2D1)
	   (#x7BDD . #xE4C0)
	   (#x7BE0 . #xBCC4)
	   (#x7BE4 . #xC6C6)
	   (#x7BE5 . #xE4C5)
	   (#x7BE6 . #xE4C4)
	   (#x7BE8 . #x8FD2D2)
	   (#x7BE9 . #xE4C1)
	   (#x7BEA . #x8FD2D3)
	   (#x7BED . #xCFB6)
	   (#x7BF2 . #x8FD2D4)
	   (#x7BF3 . #xE4CA)
	   (#x7BF4 . #x8FD2D5)
	   (#x7BF5 . #x8FD2D6)
	   (#x7BF6 . #xE4CE)
	   (#x7BF7 . #xE4CB)
	   (#x7BF8 . #x8FD2D7)
	   (#x7BF9 . #x8FD2D8)
	   (#x7BFA . #x8FD2D9)
	   (#x7BFC . #x8FD2DA)
	   (#x7BFE . #x8FD2DB)
	   (#x7C00 . #xE4C7)
	   (#x7C01 . #x8FD2DC)
	   (#x7C02 . #x8FD2DD)
	   (#x7C03 . #x8FD2DE)
	   (#x7C04 . #x8FD2DF)
	   (#x7C06 . #x8FD2E0)
	   (#x7C07 . #xE4C8)
	   (#x7C09 . #x8FD2E1)
	   (#x7C0B . #x8FD2E2)
	   (#x7C0C . #x8FD2E3)
	   (#x7C0D . #xE4CD)
	   (#x7C0E . #x8FD2E4)
	   (#x7C0F . #x8FD2E5)
	   (#x7C11 . #xE4C2)
	   (#x7C12 . #xD2D5)
	   (#x7C13 . #xE4C9)
	   (#x7C14 . #xE4C3)
	   (#x7C17 . #xE4CC)
	   (#x7C19 . #x8FD2E6)
	   (#x7C1B . #x8FD2E7)
	   (#x7C1F . #xE4D2)
	   (#x7C20 . #x8FD2E8)
	   (#x7C21 . #xB4CA)
	   (#x7C23 . #xE4CF)
	   (#x7C25 . #x8FD2E9)
	   (#x7C26 . #x8FD2EA)
	   (#x7C27 . #xE4D0)
	   (#x7C28 . #x8FD2EB)
	   (#x7C2A . #xE4D1)
	   (#x7C2B . #xE4D4)
	   (#x7C2C . #x8FD2EC)
	   (#x7C31 . #x8FD2ED)
	   (#x7C33 . #x8FD2EE)
	   (#x7C34 . #x8FD2EF)
	   (#x7C36 . #x8FD2F0)
	   (#x7C37 . #xE4D3)
	   (#x7C38 . #xC8F6)
	   (#x7C39 . #x8FD2F1)
	   (#x7C3A . #x8FD2F2)
	   (#x7C3D . #xE4D5)
	   (#x7C3E . #xCEFC)
	   (#x7C3F . #xCAED)
	   (#x7C40 . #xE4DA)
	   (#x7C43 . #xE4D7)
	   (#x7C46 . #x8FD2F3)
	   (#x7C4A . #x8FD2F4)
	   (#x7C4C . #xE4D6)
	   (#x7C4D . #xC0D2)
	   (#x7C4F . #xE4D9)
	   (#x7C50 . #xE4DB)
	   (#x7C51 . #x8FD2F6)
	   (#x7C52 . #x8FD2F7)
	   (#x7C53 . #x8FD2F8)
	   (#x7C54 . #xE4D8)
	   (#x7C55 . #x8FD2F5)
	   (#x7C56 . #xE4DF)
	   (#x7C58 . #xE4DC)
	   (#x7C59 . #x8FD2F9)
	   (#x7C5A . #x8FD2FA)
	   (#x7C5B . #x8FD2FB)
	   (#x7C5C . #x8FD2FC)
	   (#x7C5D . #x8FD2FD)
	   (#x7C5E . #x8FD2FE)
	   (#x7C5F . #xE4DD)
	   (#x7C60 . #xE4C6)
	   (#x7C61 . #x8FD3A1)
	   (#x7C63 . #x8FD3A2)
	   (#x7C64 . #xE4DE)
	   (#x7C65 . #xE4E0)
	   (#x7C67 . #x8FD3A3)
	   (#x7C69 . #x8FD3A4)
	   (#x7C6C . #xE4E1)
	   (#x7C6D . #x8FD3A5)
	   (#x7C6E . #x8FD3A6)
	   (#x7C70 . #x8FD3A7)
	   (#x7C72 . #x8FD3A8)
	   (#x7C73 . #xCAC6)
	   (#x7C75 . #xE4E2)
	   (#x7C79 . #x8FD3A9)
	   (#x7C7C . #x8FD3AA)
	   (#x7C7D . #x8FD3AB)
	   (#x7C7E . #xCCE2)
	   (#x7C81 . #xB6CE)
	   (#x7C82 . #xB7A9)
	   (#x7C83 . #xE4E3)
	   (#x7C86 . #x8FD3AC)
	   (#x7C87 . #x8FD3AD)
	   (#x7C89 . #xCAB4)
	   (#x7C8B . #xBFE8)
	   (#x7C8D . #xCCB0)
	   (#x7C8F . #x8FD3AE)
	   (#x7C90 . #xE4E4)
	   (#x7C92 . #xCEB3)
	   (#x7C94 . #x8FD3AF)
	   (#x7C95 . #xC7F4)
	   (#x7C97 . #xC1C6)
	   (#x7C98 . #xC7B4)
	   (#x7C9B . #xBDCD)
	   (#x7C9E . #x8FD3B0)
	   (#x7C9F . #xB0C0)
	   (#x7CA0 . #x8FD3B1)
	   (#x7CA1 . #xE4E9)
	   (#x7CA2 . #xE4E7)
	   (#x7CA4 . #xE4E5)
	   (#x7CA5 . #xB4A1)
	   (#x7CA6 . #x8FD3B2)
	   (#x7CA7 . #xBED1)
	   (#x7CA8 . #xE4EA)
	   (#x7CAB . #xE4E8)
	   (#x7CAD . #xE4E6)
	   (#x7CAE . #xE4EE)
	   (#x7CB0 . #x8FD3B3)
	   (#x7CB1 . #xE4ED)
	   (#x7CB2 . #xE4EC)
	   (#x7CB3 . #xE4EB)
	   (#x7CB6 . #x8FD3B4)
	   (#x7CB7 . #x8FD3B5)
	   (#x7CB9 . #xE4EF)
	   (#x7CBA . #x8FD3B6)
	   (#x7CBB . #x8FD3B7)
	   (#x7CBC . #x8FD3B8)
	   (#x7CBD . #xE4F0)
	   (#x7CBE . #xC0BA)
	   (#x7CBF . #x8FD3B9)
	   (#x7CC0 . #xE4F1)
	   (#x7CC2 . #xE4F3)
	   (#x7CC4 . #x8FD3BA)
	   (#x7CC5 . #xE4F2)
	   (#x7CC7 . #x8FD3BB)
	   (#x7CC8 . #x8FD3BC)
	   (#x7CC9 . #x8FD3BD)
	   (#x7CCA . #xB8D2)
	   (#x7CCD . #x8FD3BE)
	   (#x7CCE . #xC1B8)
	   (#x7CCF . #x8FD3BF)
	   (#x7CD2 . #xE4F5)
	   (#x7CD3 . #x8FD3C0)
	   (#x7CD4 . #x8FD3C1)
	   (#x7CD5 . #x8FD3C2)
	   (#x7CD6 . #xC5FC)
	   (#x7CD7 . #x8FD3C3)
	   (#x7CD8 . #xE4F4)
	   (#x7CD9 . #x8FD3C4)
	   (#x7CDA . #x8FD3C5)
	   (#x7CDC . #xE4F6)
	   (#x7CDD . #x8FD3C6)
	   (#x7CDE . #xCAB5)
	   (#x7CDF . #xC1EC)
	   (#x7CE0 . #xB9C7)
	   (#x7CE2 . #xE4F7)
	   (#x7CE6 . #x8FD3C7)
	   (#x7CE7 . #xCEC8)
	   (#x7CE9 . #x8FD3C8)
	   (#x7CEB . #x8FD3C9)
	   (#x7CEF . #xE4F9)
	   (#x7CF2 . #xE4FA)
	   (#x7CF4 . #xE4FB)
	   (#x7CF5 . #x8FD3CA)
	   (#x7CF6 . #xE4FC)
	   (#x7CF8 . #xBBE5)
	   (#x7CFA . #xE4FD)
	   (#x7CFB . #xB7CF)
	   (#x7CFE . #xB5EA)
	   (#x7D00 . #xB5AA)
	   (#x7D02 . #xE5A1)
	   (#x7D03 . #x8FD3CB)
	   (#x7D04 . #xCCF3)
	   (#x7D05 . #xB9C8)
	   (#x7D06 . #xE4FE)
	   (#x7D07 . #x8FD3CC)
	   (#x7D08 . #x8FD3CD)
	   (#x7D09 . #x8FD3CE)
	   (#x7D0A . #xE5A4)
	   (#x7D0B . #xCCE6)
	   (#x7D0D . #xC7BC)
	   (#x7D0F . #x8FD3CF)
	   (#x7D10 . #xC9B3)
	   (#x7D11 . #x8FD3D0)
	   (#x7D12 . #x8FD3D1)
	   (#x7D13 . #x8FD3D2)
	   (#x7D14 . #xBDE3)
	   (#x7D15 . #xE5A3)
	   (#x7D16 . #x8FD3D3)
	   (#x7D17 . #xBCD3)
	   (#x7D18 . #xB9C9)
	   (#x7D19 . #xBBE6)
	   (#x7D1A . #xB5E9)
	   (#x7D1B . #xCAB6)
	   (#x7D1C . #xE5A2)
	   (#x7D1D . #x8FD3D4)
	   (#x7D1E . #x8FD3D5)
	   (#x7D20 . #xC1C7)
	   (#x7D21 . #xCBC2)
	   (#x7D22 . #xBAF7)
	   (#x7D23 . #x8FD3D6)
	   (#x7D26 . #x8FD3D7)
	   (#x7D2A . #x8FD3D8)
	   (#x7D2B . #xBBE7)
	   (#x7D2C . #xC4DD)
	   (#x7D2D . #x8FD3D9)
	   (#x7D2E . #xE5A7)
	   (#x7D2F . #xCEDF)
	   (#x7D30 . #xBAD9)
	   (#x7D31 . #x8FD3DA)
	   (#x7D32 . #xE5A8)
	   (#x7D33 . #xBFC2)
	   (#x7D35 . #xE5AA)
	   (#x7D39 . #xBED2)
	   (#x7D3A . #xBAB0)
	   (#x7D3C . #x8FD3DB)
	   (#x7D3D . #x8FD3DC)
	   (#x7D3E . #x8FD3DD)
	   (#x7D3F . #xE5A9)
	   (#x7D40 . #x8FD3DE)
	   (#x7D41 . #x8FD3DF)
	   (#x7D42 . #xBDAA)
	   (#x7D43 . #xB8BE)
	   (#x7D44 . #xC1C8)
	   (#x7D45 . #xE5A5)
	   (#x7D46 . #xE5AB)
	   (#x7D47 . #x8FD3E0)
	   (#x7D48 . #x8FD3E1)
	   (#x7D4B . #xE5A6)
	   (#x7D4C . #xB7D0)
	   (#x7D4D . #x8FD3E2)
	   (#x7D4E . #xE5AE)
	   (#x7D4F . #xE5B2)
	   (#x7D50 . #xB7EB)
	   (#x7D51 . #x8FD3E3)
	   (#x7D53 . #x8FD3E4)
	   (#x7D56 . #xE5AD)
	   (#x7D57 . #x8FD3E5)
	   (#x7D59 . #x8FD3E6)
	   (#x7D5A . #x8FD3E7)
	   (#x7D5B . #xE5B6)
	   (#x7D5C . #x8FD3E8)
	   (#x7D5D . #x8FD3E9)
	   (#x7D5E . #xB9CA)
	   (#x7D61 . #xCDED)
	   (#x7D62 . #xB0BC)
	   (#x7D63 . #xE5B3)
	   (#x7D65 . #x8FD3EA)
	   (#x7D66 . #xB5EB)
	   (#x7D67 . #x8FD3EB)
	   (#x7D68 . #xE5B0)
	   (#x7D6A . #x8FD3EC)
	   (#x7D6E . #xE5B1)
	   (#x7D70 . #x8FD3ED)
	   (#x7D71 . #xC5FD)
	   (#x7D72 . #xE5AF)
	   (#x7D73 . #xE5AC)
	   (#x7D75 . #xB3A8)
	   (#x7D76 . #xC0E4)
	   (#x7D78 . #x8FD3EE)
	   (#x7D79 . #xB8A8)
	   (#x7D7A . #x8FD3EF)
	   (#x7D7B . #x8FD3F0)
	   (#x7D7D . #xE5B8)
	   (#x7D7F . #x8FD3F1)
	   (#x7D81 . #x8FD3F2)
	   (#x7D82 . #x8FD3F3)
	   (#x7D83 . #x8FD3F4)
	   (#x7D85 . #x8FD3F5)
	   (#x7D86 . #x8FD3F6)
	   (#x7D88 . #x8FD3F7)
	   (#x7D89 . #xE5B5)
	   (#x7D8B . #x8FD3F8)
	   (#x7D8C . #x8FD3F9)
	   (#x7D8D . #x8FD3FA)
	   (#x7D8F . #xE5B7)
	   (#x7D91 . #x8FD3FB)
	   (#x7D93 . #xE5B4)
	   (#x7D96 . #x8FD3FC)
	   (#x7D97 . #x8FD3FD)
	   (#x7D99 . #xB7D1)
	   (#x7D9A . #xC2B3)
	   (#x7D9B . #xE5B9)
	   (#x7D9C . #xC1EE)
	   (#x7D9D . #x8FD3FE)
	   (#x7D9E . #x8FD4A1)
	   (#x7D9F . #xE5C6)
	   (#x7DA2 . #xE5C2)
	   (#x7DA3 . #xE5BC)
	   (#x7DA6 . #x8FD4A2)
	   (#x7DA7 . #x8FD4A3)
	   (#x7DAA . #x8FD4A4)
	   (#x7DAB . #xE5C0)
	   (#x7DAC . #xBCFA)
	   (#x7DAD . #xB0DD)
	   (#x7DAE . #xE5BB)
	   (#x7DAF . #xE5C3)
	   (#x7DB0 . #xE5C7)
	   (#x7DB1 . #xB9CB)
	   (#x7DB2 . #xCCD6)
	   (#x7DB3 . #x8FD4A5)
	   (#x7DB4 . #xC4D6)
	   (#x7DB5 . #xE5BD)
	   (#x7DB6 . #x8FD4A6)
	   (#x7DB7 . #x8FD4A7)
	   (#x7DB8 . #xE5C5)
	   (#x7DB9 . #x8FD4A8)
	   (#x7DBA . #xE5BA)
	   (#x7DBB . #xC3BE)
	   (#x7DBD . #xE5BF)
	   (#x7DBE . #xB0BD)
	   (#x7DBF . #xCCCA)
	   (#x7DC2 . #x8FD4A9)
	   (#x7DC3 . #x8FD4AA)
	   (#x7DC4 . #x8FD4AB)
	   (#x7DC5 . #x8FD4AC)
	   (#x7DC6 . #x8FD4AD)
	   (#x7DC7 . #xE5BE)
	   (#x7DCA . #xB6DB)
	   (#x7DCB . #xC8EC)
	   (#x7DCC . #x8FD4AE)
	   (#x7DCD . #x8FD4AF)
	   (#x7DCE . #x8FD4B0)
	   (#x7DCF . #xC1ED)
	   (#x7DD1 . #xCED0)
	   (#x7DD2 . #xBDEF)
	   (#x7DD5 . #xE5EE)
	   (#x7DD7 . #x8FD4B1)
	   (#x7DD8 . #xE5C8)
	   (#x7DD9 . #x8FD4B2)
	   (#x7DDA . #xC0FE)
	   (#x7DDC . #xE5C4)
	   (#x7DDD . #xE5C9)
	   (#x7DDE . #xE5CB)
	   (#x7DE0 . #xC4F9)
	   (#x7DE1 . #xE5CE)
	   (#x7DE2 . #x8FD4B4)
	   (#x7DE4 . #xE5CA)
	   (#x7DE5 . #x8FD4B5)
	   (#x7DE6 . #x8FD4B6)
	   (#x7DE8 . #xCAD4)
	   (#x7DE9 . #xB4CB)
	   (#x7DEA . #x8FD4B7)
	   (#x7DEB . #x8FD4B8)
	   (#x7DEC . #xCCCB)
	   (#x7DED . #x8FD4B9)
	   (#x7DEF . #xB0DE)
	   (#x7DF1 . #x8FD4BA)
	   (#x7DF2 . #xE5CD)
	   (#x7DF4 . #xCEFD)
	   (#x7DF5 . #x8FD4BB)
	   (#x7DF6 . #x8FD4BC)
	   (#x7DF9 . #x8FD4BD)
	   (#x7DFA . #x8FD4BE)
	   (#x7DFB . #xE5CC)
	   (#x7E00 . #x8FD4B3)
	   (#x7E01 . #xB1EF)
	   (#x7E04 . #xC6EC)
	   (#x7E05 . #xE5CF)
	   (#x7E08 . #x8FD4BF)
	   (#x7E09 . #xE5D6)
	   (#x7E0A . #xE5D0)
	   (#x7E0B . #xE5D7)
	   (#x7E10 . #x8FD4C0)
	   (#x7E11 . #x8FD4C1)
	   (#x7E12 . #xE5D3)
	   (#x7E15 . #x8FD4C2)
	   (#x7E17 . #x8FD4C3)
	   (#x7E1B . #xC7FB)
	   (#x7E1C . #x8FD4C4)
	   (#x7E1D . #x8FD4C5)
	   (#x7E1E . #xBCCA)
	   (#x7E1F . #xE5D5)
	   (#x7E20 . #x8FD4C6)
	   (#x7E21 . #xE5D2)
	   (#x7E22 . #xE5D8)
	   (#x7E23 . #xE5D1)
	   (#x7E26 . #xBDC4)
	   (#x7E27 . #x8FD4C7)
	   (#x7E28 . #x8FD4C8)
	   (#x7E2B . #xCBA5)
	   (#x7E2C . #x8FD4C9)
	   (#x7E2D . #x8FD4CA)
	   (#x7E2E . #xBDCC)
	   (#x7E2F . #x8FD4CB)
	   (#x7E31 . #xE5D4)
	   (#x7E32 . #xE5E0)
	   (#x7E33 . #x8FD4CC)
	   (#x7E35 . #xE5DC)
	   (#x7E36 . #x8FD4CD)
	   (#x7E37 . #xE5DF)
	   (#x7E39 . #xE5DD)
	   (#x7E3A . #xE5E1)
	   (#x7E3B . #xE5DB)
	   (#x7E3D . #xE5C1)
	   (#x7E3E . #xC0D3)
	   (#x7E3F . #x8FD4CE)
	   (#x7E41 . #xC8CB)
	   (#x7E43 . #xE5DE)
	   (#x7E44 . #x8FD4CF)
	   (#x7E45 . #x8FD4D0)
	   (#x7E46 . #xE5D9)
	   (#x7E47 . #x8FD4D1)
	   (#x7E4A . #xC1A1)
	   (#x7E4B . #xB7D2)
	   (#x7E4D . #xBDAB)
	   (#x7E4E . #x8FD4D2)
	   (#x7E50 . #x8FD4D3)
	   (#x7E52 . #x8FD4D4)
	   (#x7E54 . #xBFA5)
	   (#x7E55 . #xC1B6)
	   (#x7E56 . #xE5E4)
	   (#x7E58 . #x8FD4D5)
	   (#x7E59 . #xE5E6)
	   (#x7E5A . #xE5E7)
	   (#x7E5D . #xE5E3)
	   (#x7E5E . #xE5E5)
	   (#x7E5F . #x8FD4D6)
	   (#x7E61 . #x8FD4D7)
	   (#x7E62 . #x8FD4D8)
	   (#x7E65 . #x8FD4D9)
	   (#x7E66 . #xE5DA)
	   (#x7E67 . #xE5E2)
	   (#x7E69 . #xE5EA)
	   (#x7E6A . #xE5E9)
	   (#x7E6B . #x8FD4DA)
	   (#x7E6D . #xCBFA)
	   (#x7E6E . #x8FD4DB)
	   (#x7E6F . #x8FD4DC)
	   (#x7E70 . #xB7AB)
	   (#x7E73 . #x8FD4DD)
	   (#x7E78 . #x8FD4DE)
	   (#x7E79 . #xE5E8)
	   (#x7E7B . #xE5EC)
	   (#x7E7C . #xE5EB)
	   (#x7E7D . #xE5EF)
	   (#x7E7E . #x8FD4DF)
	   (#x7E7F . #xE5F1)
	   (#x7E81 . #x8FD4E0)
	   (#x7E82 . #xBBBC)
	   (#x7E83 . #xE5ED)
	   (#x7E86 . #x8FD4E1)
	   (#x7E87 . #x8FD4E2)
	   (#x7E88 . #xE5F2)
	   (#x7E89 . #xE5F3)
	   (#x7E8A . #x8FD4E3)
	   (#x7E8C . #xE5F4)
	   (#x7E8D . #x8FD4E4)
	   (#x7E8E . #xE5FA)
	   (#x7E8F . #xC5BB)
	   (#x7E90 . #xE5F6)
	   (#x7E91 . #x8FD4E5)
	   (#x7E92 . #xE5F5)
	   (#x7E93 . #xE5F7)
	   (#x7E94 . #xE5F8)
	   (#x7E95 . #x8FD4E6)
	   (#x7E96 . #xE5F9)
	   (#x7E98 . #x8FD4E7)
	   (#x7E9A . #x8FD4E8)
	   (#x7E9B . #xE5FB)
	   (#x7E9C . #xE5FC)
	   (#x7E9D . #x8FD4E9)
	   (#x7E9E . #x8FD4EA)
	   (#x7F36 . #xB4CC)
	   (#x7F38 . #xE5FD)
	   (#x7F3A . #xE5FE)
	   (#x7F3B . #x8FD4EC)
	   (#x7F3C . #x8FD4EB)
	   (#x7F3D . #x8FD4ED)
	   (#x7F3E . #x8FD4EE)
	   (#x7F3F . #x8FD4EF)
	   (#x7F43 . #x8FD4F0)
	   (#x7F44 . #x8FD4F1)
	   (#x7F45 . #xE6A1)
	   (#x7F47 . #x8FD4F2)
	   (#x7F4C . #xE6A2)
	   (#x7F4D . #xE6A3)
	   (#x7F4E . #xE6A4)
	   (#x7F4F . #x8FD4F3)
	   (#x7F50 . #xE6A5)
	   (#x7F51 . #xE6A6)
	   (#x7F52 . #x8FD4F4)
	   (#x7F53 . #x8FD4F5)
	   (#x7F54 . #xE6A8)
	   (#x7F55 . #xE6A7)
	   (#x7F58 . #xE6A9)
	   (#x7F5B . #x8FD4F6)
	   (#x7F5C . #x8FD4F7)
	   (#x7F5D . #x8FD4F8)
	   (#x7F5F . #xE6AA)
	   (#x7F60 . #xE6AB)
	   (#x7F61 . #x8FD4F9)
	   (#x7F63 . #x8FD4FA)
	   (#x7F64 . #x8FD4FB)
	   (#x7F65 . #x8FD4FC)
	   (#x7F66 . #x8FD4FD)
	   (#x7F67 . #xE6AE)
	   (#x7F68 . #xE6AC)
	   (#x7F69 . #xE6AD)
	   (#x7F6A . #xBAE1)
	   (#x7F6B . #xB7D3)
	   (#x7F6D . #x8FD4FE)
	   (#x7F6E . #xC3D6)
	   (#x7F70 . #xC8B3)
	   (#x7F71 . #x8FD5A1)
	   (#x7F72 . #xBDF0)
	   (#x7F75 . #xC7CD)
	   (#x7F77 . #xC8ED)
	   (#x7F78 . #xE6AF)
	   (#x7F79 . #xD8ED)
	   (#x7F7D . #x8FD5A2)
	   (#x7F7E . #x8FD5A3)
	   (#x7F7F . #x8FD5A4)
	   (#x7F80 . #x8FD5A5)
	   (#x7F82 . #xE6B0)
	   (#x7F83 . #xE6B2)
	   (#x7F85 . #xCDE5)
	   (#x7F86 . #xE6B1)
	   (#x7F87 . #xE6B4)
	   (#x7F88 . #xE6B3)
	   (#x7F8A . #xCDD3)
	   (#x7F8B . #x8FD5A6)
	   (#x7F8C . #xE6B5)
	   (#x7F8D . #x8FD5A7)
	   (#x7F8E . #xC8FE)
	   (#x7F8F . #x8FD5A8)
	   (#x7F90 . #x8FD5A9)
	   (#x7F91 . #x8FD5AA)
	   (#x7F94 . #xE6B6)
	   (#x7F96 . #x8FD5AB)
	   (#x7F97 . #x8FD5AC)
	   (#x7F9A . #xE6B9)
	   (#x7F9C . #x8FD5AD)
	   (#x7F9D . #xE6B8)
	   (#x7F9E . #xE6B7)
	   (#x7FA1 . #x8FD5AE)
	   (#x7FA2 . #x8FD5AF)
	   (#x7FA3 . #xE6BA)
	   (#x7FA4 . #xB7B2)
	   (#x7FA6 . #x8FD5B0)
	   (#x7FA8 . #xC1A2)
	   (#x7FA9 . #xB5C1)
	   (#x7FAA . #x8FD5B1)
	   (#x7FAD . #x8FD5B2)
	   (#x7FAE . #xE6BE)
	   (#x7FAF . #xE6BB)
	   (#x7FB2 . #xE6BC)
	   (#x7FB4 . #x8FD5B3)
	   (#x7FB6 . #xE6BF)
	   (#x7FB8 . #xE6C0)
	   (#x7FB9 . #xE6BD)
	   (#x7FBC . #x8FD5B4)
	   (#x7FBD . #xB1A9)
	   (#x7FBF . #x8FD5B5)
	   (#x7FC0 . #x8FD5B6)
	   (#x7FC1 . #xB2A7)
	   (#x7FC3 . #x8FD5B7)
	   (#x7FC5 . #xE6C2)
	   (#x7FC6 . #xE6C3)
	   (#x7FC8 . #x8FD5B8)
	   (#x7FCA . #xE6C4)
	   (#x7FCC . #xCDE2)
	   (#x7FCE . #x8FD5B9)
	   (#x7FCF . #x8FD5BA)
	   (#x7FD2 . #xBDAC)
	   (#x7FD4 . #xE6C6)
	   (#x7FD5 . #xE6C5)
	   (#x7FDB . #x8FD5BB)
	   (#x7FDF . #x8FD5BC)
	   (#x7FE0 . #xBFE9)
	   (#x7FE1 . #xE6C7)
	   (#x7FE3 . #x8FD5BD)
	   (#x7FE5 . #x8FD5BE)
	   (#x7FE6 . #xE6C8)
	   (#x7FE8 . #x8FD5BF)
	   (#x7FE9 . #xE6C9)
	   (#x7FEB . #xB4E5)
	   (#x7FEC . #x8FD5C0)
	   (#x7FEE . #x8FD5C1)
	   (#x7FEF . #x8FD5C2)
	   (#x7FF0 . #xB4CD)
	   (#x7FF2 . #x8FD5C3)
	   (#x7FF3 . #xE6CA)
	   (#x7FF9 . #xE6CB)
	   (#x7FFA . #x8FD5C4)
	   (#x7FFB . #xCBDD)
	   (#x7FFC . #xCDE3)
	   (#x7FFD . #x8FD5C5)
	   (#x7FFE . #x8FD5C6)
	   (#x7FFF . #x8FD5C7)
	   (#x8000 . #xCDD4)
	   (#x8001 . #xCFB7)
	   (#x8003 . #xB9CD)
	   (#x8004 . #xE6CE)
	   (#x8005 . #xBCD4)
	   (#x8006 . #xE6CD)
	   (#x8007 . #x8FD5C8)
	   (#x8008 . #x8FD5C9)
	   (#x800A . #x8FD5CA)
	   (#x800B . #xE6CF)
	   (#x800C . #xBCA9)
	   (#x800D . #x8FD5CB)
	   (#x800E . #x8FD5CC)
	   (#x800F . #x8FD5CD)
	   (#x8010 . #xC2D1)
	   (#x8011 . #x8FD5CE)
	   (#x8012 . #xE6D0)
	   (#x8013 . #x8FD5CF)
	   (#x8014 . #x8FD5D0)
	   (#x8015 . #xB9CC)
	   (#x8016 . #x8FD5D1)
	   (#x8017 . #xCCD7)
	   (#x8018 . #xE6D1)
	   (#x8019 . #xE6D2)
	   (#x801C . #xE6D3)
	   (#x801D . #x8FD5D2)
	   (#x801E . #x8FD5D3)
	   (#x801F . #x8FD5D4)
	   (#x8020 . #x8FD5D5)
	   (#x8021 . #xE6D4)
	   (#x8024 . #x8FD5D6)
	   (#x8026 . #x8FD5D7)
	   (#x8028 . #xE6D5)
	   (#x802C . #x8FD5D8)
	   (#x802E . #x8FD5D9)
	   (#x8030 . #x8FD5DA)
	   (#x8033 . #xBCAA)
	   (#x8034 . #x8FD5DB)
	   (#x8035 . #x8FD5DC)
	   (#x8036 . #xCCED)
	   (#x8037 . #x8FD5DD)
	   (#x8039 . #x8FD5DE)
	   (#x803A . #x8FD5DF)
	   (#x803B . #xE6D7)
	   (#x803C . #x8FD5E0)
	   (#x803D . #xC3BF)
	   (#x803E . #x8FD5E1)
	   (#x803F . #xE6D6)
	   (#x8040 . #x8FD5E2)
	   (#x8044 . #x8FD5E3)
	   (#x8046 . #xE6D9)
	   (#x804A . #xE6D8)
	   (#x8052 . #xE6DA)
	   (#x8056 . #xC0BB)
	   (#x8058 . #xE6DB)
	   (#x805A . #xE6DC)
	   (#x805E . #xCAB9)
	   (#x805F . #xE6DD)
	   (#x8060 . #x8FD5E4)
	   (#x8061 . #xC1EF)
	   (#x8062 . #xE6DE)
	   (#x8064 . #x8FD5E5)
	   (#x8066 . #x8FD5E6)
	   (#x8068 . #xE6DF)
	   (#x806D . #x8FD5E7)
	   (#x806F . #xCEFE)
	   (#x8070 . #xE6E2)
	   (#x8071 . #x8FD5E8)
	   (#x8072 . #xE6E1)
	   (#x8073 . #xE6E0)
	   (#x8074 . #xC4B0)
	   (#x8075 . #x8FD5E9)
	   (#x8076 . #xE6E3)
	   (#x8077 . #xBFA6)
	   (#x8079 . #xE6E4)
	   (#x807D . #xE6E5)
	   (#x807E . #xCFB8)
	   (#x807F . #xE6E6)
	   (#x8081 . #x8FD5EA)
	   (#x8084 . #xE6E7)
	   (#x8085 . #xE6E9)
	   (#x8086 . #xE6E8)
	   (#x8087 . #xC8A5)
	   (#x8088 . #x8FD5EB)
	   (#x8089 . #xC6F9)
	   (#x808B . #xCFBE)
	   (#x808C . #xC8A9)
	   (#x808E . #x8FD5EC)
	   (#x8093 . #xE6EB)
	   (#x8096 . #xBED3)
	   (#x8098 . #xC9AA)
	   (#x809A . #xE6EC)
	   (#x809B . #xE6EA)
	   (#x809C . #x8FD5ED)
	   (#x809D . #xB4CE)
	   (#x809E . #x8FD5EE)
	   (#x80A1 . #xB8D4)
	   (#x80A2 . #xBBE8)
	   (#x80A5 . #xC8EE)
	   (#x80A6 . #x8FD5EF)
	   (#x80A7 . #x8FD5F0)
	   (#x80A9 . #xB8AA)
	   (#x80AA . #xCBC3)
	   (#x80AB . #x8FD5F1)
	   (#x80AC . #xE6EF)
	   (#x80AD . #xE6ED)
	   (#x80AF . #xB9CE)
	   (#x80B1 . #xB9CF)
	   (#x80B2 . #xB0E9)
	   (#x80B4 . #xBAE8)
	   (#x80B8 . #x8FD5F2)
	   (#x80B9 . #x8FD5F3)
	   (#x80BA . #xC7D9)
	   (#x80C3 . #xB0DF)
	   (#x80C4 . #xE6F4)
	   (#x80C6 . #xC3C0)
	   (#x80C8 . #x8FD5F4)
	   (#x80CC . #xC7D8)
	   (#x80CD . #x8FD5F5)
	   (#x80CE . #xC2DB)
	   (#x80CF . #x8FD5F6)
	   (#x80D2 . #x8FD5F7)
	   (#x80D4 . #x8FD5F8)
	   (#x80D5 . #x8FD5F9)
	   (#x80D6 . #xE6F6)
	   (#x80D7 . #x8FD5FA)
	   (#x80D8 . #x8FD5FB)
	   (#x80D9 . #xE6F2)
	   (#x80DA . #xE6F5)
	   (#x80DB . #xE6F0)
	   (#x80DD . #xE6F3)
	   (#x80DE . #xCBA6)
	   (#x80E0 . #x8FD5FC)
	   (#x80E1 . #xB8D5)
	   (#x80E4 . #xB0FD)
	   (#x80E5 . #xE6F1)
	   (#x80ED . #x8FD5FD)
	   (#x80EE . #x8FD5FE)
	   (#x80EF . #xE6F8)
	   (#x80F0 . #x8FD6A1)
	   (#x80F1 . #xE6F9)
	   (#x80F2 . #x8FD6A2)
	   (#x80F3 . #x8FD6A3)
	   (#x80F4 . #xC6B9)
	   (#x80F6 . #x8FD6A4)
	   (#x80F8 . #xB6BB)
	   (#x80F9 . #x8FD6A5)
	   (#x80FA . #x8FD6A6)
	   (#x80FC . #xE7A6)
	   (#x80FD . #xC7BD)
	   (#x80FE . #x8FD6A7)
	   (#x8102 . #xBBE9)
	   (#x8103 . #x8FD6A8)
	   (#x8105 . #xB6BC)
	   (#x8106 . #xC0C8)
	   (#x8107 . #xCFC6)
	   (#x8108 . #xCCAE)
	   (#x8109 . #xE6F7)
	   (#x810A . #xC0D4)
	   (#x810B . #x8FD6A9)
	   (#x8116 . #x8FD6AA)
	   (#x8117 . #x8FD6AB)
	   (#x8118 . #x8FD6AC)
	   (#x811A . #xB5D3)
	   (#x811B . #xE6FA)
	   (#x811C . #x8FD6AD)
	   (#x811E . #x8FD6AE)
	   (#x8120 . #x8FD6AF)
	   (#x8123 . #xE6FC)
	   (#x8124 . #x8FD6B0)
	   (#x8127 . #x8FD6B1)
	   (#x8129 . #xE6FB)
	   (#x812C . #x8FD6B2)
	   (#x812F . #xE6FD)
	   (#x8130 . #x8FD6B3)
	   (#x8131 . #xC3A6)
	   (#x8133 . #xC7BE)
	   (#x8135 . #x8FD6B4)
	   (#x8139 . #xC4B1)
	   (#x813A . #x8FD6B5)
	   (#x813C . #x8FD6B6)
	   (#x813E . #xE7A3)
	   (#x8145 . #x8FD6B7)
	   (#x8146 . #xE7A2)
	   (#x8147 . #x8FD6B8)
	   (#x814A . #x8FD6B9)
	   (#x814B . #xE6FE)
	   (#x814C . #x8FD6BA)
	   (#x814E . #xBFD5)
	   (#x8150 . #xC9E5)
	   (#x8151 . #xE7A5)
	   (#x8152 . #x8FD6BB)
	   (#x8153 . #xE7A4)
	   (#x8154 . #xB9D0)
	   (#x8155 . #xCFD3)
	   (#x8157 . #x8FD6BC)
	   (#x815F . #xE7B5)
	   (#x8160 . #x8FD6BD)
	   (#x8161 . #x8FD6BE)
	   (#x8165 . #xE7A9)
	   (#x8166 . #xE7AA)
	   (#x8167 . #x8FD6BF)
	   (#x8168 . #x8FD6C0)
	   (#x8169 . #x8FD6C1)
	   (#x816B . #xBCF0)
	   (#x816D . #x8FD6C2)
	   (#x816E . #xE7A8)
	   (#x816F . #x8FD6C3)
	   (#x8170 . #xB9F8)
	   (#x8171 . #xE7A7)
	   (#x8174 . #xE7AB)
	   (#x8177 . #x8FD6C4)
	   (#x8178 . #xC4B2)
	   (#x8179 . #xCAA2)
	   (#x817A . #xC1A3)
	   (#x817F . #xC2DC)
	   (#x8180 . #xE7AF)
	   (#x8181 . #x8FD6C5)
	   (#x8182 . #xE7B0)
	   (#x8183 . #xE7AC)
	   (#x8184 . #x8FD6C7)
	   (#x8185 . #x8FD6C8)
	   (#x8186 . #x8FD6C9)
	   (#x8188 . #xE7AD)
	   (#x818A . #xE7AE)
	   (#x818B . #x8FD6CA)
	   (#x818E . #x8FD6CB)
	   (#x818F . #xB9D1)
	   (#x8190 . #x8FD6C6)
	   (#x8193 . #xE7B6)
	   (#x8195 . #xE7B2)
	   (#x8196 . #x8FD6CC)
	   (#x8198 . #x8FD6CD)
	   (#x819A . #xC9E6)
	   (#x819B . #x8FD6CE)
	   (#x819C . #xCBEC)
	   (#x819D . #xC9A8)
	   (#x819E . #x8FD6CF)
	   (#x81A0 . #xE7B1)
	   (#x81A2 . #x8FD6D0)
	   (#x81A3 . #xE7B4)
	   (#x81A4 . #xE7B3)
	   (#x81A8 . #xCBC4)
	   (#x81A9 . #xE7B7)
	   (#x81AE . #x8FD6D1)
	   (#x81B0 . #xE7B8)
	   (#x81B2 . #x8FD6D2)
	   (#x81B3 . #xC1B7)
	   (#x81B4 . #x8FD6D3)
	   (#x81B5 . #xE7B9)
	   (#x81B8 . #xE7BB)
	   (#x81BA . #xE7BF)
	   (#x81BB . #x8FD6D4)
	   (#x81BD . #xE7BC)
	   (#x81BE . #xE7BA)
	   (#x81BF . #xC7BF)
	   (#x81C0 . #xE7BD)
	   (#x81C2 . #xE7BE)
	   (#x81C3 . #x8FD6D6)
	   (#x81C5 . #x8FD6D7)
	   (#x81C6 . #xB2B2)
	   (#x81C8 . #xE7C5)
	   (#x81C9 . #xE7C0)
	   (#x81CA . #x8FD6D8)
	   (#x81CB . #x8FD6D5)
	   (#x81CD . #xE7C1)
	   (#x81CE . #x8FD6D9)
	   (#x81CF . #x8FD6DA)
	   (#x81D1 . #xE7C2)
	   (#x81D3 . #xC2A1)
	   (#x81D5 . #x8FD6DB)
	   (#x81D7 . #x8FD6DC)
	   (#x81D8 . #xE7C4)
	   (#x81D9 . #xE7C3)
	   (#x81DA . #xE7C6)
	   (#x81DB . #x8FD6DD)
	   (#x81DD . #x8FD6DE)
	   (#x81DE . #x8FD6DF)
	   (#x81DF . #xE7C7)
	   (#x81E0 . #xE7C8)
	   (#x81E1 . #x8FD6E0)
	   (#x81E3 . #xBFC3)
	   (#x81E4 . #x8FD6E1)
	   (#x81E5 . #xB2E9)
	   (#x81E7 . #xE7C9)
	   (#x81E8 . #xCED7)
	   (#x81EA . #xBCAB)
	   (#x81EB . #x8FD6E2)
	   (#x81EC . #x8FD6E3)
	   (#x81ED . #xBDAD)
	   (#x81F0 . #x8FD6E4)
	   (#x81F1 . #x8FD6E5)
	   (#x81F2 . #x8FD6E6)
	   (#x81F3 . #xBBEA)
	   (#x81F4 . #xC3D7)
	   (#x81F5 . #x8FD6E7)
	   (#x81F6 . #x8FD6E8)
	   (#x81F8 . #x8FD6E9)
	   (#x81F9 . #x8FD6EA)
	   (#x81FA . #xE7CA)
	   (#x81FB . #xE7CB)
	   (#x81FC . #xB1B1)
	   (#x81FD . #x8FD6EB)
	   (#x81FE . #xE7CC)
	   (#x81FF . #x8FD6EC)
	   (#x8200 . #x8FD6ED)
	   (#x8201 . #xE7CD)
	   (#x8202 . #xE7CE)
	   (#x8203 . #x8FD6EE)
	   (#x8205 . #xE7CF)
	   (#x8207 . #xE7D0)
	   (#x8208 . #xB6BD)
	   (#x8209 . #xDAAA)
	   (#x820A . #xE7D1)
	   (#x820C . #xC0E5)
	   (#x820D . #xE7D2)
	   (#x820E . #xBCCB)
	   (#x820F . #x8FD6EF)
	   (#x8210 . #xE7D3)
	   (#x8212 . #xD0B0)
	   (#x8213 . #x8FD6F0)
	   (#x8214 . #x8FD6F1)
	   (#x8216 . #xE7D4)
	   (#x8217 . #xCADE)
	   (#x8218 . #xB4DC)
	   (#x8219 . #x8FD6F2)
	   (#x821A . #x8FD6F3)
	   (#x821B . #xC1A4)
	   (#x821C . #xBDD8)
	   (#x821D . #x8FD6F4)
	   (#x821E . #xC9F1)
	   (#x821F . #xBDAE)
	   (#x8221 . #x8FD6F5)
	   (#x8222 . #x8FD6F6)
	   (#x8228 . #x8FD6F7)
	   (#x8229 . #xE7D5)
	   (#x822A . #xB9D2)
	   (#x822B . #xE7D6)
	   (#x822C . #xC8CC)
	   (#x822E . #xE7E4)
	   (#x8232 . #x8FD6F8)
	   (#x8233 . #xE7D8)
	   (#x8234 . #x8FD6F9)
	   (#x8235 . #xC2C9)
	   (#x8236 . #xC7F5)
	   (#x8237 . #xB8BF)
	   (#x8238 . #xE7D7)
	   (#x8239 . #xC1A5)
	   (#x823A . #x8FD6FA)
	   (#x8240 . #xE7D9)
	   (#x8243 . #x8FD6FB)
	   (#x8244 . #x8FD6FC)
	   (#x8245 . #x8FD6FD)
	   (#x8246 . #x8FD6FE)
	   (#x8247 . #xC4FA)
	   (#x824B . #x8FD7A1)
	   (#x824E . #x8FD7A2)
	   (#x824F . #x8FD7A3)
	   (#x8251 . #x8FD7A4)
	   (#x8256 . #x8FD7A5)
	   (#x8258 . #xE7DB)
	   (#x8259 . #xE7DA)
	   (#x825A . #xE7DD)
	   (#x825C . #x8FD7A6)
	   (#x825D . #xE7DC)
	   (#x825F . #xE7DE)
	   (#x8260 . #x8FD7A7)
	   (#x8262 . #xE7E0)
	   (#x8263 . #x8FD7A8)
	   (#x8264 . #xE7DF)
	   (#x8266 . #xB4CF)
	   (#x8267 . #x8FD7A9)
	   (#x8268 . #xE7E1)
	   (#x826A . #xE7E2)
	   (#x826B . #xE7E3)
	   (#x826D . #x8FD7AA)
	   (#x826E . #xBAB1)
	   (#x826F . #xCEC9)
	   (#x8271 . #xE7E5)
	   (#x8272 . #xBFA7)
	   (#x8274 . #x8FD7AB)
	   (#x8276 . #xB1F0)
	   (#x8277 . #xE7E6)
	   (#x8278 . #xE7E7)
	   (#x827B . #x8FD7AC)
	   (#x827D . #x8FD7AD)
	   (#x827E . #xE7E8)
	   (#x827F . #x8FD7AE)
	   (#x8280 . #x8FD7AF)
	   (#x8281 . #x8FD7B0)
	   (#x8283 . #x8FD7B1)
	   (#x8284 . #x8FD7B2)
	   (#x8287 . #x8FD7B3)
	   (#x8289 . #x8FD7B4)
	   (#x828A . #x8FD7B5)
	   (#x828B . #xB0F2)
	   (#x828D . #xE7E9)
	   (#x828E . #x8FD7B6)
	   (#x8291 . #x8FD7B7)
	   (#x8292 . #xE7EA)
	   (#x8294 . #x8FD7B8)
	   (#x8296 . #x8FD7B9)
	   (#x8298 . #x8FD7BA)
	   (#x8299 . #xC9E7)
	   (#x829A . #x8FD7BB)
	   (#x829B . #x8FD7BC)
	   (#x829D . #xBCC7)
	   (#x829F . #xE7EC)
	   (#x82A0 . #x8FD7BD)
	   (#x82A1 . #x8FD7BE)
	   (#x82A3 . #x8FD7BF)
	   (#x82A4 . #x8FD7C0)
	   (#x82A5 . #xB3A9)
	   (#x82A6 . #xB0B2)
	   (#x82A7 . #x8FD7C1)
	   (#x82A8 . #x8FD7C2)
	   (#x82A9 . #x8FD7C3)
	   (#x82AA . #x8FD7C4)
	   (#x82AB . #xE7EB)
	   (#x82AC . #xE7EE)
	   (#x82AD . #xC7CE)
	   (#x82AE . #x8FD7C5)
	   (#x82AF . #xBFC4)
	   (#x82B0 . #x8FD7C6)
	   (#x82B1 . #xB2D6)
	   (#x82B2 . #x8FD7C7)
	   (#x82B3 . #xCBA7)
	   (#x82B4 . #x8FD7C8)
	   (#x82B7 . #x8FD7C9)
	   (#x82B8 . #xB7DD)
	   (#x82B9 . #xB6DC)
	   (#x82BA . #x8FD7CA)
	   (#x82BB . #xE7ED)
	   (#x82BC . #x8FD7CB)
	   (#x82BD . #xB2EA)
	   (#x82BE . #x8FD7CC)
	   (#x82BF . #x8FD7CD)
	   (#x82C5 . #xB4A3)
	   (#x82C6 . #x8FD7CE)
	   (#x82D0 . #x8FD7CF)
	   (#x82D1 . #xB1F1)
	   (#x82D2 . #xE7F2)
	   (#x82D3 . #xCEEA)
	   (#x82D4 . #xC2DD)
	   (#x82D5 . #x8FD7D0)
	   (#x82D7 . #xC9C4)
	   (#x82D9 . #xE7FE)
	   (#x82DA . #x8FD7D1)
	   (#x82DB . #xB2D7)
	   (#x82DC . #xE7FC)
	   (#x82DE . #xE7FA)
	   (#x82DF . #xE7F1)
	   (#x82E0 . #x8FD7D2)
	   (#x82E1 . #xE7EF)
	   (#x82E2 . #x8FD7D3)
	   (#x82E3 . #xE7F0)
	   (#x82E4 . #x8FD7D4)
	   (#x82E5 . #xBCE3)
	   (#x82E6 . #xB6EC)
	   (#x82E7 . #xC3F7)
	   (#x82E8 . #x8FD7D5)
	   (#x82EA . #x8FD7D6)
	   (#x82EB . #xC6D1)
	   (#x82ED . #x8FD7D7)
	   (#x82EF . #x8FD7D8)
	   (#x82F1 . #xB1D1)
	   (#x82F3 . #xE7F4)
	   (#x82F4 . #xE7F3)
	   (#x82F6 . #x8FD7D9)
	   (#x82F7 . #x8FD7DA)
	   (#x82F9 . #xE7F9)
	   (#x82FA . #xE7F5)
	   (#x82FB . #xE7F8)
	   (#x82FD . #x8FD7DB)
	   (#x82FE . #x8FD7DC)
	   (#x8300 . #x8FD7DD)
	   (#x8301 . #x8FD7DE)
	   (#x8302 . #xCCD0)
	   (#x8303 . #xE7F7)
	   (#x8304 . #xB2D8)
	   (#x8305 . #xB3FD)
	   (#x8306 . #xE7FB)
	   (#x8307 . #x8FD7DF)
	   (#x8308 . #x8FD7E0)
	   (#x8309 . #xE7FD)
	   (#x830A . #x8FD7E1)
	   (#x830B . #x8FD7E2)
	   (#x830E . #xB7D4)
	   (#x8316 . #xE8A3)
	   (#x8317 . #xE8AC)
	   (#x8318 . #xE8AD)
	   (#x831B . #x8FD7E4)
	   (#x831C . #xB0AB)
	   (#x831D . #x8FD7E5)
	   (#x831E . #x8FD7E6)
	   (#x831F . #x8FD7E7)
	   (#x8321 . #x8FD7E8)
	   (#x8322 . #x8FD7E9)
	   (#x8323 . #xE8B4)
	   (#x8328 . #xB0F1)
	   (#x832B . #xE8AB)
	   (#x832C . #x8FD7EA)
	   (#x832D . #x8FD7EB)
	   (#x832E . #x8FD7EC)
	   (#x832F . #xE8AA)
	   (#x8330 . #x8FD7ED)
	   (#x8331 . #xE8A5)
	   (#x8332 . #xE8A4)
	   (#x8333 . #x8FD7EE)
	   (#x8334 . #xE8A2)
	   (#x8335 . #xE8A1)
	   (#x8336 . #xC3E3)
	   (#x8337 . #x8FD7EF)
	   (#x8338 . #xC2FB)
	   (#x8339 . #xE8A7)
	   (#x833A . #x8FD7F0)
	   (#x833C . #x8FD7F1)
	   (#x833D . #x8FD7F2)
	   (#x8340 . #xE8A6)
	   (#x8342 . #x8FD7F3)
	   (#x8343 . #x8FD7F4)
	   (#x8344 . #x8FD7F5)
	   (#x8345 . #xE8A9)
	   (#x8347 . #x8FD7F6)
	   (#x8349 . #xC1F0)
	   (#x834A . #xB7D5)
	   (#x834D . #x8FD7F7)
	   (#x834E . #x8FD7F8)
	   (#x834F . #xB1C1)
	   (#x8350 . #xE8A8)
	   (#x8351 . #x8FD7F9)
	   (#x8352 . #xB9D3)
	   (#x8353 . #x8FD8BE)
	   (#x8354 . #x8FD7E3)
	   (#x8355 . #x8FD7FA)
	   (#x8356 . #x8FD7FB)
	   (#x8357 . #x8FD7FC)
	   (#x8358 . #xC1F1)
	   (#x8370 . #x8FD7FD)
	   (#x8373 . #xE8BA)
	   (#x8375 . #xE8BB)
	   (#x8377 . #xB2D9)
	   (#x8378 . #x8FD7FE)
	   (#x837B . #xB2AE)
	   (#x837C . #xE8B8)
	   (#x837D . #x8FD8A1)
	   (#x837F . #x8FD8A2)
	   (#x8380 . #x8FD8A3)
	   (#x8382 . #x8FD8A4)
	   (#x8384 . #x8FD8A5)
	   (#x8385 . #xE8AE)
	   (#x8386 . #x8FD8A6)
	   (#x8387 . #xE8B6)
	   (#x8389 . #xE8BD)
	   (#x838A . #xE8B7)
	   (#x838D . #x8FD8A7)
	   (#x838E . #xE8B5)
	   (#x8392 . #x8FD8A8)
	   (#x8393 . #xE7F6)
	   (#x8394 . #x8FD8A9)
	   (#x8395 . #x8FD8AA)
	   (#x8396 . #xE8B3)
	   (#x8398 . #x8FD8AB)
	   (#x8399 . #x8FD8AC)
	   (#x839A . #xE8AF)
	   (#x839B . #x8FD8AD)
	   (#x839C . #x8FD8AE)
	   (#x839D . #x8FD8AF)
	   (#x839E . #xB4D0)
	   (#x839F . #xE8B1)
	   (#x83A0 . #xE8BC)
	   (#x83A2 . #xE8B2)
	   (#x83A6 . #x8FD8B0)
	   (#x83A7 . #x8FD8B1)
	   (#x83A8 . #xE8BE)
	   (#x83A9 . #x8FD8B2)
	   (#x83AA . #xE8B0)
	   (#x83AB . #xC7FC)
	   (#x83AC . #x8FD8B3)
	   (#x83AD . #x8FD8CC)
	   (#x83B1 . #xCDE9)
	   (#x83B5 . #xE8B9)
	   (#x83BD . #xE8CF)
	   (#x83BE . #x8FD8B4)
	   (#x83BF . #x8FD8B5)
	   (#x83C0 . #x8FD8B6)
	   (#x83C1 . #xE8C7)
	   (#x83C5 . #xBFFB)
	   (#x83C7 . #x8FD8B7)
	   (#x83C9 . #x8FD8B8)
	   (#x83CA . #xB5C6)
	   (#x83CC . #xB6DD)
	   (#x83CE . #xE8C2)
	   (#x83CF . #x8FD8B9)
	   (#x83D0 . #x8FD8BA)
	   (#x83D1 . #x8FD8BB)
	   (#x83D3 . #xB2DB)
	   (#x83D4 . #x8FD8BC)
	   (#x83D6 . #xBED4)
	   (#x83D8 . #xE8C5)
	   (#x83DC . #xBADA)
	   (#x83DD . #x8FD8BD)
	   (#x83DF . #xC5D1)
	   (#x83E0 . #xE8CA)
	   (#x83E8 . #x8FD8BF)
	   (#x83E9 . #xCAEE)
	   (#x83EA . #x8FD8C0)
	   (#x83EB . #xE8C1)
	   (#x83EF . #xB2DA)
	   (#x83F0 . #xB8D6)
	   (#x83F1 . #xC9A9)
	   (#x83F2 . #xE8CB)
	   (#x83F4 . #xE8BF)
	   (#x83F6 . #x8FD8C1)
	   (#x83F7 . #xE8C8)
	   (#x83F8 . #x8FD8C2)
	   (#x83F9 . #x8FD8C3)
	   (#x83FB . #xE8D2)
	   (#x83FC . #x8FD8C4)
	   (#x83FD . #xE8C3)
	   (#x8401 . #x8FD8C5)
	   (#x8403 . #xE8C4)
	   (#x8404 . #xC6BA)
	   (#x8406 . #x8FD8C6)
	   (#x8407 . #xE8C9)
	   (#x840A . #x8FD8C7)
	   (#x840B . #xE8C6)
	   (#x840C . #xCBA8)
	   (#x840D . #xE8CC)
	   (#x840E . #xB0E0)
	   (#x840F . #x8FD8C8)
	   (#x8411 . #x8FD8C9)
	   (#x8413 . #xE8C0)
	   (#x8415 . #x8FD8CA)
	   (#x8419 . #x8FD8CB)
	   (#x8420 . #xE8CE)
	   (#x8422 . #xE8CD)
	   (#x8429 . #xC7EB)
	   (#x842A . #xE8D4)
	   (#x842C . #xE8DF)
	   (#x842F . #x8FD8CD)
	   (#x8431 . #xB3FE)
	   (#x8435 . #xE8E2)
	   (#x8438 . #xE8D0)
	   (#x8439 . #x8FD8CE)
	   (#x843C . #xE8D5)
	   (#x843D . #xCDEE)
	   (#x8445 . #x8FD8CF)
	   (#x8446 . #xE8DE)
	   (#x8447 . #x8FD8D0)
	   (#x8448 . #x8FD8D1)
	   (#x8449 . #xCDD5)
	   (#x844A . #x8FD8D2)
	   (#x844D . #x8FD8D3)
	   (#x844E . #xCEAA)
	   (#x844F . #x8FD8D4)
	   (#x8451 . #x8FD8D5)
	   (#x8452 . #x8FD8D6)
	   (#x8456 . #x8FD8D7)
	   (#x8457 . #xC3F8)
	   (#x8458 . #x8FD8D8)
	   (#x8459 . #x8FD8D9)
	   (#x845A . #x8FD8DA)
	   (#x845B . #xB3EB)
	   (#x845C . #x8FD8DB)
	   (#x8460 . #x8FD8DC)
	   (#x8461 . #xC9F2)
	   (#x8462 . #xE8E4)
	   (#x8463 . #xC6A1)
	   (#x8464 . #x8FD8DD)
	   (#x8465 . #x8FD8DE)
	   (#x8466 . #xB0B1)
	   (#x8467 . #x8FD8DF)
	   (#x8469 . #xE8DD)
	   (#x846A . #x8FD8E0)
	   (#x846B . #xE8D9)
	   (#x846C . #xC1F2)
	   (#x846D . #xE8D3)
	   (#x846E . #xE8DB)
	   (#x846F . #xE8E0)
	   (#x8470 . #x8FD8E1)
	   (#x8471 . #xC7AC)
	   (#x8473 . #x8FD8E2)
	   (#x8474 . #x8FD8E3)
	   (#x8475 . #xB0AA)
	   (#x8476 . #x8FD8E4)
	   (#x8477 . #xE8D8)
	   (#x8478 . #x8FD8E5)
	   (#x8479 . #xE8E1)
	   (#x847A . #xC9F8)
	   (#x847C . #x8FD8E6)
	   (#x847D . #x8FD8E7)
	   (#x8481 . #x8FD8E8)
	   (#x8482 . #xE8DC)
	   (#x8484 . #xE8D7)
	   (#x8485 . #x8FD8E9)
	   (#x848B . #xBED5)
	   (#x8490 . #xBDAF)
	   (#x8492 . #x8FD8EA)
	   (#x8493 . #x8FD8EB)
	   (#x8494 . #xBCAC)
	   (#x8495 . #x8FD8EC)
	   (#x8499 . #xCCD8)
	   (#x849C . #xC9C7)
	   (#x849E . #x8FD8ED)
	   (#x849F . #xE8E7)
	   (#x84A1 . #xE8F0)
	   (#x84A6 . #x8FD8EE)
	   (#x84A8 . #x8FD8EF)
	   (#x84A9 . #x8FD8F0)
	   (#x84AA . #x8FD8F1)
	   (#x84AD . #xE8DA)
	   (#x84AF . #x8FD8F2)
	   (#x84B1 . #x8FD8F3)
	   (#x84B2 . #xB3F7)
	   (#x84B4 . #x8FD8F4)
	   (#x84B8 . #xBEF8)
	   (#x84B9 . #xE8E5)
	   (#x84BA . #x8FD8F5)
	   (#x84BB . #xE8EA)
	   (#x84BC . #xC1F3)
	   (#x84BD . #x8FD8F6)
	   (#x84BE . #x8FD8F7)
	   (#x84BF . #xE8E6)
	   (#x84C0 . #x8FD8F8)
	   (#x84C1 . #xE8ED)
	   (#x84C2 . #x8FD8F9)
	   (#x84C4 . #xC3DF)
	   (#x84C6 . #xE8EE)
	   (#x84C7 . #x8FD8FA)
	   (#x84C8 . #x8FD8FB)
	   (#x84C9 . #xCDD6)
	   (#x84CA . #xE8E3)
	   (#x84CB . #xB3B8)
	   (#x84CC . #x8FD8FC)
	   (#x84CD . #xE8E9)
	   (#x84CF . #x8FD8FD)
	   (#x84D0 . #xE8EC)
	   (#x84D1 . #xCCAC)
	   (#x84D3 . #x8FD8FE)
	   (#x84D6 . #xE8EF)
	   (#x84D9 . #xE8E8)
	   (#x84DA . #xE8EB)
	   (#x84DC . #x8FD9A1)
	   (#x84E7 . #x8FD9A2)
	   (#x84EA . #x8FD9A3)
	   (#x84EC . #xCBA9)
	   (#x84EE . #xCFA1)
	   (#x84EF . #x8FD9A4)
	   (#x84F0 . #x8FD9A5)
	   (#x84F1 . #x8FD9A6)
	   (#x84F2 . #x8FD9A7)
	   (#x84F4 . #xE8F3)
	   (#x84F7 . #x8FD9A8)
	   (#x84FA . #x8FD9AA)
	   (#x84FB . #x8FD9AB)
	   (#x84FC . #xE8FA)
	   (#x84FD . #x8FD9AC)
	   (#x84FF . #xE8F2)
	   (#x8500 . #xBCC3)
	   (#x8502 . #x8FD9AD)
	   (#x8503 . #x8FD9AE)
	   (#x8506 . #xE8D1)
	   (#x8507 . #x8FD9AF)
	   (#x850C . #x8FD9B0)
	   (#x850E . #x8FD9B1)
	   (#x8510 . #x8FD9B2)
	   (#x8511 . #xCACE)
	   (#x8513 . #xCCA2)
	   (#x8514 . #xE8F9)
	   (#x8515 . #xE8F8)
	   (#x8517 . #xE8F4)
	   (#x8518 . #xE8F5)
	   (#x851A . #xB1B6)
	   (#x851C . #x8FD9B3)
	   (#x851E . #x8FD9B4)
	   (#x851F . #xE8F7)
	   (#x8521 . #xE8F1)
	   (#x8522 . #x8FD9B5)
	   (#x8523 . #x8FD9B6)
	   (#x8524 . #x8FD9B7)
	   (#x8525 . #x8FD9B8)
	   (#x8526 . #xC4D5)
	   (#x8527 . #x8FD9B9)
	   (#x852A . #x8FD9BA)
	   (#x852B . #x8FD9BB)
	   (#x852C . #xE8F6)
	   (#x852D . #xB0FE)
	   (#x852F . #x8FD9BC)
	   (#x8532 . #x8FD9A9)
	   (#x8533 . #x8FD9BD)
	   (#x8534 . #x8FD9BE)
	   (#x8535 . #xC2A2)
	   (#x8536 . #x8FD9BF)
	   (#x853D . #xCAC3)
	   (#x853F . #x8FD9C0)
	   (#x8540 . #xE8FB)
	   (#x8541 . #xE9A1)
	   (#x8543 . #xC8D9)
	   (#x8546 . #x8FD9C1)
	   (#x8548 . #xE8FE)
	   (#x8549 . #xBED6)
	   (#x854A . #xBCC9)
	   (#x854B . #xE9A3)
	   (#x854E . #xB6BE)
	   (#x854F . #x8FD9C2)
	   (#x8550 . #x8FD9C3)
	   (#x8551 . #x8FD9C4)
	   (#x8552 . #x8FD9C5)
	   (#x8553 . #x8FD9C6)
	   (#x8555 . #xE9A4)
	   (#x8556 . #x8FD9C7)
	   (#x8557 . #xC9F9)
	   (#x8558 . #xE8FD)
	   (#x8559 . #x8FD9C8)
	   (#x855A . #xE8D6)
	   (#x855C . #x8FD9C9)
	   (#x855D . #x8FD9CA)
	   (#x855E . #x8FD9CB)
	   (#x855F . #x8FD9CC)
	   (#x8560 . #x8FD9CD)
	   (#x8561 . #x8FD9CE)
	   (#x8562 . #x8FD9CF)
	   (#x8563 . #xE8FC)
	   (#x8564 . #x8FD9D0)
	   (#x8568 . #xCFCF)
	   (#x8569 . #xC6A2)
	   (#x856A . #xC9F3)
	   (#x856B . #x8FD9D1)
	   (#x856D . #xE9AB)
	   (#x856F . #x8FD9D2)
	   (#x8577 . #xE9B1)
	   (#x8579 . #x8FD9D3)
	   (#x857A . #x8FD9D4)
	   (#x857B . #x8FD9D5)
	   (#x857D . #x8FD9D6)
	   (#x857E . #xE9B2)
	   (#x857F . #x8FD9D7)
	   (#x8580 . #xE9A5)
	   (#x8581 . #x8FD9D8)
	   (#x8584 . #xC7F6)
	   (#x8585 . #x8FD9D9)
	   (#x8586 . #x8FD9DA)
	   (#x8587 . #xE9AF)
	   (#x8588 . #xE9A7)
	   (#x8589 . #x8FD9DB)
	   (#x858A . #xE9A9)
	   (#x858B . #x8FD9DC)
	   (#x858C . #x8FD9DD)
	   (#x858F . #x8FD9DE)
	   (#x8590 . #xE9B3)
	   (#x8591 . #xE9A8)
	   (#x8593 . #x8FD9DF)
	   (#x8594 . #xE9AC)
	   (#x8597 . #xB1F2)
	   (#x8598 . #x8FD9E0)
	   (#x8599 . #xC6E5)
	   (#x859B . #xE9AD)
	   (#x859C . #xE9B0)
	   (#x859D . #x8FD9E1)
	   (#x859F . #x8FD9E2)
	   (#x85A0 . #x8FD9E3)
	   (#x85A2 . #x8FD9E4)
	   (#x85A4 . #xE9A6)
	   (#x85A5 . #x8FD9E5)
	   (#x85A6 . #xC1A6)
	   (#x85A7 . #x8FD9E6)
	   (#x85A8 . #xE9AA)
	   (#x85A9 . #xBBA7)
	   (#x85AA . #xBFC5)
	   (#x85AB . #xB7B0)
	   (#x85AC . #xCCF4)
	   (#x85AD . #x8FD9F4)
	   (#x85AE . #xCCF9)
	   (#x85AF . #xBDF2)
	   (#x85B4 . #x8FD9E7)
	   (#x85B6 . #x8FD9E8)
	   (#x85B7 . #x8FD9E9)
	   (#x85B8 . #x8FD9EA)
	   (#x85B9 . #xE9B7)
	   (#x85BA . #xE9B5)
	   (#x85BC . #x8FD9EB)
	   (#x85BD . #x8FD9EC)
	   (#x85BE . #x8FD9ED)
	   (#x85BF . #x8FD9EE)
	   (#x85C1 . #xCFCE)
	   (#x85C2 . #x8FD9EF)
	   (#x85C7 . #x8FD9F0)
	   (#x85C9 . #xE9B4)
	   (#x85CA . #x8FD9F1)
	   (#x85CB . #x8FD9F2)
	   (#x85CD . #xCDF5)
	   (#x85CE . #x8FD9F3)
	   (#x85CF . #xE9B6)
	   (#x85D0 . #xE9B8)
	   (#x85D5 . #xE9B9)
	   (#x85D8 . #x8FD9F5)
	   (#x85DA . #x8FD9F6)
	   (#x85DC . #xE9BC)
	   (#x85DD . #xE9BA)
	   (#x85DF . #x8FD9F7)
	   (#x85E0 . #x8FD9F8)
	   (#x85E4 . #xC6A3)
	   (#x85E5 . #xE9BB)
	   (#x85E6 . #x8FD9F9)
	   (#x85E8 . #x8FD9FA)
	   (#x85E9 . #xC8CD)
	   (#x85EA . #xE9AE)
	   (#x85ED . #x8FD9FB)
	   (#x85F3 . #x8FD9FC)
	   (#x85F6 . #x8FD9FD)
	   (#x85F7 . #xBDF3)
	   (#x85F9 . #xE9BD)
	   (#x85FA . #xE9C2)
	   (#x85FB . #xC1F4)
	   (#x85FC . #x8FD9FE)
	   (#x85FE . #xE9C1)
	   (#x85FF . #x8FDAA1)
	   (#x8600 . #x8FDAA2)
	   (#x8602 . #xE9A2)
	   (#x8604 . #x8FDAA3)
	   (#x8605 . #x8FDAA4)
	   (#x8606 . #xE9C3)
	   (#x8607 . #xC1C9)
	   (#x860A . #xE9BE)
	   (#x860B . #xE9C0)
	   (#x860D . #x8FDAA5)
	   (#x860E . #x8FDAA6)
	   (#x8610 . #x8FDAA7)
	   (#x8611 . #x8FDAA8)
	   (#x8612 . #x8FDAA9)
	   (#x8613 . #xE9BF)
	   (#x8616 . #xDDB1)
	   (#x8617 . #xDDA2)
	   (#x8618 . #x8FDAAA)
	   (#x8619 . #x8FDAAB)
	   (#x861A . #xE9C5)
	   (#x861B . #x8FDAAC)
	   (#x861E . #x8FDAAD)
	   (#x8621 . #x8FDAAE)
	   (#x8622 . #xE9C4)
	   (#x8627 . #x8FDAAF)
	   (#x8629 . #x8FDAB0)
	   (#x862D . #xCDF6)
	   (#x862F . #xE2BC)
	   (#x8630 . #xE9C6)
	   (#x8636 . #x8FDAB1)
	   (#x8638 . #x8FDAB2)
	   (#x863A . #x8FDAB3)
	   (#x863C . #x8FDAB4)
	   (#x863D . #x8FDAB5)
	   (#x863F . #xE9C7)
	   (#x8640 . #x8FDAB6)
	   (#x8641 . #x8FB8E6)
	   (#x8642 . #x8FDAB7)
	   (#x8646 . #x8FDAB8)
	   (#x864D . #xE9C8)
	   (#x864E . #xB8D7)
	   (#x8650 . #xB5D4)
	   (#x8652 . #x8FDAB9)
	   (#x8653 . #x8FDABA)
	   (#x8654 . #xE9CA)
	   (#x8655 . #xD1DD)
	   (#x8656 . #x8FDABB)
	   (#x8657 . #x8FDABC)
	   (#x8658 . #x8FDABD)
	   (#x8659 . #x8FDABE)
	   (#x865A . #xB5F5)
	   (#x865C . #xCEBA)
	   (#x865D . #x8FDABF)
	   (#x865E . #xB6F3)
	   (#x865F . #xE9CB)
	   (#x8660 . #x8FDAC0)
	   (#x8661 . #x8FDAC1)
	   (#x8662 . #x8FDAC2)
	   (#x8663 . #x8FDAC3)
	   (#x8664 . #x8FDAC4)
	   (#x8667 . #xE9CC)
	   (#x8669 . #x8FDAC5)
	   (#x866B . #xC3EE)
	   (#x866C . #x8FDAC6)
	   (#x866F . #x8FDAC7)
	   (#x8671 . #xE9CD)
	   (#x8675 . #x8FDAC8)
	   (#x8676 . #x8FDAC9)
	   (#x8677 . #x8FDACA)
	   (#x8679 . #xC6FA)
	   (#x867A . #x8FDACB)
	   (#x867B . #xB0BA)
	   (#x8688 . #x8FDAED)
	   (#x868A . #xB2E3)
	   (#x868B . #xE9D2)
	   (#x868C . #xE9D3)
	   (#x868D . #x8FDACC)
	   (#x8691 . #x8FDACD)
	   (#x8693 . #xE9CE)
	   (#x8695 . #xBBBD)
	   (#x8696 . #x8FDACE)
	   (#x8698 . #x8FDACF)
	   (#x869A . #x8FDAD0)
	   (#x869C . #x8FDAD1)
	   (#x86A1 . #x8FDAD2)
	   (#x86A3 . #xE9CF)
	   (#x86A4 . #xC7C2)
	   (#x86A6 . #x8FDAD3)
	   (#x86A7 . #x8FDAD4)
	   (#x86A8 . #x8FDAD5)
	   (#x86A9 . #xE9D0)
	   (#x86AA . #xE9D1)
	   (#x86AB . #xE9DB)
	   (#x86AD . #x8FDAD6)
	   (#x86AF . #xE9D5)
	   (#x86B0 . #xE9D8)
	   (#x86B1 . #x8FDAD7)
	   (#x86B3 . #x8FDAD8)
	   (#x86B4 . #x8FDAD9)
	   (#x86B5 . #x8FDADA)
	   (#x86B6 . #xE9D4)
	   (#x86B7 . #x8FDADB)
	   (#x86B8 . #x8FDADC)
	   (#x86B9 . #x8FDADD)
	   (#x86BF . #x8FDADE)
	   (#x86C0 . #x8FDADF)
	   (#x86C1 . #x8FDAE0)
	   (#x86C3 . #x8FDAE1)
	   (#x86C4 . #xE9D6)
	   (#x86C5 . #x8FDAE2)
	   (#x86C6 . #xE9D7)
	   (#x86C7 . #xBCD8)
	   (#x86C9 . #xE9D9)
	   (#x86CB . #xC3C1)
	   (#x86CD . #xB7D6)
	   (#x86CE . #xB3C2)
	   (#x86D1 . #x8FDAE3)
	   (#x86D2 . #x8FDAE4)
	   (#x86D4 . #xE9DC)
	   (#x86D5 . #x8FDAE5)
	   (#x86D7 . #x8FDAE6)
	   (#x86D9 . #xB3BF)
	   (#x86DA . #x8FDAE7)
	   (#x86DB . #xE9E1)
	   (#x86DC . #x8FDAE8)
	   (#x86DE . #xE9DD)
	   (#x86DF . #xE9E0)
	   (#x86E0 . #x8FDAE9)
	   (#x86E3 . #x8FDAEA)
	   (#x86E4 . #xC8BA)
	   (#x86E5 . #x8FDAEB)
	   (#x86E7 . #x8FDAEC)
	   (#x86E9 . #xE9DE)
	   (#x86EC . #xE9DF)
	   (#x86ED . #xC9C8)
	   (#x86EE . #xC8DA)
	   (#x86EF . #xE9E2)
	   (#x86F8 . #xC2FD)
	   (#x86F9 . #xE9EC)
	   (#x86FA . #x8FDAEE)
	   (#x86FB . #xE9E8)
	   (#x86FC . #x8FDAEF)
	   (#x86FD . #x8FDAF0)
	   (#x86FE . #xB2EB)
	   (#x8700 . #xE9E6)
	   (#x8702 . #xCBAA)
	   (#x8703 . #xE9E7)
	   (#x8704 . #x8FDAF1)
	   (#x8705 . #x8FDAF2)
	   (#x8706 . #xE9E4)
	   (#x8707 . #x8FDAF3)
	   (#x8708 . #xE9E5)
	   (#x8709 . #xE9EA)
	   (#x870A . #xE9ED)
	   (#x870B . #x8FDAF4)
	   (#x870D . #xE9EB)
	   (#x870E . #x8FDAF5)
	   (#x870F . #x8FDAF6)
	   (#x8710 . #x8FDAF7)
	   (#x8711 . #xE9E9)
	   (#x8712 . #xE9E3)
	   (#x8713 . #x8FDAF8)
	   (#x8714 . #x8FDAF9)
	   (#x8718 . #xC3D8)
	   (#x8719 . #x8FDAFA)
	   (#x871A . #xE9F4)
	   (#x871C . #xCCAA)
	   (#x871E . #x8FDAFB)
	   (#x871F . #x8FDAFC)
	   (#x8721 . #x8FDAFD)
	   (#x8723 . #x8FDAFE)
	   (#x8725 . #xE9F2)
	   (#x8728 . #x8FDBA1)
	   (#x8729 . #xE9F3)
	   (#x872E . #x8FDBA2)
	   (#x872F . #x8FDBA3)
	   (#x8731 . #x8FDBA4)
	   (#x8732 . #x8FDBA5)
	   (#x8734 . #xE9EE)
	   (#x8737 . #xE9F0)
	   (#x8739 . #x8FDBA6)
	   (#x873A . #x8FDBA7)
	   (#x873B . #xE9F1)
	   (#x873C . #x8FDBA8)
	   (#x873D . #x8FDBA9)
	   (#x873E . #x8FDBAA)
	   (#x873F . #xE9EF)
	   (#x8740 . #x8FDBAB)
	   (#x8743 . #x8FDBAC)
	   (#x8745 . #x8FDBAD)
	   (#x8749 . #xC0E6)
	   (#x874B . #xCFB9)
	   (#x874C . #xE9F8)
	   (#x874D . #x8FDBAE)
	   (#x874E . #xE9F9)
	   (#x8753 . #xEAA1)
	   (#x8755 . #xBFAA)
	   (#x8757 . #xE9FB)
	   (#x8758 . #x8FDBAF)
	   (#x8759 . #xE9FE)
	   (#x875D . #x8FDBB0)
	   (#x875F . #xE9F6)
	   (#x8760 . #xE9F5)
	   (#x8761 . #x8FDBB1)
	   (#x8763 . #xEAA2)
	   (#x8764 . #x8FDBB2)
	   (#x8765 . #x8FDBB3)
	   (#x8766 . #xB2DC)
	   (#x8768 . #xE9FC)
	   (#x876A . #xEAA3)
	   (#x876E . #xE9FD)
	   (#x876F . #x8FDBB4)
	   (#x8771 . #x8FDBB5)
	   (#x8772 . #x8FDBB6)
	   (#x8774 . #xE9FA)
	   (#x8776 . #xC4B3)
	   (#x8778 . #xE9F7)
	   (#x877B . #x8FDBB7)
	   (#x877F . #xC7E8)
	   (#x8782 . #xEAA7)
	   (#x8783 . #x8FDBB8)
	   (#x8784 . #x8FDBB9)
	   (#x8785 . #x8FDBBA)
	   (#x8786 . #x8FDBBB)
	   (#x8787 . #x8FDBBC)
	   (#x8788 . #x8FDBBD)
	   (#x8789 . #x8FDBBE)
	   (#x878B . #x8FDBBF)
	   (#x878C . #x8FDBC0)
	   (#x878D . #xCDBB)
	   (#x8790 . #x8FDBC1)
	   (#x8793 . #x8FDBC2)
	   (#x8795 . #x8FDBC3)
	   (#x8797 . #x8FDBC4)
	   (#x8798 . #x8FDBC5)
	   (#x8799 . #x8FDBC6)
	   (#x879E . #x8FDBC7)
	   (#x879F . #xEAA6)
	   (#x87A0 . #x8FDBC8)
	   (#x87A2 . #xEAA5)
	   (#x87A3 . #x8FDBC9)
	   (#x87A7 . #x8FDBCA)
	   (#x87AB . #xEAAE)
	   (#x87AC . #x8FDBCB)
	   (#x87AD . #x8FDBCC)
	   (#x87AE . #x8FDBCD)
	   (#x87AF . #xEAA8)
	   (#x87B1 . #x8FDBCE)
	   (#x87B3 . #xEAB0)
	   (#x87B5 . #x8FDBCF)
	   (#x87BA . #xCDE6)
	   (#x87BB . #xEAB3)
	   (#x87BD . #xEAAA)
	   (#x87BE . #x8FDBD0)
	   (#x87BF . #x8FDBD1)
	   (#x87C0 . #xEAAB)
	   (#x87C1 . #x8FDBD2)
	   (#x87C4 . #xEAAF)
	   (#x87C6 . #xEAB2)
	   (#x87C7 . #xEAB1)
	   (#x87C8 . #x8FDBD3)
	   (#x87C9 . #x8FDBD4)
	   (#x87CA . #x8FDBD5)
	   (#x87CB . #xEAA9)
	   (#x87CE . #x8FDBD6)
	   (#x87D0 . #xEAAC)
	   (#x87D2 . #xEABD)
	   (#x87D5 . #x8FDBD7)
	   (#x87D6 . #x8FDBD8)
	   (#x87D9 . #x8FDBD9)
	   (#x87DA . #x8FDBDA)
	   (#x87DC . #x8FDBDB)
	   (#x87DF . #x8FDBDC)
	   (#x87E0 . #xEAB6)
	   (#x87E2 . #x8FDBDD)
	   (#x87E3 . #x8FDBDE)
	   (#x87E4 . #x8FDBDF)
	   (#x87EA . #x8FDBE0)
	   (#x87EB . #x8FDBE1)
	   (#x87ED . #x8FDBE2)
	   (#x87EF . #xEAB4)
	   (#x87F1 . #x8FDBE3)
	   (#x87F2 . #xEAB5)
	   (#x87F3 . #x8FDBE4)
	   (#x87F6 . #xEABA)
	   (#x87F7 . #xEABB)
	   (#x87F8 . #x8FDBE5)
	   (#x87F9 . #xB3AA)
	   (#x87FA . #x8FDBE6)
	   (#x87FB . #xB5C2)
	   (#x87FE . #xEAB9)
	   (#x87FF . #x8FDBE7)
	   (#x8801 . #x8FDBE8)
	   (#x8803 . #x8FDBE9)
	   (#x8805 . #xEAA4)
	   (#x8806 . #x8FDBEA)
	   (#x8809 . #x8FDBEB)
	   (#x880A . #x8FDBEC)
	   (#x880B . #x8FDBED)
	   (#x880D . #xEAB8)
	   (#x880E . #xEABC)
	   (#x880F . #xEAB7)
	   (#x8810 . #x8FDBEE)
	   (#x8811 . #xEABE)
	   (#x8812 . #x8FDBF0)
	   (#x8813 . #x8FDBF1)
	   (#x8814 . #x8FDBF2)
	   (#x8815 . #xEAC0)
	   (#x8816 . #xEABF)
	   (#x8818 . #x8FDBF3)
	   (#x8819 . #x8FDBEF)
	   (#x881A . #x8FDBF4)
	   (#x881B . #x8FDBF5)
	   (#x881C . #x8FDBF6)
	   (#x881E . #x8FDBF7)
	   (#x881F . #x8FDBF8)
	   (#x8821 . #xEAC2)
	   (#x8822 . #xEAC1)
	   (#x8823 . #xE9DA)
	   (#x8827 . #xEAC6)
	   (#x8828 . #x8FDBF9)
	   (#x882D . #x8FDBFA)
	   (#x882E . #x8FDBFB)
	   (#x8830 . #x8FDBFC)
	   (#x8831 . #xEAC3)
	   (#x8832 . #x8FDBFD)
	   (#x8835 . #x8FDBFE)
	   (#x8836 . #xEAC4)
	   (#x8839 . #xEAC5)
	   (#x883A . #x8FDCA1)
	   (#x883B . #xEAC7)
	   (#x883C . #x8FDCA2)
	   (#x8840 . #xB7EC)
	   (#x8841 . #x8FDCA3)
	   (#x8842 . #xEAC9)
	   (#x8843 . #x8FDCA4)
	   (#x8844 . #xEAC8)
	   (#x8845 . #x8FDCA5)
	   (#x8846 . #xBDB0)
	   (#x8848 . #x8FDCA6)
	   (#x8849 . #x8FDCA7)
	   (#x884A . #x8FDCA8)
	   (#x884B . #x8FDCA9)
	   (#x884C . #xB9D4)
	   (#x884D . #xDEA7)
	   (#x884E . #x8FDCAA)
	   (#x8851 . #x8FDCAB)
	   (#x8852 . #xEACA)
	   (#x8853 . #xBDD1)
	   (#x8855 . #x8FDCAC)
	   (#x8856 . #x8FDCAD)
	   (#x8857 . #xB3B9)
	   (#x8858 . #x8FDCAE)
	   (#x8859 . #xEACB)
	   (#x885A . #x8FDCAF)
	   (#x885B . #xB1D2)
	   (#x885C . #x8FDCB0)
	   (#x885D . #xBED7)
	   (#x885E . #xEACC)
	   (#x885F . #x8FDCB1)
	   (#x8860 . #x8FDCB2)
	   (#x8861 . #xB9D5)
	   (#x8862 . #xEACD)
	   (#x8863 . #xB0E1)
	   (#x8864 . #x8FDCB3)
	   (#x8868 . #xC9BD)
	   (#x8869 . #x8FDCB4)
	   (#x886B . #xEACE)
	   (#x8870 . #xBFEA)
	   (#x8871 . #x8FDCB5)
	   (#x8872 . #xEAD5)
	   (#x8875 . #xEAD2)
	   (#x8877 . #xC3EF)
	   (#x8879 . #x8FDCB6)
	   (#x887B . #x8FDCB7)
	   (#x887D . #xEAD3)
	   (#x887E . #xEAD0)
	   (#x887F . #xB6DE)
	   (#x8880 . #x8FDCB8)
	   (#x8881 . #xEACF)
	   (#x8882 . #xEAD6)
	   (#x8888 . #xB7B6)
	   (#x888B . #xC2DE)
	   (#x888D . #xEADC)
	   (#x8892 . #xEAD8)
	   (#x8896 . #xC2B5)
	   (#x8897 . #xEAD7)
	   (#x8898 . #x8FDCB9)
	   (#x8899 . #xEADA)
	   (#x889A . #x8FDCBA)
	   (#x889B . #x8FDCBB)
	   (#x889C . #x8FDCBC)
	   (#x889E . #xEAD1)
	   (#x889F . #x8FDCBD)
	   (#x88A0 . #x8FDCBE)
	   (#x88A2 . #xEADB)
	   (#x88A4 . #xEADD)
	   (#x88A8 . #x8FDCBF)
	   (#x88AA . #x8FDCC0)
	   (#x88AB . #xC8EF)
	   (#x88AE . #xEAD9)
	   (#x88B0 . #xEADE)
	   (#x88B1 . #xEAE0)
	   (#x88B4 . #xB8D3)
	   (#x88B5 . #xEAD4)
	   (#x88B7 . #xB0C1)
	   (#x88BA . #x8FDCC1)
	   (#x88BD . #x8FDCC2)
	   (#x88BE . #x8FDCC3)
	   (#x88BF . #xEADF)
	   (#x88C0 . #x8FDCC4)
	   (#x88C1 . #xBADB)
	   (#x88C2 . #xCEF6)
	   (#x88C3 . #xEAE1)
	   (#x88C4 . #xEAE2)
	   (#x88C5 . #xC1F5)
	   (#x88CA . #x8FDCC5)
	   (#x88CB . #x8FDCC6)
	   (#x88CC . #x8FDCC7)
	   (#x88CD . #x8FDCC8)
	   (#x88CE . #x8FDCC9)
	   (#x88CF . #xCEA2)
	   (#x88D1 . #x8FDCCA)
	   (#x88D2 . #x8FDCCB)
	   (#x88D3 . #x8FDCCC)
	   (#x88D4 . #xEAE3)
	   (#x88D5 . #xCDB5)
	   (#x88D8 . #xEAE4)
	   (#x88D9 . #xEAE5)
	   (#x88DB . #x8FDCCD)
	   (#x88DC . #xCAE4)
	   (#x88DD . #xEAE6)
	   (#x88DE . #x8FDCCE)
	   (#x88DF . #xBAC0)
	   (#x88E1 . #xCEA3)
	   (#x88E7 . #x8FDCCF)
	   (#x88E8 . #xEAEB)
	   (#x88EF . #x8FDCD0)
	   (#x88F0 . #x8FDCD1)
	   (#x88F1 . #x8FDCD2)
	   (#x88F2 . #xEAEC)
	   (#x88F3 . #xBED8)
	   (#x88F4 . #xEAEA)
	   (#x88F5 . #x8FDCD3)
	   (#x88F7 . #x8FDCD4)
	   (#x88F8 . #xCDE7)
	   (#x88F9 . #xEAE7)
	   (#x88FC . #xEAE9)
	   (#x88FD . #xC0BD)
	   (#x88FE . #xBFFE)
	   (#x8901 . #x8FDCD5)
	   (#x8902 . #xEAE8)
	   (#x8904 . #xEAED)
	   (#x8906 . #x8FDCD6)
	   (#x8907 . #xCAA3)
	   (#x890A . #xEAEF)
	   (#x890C . #xEAEE)
	   (#x890D . #x8FDCD7)
	   (#x890E . #x8FDCD8)
	   (#x890F . #x8FDCD9)
	   (#x8910 . #xB3EC)
	   (#x8912 . #xCBAB)
	   (#x8913 . #xEAF0)
	   (#x8915 . #x8FDCDA)
	   (#x8916 . #x8FDCDB)
	   (#x8918 . #x8FDCDC)
	   (#x8919 . #x8FDCDD)
	   (#x891A . #x8FDCDE)
	   (#x891C . #x8FDCDF)
	   (#x891D . #xEAFC)
	   (#x891E . #xEAF2)
	   (#x8920 . #x8FDCE0)
	   (#x8925 . #xEAF3)
	   (#x8926 . #x8FDCE1)
	   (#x8927 . #x8FDCE2)
	   (#x8928 . #x8FDCE3)
	   (#x892A . #xEAF4)
	   (#x892B . #xEAF5)
	   (#x8930 . #x8FDCE4)
	   (#x8931 . #x8FDCE5)
	   (#x8932 . #x8FDCE6)
	   (#x8935 . #x8FDCE7)
	   (#x8936 . #xEAF9)
	   (#x8938 . #xEAFA)
	   (#x8939 . #x8FDCE8)
	   (#x893A . #x8FDCE9)
	   (#x893B . #xEAF8)
	   (#x893E . #x8FDCEA)
	   (#x8940 . #x8FDCEB)
	   (#x8941 . #xEAF6)
	   (#x8942 . #x8FDCEC)
	   (#x8943 . #xEAF1)
	   (#x8944 . #xEAF7)
	   (#x8945 . #x8FDCED)
	   (#x8946 . #x8FDCEE)
	   (#x8949 . #x8FDCEF)
	   (#x894C . #xEAFB)
	   (#x894D . #xF0B7)
	   (#x894F . #x8FDCF0)
	   (#x8952 . #x8FDCF1)
	   (#x8956 . #xB2A8)
	   (#x8957 . #x8FDCF2)
	   (#x895A . #x8FDCF3)
	   (#x895B . #x8FDCF4)
	   (#x895C . #x8FDCF5)
	   (#x895E . #xEAFE)
	   (#x895F . #xB6DF)
	   (#x8960 . #xEAFD)
	   (#x8961 . #x8FDCF6)
	   (#x8962 . #x8FDCF7)
	   (#x8963 . #x8FDCF8)
	   (#x8964 . #xEBA2)
	   (#x8966 . #xEBA1)
	   (#x896A . #xEBA4)
	   (#x896B . #x8FDCF9)
	   (#x896D . #xEBA3)
	   (#x896E . #x8FDCFA)
	   (#x896F . #xEBA5)
	   (#x8970 . #x8FDCFB)
	   (#x8972 . #xBDB1)
	   (#x8973 . #x8FDCFC)
	   (#x8974 . #xEBA6)
	   (#x8975 . #x8FDCFD)
	   (#x8977 . #xEBA7)
	   (#x897A . #x8FDCFE)
	   (#x897B . #x8FDDA1)
	   (#x897C . #x8FDDA2)
	   (#x897D . #x8FDDA3)
	   (#x897E . #xEBA8)
	   (#x897F . #xC0BE)
	   (#x8981 . #xCDD7)
	   (#x8983 . #xEBA9)
	   (#x8986 . #xCAA4)
	   (#x8987 . #xC7C6)
	   (#x8988 . #xEBAA)
	   (#x8989 . #x8FDDA4)
	   (#x898A . #xEBAB)
	   (#x898B . #xB8AB)
	   (#x898D . #x8FDDA5)
	   (#x898F . #xB5AC)
	   (#x8990 . #x8FDDA6)
	   (#x8993 . #xEBAC)
	   (#x8994 . #x8FDDA7)
	   (#x8995 . #x8FDDA8)
	   (#x8996 . #xBBEB)
	   (#x8997 . #xC7C1)
	   (#x8998 . #xEBAD)
	   (#x899A . #xB3D0)
	   (#x899B . #x8FDDA9)
	   (#x899C . #x8FDDAA)
	   (#x899F . #x8FDDAB)
	   (#x89A0 . #x8FDDAC)
	   (#x89A1 . #xEBAE)
	   (#x89A5 . #x8FDDAD)
	   (#x89A6 . #xEBB0)
	   (#x89A7 . #xCDF7)
	   (#x89A9 . #xEBAF)
	   (#x89AA . #xBFC6)
	   (#x89AC . #xEBB1)
	   (#x89AF . #xEBB2)
	   (#x89B0 . #x8FDDAE)
	   (#x89B2 . #xEBB3)
	   (#x89B3 . #xB4D1)
	   (#x89B4 . #x8FDDAF)
	   (#x89B5 . #x8FDDB0)
	   (#x89B6 . #x8FDDB1)
	   (#x89B7 . #x8FDDB2)
	   (#x89BA . #xEBB4)
	   (#x89BC . #x8FDDB3)
	   (#x89BD . #xEBB5)
	   (#x89BF . #xEBB6)
	   (#x89C0 . #xEBB7)
	   (#x89D2 . #xB3D1)
	   (#x89D4 . #x8FDDB4)
	   (#x89D5 . #x8FDDB5)
	   (#x89D6 . #x8FDDB6)
	   (#x89D7 . #x8FDDB7)
	   (#x89D8 . #x8FDDB8)
	   (#x89DA . #xEBB8)
	   (#x89DC . #xEBB9)
	   (#x89DD . #xEBBA)
	   (#x89E3 . #xB2F2)
	   (#x89E5 . #x8FDDB9)
	   (#x89E6 . #xBFA8)
	   (#x89E7 . #xEBBB)
	   (#x89E9 . #x8FDDBA)
	   (#x89EB . #x8FDDBB)
	   (#x89ED . #x8FDDBC)
	   (#x89F1 . #x8FDDBD)
	   (#x89F3 . #x8FDDBE)
	   (#x89F4 . #xEBBC)
	   (#x89F6 . #x8FDDBF)
	   (#x89F8 . #xEBBD)
	   (#x89F9 . #x8FDDC0)
	   (#x89FD . #x8FDDC1)
	   (#x89FF . #x8FDDC2)
	   (#x8A00 . #xB8C0)
	   (#x8A02 . #xC4FB)
	   (#x8A03 . #xEBBE)
	   (#x8A04 . #x8FDDC3)
	   (#x8A05 . #x8FDDC4)
	   (#x8A07 . #x8FDDC5)
	   (#x8A08 . #xB7D7)
	   (#x8A0A . #xBFD6)
	   (#x8A0C . #xEBC1)
	   (#x8A0E . #xC6A4)
	   (#x8A0F . #x8FDDC6)
	   (#x8A10 . #xEBC0)
	   (#x8A11 . #x8FDDC7)
	   (#x8A12 . #x8FDDC8)
	   (#x8A13 . #xB7B1)
	   (#x8A14 . #x8FDDC9)
	   (#x8A15 . #x8FDDCA)
	   (#x8A16 . #xEBBF)
	   (#x8A17 . #xC2F7)
	   (#x8A18 . #xB5AD)
	   (#x8A1B . #xEBC2)
	   (#x8A1D . #xEBC3)
	   (#x8A1E . #x8FDDCB)
	   (#x8A1F . #xBED9)
	   (#x8A20 . #x8FDDCC)
	   (#x8A22 . #x8FDDCD)
	   (#x8A23 . #xB7ED)
	   (#x8A24 . #x8FDDCE)
	   (#x8A25 . #xEBC4)
	   (#x8A26 . #x8FDDCF)
	   (#x8A2A . #xCBAC)
	   (#x8A2B . #x8FDDD0)
	   (#x8A2C . #x8FDDD1)
	   (#x8A2D . #xC0DF)
	   (#x8A2F . #x8FDDD2)
	   (#x8A31 . #xB5F6)
	   (#x8A33 . #xCCF5)
	   (#x8A34 . #xC1CA)
	   (#x8A35 . #x8FDDD3)
	   (#x8A36 . #xEBC5)
	   (#x8A37 . #x8FDDD4)
	   (#x8A3A . #xBFC7)
	   (#x8A3B . #xC3F0)
	   (#x8A3C . #xBEDA)
	   (#x8A3D . #x8FDDD5)
	   (#x8A3E . #x8FDDD6)
	   (#x8A40 . #x8FDDD7)
	   (#x8A41 . #xEBC6)
	   (#x8A43 . #x8FDDD8)
	   (#x8A45 . #x8FDDD9)
	   (#x8A46 . #xEBC9)
	   (#x8A47 . #x8FDDDA)
	   (#x8A48 . #xEBCA)
	   (#x8A49 . #x8FDDDB)
	   (#x8A4D . #x8FDDDC)
	   (#x8A4E . #x8FDDDD)
	   (#x8A50 . #xBABE)
	   (#x8A51 . #xC2C2)
	   (#x8A52 . #xEBC8)
	   (#x8A53 . #x8FDDDE)
	   (#x8A54 . #xBEDB)
	   (#x8A55 . #xC9BE)
	   (#x8A56 . #x8FDDDF)
	   (#x8A57 . #x8FDDE0)
	   (#x8A58 . #x8FDDE1)
	   (#x8A5B . #xEBC7)
	   (#x8A5C . #x8FDDE2)
	   (#x8A5D . #x8FDDE3)
	   (#x8A5E . #xBBEC)
	   (#x8A60 . #xB1D3)
	   (#x8A61 . #x8FDDE4)
	   (#x8A62 . #xEBCE)
	   (#x8A63 . #xB7D8)
	   (#x8A65 . #x8FDDE5)
	   (#x8A66 . #xBBEE)
	   (#x8A67 . #x8FDDE6)
	   (#x8A69 . #xBBED)
	   (#x8A6B . #xCFCD)
	   (#x8A6C . #xEBCD)
	   (#x8A6D . #xEBCC)
	   (#x8A6E . #xC1A7)
	   (#x8A70 . #xB5CD)
	   (#x8A71 . #xCFC3)
	   (#x8A72 . #xB3BA)
	   (#x8A73 . #xBEDC)
	   (#x8A75 . #x8FDDE7)
	   (#x8A76 . #x8FDDE8)
	   (#x8A77 . #x8FDDE9)
	   (#x8A79 . #x8FDDEA)
	   (#x8A7A . #x8FDDEB)
	   (#x8A7B . #x8FDDEC)
	   (#x8A7C . #xEBCB)
	   (#x8A7E . #x8FDDED)
	   (#x8A7F . #x8FDDEE)
	   (#x8A80 . #x8FDDEF)
	   (#x8A82 . #xEBD0)
	   (#x8A83 . #x8FDDF0)
	   (#x8A84 . #xEBD1)
	   (#x8A85 . #xEBCF)
	   (#x8A86 . #x8FDDF1)
	   (#x8A87 . #xB8D8)
	   (#x8A89 . #xCDC0)
	   (#x8A8B . #x8FDDF2)
	   (#x8A8C . #xBBEF)
	   (#x8A8D . #xC7A7)
	   (#x8A8F . #x8FDDF3)
	   (#x8A90 . #x8FDDF4)
	   (#x8A91 . #xEBD4)
	   (#x8A92 . #x8FDDF5)
	   (#x8A93 . #xC0C0)
	   (#x8A95 . #xC3C2)
	   (#x8A96 . #x8FDDF6)
	   (#x8A97 . #x8FDDF7)
	   (#x8A98 . #xCDB6)
	   (#x8A99 . #x8FDDF8)
	   (#x8A9A . #xEBD7)
	   (#x8A9E . #xB8EC)
	   (#x8A9F . #x8FDDF9)
	   (#x8AA0 . #xC0BF)
	   (#x8AA1 . #xEBD3)
	   (#x8AA3 . #xEBD8)
	   (#x8AA4 . #xB8ED)
	   (#x8AA5 . #xEBD5)
	   (#x8AA6 . #xEBD6)
	   (#x8AA7 . #x8FDDFA)
	   (#x8AA8 . #xEBD2)
	   (#x8AA9 . #x8FDDFB)
	   (#x8AAC . #xC0E2)
	   (#x8AAD . #xC6C9)
	   (#x8AAE . #x8FDDFC)
	   (#x8AAF . #x8FDDFD)
	   (#x8AB0 . #xC3AF)
	   (#x8AB2 . #xB2DD)
	   (#x8AB3 . #x8FDDFE)
	   (#x8AB6 . #x8FDEA1)
	   (#x8AB7 . #x8FDEA2)
	   (#x8AB9 . #xC8F0)
	   (#x8ABB . #x8FDEA3)
	   (#x8ABC . #xB5C3)
	   (#x8ABE . #x8FDEA4)
	   (#x8ABF . #xC4B4)
	   (#x8AC2 . #xEBDB)
	   (#x8AC3 . #x8FDEA5)
	   (#x8AC4 . #xEBD9)
	   (#x8AC6 . #x8FDEA6)
	   (#x8AC7 . #xC3CC)
	   (#x8AC8 . #x8FDEA7)
	   (#x8AC9 . #x8FDEA8)
	   (#x8ACA . #x8FDEA9)
	   (#x8ACB . #xC0C1)
	   (#x8ACC . #xB4D2)
	   (#x8ACD . #xEBDA)
	   (#x8ACF . #xBFDB)
	   (#x8AD1 . #x8FDEAA)
	   (#x8AD2 . #xCECA)
	   (#x8AD3 . #x8FDEAB)
	   (#x8AD4 . #x8FDEAC)
	   (#x8AD5 . #x8FDEAD)
	   (#x8AD6 . #xCFC0)
	   (#x8AD7 . #x8FDEAE)
	   (#x8ADA . #xEBDC)
	   (#x8ADB . #xEBE7)
	   (#x8ADC . #xC4B5)
	   (#x8ADD . #x8FDEAF)
	   (#x8ADE . #xEBE6)
	   (#x8ADF . #x8FDEB0)
	   (#x8AE0 . #xEBE3)
	   (#x8AE1 . #xEBEB)
	   (#x8AE2 . #xEBE4)
	   (#x8AE4 . #xEBE0)
	   (#x8AE6 . #xC4FC)
	   (#x8AE7 . #xEBDF)
	   (#x8AEB . #xEBDD)
	   (#x8AEC . #x8FDEB1)
	   (#x8AED . #xCDA1)
	   (#x8AEE . #xBBF0)
	   (#x8AF0 . #x8FDEB2)
	   (#x8AF1 . #xEBE1)
	   (#x8AF3 . #xEBDE)
	   (#x8AF4 . #x8FDEB3)
	   (#x8AF5 . #x8FDEB4)
	   (#x8AF6 . #x8FDEB5)
	   (#x8AF7 . #xEBE5)
	   (#x8AF8 . #xBDF4)
	   (#x8AFA . #xB8C1)
	   (#x8AFC . #x8FDEB6)
	   (#x8AFE . #xC2FA)
	   (#x8AFF . #x8FDEB7)
	   (#x8B00 . #xCBC5)
	   (#x8B01 . #xB1DA)
	   (#x8B02 . #xB0E2)
	   (#x8B04 . #xC6A5)
	   (#x8B05 . #x8FDEB8)
	   (#x8B06 . #x8FDEB9)
	   (#x8B07 . #xEBE9)
	   (#x8B0A . #x8FDEBF)
	   (#x8B0B . #x8FDEBA)
	   (#x8B0C . #xEBE8)
	   (#x8B0E . #xC6E6)
	   (#x8B10 . #xEBED)
	   (#x8B11 . #x8FDEBB)
	   (#x8B14 . #xEBE2)
	   (#x8B16 . #xEBEC)
	   (#x8B17 . #xEBEE)
	   (#x8B19 . #xB8AC)
	   (#x8B1A . #xEBEA)
	   (#x8B1B . #xB9D6)
	   (#x8B1C . #x8FDEBC)
	   (#x8B1D . #xBCD5)
	   (#x8B1E . #x8FDEBD)
	   (#x8B1F . #x8FDEBE)
	   (#x8B20 . #xEBEF)
	   (#x8B21 . #xCDD8)
	   (#x8B26 . #xEBF2)
	   (#x8B28 . #xEBF5)
	   (#x8B2B . #xEBF3)
	   (#x8B2C . #xC9B5)
	   (#x8B2D . #x8FDEC0)
	   (#x8B30 . #x8FDEC1)
	   (#x8B33 . #xEBF0)
	   (#x8B37 . #x8FDEC2)
	   (#x8B39 . #xB6E0)
	   (#x8B3C . #x8FDEC3)
	   (#x8B3E . #xEBF4)
	   (#x8B41 . #xEBF6)
	   (#x8B42 . #x8FDEC4)
	   (#x8B43 . #x8FDEC5)
	   (#x8B44 . #x8FDEC6)
	   (#x8B45 . #x8FDEC7)
	   (#x8B46 . #x8FDEC8)
	   (#x8B48 . #x8FDEC9)
	   (#x8B49 . #xEBFA)
	   (#x8B4C . #xEBF7)
	   (#x8B4D . #x8FDECE)
	   (#x8B4E . #xEBF9)
	   (#x8B4F . #xEBF8)
	   (#x8B52 . #x8FDECA)
	   (#x8B53 . #x8FDECB)
	   (#x8B54 . #x8FDECC)
	   (#x8B56 . #xEBFB)
	   (#x8B58 . #xBCB1)
	   (#x8B59 . #x8FDECD)
	   (#x8B5A . #xEBFD)
	   (#x8B5B . #xEBFC)
	   (#x8B5C . #xC9E8)
	   (#x8B5E . #x8FDECF)
	   (#x8B5F . #xECA1)
	   (#x8B63 . #x8FDED0)
	   (#x8B66 . #xB7D9)
	   (#x8B6B . #xEBFE)
	   (#x8B6C . #xECA2)
	   (#x8B6D . #x8FDED1)
	   (#x8B6F . #xECA3)
	   (#x8B70 . #xB5C4)
	   (#x8B71 . #xE6C1)
	   (#x8B72 . #xBEF9)
	   (#x8B74 . #xECA4)
	   (#x8B76 . #x8FDED2)
	   (#x8B77 . #xB8EE)
	   (#x8B78 . #x8FDED3)
	   (#x8B79 . #x8FDED4)
	   (#x8B7C . #x8FDED5)
	   (#x8B7D . #xECA5)
	   (#x8B7E . #x8FDED6)
	   (#x8B80 . #xECA6)
	   (#x8B81 . #x8FDED7)
	   (#x8B83 . #xBBBE)
	   (#x8B84 . #x8FDED8)
	   (#x8B85 . #x8FDED9)
	   (#x8B8A . #xDACE)
	   (#x8B8B . #x8FDEDA)
	   (#x8B8C . #xECA7)
	   (#x8B8D . #x8FDEDB)
	   (#x8B8E . #xECA8)
	   (#x8B8F . #x8FDEDC)
	   (#x8B90 . #xBDB2)
	   (#x8B92 . #xECA9)
	   (#x8B93 . #xECAA)
	   (#x8B94 . #x8FDEDD)
	   (#x8B95 . #x8FDEDE)
	   (#x8B96 . #xECAB)
	   (#x8B99 . #xECAC)
	   (#x8B9A . #xECAD)
	   (#x8B9C . #x8FDEDF)
	   (#x8B9E . #x8FDEE0)
	   (#x8B9F . #x8FDEE1)
	   (#x8C37 . #xC3AB)
	   (#x8C38 . #x8FDEE2)
	   (#x8C39 . #x8FDEE3)
	   (#x8C3A . #xECAE)
	   (#x8C3D . #x8FDEE4)
	   (#x8C3E . #x8FDEE5)
	   (#x8C3F . #xECB0)
	   (#x8C41 . #xECAF)
	   (#x8C45 . #x8FDEE6)
	   (#x8C46 . #xC6A6)
	   (#x8C47 . #x8FDEE7)
	   (#x8C48 . #xECB1)
	   (#x8C49 . #x8FDEE8)
	   (#x8C4A . #xCBAD)
	   (#x8C4B . #x8FDEE9)
	   (#x8C4C . #xECB2)
	   (#x8C4E . #xECB3)
	   (#x8C4F . #x8FDEEA)
	   (#x8C50 . #xECB4)
	   (#x8C51 . #x8FDEEB)
	   (#x8C53 . #x8FDEEC)
	   (#x8C54 . #x8FDEED)
	   (#x8C55 . #xECB5)
	   (#x8C57 . #x8FDEEE)
	   (#x8C58 . #x8FDEEF)
	   (#x8C59 . #x8FDEF2)
	   (#x8C5A . #xC6DA)
	   (#x8C5B . #x8FDEF0)
	   (#x8C5D . #x8FDEF1)
	   (#x8C61 . #xBEDD)
	   (#x8C62 . #xECB6)
	   (#x8C63 . #x8FDEF3)
	   (#x8C64 . #x8FDEF4)
	   (#x8C66 . #x8FDEF5)
	   (#x8C68 . #x8FDEF6)
	   (#x8C69 . #x8FDEF7)
	   (#x8C6A . #xB9EB)
	   (#x8C6B . #xD0AE)
	   (#x8C6C . #xECB7)
	   (#x8C6D . #x8FDEF8)
	   (#x8C73 . #x8FDEF9)
	   (#x8C75 . #x8FDEFA)
	   (#x8C76 . #x8FDEFB)
	   (#x8C78 . #xECB8)
	   (#x8C79 . #xC9BF)
	   (#x8C7A . #xECB9)
	   (#x8C7B . #x8FDEFC)
	   (#x8C7C . #xECC1)
	   (#x8C7E . #x8FDEFD)
	   (#x8C82 . #xECBA)
	   (#x8C85 . #xECBC)
	   (#x8C86 . #x8FDEFE)
	   (#x8C87 . #x8FDFA1)
	   (#x8C89 . #xECBB)
	   (#x8C8A . #xECBD)
	   (#x8C8B . #x8FDFA2)
	   (#x8C8C . #xCBC6)
	   (#x8C8D . #xECBE)
	   (#x8C8E . #xECBF)
	   (#x8C90 . #x8FDFA3)
	   (#x8C92 . #x8FDFA4)
	   (#x8C93 . #x8FDFA5)
	   (#x8C94 . #xECC0)
	   (#x8C98 . #xECC2)
	   (#x8C99 . #x8FDFA6)
	   (#x8C9B . #x8FDFA7)
	   (#x8C9C . #x8FDFA8)
	   (#x8C9D . #xB3AD)
	   (#x8C9E . #xC4E7)
	   (#x8CA0 . #xC9E9)
	   (#x8CA1 . #xBAE2)
	   (#x8CA2 . #xB9D7)
	   (#x8CA4 . #x8FDFA9)
	   (#x8CA7 . #xC9CF)
	   (#x8CA8 . #xB2DF)
	   (#x8CA9 . #xC8CE)
	   (#x8CAA . #xECC5)
	   (#x8CAB . #xB4D3)
	   (#x8CAC . #xC0D5)
	   (#x8CAD . #xECC4)
	   (#x8CAE . #xECC9)
	   (#x8CAF . #xC3F9)
	   (#x8CB0 . #xCCE3)
	   (#x8CB2 . #xECC7)
	   (#x8CB3 . #xECC8)
	   (#x8CB4 . #xB5AE)
	   (#x8CB6 . #xECCA)
	   (#x8CB7 . #xC7E3)
	   (#x8CB8 . #xC2DF)
	   (#x8CB9 . #x8FDFAA)
	   (#x8CBA . #x8FDFAB)
	   (#x8CBB . #xC8F1)
	   (#x8CBC . #xC5BD)
	   (#x8CBD . #xECC6)
	   (#x8CBF . #xCBC7)
	   (#x8CC0 . #xB2EC)
	   (#x8CC1 . #xECCC)
	   (#x8CC2 . #xCFA8)
	   (#x8CC3 . #xC4C2)
	   (#x8CC4 . #xCFC5)
	   (#x8CC5 . #x8FDFAC)
	   (#x8CC6 . #x8FDFAD)
	   (#x8CC7 . #xBBF1)
	   (#x8CC8 . #xECCB)
	   (#x8CC9 . #x8FDFAE)
	   (#x8CCA . #xC2B1)
	   (#x8CCB . #x8FDFAF)
	   (#x8CCD . #xECDC)
	   (#x8CCE . #xC1A8)
	   (#x8CCF . #x8FDFB0)
	   (#x8CD1 . #xC6F8)
	   (#x8CD3 . #xC9D0)
	   (#x8CD5 . #x8FDFB2)
	   (#x8CD6 . #x8FDFB1)
	   (#x8CD9 . #x8FDFB3)
	   (#x8CDA . #xECCF)
	   (#x8CDB . #xBBBF)
	   (#x8CDC . #xBBF2)
	   (#x8CDD . #x8FDFB4)
	   (#x8CDE . #xBEDE)
	   (#x8CE0 . #xC7E5)
	   (#x8CE1 . #x8FDFB5)
	   (#x8CE2 . #xB8AD)
	   (#x8CE3 . #xECCE)
	   (#x8CE4 . #xECCD)
	   (#x8CE6 . #xC9EA)
	   (#x8CE8 . #x8FDFB6)
	   (#x8CEA . #xBCC1)
	   (#x8CEC . #x8FDFB7)
	   (#x8CED . #xC5D2)
	   (#x8CEF . #x8FDFB8)
	   (#x8CF0 . #x8FDFB9)
	   (#x8CF2 . #x8FDFBA)
	   (#x8CF5 . #x8FDFBB)
	   (#x8CF7 . #x8FDFBC)
	   (#x8CF8 . #x8FDFBD)
	   (#x8CFA . #xECD1)
	   (#x8CFB . #xECD2)
	   (#x8CFC . #xB9D8)
	   (#x8CFD . #xECD0)
	   (#x8CFE . #x8FDFBE)
	   (#x8CFF . #x8FDFBF)
	   (#x8D01 . #x8FDFC0)
	   (#x8D03 . #x8FDFC1)
	   (#x8D04 . #xECD3)
	   (#x8D05 . #xECD4)
	   (#x8D07 . #xECD6)
	   (#x8D08 . #xC2A3)
	   (#x8D09 . #x8FDFC2)
	   (#x8D0A . #xECD5)
	   (#x8D0B . #xB4E6)
	   (#x8D0D . #xECD8)
	   (#x8D0F . #xECD7)
	   (#x8D10 . #xECD9)
	   (#x8D12 . #x8FDFC3)
	   (#x8D13 . #xECDB)
	   (#x8D14 . #xECDD)
	   (#x8D16 . #xECDE)
	   (#x8D17 . #x8FDFC4)
	   (#x8D1B . #x8FDFC5)
	   (#x8D64 . #xC0D6)
	   (#x8D65 . #x8FDFC6)
	   (#x8D66 . #xBCCF)
	   (#x8D67 . #xECDF)
	   (#x8D69 . #x8FDFC7)
	   (#x8D6B . #xB3D2)
	   (#x8D6C . #x8FDFC8)
	   (#x8D6D . #xECE0)
	   (#x8D6E . #x8FDFC9)
	   (#x8D70 . #xC1F6)
	   (#x8D71 . #xECE1)
	   (#x8D73 . #xECE2)
	   (#x8D74 . #xC9EB)
	   (#x8D77 . #xB5AF)
	   (#x8D7F . #x8FDFCA)
	   (#x8D81 . #xECE3)
	   (#x8D82 . #x8FDFCB)
	   (#x8D84 . #x8FDFCC)
	   (#x8D85 . #xC4B6)
	   (#x8D88 . #x8FDFCD)
	   (#x8D8A . #xB1DB)
	   (#x8D8D . #x8FDFCE)
	   (#x8D90 . #x8FDFCF)
	   (#x8D91 . #x8FDFD0)
	   (#x8D95 . #x8FDFD1)
	   (#x8D99 . #xECE4)
	   (#x8D9E . #x8FDFD2)
	   (#x8D9F . #x8FDFD3)
	   (#x8DA0 . #x8FDFD4)
	   (#x8DA3 . #xBCF1)
	   (#x8DA6 . #x8FDFD5)
	   (#x8DA8 . #xBFF6)
	   (#x8DAB . #x8FDFD6)
	   (#x8DAC . #x8FDFD7)
	   (#x8DAF . #x8FDFD8)
	   (#x8DB2 . #x8FDFD9)
	   (#x8DB3 . #xC2AD)
	   (#x8DB5 . #x8FDFDA)
	   (#x8DB7 . #x8FDFDB)
	   (#x8DB9 . #x8FDFDC)
	   (#x8DBA . #xECE7)
	   (#x8DBB . #x8FDFDD)
	   (#x8DBC . #x8FDFEF)
	   (#x8DBE . #xECE6)
	   (#x8DC0 . #x8FDFDE)
	   (#x8DC2 . #xECE5)
	   (#x8DC5 . #x8FDFDF)
	   (#x8DC6 . #x8FDFE0)
	   (#x8DC7 . #x8FDFE1)
	   (#x8DC8 . #x8FDFE2)
	   (#x8DCA . #x8FDFE3)
	   (#x8DCB . #xECED)
	   (#x8DCC . #xECEB)
	   (#x8DCE . #x8FDFE4)
	   (#x8DCF . #xECE8)
	   (#x8DD1 . #x8FDFE5)
	   (#x8DD4 . #x8FDFE6)
	   (#x8DD5 . #x8FDFE7)
	   (#x8DD6 . #xECEA)
	   (#x8DD7 . #x8FDFE8)
	   (#x8DD9 . #x8FDFE9)
	   (#x8DDA . #xECE9)
	   (#x8DDB . #xECEC)
	   (#x8DDD . #xB5F7)
	   (#x8DDF . #xECF0)
	   (#x8DE1 . #xC0D7)
	   (#x8DE3 . #xECF1)
	   (#x8DE4 . #x8FDFEA)
	   (#x8DE5 . #x8FDFEB)
	   (#x8DE7 . #x8FDFEC)
	   (#x8DE8 . #xB8D9)
	   (#x8DEA . #xECEE)
	   (#x8DEB . #xECEF)
	   (#x8DEC . #x8FDFED)
	   (#x8DEF . #xCFA9)
	   (#x8DF0 . #x8FDFEE)
	   (#x8DF1 . #x8FDFF0)
	   (#x8DF2 . #x8FDFF1)
	   (#x8DF3 . #xC4B7)
	   (#x8DF4 . #x8FDFF2)
	   (#x8DF5 . #xC1A9)
	   (#x8DFC . #xECF2)
	   (#x8DFD . #x8FDFF3)
	   (#x8DFF . #xECF5)
	   (#x8E01 . #x8FDFF4)
	   (#x8E04 . #x8FDFF5)
	   (#x8E05 . #x8FDFF6)
	   (#x8E06 . #x8FDFF7)
	   (#x8E08 . #xECF3)
	   (#x8E09 . #xECF4)
	   (#x8E0A . #xCDD9)
	   (#x8E0B . #x8FDFF8)
	   (#x8E0F . #xC6A7)
	   (#x8E10 . #xECF8)
	   (#x8E11 . #x8FDFF9)
	   (#x8E14 . #x8FDFFA)
	   (#x8E16 . #x8FDFFB)
	   (#x8E1D . #xECF6)
	   (#x8E1E . #xECF7)
	   (#x8E1F . #xECF9)
	   (#x8E20 . #x8FDFFC)
	   (#x8E21 . #x8FDFFD)
	   (#x8E22 . #x8FDFFE)
	   (#x8E23 . #x8FE0A1)
	   (#x8E26 . #x8FE0A2)
	   (#x8E27 . #x8FE0A3)
	   (#x8E2A . #xEDA9)
	   (#x8E30 . #xECFC)
	   (#x8E31 . #x8FE0A4)
	   (#x8E33 . #x8FE0A5)
	   (#x8E34 . #xECFD)
	   (#x8E35 . #xECFB)
	   (#x8E36 . #x8FE0A6)
	   (#x8E37 . #x8FE0A7)
	   (#x8E38 . #x8FE0A8)
	   (#x8E39 . #x8FE0A9)
	   (#x8E3D . #x8FE0AA)
	   (#x8E40 . #x8FE0AB)
	   (#x8E41 . #x8FE0AC)
	   (#x8E42 . #xECFA)
	   (#x8E44 . #xC4FD)
	   (#x8E47 . #xEDA1)
	   (#x8E48 . #xEDA5)
	   (#x8E49 . #xEDA2)
	   (#x8E4A . #xECFE)
	   (#x8E4B . #x8FE0AD)
	   (#x8E4C . #xEDA3)
	   (#x8E4D . #x8FE0AE)
	   (#x8E4E . #x8FE0AF)
	   (#x8E4F . #x8FE0B0)
	   (#x8E50 . #xEDA4)
	   (#x8E54 . #x8FE0B1)
	   (#x8E55 . #xEDAB)
	   (#x8E59 . #xEDA6)
	   (#x8E5B . #x8FE0B2)
	   (#x8E5C . #x8FE0B3)
	   (#x8E5D . #x8FE0B4)
	   (#x8E5E . #x8FE0B5)
	   (#x8E5F . #xC0D8)
	   (#x8E60 . #xEDA8)
	   (#x8E61 . #x8FE0B6)
	   (#x8E62 . #x8FE0B7)
	   (#x8E63 . #xEDAA)
	   (#x8E64 . #xEDA7)
	   (#x8E69 . #x8FE0B8)
	   (#x8E6C . #x8FE0B9)
	   (#x8E6D . #x8FE0BA)
	   (#x8E6F . #x8FE0BB)
	   (#x8E70 . #x8FE0BC)
	   (#x8E71 . #x8FE0BD)
	   (#x8E72 . #xEDAD)
	   (#x8E74 . #xBDB3)
	   (#x8E76 . #xEDAC)
	   (#x8E79 . #x8FE0BE)
	   (#x8E7A . #x8FE0BF)
	   (#x8E7B . #x8FE0C0)
	   (#x8E7C . #xEDAE)
	   (#x8E81 . #xEDAF)
	   (#x8E82 . #x8FE0C1)
	   (#x8E83 . #x8FE0C2)
	   (#x8E84 . #xEDB2)
	   (#x8E85 . #xEDB1)
	   (#x8E87 . #xEDB0)
	   (#x8E89 . #x8FE0C3)
	   (#x8E8A . #xEDB4)
	   (#x8E8B . #xEDB3)
	   (#x8E8D . #xCCF6)
	   (#x8E90 . #x8FE0C4)
	   (#x8E91 . #xEDB6)
	   (#x8E92 . #x8FE0C5)
	   (#x8E93 . #xEDB5)
	   (#x8E94 . #xEDB7)
	   (#x8E95 . #x8FE0C6)
	   (#x8E99 . #xEDB8)
	   (#x8E9A . #x8FE0C7)
	   (#x8E9B . #x8FE0C8)
	   (#x8E9D . #x8FE0C9)
	   (#x8E9E . #x8FE0CA)
	   (#x8EA1 . #xEDBA)
	   (#x8EA2 . #x8FE0CB)
	   (#x8EA7 . #x8FE0CC)
	   (#x8EA9 . #x8FE0CD)
	   (#x8EAA . #xEDB9)
	   (#x8EAB . #xBFC8)
	   (#x8EAC . #xEDBB)
	   (#x8EAD . #x8FE0CE)
	   (#x8EAE . #x8FE0CF)
	   (#x8EAF . #xB6ED)
	   (#x8EB0 . #xEDBC)
	   (#x8EB1 . #xEDBE)
	   (#x8EB3 . #x8FE0D0)
	   (#x8EB5 . #x8FE0D1)
	   (#x8EBA . #x8FE0D2)
	   (#x8EBB . #x8FE0D3)
	   (#x8EBE . #xEDBF)
	   (#x8EC0 . #x8FE0D4)
	   (#x8EC1 . #x8FE0D5)
	   (#x8EC3 . #x8FE0D6)
	   (#x8EC4 . #x8FE0D7)
	   (#x8EC5 . #xEDC0)
	   (#x8EC6 . #xEDBD)
	   (#x8EC7 . #x8FE0D8)
	   (#x8EC8 . #xEDC1)
	   (#x8ECA . #xBCD6)
	   (#x8ECB . #xEDC2)
	   (#x8ECC . #xB5B0)
	   (#x8ECD . #xB7B3)
	   (#x8ECF . #x8FE0D9)
	   (#x8ED1 . #x8FE0DA)
	   (#x8ED2 . #xB8AE)
	   (#x8ED4 . #x8FE0DB)
	   (#x8EDB . #xEDC3)
	   (#x8EDC . #x8FE0DC)
	   (#x8EDF . #xC6F0)
	   (#x8EE2 . #xC5BE)
	   (#x8EE3 . #xEDC4)
	   (#x8EE8 . #x8FE0DD)
	   (#x8EEB . #xEDC7)
	   (#x8EED . #x8FE0E4)
	   (#x8EEE . #x8FE0DE)
	   (#x8EF0 . #x8FE0DF)
	   (#x8EF1 . #x8FE0E0)
	   (#x8EF7 . #x8FE0E1)
	   (#x8EF8 . #xBCB4)
	   (#x8EF9 . #x8FE0E2)
	   (#x8EFA . #x8FE0E3)
	   (#x8EFB . #xEDC6)
	   (#x8EFC . #xEDC5)
	   (#x8EFD . #xB7DA)
	   (#x8EFE . #xEDC8)
	   (#x8F00 . #x8FE0E5)
	   (#x8F02 . #x8FE0E6)
	   (#x8F03 . #xB3D3)
	   (#x8F05 . #xEDCA)
	   (#x8F07 . #x8FE0E7)
	   (#x8F08 . #x8FE0E8)
	   (#x8F09 . #xBADC)
	   (#x8F0A . #xEDC9)
	   (#x8F0C . #xEDD2)
	   (#x8F0F . #x8FE0E9)
	   (#x8F10 . #x8FE0EA)
	   (#x8F12 . #xEDCC)
	   (#x8F13 . #xEDCE)
	   (#x8F14 . #xCAE5)
	   (#x8F15 . #xEDCB)
	   (#x8F16 . #x8FE0EB)
	   (#x8F17 . #x8FE0EC)
	   (#x8F18 . #x8FE0ED)
	   (#x8F19 . #xEDCD)
	   (#x8F1B . #xEDD1)
	   (#x8F1C . #xEDCF)
	   (#x8F1D . #xB5B1)
	   (#x8F1E . #x8FE0EE)
	   (#x8F1F . #xEDD0)
	   (#x8F20 . #x8FE0EF)
	   (#x8F21 . #x8FE0F0)
	   (#x8F23 . #x8FE0F1)
	   (#x8F25 . #x8FE0F2)
	   (#x8F26 . #xEDD3)
	   (#x8F27 . #x8FE0F3)
	   (#x8F28 . #x8FE0F4)
	   (#x8F29 . #xC7DA)
	   (#x8F2A . #xCED8)
	   (#x8F2C . #x8FE0F5)
	   (#x8F2D . #x8FE0F6)
	   (#x8F2E . #x8FE0F7)
	   (#x8F2F . #xBDB4)
	   (#x8F33 . #xEDD4)
	   (#x8F34 . #x8FE0F8)
	   (#x8F35 . #x8FE0F9)
	   (#x8F36 . #x8FE0FA)
	   (#x8F37 . #x8FE0FB)
	   (#x8F38 . #xCDA2)
	   (#x8F39 . #xEDD6)
	   (#x8F3A . #x8FE0FC)
	   (#x8F3B . #xEDD5)
	   (#x8F3E . #xEDD9)
	   (#x8F3F . #xCDC1)
	   (#x8F40 . #x8FE0FD)
	   (#x8F41 . #x8FE0FE)
	   (#x8F42 . #xEDD8)
	   (#x8F43 . #x8FE1A1)
	   (#x8F44 . #xB3ED)
	   (#x8F45 . #xEDD7)
	   (#x8F46 . #xEDDC)
	   (#x8F47 . #x8FE1A2)
	   (#x8F49 . #xEDDB)
	   (#x8F4C . #xEDDA)
	   (#x8F4D . #xC5B2)
	   (#x8F4E . #xEDDD)
	   (#x8F4F . #x8FE1A3)
	   (#x8F51 . #x8FE1A4)
	   (#x8F52 . #x8FE1A5)
	   (#x8F53 . #x8FE1A6)
	   (#x8F54 . #x8FE1A7)
	   (#x8F55 . #x8FE1A8)
	   (#x8F57 . #xEDDE)
	   (#x8F58 . #x8FE1A9)
	   (#x8F5C . #xEDDF)
	   (#x8F5D . #x8FE1AA)
	   (#x8F5E . #x8FE1AB)
	   (#x8F5F . #xB9EC)
	   (#x8F61 . #xB7A5)
	   (#x8F62 . #xEDE0)
	   (#x8F63 . #xEDE1)
	   (#x8F64 . #xEDE2)
	   (#x8F65 . #x8FE1AC)
	   (#x8F9B . #xBFC9)
	   (#x8F9C . #xEDE3)
	   (#x8F9D . #x8FE1AD)
	   (#x8F9E . #xBCAD)
	   (#x8F9F . #xEDE4)
	   (#x8FA0 . #x8FE1AE)
	   (#x8FA1 . #x8FE1AF)
	   (#x8FA3 . #xEDE5)
	   (#x8FA4 . #x8FE1B0)
	   (#x8FA5 . #x8FE1B1)
	   (#x8FA6 . #x8FE1B2)
	   (#x8FA7 . #xD2A1)
	   (#x8FA8 . #xD1FE)
	   (#x8FAD . #xEDE6)
	   (#x8FAE . #xE5F0)
	   (#x8FAF . #xEDE7)
	   (#x8FB0 . #xC3A4)
	   (#x8FB1 . #xBFAB)
	   (#x8FB2 . #xC7C0)
	   (#x8FB5 . #x8FE1B3)
	   (#x8FB6 . #x8FE1B4)
	   (#x8FB7 . #xEDE8)
	   (#x8FB8 . #x8FE1B5)
	   (#x8FBA . #xCAD5)
	   (#x8FBB . #xC4D4)
	   (#x8FBC . #xB9FE)
	   (#x8FBE . #x8FE1B6)
	   (#x8FBF . #xC3A9)
	   (#x8FC0 . #x8FE1B7)
	   (#x8FC1 . #x8FE1B8)
	   (#x8FC2 . #xB1AA)
	   (#x8FC4 . #xCBF8)
	   (#x8FC5 . #xBFD7)
	   (#x8FC6 . #x8FE1B9)
	   (#x8FCA . #x8FE1BA)
	   (#x8FCB . #x8FE1BB)
	   (#x8FCD . #x8FE1BC)
	   (#x8FCE . #xB7DE)
	   (#x8FD0 . #x8FE1BD)
	   (#x8FD1 . #xB6E1)
	   (#x8FD2 . #x8FE1BE)
	   (#x8FD3 . #x8FE1BF)
	   (#x8FD4 . #xCAD6)
	   (#x8FD5 . #x8FE1C0)
	   (#x8FDA . #xEDE9)
	   (#x8FE0 . #x8FE1C1)
	   (#x8FE2 . #xEDEB)
	   (#x8FE3 . #x8FE1C2)
	   (#x8FE4 . #x8FE1C3)
	   (#x8FE5 . #xEDEA)
	   (#x8FE6 . #xB2E0)
	   (#x8FE8 . #x8FE1C4)
	   (#x8FE9 . #xC6F6)
	   (#x8FEA . #xEDEC)
	   (#x8FEB . #xC7F7)
	   (#x8FED . #xC5B3)
	   (#x8FEE . #x8FE1C5)
	   (#x8FEF . #xEDED)
	   (#x8FF0 . #xBDD2)
	   (#x8FF1 . #x8FE1C6)
	   (#x8FF4 . #xEDEF)
	   (#x8FF5 . #x8FE1C7)
	   (#x8FF6 . #x8FE1C8)
	   (#x8FF7 . #xCCC2)
	   (#x8FF8 . #xEDFE)
	   (#x8FF9 . #xEDF1)
	   (#x8FFA . #xEDF2)
	   (#x8FFB . #x8FE1C9)
	   (#x8FFD . #xC4C9)
	   (#x8FFE . #x8FE1CA)
	   (#x9000 . #xC2E0)
	   (#x9001 . #xC1F7)
	   (#x9002 . #x8FE1CB)
	   (#x9003 . #xC6A8)
	   (#x9004 . #x8FE1CC)
	   (#x9005 . #xEDF0)
	   (#x9006 . #xB5D5)
	   (#x9008 . #x8FE1CD)
	   (#x900B . #xEDF9)
	   (#x900C . #x8FE1CE)
	   (#x900D . #xEDF6)
	   (#x900E . #xEEA5)
	   (#x900F . #xC6A9)
	   (#x9010 . #xC3E0)
	   (#x9011 . #xEDF3)
	   (#x9013 . #xC4FE)
	   (#x9014 . #xC5D3)
	   (#x9015 . #xEDF4)
	   (#x9016 . #xEDF8)
	   (#x9017 . #xBFE0)
	   (#x9018 . #x8FE1CF)
	   (#x9019 . #xC7E7)
	   (#x901A . #xC4CC)
	   (#x901B . #x8FE1D0)
	   (#x901D . #xC0C2)
	   (#x901E . #xEDF7)
	   (#x901F . #xC2AE)
	   (#x9020 . #xC2A4)
	   (#x9021 . #xEDF5)
	   (#x9022 . #xB0A9)
	   (#x9023 . #xCFA2)
	   (#x9027 . #xEDFA)
	   (#x9028 . #x8FE1D1)
	   (#x9029 . #x8FE1D2)
	   (#x902A . #x8FE1D4)
	   (#x902C . #x8FE1D5)
	   (#x902D . #x8FE1D6)
	   (#x902E . #xC2E1)
	   (#x902F . #x8FE1D3)
	   (#x9031 . #xBDB5)
	   (#x9032 . #xBFCA)
	   (#x9033 . #x8FE1D7)
	   (#x9034 . #x8FE1D8)
	   (#x9035 . #xEDFC)
	   (#x9036 . #xEDFB)
	   (#x9037 . #x8FE1D9)
	   (#x9038 . #xB0EF)
	   (#x9039 . #xEDFD)
	   (#x903C . #xC9AF)
	   (#x903E . #xEEA7)
	   (#x903F . #x8FE1DA)
	   (#x9041 . #xC6DB)
	   (#x9042 . #xBFEB)
	   (#x9043 . #x8FE1DB)
	   (#x9044 . #x8FE1DC)
	   (#x9045 . #xC3D9)
	   (#x9047 . #xB6F8)
	   (#x9049 . #xEEA6)
	   (#x904A . #xCDB7)
	   (#x904B . #xB1BF)
	   (#x904C . #x8FE1DD)
	   (#x904D . #xCAD7)
	   (#x904E . #xB2E1)
	   (#x904F . #xEEA1)
	   (#x9050 . #xEEA2)
	   (#x9051 . #xEEA3)
	   (#x9052 . #xEEA4)
	   (#x9053 . #xC6BB)
	   (#x9054 . #xC3A3)
	   (#x9055 . #xB0E3)
	   (#x9056 . #xEEA8)
	   (#x9058 . #xEEA9)
	   (#x9059 . #xF4A3)
	   (#x905B . #x8FE1DE)
	   (#x905C . #xC2BD)
	   (#x905D . #x8FE1DF)
	   (#x905E . #xEEAA)
	   (#x9060 . #xB1F3)
	   (#x9061 . #xC1CC)
	   (#x9062 . #x8FE1E0)
	   (#x9063 . #xB8AF)
	   (#x9065 . #xCDDA)
	   (#x9066 . #x8FE1E1)
	   (#x9067 . #x8FE1E2)
	   (#x9068 . #xEEAB)
	   (#x9069 . #xC5AC)
	   (#x906C . #x8FE1E3)
	   (#x906D . #xC1F8)
	   (#x906E . #xBCD7)
	   (#x906F . #xEEAC)
	   (#x9070 . #x8FE1E4)
	   (#x9072 . #xEEAF)
	   (#x9074 . #x8FE1E5)
	   (#x9075 . #xBDE5)
	   (#x9076 . #xEEAD)
	   (#x9077 . #xC1AB)
	   (#x9078 . #xC1AA)
	   (#x9079 . #x8FE1E6)
	   (#x907A . #xB0E4)
	   (#x907C . #xCECB)
	   (#x907D . #xEEB1)
	   (#x907F . #xC8F2)
	   (#x9080 . #xEEB3)
	   (#x9081 . #xEEB2)
	   (#x9082 . #xEEB0)
	   (#x9083 . #xE3E4)
	   (#x9084 . #xB4D4)
	   (#x9085 . #x8FE1E7)
	   (#x9087 . #xEDEE)
	   (#x9088 . #x8FE1E8)
	   (#x9089 . #xEEB5)
	   (#x908A . #xEEB4)
	   (#x908B . #x8FE1E9)
	   (#x908C . #x8FE1EA)
	   (#x908E . #x8FE1EB)
	   (#x908F . #xEEB6)
	   (#x9090 . #x8FE1EC)
	   (#x9091 . #xCDB8)
	   (#x9095 . #x8FE1ED)
	   (#x9097 . #x8FE1EE)
	   (#x9098 . #x8FE1EF)
	   (#x9099 . #x8FE1F0)
	   (#x909B . #x8FE1F1)
	   (#x90A0 . #x8FE1F2)
	   (#x90A1 . #x8FE1F3)
	   (#x90A2 . #x8FE1F4)
	   (#x90A3 . #xC6E1)
	   (#x90A5 . #x8FE1F5)
	   (#x90A6 . #xCBAE)
	   (#x90A8 . #xEEB7)
	   (#x90AA . #xBCD9)
	   (#x90AF . #xEEB8)
	   (#x90B0 . #x8FE1F6)
	   (#x90B1 . #xEEB9)
	   (#x90B2 . #x8FE1F7)
	   (#x90B3 . #x8FE1F8)
	   (#x90B4 . #x8FE1F9)
	   (#x90B5 . #xEEBA)
	   (#x90B6 . #x8FE1FA)
	   (#x90B8 . #xC5A1)
	   (#x90BD . #x8FE1FB)
	   (#x90BE . #x8FE1FD)
	   (#x90C1 . #xB0EA)
	   (#x90C3 . #x8FE1FE)
	   (#x90C4 . #x8FE2A1)
	   (#x90C5 . #x8FE2A2)
	   (#x90C7 . #x8FE2A3)
	   (#x90C8 . #x8FE2A4)
	   (#x90CA . #xB9D9)
	   (#x90CC . #x8FE1FC)
	   (#x90CE . #xCFBA)
	   (#x90D2 . #x8FE2AD)
	   (#x90D5 . #x8FE2A5)
	   (#x90D7 . #x8FE2A6)
	   (#x90D8 . #x8FE2A7)
	   (#x90D9 . #x8FE2A8)
	   (#x90DB . #xEEBE)
	   (#x90DC . #x8FE2A9)
	   (#x90DD . #x8FE2AA)
	   (#x90DF . #x8FE2AB)
	   (#x90E1 . #xB7B4)
	   (#x90E2 . #xEEBB)
	   (#x90E4 . #xEEBC)
	   (#x90E5 . #x8FE2AC)
	   (#x90E8 . #xC9F4)
	   (#x90EB . #x8FE2AF)
	   (#x90ED . #xB3D4)
	   (#x90EF . #x8FE2B0)
	   (#x90F0 . #x8FE2B1)
	   (#x90F4 . #x8FE2B2)
	   (#x90F5 . #xCDB9)
	   (#x90F6 . #x8FE2AE)
	   (#x90F7 . #xB6BF)
	   (#x90FD . #xC5D4)
	   (#x90FE . #x8FE2B3)
	   (#x90FF . #x8FE2B4)
	   (#x9100 . #x8FE2B5)
	   (#x9102 . #xEEBF)
	   (#x9104 . #x8FE2B6)
	   (#x9105 . #x8FE2B7)
	   (#x9106 . #x8FE2B8)
	   (#x9108 . #x8FE2B9)
	   (#x910D . #x8FE2BA)
	   (#x9110 . #x8FE2BB)
	   (#x9112 . #xEEC0)
	   (#x9114 . #x8FE2BC)
	   (#x9116 . #x8FE2BD)
	   (#x9117 . #x8FE2BE)
	   (#x9118 . #x8FE2BF)
	   (#x9119 . #xEEC1)
	   (#x911A . #x8FE2C0)
	   (#x911C . #x8FE2C1)
	   (#x911E . #x8FE2C2)
	   (#x9120 . #x8FE2C3)
	   (#x9122 . #x8FE2C5)
	   (#x9123 . #x8FE2C6)
	   (#x9125 . #x8FE2C4)
	   (#x9127 . #x8FE2C7)
	   (#x9129 . #x8FE2C8)
	   (#x912D . #xC5A2)
	   (#x912E . #x8FE2C9)
	   (#x912F . #x8FE2CA)
	   (#x9130 . #xEEC3)
	   (#x9131 . #x8FE2CB)
	   (#x9132 . #xEEC2)
	   (#x9134 . #x8FE2CC)
	   (#x9136 . #x8FE2CD)
	   (#x9137 . #x8FE2CE)
	   (#x9139 . #x8FE2CF)
	   (#x913A . #x8FE2D0)
	   (#x913C . #x8FE2D1)
	   (#x913D . #x8FE2D2)
	   (#x9143 . #x8FE2D3)
	   (#x9147 . #x8FE2D4)
	   (#x9148 . #x8FE2D5)
	   (#x9149 . #xC6D3)
	   (#x914A . #xEEC4)
	   (#x914B . #xBDB6)
	   (#x914C . #xBCE0)
	   (#x914D . #xC7DB)
	   (#x914E . #xC3F1)
	   (#x914F . #x8FE2D6)
	   (#x9152 . #xBCF2)
	   (#x9153 . #x8FE2D7)
	   (#x9154 . #xBFEC)
	   (#x9156 . #xEEC5)
	   (#x9157 . #x8FE2D8)
	   (#x9158 . #xEEC6)
	   (#x9159 . #x8FE2D9)
	   (#x915A . #x8FE2DA)
	   (#x915B . #x8FE2DB)
	   (#x9161 . #x8FE2DC)
	   (#x9162 . #xBFDD)
	   (#x9163 . #xEEC7)
	   (#x9164 . #x8FE2DD)
	   (#x9165 . #xEEC8)
	   (#x9167 . #x8FE2DE)
	   (#x9169 . #xEEC9)
	   (#x916A . #xCDEF)
	   (#x916C . #xBDB7)
	   (#x916D . #x8FE2DF)
	   (#x9172 . #xEECB)
	   (#x9173 . #xEECA)
	   (#x9174 . #x8FE2E0)
	   (#x9175 . #xB9DA)
	   (#x9177 . #xB9F3)
	   (#x9178 . #xBBC0)
	   (#x9179 . #x8FE2E1)
	   (#x917A . #x8FE2E2)
	   (#x917B . #x8FE2E3)
	   (#x9181 . #x8FE2E4)
	   (#x9182 . #xEECE)
	   (#x9183 . #x8FE2E5)
	   (#x9185 . #x8FE2E6)
	   (#x9186 . #x8FE2E7)
	   (#x9187 . #xBDE6)
	   (#x9189 . #xEECD)
	   (#x918A . #x8FE2E8)
	   (#x918B . #xEECC)
	   (#x918D . #xC2E9)
	   (#x918E . #x8FE2E9)
	   (#x9190 . #xB8EF)
	   (#x9191 . #x8FE2EA)
	   (#x9192 . #xC0C3)
	   (#x9193 . #x8FE2EB)
	   (#x9194 . #x8FE2EC)
	   (#x9195 . #x8FE2ED)
	   (#x9197 . #xC8B0)
	   (#x9198 . #x8FE2EE)
	   (#x919C . #xBDB9)
	   (#x919E . #x8FE2EF)
	   (#x91A1 . #x8FE2F0)
	   (#x91A2 . #xEECF)
	   (#x91A4 . #xBEDF)
	   (#x91A6 . #x8FE2F1)
	   (#x91A8 . #x8FE2F2)
	   (#x91AA . #xEED2)
	   (#x91AB . #xEED0)
	   (#x91AC . #x8FE2F3)
	   (#x91AD . #x8FE2F4)
	   (#x91AE . #x8FE2F5)
	   (#x91AF . #xEED1)
	   (#x91B0 . #x8FE2F6)
	   (#x91B1 . #x8FE2F7)
	   (#x91B2 . #x8FE2F8)
	   (#x91B3 . #x8FE2F9)
	   (#x91B4 . #xEED4)
	   (#x91B5 . #xEED3)
	   (#x91B6 . #x8FE2FA)
	   (#x91B8 . #xBEFA)
	   (#x91BA . #xEED5)
	   (#x91BB . #x8FE2FB)
	   (#x91BC . #x8FE2FC)
	   (#x91BD . #x8FE2FD)
	   (#x91BF . #x8FE2FE)
	   (#x91C0 . #xEED6)
	   (#x91C1 . #xEED7)
	   (#x91C2 . #x8FE3A1)
	   (#x91C3 . #x8FE3A2)
	   (#x91C5 . #x8FE3A3)
	   (#x91C6 . #xC8D0)
	   (#x91C7 . #xBAD3)
	   (#x91C8 . #xBCE1)
	   (#x91C9 . #xEED8)
	   (#x91CB . #xEED9)
	   (#x91CC . #xCEA4)
	   (#x91CD . #xBDC5)
	   (#x91CE . #xCCEE)
	   (#x91CF . #xCECC)
	   (#x91D0 . #xEEDA)
	   (#x91D1 . #xB6E2)
	   (#x91D3 . #x8FE3A4)
	   (#x91D4 . #x8FE3A5)
	   (#x91D6 . #xEEDB)
	   (#x91D7 . #x8FE3A6)
	   (#x91D8 . #xC5A3)
	   (#x91D9 . #x8FE3A7)
	   (#x91DA . #x8FE3A8)
	   (#x91DB . #xEEDE)
	   (#x91DC . #xB3F8)
	   (#x91DD . #xBFCB)
	   (#x91DE . #x8FE3A9)
	   (#x91DF . #xEEDC)
	   (#x91E1 . #xEEDD)
	   (#x91E3 . #xC4E0)
	   (#x91E4 . #x8FE3AA)
	   (#x91E5 . #x8FE3AB)
	   (#x91E6 . #xCBD5)
	   (#x91E7 . #xB6FC)
	   (#x91E9 . #x8FE3AC)
	   (#x91EA . #x8FE3AD)
	   (#x91EC . #x8FE3AE)
	   (#x91ED . #x8FE3AF)
	   (#x91EE . #x8FE3B0)
	   (#x91EF . #x8FE3B1)
	   (#x91F0 . #x8FE3B2)
	   (#x91F1 . #x8FE3B3)
	   (#x91F5 . #xEEE0)
	   (#x91F6 . #xEEE1)
	   (#x91F7 . #x8FE3B4)
	   (#x91F9 . #x8FE3B5)
	   (#x91FB . #x8FE3B6)
	   (#x91FC . #xEEDF)
	   (#x91FD . #x8FE3B7)
	   (#x91FF . #xEEE3)
	   (#x9200 . #x8FE3B8)
	   (#x9201 . #x8FE3B9)
	   (#x9204 . #x8FE3BA)
	   (#x9205 . #x8FE3BB)
	   (#x9206 . #x8FE3BC)
	   (#x9207 . #x8FE3BD)
	   (#x9209 . #x8FE3BE)
	   (#x920A . #x8FE3BF)
	   (#x920C . #x8FE3C0)
	   (#x920D . #xC6DF)
	   (#x920E . #xB3C3)
	   (#x9210 . #x8FE3C1)
	   (#x9211 . #xEEE7)
	   (#x9212 . #x8FE3C2)
	   (#x9213 . #x8FE3C3)
	   (#x9214 . #xEEE4)
	   (#x9215 . #xEEE6)
	   (#x9216 . #x8FE3C4)
	   (#x9218 . #x8FE3C5)
	   (#x921C . #x8FE3C6)
	   (#x921D . #x8FE3C7)
	   (#x921E . #xEEE2)
	   (#x9223 . #x8FE3C8)
	   (#x9224 . #x8FE3C9)
	   (#x9225 . #x8FE3CA)
	   (#x9226 . #x8FE3CB)
	   (#x9228 . #x8FE3CC)
	   (#x9229 . #xEFCF)
	   (#x922C . #xEEE5)
	   (#x922E . #x8FE3CD)
	   (#x922F . #x8FE3CE)
	   (#x9230 . #x8FE3CF)
	   (#x9233 . #x8FE3D0)
	   (#x9234 . #xCEEB)
	   (#x9235 . #x8FE3D1)
	   (#x9236 . #x8FE3D2)
	   (#x9237 . #xB8DA)
	   (#x9238 . #x8FE3D3)
	   (#x9239 . #x8FE3D4)
	   (#x923A . #x8FE3D5)
	   (#x923C . #x8FE3D6)
	   (#x923E . #x8FE3D7)
	   (#x923F . #xEEEF)
	   (#x9240 . #x8FE3D8)
	   (#x9242 . #x8FE3D9)
	   (#x9243 . #x8FE3DA)
	   (#x9244 . #xC5B4)
	   (#x9245 . #xEEEA)
	   (#x9246 . #x8FE3DB)
	   (#x9247 . #x8FE3DC)
	   (#x9248 . #xEEED)
	   (#x9249 . #xEEEB)
	   (#x924A . #x8FE3DD)
	   (#x924B . #xEEF0)
	   (#x924D . #x8FE3DE)
	   (#x924E . #x8FE3DF)
	   (#x924F . #x8FE3E0)
	   (#x9250 . #xEEF1)
	   (#x9251 . #x8FE3E1)
	   (#x9257 . #xEEE9)
	   (#x9258 . #x8FE3E2)
	   (#x9259 . #x8FE3E3)
	   (#x925A . #xEEF6)
	   (#x925B . #xB1F4)
	   (#x925C . #x8FE3E4)
	   (#x925D . #x8FE3E5)
	   (#x925E . #xEEE8)
	   (#x9260 . #x8FE3E6)
	   (#x9261 . #x8FE3E7)
	   (#x9262 . #xC8AD)
	   (#x9264 . #xEEEC)
	   (#x9265 . #x8FE3E8)
	   (#x9266 . #xBEE0)
	   (#x9267 . #x8FE3E9)
	   (#x9268 . #x8FE3EA)
	   (#x9269 . #x8FE3EB)
	   (#x926E . #x8FE3EC)
	   (#x926F . #x8FE3ED)
	   (#x9270 . #x8FE3EE)
	   (#x9271 . #xB9DB)
	   (#x9275 . #x8FE3EF)
	   (#x9276 . #x8FE3F0)
	   (#x9277 . #x8FE3F1)
	   (#x9278 . #x8FE3F2)
	   (#x9279 . #x8FE3F3)
	   (#x927B . #x8FE3F4)
	   (#x927C . #x8FE3F5)
	   (#x927D . #x8FE3F6)
	   (#x927E . #xCBC8)
	   (#x927F . #x8FE3F7)
	   (#x9280 . #xB6E4)
	   (#x9283 . #xBDC6)
	   (#x9285 . #xC6BC)
	   (#x9288 . #x8FE3F8)
	   (#x9289 . #x8FE3F9)
	   (#x928A . #x8FE3FA)
	   (#x928D . #x8FE3FB)
	   (#x928E . #x8FE3FC)
	   (#x9291 . #xC1AD)
	   (#x9292 . #x8FE3FD)
	   (#x9293 . #xEEF4)
	   (#x9295 . #xEEEE)
	   (#x9296 . #xEEF3)
	   (#x9297 . #x8FE3FE)
	   (#x9298 . #xCCC3)
	   (#x9299 . #x8FE4A1)
	   (#x929A . #xC4B8)
	   (#x929B . #xEEF5)
	   (#x929C . #xEEF2)
	   (#x929F . #x8FE4A2)
	   (#x92A0 . #x8FE4A3)
	   (#x92A4 . #x8FE4A4)
	   (#x92A5 . #x8FE4A5)
	   (#x92A7 . #x8FE4A6)
	   (#x92A8 . #x8FE4A7)
	   (#x92AB . #x8FE4A8)
	   (#x92AD . #xC1AC)
	   (#x92AF . #x8FE4A9)
	   (#x92B2 . #x8FE4AA)
	   (#x92B6 . #x8FE4AB)
	   (#x92B7 . #xEEF9)
	   (#x92B8 . #x8FE4AC)
	   (#x92B9 . #xEEF8)
	   (#x92BA . #x8FE4AD)
	   (#x92BB . #x8FE4AE)
	   (#x92BC . #x8FE4AF)
	   (#x92BD . #x8FE4B0)
	   (#x92BF . #x8FE4B1)
	   (#x92C0 . #x8FE4B2)
	   (#x92C1 . #x8FE4B3)
	   (#x92C2 . #x8FE4B4)
	   (#x92C3 . #x8FE4B5)
	   (#x92C5 . #x8FE4B6)
	   (#x92C6 . #x8FE4B7)
	   (#x92C7 . #x8FE4B8)
	   (#x92C8 . #x8FE4B9)
	   (#x92CB . #x8FE4BA)
	   (#x92CC . #x8FE4BB)
	   (#x92CD . #x8FE4BC)
	   (#x92CE . #x8FE4BD)
	   (#x92CF . #xEEF7)
	   (#x92D0 . #x8FE4BE)
	   (#x92D2 . #xCBAF)
	   (#x92D3 . #x8FE4BF)
	   (#x92D5 . #x8FE4C0)
	   (#x92D7 . #x8FE4C1)
	   (#x92D8 . #x8FE4C2)
	   (#x92D9 . #x8FE4C3)
	   (#x92DC . #x8FE4C4)
	   (#x92DD . #x8FE4C5)
	   (#x92DF . #x8FE4C6)
	   (#x92E0 . #x8FE4C7)
	   (#x92E1 . #x8FE4C8)
	   (#x92E3 . #x8FE4C9)
	   (#x92E4 . #xBDFB)
	   (#x92E5 . #x8FE4CA)
	   (#x92E7 . #x8FE4CB)
	   (#x92E8 . #x8FE4CC)
	   (#x92E9 . #xEEFA)
	   (#x92EA . #xCADF)
	   (#x92EC . #x8FE4CD)
	   (#x92ED . #xB1D4)
	   (#x92EE . #x8FE4CE)
	   (#x92F0 . #x8FE4CF)
	   (#x92F2 . #xC9C6)
	   (#x92F3 . #xC3F2)
	   (#x92F8 . #xB5F8)
	   (#x92F9 . #x8FE4D0)
	   (#x92FA . #xEEFC)
	   (#x92FB . #x8FE4D1)
	   (#x92FC . #xB9DD)
	   (#x92FF . #x8FE4D2)
	   (#x9300 . #x8FE4D3)
	   (#x9302 . #x8FE4D4)
	   (#x9306 . #xBBAC)
	   (#x9308 . #x8FE4D5)
	   (#x930D . #x8FE4D6)
	   (#x930F . #xEEFB)
	   (#x9310 . #xBFED)
	   (#x9311 . #x8FE4D7)
	   (#x9314 . #x8FE4D8)
	   (#x9315 . #x8FE4D9)
	   (#x9318 . #xBFEE)
	   (#x9319 . #xEFA1)
	   (#x931A . #xEFA3)
	   (#x931C . #x8FE4DA)
	   (#x931D . #x8FE4DB)
	   (#x931E . #x8FE4DC)
	   (#x931F . #x8FE4DD)
	   (#x9320 . #xBEFB)
	   (#x9321 . #x8FE4DE)
	   (#x9322 . #xEFA2)
	   (#x9323 . #xEFA4)
	   (#x9324 . #x8FE4DF)
	   (#x9325 . #x8FE4E0)
	   (#x9326 . #xB6D3)
	   (#x9327 . #x8FE4E1)
	   (#x9328 . #xC9C5)
	   (#x9329 . #x8FE4E2)
	   (#x932A . #x8FE4E3)
	   (#x932B . #xBCE2)
	   (#x932C . #xCFA3)
	   (#x932E . #xEEFE)
	   (#x932F . #xBAF8)
	   (#x9332 . #xCFBF)
	   (#x9333 . #x8FE4E4)
	   (#x9334 . #x8FE4E5)
	   (#x9335 . #xEFA6)
	   (#x9336 . #x8FE4E6)
	   (#x9337 . #x8FE4E7)
	   (#x933A . #xEFA5)
	   (#x933B . #xEFA7)
	   (#x9344 . #xEEFD)
	   (#x9347 . #x8FE4E8)
	   (#x9348 . #x8FE4E9)
	   (#x9349 . #x8FE4EA)
	   (#x934B . #xC6E9)
	   (#x934D . #xC5D5)
	   (#x9350 . #x8FE4EB)
	   (#x9351 . #x8FE4EC)
	   (#x9352 . #x8FE4ED)
	   (#x9354 . #xC4D7)
	   (#x9355 . #x8FE4EE)
	   (#x9356 . #xEFAC)
	   (#x9357 . #x8FE4EF)
	   (#x9358 . #x8FE4F0)
	   (#x935A . #x8FE4F1)
	   (#x935B . #xC3C3)
	   (#x935C . #xEFA8)
	   (#x935E . #x8FE4F2)
	   (#x9360 . #xEFA9)
	   (#x9364 . #x8FE4F3)
	   (#x9365 . #x8FE4F4)
	   (#x9367 . #x8FE4F5)
	   (#x9369 . #x8FE4F6)
	   (#x936A . #x8FE4F7)
	   (#x936C . #xB7AD)
	   (#x936D . #x8FE4F8)
	   (#x936E . #xEFAB)
	   (#x936F . #x8FE4F9)
	   (#x9370 . #x8FE4FA)
	   (#x9371 . #x8FE4FB)
	   (#x9373 . #x8FE4FC)
	   (#x9374 . #x8FE4FD)
	   (#x9375 . #xB8B0)
	   (#x9376 . #x8FE4FE)
	   (#x937A . #x8FE5A1)
	   (#x937C . #xEFAA)
	   (#x937D . #x8FE5A2)
	   (#x937E . #xBEE1)
	   (#x937F . #x8FE5A3)
	   (#x9380 . #x8FE5A4)
	   (#x9381 . #x8FE5A5)
	   (#x9382 . #x8FE5A6)
	   (#x9388 . #x8FE5A7)
	   (#x938A . #x8FE5A8)
	   (#x938B . #x8FE5A9)
	   (#x938C . #xB3F9)
	   (#x938D . #x8FE5AA)
	   (#x938F . #x8FE5AB)
	   (#x9392 . #x8FE5AC)
	   (#x9394 . #xEFB0)
	   (#x9395 . #x8FE5AD)
	   (#x9396 . #xBABF)
	   (#x9397 . #xC1F9)
	   (#x9398 . #x8FE5AE)
	   (#x939A . #xC4CA)
	   (#x939B . #x8FE5AF)
	   (#x939E . #x8FE5B0)
	   (#x93A1 . #x8FE5B1)
	   (#x93A3 . #x8FE5B2)
	   (#x93A4 . #x8FE5B3)
	   (#x93A6 . #x8FE5B4)
	   (#x93A7 . #xB3BB)
	   (#x93A8 . #x8FE5B5)
	   (#x93A9 . #x8FE5BB)
	   (#x93AB . #x8FE5B6)
	   (#x93AC . #xEFAE)
	   (#x93AD . #xEFAF)
	   (#x93AE . #xC4C3)
	   (#x93B0 . #xEFAD)
	   (#x93B4 . #x8FE5B7)
	   (#x93B5 . #x8FE5B8)
	   (#x93B6 . #x8FE5B9)
	   (#x93B9 . #xEFB1)
	   (#x93BA . #x8FE5BA)
	   (#x93C1 . #x8FE5BC)
	   (#x93C3 . #xEFB7)
	   (#x93C4 . #x8FE5BD)
	   (#x93C5 . #x8FE5BE)
	   (#x93C6 . #x8FE5BF)
	   (#x93C7 . #x8FE5C0)
	   (#x93C8 . #xEFBA)
	   (#x93C9 . #x8FE5C1)
	   (#x93CA . #x8FE5C2)
	   (#x93CB . #x8FE5C3)
	   (#x93CC . #x8FE5C4)
	   (#x93CD . #x8FE5C5)
	   (#x93D0 . #xEFB9)
	   (#x93D1 . #xC5AD)
	   (#x93D3 . #x8FE5C6)
	   (#x93D6 . #xEFB2)
	   (#x93D7 . #xEFB3)
	   (#x93D8 . #xEFB6)
	   (#x93D9 . #x8FE5C7)
	   (#x93DC . #x8FE5C8)
	   (#x93DD . #xEFB8)
	   (#x93DE . #x8FE5C9)
	   (#x93DF . #x8FE5CA)
	   (#x93E1 . #xB6C0)
	   (#x93E2 . #x8FE5CB)
	   (#x93E4 . #xEFBB)
	   (#x93E5 . #xEFB5)
	   (#x93E6 . #x8FE5CC)
	   (#x93E7 . #x8FE5CD)
	   (#x93E8 . #xEFB4)
	   (#x93F7 . #x8FE5CF)
	   (#x93F8 . #x8FE5D0)
	   (#x93F9 . #x8FE5CE)
	   (#x93FA . #x8FE5D1)
	   (#x93FB . #x8FE5D2)
	   (#x93FD . #x8FE5D3)
	   (#x9401 . #x8FE5D4)
	   (#x9402 . #x8FE5D5)
	   (#x9403 . #xEFBF)
	   (#x9404 . #x8FE5D6)
	   (#x9407 . #xEFC0)
	   (#x9408 . #x8FE5D7)
	   (#x9409 . #x8FE5D8)
	   (#x940D . #x8FE5D9)
	   (#x940E . #x8FE5DA)
	   (#x940F . #x8FE5DB)
	   (#x9410 . #xEFC1)
	   (#x9413 . #xEFBE)
	   (#x9414 . #xEFBD)
	   (#x9415 . #x8FE5DC)
	   (#x9416 . #x8FE5DD)
	   (#x9417 . #x8FE5DE)
	   (#x9418 . #xBEE2)
	   (#x9419 . #xC6AA)
	   (#x941A . #xEFBC)
	   (#x941F . #x8FE5DF)
	   (#x9421 . #xEFC5)
	   (#x942B . #xEFC3)
	   (#x942E . #x8FE5E0)
	   (#x942F . #x8FE5E1)
	   (#x9431 . #x8FE5E2)
	   (#x9432 . #x8FE5E3)
	   (#x9433 . #x8FE5E4)
	   (#x9434 . #x8FE5E5)
	   (#x9435 . #xEFC4)
	   (#x9436 . #xEFC2)
	   (#x9438 . #xC2F8)
	   (#x943A . #xEFC6)
	   (#x943B . #x8FE5E6)
	   (#x943D . #x8FE5E8)
	   (#x943F . #x8FE5E7)
	   (#x9441 . #xEFC7)
	   (#x9443 . #x8FE5E9)
	   (#x9444 . #xEFC9)
	   (#x9445 . #x8FE5EA)
	   (#x9448 . #x8FE5EB)
	   (#x944A . #x8FE5EC)
	   (#x944C . #x8FE5ED)
	   (#x9451 . #xB4D5)
	   (#x9452 . #xEFC8)
	   (#x9453 . #xCCFA)
	   (#x9455 . #x8FE5EE)
	   (#x9459 . #x8FE5EF)
	   (#x945A . #xEFD4)
	   (#x945B . #xEFCA)
	   (#x945C . #x8FE5F0)
	   (#x945E . #xEFCD)
	   (#x945F . #x8FE5F1)
	   (#x9460 . #xEFCB)
	   (#x9461 . #x8FE5F2)
	   (#x9462 . #xEFCC)
	   (#x9463 . #x8FE5F3)
	   (#x9468 . #x8FE5F4)
	   (#x946A . #xEFCE)
	   (#x946B . #x8FE5F5)
	   (#x946D . #x8FE5F6)
	   (#x946E . #x8FE5F7)
	   (#x946F . #x8FE5F8)
	   (#x9470 . #xEFD0)
	   (#x9471 . #x8FE5F9)
	   (#x9472 . #x8FE5FA)
	   (#x9475 . #xEFD1)
	   (#x9477 . #xEFD2)
	   (#x947C . #xEFD5)
	   (#x947D . #xEFD3)
	   (#x947E . #xEFD6)
	   (#x947F . #xEFD8)
	   (#x9481 . #xEFD7)
	   (#x9483 . #x8FE5FC)
	   (#x9484 . #x8FE5FB)
	   (#x9577 . #xC4B9)
	   (#x9578 . #x8FE5FD)
	   (#x9579 . #x8FE5FE)
	   (#x957E . #x8FE6A1)
	   (#x9580 . #xCCE7)
	   (#x9582 . #xEFD9)
	   (#x9583 . #xC1AE)
	   (#x9584 . #x8FE6A2)
	   (#x9587 . #xEFDA)
	   (#x9588 . #x8FE6A3)
	   (#x9589 . #xCAC4)
	   (#x958A . #xEFDB)
	   (#x958B . #xB3AB)
	   (#x958C . #x8FE6A4)
	   (#x958D . #x8FE6A5)
	   (#x958E . #x8FE6A6)
	   (#x958F . #xB1BC)
	   (#x9591 . #xB4D7)
	   (#x9593 . #xB4D6)
	   (#x9594 . #xEFDC)
	   (#x9596 . #xEFDD)
	   (#x9598 . #xEFDE)
	   (#x9599 . #xEFDF)
	   (#x959D . #x8FE6A7)
	   (#x959E . #x8FE6A8)
	   (#x959F . #x8FE6A9)
	   (#x95A0 . #xEFE0)
	   (#x95A1 . #x8FE6AA)
	   (#x95A2 . #xB4D8)
	   (#x95A3 . #xB3D5)
	   (#x95A4 . #xB9DE)
	   (#x95A5 . #xC8B6)
	   (#x95A6 . #x8FE6AB)
	   (#x95A7 . #xEFE2)
	   (#x95A8 . #xEFE1)
	   (#x95A9 . #x8FE6AC)
	   (#x95AB . #x8FE6AD)
	   (#x95AC . #x8FE6AE)
	   (#x95AD . #xEFE3)
	   (#x95B2 . #xB1DC)
	   (#x95B4 . #x8FE6AF)
	   (#x95B6 . #x8FE6B0)
	   (#x95B9 . #xEFE6)
	   (#x95BA . #x8FE6B1)
	   (#x95BB . #xEFE5)
	   (#x95BC . #xEFE4)
	   (#x95BD . #x8FE6B2)
	   (#x95BE . #xEFE7)
	   (#x95BF . #x8FE6B3)
	   (#x95C3 . #xEFEA)
	   (#x95C6 . #x8FE6B4)
	   (#x95C7 . #xB0C7)
	   (#x95C8 . #x8FE6B5)
	   (#x95C9 . #x8FE6B6)
	   (#x95CA . #xEFE8)
	   (#x95CB . #x8FE6B7)
	   (#x95CC . #xEFEC)
	   (#x95CD . #xEFEB)
	   (#x95D0 . #x8FE6B8)
	   (#x95D1 . #x8FE6B9)
	   (#x95D2 . #x8FE6BA)
	   (#x95D3 . #x8FE6BB)
	   (#x95D4 . #xEFEE)
	   (#x95D5 . #xEFED)
	   (#x95D6 . #xEFEF)
	   (#x95D8 . #xC6AE)
	   (#x95D9 . #x8FE6BC)
	   (#x95DA . #x8FE6BD)
	   (#x95DC . #xEFF0)
	   (#x95DD . #x8FE6BE)
	   (#x95DE . #x8FE6BF)
	   (#x95DF . #x8FE6C0)
	   (#x95E0 . #x8FE6C1)
	   (#x95E1 . #xEFF1)
	   (#x95E2 . #xEFF3)
	   (#x95E4 . #x8FE6C2)
	   (#x95E5 . #xEFF2)
	   (#x95E6 . #x8FE6C3)
	   (#x961C . #xC9EC)
	   (#x961D . #x8FE6C4)
	   (#x961E . #x8FE6C5)
	   (#x9621 . #xEFF4)
	   (#x9622 . #x8FE6C6)
	   (#x9624 . #x8FE6C7)
	   (#x9625 . #x8FE6C8)
	   (#x9626 . #x8FE6C9)
	   (#x9628 . #xEFF5)
	   (#x962A . #xBAE5)
	   (#x962C . #x8FE6CA)
	   (#x962E . #xEFF6)
	   (#x962F . #xEFF7)
	   (#x9631 . #x8FE6CB)
	   (#x9632 . #xCBC9)
	   (#x9633 . #x8FE6CC)
	   (#x9637 . #x8FE6CD)
	   (#x9638 . #x8FE6CE)
	   (#x9639 . #x8FE6CF)
	   (#x963A . #x8FE6D0)
	   (#x963B . #xC1CB)
	   (#x963C . #x8FE6D1)
	   (#x963D . #x8FE6D2)
	   (#x963F . #xB0A4)
	   (#x9640 . #xC2CB)
	   (#x9641 . #x8FE6D3)
	   (#x9642 . #xEFF8)
	   (#x9644 . #xC9ED)
	   (#x964B . #xEFFB)
	   (#x964C . #xEFF9)
	   (#x964D . #xB9DF)
	   (#x964F . #xEFFA)
	   (#x9650 . #xB8C2)
	   (#x9652 . #x8FE6D4)
	   (#x9654 . #x8FE6D5)
	   (#x9656 . #x8FE6D6)
	   (#x9657 . #x8FE6D7)
	   (#x9658 . #x8FE6D8)
	   (#x965B . #xCAC5)
	   (#x965C . #xEFFD)
	   (#x965D . #xF0A1)
	   (#x965E . #xEFFE)
	   (#x965F . #xF0A2)
	   (#x9661 . #x8FE6D9)
	   (#x9662 . #xB1A1)
	   (#x9663 . #xBFD8)
	   (#x9664 . #xBDFC)
	   (#x9665 . #xB4D9)
	   (#x9666 . #xF0A3)
	   (#x966A . #xC7E6)
	   (#x966C . #xF0A5)
	   (#x966E . #x8FE6DA)
	   (#x9670 . #xB1A2)
	   (#x9672 . #xF0A4)
	   (#x9673 . #xC4C4)
	   (#x9674 . #x8FE6DB)
	   (#x9675 . #xCECD)
	   (#x9676 . #xC6AB)
	   (#x9677 . #xEFFC)
	   (#x9678 . #xCEA6)
	   (#x967A . #xB8B1)
	   (#x967B . #x8FE6DC)
	   (#x967C . #x8FE6DD)
	   (#x967D . #xCDDB)
	   (#x967E . #x8FE6DE)
	   (#x967F . #x8FE6DF)
	   (#x9681 . #x8FE6E0)
	   (#x9682 . #x8FE6E1)
	   (#x9683 . #x8FE6E2)
	   (#x9684 . #x8FE6E3)
	   (#x9685 . #xB6F9)
	   (#x9686 . #xCEB4)
	   (#x9688 . #xB7A8)
	   (#x9689 . #x8FE6E4)
	   (#x968A . #xC2E2)
	   (#x968B . #xE7A1)
	   (#x968D . #xF0A6)
	   (#x968E . #xB3AC)
	   (#x968F . #xBFEF)
	   (#x9691 . #x8FE6E5)
	   (#x9694 . #xB3D6)
	   (#x9695 . #xF0A8)
	   (#x9696 . #x8FE6E6)
	   (#x9697 . #xF0A9)
	   (#x9698 . #xF0A7)
	   (#x9699 . #xB7E4)
	   (#x969A . #x8FE6E7)
	   (#x969B . #xBADD)
	   (#x969C . #xBEE3)
	   (#x969D . #x8FE6E8)
	   (#x969F . #x8FE6E9)
	   (#x96A0 . #xB1A3)
	   (#x96A3 . #xCED9)
	   (#x96A4 . #x8FE6EA)
	   (#x96A5 . #x8FE6EB)
	   (#x96A6 . #x8FE6EC)
	   (#x96A7 . #xF0AB)
	   (#x96A8 . #xEEAE)
	   (#x96A9 . #x8FE6ED)
	   (#x96AA . #xF0AA)
	   (#x96AE . #x8FE6EE)
	   (#x96AF . #x8FE6EF)
	   (#x96B0 . #xF0AE)
	   (#x96B1 . #xF0AC)
	   (#x96B2 . #xF0AD)
	   (#x96B3 . #x8FE6F0)
	   (#x96B4 . #xF0AF)
	   (#x96B6 . #xF0B0)
	   (#x96B7 . #xCEEC)
	   (#x96B8 . #xF0B1)
	   (#x96B9 . #xF0B2)
	   (#x96BA . #x8FE6F1)
	   (#x96BB . #xC0C9)
	   (#x96BC . #xC8BB)
	   (#x96C0 . #xBFFD)
	   (#x96C1 . #xB4E7)
	   (#x96C4 . #xCDBA)
	   (#x96C5 . #xB2ED)
	   (#x96C6 . #xBDB8)
	   (#x96C7 . #xB8DB)
	   (#x96C9 . #xF0B5)
	   (#x96CA . #x8FE6F2)
	   (#x96CB . #xF0B4)
	   (#x96CC . #xBBF3)
	   (#x96CD . #xF0B6)
	   (#x96CE . #xF0B3)
	   (#x96D1 . #xBBA8)
	   (#x96D2 . #x8FE6F3)
	   (#x96D5 . #xF0BA)
	   (#x96D6 . #xEAAD)
	   (#x96D8 . #x8FE6F5)
	   (#x96D9 . #xD2D6)
	   (#x96DA . #x8FE6F6)
	   (#x96DB . #xBFF7)
	   (#x96DC . #xF0B8)
	   (#x96DD . #x8FE6F7)
	   (#x96DE . #x8FE6F8)
	   (#x96DF . #x8FE6F9)
	   (#x96E2 . #xCEA5)
	   (#x96E3 . #xC6F1)
	   (#x96E8 . #xB1AB)
	   (#x96E9 . #x8FE6FA)
	   (#x96EA . #xC0E3)
	   (#x96EB . #xBCB6)
	   (#x96EF . #x8FE6FB)
	   (#x96F0 . #xCAB7)
	   (#x96F1 . #x8FE6FC)
	   (#x96F2 . #xB1C0)
	   (#x96F6 . #xCEED)
	   (#x96F7 . #xCDEB)
	   (#x96F9 . #xF0BB)
	   (#x96FA . #x8FE6FD)
	   (#x96FB . #xC5C5)
	   (#x9700 . #xBCFB)
	   (#x9702 . #x8FE6FE)
	   (#x9703 . #x8FE7A1)
	   (#x9704 . #xF0BC)
	   (#x9705 . #x8FE7A2)
	   (#x9706 . #xF0BD)
	   (#x9707 . #xBFCC)
	   (#x9708 . #xF0BE)
	   (#x9709 . #x8FE7A3)
	   (#x970A . #xCEEE)
	   (#x970D . #xF0B9)
	   (#x970E . #xF0C0)
	   (#x970F . #xF0C2)
	   (#x9711 . #xF0C1)
	   (#x9713 . #xF0BF)
	   (#x9716 . #xF0C3)
	   (#x9719 . #xF0C4)
	   (#x971A . #x8FE7A4)
	   (#x971B . #x8FE7A5)
	   (#x971C . #xC1FA)
	   (#x971D . #x8FE7A6)
	   (#x971E . #xB2E2)
	   (#x9721 . #x8FE7A7)
	   (#x9722 . #x8FE7A8)
	   (#x9723 . #x8FE7A9)
	   (#x9724 . #xF0C5)
	   (#x9727 . #xCCB8)
	   (#x9728 . #x8FE7AA)
	   (#x972A . #xF0C6)
	   (#x9730 . #xF0C7)
	   (#x9731 . #x8FE7AB)
	   (#x9732 . #xCFAA)
	   (#x9733 . #x8FE7AC)
	   (#x9738 . #xDBB1)
	   (#x9739 . #xF0C8)
	   (#x973D . #xF0C9)
	   (#x973E . #xF0CA)
	   (#x9741 . #x8FE7AD)
	   (#x9742 . #xF0CE)
	   (#x9743 . #x8FE7AE)
	   (#x9744 . #xF0CB)
	   (#x9746 . #xF0CC)
	   (#x9748 . #xF0CD)
	   (#x9749 . #xF0CF)
	   (#x974A . #x8FE7AF)
	   (#x974E . #x8FE7B0)
	   (#x974F . #x8FE7B1)
	   (#x9752 . #xC0C4)
	   (#x9755 . #x8FE7B2)
	   (#x9756 . #xCCF7)
	   (#x9757 . #x8FE7B3)
	   (#x9758 . #x8FE7B4)
	   (#x9759 . #xC0C5)
	   (#x975A . #x8FE7B5)
	   (#x975B . #x8FE7B6)
	   (#x975C . #xF0D0)
	   (#x975E . #xC8F3)
	   (#x9760 . #xF0D1)
	   (#x9761 . #xF3D3)
	   (#x9762 . #xCCCC)
	   (#x9763 . #x8FE7B7)
	   (#x9764 . #xF0D2)
	   (#x9766 . #xF0D3)
	   (#x9767 . #x8FE7B8)
	   (#x9768 . #xF0D4)
	   (#x9769 . #xB3D7)
	   (#x976A . #x8FE7B9)
	   (#x976B . #xF0D6)
	   (#x976D . #xBFD9)
	   (#x976E . #x8FE7BA)
	   (#x9771 . #xF0D7)
	   (#x9773 . #x8FE7BB)
	   (#x9774 . #xB7A4)
	   (#x9776 . #x8FE7BC)
	   (#x9777 . #x8FE7BD)
	   (#x9778 . #x8FE7BE)
	   (#x9779 . #xF0D8)
	   (#x977A . #xF0DC)
	   (#x977B . #x8FE7BF)
	   (#x977C . #xF0DA)
	   (#x977D . #x8FE7C0)
	   (#x977F . #x8FE7C1)
	   (#x9780 . #x8FE7C2)
	   (#x9781 . #xF0DB)
	   (#x9784 . #xB3F3)
	   (#x9785 . #xF0D9)
	   (#x9786 . #xF0DD)
	   (#x9789 . #x8FE7C3)
	   (#x978B . #xF0DE)
	   (#x978D . #xB0C8)
	   (#x978F . #xF0DF)
	   (#x9790 . #xF0E0)
	   (#x9795 . #x8FE7C4)
	   (#x9796 . #x8FE7C5)
	   (#x9797 . #x8FE7C6)
	   (#x9798 . #xBEE4)
	   (#x9799 . #x8FE7C7)
	   (#x979A . #x8FE7C8)
	   (#x979C . #xF0E1)
	   (#x979E . #x8FE7C9)
	   (#x979F . #x8FE7CA)
	   (#x97A0 . #xB5C7)
	   (#x97A2 . #x8FE7CB)
	   (#x97A3 . #xF0E4)
	   (#x97A6 . #xF0E3)
	   (#x97A8 . #xF0E2)
	   (#x97AB . #xEBF1)
	   (#x97AC . #x8FE7CC)
	   (#x97AD . #xCADC)
	   (#x97AE . #x8FE7CD)
	   (#x97B1 . #x8FE7CE)
	   (#x97B2 . #x8FE7CF)
	   (#x97B3 . #xF0E5)
	   (#x97B4 . #xF0E6)
	   (#x97B5 . #x8FE7D0)
	   (#x97B6 . #x8FE7D1)
	   (#x97B8 . #x8FE7D2)
	   (#x97B9 . #x8FE7D3)
	   (#x97BA . #x8FE7D4)
	   (#x97BC . #x8FE7D5)
	   (#x97BE . #x8FE7D6)
	   (#x97BF . #x8FE7D7)
	   (#x97C1 . #x8FE7D8)
	   (#x97C3 . #xF0E7)
	   (#x97C4 . #x8FE7D9)
	   (#x97C5 . #x8FE7DA)
	   (#x97C6 . #xF0E8)
	   (#x97C7 . #x8FE7DB)
	   (#x97C8 . #xF0E9)
	   (#x97C9 . #x8FE7DC)
	   (#x97CA . #x8FE7DD)
	   (#x97CB . #xF0EA)
	   (#x97CC . #x8FE7DE)
	   (#x97CD . #x8FE7DF)
	   (#x97CE . #x8FE7E0)
	   (#x97D0 . #x8FE7E1)
	   (#x97D1 . #x8FE7E2)
	   (#x97D3 . #xB4DA)
	   (#x97D4 . #x8FE7E3)
	   (#x97D7 . #x8FE7E4)
	   (#x97D8 . #x8FE7E5)
	   (#x97D9 . #x8FE7E6)
	   (#x97DB . #x8FE7EA)
	   (#x97DC . #xF0EB)
	   (#x97DD . #x8FE7E7)
	   (#x97DE . #x8FE7E8)
	   (#x97E0 . #x8FE7E9)
	   (#x97E1 . #x8FE7EB)
	   (#x97E4 . #x8FE7EC)
	   (#x97ED . #xF0EC)
	   (#x97EE . #xC7A3)
	   (#x97EF . #x8FE7ED)
	   (#x97F1 . #x8FE7EE)
	   (#x97F2 . #xF0EE)
	   (#x97F3 . #xB2BB)
	   (#x97F4 . #x8FE7EF)
	   (#x97F5 . #xF0F1)
	   (#x97F6 . #xF0F0)
	   (#x97F7 . #x8FE7F0)
	   (#x97F8 . #x8FE7F1)
	   (#x97FA . #x8FE7F2)
	   (#x97FB . #xB1A4)
	   (#x97FF . #xB6C1)
	   (#x9801 . #xCAC7)
	   (#x9802 . #xC4BA)
	   (#x9803 . #xBAA2)
	   (#x9805 . #xB9E0)
	   (#x9806 . #xBDE7)
	   (#x9807 . #x8FE7F3)
	   (#x9808 . #xBFDC)
	   (#x980A . #x8FE7F4)
	   (#x980C . #xF0F3)
	   (#x980D . #x8FE7F6)
	   (#x980E . #x8FE7F7)
	   (#x980F . #xF0F2)
	   (#x9810 . #xCDC2)
	   (#x9811 . #xB4E8)
	   (#x9812 . #xC8D2)
	   (#x9813 . #xC6DC)
	   (#x9814 . #x8FE7F8)
	   (#x9816 . #x8FE7F9)
	   (#x9817 . #xBFFC)
	   (#x9818 . #xCECE)
	   (#x9819 . #x8FE7F5)
	   (#x981A . #xB7DB)
	   (#x981C . #x8FE7FA)
	   (#x981E . #x8FE7FB)
	   (#x9820 . #x8FE7FC)
	   (#x9821 . #xF0F6)
	   (#x9823 . #x8FE7FD)
	   (#x9824 . #xF0F5)
	   (#x9825 . #x8FE8A8)
	   (#x9826 . #x8FE7FE)
	   (#x982B . #x8FE8A1)
	   (#x982C . #xCBCB)
	   (#x982D . #xC6AC)
	   (#x982E . #x8FE8A2)
	   (#x982F . #x8FE8A3)
	   (#x9830 . #x8FE8A4)
	   (#x9832 . #x8FE8A5)
	   (#x9833 . #x8FE8A6)
	   (#x9834 . #xB1D0)
	   (#x9835 . #x8FE8A7)
	   (#x9837 . #xF0F7)
	   (#x9838 . #xF0F4)
	   (#x983B . #xC9D1)
	   (#x983C . #xCDEA)
	   (#x983D . #xF0F8)
	   (#x983E . #x8FE8A9)
	   (#x9844 . #x8FE8AA)
	   (#x9846 . #xF0F9)
	   (#x9847 . #x8FE8AB)
	   (#x984A . #x8FE8AC)
	   (#x984B . #xF0FB)
	   (#x984C . #xC2EA)
	   (#x984D . #xB3DB)
	   (#x984E . #xB3DC)
	   (#x984F . #xF0FA)
	   (#x9851 . #x8FE8AD)
	   (#x9852 . #x8FE8AE)
	   (#x9853 . #x8FE8AF)
	   (#x9854 . #xB4E9)
	   (#x9855 . #xB8B2)
	   (#x9856 . #x8FE8B0)
	   (#x9857 . #x8FE8B1)
	   (#x9858 . #xB4EA)
	   (#x9859 . #x8FE8B2)
	   (#x985A . #x8FE8B3)
	   (#x985B . #xC5BF)
	   (#x985E . #xCEE0)
	   (#x9862 . #x8FE8B4)
	   (#x9863 . #x8FE8B5)
	   (#x9865 . #x8FE8B6)
	   (#x9866 . #x8FE8B7)
	   (#x9867 . #xB8DC)
	   (#x986A . #x8FE8B8)
	   (#x986B . #xF0FC)
	   (#x986C . #x8FE8B9)
	   (#x986F . #xF0FD)
	   (#x9870 . #xF0FE)
	   (#x9871 . #xF1A1)
	   (#x9873 . #xF1A3)
	   (#x9874 . #xF1A2)
	   (#x98A8 . #xC9F7)
	   (#x98AA . #xF1A4)
	   (#x98AB . #x8FE8BA)
	   (#x98AD . #x8FE8BB)
	   (#x98AE . #x8FE8BC)
	   (#x98AF . #xF1A5)
	   (#x98B0 . #x8FE8BD)
	   (#x98B1 . #xF1A6)
	   (#x98B4 . #x8FE8BE)
	   (#x98B6 . #xF1A7)
	   (#x98B7 . #x8FE8BF)
	   (#x98B8 . #x8FE8C0)
	   (#x98BA . #x8FE8C1)
	   (#x98BB . #x8FE8C2)
	   (#x98BF . #x8FE8C3)
	   (#x98C2 . #x8FE8C4)
	   (#x98C3 . #xF1A9)
	   (#x98C4 . #xF1A8)
	   (#x98C5 . #x8FE8C5)
	   (#x98C6 . #xF1AA)
	   (#x98C8 . #x8FE8C6)
	   (#x98CC . #x8FE8C7)
	   (#x98DB . #xC8F4)
	   (#x98DC . #xE6CC)
	   (#x98DF . #xBFA9)
	   (#x98E1 . #x8FE8C8)
	   (#x98E2 . #xB5B2)
	   (#x98E3 . #x8FE8C9)
	   (#x98E5 . #x8FE8CA)
	   (#x98E6 . #x8FE8CB)
	   (#x98E7 . #x8FE8CC)
	   (#x98E9 . #xF1AB)
	   (#x98EA . #x8FE8CD)
	   (#x98EB . #xF1AC)
	   (#x98ED . #xD2AC)
	   (#x98EE . #xDDBB)
	   (#x98EF . #xC8D3)
	   (#x98F2 . #xB0FB)
	   (#x98F3 . #x8FE8CE)
	   (#x98F4 . #xB0BB)
	   (#x98F6 . #x8FE8CF)
	   (#x98FC . #xBBF4)
	   (#x98FD . #xCBB0)
	   (#x98FE . #xBEFE)
	   (#x9902 . #x8FE8D0)
	   (#x9903 . #xF1AD)
	   (#x9905 . #xCCDF)
	   (#x9907 . #x8FE8D1)
	   (#x9908 . #x8FE8D2)
	   (#x9909 . #xF1AE)
	   (#x990A . #xCDDC)
	   (#x990C . #xB1C2)
	   (#x9910 . #xBBC1)
	   (#x9911 . #x8FE8D3)
	   (#x9912 . #xF1AF)
	   (#x9913 . #xB2EE)
	   (#x9914 . #xF1B0)
	   (#x9915 . #x8FE8D4)
	   (#x9916 . #x8FE8D5)
	   (#x9917 . #x8FE8D6)
	   (#x9918 . #xF1B1)
	   (#x991A . #x8FE8D7)
	   (#x991B . #x8FE8D8)
	   (#x991C . #x8FE8D9)
	   (#x991D . #xF1B3)
	   (#x991E . #xF1B4)
	   (#x991F . #x8FE8DA)
	   (#x9920 . #xF1B6)
	   (#x9921 . #xF1B2)
	   (#x9922 . #x8FE8DB)
	   (#x9924 . #xF1B5)
	   (#x9926 . #x8FE8DC)
	   (#x9927 . #x8FE8DD)
	   (#x9928 . #xB4DB)
	   (#x992B . #x8FE8DE)
	   (#x992C . #xF1B7)
	   (#x992E . #xF1B8)
	   (#x9931 . #x8FE8DF)
	   (#x9932 . #x8FE8E0)
	   (#x9933 . #x8FE8E1)
	   (#x9934 . #x8FE8E2)
	   (#x9935 . #x8FE8E3)
	   (#x9939 . #x8FE8E4)
	   (#x993A . #x8FE8E5)
	   (#x993B . #x8FE8E6)
	   (#x993C . #x8FE8E7)
	   (#x993D . #xF1B9)
	   (#x993E . #xF1BA)
	   (#x9940 . #x8FE8E8)
	   (#x9941 . #x8FE8E9)
	   (#x9942 . #xF1BB)
	   (#x9945 . #xF1BD)
	   (#x9946 . #x8FE8EA)
	   (#x9947 . #x8FE8EB)
	   (#x9948 . #x8FE8EC)
	   (#x9949 . #xF1BC)
	   (#x994B . #xF1BF)
	   (#x994C . #xF1C2)
	   (#x994D . #x8FE8ED)
	   (#x994E . #x8FE8EE)
	   (#x9950 . #xF1BE)
	   (#x9951 . #xF1C0)
	   (#x9952 . #xF1C1)
	   (#x9954 . #x8FE8EF)
	   (#x9955 . #xF1C3)
	   (#x9957 . #xB6C2)
	   (#x9958 . #x8FE8F0)
	   (#x9959 . #x8FE8F1)
	   (#x995B . #x8FE8F2)
	   (#x995C . #x8FE8F3)
	   (#x995E . #x8FE8F4)
	   (#x995F . #x8FE8F5)
	   (#x9960 . #x8FE8F6)
	   (#x9996 . #xBCF3)
	   (#x9997 . #xF1C4)
	   (#x9998 . #xF1C5)
	   (#x9999 . #xB9E1)
	   (#x999B . #x8FE8F7)
	   (#x999D . #x8FE8F8)
	   (#x999F . #x8FE8F9)
	   (#x99A5 . #xF1C6)
	   (#x99A6 . #x8FE8FA)
	   (#x99A8 . #xB3BE)
	   (#x99AC . #xC7CF)
	   (#x99AD . #xF1C7)
	   (#x99AE . #xF1C8)
	   (#x99B0 . #x8FE8FB)
	   (#x99B1 . #x8FE8FC)
	   (#x99B2 . #x8FE8FD)
	   (#x99B3 . #xC3DA)
	   (#x99B4 . #xC6EB)
	   (#x99B5 . #x8FE8FE)
	   (#x99B9 . #x8FE9A1)
	   (#x99BA . #x8FE9A2)
	   (#x99BC . #xF1C9)
	   (#x99BD . #x8FE9A3)
	   (#x99BF . #x8FE9A4)
	   (#x99C1 . #xC7FD)
	   (#x99C3 . #x8FE9A5)
	   (#x99C4 . #xC2CC)
	   (#x99C5 . #xB1D8)
	   (#x99C6 . #xB6EE)
	   (#x99C8 . #xB6EF)
	   (#x99C9 . #x8FE9A6)
	   (#x99D0 . #xC3F3)
	   (#x99D1 . #xF1CE)
	   (#x99D2 . #xB6F0)
	   (#x99D3 . #x8FE9A7)
	   (#x99D4 . #x8FE9A8)
	   (#x99D5 . #xB2EF)
	   (#x99D8 . #xF1CD)
	   (#x99D9 . #x8FE9A9)
	   (#x99DA . #x8FE9AA)
	   (#x99DB . #xF1CB)
	   (#x99DC . #x8FE9AB)
	   (#x99DD . #xF1CC)
	   (#x99DE . #x8FE9AC)
	   (#x99DF . #xF1CA)
	   (#x99E2 . #xF1D8)
	   (#x99E7 . #x8FE9AD)
	   (#x99EA . #x8FE9AE)
	   (#x99EB . #x8FE9AF)
	   (#x99EC . #x8FE9B0)
	   (#x99ED . #xF1CF)
	   (#x99EE . #xF1D0)
	   (#x99F0 . #x8FE9B1)
	   (#x99F1 . #xF1D1)
	   (#x99F2 . #xF1D2)
	   (#x99F4 . #x8FE9B2)
	   (#x99F5 . #x8FE9B3)
	   (#x99F8 . #xF1D4)
	   (#x99F9 . #x8FE9B4)
	   (#x99FB . #xF1D3)
	   (#x99FD . #x8FE9B5)
	   (#x99FE . #x8FE9B6)
	   (#x99FF . #xBDD9)
	   (#x9A01 . #xF1D5)
	   (#x9A02 . #x8FE9B7)
	   (#x9A03 . #x8FE9B8)
	   (#x9A04 . #x8FE9B9)
	   (#x9A05 . #xF1D7)
	   (#x9A0B . #x8FE9BA)
	   (#x9A0C . #x8FE9BB)
	   (#x9A0E . #xB5B3)
	   (#x9A0F . #xF1D6)
	   (#x9A10 . #x8FE9BC)
	   (#x9A11 . #x8FE9BD)
	   (#x9A12 . #xC1FB)
	   (#x9A13 . #xB8B3)
	   (#x9A16 . #x8FE9BE)
	   (#x9A19 . #xF1D9)
	   (#x9A1E . #x8FE9BF)
	   (#x9A20 . #x8FE9C0)
	   (#x9A22 . #x8FE9C1)
	   (#x9A23 . #x8FE9C2)
	   (#x9A24 . #x8FE9C3)
	   (#x9A27 . #x8FE9C4)
	   (#x9A28 . #xC2CD)
	   (#x9A2B . #xF1DA)
	   (#x9A2D . #x8FE9C5)
	   (#x9A2E . #x8FE9C6)
	   (#x9A30 . #xC6AD)
	   (#x9A33 . #x8FE9C7)
	   (#x9A35 . #x8FE9C8)
	   (#x9A36 . #x8FE9C9)
	   (#x9A37 . #xF1DB)
	   (#x9A38 . #x8FE9CA)
	   (#x9A3E . #xF1E0)
	   (#x9A40 . #xF1DE)
	   (#x9A41 . #x8FE9CC)
	   (#x9A42 . #xF1DD)
	   (#x9A43 . #xF1DF)
	   (#x9A44 . #x8FE9CD)
	   (#x9A45 . #xF1DC)
	   (#x9A47 . #x8FE9CB)
	   (#x9A4A . #x8FE9CE)
	   (#x9A4B . #x8FE9CF)
	   (#x9A4C . #x8FE9D0)
	   (#x9A4D . #xF1E2)
	   (#x9A4E . #x8FE9D1)
	   (#x9A51 . #x8FE9D2)
	   (#x9A54 . #x8FE9D3)
	   (#x9A55 . #xF1E1)
	   (#x9A56 . #x8FE9D4)
	   (#x9A57 . #xF1E4)
	   (#x9A5A . #xB6C3)
	   (#x9A5B . #xF1E3)
	   (#x9A5D . #x8FE9D5)
	   (#x9A5F . #xF1E5)
	   (#x9A62 . #xF1E6)
	   (#x9A64 . #xF1E8)
	   (#x9A65 . #xF1E7)
	   (#x9A69 . #xF1E9)
	   (#x9A6A . #xF1EB)
	   (#x9A6B . #xF1EA)
	   (#x9AA8 . #xB9FC)
	   (#x9AAA . #x8FE9D6)
	   (#x9AAC . #x8FE9D7)
	   (#x9AAD . #xF1EC)
	   (#x9AAE . #x8FE9D8)
	   (#x9AAF . #x8FE9D9)
	   (#x9AB0 . #xF1ED)
	   (#x9AB2 . #x8FE9DA)
	   (#x9AB4 . #x8FE9DB)
	   (#x9AB5 . #x8FE9DC)
	   (#x9AB6 . #x8FE9DD)
	   (#x9AB8 . #xB3BC)
	   (#x9AB9 . #x8FE9DE)
	   (#x9ABB . #x8FE9DF)
	   (#x9ABC . #xF1EE)
	   (#x9ABE . #x8FE9E0)
	   (#x9ABF . #x8FE9E1)
	   (#x9AC0 . #xF1EF)
	   (#x9AC1 . #x8FE9E2)
	   (#x9AC3 . #x8FE9E3)
	   (#x9AC4 . #xBFF1)
	   (#x9AC6 . #x8FE9E4)
	   (#x9AC8 . #x8FE9E5)
	   (#x9ACE . #x8FE9E6)
	   (#x9ACF . #xF1F0)
	   (#x9AD0 . #x8FE9E7)
	   (#x9AD1 . #xF1F1)
	   (#x9AD2 . #x8FE9E8)
	   (#x9AD3 . #xF1F2)
	   (#x9AD4 . #xF1F3)
	   (#x9AD5 . #x8FE9E9)
	   (#x9AD6 . #x8FE9EA)
	   (#x9AD7 . #x8FE9EB)
	   (#x9AD8 . #xB9E2)
	   (#x9ADB . #x8FE9EC)
	   (#x9ADC . #x8FE9ED)
	   (#x9ADE . #xF1F4)
	   (#x9ADF . #xF1F5)
	   (#x9AE0 . #x8FE9EE)
	   (#x9AE2 . #xF1F6)
	   (#x9AE3 . #xF1F7)
	   (#x9AE4 . #x8FE9EF)
	   (#x9AE5 . #x8FE9F0)
	   (#x9AE6 . #xF1F8)
	   (#x9AE7 . #x8FE9F1)
	   (#x9AE9 . #x8FE9F2)
	   (#x9AEA . #xC8B1)
	   (#x9AEB . #xF1FA)
	   (#x9AEC . #x8FE9F3)
	   (#x9AED . #xC9A6)
	   (#x9AEE . #xF1FB)
	   (#x9AEF . #xF1F9)
	   (#x9AF1 . #xF1FD)
	   (#x9AF2 . #x8FE9F4)
	   (#x9AF3 . #x8FE9F5)
	   (#x9AF4 . #xF1FC)
	   (#x9AF5 . #x8FE9F6)
	   (#x9AF7 . #xF1FE)
	   (#x9AF9 . #x8FE9F7)
	   (#x9AFA . #x8FE9F8)
	   (#x9AFB . #xF2A1)
	   (#x9AFD . #x8FE9F9)
	   (#x9AFF . #x8FE9FA)
	   (#x9B00 . #x8FE9FB)
	   (#x9B01 . #x8FE9FC)
	   (#x9B02 . #x8FE9FD)
	   (#x9B03 . #x8FE9FE)
	   (#x9B04 . #x8FEAA1)
	   (#x9B05 . #x8FEAA2)
	   (#x9B06 . #xF2A2)
	   (#x9B08 . #x8FEAA3)
	   (#x9B09 . #x8FEAA4)
	   (#x9B0B . #x8FEAA5)
	   (#x9B0C . #x8FEAA6)
	   (#x9B0D . #x8FEAA7)
	   (#x9B0E . #x8FEAA8)
	   (#x9B10 . #x8FEAA9)
	   (#x9B12 . #x8FEAAA)
	   (#x9B16 . #x8FEAAB)
	   (#x9B18 . #xF2A3)
	   (#x9B19 . #x8FEAAC)
	   (#x9B1A . #xF2A4)
	   (#x9B1B . #x8FEAAD)
	   (#x9B1C . #x8FEAAE)
	   (#x9B1F . #xF2A5)
	   (#x9B20 . #x8FEAAF)
	   (#x9B22 . #xF2A6)
	   (#x9B23 . #xF2A7)
	   (#x9B25 . #xF2A8)
	   (#x9B26 . #x8FEAB0)
	   (#x9B27 . #xF2A9)
	   (#x9B28 . #xF2AA)
	   (#x9B29 . #xF2AB)
	   (#x9B2A . #xF2AC)
	   (#x9B2B . #x8FEAB1)
	   (#x9B2D . #x8FEAB2)
	   (#x9B2E . #xF2AD)
	   (#x9B2F . #xF2AE)
	   (#x9B31 . #xDDB5)
	   (#x9B32 . #xF2AF)
	   (#x9B33 . #x8FEAB3)
	   (#x9B34 . #x8FEAB4)
	   (#x9B35 . #x8FEAB5)
	   (#x9B37 . #x8FEAB6)
	   (#x9B39 . #x8FEAB7)
	   (#x9B3A . #x8FEAB8)
	   (#x9B3B . #xE4F8)
	   (#x9B3C . #xB5B4)
	   (#x9B3D . #x8FEAB9)
	   (#x9B41 . #xB3A1)
	   (#x9B42 . #xBAB2)
	   (#x9B43 . #xF2B1)
	   (#x9B44 . #xF2B0)
	   (#x9B45 . #xCCA5)
	   (#x9B48 . #x8FEABA)
	   (#x9B4B . #x8FEABB)
	   (#x9B4C . #x8FEABC)
	   (#x9B4D . #xF2B3)
	   (#x9B4E . #xF2B4)
	   (#x9B4F . #xF2B2)
	   (#x9B51 . #xF2B5)
	   (#x9B54 . #xCBE2)
	   (#x9B55 . #x8FEABD)
	   (#x9B56 . #x8FEABE)
	   (#x9B57 . #x8FEABF)
	   (#x9B58 . #xF2B6)
	   (#x9B5A . #xB5FB)
	   (#x9B5B . #x8FEAC0)
	   (#x9B5E . #x8FEAC1)
	   (#x9B61 . #x8FEAC2)
	   (#x9B63 . #x8FEAC3)
	   (#x9B65 . #x8FEAC4)
	   (#x9B66 . #x8FEAC5)
	   (#x9B68 . #x8FEAC6)
	   (#x9B6A . #x8FEAC7)
	   (#x9B6B . #x8FEAC8)
	   (#x9B6C . #x8FEAC9)
	   (#x9B6D . #x8FEACA)
	   (#x9B6E . #x8FEACB)
	   (#x9B6F . #xCFA5)
	   (#x9B73 . #x8FEACC)
	   (#x9B74 . #xF2B7)
	   (#x9B75 . #x8FEACD)
	   (#x9B77 . #x8FEACE)
	   (#x9B78 . #x8FEACF)
	   (#x9B79 . #x8FEAD0)
	   (#x9B7F . #x8FEAD1)
	   (#x9B80 . #x8FEAD2)
	   (#x9B83 . #xF2B9)
	   (#x9B84 . #x8FEAD3)
	   (#x9B85 . #x8FEAD4)
	   (#x9B86 . #x8FEAD5)
	   (#x9B87 . #x8FEAD6)
	   (#x9B89 . #x8FEAD7)
	   (#x9B8A . #x8FEAD8)
	   (#x9B8B . #x8FEAD9)
	   (#x9B8D . #x8FEADA)
	   (#x9B8E . #xB0BE)
	   (#x9B8F . #x8FEADB)
	   (#x9B90 . #x8FEADC)
	   (#x9B91 . #xF2BA)
	   (#x9B92 . #xCAAB)
	   (#x9B93 . #xF2B8)
	   (#x9B94 . #x8FEADD)
	   (#x9B96 . #xF2BB)
	   (#x9B97 . #xF2BC)
	   (#x9B9A . #x8FEADE)
	   (#x9B9D . #x8FEADF)
	   (#x9B9E . #x8FEAE0)
	   (#x9B9F . #xF2BD)
	   (#x9BA0 . #xF2BE)
	   (#x9BA6 . #x8FEAE1)
	   (#x9BA7 . #x8FEAE2)
	   (#x9BA8 . #xF2BF)
	   (#x9BA9 . #x8FEAE3)
	   (#x9BAA . #xCBEE)
	   (#x9BAB . #xBBAD)
	   (#x9BAC . #x8FEAE4)
	   (#x9BAD . #xBAFA)
	   (#x9BAE . #xC1AF)
	   (#x9BB0 . #x8FEAE5)
	   (#x9BB1 . #x8FEAE6)
	   (#x9BB2 . #x8FEAE7)
	   (#x9BB4 . #xF2C0)
	   (#x9BB7 . #x8FEAE8)
	   (#x9BB8 . #x8FEAE9)
	   (#x9BB9 . #xF2C3)
	   (#x9BBB . #x8FEAEA)
	   (#x9BBC . #x8FEAEB)
	   (#x9BBE . #x8FEAEC)
	   (#x9BBF . #x8FEAED)
	   (#x9BC0 . #xF2C1)
	   (#x9BC1 . #x8FEAEE)
	   (#x9BC6 . #xF2C4)
	   (#x9BC7 . #x8FEAEF)
	   (#x9BC8 . #x8FEAF0)
	   (#x9BC9 . #xB8F1)
	   (#x9BCA . #xF2C2)
	   (#x9BCE . #x8FEAF1)
	   (#x9BCF . #xF2C5)
	   (#x9BD0 . #x8FEAF2)
	   (#x9BD1 . #xF2C6)
	   (#x9BD2 . #xF2C7)
	   (#x9BD4 . #xF2CB)
	   (#x9BD6 . #xBBAA)
	   (#x9BD7 . #x8FEAF3)
	   (#x9BD8 . #x8FEAF4)
	   (#x9BDB . #xC2E4)
	   (#x9BDD . #x8FEAF5)
	   (#x9BDF . #x8FEAF6)
	   (#x9BE1 . #xF2CC)
	   (#x9BE2 . #xF2C9)
	   (#x9BE3 . #xF2C8)
	   (#x9BE4 . #xF2CA)
	   (#x9BE5 . #x8FEAF7)
	   (#x9BE7 . #x8FEAF8)
	   (#x9BE8 . #xB7DF)
	   (#x9BEA . #x8FEAF9)
	   (#x9BEB . #x8FEAFA)
	   (#x9BEF . #x8FEAFB)
	   (#x9BF0 . #xF2D0)
	   (#x9BF1 . #xF2CF)
	   (#x9BF2 . #xF2CE)
	   (#x9BF3 . #x8FEAFC)
	   (#x9BF5 . #xB0B3)
	   (#x9BF7 . #x8FEAFD)
	   (#x9BF8 . #x8FEAFE)
	   (#x9BF9 . #x8FEBA1)
	   (#x9BFA . #x8FEBA2)
	   (#x9BFD . #x8FEBA3)
	   (#x9BFF . #x8FEBA4)
	   (#x9C00 . #x8FEBA5)
	   (#x9C02 . #x8FEBA6)
	   (#x9C04 . #xF2DA)
	   (#x9C06 . #xF2D6)
	   (#x9C08 . #xF2D7)
	   (#x9C09 . #xF2D3)
	   (#x9C0A . #xF2D9)
	   (#x9C0B . #x8FEBA7)
	   (#x9C0C . #xF2D5)
	   (#x9C0D . #xB3E2)
	   (#x9C0F . #x8FEBA8)
	   (#x9C10 . #xCFCC)
	   (#x9C11 . #x8FEBA9)
	   (#x9C12 . #xF2D8)
	   (#x9C13 . #xF2D4)
	   (#x9C14 . #xF2D2)
	   (#x9C15 . #xF2D1)
	   (#x9C16 . #x8FEBAA)
	   (#x9C18 . #x8FEBAB)
	   (#x9C19 . #x8FEBAC)
	   (#x9C1A . #x8FEBAD)
	   (#x9C1B . #xF2DC)
	   (#x9C1C . #x8FEBAE)
	   (#x9C1E . #x8FEBAF)
	   (#x9C21 . #xF2DF)
	   (#x9C22 . #x8FEBB0)
	   (#x9C23 . #x8FEBB1)
	   (#x9C24 . #xF2DE)
	   (#x9C25 . #xF2DD)
	   (#x9C26 . #x8FEBB2)
	   (#x9C27 . #x8FEBB3)
	   (#x9C28 . #x8FEBB4)
	   (#x9C29 . #x8FEBB5)
	   (#x9C2A . #x8FEBB6)
	   (#x9C2D . #xC9C9)
	   (#x9C2E . #xF2DB)
	   (#x9C2F . #xB0F3)
	   (#x9C30 . #xF2E0)
	   (#x9C31 . #x8FEBB7)
	   (#x9C32 . #xF2E2)
	   (#x9C35 . #x8FEBB8)
	   (#x9C36 . #x8FEBB9)
	   (#x9C37 . #x8FEBBA)
	   (#x9C39 . #xB3EF)
	   (#x9C3A . #xF2CD)
	   (#x9C3B . #xB1B7)
	   (#x9C3D . #x8FEBBB)
	   (#x9C3E . #xF2E4)
	   (#x9C41 . #x8FEBBC)
	   (#x9C43 . #x8FEBBD)
	   (#x9C44 . #x8FEBBE)
	   (#x9C45 . #x8FEBBF)
	   (#x9C46 . #xF2E3)
	   (#x9C47 . #xF2E1)
	   (#x9C48 . #xC3AD)
	   (#x9C49 . #x8FEBC0)
	   (#x9C4A . #x8FEBC1)
	   (#x9C4E . #x8FEBC2)
	   (#x9C4F . #x8FEBC3)
	   (#x9C50 . #x8FEBC4)
	   (#x9C52 . #xCBF0)
	   (#x9C53 . #x8FEBC5)
	   (#x9C54 . #x8FEBC6)
	   (#x9C56 . #x8FEBC7)
	   (#x9C57 . #xCEDA)
	   (#x9C58 . #x8FEBC8)
	   (#x9C5A . #xF2E5)
	   (#x9C5B . #x8FEBC9)
	   (#x9C5C . #x8FEBD0)
	   (#x9C5D . #x8FEBCA)
	   (#x9C5E . #x8FEBCB)
	   (#x9C5F . #x8FEBCC)
	   (#x9C60 . #xF2E6)
	   (#x9C63 . #x8FEBCD)
	   (#x9C67 . #xF2E7)
	   (#x9C68 . #x8FEBD2)
	   (#x9C69 . #x8FEBCE)
	   (#x9C6A . #x8FEBCF)
	   (#x9C6B . #x8FEBD1)
	   (#x9C6E . #x8FEBD3)
	   (#x9C70 . #x8FEBD4)
	   (#x9C72 . #x8FEBD5)
	   (#x9C75 . #x8FEBD6)
	   (#x9C76 . #xF2E8)
	   (#x9C77 . #x8FEBD7)
	   (#x9C78 . #xF2E9)
	   (#x9C7B . #x8FEBD8)
	   (#x9CE5 . #xC4BB)
	   (#x9CE6 . #x8FEBD9)
	   (#x9CE7 . #xF2EA)
	   (#x9CE9 . #xC8B7)
	   (#x9CEB . #xF2EF)
	   (#x9CEC . #xF2EB)
	   (#x9CF0 . #xF2EC)
	   (#x9CF2 . #x8FEBDA)
	   (#x9CF3 . #xCBB1)
	   (#x9CF4 . #xCCC4)
	   (#x9CF6 . #xC6D0)
	   (#x9CF7 . #x8FEBDB)
	   (#x9CF9 . #x8FEBDC)
	   (#x9D02 . #x8FEBDE)
	   (#x9D03 . #xF2F0)
	   (#x9D06 . #xF2F1)
	   (#x9D07 . #xC6BE)
	   (#x9D08 . #xF2EE)
	   (#x9D09 . #xF2ED)
	   (#x9D0B . #x8FEBDD)
	   (#x9D0E . #xB2AA)
	   (#x9D11 . #x8FEBDF)
	   (#x9D12 . #xF2F9)
	   (#x9D15 . #xF2F8)
	   (#x9D17 . #x8FEBE0)
	   (#x9D18 . #x8FEBE1)
	   (#x9D1B . #xB1F5)
	   (#x9D1C . #x8FEBE2)
	   (#x9D1D . #x8FEBE3)
	   (#x9D1E . #x8FEBE4)
	   (#x9D1F . #xF2F6)
	   (#x9D23 . #xF2F5)
	   (#x9D26 . #xF2F3)
	   (#x9D28 . #xB3FB)
	   (#x9D2A . #xF2F2)
	   (#x9D2B . #xBCB2)
	   (#x9D2C . #xB2A9)
	   (#x9D2F . #x8FEBE5)
	   (#x9D30 . #x8FEBE6)
	   (#x9D32 . #x8FEBE7)
	   (#x9D33 . #x8FEBE8)
	   (#x9D34 . #x8FEBE9)
	   (#x9D3A . #x8FEBEA)
	   (#x9D3B . #xB9E3)
	   (#x9D3C . #x8FEBEB)
	   (#x9D3D . #x8FEBED)
	   (#x9D3E . #xF2FC)
	   (#x9D3F . #xF2FB)
	   (#x9D41 . #xF2FA)
	   (#x9D42 . #x8FEBEE)
	   (#x9D43 . #x8FEBEF)
	   (#x9D44 . #xF2F7)
	   (#x9D45 . #x8FEBEC)
	   (#x9D46 . #xF2FD)
	   (#x9D47 . #x8FEBF0)
	   (#x9D48 . #xF2FE)
	   (#x9D4A . #x8FEBF1)
	   (#x9D50 . #xF3A5)
	   (#x9D51 . #xF3A4)
	   (#x9D53 . #x8FEBF2)
	   (#x9D54 . #x8FEBF3)
	   (#x9D59 . #xF3A6)
	   (#x9D5C . #xB1AD)
	   (#x9D5D . #xF3A1)
	   (#x9D5E . #xF3A2)
	   (#x9D5F . #x8FEBF4)
	   (#x9D60 . #xB9F4)
	   (#x9D61 . #xCCB9)
	   (#x9D62 . #x8FEBF6)
	   (#x9D63 . #x8FEBF5)
	   (#x9D64 . #xF3A3)
	   (#x9D65 . #x8FEBF7)
	   (#x9D69 . #x8FEBF8)
	   (#x9D6A . #x8FEBF9)
	   (#x9D6B . #x8FEBFA)
	   (#x9D6C . #xCBB2)
	   (#x9D6F . #xF3AB)
	   (#x9D70 . #x8FEBFB)
	   (#x9D72 . #xF3A7)
	   (#x9D76 . #x8FEBFC)
	   (#x9D77 . #x8FEBFD)
	   (#x9D7A . #xF3AC)
	   (#x9D7B . #x8FEBFE)
	   (#x9D7C . #x8FECA1)
	   (#x9D7E . #x8FECA2)
	   (#x9D83 . #x8FECA3)
	   (#x9D84 . #x8FECA4)
	   (#x9D86 . #x8FECA5)
	   (#x9D87 . #xF3A9)
	   (#x9D89 . #xF3A8)
	   (#x9D8A . #x8FECA6)
	   (#x9D8D . #x8FECA7)
	   (#x9D8E . #x8FECA8)
	   (#x9D8F . #xB7DC)
	   (#x9D92 . #x8FECA9)
	   (#x9D93 . #x8FECAA)
	   (#x9D95 . #x8FECAB)
	   (#x9D96 . #x8FECAC)
	   (#x9D97 . #x8FECAD)
	   (#x9D98 . #x8FECAE)
	   (#x9D9A . #xF3AD)
	   (#x9DA1 . #x8FECAF)
	   (#x9DA4 . #xF3AE)
	   (#x9DA9 . #xF3AF)
	   (#x9DAA . #x8FECB0)
	   (#x9DAB . #xF3AA)
	   (#x9DAC . #x8FECB1)
	   (#x9DAE . #x8FECB2)
	   (#x9DAF . #xF2F4)
	   (#x9DB1 . #x8FECB3)
	   (#x9DB2 . #xF3B0)
	   (#x9DB4 . #xC4E1)
	   (#x9DB5 . #x8FECB4)
	   (#x9DB8 . #xF3B4)
	   (#x9DB9 . #x8FECB5)
	   (#x9DBA . #xF3B5)
	   (#x9DBB . #xF3B3)
	   (#x9DBC . #x8FECB6)
	   (#x9DBF . #x8FECB7)
	   (#x9DC1 . #xF3B2)
	   (#x9DC2 . #xF3B8)
	   (#x9DC3 . #x8FECB8)
	   (#x9DC4 . #xF3B1)
	   (#x9DC6 . #xF3B6)
	   (#x9DC7 . #x8FECB9)
	   (#x9DC9 . #x8FECBA)
	   (#x9DCA . #x8FECBB)
	   (#x9DCF . #xF3B7)
	   (#x9DD3 . #xF3BA)
	   (#x9DD4 . #x8FECBC)
	   (#x9DD5 . #x8FECBD)
	   (#x9DD6 . #x8FECBE)
	   (#x9DD7 . #x8FECBF)
	   (#x9DD9 . #xF3B9)
	   (#x9DDA . #x8FECC0)
	   (#x9DDE . #x8FECC1)
	   (#x9DDF . #x8FECC2)
	   (#x9DE0 . #x8FECC3)
	   (#x9DE5 . #x8FECC4)
	   (#x9DE6 . #xF3BC)
	   (#x9DE7 . #x8FECC5)
	   (#x9DE9 . #x8FECC6)
	   (#x9DEB . #x8FECC7)
	   (#x9DED . #xF3BD)
	   (#x9DEE . #x8FECC8)
	   (#x9DEF . #xF3BE)
	   (#x9DF0 . #x8FECC9)
	   (#x9DF2 . #xCFC9)
	   (#x9DF3 . #x8FECCA)
	   (#x9DF4 . #x8FECCB)
	   (#x9DF8 . #xF3BB)
	   (#x9DF9 . #xC2EB)
	   (#x9DFA . #xBAED)
	   (#x9DFD . #xF3BF)
	   (#x9DFE . #x8FECCC)
	   (#x9E02 . #x8FECCE)
	   (#x9E07 . #x8FECCF)
	   (#x9E0A . #x8FECCD)
	   (#x9E0E . #x8FECD0)
	   (#x9E10 . #x8FECD1)
	   (#x9E11 . #x8FECD2)
	   (#x9E12 . #x8FECD3)
	   (#x9E15 . #x8FECD4)
	   (#x9E16 . #x8FECD5)
	   (#x9E19 . #x8FECD6)
	   (#x9E1A . #xF3C0)
	   (#x9E1B . #xF3C1)
	   (#x9E1C . #x8FECD7)
	   (#x9E1D . #x8FECD8)
	   (#x9E1E . #xF3C2)
	   (#x9E75 . #xF3C3)
	   (#x9E78 . #xB8B4)
	   (#x9E79 . #xF3C4)
	   (#x9E7A . #x8FECD9)
	   (#x9E7B . #x8FECDA)
	   (#x9E7C . #x8FECDB)
	   (#x9E7D . #xF3C5)
	   (#x9E7F . #xBCAF)
	   (#x9E80 . #x8FECDC)
	   (#x9E81 . #xF3C6)
	   (#x9E82 . #x8FECDD)
	   (#x9E83 . #x8FECDE)
	   (#x9E84 . #x8FECDF)
	   (#x9E85 . #x8FECE0)
	   (#x9E87 . #x8FECE1)
	   (#x9E88 . #xF3C7)
	   (#x9E8B . #xF3C8)
	   (#x9E8C . #xF3C9)
	   (#x9E8E . #x8FECE2)
	   (#x9E8F . #x8FECE3)
	   (#x9E91 . #xF3CC)
	   (#x9E92 . #xF3CA)
	   (#x9E93 . #xCFBC)
	   (#x9E95 . #xF3CB)
	   (#x9E96 . #x8FECE4)
	   (#x9E97 . #xCEEF)
	   (#x9E98 . #x8FECE5)
	   (#x9E9B . #x8FECE6)
	   (#x9E9D . #xF3CD)
	   (#x9E9E . #x8FECE7)
	   (#x9E9F . #xCEDB)
	   (#x9EA4 . #x8FECE8)
	   (#x9EA5 . #xF3CE)
	   (#x9EA6 . #xC7FE)
	   (#x9EA8 . #x8FECE9)
	   (#x9EA9 . #xF3CF)
	   (#x9EAA . #xF3D1)
	   (#x9EAC . #x8FECEA)
	   (#x9EAD . #xF3D2)
	   (#x9EAE . #x8FECEB)
	   (#x9EAF . #x8FECEC)
	   (#x9EB0 . #x8FECED)
	   (#x9EB3 . #x8FECEE)
	   (#x9EB4 . #x8FECEF)
	   (#x9EB5 . #x8FECF0)
	   (#x9EB8 . #xF3D0)
	   (#x9EB9 . #xB9ED)
	   (#x9EBA . #xCCCD)
	   (#x9EBB . #xCBE3)
	   (#x9EBC . #xD6F7)
	   (#x9EBE . #xDDE0)
	   (#x9EBF . #xCBFB)
	   (#x9EC4 . #xB2AB)
	   (#x9EC6 . #x8FECF1)
	   (#x9EC8 . #x8FECF2)
	   (#x9ECB . #x8FECF3)
	   (#x9ECC . #xF3D4)
	   (#x9ECD . #xB5D0)
	   (#x9ECE . #xF3D5)
	   (#x9ECF . #xF3D6)
	   (#x9ED0 . #xF3D7)
	   (#x9ED2 . #xB9F5)
	   (#x9ED4 . #xF3D8)
	   (#x9ED5 . #x8FECF4)
	   (#x9ED8 . #xE0D4)
	   (#x9ED9 . #xCCDB)
	   (#x9EDB . #xC2E3)
	   (#x9EDC . #xF3D9)
	   (#x9EDD . #xF3DB)
	   (#x9EDE . #xF3DA)
	   (#x9EDF . #x8FECF5)
	   (#x9EE0 . #xF3DC)
	   (#x9EE4 . #x8FECF6)
	   (#x9EE5 . #xF3DD)
	   (#x9EE7 . #x8FECF7)
	   (#x9EE8 . #xF3DE)
	   (#x9EEC . #x8FECF8)
	   (#x9EED . #x8FECF9)
	   (#x9EEE . #x8FECFA)
	   (#x9EEF . #xF3DF)
	   (#x9EF0 . #x8FECFB)
	   (#x9EF1 . #x8FECFC)
	   (#x9EF2 . #x8FECFD)
	   (#x9EF4 . #xF3E0)
	   (#x9EF5 . #x8FECFE)
	   (#x9EF6 . #xF3E1)
	   (#x9EF7 . #xF3E2)
	   (#x9EF8 . #x8FEDA1)
	   (#x9EF9 . #xF3E3)
	   (#x9EFB . #xF3E4)
	   (#x9EFC . #xF3E5)
	   (#x9EFD . #xF3E6)
	   (#x9EFF . #x8FEDA2)
	   (#x9F02 . #x8FEDA3)
	   (#x9F03 . #x8FEDA4)
	   (#x9F07 . #xF3E7)
	   (#x9F08 . #xF3E8)
	   (#x9F09 . #x8FEDA5)
	   (#x9F0E . #xC5A4)
	   (#x9F0F . #x8FEDA6)
	   (#x9F10 . #x8FEDA7)
	   (#x9F11 . #x8FEDA8)
	   (#x9F12 . #x8FEDA9)
	   (#x9F13 . #xB8DD)
	   (#x9F14 . #x8FEDAA)
	   (#x9F15 . #xF3EA)
	   (#x9F16 . #x8FEDAB)
	   (#x9F17 . #x8FEDAC)
	   (#x9F19 . #x8FEDAD)
	   (#x9F1A . #x8FEDAE)
	   (#x9F1B . #x8FEDAF)
	   (#x9F1F . #x8FEDB0)
	   (#x9F20 . #xC1CD)
	   (#x9F21 . #xF3EB)
	   (#x9F22 . #x8FEDB1)
	   (#x9F26 . #x8FEDB2)
	   (#x9F2A . #x8FEDB3)
	   (#x9F2B . #x8FEDB4)
	   (#x9F2C . #xF3EC)
	   (#x9F2F . #x8FEDB5)
	   (#x9F31 . #x8FEDB6)
	   (#x9F32 . #x8FEDB7)
	   (#x9F34 . #x8FEDB8)
	   (#x9F37 . #x8FEDB9)
	   (#x9F39 . #x8FEDBA)
	   (#x9F3A . #x8FEDBB)
	   (#x9F3B . #xC9A1)
	   (#x9F3C . #x8FEDBC)
	   (#x9F3D . #x8FEDBD)
	   (#x9F3E . #xF3ED)
	   (#x9F3F . #x8FEDBE)
	   (#x9F41 . #x8FEDBF)
	   (#x9F43 . #x8FEDC0)
	   (#x9F44 . #x8FEDC1)
	   (#x9F45 . #x8FEDC2)
	   (#x9F46 . #x8FEDC3)
	   (#x9F47 . #x8FEDC4)
	   (#x9F4A . #xF3EE)
	   (#x9F4B . #xE3B7)
	   (#x9F4E . #xECDA)
	   (#x9F4F . #xF0ED)
	   (#x9F52 . #xF3EF)
	   (#x9F53 . #x8FEDC5)
	   (#x9F54 . #xF3F0)
	   (#x9F55 . #x8FEDC6)
	   (#x9F56 . #x8FEDC7)
	   (#x9F57 . #x8FEDC8)
	   (#x9F58 . #x8FEDC9)
	   (#x9F5A . #x8FEDCA)
	   (#x9F5D . #x8FEDCB)
	   (#x9F5E . #x8FEDCC)
	   (#x9F5F . #xF3F2)
	   (#x9F60 . #xF3F3)
	   (#x9F61 . #xF3F4)
	   (#x9F62 . #xCEF0)
	   (#x9F63 . #xF3F1)
	   (#x9F66 . #xF3F5)
	   (#x9F67 . #xF3F6)
	   (#x9F68 . #x8FEDCD)
	   (#x9F69 . #x8FEDCE)
	   (#x9F6A . #xF3F8)
	   (#x9F6C . #xF3F7)
	   (#x9F6D . #x8FEDCF)
	   (#x9F6E . #x8FEDD0)
	   (#x9F6F . #x8FEDD1)
	   (#x9F70 . #x8FEDD2)
	   (#x9F71 . #x8FEDD3)
	   (#x9F72 . #xF3FA)
	   (#x9F73 . #x8FEDD4)
	   (#x9F75 . #x8FEDD5)
	   (#x9F76 . #xF3FB)
	   (#x9F77 . #xF3F9)
	   (#x9F7A . #x8FEDD6)
	   (#x9F7D . #x8FEDD7)
	   (#x9F8D . #xCEB6)
	   (#x9F8F . #x8FEDD8)
	   (#x9F90 . #x8FEDD9)
	   (#x9F91 . #x8FEDDA)
	   (#x9F92 . #x8FEDDB)
	   (#x9F94 . #x8FEDDC)
	   (#x9F95 . #xF3FC)
	   (#x9F96 . #x8FEDDD)
	   (#x9F97 . #x8FEDDE)
	   (#x9F9C . #xF3FD)
	   (#x9F9D . #xE3D4)
	   (#x9F9E . #x8FEDDF)
	   (#x9FA0 . #xF3FE)
	   (#x9FA1 . #x8FEDE0)
	   (#x9FA2 . #x8FEDE1)
	   (#x9FA3 . #x8FEDE2)
	   (#x9FA5 . #x8FEDE3)
	   (#xFF01 . #xA1AA)
	   (#xFF03 . #xA1F4)
	   (#xFF04 . #xA1F0)
	   (#xFF05 . #xA1F3)
	   (#xFF06 . #xA1F5)
	   (#xFF08 . #xA1CA)
	   (#xFF09 . #xA1CB)
	   (#xFF0A . #xA1F6)
	   (#xFF0B . #xA1DC)
	   (#xFF0C . #xA1A4)
	   (#xFF0E . #xA1A5)
	   (#xFF0F . #xA1BF)
	   (#xFF10 . #xA3B0)
	   (#xFF11 . #xA3B1)
	   (#xFF12 . #xA3B2)
	   (#xFF13 . #xA3B3)
	   (#xFF14 . #xA3B4)
	   (#xFF15 . #xA3B5)
	   (#xFF16 . #xA3B6)
	   (#xFF17 . #xA3B7)
	   (#xFF18 . #xA3B8)
	   (#xFF19 . #xA3B9)
	   (#xFF1A . #xA1A7)
	   (#xFF1B . #xA1A8)
	   (#xFF1C . #xA1E3)
	   (#xFF1D . #xA1E1)
	   (#xFF1E . #xA1E4)
	   (#xFF1F . #xA1A9)
	   (#xFF20 . #xA1F7)
	   (#xFF21 . #xA3C1)
	   (#xFF22 . #xA3C2)
	   (#xFF23 . #xA3C3)
	   (#xFF24 . #xA3C4)
	   (#xFF25 . #xA3C5)
	   (#xFF26 . #xA3C6)
	   (#xFF27 . #xA3C7)
	   (#xFF28 . #xA3C8)
	   (#xFF29 . #xA3C9)
	   (#xFF2A . #xA3CA)
	   (#xFF2B . #xA3CB)
	   (#xFF2C . #xA3CC)
	   (#xFF2D . #xA3CD)
	   (#xFF2E . #xA3CE)
	   (#xFF2F . #xA3CF)
	   (#xFF30 . #xA3D0)
	   (#xFF31 . #xA3D1)
	   (#xFF32 . #xA3D2)
	   (#xFF33 . #xA3D3)
	   (#xFF34 . #xA3D4)
	   (#xFF35 . #xA3D5)
	   (#xFF36 . #xA3D6)
	   (#xFF37 . #xA3D7)
	   (#xFF38 . #xA3D8)
	   (#xFF39 . #xA3D9)
	   (#xFF3A . #xA3DA)
	   (#xFF3B . #xA1CE)
	   (#xFF3C . #xA1C0)
	   (#xFF3D . #xA1CF)
	   (#xFF3E . #xA1B0)
	   (#xFF3F . #xA1B2)
	   (#xFF40 . #xA1AE)
	   (#xFF41 . #xA3E1)
	   (#xFF42 . #xA3E2)
	   (#xFF43 . #xA3E3)
	   (#xFF44 . #xA3E4)
	   (#xFF45 . #xA3E5)
	   (#xFF46 . #xA3E6)
	   (#xFF47 . #xA3E7)
	   (#xFF48 . #xA3E8)
	   (#xFF49 . #xA3E9)
	   (#xFF4A . #xA3EA)
	   (#xFF4B . #xA3EB)
	   (#xFF4C . #xA3EC)
	   (#xFF4D . #xA3ED)
	   (#xFF4E . #xA3EE)
	   (#xFF4F . #xA3EF)
	   (#xFF50 . #xA3F0)
	   (#xFF51 . #xA3F1)
	   (#xFF52 . #xA3F2)
	   (#xFF53 . #xA3F3)
	   (#xFF54 . #xA3F4)
	   (#xFF55 . #xA3F5)
	   (#xFF56 . #xA3F6)
	   (#xFF57 . #xA3F7)
	   (#xFF58 . #xA3F8)
	   (#xFF59 . #xA3F9)
	   (#xFF5A . #xA3FA)
	   (#xFF5B . #xA1D0)
	   (#xFF5C . #xA1C3)
	   (#xFF5D . #xA1D1)
	   (#xFF5E . #x8FA2B7)
	   (#xFF61 . #x8EA1)
	   (#xFF62 . #x8EA2)
	   (#xFF63 . #x8EA3)
	   (#xFF64 . #x8EA4)
	   (#xFF65 . #x8EA5)
	   (#xFF66 . #x8EA6)
	   (#xFF67 . #x8EA7)
	   (#xFF68 . #x8EA8)
	   (#xFF69 . #x8EA9)
	   (#xFF6A . #x8EAA)
	   (#xFF6B . #x8EAB)
	   (#xFF6C . #x8EAC)
	   (#xFF6D . #x8EAD)
	   (#xFF6E . #x8EAE)
	   (#xFF6F . #x8EAF)
	   (#xFF70 . #x8EB0)
	   (#xFF71 . #x8EB1)
	   (#xFF72 . #x8EB2)
	   (#xFF73 . #x8EB3)
	   (#xFF74 . #x8EB4)
	   (#xFF75 . #x8EB5)
	   (#xFF76 . #x8EB6)
	   (#xFF77 . #x8EB7)
	   (#xFF78 . #x8EB8)
	   (#xFF79 . #x8EB9)
	   (#xFF7A . #x8EBA)
	   (#xFF7B . #x8EBB)
	   (#xFF7C . #x8EBC)
	   (#xFF7D . #x8EBD)
	   (#xFF7E . #x8EBE)
	   (#xFF7F . #x8EBF)
	   (#xFF80 . #x8EC0)
	   (#xFF81 . #x8EC1)
	   (#xFF82 . #x8EC2)
	   (#xFF83 . #x8EC3)
	   (#xFF84 . #x8EC4)
	   (#xFF85 . #x8EC5)
	   (#xFF86 . #x8EC6)
	   (#xFF87 . #x8EC7)
	   (#xFF88 . #x8EC8)
	   (#xFF89 . #x8EC9)
	   (#xFF8A . #x8ECA)
	   (#xFF8B . #x8ECB)
	   (#xFF8C . #x8ECC)
	   (#xFF8D . #x8ECD)
	   (#xFF8E . #x8ECE)
	   (#xFF8F . #x8ECF)
	   (#xFF90 . #x8ED0)
	   (#xFF91 . #x8ED1)
	   (#xFF92 . #x8ED2)
	   (#xFF93 . #x8ED3)
	   (#xFF94 . #x8ED4)
	   (#xFF95 . #x8ED5)
	   (#xFF96 . #x8ED6)
	   (#xFF97 . #x8ED7)
	   (#xFF98 . #x8ED8)
	   (#xFF99 . #x8ED9)
	   (#xFF9A . #x8EDA)
	   (#xFF9B . #x8EDB)
	   (#xFF9C . #x8EDC)
	   (#xFF9D . #x8EDD)
	   (#xFF9E . #x8EDE)
	   (#xFF9F . #x8EDF)))
	(ucs->eucjp		; mono-directional table UCS -> EUC-JP
	 ;; some implementations convert EUC-JP into other UCS code point.
	 ;; <http://www.y-adagio.com/public/standards/tr_xml_jpf/kaisetsu.htm>
	 '((#x2015 . #xA1BD)
	   (#x2225 . #xA1C2)
	   (#xFF0D . #xA1DD)
	   (#xFFE0 . #xA1F1)
	   (#xFFE1 . #xA1F2)
	   (#xFFE2 . #xA2CC)
	   (#xFFE3 . #xA1B1)
	   (#xFFE4 . #x8FA2C3)
	   (#xFFE5 . #xA1EF))))
    (dotimes (i 128)
      (setf (gethash i ucs-to-eucjp-table) i)
      (setf (gethash i eucjp-to-ucs-table) i))
    (dolist (pair ucs<->eucjp)
      (when (gethash (car pair) ucs-to-eucjp-table)
	(error "duplicated ucs: ~X" (car pair)))
      (when (gethash (cdr pair) eucjp-to-ucs-table)
	(error "duplicated eucjp: ~X" (car pair)))
      (setf (gethash (car pair) ucs-to-eucjp-table) (cdr pair))
      (setf (gethash (cdr pair) eucjp-to-ucs-table) (car pair)))
    (dolist (pair ucs->eucjp)
      (when (gethash (car pair) ucs-to-eucjp-table)
	(error "duplicated ucs: ~X" (car pair)))
      (setf (gethash (car pair) ucs-to-eucjp-table) (cdr pair))))
  (defun ucs-to-eucjp (code)
    (declare (optimize speed (safety 0))
	     (type fixnum code))
    (gethash code ucs-to-eucjp-table))
  (defun eucjp-to-ucs (code)
    (declare (optimize speed (safety 0))
	     (type fixnum code))
    (gethash code eucjp-to-ucs-table)))

;;; for fd-stream.lisp
(define-external-format/variable-width (:euc-jp :eucjp :|eucJP|) t
  (let ((euc (ucs-to-eucjp (char-code byte))))
    (if euc
	(cond ((< euc #x100) 1)
	      ((< euc #x10000) 2)
	      ((< euc #x1000000) 3))
	;; FIXME: no error handler in upstream?
	1))
  (let ((euc (ucs-to-eucjp bits)))
    (if (null euc)
	(stream-encoding-error-and-handle stream byte)
	(ecase size
	  (1 (setf (sap-ref-8 sap tail) euc))
	  (2 (setf (sap-ref-8 sap tail) (ldb (byte 8 8) euc)
		   (sap-ref-8 sap (1+ tail)) (ldb (byte 8 0) euc)))
	  (3 (setf (sap-ref-8 sap tail) (ldb (byte 8 16) euc)
		   (sap-ref-8 sap (1+ tail)) (ldb (byte 8 8) euc)
		   (sap-ref-8 sap (+ 2 tail)) (ldb (byte 8 0) euc))))))
  (cond ((< byte #x80) 1)
	((or (= byte #x8E) (<= #xA1 byte #xFE)) 2)
	((= byte #x8F) 3))
  (let* ((euc (ecase size
		(1 byte)
		(2 (let ((byte2 (sap-ref-8 sap (1+ head))))
		     (unless (<= #xA1 byte2 #xFE)
		       (return-from decode-break-reason 2))
		     (dpb byte (byte 8 8) byte2)))
		(3 (let ((byte2 (sap-ref-8 sap (1+ head)))
			 (byte3 (sap-ref-8 sap (+ 2 head))))
		     (unless (and (<= #xA1 byte2 #xFE)
				  (<= #xA1 byte2 #xFE))
		       (return-from decode-break-reason 3))
		     (dpb byte (byte 8 16) (dpb byte2 (byte 8 8) byte3))))))
	 (ucs (eucjp-to-ucs euc)))
    (if (null ucs)
	(return-from decode-break-reason 3)
	(code-char ucs))))

;;; for octets.lisp
(define-condition malformed-eucjp (octet-decoding-error) ())
(define-condition invalid-eucjp-starter-byte (octet-decoding-error) ())
(define-condition invalid-eucjp-continuation-byte (octet-decoding-error) ())

(declaim (inline char-len-as-eucjp))
(defun char-len-as-eucjp (code)
  (declare (optimize speed (safety 0))
	   (type fixnum code))
  (cond ((< code 0) (bug "can't happen"))
	((< code #x100) 1)
	((< code #x10000) 2)
	((< code #x1000000) 3)
	(t (bug "can't happen"))))

(declaim (inline char->eucjp))
(defun char->eucjp (char dest string pos)
  (declare (optimize speed (safety 0))
	   (type (array (unsigned-byte 8) (*)) dest))
  (let ((code (ucs-to-eucjp (char-code char))))
    (if code
	(flet ((add-byte (b)
		 (declare (type (unsigned-byte 8) b))
		 (vector-push-extend b dest)))
	  (declare (inline add-byte))
	  (setf code (the fixnum code))
	  (ecase (char-len-as-eucjp code)
	    (1
	     (add-byte code))
	    (2
	     (add-byte (ldb (byte 8 8) code))
	     (add-byte (ldb (byte 8 0) code)))
	    (3
	     (add-byte (ldb (byte 8 16) code))
	     (add-byte (ldb (byte 8 8) code))
	     (add-byte (ldb (byte 8 0) code)))))
	(encoding-error :euc-jp string pos))))

(defun string->eucjp (string sstart send additional-space)
  (declare (optimize speed (safety 0))
	   (type simple-string string)
	   (type array-range sstart send additional-space))
  (let ((array (make-array (+ additional-space (- send sstart))
			   :element-type '(unsigned-byte 8)
			   :adjustable t
			   :fill-pointer 0)))
    (loop for i from sstart below send
	  do (char->eucjp (char string i) array string i))
    (dotimes (i additional-space)
      (vector-push-extend 0 array))
    (coerce array '(simple-array (unsigned-byte 8) (*)))))

(defmacro define-bytes-per-eucjp-character (accessor type)
  (let ((name (make-od-name 'bytes-per-eucjp-character accessor)))
    `(progn
      ;;(declaim (inline ,name))
      (defun ,name (array pos end)
	(declare (optimize speed (safety 0))
		 (type ,type array)
		 (type array-range pos end))
	;; returns the number of bytes consumed and nil if it's a
	;; valid character or the number of bytes consumed and a
	;; replacement string if it's not.
	(let ((initial-byte (,accessor array pos))
	      (reject-reason nil)
	      (reject-position pos)
	      (remaining-bytes (- end pos)))
	  (declare (type array-range reject-position remaining-bytes))
	  (labels ((valid-eucjp-starter-byte-p (b)
		     (declare (type (unsigned-byte 8) b))
		     (let ((ok (cond ((< b #x80) 1)
				     ((or (= b #x8E) (<= #xA1 b #xFE)) 2)
				     ((= b #x8F) 3))))
		       (unless ok
			 (setf reject-reason 'invalid-eucjp-starter-byte))
		       ok))
		   (enough-bytes-left-p (x)
		     (let ((ok (> end (+ pos (1- x)))))
		       (unless ok
			 (setf reject-reason 'end-of-input-in-character))
		       ok))
		   (valid-secondary-p (x)
		     (let* ((idx (the array-range (+ pos x)))
			    (b (,accessor array idx))
			    (ok (<= #xA1 b #xFE)))
		       (unless ok
			 (setf reject-reason 'invalid-eucjp-continuation-byte)
			 (setf reject-position idx))
		       ok))
		   (preliminary-ok-for-length (maybe-len len)
		     (and (eql maybe-len len)
			  ;; Has to be done in this order so that
			  ;; certain broken sequences (e.g., the
			  ;; two-byte sequence `"initial (length 3)"
			  ;; "non-continuation"' -- `#xef #x32')
			  ;; signal only part of that sequence as
			  ;; erronous.
			  (loop for i from 1 below (min len remaining-bytes)
				always (valid-secondary-p i))
			  (enough-bytes-left-p len))))
	    (declare (inline valid-eucjp-starter-byte-p
			     enough-bytes-left-p
			     valid-secondary-p
			     preliminary-ok-for-length))
	    (let ((maybe-len (valid-eucjp-starter-byte-p initial-byte)))
	      (cond ((eql maybe-len 1)
		     (values 1 nil))
		    ((preliminary-ok-for-length maybe-len 2)
		     (values 2 nil))
		    ((preliminary-ok-for-length maybe-len 3)
		     (values 3 nil))
		    (t
		     (let* ((bad-end (ecase reject-reason
				       (invalid-eucjp-starter-byte
					(1+ pos))
				       (end-of-input-in-character
					end)
				       (invalid-eucjp-continuation-byte
					reject-position)))
			    (bad-len (- bad-end pos)))
		       (declare (type array-range bad-end bad-len))
		       (let ((replacement (decoding-error array pos bad-end :euc-jp reject-reason reject-position)))
			 (values bad-len replacement))))))))))))
(instantiate-octets-definition define-bytes-per-eucjp-character)

(defmacro define-simple-get-eucjp-char (accessor type)
  (let ((name (make-od-name 'simple-get-eucjp-char accessor)))
    `(progn
      (declaim (inline ,name))
      (defun ,name (array pos bytes)
	(declare (optimize speed (safety 0))
		 (type ,type array)
		 (type array-range pos)
		 (type (integer 1 3) bytes))
	(flet ((cref (x)
		 (,accessor array (the array-range (+ pos x)))))
	  (declare (inline cref))
	  (let ((code (eucjp-to-ucs (ecase bytes
				      (1 (cref 0))
				      (2 (logior (ash (cref 0) 8) (cref 1)))
				      (3 (logior (ash (cref 0) 16)
						 (ash (cref 1) 8)
						 (cref 2)))))))
	    (if code
		(code-char code)
		(decoding-error array pos (+ pos bytes) :euc-jp
				'malformed-eucjp pos))))))))
(instantiate-octets-definition define-simple-get-eucjp-char)

(defmacro define-eucjp->string (accessor type)
  (let ((name (make-od-name 'eucjp->string accessor)))
    `(progn
      (defun ,name (array astart aend)
	(declare (optimize speed (safety 0))
		 (type ,type array)
		 (type array-range astart aend))
	(let ((string (make-array 0 :adjustable t :fill-pointer 0 :element-type 'character)))
	  (loop with pos = astart
		while (< pos aend)
		do (multiple-value-bind (bytes invalid)
		       (,(make-od-name 'bytes-per-eucjp-character accessor) array pos aend)
		     (declare (type (or null string) invalid))
		     (cond
		       ((null invalid)
			(vector-push-extend (,(make-od-name 'simple-get-eucjp-char accessor) array pos bytes) string))
		       (t
			(dotimes (i (length invalid))
			  (vector-push-extend (char invalid i) string))))
		     (incf pos bytes)))
	  (coerce string 'simple-string))))))
(instantiate-octets-definition define-eucjp->string)

(push '((:euc-jp :eucjp :|eucJP|)
	eucjp->string-aref string->eucjp)
      *external-format-functions*)
