/*
 * CimWinHttp.h
 *
 * (C) Copyright IBM Corp. 2004
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 *
 * Author:       Adrian Schuur <schuur@de.ibm.com>
 * Contributors: Viktor Mihajlovski <mihajlov@de.ibm.com>
 *               Markus Mueller <markus_mueller@de.ibm.com>
 *               Steve Shepherd <steve.shepherd@configuresoft.com>
 *               Heidi Neumann  <heidineu@de.ibm.com>
 *
 * Description: Line command interface to DMTF conforming WBEM servers
*/


#ifndef CIMWINHTTP_H
#define CIMWINHTTP_H

#include <winhttp.h>
#include "CimXml.h"


class CimomWinHttp : public Cimom
{
  private:
   virtual void addPayload(char *pl);

   virtual void genRequest(URL &url, char *op, bool cls=false, bool keys=false);
   virtual void addPayload(LPCVOID lpPayload, DWORD dwSIze);
   virtual string getResponse();

  public:
   CimomWinHttp::CimomWinHttp();
   CimomWinHttp::~CimomWinHttp();

   // Timeouts are in milli-seconds (these are the defaults)
   virtual bool SetTimeouts(int Connect = 60000,
							int Send = 30000,
							int Receive = 30000);

   void setClientCertificates(const char * cacert,
			      int noverify,
			      const char * clientcert,
			      const char * clientkey);
  private:
	HINTERNET			m_hSession;
	HINTERNET			m_hConnect;
	HINTERNET			m_hRequest;
	LPVOID				m_lpPayload;
	DWORD				m_dwPayloadSize;

};

#endif	/* CIMWINHTTP_H */
