/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

class RecordEnumerationImpl
implements RecordEnumeration,
RecordListener {
    private RecordStore recordStore;
    private RecordFilter filter;
    private RecordComparator comparator;
    private boolean beObserver;
    private int index;
    private int[] records;
    private static final int NO_SUCH_RECORD = -1;

    private RecordEnumerationImpl() {
    }

    RecordEnumerationImpl(RecordStore recordStore, RecordFilter filter, RecordComparator comparator, boolean keepUpdated) {
        this.recordStore = recordStore;
        this.filter = filter;
        this.comparator = comparator;
        this.records = new int[0];
        this.keepUpdated(keepUpdated);
        if (!keepUpdated) {
            this.rebuild();
        }
    }

    public synchronized int numRecords() {
        this.checkDestroyed();
        return this.records.length;
    }

    public synchronized byte[] nextRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        this.checkDestroyed();
        return this.recordStore.getRecord(this.nextRecordId());
    }

    public synchronized int nextRecordId() throws InvalidRecordIDException {
        this.checkDestroyed();
        if (this.index == this.records.length - 1) {
            throw new InvalidRecordIDException();
        }
        this.index = this.index == -1 ? 0 : ++this.index;
        return this.records[this.index];
    }

    public synchronized byte[] previousRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        this.checkDestroyed();
        return this.recordStore.getRecord(this.previousRecordId());
    }

    public synchronized int previousRecordId() throws InvalidRecordIDException {
        this.checkDestroyed();
        if (this.index == 0 || this.records.length == 0) {
            throw new InvalidRecordIDException();
        }
        this.index = this.index == -1 ? this.records.length - 1 : --this.index;
        return this.records[this.index];
    }

    public boolean hasNextElement() {
        this.checkDestroyed();
        return this.index != this.records.length - 1;
    }

    public boolean hasPreviousElement() {
        this.checkDestroyed();
        if (this.records.length == 0) {
            return false;
        }
        return this.index != 0;
    }

    public void reset() {
        this.checkDestroyed();
        this.index = -1;
    }

    public void rebuild() {
        this.checkDestroyed();
        Object object = this.recordStore.rsLock;
        synchronized (object) {
            int[] tmp = this.recordStore.getRecordIDs();
            this.reFilterSort(tmp);
        }
    }

    public void keepUpdated(boolean keepUpdated) {
        this.checkDestroyed();
        if (keepUpdated != this.beObserver) {
            this.beObserver = keepUpdated;
            if (keepUpdated) {
                this.recordStore.addRecordListener(this);
                this.rebuild();
            } else {
                this.recordStore.removeRecordListener(this);
            }
        }
    }

    public boolean isKeptUpdated() {
        this.checkDestroyed();
        return this.beObserver;
    }

    public synchronized void recordAdded(RecordStore recordStore, int recordId) {
        this.checkDestroyed();
        Object object = recordStore.rsLock;
        synchronized (object) {
            this.filterAdd(recordId);
        }
    }

    public synchronized void recordChanged(RecordStore recordStore, int recordId) {
        this.checkDestroyed();
        int recIndex = this.findIndexOfRecord(recordId);
        if (recIndex < 0) {
            return;
        }
        this.removeRecordAtIndex(recIndex);
        Object object = recordStore.rsLock;
        synchronized (object) {
            this.filterAdd(recordId);
        }
    }

    public synchronized void recordDeleted(RecordStore recordStore, int recordId) {
        this.checkDestroyed();
        int recIndex = this.findIndexOfRecord(recordId);
        if (recIndex < 0) {
            return;
        }
        this.removeRecordAtIndex(recIndex);
    }

    public synchronized void destroy() {
        this.checkDestroyed();
        if (this.beObserver) {
            this.recordStore.removeRecordListener(this);
        }
        this.filter = null;
        this.comparator = null;
        this.records = null;
        this.recordStore = null;
    }

    private void checkDestroyed() {
        if (this.recordStore == null) {
            throw new IllegalStateException();
        }
    }

    private void filterAdd(int recordId) {
        int insertPoint = -1;
        if (this.filter != null) {
            try {
                if (!this.filter.matches(this.recordStore.getRecord(recordId))) {
                    return;
                }
            }
            catch (RecordStoreException rse) {
                return;
            }
        }
        int[] newrecs = new int[this.records.length + 1];
        newrecs[0] = recordId;
        System.arraycopy(this.records, 0, newrecs, 1, this.records.length);
        this.records = newrecs;
        if (this.comparator != null) {
            try {
                insertPoint = this.sortInsert();
            }
            catch (RecordStoreException rse) {
                System.out.println("Unexpected exception in filterAdd");
            }
        }
        if (this.index != -1 && insertPoint != -1 && insertPoint < this.index) {
            ++this.index;
        }
    }

    private int sortInsert() throws RecordStoreException {
        int i = 0;
        int j = 1;
        while (i < this.records.length - 1) {
            if (this.comparator.compare(this.recordStore.getRecord(this.records[i]), this.recordStore.getRecord(this.records[j])) != 1) break;
            int tmp = this.records[i];
            this.records[i] = this.records[j];
            this.records[j] = tmp;
            ++i;
            ++j;
        }
        return i;
    }

    private int findIndexOfRecord(int recordId) {
        int recIndex = -1;
        int idx = this.records.length - 1;
        while (idx >= 0) {
            if (this.records[idx] == recordId) {
                recIndex = idx;
                break;
            }
            --idx;
        }
        return recIndex;
    }

    private void removeRecordAtIndex(int recIndex) {
        int[] tmp = new int[this.records.length - 1];
        if (recIndex < this.records.length) {
            System.arraycopy(this.records, 0, tmp, 0, recIndex);
            System.arraycopy(this.records, recIndex + 1, tmp, recIndex, this.records.length - recIndex - 1);
        } else {
            System.arraycopy(this.records, 0, tmp, 0, this.records.length - 1);
        }
        this.records = tmp;
        if (this.index != -1 && recIndex < this.index) {
            --this.index;
        } else if (this.index == this.records.length) {
            --this.index;
        }
    }

    private void reFilterSort(int[] filtered) {
        int filteredIndex = 0;
        if (this.filter == null) {
            this.records = filtered;
        } else {
            int i = 0;
            while (i < filtered.length) {
                try {
                    if (this.filter.matches(this.recordStore.getRecord(filtered[i]))) {
                        if (filteredIndex != i) {
                            filtered[filteredIndex++] = filtered[i];
                        } else {
                            ++filteredIndex;
                        }
                    }
                }
                catch (RecordStoreException rse) {
                    // empty catch block
                }
                ++i;
            }
            this.records = new int[filteredIndex];
            System.arraycopy(filtered, 0, this.records, 0, filteredIndex);
        }
        if (this.comparator != null) {
            try {
                this.QuickSort(this.records, 0, this.records.length - 1, this.comparator);
            }
            catch (RecordStoreException de) {
                System.out.println("Unexpected exception in reFilterSort");
            }
        }
        this.reset();
    }

    /*
     * Unable to fully structure code
     */
    private void QuickSort(int[] a, int lowIndex, int highIndex, RecordComparator comparator) throws RecordStoreException {
        block5: {
            left = lowIndex;
            right = highIndex;
            if (highIndex <= lowIndex) break block5;
            ind = (lowIndex + highIndex) / 2;
            pivotIndex = a[ind];
            pivotData = this.recordStore.getRecord(pivotIndex);
            ** GOTO lbl20
            {
                ++left;
                do {
                    if (left < highIndex && comparator.compare(this.recordStore.getRecord(a[left]), pivotData) == -1) continue block0;
                    while (right > lowIndex && comparator.compare(this.recordStore.getRecord(a[right]), pivotData) == 1) {
                        --right;
                    }
                    if (left > right) continue;
                    tmp = a[left];
                    a[left] = a[right];
                    a[right] = tmp;
                    ++left;
                    --right;
lbl20:
                    // 3 sources

                } while (left <= right);
            }
            if (lowIndex < right) {
                this.QuickSort(a, lowIndex, right, comparator);
            }
            if (left < highIndex) {
                this.QuickSort(a, left, highIndex, comparator);
            }
        }
    }
}

