/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.midp.io.Properties;
import com.sun.midp.midletsuite.InvalidJadException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JadProperties
extends Properties {
    protected static final int HT = 9;
    protected static final int LF = 10;
    protected static final int CR = 13;
    protected static final int EOF = 26;
    protected static final int SP = 32;
    protected char[] lineBuffer = null;

    public synchronized void load(InputStream inStream, String enc) throws IOException, InvalidJadException {
        this.partialLoad(inStream, enc, Integer.MAX_VALUE);
    }

    public void partialLoad(InputStream inStream, String enc, int propertiesToLoad) throws IOException, InvalidJadException {
        String key = null;
        String value = null;
        InvalidJadException jadException = null;
        InputStreamReader in = enc == null ? new InputStreamReader(inStream, "UTF-8") : new InputStreamReader(inStream, enc);
        this.lineBuffer = new char[512];
        int i = 0;
        while (i < propertiesToLoad) {
            String line = this.readLine(in);
            if (line == null) break;
            if (line.length() != 0) {
                int endOfKey = line.indexOf(":");
                if (endOfKey == -1) {
                    jadException = new InvalidJadException(28);
                } else {
                    key = line.substring(0, endOfKey);
                    if (key == null) {
                        jadException = new InvalidJadException(28);
                    } else {
                        if (key.indexOf(32) != -1 || key.indexOf(9) != -1) {
                            throw new InvalidJadException(28);
                        }
                        int startOfValue = endOfKey + 1;
                        value = line.substring(startOfValue, line.length());
                        if ((value = value.trim()) == null) {
                            jadException = new InvalidJadException(29);
                        } else {
                            this.setProperty(key, value);
                        }
                    }
                }
            }
            ++i;
        }
        this.lineBuffer = null;
        if (jadException != null) {
            throw jadException;
        }
    }

    public synchronized void load(InputStream inStream) throws IOException, InvalidJadException {
        this.load(inStream, null);
    }

    protected String readLine(Reader in) throws IOException {
        int offset = 0;
        int c = 0;
        int room = this.lineBuffer.length;
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13 || c == 26) continue;
            if (--room < 0) {
                char[] temp = new char[offset + 128];
                room = temp.length - offset - 1;
                System.arraycopy(this.lineBuffer, 0, temp, 0, offset);
                this.lineBuffer = temp;
            }
            this.lineBuffer[offset++] = (char)c;
        }
        if (c == -1 && offset <= 0) {
            return null;
        }
        return new String(this.lineBuffer, 0, offset);
    }
}

