/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2010-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  Copyright (c) 2003-2008                                                **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/**
 * @file  epk_fmpiwrap_coll.c
 *
 * @brief Fortran interface wrappers for collective communication
 */

#include <stdlib.h>
#include <mpi.h>

#include "elg_error.h"
#include "elg_fmpi_defs.h"
#include "epk_fmpiwrap.h"
#include "epk_defs_mpi.h"
#include "epk_fwrapper_def.h"

/* uppercase defines */
/** All uppercase name of MPI_Allgather */
#define MPI_Allgather_U MPI_ALLGATHER
/** All uppercase name of MPI_Allgatherv */
#define MPI_Allgatherv_U MPI_ALLGATHERV
/** All uppercase name of MPI_Allreduce */
#define MPI_Allreduce_U MPI_ALLREDUCE
/** All uppercase name of MPI_Alltoall */
#define MPI_Alltoall_U MPI_ALLTOALL
/** All uppercase name of MPI_Alltoallv */
#define MPI_Alltoallv_U MPI_ALLTOALLV
/** All uppercase name of MPI_Alltoallw */
#define MPI_Alltoallw_U MPI_ALLTOALLW
/** All uppercase name of MPI_Barrier */
#define MPI_Barrier_U MPI_BARRIER
/** All uppercase name of MPI_Bcast */
#define MPI_Bcast_U MPI_BCAST
/** All uppercase name of MPI_Exscan */
#define MPI_Exscan_U MPI_EXSCAN
/** All uppercase name of MPI_Gather */
#define MPI_Gather_U MPI_GATHER
/** All uppercase name of MPI_Gatherv */
#define MPI_Gatherv_U MPI_GATHERV
/** All uppercase name of MPI_Reduce */
#define MPI_Reduce_U MPI_REDUCE
/** All uppercase name of MPI_Reduce_local */
#define MPI_Reduce_local_U MPI_REDUCE_LOCAL
/** All uppercase name of MPI_Reduce_scatter */
#define MPI_Reduce_scatter_U MPI_REDUCE_SCATTER
/** All uppercase name of MPI_Reduce_scatter_block */
#define MPI_Reduce_scatter_block_U MPI_REDUCE_SCATTER_BLOCK
/** All uppercase name of MPI_Scan */
#define MPI_Scan_U MPI_SCAN
/** All uppercase name of MPI_Scatter */
#define MPI_Scatter_U MPI_SCATTER
/** All uppercase name of MPI_Scatterv */
#define MPI_Scatterv_U MPI_SCATTERV

/* lowercase defines */
/** All lowercase name of MPI_Allgather */
#define MPI_Allgather_L mpi_allgather
/** All lowercase name of MPI_Allgatherv */
#define MPI_Allgatherv_L mpi_allgatherv
/** All lowercase name of MPI_Allreduce */
#define MPI_Allreduce_L mpi_allreduce
/** All lowercase name of MPI_Alltoall */
#define MPI_Alltoall_L mpi_alltoall
/** All lowercase name of MPI_Alltoallv */
#define MPI_Alltoallv_L mpi_alltoallv
/** All lowercase name of MPI_Alltoallw */
#define MPI_Alltoallw_L mpi_alltoallw
/** All lowercase name of MPI_Barrier */
#define MPI_Barrier_L mpi_barrier
/** All lowercase name of MPI_Bcast */
#define MPI_Bcast_L mpi_bcast
/** All lowercase name of MPI_Exscan */
#define MPI_Exscan_L mpi_exscan
/** All lowercase name of MPI_Gather */
#define MPI_Gather_L mpi_gather
/** All lowercase name of MPI_Gatherv */
#define MPI_Gatherv_L mpi_gatherv
/** All lowercase name of MPI_Reduce */
#define MPI_Reduce_L mpi_reduce
/** All lowercase name of MPI_Reduce_local */
#define MPI_Reduce_local_L mpi_reduce_local
/** All lowercase name of MPI_Reduce_scatter */
#define MPI_Reduce_scatter_L mpi_reduce_scatter
/** All lowercase name of MPI_Reduce_scatter_block */
#define MPI_Reduce_scatter_block_L mpi_reduce_scatter_block
/** All lowercase name of MPI_Scan */
#define MPI_Scan_L mpi_scan
/** All lowercase name of MPI_Scatter */
#define MPI_Scatter_L mpi_scatter
/** All lowercase name of MPI_Scatterv */
#define MPI_Scatterv_L mpi_scatterv

/**
 * @name Fortran wrappers
 * @{
 */

#ifndef NEED_F2C_CONV

/* If MPI_Comm_f2c is defined as a simple macro (which typically does nothing)
 * as it would require a "real" function if it is really needed
 * => we can save the f2c and c2s conversions */

#if defined(HAS_MPI_ALLGATHER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Allgather
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Allgather)(void*         sendbuf,
                         int*          sendcount,
                         MPI_Datatype* sendtype,
                         void*         recvbuf,
                         int*          recvcount,
                         MPI_Datatype* recvtype,
                         MPI_Comm*     comm,
                         int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Allgather(sendbuf,
                        *sendcount,
                        *sendtype,
                        recvbuf,
                        *recvcount,
                        *recvtype,
                        *comm);
}

#endif
#if defined(HAS_MPI_ALLGATHERV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Allgatherv
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Allgatherv)(void*         sendbuf,
                          int*          sendcount,
                          MPI_Datatype* sendtype,
                          void*         recvbuf,
                          int*          recvcounts,
                          int*          displs,
                          MPI_Datatype* recvtype,
                          MPI_Comm*     comm,
                          int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Allgatherv(sendbuf,
                         *sendcount,
                         *sendtype,
                         recvbuf,
                         recvcounts,
                         displs,
                         *recvtype,
                         *comm);
}

#endif
#if defined(HAS_MPI_ALLREDUCE) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Allreduce
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Allreduce)(void*         sendbuf,
                         void*         recvbuf,
                         int*          count,
                         MPI_Datatype* datatype,
                         MPI_Op*       op,
                         MPI_Comm*     comm,
                         int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Allreduce(sendbuf, recvbuf, *count, *datatype, *op, *comm);
}

#endif
#if defined(HAS_MPI_ALLTOALL) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Alltoall
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Alltoall)(void*         sendbuf,
                        int*          sendcount,
                        MPI_Datatype* sendtype,
                        void*         recvbuf,
                        int*          recvcount,
                        MPI_Datatype* recvtype,
                        MPI_Comm*     comm,
                        int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Alltoall(sendbuf,
                       *sendcount,
                       *sendtype,
                       recvbuf,
                       *recvcount,
                       *recvtype,
                       *comm);
}

#endif
#if defined(HAS_MPI_ALLTOALLV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Alltoallv
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Alltoallv)(void*         sendbuf,
                         int*          sendcounts,
                         int*          sdispls,
                         MPI_Datatype* sendtype,
                         void*         recvbuf,
                         int*          recvcounts,
                         int*          rdispls,
                         MPI_Datatype* recvtype,
                         MPI_Comm*     comm,
                         int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Alltoallv(sendbuf,
                        sendcounts,
                        sdispls,
                        *sendtype,
                        recvbuf,
                        recvcounts,
                        rdispls,
                        *recvtype,
                        *comm);
}

#endif
#if defined(HAS_MPI_ALLTOALLW) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Alltoallw
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 2.0
 * @ingroup coll
 */
void FSUB(MPI_Alltoallw)(void*        sendbuf,
                         int          sendcounts[],
                         int          sdispls[],
                         MPI_Datatype sendtypes[],
                         void*        recvbuf,
                         int          recvcounts[],
                         int          rdispls[],
                         MPI_Datatype recvtypes[],
                         MPI_Comm*    comm,
                         int*         ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Alltoallw(sendbuf,
                        sendcounts,
                        sdispls,
                        sendtypes,
                        recvbuf,
                        recvcounts,
                        rdispls,
                        recvtypes,
                        *comm);
}

#endif
#if defined(HAS_MPI_BARRIER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Barrier
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Barrier)(MPI_Comm* comm,
                       int*      ierr)
{
  *ierr = MPI_Barrier(*comm);
}

#endif
#if defined(HAS_MPI_BCAST) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Bcast
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Bcast)(void*         buffer,
                     int*          count,
                     MPI_Datatype* datatype,
                     int*          root,
                     MPI_Comm*     comm,
                     int*          ierr)
{
  #if defined(HAS_MPI_BOTTOM)
  if (buffer == epk_mpif_bottom)
  {
    buffer = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Bcast(buffer, *count, *datatype, *root, *comm);
}

#endif
#if defined(HAS_MPI_EXSCAN) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Exscan
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 2.0
 * @ingroup coll
 */
void FSUB(MPI_Exscan)(void*         sendbuf,
                      void*         recvbuf,
                      int*          count,
                      MPI_Datatype* datatype,
                      MPI_Op*       op,
                      MPI_Comm*     comm,
                      int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Exscan(sendbuf, recvbuf, *count, *datatype, *op, *comm);
}

#endif
#if defined(HAS_MPI_GATHER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Gather
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Gather)(void*         sendbuf,
                      int*          sendcount,
                      MPI_Datatype* sendtype,
                      void*         recvbuf,
                      int*          recvcount,
                      MPI_Datatype* recvtype,
                      int*          root,
                      MPI_Comm*     comm,
                      int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Gather(sendbuf,
                     *sendcount,
                     *sendtype,
                     recvbuf,
                     *recvcount,
                     *recvtype,
                     *root,
                     *comm);
}

#endif
#if defined(HAS_MPI_GATHERV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Gatherv
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Gatherv)(void*         sendbuf,
                       int*          sendcount,
                       MPI_Datatype* sendtype,
                       void*         recvbuf,
                       int*          recvcounts,
                       int*          displs,
                       MPI_Datatype* recvtype,
                       int*          root,
                       MPI_Comm*     comm,
                       int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Gatherv(sendbuf,
                      *sendcount,
                      *sendtype,
                      recvbuf,
                      recvcounts,
                      displs,
                      *recvtype,
                      *root,
                      *comm);
}

#endif
#if defined(HAS_MPI_REDUCE) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Reduce)(void*         sendbuf,
                      void*         recvbuf,
                      int*          count,
                      MPI_Datatype* datatype,
                      MPI_Op*       op,
                      int*          root,
                      MPI_Comm*     comm,
                      int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Reduce(sendbuf,
                     recvbuf,
                     *count,
                     *datatype,
                     *op,
                     *root,
                     *comm);
}

#endif
#if defined(HAS_MPI_REDUCE_LOCAL) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce_local
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 2.2
 * @ingroup coll
 */
void FSUB(MPI_Reduce_local)(void*         inbuf,
                            void*         inoutbuf,
                            int*          count,
                            MPI_Datatype* datatype,
                            MPI_Op*       op,
                            int*          ierr)
{
  *ierr = MPI_Reduce_local(inbuf, inoutbuf, *count, *datatype, *op);
}

#endif
#if defined(HAS_MPI_REDUCE_SCATTER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce_scatter
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Reduce_scatter)(void*         sendbuf,
                              void*         recvbuf,
                              int*          recvcounts,
                              MPI_Datatype* datatype,
                              MPI_Op*       op,
                              MPI_Comm*     comm,
                              int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Reduce_scatter(sendbuf,
                             recvbuf,
                             recvcounts,
                             *datatype,
                             *op,
                             *comm);
}

#endif
#if defined(HAS_MPI_REDUCE_SCATTER_BLOCK) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce_scatter_block
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 2.2
 * @ingroup coll
 */
void FSUB(MPI_Reduce_scatter_block)(void*         sendbuf,
                                    void*         recvbuf,
                                    int*          recvcount,
                                    MPI_Datatype* datatype,
                                    MPI_Op*       op,
                                    MPI_Comm*     comm,
                                    int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Reduce_scatter_block(sendbuf,
                                   recvbuf,
                                   *recvcount,
                                   *datatype,
                                   *op,
                                   *comm);
}

#endif
#if defined(HAS_MPI_SCAN) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Scan
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Scan)(void*         sendbuf,
                    void*         recvbuf,
                    int*          count,
                    MPI_Datatype* datatype,
                    MPI_Op*       op,
                    MPI_Comm*     comm,
                    int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Scan(sendbuf, recvbuf, *count, *datatype, *op, *comm);
}

#endif
#if defined(HAS_MPI_SCATTER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Scatter
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Scatter)(void*         sendbuf,
                       int*          sendcount,
                       MPI_Datatype* sendtype,
                       void*         recvbuf,
                       int*          recvcount,
                       MPI_Datatype* recvtype,
                       int*          root,
                       MPI_Comm*     comm,
                       int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (recvbuf == epk_mpif_in_place)
  {
    recvbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Scatter(sendbuf,
                      *sendcount,
                      *sendtype,
                      recvbuf,
                      *recvcount,
                      *recvtype,
                      *root,
                      *comm);
}

#endif
#if defined(HAS_MPI_SCATTERV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Scatterv
 * @note Auto-generated by wrapgen from template: fstd.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Scatterv)(void*         sendbuf,
                        int*          sendcounts,
                        int*          displs,
                        MPI_Datatype* sendtype,
                        void*         recvbuf,
                        int*          recvcount,
                        MPI_Datatype* recvtype,
                        int*          root,
                        MPI_Comm*     comm,
                        int*          ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (recvbuf == epk_mpif_in_place)
  {
    recvbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Scatterv(sendbuf,
                       sendcounts,
                       displs,
                       *sendtype,
                       recvbuf,
                       *recvcount,
                       *recvtype,
                       *root,
                       *comm);
}

#endif

#else /* !NEED_F2C_CONV */

#if defined(HAS_MPI_ALLGATHER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Allgather
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Allgather)(void*     sendbuf,
                         MPI_Fint* sendcount,
                         MPI_Fint* sendtype,
                         void*     recvbuf,
                         MPI_Fint* recvcount,
                         MPI_Fint* recvtype,
                         MPI_Fint* comm,
                         MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Allgather(sendbuf, *sendcount, PMPI_Type_f2c(
                          *sendtype), recvbuf, *recvcount,
                        PMPI_Type_f2c(*recvtype),
                        PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_ALLGATHERV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Allgatherv
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Allgatherv)(void*     sendbuf,
                          MPI_Fint* sendcount,
                          MPI_Fint* sendtype,
                          void*     recvbuf,
                          MPI_Fint* recvcounts,
                          MPI_Fint* displs,
                          MPI_Fint* recvtype,
                          MPI_Fint* comm,
                          MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Allgatherv(sendbuf, *sendcount, PMPI_Type_f2c(
                           *sendtype), recvbuf, recvcounts, displs,
                         PMPI_Type_f2c(
                           *recvtype), PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_ALLREDUCE) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Allreduce
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Allreduce)(void*     sendbuf,
                         void*     recvbuf,
                         MPI_Fint* count,
                         MPI_Fint* datatype,
                         MPI_Fint* op,
                         MPI_Fint* comm,
                         MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Allreduce(sendbuf, recvbuf, *count, PMPI_Type_f2c(
                          *datatype), PMPI_Op_f2c(*op),
                        PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_ALLTOALL) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Alltoall
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Alltoall)(void*     sendbuf,
                        MPI_Fint* sendcount,
                        MPI_Fint* sendtype,
                        void*     recvbuf,
                        MPI_Fint* recvcount,
                        MPI_Fint* recvtype,
                        MPI_Fint* comm,
                        MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Alltoall(sendbuf, *sendcount, PMPI_Type_f2c(
                         *sendtype), recvbuf, *recvcount,
                       PMPI_Type_f2c(*recvtype),
                       PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_ALLTOALLV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Alltoallv
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Alltoallv)(void*     sendbuf,
                         MPI_Fint* sendcounts,
                         MPI_Fint* sdispls,
                         MPI_Fint* sendtype,
                         void*     recvbuf,
                         MPI_Fint* recvcounts,
                         MPI_Fint* rdispls,
                         MPI_Fint* recvtype,
                         MPI_Fint* comm,
                         MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr =
    MPI_Alltoallv(sendbuf, sendcounts, sdispls, PMPI_Type_f2c(
                    *sendtype), recvbuf, recvcounts, rdispls,
                  PMPI_Type_f2c(
                    *recvtype), PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_BARRIER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Barrier
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Barrier)(MPI_Fint* comm,
                       MPI_Fint* ierr)
{
  *ierr = MPI_Barrier(PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_BCAST) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Bcast
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Bcast)(void*     buffer,
                     MPI_Fint* count,
                     MPI_Fint* datatype,
                     MPI_Fint* root,
                     MPI_Fint* comm,
                     MPI_Fint* ierr)
{
  #if defined(HAS_MPI_BOTTOM)
  if (buffer == epk_mpif_bottom)
  {
    buffer = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Bcast(buffer, *count, PMPI_Type_f2c(
                      *datatype), *root, PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_GATHER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Gather
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Gather)(void*     sendbuf,
                      MPI_Fint* sendcount,
                      MPI_Fint* sendtype,
                      void*     recvbuf,
                      MPI_Fint* recvcount,
                      MPI_Fint* recvtype,
                      MPI_Fint* root,
                      MPI_Fint* comm,
                      MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Gather(sendbuf, *sendcount, PMPI_Type_f2c(
                       *sendtype), recvbuf, *recvcount, PMPI_Type_f2c(
                       *recvtype), *root, PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_GATHERV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Gatherv
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Gatherv)(void*     sendbuf,
                       MPI_Fint* sendcount,
                       MPI_Fint* sendtype,
                       void*     recvbuf,
                       MPI_Fint* recvcounts,
                       MPI_Fint* displs,
                       MPI_Fint* recvtype,
                       MPI_Fint* root,
                       MPI_Fint* comm,
                       MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Gatherv(sendbuf, *sendcount, PMPI_Type_f2c(
                        *sendtype), recvbuf, recvcounts, displs,
                      PMPI_Type_f2c(
                        *recvtype), *root, PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_REDUCE) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Reduce)(void*     sendbuf,
                      void*     recvbuf,
                      MPI_Fint* count,
                      MPI_Fint* datatype,
                      MPI_Fint* op,
                      MPI_Fint* root,
                      MPI_Fint* comm,
                      MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Reduce(sendbuf, recvbuf, *count, PMPI_Type_f2c(
                       *datatype), PMPI_Op_f2c(*op), *root,
                     PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_REDUCE_SCATTER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce_scatter
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Reduce_scatter)(void*     sendbuf,
                              void*     recvbuf,
                              MPI_Fint* recvcounts,
                              MPI_Fint* datatype,
                              MPI_Fint* op,
                              MPI_Fint* comm,
                              MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr =
    MPI_Reduce_scatter(sendbuf, recvbuf, recvcounts, PMPI_Type_f2c(
                         *datatype), PMPI_Op_f2c(*op), PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_SCAN) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Scan
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Scan)(void*     sendbuf,
                    void*     recvbuf,
                    MPI_Fint* count,
                    MPI_Fint* datatype,
                    MPI_Fint* op,
                    MPI_Fint* comm,
                    MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Scan(sendbuf, recvbuf, *count, PMPI_Type_f2c(
                     *datatype), PMPI_Op_f2c(*op), PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_SCATTER) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Scatter
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Scatter)(void*     sendbuf,
                       MPI_Fint* sendcount,
                       MPI_Fint* sendtype,
                       void*     recvbuf,
                       MPI_Fint* recvcount,
                       MPI_Fint* recvtype,
                       MPI_Fint* root,
                       MPI_Fint* comm,
                       MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (recvbuf == epk_mpif_in_place)
  {
    recvbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Scatter(sendbuf, *sendcount, PMPI_Type_f2c(
                        *sendtype), recvbuf, *recvcount, PMPI_Type_f2c(
                        *recvtype), *root, PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_SCATTERV) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Scatterv
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Scatterv)(void*     sendbuf,
                        MPI_Fint* sendcounts,
                        MPI_Fint* displs,
                        MPI_Fint* sendtype,
                        void*     recvbuf,
                        MPI_Fint* recvcount,
                        MPI_Fint* recvtype,
                        MPI_Fint* root,
                        MPI_Fint* comm,
                        MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (recvbuf == epk_mpif_in_place)
  {
    recvbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr =
    MPI_Scatterv(sendbuf, sendcounts, displs, PMPI_Type_f2c(
                   *sendtype), recvbuf, *recvcount, PMPI_Type_f2c(
                   *recvtype), *root, PMPI_Comm_f2c(*comm));
}

#endif

#if defined(HAS_MPI_ALLTOALLW) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Alltoallv
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 1.0
 * @ingroup coll
 */
void FSUB(MPI_Alltoallw)(void*     sendbuf,
                         MPI_Fint* sendcounts,
                         MPI_Fint* sdispls,
                         MPI_Fint* sendtypes,
                         void*     recvbuf,
                         MPI_Fint* recvcounts,
                         MPI_Fint* rdispls,
                         MPI_Fint* recvtypes,
                         MPI_Fint* comm,
                         MPI_Fint* ierr)
{
  MPI_Datatype* csendtypes;
  MPI_Datatype* crecvtypes;
  MPI_Comm      ccomm;
  int           size;

  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  ccomm = PMPI_Comm_f2c(*comm);
  PMPI_Comm_size(ccomm, &size);

  csendtypes = malloc(size * sizeof (MPI_Datatype));
  crecvtypes = malloc(size * sizeof (MPI_Datatype));

  while (size > 0)
  {
    csendtypes[size - 1] = PMPI_Type_f2c(sendtypes[size - 1]);
    crecvtypes[size - 1] = PMPI_Type_f2c(recvtypes[size - 1]);
    --size;
  }

  *ierr = MPI_Alltoallw(sendbuf, sendcounts, sdispls, csendtypes, recvbuf,
                        recvcounts, rdispls, crecvtypes, ccomm);

  free(csendtypes);
  free(crecvtypes);
} /* FSUB(MPI_Alltoallw) */

#if defined(HAS_MPI_EXSCAN) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Exscan
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 2.0
 * @ingroup coll
 */
void FSUB(MPI_Exscan)(void*     sendbuf,
                      void*     recvbuf,
                      MPI_Fint* count,
                      MPI_Fint* datatype,
                      MPI_Fint* op,
                      MPI_Fint* comm,
                      MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Exscan(sendbuf, recvbuf, *count, PMPI_Type_f2c(
                       *datatype), PMPI_Op_f2c(*op), PMPI_Comm_f2c(*comm));
}

#endif
#if defined(HAS_MPI_REDUCE_LOCAL) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce_local
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 2.2
 * @ingroup coll
 */
void FSUB(MPI_Reduce_local)(void*     inbuf,
                            void*     inoutbuf,
                            MPI_Fint* count,
                            MPI_Fint* datatype,
                            MPI_Fint* op,
                            MPI_Fint* ierr)
{
  *ierr =
    MPI_Reduce_local(inbuf, inoutbuf, *count, PMPI_Type_f2c(
                       *datatype), PMPI_Op_f2c(*op));
}

#endif
#if defined(HAS_MPI_REDUCE_SCATTER_BLOCK) && !defined(NO_MPI_COLL)
/**
 * Measurement wrapper for MPI_Reduce_scatter_block
 * @note Auto-generated by wrapgen from template: f2c_c2f.w
 * @note Fortran interface
 * @note Introduced with MPI 2.2
 * @ingroup coll
 */
void FSUB(MPI_Reduce_scatter_block)(void*     sendbuf,
                                    void*     recvbuf,
                                    MPI_Fint* recvcount,
                                    MPI_Fint* datatype,
                                    MPI_Fint* op,
                                    MPI_Fint* comm,
                                    MPI_Fint* ierr)
{
  #if defined(HAS_MPI_IN_PLACE)
  if (sendbuf == epk_mpif_in_place)
  {
    sendbuf = MPI_IN_PLACE;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (sendbuf == epk_mpif_bottom)
  {
    sendbuf = MPI_BOTTOM;
  }
  #endif
  #if defined(HAS_MPI_BOTTOM)
  if (recvbuf == epk_mpif_bottom)
  {
    recvbuf = MPI_BOTTOM;
  }
  #endif

  *ierr = MPI_Reduce_scatter_block(sendbuf,
                                   recvbuf,
                                   *recvcount,
                                   PMPI_Type_f2c(*datatype),
                                   PMPI_Op_f2c(*op),
                                   PMPI_Comm_f2c(*comm));
}

#endif
#endif

#endif

/**
 * @}
 */
