/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2010-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  Copyright (c) 2003-2008                                                **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/**
 * @file  epk_mpiwrap_io.c
 *
 * @brief C interface wrappers for parallel I/O
 */

#include <mpi.h>

#include "esd_event.h"

#include "epk_defs_mpi.h"
#include "epk_mpiwrap.h"

/**
 * @name C wrappers for administrative functions
 * @{
 */

#if defined(HAS_MPI_FILE_CLOSE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_close
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_close(MPI_File* fh)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_CLOSE]);

    return_val = PMPI_File_close(fh);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_CLOSE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_close(fh);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_DELETE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_delete
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_delete(char*    filename,
                    MPI_Info info)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_DELETE]);

    return_val = PMPI_File_delete(filename, info);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_DELETE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_delete(filename, info);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_AMODE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_amode
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_amode(MPI_File fh,
                       int*     amode)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_AMODE]);

    return_val = PMPI_File_get_amode(fh, amode);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_AMODE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_amode(fh, amode);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_ATOMICITY) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_atomicity
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_atomicity(MPI_File fh,
                           int*     flag)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_ATOMICITY]);

    return_val = PMPI_File_get_atomicity(fh, flag);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_ATOMICITY]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_atomicity(fh, flag);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_BYTE_OFFSET) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_byte_offset
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_byte_offset(MPI_File    fh,
                             MPI_Offset  offset,
                             MPI_Offset* disp)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_BYTE_OFFSET]);

    return_val = PMPI_File_get_byte_offset(fh, offset, disp);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_BYTE_OFFSET]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_byte_offset(fh, offset, disp);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_GROUP) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_group
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_group(MPI_File   fh,
                       MPI_Group* group)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_GROUP]);

    return_val = PMPI_File_get_group(fh, group);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_GROUP]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_group(fh, group);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_INFO) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_info
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_info(MPI_File  fh,
                      MPI_Info* info_used)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_INFO]);

    return_val = PMPI_File_get_info(fh, info_used);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_INFO]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_info(fh, info_used);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_POSITION) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_position
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_position(MPI_File    fh,
                          MPI_Offset* offset)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_POSITION]);

    return_val = PMPI_File_get_position(fh, offset);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_POSITION]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_position(fh, offset);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_POSITION_SHARED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_position_shared
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_position_shared(MPI_File    fh,
                                 MPI_Offset* offset)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_POSITION_SHARED]);

    return_val = PMPI_File_get_position_shared(fh, offset);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_POSITION_SHARED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_position_shared(fh, offset);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_SIZE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_size
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_size(MPI_File    fh,
                      MPI_Offset* size)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_SIZE]);

    return_val = PMPI_File_get_size(fh, size);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_SIZE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_size(fh, size);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_TYPE_EXTENT) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_type_extent
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_type_extent(MPI_File     fh,
                             MPI_Datatype datatype,
                             MPI_Aint*    extent)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_TYPE_EXTENT]);

    return_val = PMPI_File_get_type_extent(fh, datatype, extent);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_TYPE_EXTENT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_type_extent(fh, datatype, extent);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_VIEW) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_get_view
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_get_view(MPI_File      fh,
                      MPI_Offset*   disp,
                      MPI_Datatype* etype,
                      MPI_Datatype* filetype,
                      char*         datarep)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_VIEW]);

    return_val = PMPI_File_get_view(fh, disp, etype, filetype, datarep);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_VIEW]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_view(fh, disp, etype, filetype, datarep);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_OPEN) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_open
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_open(MPI_Comm  comm,
                  char*     filename,
                  int       amode,
                  MPI_Info  info,
                  MPI_File* fh)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_OPEN]);

    return_val = PMPI_File_open(comm, filename, amode, info, fh);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_OPEN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_open(comm, filename, amode, info, fh);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_PREALLOCATE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_preallocate
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_preallocate(MPI_File   fh,
                         MPI_Offset size)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_PREALLOCATE]);

    return_val = PMPI_File_preallocate(fh, size);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_PREALLOCATE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_preallocate(fh, size);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SEEK) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_seek
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_seek(MPI_File   fh,
                  MPI_Offset offset,
                  int        whence)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SEEK]);

    return_val = PMPI_File_seek(fh, offset, whence);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SEEK]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_seek(fh, offset, whence);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SEEK_SHARED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_seek_shared
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_seek_shared(MPI_File   fh,
                         MPI_Offset offset,
                         int        whence)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SEEK_SHARED]);

    return_val = PMPI_File_seek_shared(fh, offset, whence);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SEEK_SHARED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_seek_shared(fh, offset, whence);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SET_ATOMICITY) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_set_atomicity
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_set_atomicity(MPI_File fh,
                           int      flag)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SET_ATOMICITY]);

    return_val = PMPI_File_set_atomicity(fh, flag);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SET_ATOMICITY]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_set_atomicity(fh, flag);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SET_INFO) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_set_info
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_set_info(MPI_File fh,
                      MPI_Info info)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SET_INFO]);

    return_val = PMPI_File_set_info(fh, info);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SET_INFO]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_set_info(fh, info);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SET_SIZE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_set_size
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_set_size(MPI_File   fh,
                      MPI_Offset size)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SET_SIZE]);

    return_val = PMPI_File_set_size(fh, size);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SET_SIZE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_set_size(fh, size);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SET_VIEW) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_set_view
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_set_view(MPI_File     fh,
                      MPI_Offset   disp,
                      MPI_Datatype etype,
                      MPI_Datatype filetype,
                      char*        datarep,
                      MPI_Info     info)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SET_VIEW]);

    return_val = PMPI_File_set_view(fh,
                                    disp,
                                    etype,
                                    filetype,
                                    datarep,
                                    info);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SET_VIEW]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_set_view(fh,
                                    disp,
                                    etype,
                                    filetype,
                                    datarep,
                                    info);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SYNC) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_sync
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_sync(MPI_File fh)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SYNC]);

    return_val = PMPI_File_sync(fh);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SYNC]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_sync(fh);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_REGISTER_DATAREP) && !defined(NO_MPI_IO) \
  && !defined(NO_MPI_EXTRA)
/**
 * Measurement wrapper for MPI_Register_datarep
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_Register_datarep(
  char* datarep,
  MPI_Datarep_conversion_function*
  read_conversion_fn,
  MPI_Datarep_conversion_function*
  write_conversion_fn,
  MPI_Datarep_extent_function*
  dtype_file_extent_fn,
  void* extra_state)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_REGISTER_DATAREP]);

    return_val = PMPI_Register_datarep(datarep,
                                       read_conversion_fn,
                                       write_conversion_fn,
                                       dtype_file_extent_fn,
                                       extra_state);

    esd_exit(epk_mpi_regid[EPK__MPI_REGISTER_DATAREP]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Register_datarep(datarep,
                                       read_conversion_fn,
                                       write_conversion_fn,
                                       dtype_file_extent_fn,
                                       extra_state);
  }

  return return_val;
}

#endif

/**
 * @}
 * @name C wrappers for file read functions
 * @{
 */

#if defined(HAS_MPI_FILE_IREAD) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_iread
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_iread(MPI_File     fh,
                   void*        buf,
                   int          count,
                   MPI_Datatype datatype,
                   MPI_Request* request)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_IREAD]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_iread(fh, buf, count, datatype, request);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_IREAD]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_iread(fh, buf, count, datatype, request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_IREAD_AT) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_iread_at
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_iread_at(MPI_File     fh,
                      MPI_Offset   offset,
                      void*        buf,
                      int          count,
                      MPI_Datatype datatype,
                      MPI_Request* request)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_IREAD_AT]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_iread_at(fh,
                                    offset,
                                    buf,
                                    count,
                                    datatype,
                                    request);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_IREAD_AT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_iread_at(fh,
                                    offset,
                                    buf,
                                    count,
                                    datatype,
                                    request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_IREAD_SHARED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_iread_shared
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_iread_shared(MPI_File     fh,
                          void*        buf,
                          int          count,
                          MPI_Datatype datatype,
                          MPI_Request* request)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_IREAD_SHARED]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_iread_shared(fh, buf, count, datatype, request);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_IREAD_SHARED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_iread_shared(fh, buf, count, datatype, request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read(MPI_File     fh,
                  void*        buf,
                  int          count,
                  MPI_Datatype datatype,
                  MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_AT) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_at
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_at(MPI_File     fh,
                     MPI_Offset   offset,
                     void*        buf,
                     int          count,
                     MPI_Datatype datatype,
                     MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_AT]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_at(fh,
                                   offset,
                                   buf,
                                   count,
                                   datatype,
                                   status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_AT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_at(fh,
                                   offset,
                                   buf,
                                   count,
                                   datatype,
                                   status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_SHARED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_shared
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_shared(MPI_File     fh,
                         void*        buf,
                         int          count,
                         MPI_Datatype datatype,
                         MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_SHARED]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_shared(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_SHARED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_shared(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_ALL) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_all
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_all(MPI_File     fh,
                      void*        buf,
                      int          count,
                      MPI_Datatype datatype,
                      MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_ALL]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_all(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_ALL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_all(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_AT_ALL) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_at_all
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_at_all(MPI_File     fh,
                         MPI_Offset   offset,
                         void*        buf,
                         int          count,
                         MPI_Datatype datatype,
                         MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_AT_ALL]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_at_all(fh,
                                       offset,
                                       buf,
                                       count,
                                       datatype,
                                       status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_AT_ALL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_at_all(fh,
                                       offset,
                                       buf,
                                       count,
                                       datatype,
                                       status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_ORDERED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_ordered
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_ordered(MPI_File     fh,
                          void*        buf,
                          int          count,
                          MPI_Datatype datatype,
                          MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_ORDERED]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_ordered(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_ORDERED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_ordered(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_ALL_BEGIN) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_all_begin
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_all_begin(MPI_File     fh,
                            void*        buf,
                            int          count,
                            MPI_Datatype datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_ALL_BEGIN]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_all_begin(fh, buf, count, datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_ALL_BEGIN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_all_begin(fh, buf, count, datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_AT_ALL_BEGIN) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_at_all_begin
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_at_all_begin(MPI_File     fh,
                               MPI_Offset   offset,
                               void*        buf,
                               int          count,
                               MPI_Datatype datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_AT_ALL_BEGIN]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_at_all_begin(fh,
                                             offset,
                                             buf,
                                             count,
                                             datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_AT_ALL_BEGIN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_at_all_begin(fh,
                                             offset,
                                             buf,
                                             count,
                                             datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_ORDERED_BEGIN) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_ordered_begin
 * @note Auto-generated by wrapgen from template: file_read.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_ordered_begin(MPI_File     fh,
                                void*        buf,
                                int          count,
                                MPI_Datatype datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_ORDERED_BEGIN]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_read(count * sz);

    return_val = PMPI_File_read_ordered_begin(fh, buf, count, datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_ORDERED_BEGIN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_ordered_begin(fh, buf, count, datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_ALL_END) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_all_end
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_all_end(MPI_File    fh,
                          void*       buf,
                          MPI_Status* status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_ALL_END]);

    return_val = PMPI_File_read_all_end(fh, buf, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_ALL_END]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_all_end(fh, buf, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_AT_ALL_END) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_at_all_end
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_at_all_end(MPI_File    fh,
                             void*       buf,
                             MPI_Status* status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_AT_ALL_END]);

    return_val = PMPI_File_read_at_all_end(fh, buf, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_AT_ALL_END]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_at_all_end(fh, buf, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_READ_ORDERED_END) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_read_ordered_end
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_read_ordered_end(MPI_File    fh,
                              void*       buf,
                              MPI_Status* status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_READ_ORDERED_END]);

    return_val = PMPI_File_read_ordered_end(fh, buf, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_READ_ORDERED_END]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_read_ordered_end(fh, buf, status);
  }

  return return_val;
}

#endif

/**
 * @}
 * @name C wrappers for file write functions
 * @{
 */

#if defined(HAS_MPI_FILE_IWRITE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_iwrite
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_iwrite(MPI_File     fh,
                    void*        buf,
                    int          count,
                    MPI_Datatype datatype,
                    MPI_Request* request)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_IWRITE]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_iwrite(fh, buf, count, datatype, request);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_IWRITE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_iwrite(fh, buf, count, datatype, request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_IWRITE_AT) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_iwrite_at
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_iwrite_at(MPI_File     fh,
                       MPI_Offset   offset,
                       void*        buf,
                       int          count,
                       MPI_Datatype datatype,
                       MPI_Request* request)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_IWRITE_AT]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_iwrite_at(fh,
                                     offset,
                                     buf,
                                     count,
                                     datatype,
                                     request);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_IWRITE_AT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_iwrite_at(fh,
                                     offset,
                                     buf,
                                     count,
                                     datatype,
                                     request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_IWRITE_SHARED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_iwrite_shared
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_iwrite_shared(MPI_File     fh,
                           void*        buf,
                           int          count,
                           MPI_Datatype datatype,
                           MPI_Request* request)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_IWRITE_SHARED]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_iwrite_shared(fh, buf, count, datatype, request);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_IWRITE_SHARED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_iwrite_shared(fh, buf, count, datatype, request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write(MPI_File     fh,
                   void*        buf,
                   int          count,
                   MPI_Datatype datatype,
                   MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_AT) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_at
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_at(MPI_File     fh,
                      MPI_Offset   offset,
                      void*        buf,
                      int          count,
                      MPI_Datatype datatype,
                      MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_at(fh,
                                    offset,
                                    buf,
                                    count,
                                    datatype,
                                    status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_at(fh,
                                    offset,
                                    buf,
                                    count,
                                    datatype,
                                    status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_SHARED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_shared
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_shared(MPI_File     fh,
                          void*        buf,
                          int          count,
                          MPI_Datatype datatype,
                          MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_SHARED]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_shared(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_SHARED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_shared(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_ALL) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_all
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_all(MPI_File     fh,
                       void*        buf,
                       int          count,
                       MPI_Datatype datatype,
                       MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_ALL]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_all(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_ALL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_all(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_AT_ALL) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_at_all
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_at_all(MPI_File     fh,
                          MPI_Offset   offset,
                          void*        buf,
                          int          count,
                          MPI_Datatype datatype,
                          MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT_ALL]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_at_all(fh,
                                        offset,
                                        buf,
                                        count,
                                        datatype,
                                        status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT_ALL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_at_all(fh,
                                        offset,
                                        buf,
                                        count,
                                        datatype,
                                        status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_ORDERED) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_ordered
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_ordered(MPI_File     fh,
                           void*        buf,
                           int          count,
                           MPI_Datatype datatype,
                           MPI_Status*  status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_ORDERED]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_ordered(fh, buf, count, datatype, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_ORDERED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_ordered(fh, buf, count, datatype, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_ALL_BEGIN) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_all_begin
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_all_begin(MPI_File     fh,
                             void*        buf,
                             int          count,
                             MPI_Datatype datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_ALL_BEGIN]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_all_begin(fh, buf, count, datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_ALL_BEGIN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_all_begin(fh, buf, count, datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_AT_ALL_BEGIN) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_at_all_begin
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_at_all_begin(MPI_File     fh,
                                MPI_Offset   offset,
                                void*        buf,
                                int          count,
                                MPI_Datatype datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT_ALL_BEGIN]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_at_all_begin(fh,
                                              offset,
                                              buf,
                                              count,
                                              datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT_ALL_BEGIN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_at_all_begin(fh,
                                              offset,
                                              buf,
                                              count,
                                              datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_ORDERED_BEGIN) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_ordered_begin
 * @note Auto-generated by wrapgen from template: file_write.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_ordered_begin(MPI_File     fh,
                                 void*        buf,
                                 int          count,
                                 MPI_Datatype datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    int sz;

    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_ORDERED_BEGIN]);

    PMPI_Type_size(datatype, &sz);
    esd_mpi_file_write(count * sz);

    return_val = PMPI_File_write_ordered_begin(fh, buf, count, datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_ORDERED_BEGIN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_ordered_begin(fh, buf, count, datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_ALL_END) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_all_end
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_all_end(MPI_File    fh,
                           void*       buf,
                           MPI_Status* status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_ALL_END]);

    return_val = PMPI_File_write_all_end(fh, buf, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_ALL_END]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_all_end(fh, buf, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_AT_ALL_END) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_at_all_end
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_at_all_end(MPI_File    fh,
                              void*       buf,
                              MPI_Status* status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT_ALL_END]);

    return_val = PMPI_File_write_at_all_end(fh, buf, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_AT_ALL_END]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_at_all_end(fh, buf, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_WRITE_ORDERED_END) && !defined(NO_MPI_IO)
/**
 * Measurement wrapper for MPI_File_write_ordered_end
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io
 */
int MPI_File_write_ordered_end(MPI_File    fh,
                               void*       buf,
                               MPI_Status* status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_WRITE_ORDERED_END]);

    return_val = PMPI_File_write_ordered_end(fh, buf, status);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_WRITE_ORDERED_END]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_write_ordered_end(fh, buf, status);
  }

  return return_val;
}

#endif

/**
 * @}
 * @name C wrappers for error handling functions
 * @{
 */

#if defined(HAS_MPI_FILE_CALL_ERRHANDLER) && !defined(NO_MPI_IO) \
  && !defined(NO_MPI_EXTRA) && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_File_call_errhandler
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io_err
 */
int MPI_File_call_errhandler(MPI_File fh,
                             int      errorcode)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO_ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_CALL_ERRHANDLER]);

    return_val = PMPI_File_call_errhandler(fh, errorcode);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_CALL_ERRHANDLER]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_call_errhandler(fh, errorcode);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_CREATE_ERRHANDLER) && !defined(NO_MPI_IO) \
  && !defined(NO_MPI_EXTRA) && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_File_create_errhandler
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io_err
 */
int MPI_File_create_errhandler(MPI_File_errhandler_fn* function,
                               MPI_Errhandler*         errhandler)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO_ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_CREATE_ERRHANDLER]);

    return_val = PMPI_File_create_errhandler(function, errhandler);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_CREATE_ERRHANDLER]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_create_errhandler(function, errhandler);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_GET_ERRHANDLER) && !defined(NO_MPI_IO) \
  && !defined(NO_MPI_EXTRA) && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_File_get_errhandler
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io_err
 */
int MPI_File_get_errhandler(MPI_File        file,
                            MPI_Errhandler* errhandler)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO_ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_GET_ERRHANDLER]);

    return_val = PMPI_File_get_errhandler(file, errhandler);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_GET_ERRHANDLER]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_get_errhandler(file, errhandler);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_SET_ERRHANDLER) && !defined(NO_MPI_IO) \
  && !defined(NO_MPI_EXTRA) && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_File_set_errhandler
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io_err
 */
int MPI_File_set_errhandler(MPI_File       file,
                            MPI_Errhandler errhandler)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(IO_ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_SET_ERRHANDLER]);

    return_val = PMPI_File_set_errhandler(file, errhandler);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_SET_ERRHANDLER]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_set_errhandler(file, errhandler);
  }

  return return_val;
}

#endif

/**
 * @}
 * @name Fortran wrappers for handle conversion functions
 * @{
 */

#if defined(HAS_MPI_FILE_C2F) && !defined(NO_MPI_IO) \
  && !defined(NO_MPI_EXTRA) && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_File_c2f
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io_misc
 */
MPI_Fint MPI_File_c2f(MPI_File file)
{
  MPI_Fint return_val;

  if (IS_EVENT_GEN_ON_FOR(IO_MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_C2F]);

    return_val = PMPI_File_c2f(file);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_C2F]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_c2f(file);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FILE_F2C) && !defined(NO_MPI_IO) \
  && !defined(NO_MPI_EXTRA) && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_File_f2c
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup io_misc
 */
MPI_File MPI_File_f2c(MPI_Fint file)
{
  MPI_File return_val;

  if (IS_EVENT_GEN_ON_FOR(IO_MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FILE_F2C]);

    return_val = PMPI_File_f2c(file);

    esd_exit(epk_mpi_regid[EPK__MPI_FILE_F2C]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_File_f2c(file);
  }

  return return_val;
}

#endif
