# third party

errmsg = "For use with ruby v%s %s is required!\nPlease run schleuder-fix-gem-dependencies to fix this!"
if RUBY_VERSION =~ /1.8/
  require 'rubygems'
  begin
    require 'tmail'
  rescue LoadError
    $stderr.puts errmsg % %w(1.8, tmail \(preferably v1.2.3.1\))
    exit 1
  end
else
  begin
    gem 'actionmailer', '=2.3.14'
    require 'action_mailer'
  rescue LoadError
    $stderr.puts errmsg % %w(1.9, actionmailer-2.3.14)
    exit 1
  end
end

gem 'gpgme', '=1.0.8'
require 'gpgme'

require 'net/smtp'
require 'log4r'
require 'log4r/outputter/emailoutputter'
require 'log4r/outputter/fileoutputter'
require 'filemagic/ext'

# internal requires
$:.unshift File.dirname(__FILE__)
require 'schleuder/errors'
require 'schleuder/utils'
require 'schleuder/crypt'
require 'schleuder/storage'
require 'schleuder/list_config'
require 'schleuder/list'
require 'schleuder/mailer'
require 'schleuder/mail'
require 'schleuder/member'
require 'schleuder/plugin'
require 'schleuder/schleuder_config'
require 'schleuder/log/outputter/emailoutputter'
require 'schleuder/log/outputter/metaemailoutputter'
require 'schleuder/log/schleuderlogger'
require 'schleuder/log/listlogger'
require 'schleuder/archiver'
require 'schleuder/processor'
