module Schleuder
  class SchleuderLogger < Log4r::Logger
    # Instantiates a logger to be used outside of list-contexts and sets
    # outputters and level.
    def initialize
      # The name 'log4r' is special: it is considered as meta-logger by Log4r
      # and receives log_internal()-messages.
      super 'log4r'
      # The initial log_level is inherited by all outputters.
      @level = eval("Log4r::#{Schleuder.config.log_level.upcase}")
      pattern = "%d Schleuder %l\t%M"
      formatter = Log4r::PatternFormatter.new(:pattern => pattern)
      add Log4r::FileOutputter.new('file',
                                   { :level => @level,
                                     :filename => Schleuder.config.log_file,
                                     :formatter => formatter }
                                  )
      add MetaEmailOutputter.new('email',
                                 {:to => Schleuder.config.superadminaddr,
                                  :immediate_at => 'ERROR, FATAL'})
    end
  end
end
