#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2008 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Evolve database to generation 2.

Fix bad dates created by message and goal constructors.
"""

import pytz

from zope.app.generations.utility import getRootFolder


def fixCreated(obj):
    if obj.created.tzinfo is None:
        obj.created = pytz.UTC.localize(obj.created)


def evolve(context):
    """Fixes message and goal creation dates to have tzinfo set."""
    app = getRootFolder(context)
    interventionRoot = app.get(u'schooltool.interventions', {})
    for schoolYear in interventionRoot.values():
        for student in schoolYear.values():
            for message in student['messages'].values():
                fixCreated(message)
            for goal in student['goals'].values():
                fixCreated(goal)

