# oldspanish.tcl:
# Old Spanish help pages.
# These are no longer included in Scid because they are out of date.

set helpTitle(S,Index) "ndice"
set helpText(S,Index) {<h1>Scid: ndice de la Ayuda</h1>

<h4>Comienzo y ayuda general</h4>
<ul>
<li><a Guide><b>Gua Rpida</b> para usar Scid</a> <red>(Lee esto primero)</red></li>
<li><a Hints><b>Sugerencias</b> para conseguir ms de Scid</a></li>
<li><a MainWindow><b>Ventana principal</b> de Scid</a></li>
<li><a Menus><b>Mens</b> de Scid</a></li>
<li><a Moves>Entrada de <b>movimientos</b></a></li>
<li><a Searches><b>Bsquedas</b> en Scid</a></li>
<li><a Clipbase>Utilizacin de la <b>Base de Trabajo (Clipbase)</b></a></li>
</ul>

<h4>Otras ventanas de Scid</h4>
<ul>
<li><a Analysis>Ventana de <b>Anlisis</b></a></li>
<li><a Comment>Ventana del <b>Editor de Comentarios</b></a></li>
<li><a Crosstable>Ventana de <b>Tablas Cruzadas</b></a></li>
<li><a Switcher>Ventana del <b>Intercambiador de Bases de Datos</b></a></li>
<li><a Email>Ventana del administrador de <b>Emails</b> de ajedrez</a></li>
<li><a Finder>Ventana del <b>Visor de Archivos</b></a> <red>(Nuevo!)</red></li>
<li><a GameList>Ventana del <b>Listado de Partidas</b></a></li>
<li><a Import>Ventana de <b>Importacin de partidas</b></a></li>
<li><a OpReport><b>Ventana del <b>Informe de la apertura</b></a></li>
<li><a PGN>Ventana de <b>PGN</b> (partidas en texto)</a></li>
<li><a PInfo>Ventana de <b>Informacin del Jugador</b></a></li>
<li><a Repertoire><b>Editor de Repertorio</b></a> <red>(Nuevo!)</red></li>
<li><a Tmt>Ventana del <b>Visor de Torneos</b></a> <red>(Nuevo!)</red></li>
<li><a Tree>Ventana de <b>rbol</b></a></li>
<li><a Graphs>Ventanas de <b>Grficos</b></a></li>
<li><a TB>Uso de <b>Tablebases</b> en Scid</a> <red>(Nuevo!)</red></li>
</ul>

<h4>Otras utilidades e informacin</h4>
<ul>
<li><a Bookmarks><b>Bookmarks</b></a> <red>(Nuevo!)</red></li>
<li><a Cmdline>Command-line options</a> <red>(New!)</red></li>
<li><a Compact><b>Compactando</b> una base de datos</a></li>
<li><a Maintenance>Herramientas de <b>mantenimiento de la Base de Datos</b></a>
    <red>(cambios recientes)</red></li>
<li><a ECO>Clasificacin de aberturas por <b>ECO</b></a></li>
<li><a EPD>Archivos de <b>EPD</b></a></li>
<li><a Export><b>Exportacin</b> de partidas a archivos de texto</a></li>
<li><a Flags>Game <b>Flags</b></a> <red>(Nuevo!)</red></li>
<li><a LaTeX>Usando <b>LaTeX</b> con Scid</a></li>
<li><a Options><b>Opciones</b> y preferencias</a></li>
<li><a Sorting><b>Ordenando</b> una base de datos</a></li>
<li><a Pgnscid><b>Pgnscid</b>: conversin de archivos PGN</a></li>
<li><a NAGs>Valores de anotacin <b>NAG</b> estndares</a></li>
<li><a Formats><b>Formatos de archivo</b> de las bases de datos Scid</a></li>
<li><a Author>Informacin de contacto</a></li>
</ul>

<p><footer>(Actualizado: Scid 3.0, Noviembre 2001)</footer></p>
}


####################
### Quick Guide help:

set helpTitle(S,Guide) "Gua rpida para usar Scid"
set helpText(S,Guide) {<h1>Gua rpida para usar Scid</h1>
<p>
Scid es una aplicacin de base de datos de ajedrez; con ella puedes realizar bsquedas en bases de datos de partidas de ajedrez, editar partidas, y <a Searches>buscar</a> partidas por varios criterios.
</p>
<p>
Scid usa su propio <a Formats>formato de base de datos</a> de tres archivos, los cuales son muy compactos y rpidos, adems puede convertir a y desde el formato estndar PGN (Portable Game Notation). La <a PGN>ventana PGN</a> de Scid muestra el texto de la partida actual en formato PGN.
</p>
<p>
Puedes usar Scid para aadir partidas a una base de datos, usando el teclado o el ratn para entrar los movimientos. Ver la pgina de ayuda de <a Moves>entrada de movimientos</a> para ms detalles.
</p>
<p>
Tambin puedes usar Scid como un buscador de archivos <a PGN>PGN</a>, colocando un texto PGN en la ventana de <a Import>Importacin</a> de Scid o abriendo un archivo PGN con Scid. Sin embargo, Scid no puede editar archivos PGN (slo puede abrirlos y leerlos) ocupndose, adems, ms memoria y tardndose ms en cargar, por eso para grandes archivos PGN se recomienda crear primero una base de datos Scid de ellos con la utilidad <a Pgnscid>pgnscid</a>.
</p>
<p>
La <a MainWindow>Ventana Principal</a> de Scid (con el tablero grfico de ajedrez) muestra los datos de la partida activa y de la base de datos. Puedes tener abiertas, al mismo tiempo, tres bases de datos (cuatro incluyendo la <a Clipbase>base de trabajo</a>),
y cada una puede tener abierta su propia partida activa. (Una partida numerada como 0 indica que es una partida que no forma parte de la actual base de datos).
Puedes intercambiar entre las bases de datos abiertas mediante el <a Menus File>men Archivo</a>.
</p>
<p>
Para ms informacin, por favor lee las otras pginas de ayuda mencionadas en el <a Index>ndice de la Ayuda</a>.
</p>
<p>
Mira la pgina de la <a Author>informacin de contacto</a> si necesitas contacta con el autor de Scid.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}


####################
### Main window help:

set helpTitle(S,MainWindow) "Ventana principal de Scid"
set helpText(S,MainWindow) {<h1>Ventana principal de Scid</h1>
<p>
La ventana principal de Scid muestra la actual posicin del tablero de la partida activa e informacin sobre la partida actual y la base de datos. Otras pginas de ayuda describen los <a Menus>mens</a> y las maneras de <a Moves>entrar los movimientos de ajedrez</a>.
</p>

<h3>Botones de navegacin de la partida</h3>
<p>
Los botones de navegacin que hay sobre el tablero tienen, de derecha a izquierda, los siguientes significados:
<ul>
<li> <button tb_start> Va al inicio de la partida. </li>
<li> <button tb_prev> Va un movimiento atrs. </li>
<li> <button tb_next> Va un movimiento adelante. </li>
<li> <button tb_end> Va al final de la partida. </li>
<li> <button tb_invar> Entra en una variacin. </li>
<li> <button tb_outvar> Sale de la actual variacin. </li>
<li> <button tb_addvar> Aade una variacin. </li>
<li> <button autoplay_off> Inicia/para el modo de movimiento automtico (ver ms abajo). </li>
<li> <button tb_flip> Gira el tablero 180 grados. </li>
<li> <button tb_coords> Poner/quitar las coordenadas del tablero. </li>
</ul>

<h4><name Autoplay>Modo de Movimiento Automtico</name></h4>
<p>
En el modo de Movimiento Automtico, Scid automticamente realiza los movimientos de la partida actual, moviendo hacia adelante hasta el final de la partida. El tiempo de demora entre los movimientos puede ser cambiado desde el men <menu>Opciones: Movimientos</menu>, y es guardado en tu archivo de opciones cuando guardas las opciones.
</p>
<p>
La combinacin de teclas <b>Control+Z</b> inicia o para el modo de movimiento automtico, asimismo puedes parar el modo de movimiento automtico apretando la tecla <b>Escape (Esc)</b>.
</p>
<p>
Si inicias el modo de movimiento automtico cuando la <a Analysis>ventana de anlisis</a> est abierta, la partida es <term>comentada</term>: la puntuacin y el anlisis para cada posicin es aadido a la partida como comentarios justo antes de que se realice el siguiente movimiento. Ver la pgina de ayuda de la <a Analysis> ventana de anlisis</a> para ms detalles.
</p>

<h3>El rea de informacin de la partida</h3>
<p>
El rea debajo del tablero de ajedrez que muestra informacin sobre la partida se llama <term>rea de informacin de la partida</term>.
Las dos primeras lneas muestran informacin sobre jugadores, resultado, fecha y lugar. La tercera lnea indica la posicin actual de la partida y cual es el siguiente movimiento.
</p>
<p>
La cuarta lnea muestra el cdigo <a ECO>ECO</a> (Encyclopaedia of Chess Openings) de la actual posicin, si la posicin aparece en el archivo ECO que se este usando.
</p>
<p>
El rea de informacin de la partida tiene un men que se activa con el botn derecho del ratn, con opciones para ocultar el siguiente movimiento (til si ests entrenando usando una partida y quieres calcular cada movimiento), y para suprimir (borrar) o restaurar la partida actual. Puedes activar este men sin usar el ratn, apretando la tecla de funcin <b>F9</b>.
</p>

<h4>Tablebases</h4>
<p>
El rea de informacin de la partida tambin muestra resultados de las tablebases en cualquier momento en el que la posicin mostrada alcanza una configuracin de material que se encuentra en un archivo de tablebase (Tb). Ver la pgina de ayuda de <aTB>tablebases</a> para ms detalles.

<h3>La barra de estado</h3>
<p>
La barra de estado muestra informacin sobre la base de datos actual. El primer campo indica el estado de la partida: <b>XX</b> significa que a sido alterada y an no ha sido salvada, <b>--</b> significa que no ha sido alterada y <b>%%</b> indica que la base de datos slo se puede leer (no es alterable).
</p>
<p>
Si quieres una base de datos que slo se pueda leer pon los permisos de sus archivos Scid, o al menos de su archivo ndice, por ejemplo: <br><li><b>chmod a-w miarchivo.si</b><br> como un comando de un interprete de ordenes para un sistema operativo, y ser abierta por Scid como de slo lectura.
</p>
<p>
La barra de estado tambin muestra cuntas partidas hay actualmente en el <a Searches Filter>filtro</a>.
</p>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}


####################
### Database switcher help:

set helpTitle(S,Switcher) "Intercambiador de Bases de Datos"
set helpText(S,Switcher) {<h1>La ventana del Intercambiador de Bases de Datos</h1>
<p>
La ventana del Intercambiador de Bases de Datos proporciona una presentacin que hace fcil el intercambio entre bases de datos o la copia de partidas entre bases de datos. Se muestra el nombre, el estado del <a Searches Filter>filtro</a> y el tipo de icono grfico de cada base de datos, siendo puesta de relieve la base de datos activa mediante un fondo amarillo.
</p>
<p>
Puedes abrir el intercambiador de bases de datos desde el men <menu>Ventanas</menu>, o mediante la combinacin de teclas: <b>Control+D</b>.
</p>
<p>
Para cambiar de base de datos tan slo debes apretar el botn izquierdo del ratn cuando ests sobre ella.
</p>
<p>
Para copiar todas las partidas filtradas de una base de datos a otra debes arrastra con el botn izquierdo del ratn desde la base de datos fuente hasta la base de datos deseada; entonces vers un dilogo de confirmacin, o un mensaje de error si las partidas no pueden ser copiadas.
</p>
<p>
Presionando el botn derecho del ratn sobre una base de datos se obtiene un men emergente de atributos de la base de datos, desde el que puedes cambiar el tipo de icono de la base de datos o anular su <a Searches Filter>filtro</a>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}


####################
### Entering moves help:

set helpTitle(S,Moves) "Entrada de movimientos"
set helpText(S,Moves) {<h1>Entrada de movimientos de ajedrez</h1>
<p>
En Scid, puedes entrar los movimientos de una partida usando el ratn o el teclado. Cuando mueves el ratn sobre una casilla esta y otra casilla cambian de color si hay un movimiento legal a esta o desde esta casilla. Esto es el <term>movimiento sugerido</term>. Para hacer este movimiento simplemente aprieta el botn <term>izquierdo</term> del ratn. Si esta opcin te molesta puedes desactivar el movimiento sugerido usando el men Opciones.
</p>
<p>
Para hacer cualquier movimiento distinto del movimiento sugerido usa el botn <term>izquierdo</term> del ratn: presiona el botn sobre una casilla y sultalo sobre la casilla deseada.
</p>
<p>
Si prefieres hacer los movimientos mediante dos clicks de ratn en vez de arrastrando puedes usar el botn <term>central</term>: aprieta en una casilla y luego en la otra.
</p>

<h4>Retroceder un atrs</h4>
<p>
Para volver atrs un movimiento aprieta el botn derecho del ratn, esto va hacia atrs un movimiento, y borra el movimiento si este es el ltimo de la partida o variacin.
</p>

<h4>Reemplazar movimientos existentes</h4>
<p>
Cuando introduces un movimiento en un punto de la partida donde ya existe un movimiento Scid muestra una caja de dilogo preguntando si realmente quieres reemplazar el movimiento existente (este y todos los movimientos posteriores se perderan), o si, por contra, quieres aadirlo como una variacin. Algunas personas consideran molesta esta caja de dilogo puesto que siempre desean reemplazar el movimiento existente, si es as puedes desactivarla con la opcin de men "<i>Preguntar antes de reemplazar movimientos</i>" yendo al men <menu>Opciones: Movimientos</menu>.
</p>

<h4>Trial mode</h4>
<p>
If you are studying a game and reach a position where you want to try
an alternative variation on the board without altering the game, select
<b>Try variation</b> from the <menu>Edit</menu> menu to enter trial
mode. In this mode, you can make temporary moves and changes to the
game, then return to the original position when you exit trial mode.
</p>

<h3><name Mistakes>Correccin de errores</name></h3>
<p>
Si estas introduciendo una partida y de pronto ves un movimiento incorrecto varios movimientos antes es posible corregirlo sin perder los movimientos posteriores que has introducido. La nica manera es editando la representacin PGN de la partida: abre la ventana <a Import>Importar</a>, selecciona "Pegar partida actual", corrige el movimiento equivocado y selecciona "Importar".
</p>

<h3>Entrada de movimientos con el teclado</h3>
<p>
Para entrar movimientos con el teclado nicamente se usan teclas de letras y dgitos. Observa que los movimientos aceptados deben de estar en <term>notacin SAN</term>, <i>sin</i> el smbolo de captura (x) o de promocin (=). Los movimientos son identificados de manera insensible, por lo que puedes teclear, por ejemplo, <key>nf3</key> en vez de Nf3 -- mira la nota que hay ms abajo sobre conflictos con movimientos de peones.
</p>
<p>
Para asegurar que ningn movimiento es un prefijo de algn otro movimiento la notacin para el enroque corto y el enroque largo es <key>OK</key> y <key>OQ</key> respectivamente, en vez de la usual O-O y O-O-O.
</p>
<p>
Cuando entres un movimiento la barra de estado mostrar la lista de posibles movimientos. Puedes presionar la <key>barra espaciadora</key> en cualquier momento para escoger el primer movimiento mostrado en la lista y aadirlo a la partida. Para borrar un carcter presiona la tecla de <key>Borrar</key> (encima de Return) o <key>Suprimir</key>.
</p>
<p>
<b>Fijate</b> que una letra minscula representa primero a un pen, por lo que como <key>b</key> puede representar a un pen o a un alfil, si hay un conflicto debes usar una <key>B</key> mayscula para el movimiento del alfil.
</p>

<h4>Teclado Inteligente</h4>
<p>
En el men opciones puedes activar o desactivar la opcin <term>Teclado Inteligente</term>. Con la opcin teclado inteligente se hace un movimiento en cuanto se a escrito lo suficiente para distinguirlo de otros movimientos legales. Por ejemplo, con teclado inteligente, slo necesitaras teclear <key>nf</key> en vez de <key>nf3</key> para el movimiento <b>Nf3</b> en la posicin inicial.
</p>

<h4>Entrada de smbolos comunes de comentario</h4>
<p>
Puedes tambin aadir <a NAGs>smbolos de comentario</a> comunes mediante el teclado en la ventana principal, sin necesidad de usar la ventana del <a Comment>editor de comentarios</a>. La siguiente lista muestra cuales son los smbolos que puedes aadir, y su secuencia de teclas:
<ul>
<li> !  : [!][Return] </li>
<li> ?  : [?][Return] </li>
<li> !? : [!][?][Return] </li>
<li> ?! : [?][!][Return] </li>
<li> !! : [!][!][Return] </li>
<li> ?? : [?][?][Return] </li>
<li> </li>
<li> +- : [+][-] </li>
<li> +/-        : [+][/] </li>
<li> += : [+][=] </li>
<li> =  : [=][Return] </li>
<li> -+ : [-][+] </li>
<li> -/+        : [-][/] </li>
<li> =+ : [=][+] </li>
</ul>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}

####################
### Hints page:
set helpTitle(S,Hints) "Sugerencias de Scid"
set helpText(S,Hints) {<h1>Sugerencias de Scid</h1>
<p>
Esta pgina contiene sugerencias en formato de preguntas y respuestas para ayudarte a usar Scid mejor. Si eres un nuevo usuario de Scid, por favor lee la <a Guide>gua rpida</a> primero. Mucha de la informacin de esta pgina esta disponible, con ms detalle, en otras pginas mostradas en el <a Index>ndice</a>. Si piensas una sugerencia til para aadir a esta pgina, por favor envala al <a Author>creador de Scid</a>.
</p>

<h4>Cmo puedo conseguir que Scid cargue una base de datos cuando se arranca?</h4>
<p>
S, puedes aadir bases de datos, archivos PGN o <a EPD>archivos de posiciones</a> en la lnea de comandos. Por ejemplo:
<br><li><b>scid  mibase  partidas.pgn.gz</b>
<br>cargar la base de datos Scid mibase y adems cargar el archivo PGN comprimido en Gzip <b>partidas.pgn.gz</b>.
</p>

<h4>Hay una manera ms fcil de cambiar el tamao del tablero que teniendo que usar el men de opciones?</h4>
<p>
S, se puede usar la combinacin de teclas <b>Control+Maysculas+flecha izquierda</b> y <b>Control+Maysculas+flecha derecha</b> para disminuir o aumentar el tamao del tablero.
</p>

<h4>Estoy entrenando jugando a travs de una partida, por lo que no quiero que Scid muestre el siguiente movimiento en el rea de informacin de la partida. Cmo puedo hacer que no se muestre?</h4>
<p>
Puedes hacer que no se muestre el siguiente movimiento presionando el botn <b>derecho</b> del ratn en el rea de informacin de la partida, y seleccionando <b>Esconder el siguiente movimiento</b> en el men que aparece.
</p>

<h4>Cmo puedo ver el cdigo ECO de apertura de la posicin actual?</h4>
<p>
El cdigo ECO se muestra en la ltima lnea del rea de informacin de la partida, debajo del tablero de ajedrez en la <a MainWindow>ventana principal</a>, si tienes el archivo de clasificacin ECO (<b>scid.eco</b>) cargado. <br>
La pgina de ayuda de los <a ECO>cdigos ECO</a> explica cmo cargar el archivo de la clasificacin ECO y cmo salvar la opcin para que sea cargada cada vez que se inicie Scid.
</p>

<h4>Estoy introduciendo una partida y estoy en el movimiento 30, y entonces me doy cuenta que el nmero 10 est equivocado. Cmo puedo corregirlo y conservar todos los movimientos posteriores?</h4>
<p>
Puedes usar la ventana de <a Import>Importacin</a>; mira en la pgina de ayuda <a Moves Mistakes>entrada de movimientos</a> para obtener ms ayuda.
</p>

<h4>Cmo puedo copiar partidas de una base de datos a otra?</h4>
<p>
Usa la <a Switcher>ventana del intercambiador de bases de datos</a>: arrastra desde la base de datos fuente a la base de datos elegida para copiar todas las partidas <a Searches Filter>filtradas</a> en la base de datos fuente.
</p>

<h4>Cada vez que entro un movimiento donde ya existe uno aparece  la caja de dilogo "Reemplazar movimiento?", Cmo puedo evitarlo?</h4>
<p>
Desactvala con la opcin <b>Preguntar antes de reemplazar movimientos</b> que hay en el men <menu>Opciones: Movimientos</menu>. O adopta el hbito de suprimir movimientos usando el botn derecho del ratn, el cual realmente borra el movimiento de la partida si te encuentras en el ltimo movimiento de la partida.
</p>

<h4>Cmo puedo cambiar la anchura de las columnas en la ventana del Listado de Partidas?</h4>
<p>
Aprieta el botn derecho o izquierdo del botn en cada ttulo de las columnas.
</p>

<h4>Cmo puedo usar la ventana de rbol para las partidas seleccionadas, y no para toda la base de datos?</h4>
<p>
Usa la <a Clipbase>base de trabajo</a>. Haz el filtrado de la base de datos que contiene las partidas en las que quieres usar el rbol, y cpialo a la base de trabajo usando el <a Switcher>intercambiador de bases de datos</a>. Entonces slo tienes que abrir la ventana de rbol en la base de trabajo.
</p>

<h4>El rbol es lento con bases de datos grandes. Cmo puedo aumentar su velocidad?</h4>
<p>
Guardar el archivo cach con frecuencia, para guardar los resultados del rbol para su futuro uso. Ver la seccin sobre cache de la pgina de ayuda del <a Tree>rbol</a> para ms detalles.
</p>

<h4>Cmo puedo editar la representacin PGN de una partida directamente?</h4>
<p>
No puedes usar la ventana <a PGN>PGN</a> para editar la partida actual, pero an as puedes editar su representacin PGN usando la ventana <a Import>Importar partida</a>. Simplemente brela (combinacin de teclas: <b>Control+Mayusculas+I</b>) y el botn <b>Pegar partida actual</b>, entonces edita la partida, y despus aprieta <b>Importar</b>.
</p>

<h4>Mi base de datos tiene muchas ortografas distintas para algunos nombres de jugadores. Cmo puedo corregirlas todas?</h4>
<p>
Puedes editar los nombres individualmente o chequear ortogrficamente todos los nombres en una base de datos con los comandos que hay en el men <menu>Archivo: Mantenimiento</menu>. Ver la pgina de <a Maintenance Editing>mantenimiento</a>.
</p>

<h4>Tengo dos bases de datos abiertas: una con mis partidas, y una gran base de datos de partidas de grandes maestros. Cmo puedo comparar una de mis partidas con las de la base de datos grande?</h4>
<p>
En la base de datos grande abre la <a Tree>ventana de rbol</a> y presiona el botn <term>Bloqueo</term> para bloquear el rbol de esta base de datos. Entonces cambia a la otra base de datos, el rbol continua mostrando los datos de la base de datos grande.
</p>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}

####################
### Menus help screen:

set helpTitle(S,Menus) "Mens"
set helpText(S,Menus) {<h1>Mens de Scid</h1>

<h3><name File>Archivo</name></h3>
<ul>
<li><menu>Nuevo</menu>: Crea una nueva base de datos Scid vaca.</li>
<li><menu>Abrir</menu>: Abre una base de datos Scid ya existente.</li>
<li><menu>Cerrar</menu>: Cierra la base de datos Scid activa.</li>
<li><menu>Mantenimiento</menu>: Funciones de <a Maintenance>mantenimiento</a> de la base de datos.</li>
<ul>
  <li><menu>Ventana de mantenimiento</menu>: Abre/cierra la ventana de mantenimiento de la base de datos Scid.</li>
  <li><menu>Borrar partidas dobles</menu>: Encuentra partidas dobles y las marca como borradas.</li>
  <li><menu>Clasificar partidas por ECO</menu>: Recalcula el <a ECO>cdigo ECO</a> de todas las partidas de la base de datos</li>
<li><menu>Editor de nombres</menu>: Reemplaza todos los diferentes nombres de un jugador, evento, sitio o ronda.</li>
</ul>
<li><menu>Read-Only</menu>: Hace que la actual base de datos sea de slo lectura.</li>
<li><menu>Base 1/2/3/4</menu>: Estos comandos te permiten cambiar entre los tres lugares disponibles para bases de datos y la <a Clipbase>base de trabajo</a>.</li>
<li><menu>Archivos de posiciones (EPD)</menu>: Abre o crea un <a EPD>archivo de posiciones</a> Scid.</li>
<li><menu>Salir</menu>: Salir de Scid.
</ul>

<h3>Editar</h3>
<ul>
<li><menu>Aadir variacin</menu>: Aade una nueva variacin, vaca, para el siguiente movimiento, o para el movimiento previo si no hay todava un siguiente movimiento.</li>
<li><menu>Borrar variacin</menu>: Proporciona un submen de variaciones para el movimiento actual, en el que puedes borrar las que quieras.</li>
<li><menu>Convertir en primera variacin</menu>: Hace que una variacin sea la primera en la lista para el movimiento actual.</li>
<br>
<li><menu>Poner a cero la base de trabajo</menu>: Vaca la <a Clipbase>base de trabajo</a> para que est completamente vacia.</li>
<li><menu>Copiar esta partida a la base de trabajo</menu>: Copia la partida actual a la <a Clipbase>base de trabajo</a>.</li>
<li><menu>Pegar la ltima partida de la base de trabajo</menu>: Pega la partida activa de la <a Clipbase>base de trabajo</a> para que sea la partida activa en la actual base de datos.</li>
</ul>

<h3>Partida</h3>
<ul>
<li><menu>Limpiar partida</menu>: Devuelve la partida activa a un estado vacio, descartando cualquier cambio no salvado.</li>
<li><menu>Setup start board</menu>: Pone la posicin inicial de la actual partida.</li>
<li><menu>Cargar partida anterior/siguiente</menu>: Carga la partida anterior/siguiente del <a Searches Filter>filtro</a>.</li>
<li><menu>Recargar partida actual</menu>: Vuelve a cargar la partida actual, descartando cualquier cambio hecho.</li>
<br>
<li><menu>Guardar: Reemplazar partida</menu>: Guarda esta partida, reemplazando la antigua versin en la base de datos.</li>
<li><menu>Guardar: Aadir nueva partida</menu>: Guarda esta partida como una nueva partida, anexionndola al final de la base de datos.</li>
<br>
<li><menu>Ir a la posicin ECO ms avanzada</menu>: Encuentra la posicin ms avanzada de la partida que est en el archivo ECO.</li>
</ul>

<h3>Buscar</h3>
<ul>
<li><menu>Poner a cero el filtro</menu>: Pone a cero el <a Searches Filter>filtro</a> para que todas la partidas esten incluidas.</li>
<li><menu>Invertir filtro</menu>: Invierte el filtro para que as slo se incluyan las partidas que estaban excluidas.</li>
<br>
<li><menu>Tablero actual</menu>: Busca por la posicin  del <a Searches Board>tablero actual</a>.</li>
<li><menu>Material/Patrn</menu>: Busca por <a Searches Material>material</a> o patrn del tablero</a>.</li>
<li><menu>Encabezamiento</menu>: Busca por la informacin del <a Searches Header>encabezamiento</a>, como puede ser, por ejemplo, nombre de jugadores.</li>
<br>
<li><menu>Usar archivo de bsqueda</menu>: Busca usando un archivo de <a Searches Settings>opciones</a> de bsqueda.</li>
</ul>

<h3>Ventanas</h3>
<ul>
<li><menu>Editor de Comentarios</menu>: Abre/cierra la ventana del <a Comment>Editor de Comentarios</a>.</li>
<li><menu>Ventana de Listado de partidas</menu>: Abre/cierra la <a GameList>Ventana de Listado de partidas</a>.</li>
<li><menu>Ventana PGN</menu>: Abre/cierra la <a PGN>ventana PGN</a>.</li>
<br>
<li><menu>Intercambiador de bases de datos</menu>: Abre/cierra la ventana del <a Switcher>Intercambiador de bases de datos</a>, el cual te permite cambiar a otra base de datos o copiar fcilmente partidas entre bases de datos.</li>
<li><menu>Ventana de mantenimiento</menu>: Abre/cierra la ventana de mantenimiento de la base de datos Scid.</li>
<br>
<li><menu>ECO Browser</menu>: Abre/cierra la ventana del <a ECO browser>Buscador ECO</a>.</li>
<li><menu>Repertoire editor</menu>: Abre/cierra el <a Repertoire>editor de repertorio</a>.</li>
<li><menu>Ventana de estadsticas</menu>: Abre/cierra la <term>Ventana de estadsticas del filtro</term> la cual muestra una recopilacin de las partidas ganadas/perdidas dentro del <a Searches Filter>filtro</a>.</li>
<li><menu>Ventana de rbol</menu>: Abre/cierra la <a Tree>ventana de rbol</a>.</li>
<li><menu>Endgame Tablebase window</menu>: Abre/cierra la ventana que muestra informacin de las <a TB>tablebases</a>.</li>
</ul>

<h3>Herramientas</h3>
<ul>
<li><menu>Ventana de anlisis</menu>: Inicia/para el anlisis del motor de ajedrez, mostrando la valoracin de la posicin actual en la <a Analysis>ventana de anlisis</a>.</li>
<li><menu>Tabla cruzada</menu>: Construye una <a Crosstable>tabla cruzada</a> del torneo de la partida actual.</li>
<li><menu>Administrador de Email</menu>: Abre/cierra la ventana del <a Email>administrador de Email</a>, para administrar la correspondencia de Email.</li>
<br>
<li><menu>Opening report</menu>: Genera un <a OpReport>informe de la apertura</a> para la actual posicin.</li>
<li><menu>Player information</menu>: Muestra la <a PInfo>informacin del jugador</a> para uno o dos jugadores de la actual partida.</li>
<li><menu>Rating graph</menu>: Muestra el <a Graphs Rating>grfico de clasificacin</a>.</li>
<li><menu>Score graph</menu>: Muestra el <a Graphs Score>grfico de puntuacin</a>.</li>
<br>
<li><menu>Exportar la partida actual</menu>: Escribe la partida actual en un archivo de texto en formato PGN, HTML or LaTeX. Ver la ayuda de la pgina <a Export>exportar</a>.</li>
<li><menu>Exportar todas las partidas filtradas</menu>: Escribe todas las partidas del <a Searches Filter>filtro</a> de bsqueda en un archivo de texto en formato PGN, HTML or LaTeX. Ver la ayuda de la pgina <a Export>exportar</a>.</li>
<br>
<li><menu>Importar partida PGN</menu>: Abre la <a Import>ventana Importar</a> para anotar una partida escribiendo o pegando su texto en <a PGN>formato PGN</a>.</li>
</ul>

<h3>Opciones</h3>
<p>
Esta ventana proporciona el acceso para fijar la mayor parte de las opciones configurables de Scid.
La entrada de datos <menu>Guardar opciones</menu> guarda las opciones actuales en el archivo "<b>.scid</b>" de tu librera de uso (o para los usuario de Windows en <b>scid.opt</b> en el directorio del ejecutable de Scid).
</p>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}


########################################
### Searches help screen:

set helpTitle(S,Searches) "Bsquedas"
set helpText(S,Searches) {<h1>Bsquedas con Scid</h1>
<p>
Scid puede ejecutar muchos tipos diferentes de bsqueda en una base de datos. Los tres tipos de bsqueda principales son:
<ul>
<li><b>1)</b> para el tablero actual, </li>
<li><b>2)</b> por material especificado o modelo de distribucin de piezas, y </li>
<li><b>3)</b> por informacin de la cabecera, como jugador, resultado, fecha,...</li>
</ul>
<p>
Adems de estas, hay tambin un modo de bsqueda automtica llamado <a Tree>ventana de rbol</a> el cual se explicar separadamente.
</p>

<h3><name Filter>Filtro de Bsqueda</name></h3>
<p>
En Scid las bsquedas se basan en el concepto de <term>filtro</term>.
El filtro representa un subconjunto de la base de datos actualmente en uso; en cualquier momento cada partida puede ser incluida o excluida del filtro.
</p>
<p>
Con cada tipo de bsqueda puedes optar por restringir el filtro existente, aadirlo a l, o ignorarlo y buscar en toda la base de datos. Esta capacidad de eleccin permite complejas bsquedas construidas por partes.
</p>
<p>
Adems puedes copiar todas las partidas del filtro de una base de datos a otra, usando la ventana del <a Switcher>intercambiador de bases de datos</a>.
</p>
<p>
En las bsquedas por posicin exacta, <a Tree>rbol</a> o material/modelo, es recordado el nmero de la primera posicin coincidente de cada partida concordante, por lo que cuando cargas cada partida esta muestra automticamente la posicin coincidente.
</p>
<p>
<b>Nota</b> estas bsquedas slo se aplican a la lnea principal de movimientos de la partida, y no a los movimientos de las variaciones.
</p>

<h3><name Board>Bsqueda: Tablero Actual</name></h3>
<p>
Esta bsqueda encuentra partidas que contienen la posicin actualmente mostrada, ignorando las reglas del enroque y <i>al paso</i>.
</p>
<p>
Hay cuatro tipos de bsquedas por tablero disponibles. Las cuatro precisan de una posicin que tenga exactamente el mismo material y lado que mueva para poder corresponderse.
Los tipos son:
<ul>
<li>[1] exacta (las dos posiciones deben de corresponderse en cada casilla),</li>
<li>[2] peones (la estructura de peones debe corresponderse exactamente, pero las piezas pueden estar en cualquier sitio),</li>
<li>[3] columnas (el nmero de peones blancos y negros de cada columna debe ser exactamente el pedido, por contra las piezas pueden estar en cualquier sitio), y</li>
<li>[4] material (los peones y las piezas pueden estar en cualquier sitio).
La bsqueda por peones es til para estudiar aperturas por estructura de peones, y las bsquedas por columnas y material son tiles para encontrar posiciones similares en un final de partida.</li>
</ul>
<p>
Para buscar una posicin determinada puedes poner la posicin primero (desde el men <menu>Partida: Iniciar tablero de posicin</menu>) y entonces iniciar la bsqueda.
</p>
<p>
Puedes pedir que la bsqueda mire en las variaciones (en vez de slo la lnea principal de las partidas)seleccionando la casilla <b>Mirar en variaciones</b>, pero esto puede hacer la bsqueda mucho ms lenta si la base de datos es larga y tiene muchas partidas con variaciones.
</p>

<h3><name Material>Bsqueda: Material/Modelo</name></h3>
<p>
Esta bsqueda es til para encontrar temas de finales o medio juego. Puedes especificar la cantidad mnima y mxima para cada tipo de material, y encontrar modelos como un Alfil en f7, o un pen en la columna f.
</p>
<p>
Se facilitan algunas disposiciones comunes de material o de modelos, como finales de Torre contra pen, o peones de Dama aislados.
</p>
<p>
<b>Sugerencias:</b><br>
La velocidad de las bsquedas por modelo puede variar ampliamente. Puedes reducir el tiempo necesario para una bsqueda fijando restricciones de manera inteligente. Por ejemplo, si fijas el mnimo nmero de movimientos para un final en 20 todas las partidas que finalizan en menos de 20 movimientos sern saltadas.
</p>

<h3><name Header>Bsqueda: Cabecera</name></h3>
<p>
Esta bsqueda puede ser usada para encontrar caractersticas de una partida que se encuentran almacenadas en la cabecera (como puede ser fecha, resultado, nombres, seales y clasificaciones), las cuales no necesitan decodificar ningn movimiento.
</p>
<p>
Para que una partida se corresponda con una bsqueda por cabecera, <b>todos</b> los campos que especifiques se deben corresponder.
</p>
<p>
Los campos con nombre (blancas, negras, evento y lugar) corresponden con cualquier texto dentro del nombre, de manera insensible e ignorando espacios.
</p>
<p>
Puedes hacer bsquedas ms ajustadas usando comodines (representando <b>?</b> un caracter y <b>*</b> representando cero o ms caracteres) poniendo el texto entre comillas. Por ejemplo, una bsqueda para el lugar <b>USA</b> encontrar ciudades americanas pero tambin <b>Lausanne SUI</b>, lo cual seguramente no es lo que buscas! Una bsqueda por el lugar <b>"*USA"</b> (acurdate de usar las comillas) slo mostrar ciudades de los Estados Unidos.
</p>
<p>
Si estas buscando un jugador en concreto (o pareja de oponentes) tanto para Blanco como para Negro (no importa con el color que jug), selecciona la opcin <b>Ignorar Colores</b>.
</p>

<h3><name Settings>Guardar opciones de bsqueda</name></h3>
<p>
Las ventanas de bsqueda por Material/Modelo y Cabecera facilitan un botn para <term>Guardar opciones</term>. Esto te permite guardar las opciones de bsqueda para usarlas posteriormente, en un archivo de <term>OpcionesBsqueda</term> (extensin .sso).
Para bsquedas usando un archivo OpcionesBsqueda (.sso) previamente guardado, selecciona <menu>Abrir</menu> desde el men <menu>Bsqueda</menu>.
</p>

<h3>Tiempos de bsqueda y partidas saltadas</h3>
<p>
Muchas bsquedas proporcionan un mensaje indicando el tiempo usado y el nmero de partidas que se han <term>saltado</term>. Una partida saltada es aquella que puede se excluida de la bsqueda sin decodificar ninguno de sus movimientos, basndose en la informacin almacenada en su ndice. Ver la pgina de ayuda de los <a Formats>formatos de archivos</a> para obtener ms informacin.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}


###############################
### Clipbase help:

set helpTitle(S,Clipbase) "La Base de Trabajo"
set helpText(S,Clipbase) {<h1>La base de datos Base de Trabajo</h1>
<p>
Adems de las bases de datos que tienes abiertas, Scid proporciona una <term>base de trabajo</term>, la cual es como otra base de datos excepto que esta slo existe en memoria y no tiene archivos para un almacenamiento permanente.
</p>
<p>
La base de trabajo es til como base de datos temporal, para fusionar los resultados de bsqueda realizados en ms de una base de datos o para procesar los resultados de una bsqueda como una base de datos separada.
</p>
<p>
Por ejemplo, supongamos que te estas preparando contra un oponente y has buscado una base de datos en la que el <a filter>filtro</a> contiene slo partidas donde el oponente a jugado con blancas. Puedes copiar estas partidas a la base de trabajo (arrastrando desde su base de datos a la base de trabajo en la ventana del <a Switcher>intercambiador de bases de datos</a>); cambia a la base de trabajo, y entonces abre la <a Tree>Ventana de rbol</a> para examinar su repertorio de juego.
</p>
<p>
Observa que puedes copiar las partidas del filtro de una base de datos directamente a otra base de datos abierta (sin necesidad de usar la base de trabajo como ubicacin intermedia) usando la ventana del <a Switcher>intercambiador de bases de datos</a>.
</p>
<p>
Observa que la base de trabajo <i>no puede</i> ser cerrada; seleccionando el comando <menu>Archivo: Cerrar</menu> en la base de trabajo esto equivale a <menu>Editar: Poner a cero la base de trabajo</menu> lo cual vaca la base de trabajo.
</p>
<p>
La base de trabajo tiene siempre un lmite de 10000 partidas, desde que ella existe slo en memoria.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}


###############################
### Comment editor window help:

set helpTitle(S,Comment) "Ventana del Editor de Comentarios"
set helpText(S,Comment) {<h1>La ventana del Editor de Comentarios</h1>
<p>
La ventana del Editor de Comentarios permite aadir o editar comentarios y anotaciones de smbolos a los movimientos de la partida de ajedrez activa.
</p>

<h3>Anotaciones de smbolos</h3>
<p>
Scid usa el <a Author Related>estndar PGN</a> para la anotacin de smbolos, aceptando valores <a NAGs>NAG (numeric annotation glyph)</a> para las anotaciones.
Algunos de los smbolos ms comunes (como son "!" o "+-") son presentados como smbolos, y tienen un botn en la ventana del editor de comentarios para poder introducirlos rpidamente. Para otros smbolos, puedes introducir el valor numrico NAG apropiado, el cual es un nmero entre 1 y 255.
Por ejemplo, el valor NAG 36 significa "Blancas tienen la iniciativa" y ser mostrado como "$36" en el <a PGN>texto PGN</a> de la partida.
</p>
<p>
Ver la pgina de ayuda de los <a NAGs>valores NAG</a> para ver los valores NAG definidos por el estndar PGN.
</p>
<p>
<b>Sugerencia:</b> Puedes aadir los smbolos de evaluacin comunes (!, ?, !!, ??, !? y ?!) incluso en la ventana principal, sin necesidad de usar la ventana del editor de comentarios, escribiendo el smbolo seguido de la tecla <key>Return</key>. Esto es especialmente si ests <a Moves>anotando los movimientos</a> usando el teclado.
</p>

<h3>Comentarios</h3>
<p>
Puedes editar comentarios escribiendo en el rea de texto que se facilita y usando los botones Limpiar, Retroceder y Almacenar.
No necesitas apretar el botn Almacenar para actualizar un comentario; este es automticamente actualizado en cualquier momento que te muevas a otra posicin de la partida.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Crosstable window help:

set helpTitle(S,Crosstable) "Ventana de Tabla Cruzada"
set helpText(S,Crosstable) {<h1>La ventana de Tabla Cruzada</h1>
<p>
La ventana de tabla cruzada muestra la tabla cruzada del torneo al que pertenece la partida actual. Cada vez que actualices la ventana de tabla cruzada (apretando su botn de actualizacin, apretando la tecla <b>Return</b> en la ventana de tabla cruzada, o con <b>Control+Shift+X</b> en las ventanas <a MainWindow>principal</a> o <a GameList>listado de partidas</a>), Scid buscar todas las partidas jugadas en el mismo torneo que la partida actual.
</p>
<p>
Cualquier partida jugada <b>dos meses antes o despus</b> que la partida actual, con <b>exactamente el mismo Evento y Lugar</b>, es considerada como perteneciente al torneo.
</p>
<p>
Un click del botn izquierdo del ratn sobre cualquier resultado de la tabla carga la partida correspondiente. Puedes aadir todas las partidas del torneo al <a Searches Filter>filtro</a> con el botn <b>Aadir al filtro</b> de la ventana de tabla cruzada.
</p>

<h4>Mens de la ventana de tabla cruzada</h4>
<p>
El men <menu>Archivo</menu> permite guarda la tabla actual a un archivo de texto sin formato o a una tabla en formato HTML.
</p>
<p>
El men <menu>Mostrar</menu> permite escoger el formato de la tabla:
<b>Todos contra todos</b>, <b>Suizo</b> o <b>Eliminatoria directa</b>.
</p>
<p>
El formato todos contra todos tiene un lmite de 30 jugadores, pero el formato Suizo (para torneos con muchos jugadores) puede mostrar ms de 200 jugadores y ms de 20 rondas.
</p>
<p>
Obsrvese que Scid usa la entrada <b>Ronda</b> de cada partida para construir la tabla cruzada de Suizos, por lo que no se ver ninguna partida en la tabla de Suizo de un torneo si las partidas no tienen un valor numrico para la ronda: 1, 2, 3, etc.
</p>
<p>
El men Mostrar adems permite configurar los datos presentados a tu gusto, para incluir o excluir clasificaciones, pases y tratamiento del jugador. Adems puedes escoger si el color asignado en las tablas de Suizos es mostrado o no.
</p>
<p>
La opcin <b>Separar por grupos de clasificacin</b> slo afecta a la presentacin de la tabla cuando los jugadores son ordenados por su clasificacin: inserta una lnea en blanco entre cada grupo de jugadores con la misma clasificacin.
</p>
<p>
El men <menu>Ordenar</menu> te permite ordenar los jugadores por nombre, clasificacin o puntuacin; por defecto lo hace por puntuacin.
</p>
<p>
El men <menu>Texto</menu> te permite cambiar el color de presentacin (hipertexto) entre encendido y apagado. Puesto que puede llevar mucho tiempo el dar forma y mostrar grandes tablas cruzadas en hipertexto, seleccionando <b>Texto sin formato</b> para los eventos largos se puede ganar mucho tiempo. Sin embargo con texto sin formato no se puede pinchar sobre los jugadores o las partidas.
</p>

<h4>Partidas duplicadas en la tabla cruzada</h4>
<p>
Para obtener buenos resultados con la tabla cruzada debes marcar las partidas duplicadas para ser borradas y tus partidas deben tener una ortografa uniforme de los nombres de los jugadores, lugares y eventos.
Ver la pgina de <a Maintenance>mantenimiento de la base de datos</a> para obtener ayuda sobre el borrado de partidas duplicadas y la edicin (o comprobacin ortogrfica) de los nombres de jugadores/eventos/lugares.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### File Finder window help:
set helpTitle(S,Finder) "Ventana del Visor de Archivos"
set helpText(S,Finder) {<h1>La ventana del Visor de Archivos</h1>
<p>
El <term>Visor de Archivos</term> te ayuda a ver cualquier tipo de archivo que p
uedas usar en Scid: bases de datos, archivos <a PGN>PGN</a>, archivos <a EPD>EP
D</a>, y archivos de <a Repertoire>repertorio</a>.
</p>
<p>
El visor muestra informacin til sobre cada archivo, como su tamao (ver ms ab
ajo) y fecha de ltima modificacin. Puedes abrir cualquier archivo mostrado sel
eccionndolo con el botn izquierdo del ratn.
</p>

<h3>Mirando en subdirectorios</h3>
<p>
Cuando desees comprobar todos los archivos de todos los subdirectorios del direc
torio actual, activa el recuadro <b>Mirar en subdirectorios</b>. Esto har que S
cid examine recursivamente cada subdirectorio en busca de archivos que puedan se
r abiertos por Scid. Esto puede tomar largo tiempo si hay muchos subdirectorios,
 por lo que no debes hacer esto en un directorio cercano al directorio raz. Pue
des interrumpir la bsqueda de archivos presionando el botn <b>Parar</b>.
</p>

<h3>Tamaos de archivo</h3>
<p>
El significado del tamao del archivo mostrado por el visor depende del tipo de
archivo. Para bases de datos Scid y archivos PGN, es el nmero de partidas. Para
 archivos EPD, es el nmero de posiciones. Para archivos de repertorio, es el n
mero de lneas (incluidas o excluidas.
</p>
<p>
Para todos los tipos de archivo excepto bases de datos Scid, el tamao del archi
vo es una estimacin tomando como muestra los primeros 64 kilobytes del archivo,
 por lo que el tamao puede no ser correcto para archivos mayores de 64 kb. Los
tamaos estimados se muestran con una tilde (~) para indicar que no son exactos.
</p>

<p><footer>(Actualizado: Scid 2.7, Septiembre 2001)</footer></p>
}

####################
### Tournament Finder window help:

set helpTitle(S,Tmt) "Ventana del Visor de Torneos"
set helpText(S,Tmt) {<h1>La ventana del Visor de Torneos</h1>
<p>
El <term>Visor de Torneos</term> te permite encontrar torneos en la base de dato
s actual. Explora todas las partidas de la base de datos y compara los datos sob
re los torneos encontrados. Ten en cuenta que dos partidas se considera que son
del mismo torneo si tienen la misma etiqueta de Evento, la misma etiqueta de Lug
ar y han sido jugadas como mximo con dos meses de diferencia.
<p>
Puedes limitar la lista de torneos por el nmero de jugadores y partidas, fecha,
 media de Elo y pas, editando los campos por debajo de la lista de torneos y pr
esionando el botn <b>Actualizar</b>.
</p>
<p>
La lista mostrada puede ser ordenada por fecha, nmero de jugadores, nmero de p
artidas, media de Elo, lugar, evento o el apellido del ganador. Selecciona el ti
po desde el men <menu>Ordenar</menu> o pincha en el ttulo de una columna para
cambiar el campo de ordenacin.
</p>
<p>
Para cargar la primera partida de cualquier torneo que se muestre, simplemente p
incha con el botn izquierdo del ratn cuando este se encuentra resaltado. Esto
adems actualiza la ventana de <a Crosstable>Tabla cruzada</a> si se encuentra a
bierta.
</p>
<p>
Para aumentar la velocidad del proceso de bsqueda de torneos, es una buena idea
 introducir un rango de fechas medianamente pequeo (como unos pocos aos como m
ucho) o seleccionar un pas concreto (mediante su cdigo estndar de tres letras
). Haciendo esto se reducir grandemente el nmero de partidas que Scid tiene qu
e considerar cuando trate de formar los torneos fuera de las partidas de la base
 de datos.
</p>

<p><footer>(Actualizado: Scid 2.7, Septiembre 2001)</footer></p>
}

####################
### GameList window help:

set helpTitle(S,GameList) "Ventana de Listado de partidas"
set helpText(S,GameList) {<h1>La ventana de Listado de partidas</h1>
<p>
La ventana de Listado de partidas muestra una lnea sumario para cada partida incluida en el actual <term>filtro</term>.
</p>

<h3>Navegando por la lista de partidas</h3>
<p>
Puedes desplazarte por la lista de partidas usando la barra deslizante o los cuatro botones que hay debajo de la lista.
Tambin puedes usar las teclas <key>Inicio</key>, <key>Fin</key>,
<key>Re Pg</key>, <key>Av Pg</key> y el teclado de flechas para desplazarte usando el teclado.
</p>
<p>
Puedes encontrar la siguiente partida de la lista que tenga cierto texto en los campos blancas, negras, Evento o Lugar usando la caja  <b>Encontrar texto</b>.
</p>

<h3>Acciones sobre las partidas de la lista</h3>
<p>
Para cargar una partida de la lista haz doble click con el botn izquierdo del ratn sobre la partida. Apretando el botn central del ratn se muestran los movimientos iniciales de una partida; esto puede ser til para comprobar la apertura de una partida antes de cargarla.
</p>
<p>
El botn derecho del ratn genera un men para la partida seleccionada, con el cual puedes borrar (o cancelar el borrado, restaurar) la partida, o excluirla del filtro. Observa que borrando una partida slo se activa la marca de borrado; permanece en la base de datos hasta que esta sea compactada, ver <a Compact>compactar</a>.
</p>

<h3>Cambiando la anchura de las columnas en la lista de partidas</h3>
<p>
Aprieta el botn derecho del ratn sobre el ttulo de una columna para hacerla ms alargada, o aprieta el botn izquierdo para hacerla ms corta.
</p>

<h3>Cambiando el tamao del listado de partidas</h3>
<p>
El tamao de la ventana del listado de partidas es guardado en el archivo de opciones siempre que salves las opciones. Por lo que si quieres que el listado de partidas muestre por defecto 10 partidas, slo cambia el tamao de la ventana del listado de partidas y selecciona <menu>Guardar opciones</menu> en el men <menu>Opciones</menu>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Import window help:

set helpTitle(S,Import) "Ventana Importar"
set helpText(S,Import) {<h1>La ventana Importar</h1>
<p>
La ventana de Scid Importar proporciona una manera fcil para pegar una partida en <a PGN>formato PGN</a> dentro de Scid desde alguna otra aplicacin o ventana.
</p>
<p>
El marco grande de la ventana es donde se escribe o pega el texto de una partida en formato PGN, y el marco gris de debajo proporciona la retroinformacin de cualquier error o advertencia.
</p>

<h3>Edicin de la partida actual con la Ventana Importar</h3>
<p>
La ventana Importar adems es la manera ms conveniente de hacer pequeos cambios en la partida actual: puedes pegar la partida actual en la ventana de Importacin (con el botn <b>Pegar partida actual</b>), editar el texto, y apretar <b>Importar</b> cuando est.
</p>

<h3>Etiquetas PGN en la ventana Importar</h3>
<p>
Scid anticipa las etiquetas de la cabecera PGN como
<ul>
<li> <b>[Result "*"]</b>
</ul>
antes de cualquier movimiento; pero puedes pegar solamente un fragmento de partida anlogo a
<ul>
<li> <b>1.e4 e5 2.Bc4 Bc5 3.Qh5?! Nf6?? 4.Qxf7# 1-0</b>
</ul>
sin ninguna etiqueta de cabecera y Scid la importar.
</p>

<h3>Usando archivos PGN en Scid</h3>
<p>
Si quieres usar un archivo en formato PGN en Scid pero no quieres convertirlo primero con <a Pgnscid>pgnscid</a>, hay dos posibles maneras.
</p>
<p>
Primera, puedes importar partidas de un archivo a una base de datos existente con el comando del men <menu>Herramientas: Importar archivo de partidas PGN...</menu>.
</p>
<p>
La alternativa es abrir el archivo PGN directamente en Scid. Sin embargo, los archivos de formato PGN son abiertos como de slo lectura y consumen ms memoria que una base de datos Scid comparable, por lo que esto es slo recomendable para archivos PGN relativamente pequeos.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Exporting help:

set helpTitle(S,Export) "Exportacin de partidas"
set helpText(S,Export) {<h1>Exportacin de partidas</h1>
<p>
Puedes usar comandos mediante el men <menu>Herramientas</menu> para exportar la partida o todas las partidas del filtro actual a un archivo de texto.
</p>
<p>
Hay disponibles tres formatos de archivo: <a PGN>PGN</a> (portable game
notation), HTML (para pginas web) y LaTeX (un sistema popular de composicin tipogrfica).
</p>
<p>
Cuando exportes, puedes decidir crear un nuevo archivo, o aadir las partidas a un archivo ya existente de partidas exportadas por Scid.
</p>

<h3>Diagramas</h3>
<p>
Cuando se exporta a formato HTML o LaTeX, Scid automticamente aadir en la partida un diagrama all donde aparezca un <a NAGs>nag</a> de diagrama ("D") o un <a Comment>comentario</a> que empiece con el caracter "#".
</p>

<h3>Exportacin en HTML</h3>
<p>
Scid puede exportar partidas a un archivo HTML. Para que los diagramas aparezcan, necesitaras que las imgenes de diagrama (distribuidas con Scid, en el directorio "<b>bitmaps/</b>") estn en un subdirectorio <b>bitmaps/</b> dentro del directorio donde se encuentre el archivo HTML.
</p>

<h3>Exportacin en LaTeX</h3>
<p>
Scid puede exportar partidas a archivos LaTeX. Las partidas sern impresas a dos columnas por pgina y los movimientos estarn en notacin algebraica con figuritas.
</p>
<p>
Ver la pgina de ayuda <a LaTeX>Usando LaTeX con Scid</a> para ms informacin.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### LaTeX help:

set helpTitle(S,LaTeX) "Scid y LaTeX"
set helpText(S,LaTeX) {<h1>Usando LaTeX con Scid</h1>
<p>
Scid puede guardar partidas e informes de aperturas en archivos en formato LaTeX. LaTeX es una extensin de TeX, un sistema popular de composicin tipogrfica.
</p>
<p>
Para componer los archivos LaTeX producidos con Scid, debes de tener (por supuesto) LaTeX y tener instalada la fuente "chess12". Esta fuente no es normalmente parte de la instalacin estndar de LaTeX, por lo que si tienes LaTeX puedes no tener la fuente de ajedrez.
</p>
<p>
Para obtener informacin sobre como bajar e instalar la fuente de ajedrez usada con LaTeX, visita la pgina <url http://scid.sourceforge.net/latex.html>Usando LaTeX con Scid</url> en el <url http://scid.sourceforge.net/>sitio web de Scid</url>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### PGN window help:

set helpTitle(S,PGN) "Ventana PGN"
set helpText(S,PGN) {<h1>La ventana PGN</h1>
<p>
La ventana PGN de Scid muestra en la representacin estndar PGN el contenido de la partida actual. En el texto de los movimientos, los comentarios aparecen {entre corchetes} y las variaciones (entre parntesis).
</p>

<h3>Formato PGN</h3>
<p>
PGN (Portable Game Notation) es el estndar comn para transferir partidas de ajedrez entre programas de ordenador. Una partida PGN consiste en dos secciones. La primera es la cabecera, que contiene datos como son <br>
<b>[White "Kasparov, Gary"]</b>
y
<b>[Result "1/2-1/2"]</b>.
</p>
<p>
La segunda seccin contiene los movimientos, actuales, de la partida en la notacin algebraica estndar (standard algebraic notation (SAN)) junto con algunas variaciones, <a NAGs>smbolos de anotacin</a> y <a Comment>comentarios</a>.
</p>

<h3>Acciones en la ventana PGN</h3>
<p>
Puedes usar la ventana PGN para navegar a travs de la partida: apretando el botn izquierdo del ratn sobre un movimiento se salta hasta l. Apretando el botn izquierdo del ratn sobre un comentario se edita este.
</p>

<h3>Opciones de visualizacin PGN</h3>
<p>
Los mens de la ventana PGN contienen opciones que afectan a la visualizacin de esta.
</p>
<p>
Scid puede mostrar las partidas en color o en texto sin formato -- ver el men
<menu>Presentacin</menu> en la ventana PGN. La presentacin en color es ms fcil de leer, y permite seleccionar movimientos y comentarios con el ratn, pero es bastante ms lenta actualizndose. Para partidas muy largas es preferible escoger la presentacin con texto sin formato.
</p>
<p>
Tambin puedes alterar el formato de los comentarios y las variaciones, pudiendo decidir si son mostrados con sangra en una lnea aparte para que tengan una gran visibilidad.
</p>
<p>
Las opciones de presentacin PGN, y el tamao de la ventana PGN, son guardados en el archivo de opciones cada vez que usas en el men de la ventana principal <menu>Opciones</menu> la opcin  <b>Guardar Opciones</b>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Tree window help:

set helpTitle(S,Repertoire) "Editor de Repertorio"
set helpText(S,Repertoire) {<h1>La ventana del editor de Repertorio</h1>
<p>
El editor de repertorio te permite crear, ver y editar archivos de <term>repertorio</term>. Un archivo de repertorio (.sor) es una lista de posiciones de apertura que tratas de alcanzar o de evitar, puedes usarlo para administrar tus preferencias en las aperturas y tambin para buscar en las bases de datos con Scid.
</p>

<h3>Grupos y lneas de repertorio</h3>
<p>
Un repertorio contiene dos tipos de elementos: <term>grupos</term> y
<term>lneas</term>. Los grupos no son realmente parte de tu repertorio; slo son usados para estructurarlo de la misma manera que los directorios dan la estructura a los archivos del disco duro de tu ordenador.
</p>
<p>
Las lneas en un repertorio se organizan en dos tipos: <term>incluir</term> lneas que representan posiciones de apertura en las que ests interesado e intentas alcanzar, y <term>excluir</term> lneas en las que no ests interesado en jugar y que tratas de evitar. Por ejemplo, si juegas QGA (1.d4 d5 2.c4 dxc4) con Negras y tu juegas todos los movimientos despus de 3.e4 <i>excepto</i> 3...Nf6, debers poner 1.d4 d5 2.c4 dxc4 3.e4 como lnea incluida y 1.d4 d5 2.c4 dxc4 3.e4 Nf6 como lnea excluida.
</p>

<h3>Comentarios y notas</h3>
<p>
Cada grupo o lnea puede tener comentarios ligados a estos. Hay dos tipos: cortos (de una sola lnea) aparecen (en rojo) en la estructura del repertorio al lado de los movimientos de un grupo o lnea, por contra los comentarios largos (mltiples lneas) se muestran slo cuando el grupo o lnea es seleccionado.
</p>

<h3>Uso de la ventana del editor de repertorio</h3>
<p>
El lado <b>izquierdo</b> de la ventana muestra la estructura del repertorio. Puedes pinchar en los iconos de carpetas para expandir o colapsar los grupos, y pinchar en los movimientos de un grupo o lnea para seleccionarla y ver sus comentarios. Las lneas incluidas se muestran con una marca azul, y las excluidas con una cruz roja.
</p>
<p>
Si una lnea o grupo tiene un comentario corto este se mostrar despus de los movimientos. Si tiene un comentario largo se indica con la marca <b><red>**</red></b> despus de los movimientos. Los grupos tienen un nmero entre parntesis despus de sus movimientos que muestra el nmero de lneas (directas o indirectas) que contiene.
</p>
<p>
Pinchando con el botn derecho del ratn en un grupo o lnea aparece un men con funciones para l, como su borrado o el cambio de su estado.
</p>
<p>
El lado <b>derecho</b> de la ventana contiene tres marcos. El primer marco es una lista de los movimientos de la lnea o grupo seleccionado. Puedes pinchar con el botn izquierdo del ratn en l para pegar los movimientos en la ventana de <a Import>Importar</a>, lo cual es til para hacer que la partida actual empiece con una lnea del repertorio. El segundo marco contiene el comentario corto de la lnea o grupo, y el tercer marco contiene el comentario largo.
</p>

<h3>Aadir grupos y lneas al repertorio</h3>
<p>
Para aadir una lnea o grupo en la ventana, simplemente haz sus movimientos en el tablero de ajedrez de la ventana principal, entonces usa el men <menu>Editar</menu> del editor de repertorio para aadirlo como un grupo, una lnea incluida o una lnea excluida.
</p>
<p>
Para borrar un grupo o lnea pnchala con el botn derecho del ratn y selecciona la orden apropiada en el men que aparece.
</p>

<h3><name Search>Bsquedas en bases de datos usando archivos de repertorio</name></h3>
<p>
El men <menu>Buscar</menu> del editor de repertorio permite buscar en la base de datos actual usando el repertorio. Cada partida ser buscada para posiciones del repertorio y ser mostrada slo si la posicin del repertorio de <i>mayor profundidad</i>es de una lnea <i>incluida<i>.
</p>
<p>
Puedes escojer entre buscar usando todo el repertorio, o slo las lneas mostradas. La bsqueda de las lneas mostradas es til cuando slo necesitas usar algunas del repertorio. Por ejemplo, un repertorio para las Negras puede tener dos grupos principales en el nivel superior, uno para 1.e4 y otro para 1.d4. Si slo estas interesado en 1.e4, simplemente colapsa el grupo 1.d4 y entonces busca slo para las lneas mostradas.
</p>

<h3>Otras Sugerencias</h3>
<p>
Un archivo de repertorio es muy til para encontrar nuevas partidas con tus maneras de realizar las aperturas. Por ejemplo, cada vez que tengas un nuevo archivo PGN para aadir a tu base de datos principal (como el excelente archivo PGN semanal de <url http://www.chesscenter.com/twic/>The Week In Chess</url>), simplemente abre el archivo PGN con Scid y haz una bsqueda de repertorio. Entonces buscar entre las partidas filtradas para ver todas las partidas jugadas que estn en tu repertorio.
</p>
<p>
Es una buena idea mantener dos archivos de repertorio: uno para las Negras y otro para las Blancas, para poder buscar en cada archivo separadamente.
</p>
<p>
Desde la lnea de comandos puede abrirse un archivo de repertorio, por ejemplo: <br>
<b>scid mibase blancas.sor</b>
</p>
<p>
Puedes editar un archivo de repertorio (.sor) en cualquier editor de texto, pero ten cuidado en preservar su formato pues podra no poder cargarse o buscarse en l con Scid.
</p>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}

####################
### Tree window help:

set helpTitle(S,Tree) "Ventana de rbol"
set helpText(S,Tree) {<h1>La ventana de rbol</h1>
<p>
La ventana de <term>rbol</term> muestra informacin sobre todos los movimientos hechos desde la posicin actual en las partidas de la base de datos. En modo rbol, la ventana de rbol es actualizada automticamente cada vez que el tablero de la ventana principal cambia. Esto puede ser lento para bases de datos grandes.
</p>
<p>
Fjate que cada vez que la ventana de rbol es actualizada el <a Searches Filter>filtro</a> es restaurado y slo las partidas que tienen la posicin actual son incluidas en l.
</p>
<p>
Apretando el botn izquierdo del ratn sobre un movimiento en la ventana de rbol este se aade a la partida.
</p>

<h3>Contenidos de la ventana de rbol</h3>
<p>
La ventana de rbol muestra el <a ECO>cdigo ECO</a> (si hay alguno), frecuencia (en nmero de partidas, y en porcentajes) y la puntuacin para cada movimiento. La <term>puntuacin</term> siempre es calculada desde la perspectiva de las blancas, por lo que 100% significa que las blancas siempre han ganado y 0% que las negras siempre han ganado.
</p>
<p>
Los movimientos en la ventana de rbol pueden ser ordenados por el movimiento en si (alfabticamente), cdigo ECO, frecuencia, o puntuacin. Puedes cambiar el mtodo de ordenacin en el men <menu>Ordenar</menu>.
</p>

<h3><name Graph>Ventana grfica del rbol</name></h3>
<p>
La ventana de rbol incluye un botn denominado <term>Grfico</term> el cual muestra un grfico producido a partir de la ejecucin relativa, porcentajes, de cada movimiento en la posicin actual. Son mostrados todos los movimientos que han sido jugados al menos un 1% de las veces, y al menos 5 veces. Los porcentajes son siempre desde la perspectiva de las blancas, incluso cuando son las negras las que mueven.
</p>
<p>
Una lnea roja muestra en el grfico del rbol el trmino medio de todas las partidas segn la posicin actual, y se muestra el rea entre el 50 y 55% (donde se espera que punten la mayora de las aperturas estndar) en color azul para ayudar a la comparacin de los movimientos. Advierte que las blancas normalmente puntan en torno a 55% en el ajedrez a nivel maestro.
</p>

<h3><name Lock>Bloqueo de la ventana de rbol</name></h3>
<p>
El botn <term>Bloquear</term> de la ventana de rbol puede ser usado para bloquear el rbol en la actual base de datos. De esta manera el rbol continuar usando esa base de datos aunque cambies a otra base de datos abierta. Esto es til si necesitas usar una gran base de datos como referencia mientras juegas a traves de una partida en otra base de datos: simplemente abre el rbol en la base de datos de referencia, bloqualo, y entonces cambia a la otra base.
</p>

<h3><name Training>Entrenamiento</name></h3>
<p>
Cuando se selecciona <term>Entrenamiento</term> en la ventana de rbol Scid hace un movimiento aleatoriamente cada vez que aades un movimiento a la partida. El movimiento que escoge Scid depende de las estadsticas de la base de datos, un movimiento jugado en el 80% de las partidas de la base de datos ser escogido por Scid con una probabilidad del 80%. Es un buen sistema de probar tu conocimiento sobre aperturas: activa esta caracterstica, esconde (o minimiza)  la ventana de rbol y juega aperturas contra una base de datos de gran extensin.
</p>

<h3>Uso del rbol con archivos de Posicin abiertos</h3>
<p>
Para cada <a EPD>archivo de Posicin</a> abierto, la ventana de rbol contendr una columna extra que muestra un corto resumen (cinco caracteres) del contenido del libro de posiciones para cada posicin alcanzada desde los movimientos enumerados.
</p>
<p>
El resumen puede ser una valoracin, un cdigo de apertura o un movimiento sugerido; ser el contenido del primer campo EPD encontrado de la siguiente lista: <b>ce, eco, nic, pv, pm, bm, id</b>, o simplemente el primer campo EPD si no se encuentra ninguno de los citados antes.
</p>
<p>
Para obtener una descripcin de los campos EPD ver la pgina de ayuda de los <a EPD>archivos de Posicin</a>. Date cuenta que si el resumen es del campo <b>ce</b>, este es mostrado como una evaluacin en peones desde la perspectiva de las Blancas (en vez de como centsimas de pen desde la perspectiva del lado que mueve; que es el formato en los archivos de posicin) para as aumentar su legibilidad.
</p>

<h3>Cach para unos resultados ms rpidos</h3>
<p>
Scid mantiene una cach de los resultados de la bsqueda de rbol para las posiciones ms usuales en las partidas. Si mueves hacia adelante o atrs en una partida en el modo de rbol, vers la ventana de rbol actualizada casi instantneamente cuando la posicin buscada est en la cach.
</p>
<p>
La ventana de rbol tiene un comando llamado <term>Guardar archivo Cach</term> en el men archivo. Cuando lo seleccionas, se escriben los contenidos actuales de la cach que hay en la memoria a un archivo (con el sufijo <b>.stc</b>) para, en el futuro, aumentar la velocidad de uso del rbol con esta base de datos.
</p>
<p>
Date cuenta que un archivo de cach del rbol (.stc) es totalmente repetitivo; puedes borrarlo sin afectar a la base de datos, y de hecho este es borrado por Scid cada vez que ocurre una accin que pueda dejarlo anticuado -- por ejemplo, al aadir o reemplazar una partida, u ordenar la base de datos.
</p>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}

####################
### Compaction help:

set helpTitle(S,Compact) "Compactacin de la base de datos"
set helpText(S,Compact) {<h1>Compactacin de la base de datos</h1>
<p>
<term>Compactacin</term> de la base de datos es un tipo especfico de <a Maintenance>mantenimiento</a> que hace una base de datos tan pequea y eficiente como sea posible.
El compactar una base de datos significa que se borra cualquier espacio no utilizado en los archivos. Hay dos tipos: compactacin del archivo de nombres y del archivo de partidas.
</p>

<h3>Compactacin del archivo de nombres</h3>
<p>
Muchas veces puedes encontrar una base de datos que contiene una serie de nombres de jugadores, eventos, lugares o rondas que no son usados en ninguna partida. Esto amenudo sucede despus de que compruebes ortogrficamente los nombres. Los nombres no usados desaprovechan espacio en el archivo de nombres, y pueden enlentecer las bsquedas por nombres. La compactacin del archivo de nombres borra todos los nombres que no son usados en ninguna partida.
</p>

<h3>Compactacin del archivo de partidas</h3>
<p>
Siempre que una partida es reemplazada o borrada queda informacin no utilizada en el archivo de partidas (el ms grande de los tres archivos de base de datos de Scid). La compactacin del archivo de partidas elimina todo el espacio desaprovechado, quedando en la base de datos las partidas no borradas. Ten en cuenta que esta operacin es irreversible: despus de la compactacin, las partidas borradas se pierden para siempre!
</p>
<p>
La compactacin del archivo de partidas tambin se aconseja despus de <a Sorting>ordenar</a> una base de datos, para mantener el orden de las partidas de manera coherente con el archivo ndice que se a ordenado.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Database maintenance tools help:

set helpTitle(S,Maintenance) "Mantenimiento de la base de datos"
set helpText(S,Maintenance) {<h1>Mantenimiento de la base de datos</h1>
<p>
Scid proporciona una serie de herramientas para el mantenimiento de las bases de datos, accesibles desde el men de Scid <a Menus File>Archivo</a>. Las funciones de base de datos <a Compact>compactar</a> and <a Sorting>ordenar</a> son explicadas en pginas de ayuda separadas.
</p>

<NEW>
<h3>Maintenance window</h3>
<p>
Most Scid database maintenance can be done from the Maintenance
window, which can be opened from the <menu>File: Maintenance</menu>
or <menu>Windows</menu> menus or the shortcut key <b>Ctrl+M</b>.
</p>
<p>
You can use this window to maintain <a Flags>game flags</a>,
spellcheck names, <a Compact>compact</a> or <a Sorting>sort</a>
a database. Note that any operations that are not available
for the current database (for example, because it may be read-only
or a PGN file) will be greyed out.
</p>
</NEW>

<h3><name Twins>Borrado de partidas dobles</name></h3>
<p>
El men <menu>Archivo: Mantenimiento</menu> tiene el comando
<menu>Borrar partidas dobles...</menu> para detectar copias extra (dobles) de partidas en la base de datos. Este comando encuentra todos los pares de partidas que son dobles y, por cada par, seala la partida mas corta como borrada, dejando la ms larga sin borrar. Dos partidas son consideradas como dobles si sus jugadores (y cualquier otra etiqueta que puedes opcionalmente especificar) estn emparejados exactamente.
</p>
<p>
Si especificas la opcin los "mismos movimientos", cada par de partidas debe tener los mismos movimientos hasta la longitud de la partida ms corta (o hasta alcanzar el movimiento 40, lo primero que ocurra) para ser dobles.
</p>
<p>
Cuando tienes partidas dobles borradas, es una buena idea comprobar que cada partida borrada es realmente una copia de otra. Puedes hacer esto fcilmente si seleccionas la opcin "<b>Poner filtro a todas las partidas borradas</b>" en la caja de dilogo borrar dobles. Entonces el filtro contendr todas las partidas borradas. Puedes mirar a travs de ellas (usando las teclas <b>p</b> y <b>n</b>) con la ventana <term>comprobador de dobles</term> (disponible desde el men de mantenimiento, o la combinacin de teclas <b>Ctrl+Shift+T</b>) para verificar que cada partida a sido borrada porque es doble de otra.
</p>

<h3><name Editing>Edicin de nombres de jugadores, eventos, sitios y rondas</name></h3>
<p>
Puedes encontrar incorrecciones en los nombres de tu base de datos, las cuales puedes querer corregir. Puedes hacer esto en Scid con la ventana <term>Edicin de nombres</term> (combinacin de teclas: <b>Control+Shift+N</b>), disponible en el submen <menu>Archivo: Mantenimiento</menu>.
</p>
<p>
Cada nombre es almacenado slo una vez en el archivo de nombres, por lo que cambiando un nombre realmente cambias todas sus ocurrencias.
</p>

<h3><name Spellcheck>Correccin ortogrfica de nombres</name></h3>
<p>
Scid viene con un archivo de <term>correccin ortogrfica</term> llamado <b>spelling.ssp</b>, para la correccin de los nombres de jugadores, eventos, sitios y rondas. Scid intentar cargar el archivo de correccin ortogrfica siempre que se inicie; si este no se carga, puedes cargarlo desde el men <menu>Opciones</menu>.
</p>
<p>
Una vez que el archivo de correccin ortogrfica es cargado, puedes usarlo en una base de datos Scid mediante los comandos del men <menu>Archivo: Mantenimiento</menu>, o desde la ventana de mantenimiento.
</p>
<p>
Cuando corriges la ortografa de una base de datos, Scid produce una lista de correcciones que puedes editar antes de que realmente hagas alguna correccin, de esta manera puedes quitar cualquier correccin que no quieras que se realice.
</p>
<p>
La correccin ortogrfica es especialmente til para estandarizar una base de datos para que todos los ejemplos de un jugador en particular sean escritos de la misma manera. Por ejemplo, con el archivo de correccin ortogrfica estndar, los nombres "Kramnik,V.", "Vladimir Kramnik", y "V. Kramnik" sern todos corregidos a "Kramnik, Vladimir".
</p>
<p>
El archivo de correccin ortogrfica tiene un uso adicional: cuando es cargado, sus datos de jugadores son usados para enriquecer la ventana <a PInfo>informacin de los jugadores</a> y la ventana de <a Crosstable>tabla cruzada</a>: podrs ver los ttulos de los maestros de la FIDE (<b>gm</b> = Gran Maestro Internacional, <b>im</b> = Maestro Internacional, etc) y la informacin del pas de cualquier jugador que este listado en el archivo de correccin ortogrfica. Ms de 5000 grandes jugadores del pasado y el presente estn listados en el archivo <b>spelling.ssp</b> que viene con Scid.
</p>

<h3><name Ratings>Aadiendo clasificacin Elo a las partidas</name></h3>
<p>
El botn "Aadir clasificacin Elo..." de la ventana de mantenimiento hace que Scid busque en la base de datos activa partidas en las que un jugador no tiene clasificacin Elo, pero que en el archivo de correccin ortogrfica tiene almacenada la clasificacin Elo de ese jugador para la fecha en la que se jug esa partida.
Scid aadir todo este tipo de puntuaciones Elo automticamente. Esto es muy til para una base de datos con partidas de maestros en las que se encuentran pocas puntuaciones Elo.
</p>
<p>
El archivo de correccin ortogrfica "spelling.ssp" que viene con Scid no contiene la informacin sobre el Elo necesaria para esta funcin, pero se encuentra disponible en el <a Author>sitio web de Scid</a> una versin de ella llamada "ratings.ssp".
</p>

<h3><name Cleaner>La MultiHerramienta</name></h3>
<p>
La  <term>MultiHerramienta</term> de Scid (disponible desde la ventana de Mantenimiento) es una herramienta para hacer una serie de tareas de mantenimiento en una base de datos en una sola accin. Puedes escoger que tareas deseas hacer, y Scid las ejecutar en la actual bases de datos sin requerir la interaccin del usuario. Esto es especialmente til para el mantenimiento de grandes bases de datos.

<p><footer>(Actualizado: Scid 3.0, Noviembre 2001)</footer></p>
}

####################
### Sorting help:

set helpTitle(S,Sorting) "Ordenar una base de datos"
set helpText(S,Sorting) {<h1>Ordenar una base de datos</h1>
<p>
La funcin <term>ordenar</term> clasifica todas las partidas en una base de datos. Puedes seleccionar una serie de criterios de ordenacin. Cuando dos partidas son iguales segn el primer criterio, son ordenadas usando el segundo criterio y as sucesivamente.
</p>

<h3>Criterios de ordenacin</h3>
<p>
Los criterios de ordenacin disponibles son:
</p>
<ul>
<li> Fecha (las partidas ms antiguas primero) </li>
<li> Ao (igual que fecha, pero usando slo el ao) </li>
<li> Nombre del evento </li>
<li> Nombre del lugar </li>
<li> Nacin (las ltimas 3 letras del nombre del lugar) </li>
<li> Nombre de la ronda </li>
<li> Nombre de las blancas </li>
<li> Elo (media del Elo de las blancas y las negras, el ms alto primero) </li>
<li> Nombre de las negras </li>
<li> Resultado (primero blancas ganan, luego tablas y luego negras ganan) </li>
<li> Longitud (nmero total de movimientos de una partida) </li>
<li> ECO (el <a ECO>cdigo de la Encycolpedia of Chess Openings</a>) </li>
</ul>

<h3>Resultados de la ordenacin</h3>
<p>
Cuando ordenas una base de datos Scid que no es de slo lectura, el resultado de la ordenacin es guardado, por lo que el orden de las partidas en la base de datos cambia de manera permanente. Si quieres que el resultado de la ordenacin sea temporal, haz primero que la base de datos sea de slo lectura usando el comando del men <b>Archivo: Slo lectura</b>.
</p>
<p>
Cuando ordenas una base de datos que es de slo lectura o que es un archivo PGN, el resultado de la ordenacin no puede ser guardado por lo que el orden de las partidas se pierde cuando se cierra el archivo.
</p>
<p>
Ten encuenta que la ordenacin de una base de datos anula el <a Searches Filter>filtro de bsqueda</a> para as contener todas las partidas.
</p>

<h3>Nota importante sobre la ordenacin de bases de datos:</h3>
<p>
Cuando una base de datos es ordenada, se altera el archivo del ndice, pero el archivo de partidas permanece inalterado. Esto significa que ordenando una base de datos el registro del archivo de partidas se queda desordenado en relacin con el archivo del ndice. Esto puede <b>enlentecer</b> el <a Tree>rbol</a>, las <a Searches>bsquedas</a> por posicin y por material/modelo, por lo que deberas de reordenar el archivo de partidas mediante la <a Compact>compactacin</a> despus de la ordenacin para as mantener el buen rendimiento de la bsqueda.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Flags help:

set helpTitle(S,Flags) "Game Flags"
set helpText(S,Flags) {<h1>Game Flags</h1>

<p>
A <term>flag</term> is an indicator of some chess characteristic
that can be turned on or off for each game in the database.
There are 13 user-settable flags that you can directly set for
each game. Of these, only the Delete flag has any special
significance: games with the Delete flag turned on are marked
for deletion and will removed when the database is
<a Compact>compacted</a>.
</p>
<p>
The other 12 user-settable flags and their symbols are:
</p>

<ul>
<li>White opening (W)</li>
<li>Black opening (B)</li>
<li>Middlegame (M)</li>
<li>Endgame (E)</li>
<li>Novelty (N)</li>
<li>Pawn structure (P)</li>
<li>Tactics (T)</li>
<li>Queenside play (Q)</li>
<li>Kingside play (K)</li>
<li>Brilliancy (!)</li>
<li>Blunder (?)</li>
<li>User-defined (U)</li>
</ul>

<p>
A flag can be set for the current game, all filter games, or all
database games using the <a Maintenance>maintenance</a> window.
</p>
<p>
You can use a <a Searches Header>header search</a> to find all
games in a database that have a particular flag turned on or off,
or use flags as part of more complex searches.
</p>
<p>
Since all the user-settable flags (except the Delete flag) have
no significance to Scid, you can use them for any purpose that
suits your needs. For example, you could use the Kingside (K)
flag for kingside pawn storms, or kingside heavy piece attacks,
or even for endgames with all pawns on the kingside.
</p>

<p><footer>(Actualizado: Scid 3.0, Noviembre 2001)</footer></p>
}

####################
### Analysis window help:

set helpTitle(S,Analysis) "Ventana de Anlisis"
set helpText(S,Analysis) {<h1>La ventana de Anlisis</h1>
<p>
La ventana de anlisis de Scid muestra el anlisis que realiza un programa de ajedrez de la posicin actual del tablero. Cada vez que el tablero cambia, Scid manda la nueva posicin al programa de anlisis.
</p>
<p>
La puntuacin mostrada en la ventana de anlisis es siempre desde la perspectiva de las blancas, por lo que una puntuacin negativa indica que las negras estn mejor.
</p>

<h3>Aadir el anlisis a la partida</h3>
<p>
El botn <term>Aadir a comentario</term> en la ventana de anlisis aade la puntuacin y la mejor lnea de juego actual al comentario del movimiento en la partida.
</p>
<p>
Puedes hacer esto automticamente para una serie de movimientos anotando la partida, iniciando el <a MainWindow Autoplay>modo de automovimiento</a>.
Cuando se usa el modo de automovimiento, y la ventana de anlisis est abierta, se aade automticamente un comentario que contiene la puntuacin y la mejor lnea de juego de cada posicin de la partida por la que pasa el modo de automovimiento. Slo son anotadas las posiciones desde la actual hasta el final de la partida (o hasta salir del modo de automovimiento), por lo que puedes omitir la anotacin de los movimientos de la apertura yendo a una posicin media de la partida antes de iniciar el modo de automovimiento.
</p>
<p>
Puedes incrementar el tiempo de demora entre movimientos para aumentar la calidad del anlisis desde el men <menu>Opciones: Movimientos</menu>.
</p>
<p>
Para cancelar la anotacin en cualquier momento, slo desactiva el modo de automovimiento; por ejemplo presionando la tecla de escape en la ventana principal.
</p>

<h3>Detalles de la interconexin</h3>
<p>
Para usar la ventana de anlisis necesitars un programa de ajedrez que soporte los comandos estndar de <term>Xboard</term>. En concreto, Scid enva los comandos <b>xboard</b> y <b>post</b> al programa cuando este se inicia.
</p>
<p>
Si Scid distingue a "Crafty" al principio de una lnea de salida del programa de ajedrez usar los comandos especficos de crafty, tales como <b>setboard</b> para actualizar cada posicin.
</p>
<p>
Para todos los dems programas, Scid manda los siguientes comandos cada vez que la posicin cambia:  <b>new</b> y <b>force</b>, luego los movimientos de la partida en la posicin actual, y despus <b>go</b>.
</p>
<p>
El excelente programa gratuito de Bob Hyatt <term>crafty</term> es el que yo uso y recomiendo para la ventana de anlisis de Scid, pero yo tambin he usado otros programas exitosamente con Scid, como son Phalanx y Gnuchess.
</p>
<p>
Crafty puede ser descargado de: <br>
<url ftp://ftp.cis.uab.edu/pub/hyatt/>ftp://ftp.cis.uab.edu/pub/hyatt/</url>
</p>
<p>
Gnuchess est disponible: <br>
<url http://www.gnu.org/software/chess/chess.html>http://www.gnu.org/software/chess/chess.html</url>
</p>
<p>
El sitio de descarga de Phalanx es: <br>
<url ftp://ftp.math.muni.cz/pub/math/people/Dobes/>ftp://ftp.math.muni.cz/pub/math/people/Dobes/</url>
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### EPD files help:

set helpTitle(S,EPD) "Archivos de posiciones"
set helpText(S,EPD) {<h1>Archivos posiciones</h1>
<p>
Un archivo de posiciones Scid (extensin ".epd") es simplemente una coleccin de posiciones, en el que cada posicin tiene cierto texto asociado. Las antiguas versiones de Scid usaban un formato especial (extensin ".sbk") para los archivos de posiciones, pero desde la versin 1.6 Scid usa el formato estndar de archivos <term>EPD</term> (extended position description).
</p>
<p>
Un archivo EPD tiene un nmero definido de <term>opcodes</term> (campos), los cuales son almacenados separados por punto y coma (<b>;</b>) en el archivo, pero son mostrados en distintas lneas en la ventana de archivos de posiciones de Scid para facilitar su edicin. Un punto y coma dentro de un campo EPD es almacenado por Scid como "<b>\s</b>" para distinguirlo de una marca de fin de campo. Cada posicin y sus opcodes son almacenados en una lnea en el archivo EPD.
</p>
<p>
Los opcodes EPD estndar incluyen:
<ul>
<li> <b>acd</b> Recuento de anlisis: profundidad de bsqueda.</li>
<li> <b>acn</b> Recuento de anlisis: nmero de nodos buscados.</li>
<li> <b>acs</b> Recuento de anlisis: tiempo de bsqueda en segundos.</li>
<li> <b>bm</b> Mejores movimientos: movimiento(s) que se ha juzgado como mejor por alguna razn.</li>
<li> <b>ce</b> Evaluacin en centsimas de pen: evaluacin en centsimas de pen desde la perspectiva del <b>lado que mueve</b> -- date cuenta que esto difiere de la ventana de anlisis, la cual muestra las evaluaciones en peones desde la perspectiva de las blancas. </li>
<li> <b>cX</b> Comentario (donde <b>X</b> es un nmero, 0-9).</li>
<li> <b>eco</b> Cdigo del sistema de aperturas <a ECO>ECO</a>.</li>
<li> <b>id</b> nica Identificacin para esta posicin.</li>
<li> <b>nic</b> Cdigo del sistema de aperturas <i>New In Chess</i>.</li>
<li> <b>pm</b> Movimiento previsto: el primer movimiento de la PV (variacin prevista).</li>
<li> <b>pv</b> Variacin prevista: la lnea con mejor juego.</li>
</ul>

<p>
Los archivos de posiciones tienen distintos usos: Scid usa un archivo de posiciones para clasificar las partidas segn el sistema de la <a ECO>Encyclopaedia of Chess Openings</a> (ECO), y tu puedes hacer un archivo de posiciones para tu repertorio de aperturas, aadiendo comentarios en las posiciones que alcanzas asiduamente en las partidas.
</p>
<p>
Puedes crear un nuevo archivo de posiciones o abrir uno desde el submen
<menu>Archivo de posiciones</menu> del men <menu>Archivo</menu>. Como mximo se pueden abrir cuatro archivos de posiciones al mismo tiempo.
</p>

<h3>Ventanas de posiciones</h3>
<p>
Para cada archivo de posiciones abierto se muestra una ventana que muestra el texto de la posicin actual. No necesitas apretar el botn Almacenar para guardar los cambios hechos en el texto de una posicin; el texto ser almacenado cada vez que te muevas a una nueva posicin de la partida.
</p>

<h3>Navegando por los archivos de posicin</h3>
<p>
Para moverte a travs de las posiciones usa los comandos <menu>Siguiente posicin</menu> y <menu>Posicin anterior</menu> del men <menu>Herramientas</menu> de la ventana de posiciones, o usa las combinaciones de teclas <b>Ctrl+Flecha abajo</b> y <b>Ctrl+Flecha arriba</b>. Estos comandos mueven a la siguiente/anterior posicin del archivo, quitando de en medio la partida actual y colocando su posicin de inicio.
</p>

<h3>Eliminando campos EPD</h3>
<p>
Los archivos EPD que encuentras en internet pueden contener campos que no te interesan, los cuales pueden consumir gran cantidad de espacio en un archivo. Por ejemplo, un archivo EPD de evaluacin de ordenadores puede tener los campos ce, acd, acn, pm, pv e id pero tu puedes necesitar tan slo los campos ce y pv.
</p>
<p>
Puedes eliminar un opcode EPD de todas las posiciones del archivo usando <menu>Eliminar campos EPD</menu> desde el men <menu>Herramientas</menu> de la ventana de posiciones.
</p>

<h3>La barra de estado de la ventana de posiciones</h3>
<p>
La barra de estado de cada ventana de posiciones muestra:
<ul>
<li>- el estado del archivo (<b>--</b> significa sin cambios, <b>XX</b> significa cambiado, y <b>%%</b> significa slo lectura); </li>
<li>- el nombre del archivo; </li>
<li>- el nmero de posiciones del archivo; </li>
<li>- movimientos legales desde la posicin actual que alcanzan otra posicin de este archivo de posiciones.</li>
</ul>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

######################
### Email window help:

set helpTitle(S,Email) "Ventana de Email"
set helpText(S,Email) {<h1>Ventana de Email</h1>
<p>
La ventana de administracin de emails te proporciona una manera para manejar
las partidas de ajedrez por correspondencia jugadas por email. Si no juegas
partidas de ajedrez por email esto no ser de inters para ti. Pero si juegas
al ajedrez mediante emails puedes mandar tus mensajes directamente desde Scid!
</p>
<p>
No olvides que el administrador de emails est actualmente solo disponible para
Scid en plataformas Unix/Linux. No est disponible para usuarios de Windows.
</p>
<p>
Para usar el administrador de emails:
<ul>
<li><b>1)</b> Crear la(s) partidas(s) para tu oponente en la base de datos.
</li>
<li><b>2)</b> En la ventana del administrador de email selecciona <b>Aadir</b>
e ingresa los detalles de tu oponente: nombre, direccin de email, y los nmeros
de partida en la base de datos. </li>
<li><b>3)</b> Selecciona <b>Enviar email</b> en la ventana de email cada vez que
hayas aadido movimientos a la(s) partida(s) y quieras enviar un mensaje. </li>
</ul>

<p>
Cuando envas un mensaje de email, Scid crea el mensaje con las partidas en
formato PGN <b>sin</b> ningn comentario, anotacin o variacin, dado que
habitualmente tu no debes querer que tu oponente vea tus anlisis. Puedes editar
el mensaje antes de enviarlo para aadir movimientos potenciales u otro texto.
</p>
<p>
Para cada oponente puedes tener cualquier nmero de partidas; una o dos es lo
ms comn. Advierte que Scid no comprueba si los nmeros de partida cambian, as
que despus de introducir los datos de tu oponente debes ser cuidadoso para
evitar borrar partidas u ordenar tu base de datos de partidas de email, puesto
que esto reubicara las partidas, siendo el nmero de las partidas de cada
oponente incorrecto.
</p>

<h3>Limitaciones</h3>
<p>
Scid no tiene todava ninguna capacidad para consultar tu carpeta de email, por lo que todava necesitas aadir los movimientos de tu oponente a las partidas manualmente.
</p>

<h3>Configuracin</h3>
<p>
Una copia de cada mensaje de email es guardada por Scid en el archivo <b>.scid_sent_emails</b> en tu directorio "home". Si deseas que sean guardados en un archivo diferente tendrs que editar el archivo <b>tcl/start.tcl</b> y recompilar Scid.
</p>
<p>
Para usar el administrador de email tienes que tener instalado en tu sistema
<term>sendmail</term>; muchos sistemas Unix/Linux usan <term>sendmail</term> para enviar los mensajes de email. Si tu programa sendmail no tiene la ruta <b>/usr/lib/sendmail</b> tendrs que editar <b>tcl/start.tcl</b> y recompilar Scid. La siguiente localizacin ms comn de sendmail es <b>/usr/sbin/sendmail</b>.
</p>
<p>
Scid guarda los detalles del oponente de una base de datos en un archivo con el mismo nombre que la base de datos con el sufijo "<b>.sem</b>".
</p>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}

####################
### Opening Report help:

set helpTitle(S,OpReport) "Informe de la Apertura"
set helpText(S,OpReport) {<h1>Informe de la Apertura</h1>
<p>
Scid puede generar un <term>informe de la apertura</term> que muestra datos interesantes sobre una apertura. Para producir un informe de la apertura, primero asegrate que se muestra la posicin de la cual quieres el informe, entonces selecciona <b>Informe de la Apertura</b> en el men <b>Herramientas</b>.
</p>
<p>
La ventana del <term>Informe de la Apertura</term> muestra el resultado del informe producido por Scid. El men <b>Archivo</b> tiene comandos para guardar el informe en archivos de texto sin formato, HTML o en formato <a LaTeX>LaTeX</a>.
</p>
<p>
Las primeras secciones del informe muestran informacin sobre las partidas que llegan hasta la posicin del informe, y los movimientos realizados desde esa posicin. Puedes ver si la apertura se est haciendo ms popular, si tiene muchas tablas de corta duracin, y que orden de movimientos (transposiciones)
se han usado para llegar a esa posicin.
<p>
La parte ltima, y ms larga, es la tabla terica. Cuando guardes el informe en un archivo puedes escoger entre guardar slo la tabla terica, un informe compacto sin la tabla terica o la totalidad del informe.

<h3>Lmites</h3>
<p>
Hay un lmite de 2000 partidas para la mayora de los datos generados por el informe, as que si el informe de la posicin tiene lugar en ms de 2000 partidas algunos resultados pueden ser ligeramente incorrectos.
</p>
<p>
Adems, hay un lmite de 500 partidas para la tabla ECO. Si la posicin del informe tiene lugar en ms de 500 partidas slo las 500 partidas con el mayor promedio de clasificacin Elo sern utilizadas para producir la tabla ECO.
</p>

<h3>Exhibicin preliminar LaTeX</h3>
<p>
El botn <b>Exhibicin preliminar LaTeX</b> en la esquina inferior izquierda de la ventana del informe (no disponible en las versiones Windows) guarda el informe como un archivo temporal de formato LaTeX; pon a funcionar <b>latex</b> en l, y ejecuta <b>xdvi</b> para visualizar los resultados. Esto <b>slo</b> funcionar si tienes latex, xdvi y todos los paquetes latex necesarios instalados en tu ordenador; ver la pgina de ayuda <a LaTeX>Usando LaTeX con Scid</a>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Player Info help:

set helpTitle(S,PInfo) "Ventana de Informacin del Jugador"
set helpText(S,PInfo) {<h1>La ventana de Informacin del Jugador</h1>
<p>
La ventana <term>Informacin del Jugador</term> es producida o actualizada cada vez que aprietas el botn izquierdo en el rea de informacin (debajo del tablero) o en la ventan de <a Crosstable>tabla cruzada</a> sobre el nombre de un jugador.
</p>
<p>
Muestra (optimstamente) informacin de utilidad sobre el jugador, incluyendo sus xitos con blancas y negras, aperturas favoritas (segn <a ECO>cdigos ECO</a>),
y la historia de su Elo.
</p>
<p>
Todos los porcentajes mostrados son una puntuacin esperada (ndice de acierto), desde la perspectiva del jugador -- por lo que cuanto ms altos son mejor es para el jugador, tanto si juega con blancas como si lo hace con negras.
</p>
<p>
Puedes ver la historia del Elo de un jugador en un grfico presionando el botn
<a Graphs Rating>Grfico Elo</a>.
</p>
<p>
Cualquier nmero impreso en rojo puede se apretado con el botn izquierdo del ratn para poner las partidas que representa en el <a Searches Filter>filtro</a>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Graphs help:

set helpTitle(S,Graphs) "Ventanas de grficos"
set helpText(S,Graphs) {<h1>Ventanas de grficos</h1>
<p>
Scid tiene una serie de ventanas que muestran informacin de manera grfica. Estas son explicadas a continuacin.
</p>

<h3><name Rating>Ventana del Grfico Elo</name></h3>
<p>
La ventana del <term>Grfico Elo</term> muestra la historia del Elo de un jugador o de los dos jugadores de la partida actual. Puedes producir el grfico para un nico jugador presionando el botn <b>Grfico Elo</b> en la ventana <a PInfo>informacin del jugador</a>, o generarlo para los dos jugadores de la partida actual seleccionando <b>Grfico Elo</b> en el men <menu>Herramientas</menu>.
</p>

<h3><name Score>Ventana del Grfico de Puntuacin</name></h3>
<p>
La ventana del <term>Grfico de Puntuacin</term> muestra la evaluacin numrica (puntuacin) almacenada en los comentarios de la actual partida en forma grfica. Puedes apretar el botn izquierdo del ratn en cualquier parte del grfico de puntuacin para ir a la posicin correspondiente de la partida.
</p>
<p>
Son reconocidos dos tipos de comentarios de evaluacin: aquellos producidos por la ventana de <a Analysis>anlisis</a> de Scid (que tienen el formato
<ul>
<li><b>1.e4 {"+0.25 ...."}</b></li>
</ul>
y son siempre puntuados desde la perspectiva de las blancas) y aquellos por el comando anotar de Crafty (el cual tiene el formato
<ul>
<li><b>1.e4 ({9:+0.25} ....)</b></li>
</ul>
y son puntuados desde la perspectiva de las blancas).
</p>

<h3><name Tree>Ventana del Grfico de rbol</name></h3>
<p>
La ventana del <term>Grfico de rbol</term> esta disponible desde la ventana de rbol. Muestra el rendimiento de los movimientos ms usuales desde la posicin actual. Hay ms informacin disponible sobre esto en la pgina de ayuda del <a Tree Graph>rbol</a>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Tablebases help:

set helpTitle(S,TB) "Tablebases"
set helpText(S,TB) {<h1>Tablebases</h1>

<p>
Una <term>tablebase</term> es un archivo que contiene la informacin de un resultado perfecto de todas las posiciones con una distribucin de material concreta, como Rey y Torre contra Rey y Pen. Se han realizado tablebases de situaciones con material de hasta cinco piezas (incluidos los reyes), y algunas tablebases simples para seis piezas tambin estn disponibles.
</p>
<p>
Scid puede usar tablebases en formato Nalimov, formato que es usado por muchos motores de ajedrez modernos. Estos amenudo terminan con el sufijo <b>.nbw.emd</b> o <b>.nbb.emd</b>.
</p>

<h3>Uso de las tablebases en Scid</h3>
<p>
Para usar un directorio de archivos de tablebase en Scid, simplemente ubica el directorio seleccionando <b>Directorio de las TB...</b> en el men <menu>Opciones</menu>.
</p>
<p>
Cuando se encuentra una posicin que se encuentra en un archivo de tablebase, el rea de informacin de la partida (debajo del tablero de ajedrez) muestra informacin de la tablebase. Puedes configurar la cantidad de informacin mostrada pinchando con el botn derecho del ratn en este area o seleccionando   <b>Informacin de la partida</b> en el men <menu>Opciones</menu>. Seleccionando la opcin "resultado y mejor movimiento" se obtiene la mayor cantidad de informacin, pero es amenudo mucho ms lento que la opcin "slo resultado".

<h3>La ventana de Tablebase</h3>
<p>
Puedes obtener ms informacin sobre la posicin actual abriendo la <term>ventana de Tablebase</term> (men <menu>Ventanas</menu>,
atajo: Ctrl+Shift+T). Esta ventana muestra el resultado, con un juego perfecto, de todos los movimientos legales desde la actual posicin.
</p>

<h3>Obtener archivos de Tablebases</h3>
<p>
Ver la seccin de <a Author Related>links relacionados</a> para obtener ayuda para encontrar archivos de tablebases en internet.
</p>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}


####################
### Bookmarks help:

set helpTitle(S,Bookmarks) "Bookmarks"
set helpText(S,Bookmarks) {<h1>Bookmarks</h1>
<p>
Scid allows you to <term>bookmark</term> important games for easy
future reference. The bookmarks menu is available from the
<menu>File</menu> menu, the toolbar, or the <B>Ctrl+B</b> shortcut key.
</p>
<p>
When you select a bookmarked game from the Bookmarks menu, Scid will
open its database if necessary, find that game, and move to the game
position at which it was bookmarked.
</p>
<p>
Only games in a Scid format database (not a PGN file or the clipbase)
can be bookmarked.
</p>
<p>
If the database of a bookmarked game is sorted or compacted, the bookmark
details may become out of date. When that happens, Scid will search the
database for the best matching game (comparing player names, site, etc)
when the bookmark is selected, so the bookmarked game should still be
loaded. However, if details of the bookmarked game change, it is possible
that a different game will match the bookmark details better and be
loaded instead. So it is a good idea to re-bookmark a game if you edit
its players, site, result, round or year.
</p>

<h3>Editing bookmarks</h3>
<p>
With the bookmark editor, you can change the menu text displayed for
each bookmarked game and add folders to categorize bookmarks.
</p>

<h3>Hints</h3>
<p>
You can use bookmarks for fast access to databases you use often
by bookmarking a game from each database. Another good use for
bookmarks is to add important games you find when studying a
particular chess opening.
</p>
<p>
The bookmarks menu contains an entry for controlling the display of
bookmark folders: they can be shown as submenus (useful when there are
many bookmarks), or as a single list.
</p>

<p><footer>(Actualizado: Scid 3.0, Noviembre 2001)</footer></p>
}

#################
### Pgnscid help:

set helpTitle(S,Pgnscid) "Pgnscid"
set helpText(S,Pgnscid) {<h1>Pgnscid</h1>
<p>
<term>Pgnscid</term> es un programa aparte que necesitas usar (eso era antes) para convertir archivos PGN (portable game notation) en bases de datos Scid.
</p>
Para convertir un archivo llamado <i>miarchivo.pgn</i>, simplemente escribe:
<ul>
<li> <b>pgnscid miarchivo.pgn</b> </li>
</ul>
y la base de datos Scid (consistente en <i>miarchivo.si</i>, <i>miarchivo.sg</i> y <i>miarchivo.sn</i>) ser creada. Cualquier error o advertencia ser escrita en el archivo <i>miarchivo.err</i>.
</p>
<p>
Si quieres que la base de datos sea creada en un directorio diferente o que tenga un nombre diferente puedes aadir el nombre de la base de datos en la lnea de comandos, por ejemplo:
<ul>
<li> <b>pgnscid miarchivo.pgn mibase</b> </li>
</ul>
crear una base de datos consistente en los archivos <i>mibase.si</i>,
<i>mibase.sg</i> y <i>mibase.sn</i>.
</p>
<p>
Advierte que pgnscid (y scid) pueden leer archivos comprimidos en Gzip (ej. <b>mibase.pgn.gz</b>) directamente, por lo que, si tienes un gran archivo PGN comprimido con Gzip para ahorrar espacio, no necesitas descomprimirlo primero.
</p>

<h3>Opciones</h3>
<p>
Hay dos argumentos opcionales que pgnscid puede aceptar delante del nombre del fichero:
<b>-f</b> y <b>-x</b>.
</p>
<p>
La opcin <b>-f</b> fuerza a sobrescribir una base de datos existente; por defecto, pgnscid no convierte a una base de datos que ya existe.
</p>
<p>
La opcin <b>-x</b> provoca que pgnscid ignore todo el texto entre partidas. Por defecto, el texto entre partidas es guardado como un comentario de la partida que le sigue. Esta opcin slo afecta al texto entre partidas; los comentarios estndar dentro de cada partida son, an as, convertidos y guardados.
</p>

<h3>Formateo de nombres de jugadores</h3>
<p>
Para reducir el nmero de ortografas que hacen referencia al mismo jugador, pgnscid hace un formateo bsico de los nombre de los jugadores. Por ejemplo, el nmero de espacios despus de cada coma se estandariza a uno, se borra cualquier espacio al principio y final de un nombre, y se borran los puntos al final de un nombre. Los prefijos holandeses como "van den" y "Van Der" se normalizan para que tengan la V mayscula y la d minscula.
</p>
<p>
Puedes editar (e incluso revisar ortogrficamente de manera automtica) los nombres de los jugadores, eventos, lugares y rondas con Scid; ver las pginas de ayuda de <a Maintenance Editing>Mantenimiento</a> para obtener ms detalles.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### Options and Fonts help:

set helpTitle(S,Options) "Opciones"
set helpText(S,Options) {<h1>Opciones y preferencias</h1>
<p>
Muchas opciones y preferencias de Scid (como pueden ser: tamao del tablero, colores, fuentes y valores por defecto) son ajustables desde el men  <menu>Opciones</menu>.
Todas estas (y ms, como el ltimo directorio desde el que tu cargaste una base de datos y el tamao de algunas ventanas) son guardadas en el archivo opciones cuando seleccionas en el men Opciones <b>Guardar opciones</b>. El archivo opciones es cargado cada vez que se inicia Scid.
</p>
<p>
Si usas Windows, el archivo opciones es <b>scid.opt</b> el cual se encuentra en el directorio donde se encuentra el archivo del programa Scid, <b>scid.exe</b>. Para los usuarios del sistema operativo Unix (como puede ser Solaris o Unix) el archivo es: <b>~/.scid</b> --
es decir, el archivo <b>.scid</b> de tu directorio personal.
</p>

<h3><name Fonts>Tipos de fuentes</name></h3>
<p>
Scid tiene tres tipos de fuentes bsicas que usa en la mayora de sus ventanas, y que puedes personalizar. Estas son llamadas <b>habitual</b>, <b>pequea</b> y <b>fijada</b>.
</p>
<p>
La fuente fijada tiene una anchura de fuente fija (no proporcional). Es usada en las ventanas <a Tree>rbol</a> y <a Crosstable>tabla cruzada</a>.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### File formats help:

set helpTitle(S,Formats) "Formatos de archivo"
set helpText(S,Formats) {<h1>Los formatos de archivo de Scid</h1>
<p>
Las bases de datos Scid consisten en tres archivos esenciales: un archivo ndice, un archivo de Nombres y un archivo de Partidas. Todos tienen una extensin de dos letras que empieza con la letra "s": ".si" para los archivos ndice, ".sn" para los archivos de nombres, y ".sg" para los archivos de partidas.
</p>

<h3>El archivo ndice (.si)</h3>
<p>
Este archivo contiene una descripcin para la base de datos y pequea entrada de tamao fijo para cada partida. El actual tamao es de 41 bytes por partida. De estos, alrededor de 28 bytes son informacin esencial como el resultado, fecha, nmeros de identificacin de los nombres del jugador/evento/lugar (el nombre existente est en el archivo de Nombres), etc.
</p>
<p>
Los 13 bytes restantes contienen informacin repetida, pero til, sobre la partida; es usada para aumentar la velocidad de las bsquedas por posicin, material y modelo. Ver la seccin <a Formats Fast>Bsquedas rpidas</a> ms adelante para obtener ms informacin.
</p>

<h3>El archivo de Nombres (.sn)</h3>
<p>
Este archivo contiene todos los nombres de jugadores, eventos, lugares y rondas de la base de datos. Cada nombre es almacenado slo una vez, incluso si este aparece en muchas partidas. El archivo de nombres normalmente es el ms pequeo de los tres archivos esenciales de una base de datos.
</p>

<h3>El archivo de Partidas (.sg)</h3>
<p>
Este archivo contiene los movimientos, variaciones y comentarios de cada partida. El formato de codificacin de los movimientos es muy compacto: la mayora de los movimientos ocupan slo un byte de almacenamiento.
</p>
<p>
Cuando una partida es reemplazada, su nueva versin es guardada al <i>final</i> del archivo de partidas, por lo que se puede acumular con el tiempo espacio intil. Puedes restablecer una base de datos a su mnimo tamao mediante su <a Compact>compactacin</a>.
</p>

<h3>Otros archivos Scid</h3>
<p>
Un archivo <a EPD>EPD</a> (sufijo: ".epd") contiene una serie de posiciones, cada una con un comentario de texto. El formato de archivo EPD se describe en el <a Author Related>estndar PGN</a>.
</p>
<p>
Un archivo de E-mail (sufijo: ".sem") para una base de datos almacena detalles de los oponentes a los que mandas mensajes.
</p>
<p>
Un archivo de Opciones de Bsqueda (sufijo: ".sso") contiene opciones de bsqueda de Scid de <a Searches Header>cabecera</a> o de <a Searches Material>material/modelo</a>.
</p>

<h3><name Fast>Bsquedas rpidas en Scid</name></h3>
<p>
Como se a mencionado ms arriba el archivo de ndice almacena alguna informacin repetida pero til sobre cada partida para acelerar las bsquedas de posicin o material.
</p>
<p>
Por ejemplo, se guarda el material de la posicin final. Si buscas finales de torre y pen, entonces todas las partidas que terminen con una dama, alfil o caballo sobre el tablero (y no tienen promocin de peones) sern rpidamente saltadas.
</p>
<p>
Otro segmento de informacin guardado de utilidad es el orden en el que los peones dejan su casilla inicial (por moverse o por ser capturados). Esto es usado para aumentar la velocidad del rbol o de las bsquedas por posicin exacta, especialmente para posiciones de apertura. Por ejemplo, cuando se busca la posicin inicial de la defensa francesa (1.e4 e6), se saltan todas las partidas que empiezan con 1.e4 c5, o 1.d4, etc, pero las partidas que empiezan con 1.e4 e5 todava podrn ser utilizadas en la bsqueda.
</p>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

####################
### NAG values help:

set helpTitle(S,NAGs) "Valores NAG"
set helpText(S,NAGs) {<h1>Valores NAG estndares</h1>
<p>
Los valores NAG (Numeric Annotation Symbol) estndares definidos en el <a Author Related>estndar PGN</a> son:
</p>
<cyan>
<ul>
<li>  1   Buen movimiento (!) </li>
<li>  2   Mal movimiento (?) </li>
<li>  3   Excelente movimiento (!!) </li>
<li>  4   Error garrafal (??) </li>
<li>  5   Movimiento interesante (!?) </li>
<li>  6   Movimiento dudoso (?!) </li>
<li>  7   Movimiento forzado </li>
<li>  8   Movimiento singular; no hay alternativas razonables </li>
<li>  9   Movimiento que conlleva la derrota </li>
<li> 10   Posicin de tablas (=) </li>
<li> 11   Oportunidades iguales, posicin tranquila (=) </li>
<li> 12   Oportunidades iguales, posicin activa (=) </li>
<li> 13   Posicin incierta (~) </li>
<li> 14   Las blancas tienen una pequea ventaja (+=) </li>
<li> 15   Las negras tienen una pequea ventaja (=+) </li>
<li> 16   Las blancas tienen una moderada ventaja (+/-) </li>
<li> 17   Las negras tienen una moderada ventaja (-/+) </li>
<li> 18   Las blancas tienen una ventaja decisiva (+-) </li>
<li> 19   Las negras tienen una ventaja decisiva (-+) </li>
<li> 20   Las blancas tienen una ventaja aplastante (+-) </li>
<li> 21   Las negras tienen una ventaja aplastante (-+) </li>
<li> 22   Las blancas desearan pasar </li>
<li> 23   Las negras desearan pasar </li>
<li> 24   Las blancas tienen una pequea ventaja espacial </li>
<li> 25   Las negras tienen una pequea ventaja espacial </li>
<li> 26   Las blancas tienen una moderada ventaja espacial </li>
<li> 27   Las negras tienen una moderada ventaja espacial </li>
<li> 28   Las blancas tienen una ventaja espacial decisiva </li>
<li> 29   Las negras tienen una ventaja espacial decisiva </li>
<li> 30   Las blancas tienen una pequea ventaja de tiempo (desarrollo) </li>
<li> 31   Las negras tienen una pequea ventaja de tiempo (desarrollo) </li>
<li> 32   Las blancas tienen una moderada ventaja de tiempo (desarrollo) </li>
<li> 33   Las negras tienen una moderada ventaja de tiempo (desarrollo) </li>
<li> 34   Las blancas tienen una decisiva ventaja de tiempo (desarrollo) </li>
<li> 35   Las negras tienen una decisiva ventaja de tiempo (desarrollo) </li>
<li> 36   Las blancas tienen la iniciativa </li>
<li> 37   Las negras tienen la iniciativa </li>
<li> 38   Las blancas tienen una iniciativa duradera </li>
<li> 39   Las negras tienen una iniciativa duradera </li>
<li> 40   Las blancas llevan el ataque </li>
<li> 41   Las negras llevan el ataque </li>
<li> 42   Las blancas tienen una insuficiente compensacin para el dficit de material </li>
<li> 43   Las negras tienen una insuficiente compensacin para el dficit de material </li>
<li> 44   Las blancas tienen suficiente compensacin para el dficit de material </li>
<li> 45   Las negras tienen suficiente compensacin para el dficit de material </li>
<li> 46   Las blancas tienen una ms que adecuada compensacin para el dficit de material </li>
<li> 47   Las negras tienen una ms que adecuada compensacin para el dficit de material </li>
<li> 48   Las blancas tienen una pequea ventaja en el control del centro </li>
<li> 49   Las negras tienen una pequea ventaja en el control del centro </li>
<li> 50   Las blancas tienen una moderada ventaja en el control del centro </li>
<li> 51   Las negras tienen una moderada ventaja en el control del centro </li>
<li> 52   Las blancas tienen una ventaja decisiva en el control del centro </li>
<li> 53   Las negras tienen una ventaja decisiva en el control del centro </li>
<li> 54   Las blancas tienen una pequea ventaja en el control del ala del rey </li>
<li> 55   Las negras tienen una pequea ventaja en el control del ala del rey </li>
<li> 56   Las blancas tienen una moderada ventaja en el control del ala del rey </li>
<li> 57   Las negras tienen una moderada ventaja en el control del ala del rey </li>
<li> 58   Las blancas tienen una ventaja decisiva en el control del ala del rey </li>
<li> 59   Las negras tienen una ventaja decisiva en el control del ala del rey </li>
<li> 60   Las blancas tienen una pequea ventaja en el control del ala de la dama </li>
<li> 61   Las negras tienen una pequea ventaja en el control del ala de la dama </li>
<li> 62   Las blancas tienen una moderada ventaja en el control del ala de la dama </li>
<li> 63   Las negras tienen una moderada ventaja en el control del ala de la dama </li>
<li> 64   Las blancas tienen una ventaja decisiva en el control del ala de la dama </li>
<li> 65   Las negras tienen una ventaja decisiva en el control del ala de la dama </li>
<li> 66   Las blancas tienen una primera fila vulnerable </li>
<li> 67   Las negras tienen una primera fila vulnerable </li>
<li> 68   Las blancas tienen una primera fila bien protegida </li>
<li> 69   Las negras tienen una primera fila bien protegida </li>
<li> 70   Las blancas tienen un rey mal protegido </li>
<li> 71   Las negras tienen un rey mal protegido </li>
<li> 72   Las blancas tienen un rey bien protegido </li>
<li> 73   Las negras tienen un rey bien protegido </li>
<li> 74   Las blancas tienen un rey mal colocado </li>
<li> 75   Las negras tienen un rey mal colocado </li>
<li> 76   Las blancas tienen un rey bien colocado </li>
<li> 77   Las negras tienen un rey bien colocado </li>
<li> 78   Las blancas tienen una estructura de peones muy dbil </li>
<li> 79   Las negras tienen una estructura de peones muy dbil </li>
<li> 80   Las blancas tienen una estructura de peones moderadamente dbil </li>
<li> 81   Las negras tienen una estructura de peones moderadamente dbil </li>
<li> 82   Las blancas tienen una estructura de peones moderadamente fuerte </li>
<li> 83   Las negras tienen una estructura de peones moderadamente fuerte </li>
<li> 84   Las blancas tienen una estructura de peones muy fuerte </li>
<li> 85   Las negras tienen una estructura de peones muy fuerte </li>
<li> 86   Las blancas tienen un mal emplazamiento del caballo </li>
<li> 87   Las negras tienen un mal emplazamiento del caballo </li>
<li> 88   Las blancas tienen un buen emplazamiento del caballo </li>
<li> 89   Las negras tienen un buen emplazamiento del caballo </li>
<li> 90   Las blancas tienen un mal emplazamiento del alfil </li>
<li> 91   Las negras tienen un mal emplazamiento del alfil </li>
<li> 92   Las blancas tienen un buen emplazamiento del alfil </li>
<li> 93   Las negras tienen un buen emplazamiento del alfil </li>
<li> 94   Las blancas tienen un mal emplazamiento de la torre </li>
<li> 95   Las negras tienen un mal emplazamiento de la torre </li>
<li> 96   Las blancas tienen un buen emplazamiento de la torre </li>
<li> 97   Las negras tienen un buen emplazamiento de la torre </li>
<li> 98   Las blancas tienen un mal emplazamiento de la dama </li>
<li> 99   Las negras tienen un mal emplazamiento de la dama </li>
<li>100   Las blancas tienen un buen emplazamiento de la dama </li>
<li>101   Las negras tienen un buen emplazamiento de la dama </li>
<li>102   Las blancas tienen una mala coordinacin de piezas </li>
<li>103   Las negras tienen una mala coordinacin de piezas </li>
<li>104   Las blancas tienen una buena coordinacin de piezas </li>
<li>105   Las negras tienen una buena coordinacin de piezas </li>
<li>106   Las blancas han jugado una abertura muy mala </li>
<li>107   Las negras han jugado una abertura muy mala </li>
<li>108   Las blancas han jugado una abertura mala </li>
<li>109   Las negras han jugado una abertura mala </li>
<li>110   Las blancas han jugado una buena abertura </li>
<li>111   Las negras han jugado una buena abertura </li>
<li>112   Las blancas han jugado una muy buena abertura </li>
<li>113   Las negras han jugado una muy buena abertura </li>
<li>114   Las blancas han jugado el medio juego muy mal </li>
<li>115   Las negras han jugado el medio juego muy mal </li>
<li>116   Las blancas han jugado el medio juego mal </li>
<li>117   Las negras han jugado el medio juego mal </li>
<li>118   Las blancas han jugado el medio juego bien </li>
<li>119   Las negras han jugado el medio juego bien </li>
<li>120   Las blancas han jugado el medio juego muy bien </li>
<li>121   Las negras han jugado el medio juego muy bien </li>
<li>122   Las blancas han jugado el final muy mal </li>
<li>123   Las negras han jugado el final muy mal </li>
<li>124   Las blancas han jugado el final mal </li>
<li>125   Las negras han jugado el final mal </li>
<li>126   Las blancas han jugado el final bien </li>
<li>127   Las negras han jugado el final bien </li>
<li>128   Las blancas han jugado el final muy bien </li>
<li>129   Las negras han jugado el final muy bien </li>
<li>130   Las blancas tienen una dbil oportunidad de contraatacar </li>
<li>131   Las negras tienen una dbil oportunidad de contraatacar  </li>
<li>132   Las blancas tienen una pequea oportunidad de contraatacar  </li>
<li>133   Las negras tienen una pequea oportunidad de contraatacar  </li>
<li>134   Las blancas tienen una decisiva oportunidad de contraatacar  </li>
<li>135   Las negras tienen una decisiva oportunidad de contraatacar  </li>
<li>136   Las blancas tienen una moderada presin en el control de tiempo </li>
<li>137   Las negras tienen una moderada presin en el control de tiempo </li>
<li>138   Las blancas tienen una gran presin en el control de tiempo </li>
<li>139   Las negras tienen una gran presin en el control de tiempo </li>
</ul>
</cyan>

<p>
Otros valores NAG propuestos por Chess Informant incluyen:
</p>
<cyan>
<ul>
<li>140   con la idea ... </li>
<li>141   Apuntar contra ... </li>
<li>142   Mejor movimiento </li>
<li>143   Peor movimiento </li>
<li>144   Movimiento equivalente </li>
<li>145   Comentario del editor ("CE") </li>
<li>146   Novedad ("N") </li>
<li>147   Punto dbil </li>
<li>148   Final de la partida </li>
<li>149   Lnea </li>
<li>150   Diagonal </li>
<li>151   Las blancas tienen el par de alfiles </li>
<li>152   Las negras tienen el par de alfiles </li>
<li>153   Alfiles de colores opuestos </li>
<li>154   Alfiles de igual color </li>
</ul>
</cyan>

<p>
Otros valores sugeridos son:
</p>
<cyan>
<ul>
<li>190   Etc. </li>
<li>191   Peones doblados </li>
<li>192   Pen aislado </li>
<li>193   Peones conectados </li>
<li>194   Peones colgados </li>
<li>195   Pen trasero </li>
</ul>
</cyan>

<p>
Smbolos definidos por Scid para su propio uso:
</p>
<cyan>
<ul>
<il>201   Diagrama ("D", a veces designado con "#") </il>
</ul>
</cyan>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

###################
### ECO guide help:

set helpTitle(S,ECO) "Gua ECO"
set helpText(S,ECO) {<h1>Clasificacin de aperturas por ECO</h1>
<p>
Scid puede clasificar las partidas de acuerdo con la clasificacin de aperturas <b>ECO</b> (Encyclopaedia of Chess Openings).
Un cdigo ECO estndar consiste en una letra (A..E) seguida por dos dgitos, por lo que hay 500 cdigos ECO estndar distintos.
</p>
<p>
El sistema ECO es muy limitado y no es suficiente para las partidas actuales: algunos de los 500 cdigos casi no se vuelven a ver ms, mientras que otros se ven frecuentemente. Para mejorar esta situacin, Scid permite una extensin opcional a los cdigos ECO bsicos: cada cdigo puede ser ampliado con una letra (a..z), y con una extensin supletoria (otro dgito, 1..4) que no es usado todava en el archivo ECO estndar de Scid. Por lo que un cdigo ECO extendido por Scid se ve como "<b>A41e</b>" o "<b>E99b2</b>". Gran nmero de los cdigos ECO ms comnmente encontrados en las partidas actuales de los maestros tienen una extensin definida en el archivo ECO de Scid.
</p>

<h3><name Browser>La ventana del Buscador ECO</name></h3>
<p>
La ventana del <term>Buscador ECO</term> muestra la posicin que es usada para clasificar cada cdigo ECO, y la frecuencia y rendimiento de los cdigos ECO en la base de datos actual.
</p>
<p>
El panel superior muestra la frecuencia de cada cdigo ECO en la base de datos actual. Las barras del grfico tienen tres secciones: la inferior (de color ms claro) muestra el nmero de partidas ganadas por las blancas, la del medio muestra el nmero de tablas, y la superior (la ms oscura) muestra el nmero de las ganadas por las negras. Esto te permite ver de un vistazo las caractersticas de una apertura: por ejemplo, si las blancas puntan muy bien, o si son muy comunes las tablas.
</p>
<p>
Para ir a un nivel ECO ms profundo, aprieta el botn izquierdo del ratn sobre una barra del grfico (o escribe la letra o el dgito que corresponda). Para retroceder al nivel superior, aprieta el botn derecho del ratn en cualquier sitio del grfico, o aprieta la tecla de la flecha hacia la izquierda (o suprimir o espacio atrs (borrar)).
</p>
<p>
El panel inferior muestra las posiciones que incluye un cdigo ECO en particular, segn el archivo ECO que tengas cargado.
</p>

<h3>Cargando el archivo ECO de Scid</h3>
<p>
El archivo ECO que viene con Scid se llama <b>scid.eco</b>; Scid trata de cargarlo siempre que se enciende. Si Scid no puede encontrarlo, tendrs que hacer lo siguiente para habilitar la clasificacin ECO:
<ul>
<li>(a) En Scid, usa el comando del men
       <menu>Opciones: Cargar archivo ECO</menu>
       y selecciona el archivo <b>scid.eco</b>. </li>
<li>(b) Guardar opciones (desde el men <menu>Opciones</menu>). </li>
</ul>
Despus de hacer esto, el archivo ECO ser cargado cada vez que inicies Scid.
</p>

<h3>Sistema de cdigos ECO</h3>
<p>
La estructura bsica del sistema ECO es:
</p>
<p>
<li><b><blue><run updateEcoWin A>A</run></blue></b>   1.d4 Nf6 2...;  1.d4 ...;  1.c4;  1.various
<ul>
<li>  <b>A0</b>  1.Nf3;  1.f4;  1.<i>various</i>
      (<b>A02-A03</b>  1.f4: <i>Bird's Opening</i>;
       <b>A04-A09</b>  1.Nf3: <i>Reti; King's Indian Attack</i>) </li>
<li>  <b>A1</b>  1.c4 ...: <i>English</i> </li>
<li>  <b>A2</b>  1.c4 e5: <i>King's English</i> </li>
<li>  <b>A3</b>  1.c4 c5: <i>English, Symmetrical </i> </li>
<li>  <b>A4</b>  1.d4 ...: <i>Queen's Pawn</i> </li>
<li>  <b>A5</b>  1.d4 Nf6 2.c4 ..: <i>Indian Defence </i> </li>
<li>  <b>A6</b>  1.d4 Nf6 2.c4 c5 3.d5 e6: <i>Modern Benoni</i> </li>
<li>  <b>A7</b>  A6 + 4.Nc3 exd5 5.cxd5 d6 6.e4 g6 7.Nf3 </li>
<li>  <b>A8</b>  1.d4 f5: <i>Dutch Defence</i> </li>
<li>  <b>A9</b>  1.d4 f5 2.c4 e6: <i>Dutch Defence</i> </li>
</ul>

<p>
<b><blue><run updateEcoWin B>B</run></blue></b>   1.e4 c5;  1.e4 c6;  1.e4 d6;  1.e4 <i>various</i>
<ul>
<li>  <b>B0</b>  1.e4 ...
      (<b>B02-B05</b>  1.e4 Nf6: <i>Alekhine Defence</i>;
       <b>B07-B09</b>  1.e4 d6: <i>Pirc</i>) </li>
<li>  <b>B1</b>  1.e4 c6: <i>Caro-Kann</i> </li>
<li>  <b>B2</b>  1.e4 c5: <i>Sicilian Defence </i> </li>
<li>  <b>B3</b>  1.e4 c5 2.Nf3 Nc6: <i>Sicilian</i> </li>
<li>  <b>B4</b>  1.e4 c5 2.Nf3 e6: <i>Sicilian</i> </li>
<li>  <b>B5</b>  1.e4 c5 2.Nf3 d6: <i>Sicilian</i> </li>
<li>  <b>B6</b>  B5 + 3.d4 cxd4 4.Nxd4 Nf6 5.Nc3 Nc6 </li>
<li>  <b>B7</b>  B5 + 4.Nxd4 Nf6 5.Nc3 g6: <i>Sicilian Dragon</i> </li>
<li>  <b>B8</b>  B5 + 4.Nxd4 Nf6 5.Nc3 e6: <i>Sicilian Scheveningen</i> </li>
<li>  <b>B9</b>  B5 + 4.Nxd4 Nf6 5.Nc3 a6: <i>Sicilian Najdorf</i> </li>
</ul>

<p>
<b><blue><run updateEcoWin C>C</run></blue></b>   1.e4 e5;  1.e4 e6
<ul>
<li>  <b>C0</b>  1.e4 e6: <i>French Defence</i> </li>
<li>  <b>C1</b>  1.e4 e6 2.d4 d5 3.Nc3: <i>French, Winawer/Classical</i> </li>
<li>  <b>C2</b>  1.e4 e5: <i>Open Game</i> </li>
<li>  <b>C3</b>  1.e4 e5 2.f4: <i>King's Gambit</i> </li>
<li>  <b>C4</b>  1.e4 e5 2.Nf3: <i>Open Game</i> </li>
<li>  <b>C5</b>  1.e4 e5 2.Nf3 Nc6 3.Bc4: <i>Italian; Two Knights</i> </li>
<li>  <b>C6</b>  1.e4 e5 2.Nf3 Nc6 3.Bb5: <i>Spanish (Ruy Lopez)<i> </li>
<li>  <b>C7</b>  1.e4 e5 2.Nf3 Nc6 3.Bb5 a6 4.Ba4: <i>Spanish</i> </li>
<li>  <b>C8</b>  C7 + 4...Nf6 5.O-O: <i>Spanish, Closed and Open</i>
        (<b>C80-C83</b>  5.O-O Nxe4: <i>Spanish, Open System</i>;
         <b>C84-C89</b>  5.O-O Be7: <i>Spanish, Closed System</i>) </li>
<li>  <b>C9</b>  C8 + 5...Be7 6.Re1 b5 7.Bb3 d6: <i>Spanish, Closed</i> </li>
</ul>

<p>
<b><blue><run updateEcoWin D>D</run></blue></b>   1.d4 d5; 1.d4 Nf6 2.c4 g6 with 3...d5
<ul>
<li>  <b>D0</b>   1.d4 d5: <i>Queen's Pawn</i> </li>
<li>  <b>D1</b>   1.d4 d5 2.c4 c6: <i>Slav Defence</i> </li>
<li>  <b>D2</b>  1.d4 d5 2.c4 dxc4: <i>Queen's Gambit Accepted (QGA)</i> </li>
<li>  <b>D3</b>  1.d4 d5 2.c4 e6: <i>Queen's Gambit Declined (QGD)</i> </li>
<li>  <b>D4</b>  D3 + 3.Nc3 Nf6 4.Nf3 c5/c6: <i>Semi-Tarrasch; Semi-Slav</i> </li>
<li>  <b>D5</b>  D3 + 3.Nc3 Nf6 4.Bg5: <i>QGD Classical</i> </li>
<li>  <b>D6</b>  D5 + 4...Be7 5.e3 O-O 6.Nf3 Nbd7: <i>QGD Orthodox</i> </li>
<li>  <b>D7</b>  1.d4 Nf6 2.c4 g6 with 3...d5: <i>Grunfeld</i> </li>
<li>  <b>D8</b>  1.d4 Nf6 2.c4 g6 3.Nc3 d5: <i>Grunfeld</i> </li>
<li>  <b>D9</b>  1.d4 Nf6 2.c4 g6 3.Nc3 d5 4.Nf3: <i>Grunfeld</i> </li>
</ul>

<p>
<b><blue><run updateEcoWin E>E</run></blue></b>   1.d4 Nf6 2.c4 e6; 1.d4 Nf6 2.c4 g6
<ul>
<li>  <b>E0</b>  1.d4 Nf6 2.c4 e6: <i>Catalan, etc</i> </li>
<li>  <b>E1</b>  1.d4 Nf6 2.c4 e6 3.Nf3 (b6): <i>Queen's Indian, etc</i> </li>
<li>  <b>E2</b>  1.d4 Nf6 2.c4 e6 3.Nc3 (Bb4): <i>Nimzo-Indian, etc</i> </li>
<li>  <b>E3</b>  E2 + 4.Bg5 or 4.Qc2: <i>Nimzo-Indian</i> </li>
<li>  <b>E4</b>  E2 + 4.e3: <i>Nimzo-Indian, Rubinstein</i> </li>
<li>  <b>E5</b>  E4 + 4...O-O 5.Nf3: <i>Nimzo-Indian, main line</i> </li>
<li>  <b>E6</b>  1.d4 Nf6 2.c4 g6: <i>King's Indian</i> </li>
<li>  <b>E7</b>  1.d4 Nf6 2.c4 g6 3.Nc3 Bg7 4.e4: <i>King's Indian</i> </li>
<li>  <b>E8</b>  E7 + 4...d6 5.f3: <i>King's Indian, Samisch</i> </li>
<li>  <b>E9</b>  E7 + 4...d6 5.Nf3: <i>King's Indian, main lines</i> </li>
</ul>

<p><footer>(Actualizado: Scid 2.5, Junio 2001)</footer></p>
}

#############################
### Contact information help:

set helpTitle(S,Author) "Informacin de contacto"
set helpText(S,Author) {<h1>Informacin de contacto</h1>
<p>
La pgina de Scid se encuentra en:: <br>
<li><b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>
</p>
<p>
Esta tiene la ltima versin de Scid para bajarse y cualquier otro archivo extra que est disponible.
</p>
<p>
Por favor enva cualquier comentario, pregunta, sugerencia o informe de errores al autor de Scid, Shane Hudson, al E-mail:<br>
<li><b>sgh@users.sourceforge.net</b>
</p>

<h3><name Related>Links relacionados</name></h3>
<p>
Si disfrutas con Scid, encontrars los siguientes sitios web interesantes:
</p>
<ul>
<li><url http://www.tim-mann.org/chess.html>http://www.tim_mann.org/chess.html</url> --
Pgina personal del programa <b>xboard y winboard</b> de Tim Mann, el cual es un lector PGN y un interfaz para los servidores de ajedrez de internet. Adems tiene informacin interesante sobre Crafty, GNUchess y otros programas gratuitos.</li>

<li><url ftp://ftp.cis.uab.edu/pub/hyatt/>ftp://ftp.cis.uab.edu/pub/hyatt/</url> --
El fuerte programa de ajedrez Crafty: El subdirectorio llamado <b>TB</b> tiene gran nmero de archivos de finales (tablebase) en formato Nalimov, los cuales puedes usar en muchos programas de ajedrez y en Scid.</li>

<li><url http://www.chesscenter.com/twic/>http://www.chesscenter.com/twic/</url> -- TWIC (the week in chess), un excelente boletn semanal de partidas de ajedrez disponibles en formato PGN.</li>

<li><url http://scid.sourceforge.net/standard.txt>http://scid.sourceforge.net/standard.txt</url> -- El <b>Estndar PGN</b>, creado por Steven J. Edwards en 1994. Este archivo de texto explica los formatos PGN y EPD detalladamente.</li>
</ul>

<p><footer>(Actualizado: Scid 2.6, Agosto 2001)</footer></p>
}

