# spanish.tcl:
# Spanish translations for Scid.
# Contributed by Jordi Gonzlez Boada.
# Updated by Enrique Lopez.
# Untranslated messages are marked with a "***" comment.

addLanguage S Espanol 1

proc setLanguage_S {} {

# File menu:
menuText S File "Archivo" 0
menuText S FileNew "Nuevo..." 0 {Crea una nueva base de datos Scid vaca}
menuText S FileOpen "Abrir..." 1 {Abre una base de datos Scid ya existente}
menuText S FileClose "Cerrar" 0 {Cierra la base de datos Scid activa}
menuText S FileFinder "Visor..." 0 {Abre la ventana del visor de Archivos}
menuText S FileBookmarks "Bookmarks" 0 {Bookmarks menu (shortcut: Ctrl+B)}
menuText S FileBookmarksAdd "Aadir marcador" 0 \
  {Seala la partida y posicin actual de la base de datos}
menuText S FileBookmarksFile "Archivar marcador" 8 \
  {Archiva un marcador para la partida y posicin actual}
menuText S FileBookmarksEdit "Editar marcadores..." 0 \
  {Edita los menus de los marcadores}
menuText S FileBookmarksList "Mostrar las corpetas en una sola lista" 0 \
  {Muestrar las corpetas de marcadores en una sola lista, sin submenus}
menuText S FileBookmarksSub "Mostrar carpetas como submenus" 0 \
  {Muestrar las corpetas de marcadores como submenus, no una sola lista}
menuText S FileMaint "Mantenimiento" 0 \
  {Herramientas de mantenimiento de la base de datos Scid}
menuText S FileMaintWin "Ventana de mantenimiento" 0 \
  {Abre/cierra la ventana de mantenimiento de la base de datos Scid}
menuText S FileMaintCompact "Compactar base de datos..." 0 \
  {Compacta los archivos de la base de datos, quitando partidas borradas y nombres no usados}
menuText S FileMaintClass "Clasificar partidas por ECO..." 24 \
  {Recalcula el cdigo ECO de todas las partidas}
menuText S FileMaintSort "Ordenar base de datos..." 0 \
  {Ordena todas las partidas de la base de datos}
menuText S FileMaintDelete "Borrar partidas dobles..." 0 \
  {Encuentra partidas dobles y las coloca para ser borradas}
menuText S FileMaintTwin "Ventana de inspeccin de dobles" 11 \
  {Abre/actualiza la ventana de inspeccin de dobles}
menuText S FileMaintName "Ortografa de nombres" 0 {Herramientas de ortografa y edicin de nombres}
menuText S FileMaintNameEditor "Ventana de edicin de nombres" 22 \
  {Abre/cierra la ventana de edicin de nombres}
menuText S FileMaintNamePlayer "Comprobacin ortogrfica de nombres de jugadores..." 39 \
  {Comprobacin ortogrfica de jugadores usando archivo de comprobacin ortogrfica}
menuText S FileMaintNameEvent "Comprobacin ortogrfica de nombres de eventos..." 39 \
  {Comprobacin ortogrfica de eventos usando el archivo de comprobacin ortogrfica}
menuText S FileMaintNameSite "Comprobacin ortogrfica de nombres de lugares..." 39 \
  {Comprobacin ortogrfica de lugares usando el archivo de comprobacin ortogrfica}
menuText S FileMaintNameRound "Comprobacin ortogrfica de rondas..." 28 \
  {Comprobacin ortogrfica de rondas usando el archivo de comprobacin ortogrfica}
menuText S FileReadOnly "Slo lectura..." 5 \
  {Trata la actual base de datos como de slo lectura, previniendo cambios}
menuText S FileSwitch "Cambiar de base de datos" 0 \
  {Cambia a una base de dator abierta diferente}
menuText S FileExit "Salir" 0 {Salir de Scid}

# Edit menu:
menuText S Edit "Editar" 0
menuText S EditAdd "Aadir variacin" 0 \
  {Aade una variacin a este movimiento en la partida}
menuText S EditDelete "Borrar variacin" 0 {Borra variacin para este movimiento}
menuText S EditFirst "Convertir en primera variacin" 0 \
  {Hace que una variacin sea la primera en la lista}
menuText S EditMain "Variacin a lnea principal" 0 \
   {Promover una variacin para que sea la lnea principal}
menuText S EditTrial "Probar variacin" 1 \
  {Inicia/para el modo de prueba, para ensayar una idea en el tablero}
menuText S EditStrip "Eliminar" 2 \
  {Eliminar comentarios o variaciones de esta partida}
menuText S EditStripComments "Comentarios" 0 \
  {Quita todos los comentarios y variaciones de esta partida}
menuText S EditStripVars "Variaciones" 0 {Quita todas las variaciones de esta partida}
menuText S EditStripBegin "Movimientos desde el principio" 1 \
  {Quita los movimientos desde el principio de la partida}
menuText S EditStripEnd "Movimientos hasta el final" 0 \
  {Quita los movimientos hasta el final de la partida}
menuText S EditReset "Poner a cero la base de trabajo" 0 \
  {Pone a cero la base de trabajo (clipbase) para que est completamente vaca}
menuText S EditCopy "Copiar esta partida a la base de trabajo" 1 \
  {Copia esta partida a la base de trabajo (clipbase)}
menuText S EditPaste "Pegar la ltima partida de la base de trabajo" 2 \
  {Pega la partida activa en la base de trabajo (clipbase) aqu}
menuText S EditPastePGN "Paste Clipboard text as PGN game..." 10 \
  {Interpreta el texto  de la base de trabajo (clipbase) como una partida en notacion PGN y la pega aqu}
menuText S EditSetup "Iniciar tablero de posicin..." 26 \
  {Inicia el tablero de posicin con la posicin de la partida}
menuText S EditCopyBoard "Copiar posicin" 8 \
  {Copia el tablero actual en notacin FEN a la seleccin de texto (clipboard)}
menuText S EditPasteBoard "Pegar tablero inicial" 6 \
  {Coloca el tablero inicial de la seleccin de texto actual (clipboard)}

# Game menu:
menuText S Game "Partida" 0
menuText S GameNew "Limpiar partida" 0 \
  {Vuelve a una partida limpia, descartando cualquier cambio}
menuText S GameFirst "Cargar primera partida" 7 {Carga la primera partida filtrada}
menuText S GamePrev "Cargar partida anterior" 16 {Carga la anterior partida filtrada}
menuText S GameReload "Recargar partida actual" 0 \
  {Vuelve a cargar esta partida, descartando cualquier cambio hecho}
menuText S GameNext "Cargar siguiente partida" 7 {Carga la siguiente partida filtrada}
menuText S GameLast "Cargar ltima partida" 9 {Carga la ltima partida filtrada}
menuText S GameRandom "Cargar partida aleatoria" 16 {Carga aleatoriamente una partida filtrada}
menuText S GameNumber "Cargar partida nmero..." 3 \
  {Carga una partida poniendo su nmero}
menuText S GameReplace "Guardar: Reemplazar partida..." 10 \
  {Guarda esta partida, reemplazando la antigua versin}
menuText S GameAdd "Guardar: Aadir nueva partida..." 9 \
  {Guarda esta partida como una nueva partida en la base de datos}
menuText S GameDeepest "Identificar apertura" 1 \
  {Va a la posicin ms avanzada de la partida segn el libro ECO}
menuText S GameGotoMove "Ir al movimiento nmero..." 6 \
  {Ir al nmero de movimiento especificado en la partida actual}
menuText S GameNovelty "Encontrar Novedad..." 12 \
  {Encuentra el primer movimiento de esta partida que no se ha jugado antes}

# Search Menu:
menuText S Search "Buscar" 0
menuText S SearchReset "Poner a cero el filtro" 0 \
  {Poner a cero el filtro para que todas la partidas estn incluidas}
menuText S SearchNegate "Invertir filtro" 0 \
  {Invierte el filtro para slo incluir las partidas excluidas}
menuText S SearchCurrent "Tablero actual..." 0 \
  {Busca por la posicin actual del tablero}
menuText S SearchHeader "Encabezamiento..." 0 \
  {Busca por informacin de encabezamiento (jugador, evento, etc)}
menuText S SearchMaterial "Material/Patrn..." 0 \
  {Busca por material o patrn del tablero}
menuText S SearchUsing "Usar archivo de bsqueda..." 0 \
  {Busca usando un archivo de opciones de bsqueda}

# Windows menu:
menuText S Windows "Ventanas" 0
menuText S WindowsComment "Editor de comentarios" 0 \
  {Abre/cierra el editor de comentarios}
menuText S WindowsGList "Listado de partidas" 0 \
  {Abre/cierra la  ventana de listado de partidas}
menuText S WindowsPGN "Ventana PGN" 8 \
  {Abre/cierra la ventana de PGN (notacin de partida)}
menuText S WindowsPList "Buscador de jugadores" 2 {Abre/cierra el buscador de jugadores}
menuText S WindowsTmt "Visor de Torneos" 9 {Abre/cierra el visor de torneos}
menuText S WindowsSwitcher "Intercambiador de bases de datos" 0 \
  {Abre/cierra la ventana del intercambiador de bases de datos}
menuText S WindowsMaint "Ventana de mantenimiento" 11 \
  {Abre/cierra la ventana de mantenimiento}
menuText S WindowsECO "Buscador ECO" 0 {Abre/cierra la ventana del buscador ECO}
menuText S WindowsRepertoire "Editor de repertorio" 10 \
  {Abrir/cerrar el editor de repertorio de aperturas}
menuText S WindowsStats "Ventana de estadsticas" 12 \
  {Abre/cierra la ventana de estadsticas del filtro}
menuText S WindowsTree "Ventana de rbol" 6 {Abre/cierra la ventana de rbol}
menuText S WindowsTB "Ventana de TBs" 8 \
  {Abre/cierra la ventana de TBs}

# Tools menu:
menuText S Tools "Herramientas" 0
menuText S ToolsAnalysis "Motor de anlisis..." 0 \
  {Inicia/para el anlisis de un motor de ajedrez}
menuText S ToolsAnalysis2 "Motor de anlisis #2..." 18 \
  {Inicia/para el anlisis de un motor de ajedrez}
menuText S ToolsCross "Tabla cruzada" 0 {Muestra la tabla cruzada para esta partida}
menuText S ToolsEmail "Administrador de Email" 0 \
  {Abre/cierra la ventana del administrador de Email}
menuText S ToolsFilterGraph "Filtro grfico" 7 \
  {Abre/cierra la ventana del filtro grfico}
menuText S ToolsOpReport "Informe de la apertura" 1 \
  {Crea un informe de la apertura para la posicin actual}
menuText S ToolsTracker "Rastreador de piezas"  14 {Abre la ventana del rastreador de piezas}
menuText S ToolsPInfo "Informacin del Jugador" 16 \
  {Abrir/actualizar la ventana de Informacin del Jugador}
menuText S ToolsPlayerReport "Informe del jugador..." 3 \
  {Crea un informe sobre un jugador}
menuText S ToolsRating "Grfico del Elo" 0 \
  {Grfico de la historia del Elo de los jugadores de la actual partida}
menuText S ToolsScore "Grfico de puntuacin" 1 \
  {Muestra la ventana del grfico de puntuacin}
menuText S ToolsExpCurrent "Exportar la partida actual" 0 \
  {Escribe la partida actual en un archivo de texto}
menuText S ToolsExpCurrentPGN "Exportar la partida a un archivo PGN..." 33 \
  {Escribe la partida actual en un archivo PGN}
menuText S ToolsExpCurrentHTML "Exportar la partida a un archivo HTML..." 33 \
  {Escribe la partida actual en un archivo HTML}
menuText S ToolsExpCurrentLaTeX "Exportar la partida a un archivo LaTeX..." 33 \
  {Escribe la partida actual en un archivo LaTeX}
menuText S ToolsExpFilter "Exportar todas las partidas filtradas" 1 \
  {Escribe todas las partidas filtradas en un archivo de texto}
menuText S ToolsExpFilterPGN "Exportar filtro a un archivo PGN..." 29 \
  {Escribe todas las partidas filtradas en un archivo PGN}
menuText S ToolsExpFilterHTML "Exportar filtro a un archivo HTML..." 29 \
  {Escribe todas las partidas filtradas en un archivo HTML}
menuText S ToolsExpFilterLaTeX "Exportar filtro a un archivo LaTeX..." 29 \
  {Escribe todas las partidas filtradas en un archivo LaTeX}
menuText S ToolsImportOne "Importar una partida PGN..." 0 \
  {Importa una partida de un texto PGN}
menuText S ToolsImportFile "Importar un archivo de partidas PGN..." 2 \
  {Importa partidas de un archivo PGN}

# Options menu:
menuText S Options "Opciones" 0
menuText S OptionsBoard "Tablero" 0 {Opciones sobre el aspecto del tablero}
menuText S OptionsBoardSize "Tamao del tablero" 0 {Cambia el tamao del tablero}
menuText S OptionsBoardPieces "Estilo de piezas" 10 \
  {Cambia el estilo de piezas del tablero}
menuText S OptionsBoardColors "Colores..." 0 {Cambia los colores del tablero}
menuText S OptionsBoardNames "Mis nombres de jugador..." 0 {Edita mis nombres de jugador}
menuText S OptionsExport "Exportacin" 0 {Cambia las opciones de exportacin de texto}
menuText S OptionsFonts "Fuentes" 0 {Cambia las fuentes}
menuText S OptionsFontsRegular "Habitual" 0 {Cambia la fuente habitual}
menuText S OptionsFontsMenu "Men" 0 {Cambia la fuente del men}
menuText S OptionsFontsSmall "Pequea" 0 {Cambia la fuente pequea}
menuText S OptionsFontsFixed "Fijada" 0 {Cambia la anchura fijada de la fuente}
menuText S OptionsGInfo "Informacin de la partida" 0 {Informacin de la partida}
menuText S OptionsLanguage "Lenguaje" 0 {Selecciona el lenguaje del men}
menuText S OptionsMoves "Movimientos" 0 {Opciones de la entrada de movimientos}
menuText S OptionsMovesAsk "Preguntar antes de reemplazar movimientos" 0 \
  {Pregunta antes de sobreescribir cualquier movimiento existente}
menuText S OptionsMovesAnimate "Velocidad de la animacin" 1 \
  {Pone el tiempo usado para animar las jugadas}
menuText S OptionsMovesDelay "Demora del automovimiento..." 0 \
  {Pone el tiempo de demora para el modo de automovimiento}
menuText S OptionsMovesCoord "Entrada de movimientos coordinada" 0 \
  {Acepta entrada de movimientos en sistema "coordinado" ("g1f3")}
menuText S OptionsMovesSuggest "Mostrar movimientos sugeridos" 20 \
  {Activa/desactiva la sugerencia de movimientos}
menuText S OptionsMovesKey "Teclado Inteligente" 0 \
{Activa/desactiva la funcin de autocompletado inteligente de movimientos
con teclado}
menuText S OptionsNumbers "Formato de nmeros" 11 {Selecciona el formato de nmeros}
menuText S OptionsStartup "Inicio" 3 {Seleccionar ventanas a abrir al inicio}
menuText S OptionsWindows "Ventanas" 0 {Opciones de ventana}
menuText S OptionsWindowsIconify "Autominimizar" 4 \
  {Minimiza todas las ventanas cuando la ventana principal es minimizada}
menuText S OptionsWindowsRaise "Poner a la vista automticamente" 0 \
  {Hace visibles ciertas ventanas (ej. barras de progreso) siempre que sean tapadas}
menuText S OptionsSounds "Sounds..." 2 {Configura el sonido del anuncio de las jugadas}
menuText S OptionsToolbar "Barra de herramientas ventana principal" 9 \
  {Muestra/oculta la barra de herramientas de la ventana principal}
menuText S OptionsECO "Cargar archivo ECO..." 7 \
  {Cargar el archivo de clasificacin ECO}
menuText S OptionsSpell "Cargar archivo de comprobacin ortogrfica..." 2 \
  {Carga el archivo de comprobacin ortogrfica Scid}
menuText S OptionsTable "Directorio de las TB..." 19 \
  {Selecciona el directorio de finales; todas las TB de ese directorio sern usadas}
menuText S OptionsRecent "Archivos recientes..." 9 \
  {Cambia el nmero de archivos recientes mostrados en el men Archivo}
menuText S OptionsSave "Guardar opciones" 0 \
  "Guarda todas las opciones en el fichero $::optionsFile"
menuText S OptionsAutoSave "Autoguardar opciones al salir" 0 \
  {Guarda automticamente todas las opciones cuando se sale de Scid}

# Help menu:
menuText S Help "Ayuda" 1
menuText S HelpContents "Contenidos" 0 {Show the help contents page}
menuText S HelpIndex "Indice" 0 {Muestra la pgina ndice de la ayuda}
menuText S HelpGuide "Gua rpida" 0 {Muestra la pgina de la ayuda gua rpida}
menuText S HelpHints "Sugerencias" 1 {Muestra la pgina de la ayuda sugerencias}
menuText S HelpContact "Informacin de contacto" 15 \
  {Muestra la pgina de la ayuda de la informacin de contacto}
menuText S HelpTip "Sugerencia del da" 0 {Muestra una til sugerencia Scid}
menuText S HelpStartup "Ventana de inicio" 0 {Muestra la ventana de inicio}
menuText S HelpAbout "Acerca de Scid" 10 {Informacin acerca de Scid}

# Game info box popup menu:
menuText S GInfoHideNext "Ocultar siguiente movimiento" 0
menuText S GInfoMaterial "Mostrar valor del material" 0
menuText S GInfoFEN "Mostrar FEN" 8
menuText S GInfoMarks "Mostrar casillas y flechas coloreadas" 29
menuText S GInfoWrap "Dividir lneas largas" 0
menuText S GInfoFullComment "Mostrar comentarios completos" 8
menuText S GInfoPhotos "Mostrar fotos" 5
menuText S GInfoTBNothing "TBs: nada" 5
menuText S GInfoTBResult  "TBs: slo resultado" 10
menuText S GInfoTBAll "TBs: resultado y mejor movimiento" 23
menuText S GInfoDelete "(No)Borrar esta partida" 4
menuText S GInfoMark "(No)Marcar esta partida" 4

# Main window buttons:
helpMsg S .button.start {Ir al principio de la partida  (Tecla: Inicio)}
helpMsg S .button.end {Ir al final de la partida  (Tecla: Fin)}
helpMsg S .button.back {Ir atrs un movimiento  (Tecla: Flecha izquierda)}
helpMsg S .button.forward {Ir adelante un movimiento  (Tecla: Flecha derecha)}
helpMsg S .button.intoVar {Moverse dentro de una variacin  (Tecla rpida: v)}
helpMsg S .button.exitVar {Dejar la variacin actual  (Tecla rpida: z)}
helpMsg S .button.flip {Girar tablero  (Tecla rpida: .)}
helpMsg S .button.coords {Poner/quitar las coordenadas del tablero  (Tecla rpida: 0)}
helpMsg S .button.stm {Activa/Desactiva el icono de Turno de Juego}
helpMsg S .button.autoplay {Automovimiento de los movimientos  (Tecla: Ctrl+Z)}

# General buttons:
translate S Back {Atrs}
translate S Browse {Navegar}
translate S Cancel {Cancelar}
translate S Clear {Limpiar}
translate S Close {Cerrar}
translate S Contents {Contenidos}
translate S Defaults {Por defecto}
translate S Delete {Borrar}
translate S Graph {Grfico}
translate S Help {Ayuda}
translate S Import {Importar}
translate S Index {ndice}
translate S LoadGame {Cargar partida}
translate S BrowseGame {Buscar partida}
translate S MergeGame {Incorporar partida}
translate S Preview {Vista previa}
translate S Revert {Retroceder}
translate S Save {Guardar}
translate S Search {Buscar}
translate S Stop {Parar}
translate S Store {Almacenar}
translate S Update {Actualizar}
translate S ChangeOrient {Cambiar orientacin de la ventana}
translate S ShowIcons {Show Icons} ;# ***
translate S None {Ninguno}
translate S First {Primera}
translate S Current {Actual}
translate S Last {ltima}

# General messages:
translate S game {partida}
translate S games {partidas}
translate S move {movimiento}
translate S moves {movimientos}
translate S all {todo}
translate S Yes {S}
translate S No {No}
translate S Both {Ambos}
translate S King {Rey}
translate S Queen {Dama}
translate S Rook {Torre}
translate S Bishop {Alfil}
translate S Knight {Caballo}
translate S Pawn {Pen}
translate S White {Blanco}
translate S Black {Negro}
translate S Player {Jugador}
translate S Rating {Elo}
translate S RatingDiff {Diferencia de Elo (Blanco - Negro)}
translate S AverageRating {Clasificacin promedio}
translate S Event {Evento}
translate S Site {Lugar}
translate S Country {Pas}
translate S IgnoreColors {Ignorar colores}
translate S Date {Fecha}
translate S EventDate {Evento fecha}
translate S Decade {Dcada}
translate S Year {Ao}
translate S Month {Mes}
translate S Months {enero febrero marzo abril mayo junio
  julio agosto septiembre octubre noviembre diciembre}
translate S Days {dom lun mar mi jue vie sb}
translate S YearToToday {ltimo ao hasta hoy}
translate S Result {Resultado}
translate S Round {Ronda}
translate S Length {Longitud}
translate S ECOCode {Cdigo ECO}
translate S ECO {ECO}
translate S Deleted {Borrado}
translate S SearchResults {Buscar resultados}
translate S OpeningTheDatabase {Abriendo base de datos}
translate S Database {Base de datos}
translate S Filter {Filtro}
translate S noGames {no hay partidas}
translate S allGames {todas las partidas}
translate S empty {vaca}
translate S clipbase {clipbase}
translate S score {puntuacin}
translate S StartPos {Posicin inicial}
translate S Total {Total}
translate S readonly {slo lectura}

# Standard error messages:
translate S ErrNotOpen {Esta base de datos no est abierta.}
translate S ErrReadOnly {Esta base de datos es de slo lectura; no puede ser cambiada.}
translate S ErrSearchInterrupted {La busqueda se interrumpio; los resultados son incompletos.}

# Game information:
translate S twin {doble}
translate S deleted {borradas}
translate S comment {comentario}
translate S hidden {oculto}
translate S LastMove {ltimo movimiento}
translate S NextMove {Siguiente}
translate S GameStart {Inicio de partida}
translate S LineStart {Inicio de lnea}
translate S GameEnd {Fin de partida}
translate S LineEnd {Fin de lnea}

# Player information:
translate S PInfoAll {Resultados para <b>todas</b> las partidas}
translate S PInfoFilter {Resultados para las partidas <b>filtradas</b>}
translate S PInfoAgainst {Resultados contra}
translate S PInfoMostWhite {Aperturas ms comunes con Blancas}
translate S PInfoMostBlack {Aperturas ms comunes con Negras}
translate S PInfoRating {Historial de clasificacin}
translate S PInfoBio {Biografa}
translate S PInfoEditRatings {Editar elos}

# Tablebase information:
translate S Draw {Tablas}
translate S stalemate {rey ahogado}
translate S withAllMoves {con todos los movimientos}
translate S withAllButOneMove {con todos los movimientos excepto uno}
translate S with {con}
translate S only {slo}
translate S lose {formas de perder}
translate S loses {hace perder}
translate S allOthersLose {todos los dems hacen perder}
translate S matesIn {mate en}
translate S hasCheckmated {jaque mate}
translate S longest {el mate ms largo}
translate S WinningMoves {Movimientos ganadores}
translate S DrawingMoves {Movimientos para tablas}
translate S LosingMoves {Movimientos perdedores}
translate S UnknownMoves {Movimientos de resultado desconocido}

# Tip of the day:
translate S Tip {Sugerencia}
translate S TipAtStartup {Sugerencia al iniciar}

# Tree window menus:
menuText S TreeFile "Archivo" 0
menuText S TreeFileSave "Guardar archivo cach" 0 \
  {Guarda el archivo cach del rbol (.stc)}
menuText S TreeFileFill "Construir archivo cach" 2 \
  {Construir archivo cach con posiciones de apertura comunes}
menuText S TreeFileBest "Lista de mejores partidas" 9 {Muestra la lista del rbol de mejores partidas}
menuText S TreeFileGraph "Ventana del grfico" 0 \
  {Muestra el grfico para esta rama del rbol}
menuText S TreeFileCopy "Copiar texto del rbol al clipboard" 1 \
  {Copiar texto del rbol al clipboard}
menuText S TreeFileClose "Cerrar ventana del rbol" 0 \
  {Cerrar ventana del rbol}
menuText S TreeSort "Ordenar" 0
menuText S TreeSortAlpha "Alfabticamente" 0
menuText S TreeSortECO "Por cdigo ECO" 11
menuText S TreeSortFreq "Por frecuencia" 4
menuText S TreeSortScore "Por puntuacin" 4
menuText S TreeOpt "Opciones" 1
menuText S TreeOptLock "Bloquear" 1 {Bloquea/desbloquea el rbol de la base de datos actual}
menuText S TreeOptTraining "Entrenamiento" 2 {Activa/desactiva el modo de entrenamiento de rbol}
menuText S TreeOptAutosave "Autoguardar archivo cach" 0 \
  {Guarda automticamente el archivo cach cuuando se cierra la ventana de rbol}
menuText S TreeHelp "Ayuda" 1
menuText S TreeHelpTree "Ayuda del rbol" 4
menuText S TreeHelpIndex "Indice de la ayuda" 0
translate S SaveCache {Guardar cach}
translate S Training {Entrenamiento}
translate S LockTree {Bloquear}
translate S TreeLocked {Bloqueado}
translate S TreeBest {Mejor}
translate S TreeBestGames {Mejores partidas del rbol}
# Note: the next message is the tree window title row. After editing it,
# check the tree window to make sure it lines up with the actual columns.
translate S TreeTitleRow \
  {    Movim. ECO       Frecuencia   Puntu. AvElo Perf AvAo %Tablas}
translate S TreeTotal {TOTAL}

# Finder window:
menuText S FinderFile "Archivo" 0
menuText S FinderFileSubdirs "Mirar en subdirectorios" 0
menuText S FinderFileClose "Cierra visor de Archivos" 0
menuText S FinderSort "Ordenar" 0
menuText S FinderSortType "Tipo" 0
menuText S FinderSortSize "Tamao" 0
menuText S FinderSortMod "Modificado" 0
menuText S FinderSortName "Nombre" 0
menuText S FinderSortPath "Camino" 0
menuText S FinderTypes "Tipos" 0
menuText S FinderTypesScid "Bases de datos Scid" 0
menuText S FinderTypesOld "Bases de datos Scid en antiguo formato" 12
menuText S FinderTypesPGN "Archivos PGN" 9
menuText S FinderTypesEPD "Archivos EPD (libro)" 0
menuText S FinderTypesRep "Archivos de Repertorio" 12
menuText S FinderHelp "Ayuda" 1
menuText S FinderHelpFinder "Ayuda del visor de Archivos" 0
menuText S FinderHelpIndex "Indice de la ayuda" 0
translate S FileFinder {Visor de Archivos}
translate S FinderDir {Directorio}
translate S FinderDirs {Directorios}
translate S FinderFiles {Archivos}
translate S FinderUpDir {arriba}

# Player finder:
menuText S PListFile "Archivo" 0
menuText S PListFileUpdate "Actualizar" 0
menuText S PListFileClose "Cierra el Buscador de Jugadores" 0
menuText S PListSort "Ordenar" 0
menuText S PListSortName "Nombre" 0
menuText S PListSortElo "Elo" 0
menuText S PListSortGames "Partidas" 0
menuText S PListSortOldest "Ms antiguo" 10
menuText S PListSortNewest "Ms nuevo" 4

# Tournament finder:
menuText S TmtFile "Archivo" 0
menuText S TmtFileUpdate "Actualizar" 0
menuText S TmtFileClose "Cierra el Visor de Torneos" 0
menuText S TmtSort "Ordenar" 0
menuText S TmtSortDate "Fecha" 0
menuText S TmtSortPlayers "Jugadores" 0
menuText S TmtSortGames "Partidas" 0
menuText S TmtSortElo "Elo" 0
menuText S TmtSortSite "Lugar" 0
menuText S TmtSortEvent "Evento" 1
menuText S TmtSortWinner "Ganador" 0
translate S TmtLimit "Lmite de lista"
translate S TmtMeanElo "Media de Elo inferior"
translate S TmtNone "No se han encontrado torneos concordantes."

# Graph windows:
menuText S GraphFile "Archivo" 0
menuText S GraphFileColor "Guardar como Postscript Color..." 24
menuText S GraphFileGrey "Guardar como Postscript escala de grises..." 34
menuText S GraphFileClose "Cerrar ventana" 7
menuText S GraphOptions "Opciones" 0
menuText S GraphOptionsWhite "Blanco" 0
menuText S GraphOptionsBlack "Negro" 0
menuText S GraphOptionsBoth "Ambos" 0
menuText S GraphOptionsPInfo "Jugador Informacin jugador" 0
translate S GraphFilterTitle "Filtro grfico: frecuencia por 1000 partidas"

# Analysis window:
translate S AddVariation {Aadir variacin}
translate S AddMove {Aadir movimiento}
translate S Annotate {Anotar}
translate S AnalysisCommand {Direccin de anlisis}
translate S PreviousChoices {Eleccin previa}
translate S AnnotateTime {Poner el tiempo entre movimientos en segundos}
translate S AnnotateWhich {Aadir variaciones}
translate S AnnotateAll {Para movimientos de ambos lados}
translate S AnnotateWhite {Slo para movimientos de las Blancas}
translate S AnnotateBlack {Slo para movimientos de las Negras}
translate S AnnotateNotBest {Cuando el movimiento de la partida no es el mejor}
translate S LowPriority {Baja prioridad del procesador}

# Analysis Engine open dialog:
translate S EngineList {Lista de Motores de Anlisis}
translate S EngineName {Nombre}
translate S EngineCmd {Orden}
translate S EngineArgs {Parmetros}
translate S EngineDir {Directorio}
translate S EngineElo {Elo}
translate S EngineTime {Fecha}
translate S EngineNew {Neevo}
translate S EngineEdit {Editar}
translate S EngineRequired {Los campos en negrita son obligatorios; los dems opcionales}

# Stats window menus:
menuText S StatsFile "Archivo" 0
menuText S StatsFilePrint "Imprimir en archivo..." 0
menuText S StatsFileClose "Cerrar ventana" 0
menuText S StatsOpt "Opciones" 0

# PGN window menus:
menuText S PgnFile "Archivo" 0
menuText S PgnFileCopy "Copiar partida al portapapeles" 0
menuText S PgnFilePrint "Imprimir en archivo..." 0
menuText S PgnFileClose "Cerrar ventana PGN" 0
menuText S PgnOpt "Presentacin" 0
menuText S PgnOptColor "Color de la presentacin" 0
menuText S PgnOptShort "Encabezado pequeo (3 lneas)" 13
menuText S PgnOptSymbols "Anotaciones simblicas" 0
menuText S PgnOptIndentC "Sangra en comentarios" 0
menuText S PgnOptIndentV "Sangra en variaciones" 11
menuText S PgnOptColumn "Estilo de columna (un movimiento por lnea)" 1
menuText S PgnOptSpace "Espacio despus del nmero del movimiento" 0
menuText S PgnOptStripMarks "Quitar cdigos de color en casilla/flecha" 3
menuText S PgnOptBoldMainLine "Usar texto en negrita para las jugadas principales" 4
menuText S PgnColor "Colores" 1
menuText S PgnColorHeader "Encabezamiento..." 0
menuText S PgnColorAnno "Anotaciones..." 0
menuText S PgnColorComments "Comentarios..." 0
menuText S PgnColorVars "Variaciones..." 0
menuText S PgnColorBackground "Fondo..." 0
menuText S PgnHelp "Ayuda" 1
menuText S PgnHelpPgn "Ayuda de PGN" 9
menuText S PgnHelpIndex "Indice de la ayuda" 0
translate S PgnWindowTitle {Planilla - partida %u}

# Crosstable window menus:
menuText S CrosstabFile "Archivo" 0
menuText S CrosstabFileText "Imprimir en archivo texto..." 20
menuText S CrosstabFileHtml "Imprimir en archivo HTML..." 20
menuText S CrosstabFileLaTeX "Imprimir en archivo LaTeX..." 20
menuText S CrosstabFileClose "Cerrar ventana de tabla cruzada" 0
menuText S CrosstabEdit "Editar" 0
menuText S CrosstabEditEvent "Evento" 0
menuText S CrosstabEditSite "Lugar" 0
menuText S CrosstabEditDate "Fecha" 0
menuText S CrosstabOpt "Presentacin" 0
menuText S CrosstabOptAll "Todos contra todos" 0
menuText S CrosstabOptSwiss "Suizo" 0
menuText S CrosstabOptKnockout "Eliminatoria directa" 0
menuText S CrosstabOptAuto "Auto" 0
menuText S CrosstabOptAges "Edad en aos" 1
menuText S CrosstabOptNats "Nacionalidades" 0
menuText S CrosstabOptRatings "Elo" 0
menuText S CrosstabOptTitles "Ttulos" 0
menuText S CrosstabOptBreaks "Puntuaciones de desempate" 0
menuText S CrosstabOptDeleted "Incluir partidas borradas" 17
menuText S CrosstabOptColors "Colores (slo en tabla de Suizos)" 0
menuText S CrosstabOptColumnNumbers "Columnas numeradas (Slo en tabla todos contra todos)" 11
menuText S CrosstabOptGroup "Grupos de clasificacin" 0
menuText S CrosstabSort "Ordenar" 0
menuText S CrosstabSortName "Por nombre" 4
menuText S CrosstabSortRating "Por Elo" 4
menuText S CrosstabSortScore "Por puntuacin" 4
menuText S CrosstabColor "Color" 2
menuText S CrosstabColorPlain "Texto simple" 0
menuText S CrosstabColorHyper "Hipertexto" 0
menuText S CrosstabHelp "Ayuda" 1
menuText S CrosstabHelpCross "Ayuda de tabla cruzada" 9
menuText S CrosstabHelpIndex "Indice de la ayuda" 0
translate S SetFilter {Poner filtro}
translate S AddToFilter {Aadir al filtro}
translate S Swiss {Suizo}
translate S Category {Categora}

# Opening report window menus:
menuText S OprepFile "Archivo" 0
menuText S OprepFileText "Imprimir en archivo texto..." 20
menuText S OprepFileHtml "Imprimir en archivo HTML..." 20
menuText S OprepFileLaTeX "Imprimir en archivo LaTeX..." 20
menuText S OprepFileOptions "Opciones..." 0
menuText S OprepFileClose "Cerrar ventana del informe de la apertura" 0
menuText S OprepFavorites "Favoritos" 1
menuText S OprepFavoritesAdd "Aadir informe..." 0
menuText S OprepFavoritesEdit "Editar informe favorito..." 0
menuText S OprepFavoritesGenerate "Generar informe..." 0
menuText S OprepHelp "Ayuda" 1
menuText S OprepHelpReport "Ayuda del informe de la apertura" 11
menuText S OprepHelpIndex "Indice de la ayuda" 0

# Repertoire editor:
menuText S RepFile "Archivo" 0
menuText S RepFileNew "Nuevo" 0
menuText S RepFileOpen "Abrir..." 0
menuText S RepFileSave "Guardar..." 0
menuText S RepFileSaveAs "Guardar como..." 1
menuText S RepFileClose "Cerrar ventana" 0
menuText S RepEdit "Editar" 0
menuText S RepEditGroup "Aadir grupo" 7
menuText S RepEditInclude "Aadir lnea incluida" 13
menuText S RepEditExclude "Aadir lnea excluida" 13
menuText S RepView "Ver" 0
menuText S RepViewExpand "Expandir todos los grupos" 0
menuText S RepViewCollapse "Colapsar todos los grupos" 0
menuText S RepSearch "Buscar" 0
menuText S RepSearchAll "Todo el repertorio..." 0
menuText S RepSearchDisplayed "Slo las lneas mostradas..." 16
menuText S RepHelp "Ayuda" 1
menuText S RepHelpRep "Ayuda del repertorio" 10
menuText S RepHelpIndex "Indice de la ayuda" 0
translate S RepSearch "Bsqueda del repertorio"
translate S RepIncludedLines "Lneas incluidas"
translate S RepExcludedLines "Lneas excluidas"
translate S RepCloseDialog {Este repertorio tiene cambios no guardados.

Realmente quieres continuar y descartar los cambios que has hecho?
}

# Header search:
translate S HeaderSearch {Bsqueda por encabezamiento}
translate S EndSideToMove {Bando a mover al final de la partida}
translate S GamesWithNoECO {Partidas sin ECO?}
translate S GameLength {Duracin:}
translate S FindGamesWith {Encontrar partidas con}
translate S StdStart {Inicio estndar}
translate S Promotions {Promociones}
translate S Comments {Comentarios}
translate S Variations {Variaciones}
translate S Annotations {Anotaciones}
translate S DeleteFlag {Seal de borrado}
translate S WhiteOpFlag {Apertura de las blancas}
translate S BlackOpFlag {Apertura de las negras}
translate S MiddlegameFlag {Mediojuego}
translate S EndgameFlag {Finales}
translate S NoveltyFlag {Novedad}
translate S PawnFlag {Estruvtura de peones}
translate S TacticsFlag {Tacticas}
translate S QsideFlag {Juego del lado de dama}
translate S KsideFlag {Juego del lado de rey}
translate S BrilliancyFlag {Genialidad}
translate S BlunderFlag {Error}
translate S UserFlag {Usuario}
translate S PgnContains {PGN contiene texto}

# Game list window:
translate S GlistNumber {Nmero}
translate S GlistWhite {Blanco}
translate S GlistBlack {Negro}
translate S GlistWElo {B-Elo}
translate S GlistBElo {N-Elo}
translate S GlistEvent {Evento}
translate S GlistSite {Lugar}
translate S GlistRound {Ronda}
translate S GlistDate {Fecha}
translate S GlistYear {Ao}
translate S GlistEDate {Evento-Fecha}
translate S GlistResult {Resultado}
translate S GlistLength {Longitud}
translate S GlistCountry {Pas}
translate S GlistECO {ECO}
translate S GlistOpening {Apertura}
translate S GlistEndMaterial {Material final}
translate S GlistDeleted {Borrado}
translate S GlistFlags {Seal}
translate S GlistVars {Variaciones}
translate S GlistComments {Comentarios}
translate S GlistAnnos {Anotaciones}
translate S GlistStart {Inicio}
translate S GlistGameNumber {Nmero de partida}
translate S GlistFindText {Encontrar texto}
translate S GlistMoveField {Movimiento}
translate S GlistEditField {Configurar}
translate S GlistAddField {Aadir}
translate S GlistDeleteField {Quitar}
translate S GlistWidth {Anchura}
translate S GlistAlign {Alinear}
translate S GlistColor {Color}
translate S GlistSep {Separador}

# Maintenance window:
translate S DatabaseName {Nombre de la base:}
translate S TypeIcon {Tipo de icono:}
translate S NumOfGames {Partidas:}
translate S NumDeletedGames {Partidas borradas:}
translate S NumFilterGames {Partidas en el filtro:}
translate S YearRange {Rango de aos:}
translate S RatingRange {Rango de Elo:}
translate S Description {Descripcin}
translate S Flag {Seal}
translate S DeleteCurrent {Borrar partida actual}
translate S DeleteFilter {Borrar partidas filtradas}
translate S DeleteAll {Borrar todas las partidas}
translate S UndeleteCurrent {No borrar partida actual}
translate S UndeleteFilter {No borrar partidas filtradas}
translate S UndeleteAll {No borrar todas las partidas}
translate S DeleteTwins {Borrar partidas dobles}
translate S MarkCurrent {Marcar partida actual}
translate S MarkFilter {Marcar partidas filtradas}
translate S MarkAll {Marcar todas las partidas}
translate S UnmarkCurrent {No marcar partida actual}
translate S UnmarkFilter {No marcar partidas filtradas}
translate S UnmarkAll {No marcar todas las partidas}
translate S Spellchecking {Revisin ortogrfica}
translate S Players {Jugadores}
translate S Events {Eventos}
translate S Sites {Lugares}
translate S Rounds {Rondas}
translate S DatabaseOps {Operaciones con la base de datos}
translate S ReclassifyGames {Reclasificar partidas por ECO...}
translate S CompactDatabase {Compactar base de datos}
translate S SortDatabase {Ordenar base de datos}
translate S AddEloRatings {Aadir clasificacin Elo}
translate S AutoloadGame {Autocargar nmero de partida}
translate S StripTags {Quitar etiquetas PGN}
translate S StripTag {Quitar etiquetas}
translate S Cleaner {MultiHerramienta}
translate S CleanerHelp {
Scid ejecutar, en la actual base de datos, todas las acciones de mantenimiento
que selecciones de la siguiente lista.

Se aplicar el estado actual en la clasificacin ECO y el dilogo de borrado de
dobles si seleccionas esas funciones.
}
translate S CleanerConfirm {
Una vez que la MultiHerramienta de mantenimiento se inicia no puede ser interrumpida!

Esto puede tomar mucho tiempo en una base de datos grande, dependiendo de las funciones que hallas seleccionado y su estado actual.

Ests seguro de querer comenzar las funciones de mantenimiento que has seleccionado?
}

# Comment editor:
translate S AnnotationSymbols  {Smbolos de anotacin:}
translate S Comment {Comentario:}
translate S InsertMark {Insertar marca}
translate S InsertMarkHelp {
Insertar/quitar marca: Selecciona color, tipo, casilla.
Insertar/quitar flecha: Botn derecho sobre dos casillas.
}

# Nag buttons in comment editor:
translate S GoodMove {Buena jugada}
translate S PoorMove {Mala jugada}
translate S ExcellentMove {Jugada excelente}
translate S Blunder {Error}
translate S InterestingMove {Jugada interesante}
translate S DubiousMove {Jugada dudosa}
translate S WhiteDecisiveAdvantage {Las blancas tienen decisiva ventaja}
translate S BlackDecisiveAdvantage {Las negras tienen decisiva ventaja}
translate S WhiteClearAdvantage {Las blancas tienen clara ventaja}
translate S BlackClearAdvantage {Las negras tienen clara ventaja}
translate S WhiteSlightAdvantage {Las blancas tienen ligera ventaja}
translate S BlackSlightAdvantage {Las negras tienen ligera ventaja}
translate S Equality {Igualdad}
translate S Unclear {Incierto}
translate S Diagram {Diagrama}

# Board search:
translate S BoardSearch {Tablero de bsqueda}
translate S FilterOperation {Operacin en filtro actual:}
translate S FilterAnd {Y (Restringir filtro)}
translate S FilterOr {O (Aadir al filtro)}
translate S FilterIgnore {IGNORAR (Poner a cero el filtro)}
translate S SearchType {Tipo de bsqueda:}
translate S SearchBoardExact {Posicin exacta (todas las piezas en las mismas casillas)}
translate S SearchBoardPawns {Peones (igual material, todos los peones en las mismas casillas)}
translate S SearchBoardFiles {Columnas (igual material, todos los peones en las mismas columnas)}
translate S SearchBoardAny {Cualquiera (igual material, peones y piezas en cualquier parte)}
translate S LookInVars {Mirar en variaciones}

# Material search:
translate S MaterialSearch {Bsqueda de Material}
translate S Material {Material}
translate S Patterns {Patrones}
translate S Zero {Cero}
translate S Any {Cualquiera}
translate S CurrentBoard {Tablero Actual}
translate S CommonEndings {Finales comunes}
translate S CommonPatterns {Patrones comunes}
translate S MaterialDiff {Diferencia de material}
translate S squares {casillas}
translate S SameColor {Igual color}
translate S OppColor {Color opuesto}
translate S Either {Cualquiera}
translate S MoveNumberRange {Rango de nmero de movimientos}
translate S MatchForAtLeast {Encuentro de al menos}
translate S HalfMoves {medios movimientos}

# Common endings in material search:
translate S EndingPawns {Finales de peones}
translate S EndingRookVsPawns {Torre vs. peon(es)}
translate S EndingRookPawnVsRook {Torre y 1 pen vs. torre}
translate S EndingRookPawnsVsRook {Torre y peon(es) vs. torre}
translate S EndingRooks {Finales de torre vs. torre}
translate S EndingRooksPassedA {Finales de torre vs. torre con pen pasado}
translate S EndingRooksDouble {Finales de dos torres}
translate S EndingBishops {Finales de alfil vs. alfil}
translate S EndingBishopVsKnight {Finales de alfil vs. caballo}
translate S EndingKnights {Finales de caballo vs. caballo}
translate S EndingQueens {Finales de dama vs. dama}
translate S EndingQueenPawnVsQueen {Dama y 1 pen vs. dama}
translate S BishopPairVsKnightPair {Medio juego de dos alfiles vs. dos caballos}

# Common patterns in material search:
translate S PatternWhiteIQP {PDA blanco}
translate S PatternWhiteIQPBreakE6 {PDA blanco: d4-d5 ruptura vs. e6}
translate S PatternWhiteIQPBreakC6 {PDA blanco: d4-d5 ruptura vs. c6}
translate S PatternBlackIQP {PDA negro}
translate S PatternWhiteBlackIQP {PDA blanco vs. PDA negro}
translate S PatternCoupleC3D4 {Pareja de peones aislados blancos c3+d4}
translate S PatternHangingC5D5 {Peones colgantes negros en c5 y d5}
translate S PatternMaroczy {Centro Maroczy (con peones en c4 y e4)}
translate S PatternRookSacC3 {Sacrificio de torre en c3}
translate S PatternKc1Kg8 {O-O-O vs. O-O (Rc1 vs. Rg8)}
translate S PatternKg1Kc8 {O-O vs. O-O-O (Rg1 vs. Rc8)}
translate S PatternLightFian {Fianchettos de casillas claras (Alfil-g2 vs. Alfil-b7)}
translate S PatternDarkFian {Fianchettos de casillas oscuras (Alfil-b2 vs. Alfil-g7)}
translate S PatternFourFian {Cuatro Fianchettos (Alfiles en b2,g2,b7,g7)}

# Game saving:
translate S Today {Hoy}
translate S ClassifyGame {Clasificar partida}

# Setup position:
translate S EmptyBoard {Tablero vaco}
translate S InitialBoard {Tablero inicial}
translate S SideToMove {Lado que mueve}
translate S MoveNumber {Movimiento nmero}
translate S Castling {Enroque}
translate S EnPassantFile {Columna al paso}
translate S ClearFen {Quitar FEN}
translate S PasteFen {Pegar FEN}

# Replace move dialog:
translate S ReplaceMove {Reemplazar movimiento}
translate S AddNewVar {Aadir nueva variacin}
translate S ReplaceMoveMessage {Ya existe un movimiento.

Puedes reemplazarlo, descartando todos los movimientos posteriores, o aadirlo como una nueva variacin.

(Puedes evitar seguir viendo este mensaje en el futuro desactivando la opcin "Preguntar antes de reemplazar movimientos" en el men Opciones: Movimientos.)}

# Make database read-only dialog:
translate S ReadOnlyDialog {Si haces que esta base de datos sea de slo lectura no se permitirn hacer cambios. No se podrn guardar o reemplazar partidas, y no se podrn alterar las seales de borrada. Cualquier ordenacin o clasificacin por ECO ser temporal.

Puedes hacer fcilmente escribible la base de datos otra vez cerrndola y abrindola.

Realmente quieres hacer que esta base de datos sea de slo lectura?}

# Clear game dialog:
translate S ClearGameDialog {Esta partida a sido cambiada.

Realmente quieres continuar y eliminar los cambios hechos en ella?
}

# Exit dialog:
translate S ExitDialog {Realmente quieres salir de Scid?}
translate S ExitUnsaved {La siguiente base de datos tiene cambios en partidas no guardados. Si sales ahora se perdern estos cambios.}

# Import window:
translate S PasteCurrentGame {Pegar partida actual}
translate S ImportHelp1 \
  {Introducir o pegar una partida en formato PGN en el marco superior.}
translate S ImportHelp2 \
  {Cualquier error importando la partida ser mostrado aqu.}

# ECO Browser:
translate S ECOAllSections {todas las divisiones ECO}
translate S ECOSection {divisin ECO}
translate S ECOSummary {Resumen de}
translate S ECOFrequency {Frecuencia de los subcdigos para}

# Opening Report:
translate S OprepTitle {Informe de la apertura}
translate S OprepReport {Informe}
translate S OprepGenerated {Generado por}
translate S OprepStatsHist {Estadsticas e Historia}
translate S OprepStats {Estadsticas}
translate S OprepStatAll {Todas las partidas referidas}
translate S OprepStatBoth {Ambos con Elo}
translate S OprepStatSince {Desde}
translate S OprepOldest {Partidas ms antiguas}
translate S OprepNewest {Partidas ms nuevas}
translate S OprepPopular {Popularidad actual}
translate S OprepFreqAll {Frecuencia durante todos los aos: }
translate S OprepFreq1   {Desde el ltimo ao hasta hoy:     }
translate S OprepFreq5   {En los ltimos 5 aos hasta hoy:   }
translate S OprepFreq10  {En los ltimos 10 aos hasta hoy:  }
translate S OprepEvery {una vez cada %u partidas}
translate S OprepUp {sube un %u%s respecto al total de aos}
translate S OprepDown {baja un %u%s respecto al total de aos}
translate S OprepSame {no hay cambios respecto al total de aos}
translate S OprepMostFrequent {Jugadores ms frecuentes}
translate S OprepMostFrequentOpponents {Rivales ms frecuentes}
translate S OprepRatingsPerf {Elo y Rendimiento}
translate S OprepAvgPerf {Promedio de Elo y rendimiento}
translate S OprepWRating {Elo de las blancas}
translate S OprepBRating {Elo de las negras}
translate S OprepWPerf {Rendimiento de las blancas}
translate S OprepBPerf {Rendimiento de las negras}
translate S OprepHighRating {Partida con el mayor promedio de Elo}
translate S OprepTrends {Tendencias de Resultados}
translate S OprepResults {Resultado de duraciones y frecuencias}
translate S OprepLength {Duracin de la partida}
translate S OprepFrequency {Frecuencia}
translate S OprepWWins {Blancas ganan: }
translate S OprepBWins {Negras ganan:  }
translate S OprepDraws {Tablas:        }
translate S OprepWholeDB {en el conjunto de la base de datos}
translate S OprepShortest {Triunfos ms cortos}
translate S OprepMovesThemes {Movimientos y temas}
translate S OprepMoveOrders {Lneas de movimientos que alcanzan la posicin del informe}
translate S OprepMoveOrdersOne \
  {Slo hay una lnea de movimientos que alcanza esta posicin:}
translate S OprepMoveOrdersAll \
  {Hay %u lneas de movimiento que alcanzan esta posicin:}
translate S OprepMoveOrdersMany \
  {Hay %u lneas de movimiento que alcanzan esta posicin. Las %u ms comunes son:}
translate S OprepMovesFrom {Movimientos desde la posicin del informe}
translate S OprepMostFrequentEcoCodes {Aperturas ms frecuentes}
translate S OprepThemes {Temas Posicionales}
translate S OprepThemeDescription {Frecuencia de los temas en las primeras %u jugadas de cada partida}
translate S OprepThemeSameCastling {Enroque al mismo lado}
translate S OprepThemeOppCastling {Enroque en lados opuestos}
translate S OprepThemeNoCastling {Ambos Reyes no enrocados}
translate S OprepThemeKPawnStorm {Avanzada de los peones del Rey}
translate S OprepThemeQueenswap {Damas intercambiadas}
translate S OprepThemeWIQP {Pen de dama aislado de las blancas}
translate S OprepThemeBIQP {Pen de dama aislado de las negras}
translate S OprepThemeWP567 {Peones blancos en 5/6/7 fila}
translate S OprepThemeBP234 {Peones negros en 2/3/4 fila}
translate S OprepThemeOpenCDE {Columnas c/d/e abiertas}
translate S OprepTheme1BishopPair {Un lado tiene los dos alfiles}
translate S OprepEndgames {Finales}
translate S OprepReportGames {Informe de partidas}
translate S OprepAllGames {Todas las partidas}
translate S OprepEndClass {Tipos de finales segn la ltima posicin de las partidas}
translate S OprepTheoryTable {Tabla Terica}
translate S OprepTableComment {Generado a partir de las %u partidas con mejor Elo.}
translate S OprepExtraMoves {Anotacin extra de movimientos en la tabla terica}
translate S OprepMaxGames {Mximas partidas en la tabla terica}
translate S OprepViewHTML {Ver HTML}
translate S OprepViewLaTeX {Ver LaTeX}

# Player Report:
translate S PReportTitle {Informe del jugador}
translate S PReportColorWhite {con las piezas blancas}
translate S PReportColorBlack {con las piezas negras}
translate S PReportMoves {%s despus}
translate S PReportOpenings {Aperturas}
translate S PReportClipbase {Vaciar portapapeles y copiar las partidas}

# Piece Tracker window:
translate S TrackerSelectSingle {El botn izquierdo selecciona esta pieza.}
translate S TrackerSelectPair {El botn izquierdo selecciona esta pieza; el botn derecho tambin selecciona su hermana.}
translate S TrackerSelectPawn {El botn izquierdo selecciona este pen; el botn derecho selecciona los 8 peones.}
translate S TrackerStat {Estadstica}
translate S TrackerGames {% de partidas con movimiento a esta casilla}
translate S TrackerTime {% de tiempo en esta casilla}
translate S TrackerMoves {Movimientos}
translate S TrackerMovesStart {Escribe el nmero del movimiento desde donde debe empezar el rastreo.}
translate S TrackerMovesStop {Escribe el nmero del movimiento donde debe parar el rastreo.}

# Game selection dialogs:
translate S SelectAllGames {Todas las partidas de la base de datos}
translate S SelectFilterGames {Slo las partidas filtradas}
translate S SelectTournamentGames {Slo las partidas del actual torneo}
translate S SelectOlderGames {Slo partidas antiguas}

# Delete Twins window:
translate S TwinsNote {Para ser dobles, dos partidas deben de tener al menos los mismos dos jugadores, y los criterios que fijes debajo. Cuando un par de dobles es encontrado, la partida ms corta es borrada.
Sugerencia: es mejor hacer la correccin ortogrfica de la base de datos antes de iniciar el borrado de dobles, porque esto mejora su deteccin.}
translate S TwinsCriteria {Criterios: Las partidas dobles deben tener...}
translate S TwinsWhich {Partidas a examinar}
translate S TwinsColors {Jugadores con igual color?}
translate S TwinsEvent {Mismo evento?}
translate S TwinsSite {Mismo sitio?}
translate S TwinsRound {Misma ronda?}
translate S TwinsYear {Mismo ao?}
translate S TwinsMonth {Mismo mes?}
translate S TwinsDay {Mismo da?}
translate S TwinsResult {Mismo resultado?}
translate S TwinsECO {Mismo cdigo ECO?}
translate S TwinsMoves {Mismos movimientos?}
translate S TwinsPlayers {Comparando nombres de jugadores:}
translate S TwinsPlayersExact {Encuentro exacto}
translate S TwinsPlayersPrefix {Slo las primeras 4 letras}
translate S TwinsWhen {Cuando se borren partidas dobles}
translate S TwinsSkipShort {Ignorar todas las partidas con menos de 5 movimientos?}
translate S TwinsUndelete {Quitar marcas de borrado primero?}
translate S TwinsSetFilter {Poner filtro a todas las partidas borradas?}
translate S TwinsComments {Saltar siempre partidas con comentarios?}
translate S TwinsVars {Saltar siempre partidas con variaciones?}
translate S TwinsDeleteWhich {Qu partida borrar:}
translate S TwinsDeleteShorter {Partida ms corta}
translate S TwinsDeleteOlder {Nmero de partida menor}
translate S TwinsDeleteNewer {Nmero de partida mayor}
translate S TwinsDelete {Borrar partidas}

# Name editor window:
translate S NameEditType {Tipo de nombre a editar}
translate S NameEditSelect {Partidas a editar}
translate S NameEditReplace {Reemplazar}
translate S NameEditWith {con}
translate S NameEditMatches {Encuentros: Presionar Ctrl+1 a Ctrl+9 para seleccionarlo}

# Classify window:
translate S Classify {Clasificar}
translate S ClassifyWhich {Clasificar por cdigos ECO}
translate S ClassifyAll {Todas las partidas (sobreescribir cdigo ECO)}
translate S ClassifyYear {Todas las partidas jugadas en el ltimo ao}
translate S ClassifyMonth {Todas las partidas jugadas en el ltimo mes}
translate S ClassifyNew {Slo las partidas todaba sin cdigo ECO}
translate S ClassifyCodes {Cdigo ECO a usar}
translate S ClassifyBasic {Slo cdigo bsico ("B12", ...)}
translate S ClassifyExtended {Extensiones Scid ("B12j", ...)}

# Compaction:
translate S NameFile {Archivo de nombres}
translate S GameFile {Archivo de partidas}
translate S Names {Nombres}
translate S Unused {No usado}
translate S SizeKb {Tamao (kb)}
translate S CurrentState {Estado actual}
translate S AfterCompaction {Despus de la compactacin}
translate S CompactNames {Compactar archivo de nombres}
translate S CompactGames {Compactar archivo de partidas}

# Sorting:
translate S SortCriteria {Criterio}
translate S AddCriteria {Aadir criterio}
translate S CommonSorts {Ordenaciones comunes}
translate S Sort {Ordenar}

# Exporting:
translate S AddToExistingFile {Aadir partidas a un archivo existente?}
translate S ExportComments {Exportar comentarios?}
translate S ExportVariations {Exportar variaciones?}
translate S IndentComments {Sangrar comentarios?}
translate S IndentVariations {Sangrar variaciones?}
translate S ExportColumnStyle {Estilo de columna (un movimiento por lnea)?}
translate S ExportSymbolStyle {Estilo de anotacin simblico:}
translate S ExportStripMarks {Quitar marca de cdigos de casilla/flecha de los comentarios?}

# Goto game/move dialogs:
translate S LoadGameNumber {Entra el nmero de la partida a cargar:}
translate S GotoMoveNumber {Ir al movimiento nmero:}

# Copy games dialog:
translate S CopyGames {Copiar partidas}
translate S CopyConfirm {
 Realmente deseas copiar las [::utils::thousands $nGamesToCopy] partidas fitradas
 de la base de datos "$fromName"
 a la base de datos "$targetName"?
}
translate S CopyErr {No se pueden copiar las partidas}
translate S CopyErrSource {la base de datos fuente}
translate S CopyErrTarget {la base de datos de destino}
translate S CopyErrNoGames {no tiene partidas en su filtro}
translate S CopyErrReadOnly {es slo de lectura}
translate S CopyErrNotOpen {no est abierta}

# Colors:
translate S LightSquares {Casillas claras}
translate S DarkSquares {Casillas oscuras}
translate S SelectedSquares {Casillas seleccionadas}
translate S SuggestedSquares {Casillas de movimiento sugerido}
translate S WhitePieces {Piezas blancas}
translate S BlackPieces {Piezas negras}
translate S WhiteBorder {Borde blancas}
translate S BlackBorder {Borde negras}

# Novelty window:
translate S FindNovelty {Encontrar Novedad}
translate S Novelty {Novedad}
translate S NoveltyInterrupt {Busqueda de novedades interrumpida}
translate S NoveltyNone {Ninguna novedad encontrada para esta partida}
translate S NoveltyHelp {
Scid encontrar el primer movimiento de la actual partida que alcanza una posicin no encontrada en la base de datos seleccionada o en el libro de aperturas ECO.
}

# Sounds configuration:
translate S SoundsFolder {Directorio de los archivos de sonido}
translate S SoundsFolderHelp {El directorio debe contener los archivos King.wav, a.wav, 1.wav, etc}
translate S SoundsAnnounceOptions {Opciones de anunciamiento de movimientos}
translate S SoundsAnnounceNew {Anunciar nuevos movimientos cuando sean hechos}
translate S SoundsAnnounceForward {Anunciar movimientos cuando avancemos un movimiento}
translate S SoundsAnnounceBack {Anunciar movimiento cuando rectifiquemos o retrocedamos una jugada}

# Upgrading databases:
translate S Upgrading {Actualizacin}
translate S ConfirmOpenNew {
Este es un formato de base de datos antiguo (Scid 2) que no puede ser abierto con Scid 3, pero ya se ha creado una versin de formato nuevo (Scid 3).

Quieres abrir la versin de formato nuevo de la base de datos?
}
translate S ConfirmUpgrade {
Esta es una base de datos en un formato antiguo (Scid 2). Se debe crear una versin de formato nuevo de base de datos antes de poder ser usada en Scid 3.

La actualizacin crear una nueva versin de la base de datos; esta no corregir o borrar los archivos originales.

Esto puede tomar un tiempo, pero slo es necesario hacerlo una vez. Puedes cancelar si toma demasiado tiempo.

Quieres actualizar esta base de datos ahora?
}

# Recent files options:
translate S RecentFilesMenu {Nmero de archivos recientes en el men Archivo}
translate S RecentFilesExtra {Nmero de archivos recientes en submen extra}

# My Player Names options:
translate S MyPlayerNamesDescription {
Escriba una lista de nombres de jugadores preferidos, un nombre por cada lnea. Estn permitidos los comodines (por ejemplo "?" para un slo caracter, "*" para varios caracteres).

Cada vez que carge una partida con un jugador de la lista se girar el tablero, si fuese necesario, para ver la partida desde la perspectiva del jugador.
}

}
# end of spanish.tcl
