#
# SimpleStats.py : GUI for the module Scientific.Statistics
# Calculates and inserts simple statistics for a column into a sheet
#
# Copyright (C) 2001 Conrad D. Steenberg <conrad@hep.caltech.edu>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# Import some standard modules
from string import *
from gtk import *
from Numeric import *
from Scientific.Statistics import *

# Import the sg and related modules
import sg
import sgagtk # The wizard class
import pysga  # The python binding for sheets and plots

# The function that gets called when the wizard finishes
def finish_func(params):
  pass

# Called when the column name combo gets changed
def col_combo_changed(entry,params,label,mysheet):
  colname=entry.get_text()
  try:
    datay=mysheet.col(colname)
    label.set_text(params['fmt']%(correlation(params['datax'],datay)))
  except:
    label.set_text("Error")
    
# Our GUI setup function. Just add a widget to the provided page_box widget
# and use the params dictionary to pass around variables to other functions
def calc_func(params,page_box,next=None,prev=None,cancel=None):
  params['sheet_name']=sg.active_worksheet_name()
  mysheet=pysga.SGworksheet(params['sheet_name'])
  cols=sg.column_names(params['sheet_name'])
  active=mysheet.col0()
  params["datax"]=datax=mysheet.col(active)

  frame=GtkFrame("Column: "+cols[active])
  table=GtkTable(7,2,FALSE)
  table.set_col_spacings(5)
  table.set_row_spacings(5)
  
  page_box.pack_start(frame)
  frame.add(table)

  if len(datax)<=0:
   table.attach(GtkLabel("No values found!"), 0, 2, 0, 1)
   return

  
  vals=[mean,variance,standardDeviation,median,skewness,kurtosis]  
  keys= ["Mean","Variance","Standard deviation",
         "Median","Skewness","Kurtosis"]
  params['fmt']=fmt="%%2.%de"%(sg.get_column_precision(active)+1)

  for i in range(len(keys)):
      label = GtkLabel(keys[i]+": ")
      label.set_alignment(1., .5)
      table.attach(label, 0, 1, i, i+1)
      try:
        label = GtkLabel(fmt%(vals[i](datax)))
      except:
        label = GtkLabel("Error")
      label.set_alignment(0., .5)
      table.attach(label, 1, 2, i, i+1)
  i=i+1
  label = GtkLabel("Correllation coef. with column: ")
  label.set_alignment(1., .5)
  table.attach(label, 0, 1, i, i+1)
  i=i+1
  
  cor_col=range(active)+range(active+1,len(cols))
  menu=GtkCombo()
  col_strings=[]
  for j in cor_col:
    col_strings.append(cols[j])
  menu.set_popdown_strings(col_strings)
  menu.set_value_in_list(TRUE,FALSE)
  cor_active=active+1
  if cor_active>=len(cols):
    cor_active=active-1
    if cor_active==-1:
      cor_active=0

  menu.entry.set_text(cols[cor_active])
  datay=mysheet.col(cor_active)
  label = GtkLabel(fmt%(correlation(datax,datay)))
  label.set_alignment(0., .5)
  table.attach(label, 1, 2, i-1, i+1,xpadding=5)

  table.attach(menu, 0, 1, i, i+1,xpadding=5,ypadding=5)
  menu.entry.set_editable(FALSE)
  menu.entry.connect("changed",col_combo_changed,params,label,mysheet)
  frame.show_all()         

# The function that gets called when the menu option is selected
def fit_init():
  params={
# These are compulsory
  "funcs":[calc_func],
  "finish":finish_func,
# This is optional
  "labels":["Column Statistics"],
  "title": "Column statistics"
  }
  wizard=sgagtk.SGwizard(params)

# Module registration, make sure the group (second parameter) exists, 
# and ends in a colon.
if (sg):
  sg.register_plugin("Column statistics","Worksheet:Analysis:",fit_init)
  sg.register_plugin("Statistics","Worksheet:Column:",fit_init)
  