#ifndef __PYTHON_INT_H__
#define __PYTHON_INT_H__

#include <Python.h>

/* Flags for module loading */
enum {SG_MODULE_LOAD_MAIN = 1 << 0,      /* Load module dict into main dictionary */
      SG_MODULE_LOAD_SYMBOLS = 1 << 1,   /* Load module's symbols into main dictionary */
      SG_MODULE_LOAD_REQ = 1 << 2 }; /* This module is required for normal operation of SG */


extern gboolean sg_report_python_error;
extern gint sg_autosave_interval;
extern gint sg_compress_level;
extern PyObject *main_dict,
                *sys_dict,
		*sg_o, *sg_dict,
		*config_dict;



gint python_error_report		(PyObject *object);
gint python_error_report_verbose	(PyObject *object,
					 gboolean report,
					 gchar *message,
					 gint type);
gint python_init_minimal		(gchar *progname);
gint python_config_init			(void);
gint python_config_save			(void);

#endif /* __PYTHON_INT_H__ */

