// Utility Function Test

// Convolution
disp("-->conv test<--")
a=rand(1,100,'normal');
b=rand(1,51,'uniform');
c=conv(a,b);
c1=conv(a',b);
c2=conv(a,b');
c3=conv(a',b');
d=convol(a,b);
e1=sum(abs(c-d));
e2=sum(abs(c1-d));
e3=sum(abs(c2-d));
e4=sum(abs(c3-d));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8))
   disp("***conv test passes!***");
else
   disp("###conv test fails!###");
end
clear a;
clear b;
clear c;
clear c1;
clear c2;
clear c3;
clear d;
clear e1;
clear e2;
clear e3;
clear e4;

// wrev test
disp("-->wrev test<--");
a=rand(1,500,'normal');
b=wrev(a);
b1=wrev(a');
ind=[1:500];
ind1=[500:-1:1];
I=eye(500,500);
II=zeros(500,500);
II(ind,:)=I(ind1,:);
c=a*II;
e1=sum(abs(b-c));
e2=sum(abs(b1'-c));
if ((e1<1E-8) & (e2<1E-8))
   disp("***wrev test passes!***");
else
   disp("###wrev test fails!###");
end
clear a;
clear b;
clear b1;
clear c;
clear ind;
clear ind1;
clear I;
clear II:
clear e1;
clear e2;

// qmf test
disp("-->qmf test<--");
a=rand(1,5,'uniform');
b=qmf(a);
b1=qmf(a,0);
b2=qmf(a,1);
b3=qmf(a');
b4=qmf(a',0);
b5=qmf(a',1);
c=[0 0 0 0 1;0 0 0 -1 0;0 0 1 0 0;0 -1 0 0 0;1 0 0 0 0];
c1=[0 0 0 0 -1;0 0 0 1 0;0 0 -1 0 0;0 1 0 0 0;-1 0 0 0 0];
d=a*c;
d1=a*c1;
e1=sum(abs(b-b1));
e2=sum(abs(b-d));
e3=sum(abs(b2-d1));
e4=sum(abs(b3-b'));
e5=sum(abs(b4-b'));
e6=sum(abs(b5-d1'));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8))
   disp("***qmf test passes!***");
else
   disp("###qmf test fails!###");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear c;
clear c1;
clear d;
clear d1;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;

// dyaddown test
disp("-->dyaddown test<--");
disp("-->vector input, odd length<--");
a=rand(1,51,'normal');
ind=[1:25];
ind1=[1:26];
b=dyaddown(a);
b1=dyaddown(a,0);
b2=dyaddown(a,1);
b3=dyaddown(a');
b4=dyaddown(a',0);
b5=dyaddown(a',1);
c=a(2*ind);
c1=a(2*ind1-1);
e1=sum(abs(b-b1));
e2=sum(abs(b-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-b4));
e5=sum(abs(b3-b'));
e6=sum(abs(b5-b2'));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8))
   disp("Odd-length Vector Input passes!");
else
   disp("Odd-length Vector Input fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear c;
clear c1;
clear ind;
clear ind1;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;

disp("-->Vector Input, Even Length<--");
a=rand(1,50,'normal');
ind=[1:25];
b=dyaddown(a);
b1=dyaddown(a,0);
b2=dyaddown(a,1);
b3=dyaddown(a');
b4=dyaddown(a',0);
b5=dyaddown(a',1);
c=a(2*ind);
c1=a(2*ind-1);
e1=sum(abs(b-b1));
e2=sum(abs(b-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-b4));
e5=sum(abs(b3-c'));
e6=sum(abs(b5-c1'));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8))
   disp("Even-length Vector Input passes!");
else
   disp("Even-length Vector Input fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear c;
clear c1;
clear ind;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;

disp("-->Matrix Input<--");
a=rand(50,51,'normal');
b=dyaddown(a);
b1=dyaddown(a,0);
b2=dyaddown(a,1);
b3=dyaddown(a,'r');
b4=dyaddown(a,'c');
b5=dyaddown(a,'m');
b6=dyaddown(a,0,'r');
b7=dyaddown(a,0,'c');
b8=dyaddown(a,0,'m');
b9=dyaddown(a,1,'r');
b10=dyaddown(a,1,'c');
b11=dyaddown(a,1,'m');
ind=[1:25];
ind1=[1:26];
c=a(2*ind,:);
c1=a(2*ind-1,:);
c2=a(:,2*ind);
c3=a(:,2*ind1-1);
c4=a(2*ind,2*ind);
c5=a(2*ind-1,2*ind);
c6=a(2*ind,2*ind1-1);
c7=a(2*ind-1,2*ind1-1);
e1=sum(abs(b-c2));
e2=sum(abs(b1-b));
e3=sum(abs(b2-c3));
e4=sum(abs(b3-c));
e5=sum(abs(b4-c2));
e6=sum(abs(b5-c4));
e7=sum(abs(b6-c));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c4));
e10=sum(abs(b9-c1));
e11=sum(abs(b10-c3));
e12=sum(abs(b11-c7));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8) & (e7<1E-8) & (e8<1E-8) & (e9<1E-8) & (e10<1E-8) & (e11<1E-8) & (e12<1E-8))
   disp("Matrix Input passes!");
else
   disp("Matrix Input  fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear b6;
clear b7;
clear b8;
clear b9;
clear b10;
clear b11;
clear c;
clear c1;
clear c2;
clear c3;
clear c4;
clear c5;
clear c6;
clear c7;
clear ind;
clear ind1;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;
clear e7;
clear e8;
clear e9;
clear e10;
clear e11;
clear e12;

disp("***dyaddown test passes!***");

// dyadup test
disp("-->dyadup test<--");
disp("-->Vector Input, Odd Length<--");
a=rand(1,51,'normal');
b=dyadup(a);
b1=dyadup(a,0);
b2=dyadup(a,1);
b3=dyadup(a');
b4=dyadup(a',0);
b5=dyadup(a',1);
ind=[1:51];
c=zeros(1,103);
c(2*ind)=a(ind);
c1=zeros(1,101);
c1(2*ind-1)=a(ind);
e1=sum(abs(b-b2));
e2=sum(abs(b1-c1));
e3=sum(abs(b2-c));
e4=sum(abs(b3-b'));
e5=sum(abs(b4-b1'));
e6=sum(abs(b5-c'));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8))
   disp("Odd-length Vector Input passes!");
else
   disp("Odd-length Vector Input fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear c;
clear c1;
clear ind;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;

disp("-->Vector Input, Even Length<--");
a=rand(1,50,'normal');
b=dyadup(a);
b1=dyadup(a,0);
b2=dyadup(a,1);
b3=dyadup(a');
b4=dyadup(a',0);
b5=dyadup(a',1);
ind=[1:50];
c=zeros(1,101);
c(2*ind)=a(ind);
c1=zeros(1,99);
c1(2*ind-1)=a(ind);
e1=sum(abs(b-b2));
e2=sum(abs(b-c));
e3=sum(abs(b1-c1));
e4=sum(abs(b3-c'));
e5=sum(abs(b4-c1'));
e6=sum(abs(b5-b3));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8))
   disp("Even-length Vector Input passes!");
else
   disp("Even-length Vector Input fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear c;
clear c1;
clear ind;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;

disp("-->Matrix Input<--");
a=rand(50,51,'normal');
b=dyadup(a);
b1=dyadup(a,0);
b2=dyadup(a,1);
b3=dyadup(a,'r');
b4=dyadup(a,'c');
b5=dyadup(a,'m');
b6=dyadup(a,0,'r');
b7=dyadup(a,0,'c');
b8=dyadup(a,0,'m');
b9=dyadup(a,1,'r');
b10=dyadup(a,1,'c');
b11=dyadup(a,1,'m');
ind=[1:50];
ind1=[1:51];
c=zeros(99,51);
c(2*ind-1,:)=a(ind,:);
c1=zeros(101,51);
c1(2*ind,:)=a(ind,:);
c2=zeros(50,101);
c2(:,2*ind1-1)=a(:,ind1);
c3=zeros(50,103);
c3(:,2*ind1)=a(:,ind1);
c4=zeros(99,101);
c4(2*ind-1,2*ind1-1)=a(ind,ind1);
c5=zeros(101,103);
c5(2*ind,2*ind1)=a(ind,ind1);
e1=sum(abs(b-b10));
e2=sum(abs(b-c3));
e3=sum(abs(b1-c2));
e4=sum(abs(b2-b));
e5=sum(abs(b3-c1));
e6=sum(abs(b4-b2));
e7=sum(abs(b5-c5));
e8=sum(abs(b6-c));
e9=sum(abs(b7-c2));
e10=sum(abs(b8-c4));
e11=sum(abs(b9-c1));
e12=sum(abs(b10-c3));
e13=sum(abs(b11-c5));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8) & (e7<1E-8) & (e8<1E-8) & (e9<1E-8) & (e10<1E-8) & (e11<1E-8) & (e12<1E-8) & (e13<1E-8))
   disp("Matrix Input passes!");
else
   disp("Matrix Input  fails!");
end
disp("***dyadup passes!***");
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear b6;
clear b7;
clear b8;
clear b9;
clear b10;
clear b11;
clear c;
clear c1;
clear c2;
clear c3;
clear c4;
clear c5;
clear ind;
clear ind1;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;
clear e7;
clear e8;
clear e9;
clear e10;
clear e11;
clear e12;
clear e13;

// wkeep test
disp("-->wkeep test<--");
disp("Vector Input, Even Length");
a=rand(1,50,'normal');
b=wkeep(a,27);
b1=wkeep(a,27,'c');
b2=wkeep(a,27,'l');
b3=wkeep(a,27,'r');
b4=wkeep(a',27);
b5=wkeep(a',27,'c');
b6=wkeep(a',27,'l');
b7=wkeep(a',27,'r');
b8=wkeep(a,27,2);
b9=wkeep(a',27,2);
c=a(12:38);
c1=a(1:27);
c2=a($-26:$);
c3=a(2:28);
e1=sum(abs(b-b1));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-b1'));
e6=sum(abs(b5-b1'));
e7=sum(abs(b6-b2'));
e8=sum(abs(b7-b3'));
e9=sum(abs(b8-c3));
e10=sum(abs(b9-c3'));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8) & (e7<1E-8) & (e8<1E-8) & (e9<1E-8) & (e10<1E-8) )
   disp("Even-length Vector passes!");
else
   disp("Even-length Vector  fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear b6;
clear b7;
clear b8;
clear b9;
clear c;
clear c1;
clear c2;
clear c3;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;
clear e7;
clear e8;
clear e9;
clear e10;

disp("-->Vector Input, Odd Length<--");
a=rand(1,51,'normal');
b=wkeep(a,26);
b1=wkeep(a,26,'c');
b2=wkeep(a,26,'l');
b3=wkeep(a,26,'r');
b4=wkeep(a,26,2);
b5=wkeep(a',26);
b6=wkeep(a',26,'c');
b7=wkeep(a',26,'l');
b8=wkeep(a',26,'r');
b9=wkeep(a',26,2);
c=a(13:38);
c1=a(1:26);
c2=a($-25:$);
c3=a(2:27);
e1=sum(abs(b-b1));
e2=sum(abs(b-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c3));
e6=sum(abs(b5-b'));
e7=sum(abs(b6-b'));
e8=sum(abs(b7-b2'));
e9=sum(abs(b8-b3'));
e10=sum(abs(b9-c3'));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8) & (e7<1E-8) & (e8<1E-8) & (e9<1E-8) & (e10<1E-8) )
   disp("Odd-length Vector passes!");
else
   disp("Odd-length Vector  fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear b6;
clear b7;
clear b8;
clear b9;
clear c;
clear c1;
clear c2;
clear c3;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;
clear e7;
clear e8;
clear e9;
clear e10;

disp("-->Matrix Input<--");
a=rand(50,51,'normal');
b=wkeep(a,[27 26]);
b1=wkeep(a,[27 26]');
b2=wkeep(a,[27 26],[2 3]);
b3=wkeep(a,[27 26]',[2 3]);
b4=wkeep(a,[27 26],[2 3]');
b5=wkeep(a,[27 26]',[2 3]');
c=a(12:38,13:38);
c1=a(2:28,3:28);
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c1));
e5=sum(abs(b4-c1));
e6=sum(abs(b5-c1));
if ((e1<1E-8) & (e2<1E-8) & (e3<1E-8) & (e4<1E-8) & (e5<1E-8) & (e6<1E-8))
   disp("Matrix Input passes!");
else
   disp("Matrix Input  fails!");
end
clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear c;
clear c1;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;
disp("***wkeep test pass!***");

// wextend test
disp("-->wextend test<--");
a=rand(1,51,'normal');
b=wextend(1,'symh',a,7);
b1=wextend(1,'symh',a,7,'b');
b2=wextend(1,'symh',a,7,'l');
b3=wextend(1,'symh',a,7,'r');
b4=wextend('1','symh',a,7);
b5=wextend('1','symh',a,7,'b');
b6=wextend('1','symh',a,7,'l');
b7=wextend('1','symh',a,7,'r');
b8=wextend('1d','symh',a,7);
b9=wextend('1d','symh',a,7,'b');
b10=wextend('1d','symh',a,7,'l');
b11=wextend('1d','symh',a,7,'r');
b12=wextend('1D','symh',a,7);
b13=wextend('1D','symh',a,7,'b');
b14=wextend('1D','symh',a,7,'l');
b15=wextend('1D','symh',a,7,'r');
b16=wextend(1,'symh',a',7);
b17=wextend(1,'symh',a',7,'b');
b18=wextend(1,'symh',a',7,'l');
b19=wextend(1,'symh',a',7,'r');
b20=wextend('1','symh',a',7);
b21=wextend('1','symh',a',7,'b');
b22=wextend('1','symh',a',7,'l');
b23=wextend('1','symh',a',7,'r');
b24=wextend('1d','symh',a',7);
b25=wextend('1d','symh',a',7,'b');
b26=wextend('1d','symh',a',7,'l');
b27=wextend('1d','symh',a',7,'r');
b28=wextend('1D','symh',a',7);
b29=wextend('1D','symh',a',7,'b');
b30=wextend('1D','symh',a',7,'l');
b31=wextend('1D','symh',a',7,'r');
ind=[7:-1:1];
c=[a(ind) a a($:-1:$-6)];
c1=[a(ind) a];
c2=[a a($:-1:$-6)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector symh passes!");
else
   disp("vector symh failes!");
end

b=wextend(1,'SYMH',a,7);
b1=wextend(1,'SYMH',a,7,'b');
b2=wextend(1,'SYMH',a,7,'l');
b3=wextend(1,'SYMH',a,7,'r');
b4=wextend('1','SYMH',a,7);
b5=wextend('1','SYMH',a,7,'b');
b6=wextend('1','SYMH',a,7,'l');
b7=wextend('1','SYMH',a,7,'r');
b8=wextend('1d','SYMH',a,7);
b9=wextend('1d','SYMH',a,7,'b');
b10=wextend('1d','SYMH',a,7,'l');
b11=wextend('1d','SYMH',a,7,'r');
b12=wextend('1D','SYMH',a,7);
b13=wextend('1D','SYMH',a,7,'b');
b14=wextend('1D','SYMH',a,7,'l');
b15=wextend('1D','SYMH',a,7,'r');
b16=wextend(1,'SYMH',a',7);
b17=wextend(1,'SYMH',a',7,'b');
b18=wextend(1,'SYMH',a',7,'l');
b19=wextend(1,'SYMH',a',7,'r');
b20=wextend('1','SYMH',a',7);
b21=wextend('1','SYMH',a',7,'b');
b22=wextend('1','SYMH',a',7,'l');
b23=wextend('1','SYMH',a',7,'r');
b24=wextend('1d','SYMH',a',7);
b25=wextend('1d','SYMH',a',7,'b');
b26=wextend('1d','SYMH',a',7,'l');
b27=wextend('1d','SYMH',a',7,'r');
b28=wextend('1D','SYMH',a',7);
b29=wextend('1D','SYMH',a',7,'b');
b30=wextend('1D','SYMH',a',7,'l');
b31=wextend('1D','SYMH',a',7,'r');
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector SYMH passes!");
else
   disp("vector SYMH failes!");
end

b=wextend(1,'sym',a,7);
b1=wextend(1,'sym',a,7,'b');
b2=wextend(1,'sym',a,7,'l');
b3=wextend(1,'sym',a,7,'r');
b4=wextend('1','sym',a,7);
b5=wextend('1','sym',a,7,'b');
b6=wextend('1','sym',a,7,'l');
b7=wextend('1','sym',a,7,'r');
b8=wextend('1d','sym',a,7);
b9=wextend('1d','sym',a,7,'b');
b10=wextend('1d','sym',a,7,'l');
b11=wextend('1d','sym',a,7,'r');
b12=wextend('1D','sym',a,7);
b13=wextend('1D','sym',a,7,'b');
b14=wextend('1D','sym',a,7,'l');
b15=wextend('1D','sym',a,7,'r');
b16=wextend(1,'sym',a',7);
b17=wextend(1,'sym',a',7,'b');
b18=wextend(1,'sym',a',7,'l');
b19=wextend(1,'sym',a',7,'r');
b20=wextend('1','sym',a',7);
b21=wextend('1','sym',a',7,'b');
b22=wextend('1','sym',a',7,'l');
b23=wextend('1','sym',a',7,'r');
b24=wextend('1d','sym',a',7);
b25=wextend('1d','sym',a',7,'b');
b26=wextend('1d','sym',a',7,'l');
b27=wextend('1d','sym',a',7,'r');
b28=wextend('1D','sym',a',7);
b29=wextend('1D','sym',a',7,'b');
b30=wextend('1D','sym',a',7,'l');
b31=wextend('1D','sym',a',7,'r');
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector sym passes!");
else
   disp("vector sym failes!");
end


b=wextend(1,'SYM',a,7);
b1=wextend(1,'SYM',a,7,'b');
b2=wextend(1,'SYM',a,7,'l');
b3=wextend(1,'SYM',a,7,'r');
b4=wextend('1','SYM',a,7);
b5=wextend('1','SYM',a,7,'b');
b6=wextend('1','SYM',a,7,'l');
b7=wextend('1','SYM',a,7,'r');
b8=wextend('1d','SYM',a,7);
b9=wextend('1d','SYM',a,7,'b');
b10=wextend('1d','SYM',a,7,'l');
b11=wextend('1d','SYM',a,7,'r');
b12=wextend('1D','SYM',a,7);
b13=wextend('1D','SYM',a,7,'b');
b14=wextend('1D','SYM',a,7,'l');
b15=wextend('1D','SYM',a,7,'r');
b16=wextend(1,'SYM',a',7);
b17=wextend(1,'SYM',a',7,'b');
b18=wextend(1,'SYM',a',7,'l');
b19=wextend(1,'SYM',a',7,'r');
b20=wextend('1','SYM',a',7);
b21=wextend('1','SYM',a',7,'b');
b22=wextend('1','SYM',a',7,'l');
b23=wextend('1','SYM',a',7,'r');
b24=wextend('1d','SYM',a',7);
b25=wextend('1d','SYM',a',7,'b');
b26=wextend('1d','SYM',a',7,'l');
b27=wextend('1d','SYM',a',7,'r');
b28=wextend('1D','SYM',a',7);
b29=wextend('1D','SYM',a',7,'b');
b30=wextend('1D','SYM',a',7,'l');
b31=wextend('1D','SYM',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector SYM passes!");
else
   disp("vector SYM failes!");
end

// SYMW

b=wextend(1,'SYMW',a,7);
b1=wextend(1,'SYMW',a,7,'b');
b2=wextend(1,'SYMW',a,7,'l');
b3=wextend(1,'SYMW',a,7,'r');
b4=wextend('1','SYMW',a,7);
b5=wextend('1','SYMW',a,7,'b');
b6=wextend('1','SYMW',a,7,'l');
b7=wextend('1','SYMW',a,7,'r');
b8=wextend('1d','SYMW',a,7);
b9=wextend('1d','SYMW',a,7,'b');
b10=wextend('1d','SYMW',a,7,'l');
b11=wextend('1d','SYMW',a,7,'r');
b12=wextend('1D','SYMW',a,7);
b13=wextend('1D','SYMW',a,7,'b');
b14=wextend('1D','SYMW',a,7,'l');
b15=wextend('1D','SYMW',a,7,'r');
b16=wextend(1,'SYMW',a',7);
b17=wextend(1,'SYMW',a',7,'b');
b18=wextend(1,'SYMW',a',7,'l');
b19=wextend(1,'SYMW',a',7,'r');
b20=wextend('1','SYMW',a',7);
b21=wextend('1','SYMW',a',7,'b');
b22=wextend('1','SYMW',a',7,'l');
b23=wextend('1','SYMW',a',7,'r');
b24=wextend('1d','SYMW',a',7);
b25=wextend('1d','SYMW',a',7,'b');
b26=wextend('1d','SYMW',a',7,'l');
b27=wextend('1d','SYMW',a',7,'r');
b28=wextend('1D','SYMW',a',7);
b29=wextend('1D','SYMW',a',7,'b');
b30=wextend('1D','SYMW',a',7,'l');
b31=wextend('1D','SYMW',a',7,'r');
ind=[8:-1:2];
c=[a(ind) a a($-1:-1:$-7)];
c1=[a(ind) a];
c2=[a a($-1:-1:$-7)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector SYMW passes!");
else
   disp("vector SYMW failes!");
end


b=wextend(1,'symw',a,7);
b1=wextend(1,'symw',a,7,'b');
b2=wextend(1,'symw',a,7,'l');
b3=wextend(1,'symw',a,7,'r');
b4=wextend('1','symw',a,7);
b5=wextend('1','symw',a,7,'b');
b6=wextend('1','symw',a,7,'l');
b7=wextend('1','symw',a,7,'r');
b8=wextend('1d','symw',a,7);
b9=wextend('1d','symw',a,7,'b');
b10=wextend('1d','symw',a,7,'l');
b11=wextend('1d','symw',a,7,'r');
b12=wextend('1D','symw',a,7);
b13=wextend('1D','symw',a,7,'b');
b14=wextend('1D','symw',a,7,'l');
b15=wextend('1D','symw',a,7,'r');
b16=wextend(1,'symw',a',7);
b17=wextend(1,'symw',a',7,'b');
b18=wextend(1,'symw',a',7,'l');
b19=wextend(1,'symw',a',7,'r');
b20=wextend('1','symw',a',7);
b21=wextend('1','symw',a',7,'b');
b22=wextend('1','symw',a',7,'l');
b23=wextend('1','symw',a',7,'r');
b24=wextend('1d','symw',a',7);
b25=wextend('1d','symw',a',7,'b');
b26=wextend('1d','symw',a',7,'l');
b27=wextend('1d','symw',a',7,'r');
b28=wextend('1D','symw',a',7);
b29=wextend('1D','symw',a',7,'b');
b30=wextend('1D','symw',a',7,'l');
b31=wextend('1D','symw',a',7,'r');
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector symw passes!");
else
   disp("vector symw failes!");
end

// ASYMW

b=wextend(1,'ASYMW',a,7);
b1=wextend(1,'ASYMW',a,7,'b');
b2=wextend(1,'ASYMW',a,7,'l');
b3=wextend(1,'ASYMW',a,7,'r');
b4=wextend('1','ASYMW',a,7);
b5=wextend('1','ASYMW',a,7,'b');
b6=wextend('1','ASYMW',a,7,'l');
b7=wextend('1','ASYMW',a,7,'r');
b8=wextend('1d','ASYMW',a,7);
b9=wextend('1d','ASYMW',a,7,'b');
b10=wextend('1d','ASYMW',a,7,'l');
b11=wextend('1d','ASYMW',a,7,'r');
b12=wextend('1D','ASYMW',a,7);
b13=wextend('1D','ASYMW',a,7,'b');
b14=wextend('1D','ASYMW',a,7,'l');
b15=wextend('1D','ASYMW',a,7,'r');
b16=wextend(1,'ASYMW',a',7);
b17=wextend(1,'ASYMW',a',7,'b');
b18=wextend(1,'ASYMW',a',7,'l');
b19=wextend(1,'ASYMW',a',7,'r');
b20=wextend('1','ASYMW',a',7);
b21=wextend('1','ASYMW',a',7,'b');
b22=wextend('1','ASYMW',a',7,'l');
b23=wextend('1','ASYMW',a',7,'r');
b24=wextend('1d','ASYMW',a',7);
b25=wextend('1d','ASYMW',a',7,'b');
b26=wextend('1d','ASYMW',a',7,'l');
b27=wextend('1d','ASYMW',a',7,'r');
b28=wextend('1D','ASYMW',a',7);
b29=wextend('1D','ASYMW',a',7,'b');
b30=wextend('1D','ASYMW',a',7,'l');
b31=wextend('1D','ASYMW',a',7,'r');
ind=[8:-1:2];
c=[-a(ind) a -a($-1:-1:$-7)];
c1=[-a(ind) a];
c2=[a -a($-1:-1:$-7)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector ASYMW passes!");
else
   disp("vector ASYMW failes!");
end


b=wextend(1,'asymw',a,7);
b1=wextend(1,'asymw',a,7,'b');
b2=wextend(1,'asymw',a,7,'l');
b3=wextend(1,'asymw',a,7,'r');
b4=wextend('1','asymw',a,7);
b5=wextend('1','asymw',a,7,'b');
b6=wextend('1','asymw',a,7,'l');
b7=wextend('1','asymw',a,7,'r');
b8=wextend('1d','asymw',a,7);
b9=wextend('1d','asymw',a,7,'b');
b10=wextend('1d','asymw',a,7,'l');
b11=wextend('1d','asymw',a,7,'r');
b12=wextend('1D','asymw',a,7);
b13=wextend('1D','asymw',a,7,'b');
b14=wextend('1D','asymw',a,7,'l');
b15=wextend('1D','asymw',a,7,'r');
b16=wextend(1,'asymw',a',7);
b17=wextend(1,'asymw',a',7,'b');
b18=wextend(1,'asymw',a',7,'l');
b19=wextend(1,'asymw',a',7,'r');
b20=wextend('1','asymw',a',7);
b21=wextend('1','asymw',a',7,'b');
b22=wextend('1','asymw',a',7,'l');
b23=wextend('1','asymw',a',7,'r');
b24=wextend('1d','asymw',a',7);
b25=wextend('1d','asymw',a',7,'b');
b26=wextend('1d','asymw',a',7,'l');
b27=wextend('1d','asymw',a',7,'r');
b28=wextend('1D','asymw',a',7);
b29=wextend('1D','asymw',a',7,'b');
b30=wextend('1D','asymw',a',7,'l');
b31=wextend('1D','asymw',a',7,'r');
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector asymw passes!");
else
   disp("vector asymw failes!");
end

// ASYMH

b=wextend(1,'asymh',a,7);
b1=wextend(1,'asymh',a,7,'b');
b2=wextend(1,'asymh',a,7,'l');
b3=wextend(1,'asymh',a,7,'r');
b4=wextend('1','asymh',a,7);
b5=wextend('1','asymh',a,7,'b');
b6=wextend('1','asymh',a,7,'l');
b7=wextend('1','asymh',a,7,'r');
b8=wextend('1d','asymh',a,7);
b9=wextend('1d','asymh',a,7,'b');
b10=wextend('1d','asymh',a,7,'l');
b11=wextend('1d','asymh',a,7,'r');
b12=wextend('1D','asymh',a,7);
b13=wextend('1D','asymh',a,7,'b');
b14=wextend('1D','asymh',a,7,'l');
b15=wextend('1D','asymh',a,7,'r');
b16=wextend(1,'asymh',a',7);
b17=wextend(1,'asymh',a',7,'b');
b18=wextend(1,'asymh',a',7,'l');
b19=wextend(1,'asymh',a',7,'r');
b20=wextend('1','asymh',a',7);
b21=wextend('1','asymh',a',7,'b');
b22=wextend('1','asymh',a',7,'l');
b23=wextend('1','asymh',a',7,'r');
b24=wextend('1d','asymh',a',7);
b25=wextend('1d','asymh',a',7,'b');
b26=wextend('1d','asymh',a',7,'l');
b27=wextend('1d','asymh',a',7,'r');
b28=wextend('1D','asymh',a',7);
b29=wextend('1D','asymh',a',7,'b');
b30=wextend('1D','asymh',a',7,'l');
b31=wextend('1D','asymh',a',7,'r');
ind=[7:-1:1];
c=[-a(ind) a -a($:-1:$-6)];
c1=[-a(ind) a];
c2=[a -a($:-1:$-6)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector asymh passes!");
else
   disp("vector asymh failes!");
end

b=wextend(1,'ASYMH',a,7);
b1=wextend(1,'ASYMH',a,7,'b');
b2=wextend(1,'ASYMH',a,7,'l');
b3=wextend(1,'ASYMH',a,7,'r');
b4=wextend('1','ASYMH',a,7);
b5=wextend('1','ASYMH',a,7,'b');
b6=wextend('1','ASYMH',a,7,'l');
b7=wextend('1','ASYMH',a,7,'r');
b8=wextend('1d','ASYMH',a,7);
b9=wextend('1d','ASYMH',a,7,'b');
b10=wextend('1d','ASYMH',a,7,'l');
b11=wextend('1d','ASYMH',a,7,'r');
b12=wextend('1D','ASYMH',a,7);
b13=wextend('1D','ASYMH',a,7,'b');
b14=wextend('1D','ASYMH',a,7,'l');
b15=wextend('1D','ASYMH',a,7,'r');
b16=wextend(1,'ASYMH',a',7);
b17=wextend(1,'ASYMH',a',7,'b');
b18=wextend(1,'ASYMH',a',7,'l');
b19=wextend(1,'ASYMH',a',7,'r');
b20=wextend('1','ASYMH',a',7);
b21=wextend('1','ASYMH',a',7,'b');
b22=wextend('1','ASYMH',a',7,'l');
b23=wextend('1','ASYMH',a',7,'r');
b24=wextend('1d','ASYMH',a',7);
b25=wextend('1d','ASYMH',a',7,'b');
b26=wextend('1d','ASYMH',a',7,'l');
b27=wextend('1d','ASYMH',a',7,'r');
b28=wextend('1D','ASYMH',a',7);
b29=wextend('1D','ASYMH',a',7,'b');
b30=wextend('1D','ASYMH',a',7,'l');
b31=wextend('1D','ASYMH',a',7,'r');
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector ASYMH passes!");
else
   disp("vector ASYMH failes!");
end

b=wextend(1,'asym',a,7);
b1=wextend(1,'asym',a,7,'b');
b2=wextend(1,'asym',a,7,'l');
b3=wextend(1,'asym',a,7,'r');
b4=wextend('1','asym',a,7);
b5=wextend('1','asym',a,7,'b');
b6=wextend('1','asym',a,7,'l');
b7=wextend('1','asym',a,7,'r');
b8=wextend('1d','asym',a,7);
b9=wextend('1d','asym',a,7,'b');
b10=wextend('1d','asym',a,7,'l');
b11=wextend('1d','asym',a,7,'r');
b12=wextend('1D','asym',a,7);
b13=wextend('1D','asym',a,7,'b');
b14=wextend('1D','asym',a,7,'l');
b15=wextend('1D','asym',a,7,'r');
b16=wextend(1,'asym',a',7);
b17=wextend(1,'asym',a',7,'b');
b18=wextend(1,'asym',a',7,'l');
b19=wextend(1,'asym',a',7,'r');
b20=wextend('1','asym',a',7);
b21=wextend('1','asym',a',7,'b');
b22=wextend('1','asym',a',7,'l');
b23=wextend('1','asym',a',7,'r');
b24=wextend('1d','asym',a',7);
b25=wextend('1d','asym',a',7,'b');
b26=wextend('1d','asym',a',7,'l');
b27=wextend('1d','asym',a',7,'r');
b28=wextend('1D','asym',a',7);
b29=wextend('1D','asym',a',7,'b');
b30=wextend('1D','asym',a',7,'l');
b31=wextend('1D','asym',a',7,'r');
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector asym passes!");
else
   disp("vector asym failes!");
end


b=wextend(1,'ASYM',a,7);
b1=wextend(1,'ASYM',a,7,'b');
b2=wextend(1,'ASYM',a,7,'l');
b3=wextend(1,'ASYM',a,7,'r');
b4=wextend('1','ASYM',a,7);
b5=wextend('1','ASYM',a,7,'b');
b6=wextend('1','ASYM',a,7,'l');
b7=wextend('1','ASYM',a,7,'r');
b8=wextend('1d','ASYM',a,7);
b9=wextend('1d','ASYM',a,7,'b');
b10=wextend('1d','ASYM',a,7,'l');
b11=wextend('1d','ASYM',a,7,'r');
b12=wextend('1D','ASYM',a,7);
b13=wextend('1D','ASYM',a,7,'b');
b14=wextend('1D','ASYM',a,7,'l');
b15=wextend('1D','ASYM',a,7,'r');
b16=wextend(1,'ASYM',a',7);
b17=wextend(1,'ASYM',a',7,'b');
b18=wextend(1,'ASYM',a',7,'l');
b19=wextend(1,'ASYM',a',7,'r');
b20=wextend('1','ASYM',a',7);
b21=wextend('1','ASYM',a',7,'b');
b22=wextend('1','ASYM',a',7,'l');
b23=wextend('1','ASYM',a',7,'r');
b24=wextend('1d','ASYM',a',7);
b25=wextend('1d','ASYM',a',7,'b');
b26=wextend('1d','ASYM',a',7,'l');
b27=wextend('1d','ASYM',a',7,'r');
b28=wextend('1D','ASYM',a',7);
b29=wextend('1D','ASYM',a',7,'b');
b30=wextend('1D','ASYM',a',7,'l');
b31=wextend('1D','ASYM',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector ASYM passes!");
else
   disp("vector ASYM failes!");
end

// ZPD

b=wextend(1,'ZPD',a,7);
b1=wextend(1,'ZPD',a,7,'b');
b2=wextend(1,'ZPD',a,7,'l');
b3=wextend(1,'ZPD',a,7,'r');
b4=wextend('1','ZPD',a,7);
b5=wextend('1','ZPD',a,7,'b');
b6=wextend('1','ZPD',a,7,'l');
b7=wextend('1','ZPD',a,7,'r');
b8=wextend('1d','ZPD',a,7);
b9=wextend('1d','ZPD',a,7,'b');
b10=wextend('1d','ZPD',a,7,'l');
b11=wextend('1d','ZPD',a,7,'r');
b12=wextend('1D','ZPD',a,7);
b13=wextend('1D','ZPD',a,7,'b');
b14=wextend('1D','ZPD',a,7,'l');
b15=wextend('1D','ZPD',a,7,'r');
b16=wextend(1,'ZPD',a',7);
b17=wextend(1,'ZPD',a',7,'b');
b18=wextend(1,'ZPD',a',7,'l');
b19=wextend(1,'ZPD',a',7,'r');
b20=wextend('1','ZPD',a',7);
b21=wextend('1','ZPD',a',7,'b');
b22=wextend('1','ZPD',a',7,'l');
b23=wextend('1','ZPD',a',7,'r');
b24=wextend('1d','ZPD',a',7);
b25=wextend('1d','ZPD',a',7,'b');
b26=wextend('1d','ZPD',a',7,'l');
b27=wextend('1d','ZPD',a',7,'r');
b28=wextend('1D','ZPD',a',7);
b29=wextend('1D','ZPD',a',7,'b');
b30=wextend('1D','ZPD',a',7,'l');
b31=wextend('1D','ZPD',a',7,'r');
c=[zeros(1,7) a zeros(1,7)];
c1=[zeros(1,7) a];
c2=[a zeros(1,7)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector ZPD passes!");
else
   disp("vector ZPD failes!");
end

b=wextend(1,'zpd',a,7);
b1=wextend(1,'zpd',a,7,'b');
b2=wextend(1,'zpd',a,7,'l');
b3=wextend(1,'zpd',a,7,'r');
b4=wextend('1','zpd',a,7);
b5=wextend('1','zpd',a,7,'b');
b6=wextend('1','zpd',a,7,'l');
b7=wextend('1','zpd',a,7,'r');
b8=wextend('1d','zpd',a,7);
b9=wextend('1d','zpd',a,7,'b');
b10=wextend('1d','zpd',a,7,'l');
b11=wextend('1d','zpd',a,7,'r');
b12=wextend('1D','zpd',a,7);
b13=wextend('1D','zpd',a,7,'b');
b14=wextend('1D','zpd',a,7,'l');
b15=wextend('1D','zpd',a,7,'r');
b16=wextend(1,'zpd',a',7);
b17=wextend(1,'zpd',a',7,'b');
b18=wextend(1,'zpd',a',7,'l');
b19=wextend(1,'zpd',a',7,'r');
b20=wextend('1','zpd',a',7);
b21=wextend('1','zpd',a',7,'b');
b22=wextend('1','zpd',a',7,'l');
b23=wextend('1','zpd',a',7,'r');
b24=wextend('1d','zpd',a',7);
b25=wextend('1d','zpd',a',7,'b');
b26=wextend('1d','zpd',a',7,'l');
b27=wextend('1d','zpd',a',7,'r');
b28=wextend('1D','zpd',a',7);
b29=wextend('1D','zpd',a',7,'b');
b30=wextend('1D','zpd',a',7,'l');
b31=wextend('1D','zpd',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector zpd passes!");
else
   disp("vector zpd failes!");
end

// SP0

b=wextend(1,'SP0',a,7);
b1=wextend(1,'SP0',a,7,'b');
b2=wextend(1,'SP0',a,7,'l');
b3=wextend(1,'SP0',a,7,'r');
b4=wextend('1','SP0',a,7);
b5=wextend('1','SP0',a,7,'b');
b6=wextend('1','SP0',a,7,'l');
b7=wextend('1','SP0',a,7,'r');
b8=wextend('1d','SP0',a,7);
b9=wextend('1d','SP0',a,7,'b');
b10=wextend('1d','SP0',a,7,'l');
b11=wextend('1d','SP0',a,7,'r');
b12=wextend('1D','SP0',a,7);
b13=wextend('1D','SP0',a,7,'b');
b14=wextend('1D','SP0',a,7,'l');
b15=wextend('1D','SP0',a,7,'r');
b16=wextend(1,'SP0',a',7);
b17=wextend(1,'SP0',a',7,'b');
b18=wextend(1,'SP0',a',7,'l');
b19=wextend(1,'SP0',a',7,'r');
b20=wextend('1','SP0',a',7);
b21=wextend('1','SP0',a',7,'b');
b22=wextend('1','SP0',a',7,'l');
b23=wextend('1','SP0',a',7,'r');
b24=wextend('1d','SP0',a',7);
b25=wextend('1d','SP0',a',7,'b');
b26=wextend('1d','SP0',a',7,'l');
b27=wextend('1d','SP0',a',7,'r');
b28=wextend('1D','SP0',a',7);
b29=wextend('1D','SP0',a',7,'b');
b30=wextend('1D','SP0',a',7,'l');
b31=wextend('1D','SP0',a',7,'r');
c=[ones(1,7)*a(1) a ones(1,7)*a($)];
c1=[ones(1,7)*a(1) a];
c2=[a ones(1,7)*a($)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector SP0 passes!");
else
   disp("vector SP0 failes!");
end

b=wextend(1,'sp0',a,7);
b1=wextend(1,'sp0',a,7,'b');
b2=wextend(1,'sp0',a,7,'l');
b3=wextend(1,'sp0',a,7,'r');
b4=wextend('1','sp0',a,7);
b5=wextend('1','sp0',a,7,'b');
b6=wextend('1','sp0',a,7,'l');
b7=wextend('1','sp0',a,7,'r');
b8=wextend('1d','sp0',a,7);
b9=wextend('1d','sp0',a,7,'b');
b10=wextend('1d','sp0',a,7,'l');
b11=wextend('1d','sp0',a,7,'r');
b12=wextend('1D','sp0',a,7);
b13=wextend('1D','sp0',a,7,'b');
b14=wextend('1D','sp0',a,7,'l');
b15=wextend('1D','sp0',a,7,'r');
b16=wextend(1,'sp0',a',7);
b17=wextend(1,'sp0',a',7,'b');
b18=wextend(1,'sp0',a',7,'l');
b19=wextend(1,'sp0',a',7,'r');
b20=wextend('1','sp0',a',7);
b21=wextend('1','sp0',a',7,'b');
b22=wextend('1','sp0',a',7,'l');
b23=wextend('1','sp0',a',7,'r');
b24=wextend('1d','sp0',a',7);
b25=wextend('1d','sp0',a',7,'b');
b26=wextend('1d','sp0',a',7,'l');
b27=wextend('1d','sp0',a',7,'r');
b28=wextend('1D','sp0',a',7);
b29=wextend('1D','sp0',a',7,'b');
b30=wextend('1D','sp0',a',7,'l');
b31=wextend('1D','sp0',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector sp0 passes!");
else
   disp("vector sp0 failes!");
end

// PPD
b=wextend(1,'PPD',a,7);
b1=wextend(1,'PPD',a,7,'b');
b2=wextend(1,'PPD',a,7,'l');
b3=wextend(1,'PPD',a,7,'r');
b4=wextend('1','PPD',a,7);
b5=wextend('1','PPD',a,7,'b');
b6=wextend('1','PPD',a,7,'l');
b7=wextend('1','PPD',a,7,'r');
b8=wextend('1d','PPD',a,7);
b9=wextend('1d','PPD',a,7,'b');
b10=wextend('1d','PPD',a,7,'l');
b11=wextend('1d','PPD',a,7,'r');
b12=wextend('1D','PPD',a,7);
b13=wextend('1D','PPD',a,7,'b');
b14=wextend('1D','PPD',a,7,'l');
b15=wextend('1D','PPD',a,7,'r');
b16=wextend(1,'PPD',a',7);
b17=wextend(1,'PPD',a',7,'b');
b18=wextend(1,'PPD',a',7,'l');
b19=wextend(1,'PPD',a',7,'r');
b20=wextend('1','PPD',a',7);
b21=wextend('1','PPD',a',7,'b');
b22=wextend('1','PPD',a',7,'l');
b23=wextend('1','PPD',a',7,'r');
b24=wextend('1d','PPD',a',7);
b25=wextend('1d','PPD',a',7,'b');
b26=wextend('1d','PPD',a',7,'l');
b27=wextend('1d','PPD',a',7,'r');
b28=wextend('1D','PPD',a',7);
b29=wextend('1D','PPD',a',7,'b');
b30=wextend('1D','PPD',a',7,'l');
b31=wextend('1D','PPD',a',7,'r');
c=[a($-6:$) a a(1:7)];
c1=[a($-6:$) a];
c2=[a a(1:7)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector PPD passes!");
else
   disp("vector PPD failes!");
end

b=wextend(1,'ppd',a,7);
b1=wextend(1,'ppd',a,7,'b');
b2=wextend(1,'ppd',a,7,'l');
b3=wextend(1,'ppd',a,7,'r');
b4=wextend('1','ppd',a,7);
b5=wextend('1','ppd',a,7,'b');
b6=wextend('1','ppd',a,7,'l');
b7=wextend('1','ppd',a,7,'r');
b8=wextend('1d','ppd',a,7);
b9=wextend('1d','ppd',a,7,'b');
b10=wextend('1d','ppd',a,7,'l');
b11=wextend('1d','ppd',a,7,'r');
b12=wextend('1D','ppd',a,7);
b13=wextend('1D','ppd',a,7,'b');
b14=wextend('1D','ppd',a,7,'l');
b15=wextend('1D','ppd',a,7,'r');
b16=wextend(1,'ppd',a',7);
b17=wextend(1,'ppd',a',7,'b');
b18=wextend(1,'ppd',a',7,'l');
b19=wextend(1,'ppd',a',7,'r');
b20=wextend('1','ppd',a',7);
b21=wextend('1','ppd',a',7,'b');
b22=wextend('1','ppd',a',7,'l');
b23=wextend('1','ppd',a',7,'r');
b24=wextend('1d','ppd',a',7);
b25=wextend('1d','ppd',a',7,'b');
b26=wextend('1d','ppd',a',7,'l');
b27=wextend('1d','ppd',a',7,'r');
b28=wextend('1D','ppd',a',7);
b29=wextend('1D','ppd',a',7,'b');
b30=wextend('1D','ppd',a',7,'l');
b31=wextend('1D','ppd',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector ppd passes!");
else
   disp("vector ppd failes!");
end

// SP1
b=wextend(1,'SP1',a,7);
b1=wextend(1,'SP1',a,7,'b');
b2=wextend(1,'SP1',a,7,'l');
b3=wextend(1,'SP1',a,7,'r');
b4=wextend('1','SP1',a,7);
b5=wextend('1','SP1',a,7,'b');
b6=wextend('1','SP1',a,7,'l');
b7=wextend('1','SP1',a,7,'r');
b8=wextend('1d','SP1',a,7);
b9=wextend('1d','SP1',a,7,'b');
b10=wextend('1d','SP1',a,7,'l');
b11=wextend('1d','SP1',a,7,'r');
b12=wextend('1D','SP1',a,7);
b13=wextend('1D','SP1',a,7,'b');
b14=wextend('1D','SP1',a,7,'l');
b15=wextend('1D','SP1',a,7,'r');
b16=wextend(1,'SP1',a',7);
b17=wextend(1,'SP1',a',7,'b');
b18=wextend(1,'SP1',a',7,'l');
b19=wextend(1,'SP1',a',7,'r');
b20=wextend('1','SP1',a',7);
b21=wextend('1','SP1',a',7,'b');
b22=wextend('1','SP1',a',7,'l');
b23=wextend('1','SP1',a',7,'r');
b24=wextend('1d','SP1',a',7);
b25=wextend('1d','SP1',a',7,'b');
b26=wextend('1d','SP1',a',7,'l');
b27=wextend('1d','SP1',a',7,'r');
b28=wextend('1D','SP1',a',7);
b29=wextend('1D','SP1',a',7,'b');
b30=wextend('1D','SP1',a',7,'l');
b31=wextend('1D','SP1',a',7,'r');
ind=[1:7];
ind1=[7:-1:1];
delta1=a(2)-a(1);
delta2=a($)-a($-1);
aa=a(1)-delta1*ind1;
ae=a($)+delta2*ind;
c=[aa a ae];
c1=[aa a];
c2=[a ae];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector SP1 passes!");
else
   disp("vector SP1 failes!");
end

b=wextend(1,'sp1',a,7);
b1=wextend(1,'sp1',a,7,'b');
b2=wextend(1,'sp1',a,7,'l');
b3=wextend(1,'sp1',a,7,'r');
b4=wextend('1','sp1',a,7);
b5=wextend('1','sp1',a,7,'b');
b6=wextend('1','sp1',a,7,'l');
b7=wextend('1','sp1',a,7,'r');
b8=wextend('1d','sp1',a,7);
b9=wextend('1d','sp1',a,7,'b');
b10=wextend('1d','sp1',a,7,'l');
b11=wextend('1d','sp1',a,7,'r');
b12=wextend('1D','sp1',a,7);
b13=wextend('1D','sp1',a,7,'b');
b14=wextend('1D','sp1',a,7,'l');
b15=wextend('1D','sp1',a,7,'r');
b16=wextend(1,'sp1',a',7);
b17=wextend(1,'sp1',a',7,'b');
b18=wextend(1,'sp1',a',7,'l');
b19=wextend(1,'sp1',a',7,'r');
b20=wextend('1','sp1',a',7);
b21=wextend('1','sp1',a',7,'b');
b22=wextend('1','sp1',a',7,'l');
b23=wextend('1','sp1',a',7,'r');
b24=wextend('1d','sp1',a',7);
b25=wextend('1d','sp1',a',7,'b');
b26=wextend('1d','sp1',a',7,'l');
b27=wextend('1d','sp1',a',7,'r');
b28=wextend('1D','sp1',a',7);
b29=wextend('1D','sp1',a',7,'b');
b30=wextend('1D','sp1',a',7,'l');
b31=wextend('1D','sp1',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector sp1 passes!");
else
   disp("vector sp1 failes!");
end

b=wextend(1,'SPD',a,7);
b1=wextend(1,'SPD',a,7,'b');
b2=wextend(1,'SPD',a,7,'l');
b3=wextend(1,'SPD',a,7,'r');
b4=wextend('1','SPD',a,7);
b5=wextend('1','SPD',a,7,'b');
b6=wextend('1','SPD',a,7,'l');
b7=wextend('1','SPD',a,7,'r');
b8=wextend('1d','SPD',a,7);
b9=wextend('1d','SPD',a,7,'b');
b10=wextend('1d','SPD',a,7,'l');
b11=wextend('1d','SPD',a,7,'r');
b12=wextend('1D','SPD',a,7);
b13=wextend('1D','SPD',a,7,'b');
b14=wextend('1D','SPD',a,7,'l');
b15=wextend('1D','SPD',a,7,'r');
b16=wextend(1,'SPD',a',7);
b17=wextend(1,'SPD',a',7,'b');
b18=wextend(1,'SPD',a',7,'l');
b19=wextend(1,'SPD',a',7,'r');
b20=wextend('1','SPD',a',7);
b21=wextend('1','SPD',a',7,'b');
b22=wextend('1','SPD',a',7,'l');
b23=wextend('1','SPD',a',7,'r');
b24=wextend('1d','SPD',a',7);
b25=wextend('1d','SPD',a',7,'b');
b26=wextend('1d','SPD',a',7,'l');
b27=wextend('1d','SPD',a',7,'r');
b28=wextend('1D','SPD',a',7);
b29=wextend('1D','SPD',a',7,'b');
b30=wextend('1D','SPD',a',7,'l');
b31=wextend('1D','SPD',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector SPD passes!");
else
   disp("vector SPD failes!");
end

b=wextend(1,'spd',a,7);
b1=wextend(1,'spd',a,7,'b');
b2=wextend(1,'spd',a,7,'l');
b3=wextend(1,'spd',a,7,'r');
b4=wextend('1','spd',a,7);
b5=wextend('1','spd',a,7,'b');
b6=wextend('1','spd',a,7,'l');
b7=wextend('1','spd',a,7,'r');
b8=wextend('1d','spd',a,7);
b9=wextend('1d','spd',a,7,'b');
b10=wextend('1d','spd',a,7,'l');
b11=wextend('1d','spd',a,7,'r');
b12=wextend('1D','spd',a,7);
b13=wextend('1D','spd',a,7,'b');
b14=wextend('1D','spd',a,7,'l');
b15=wextend('1D','spd',a,7,'r');
b16=wextend(1,'spd',a',7);
b17=wextend(1,'spd',a',7,'b');
b18=wextend(1,'spd',a',7,'l');
b19=wextend(1,'spd',a',7,'r');
b20=wextend('1','spd',a',7);
b21=wextend('1','spd',a',7,'b');
b22=wextend('1','spd',a',7,'l');
b23=wextend('1','spd',a',7,'r');
b24=wextend('1d','spd',a',7);
b25=wextend('1d','spd',a',7,'b');
b26=wextend('1d','spd',a',7,'l');
b27=wextend('1d','spd',a',7,'r');
b28=wextend('1D','spd',a',7);
b29=wextend('1D','spd',a',7,'b');
b30=wextend('1D','spd',a',7,'l');
b31=wextend('1D','spd',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector spd passes!");
else
   disp("vector spd failes!");
end

// PER
b=wextend(1,'PER',a,7);
b1=wextend(1,'PER',a,7,'b');
b2=wextend(1,'PER',a,7,'l');
b3=wextend(1,'PER',a,7,'r');
b4=wextend('1','PER',a,7);
b5=wextend('1','PER',a,7,'b');
b6=wextend('1','PER',a,7,'l');
b7=wextend('1','PER',a,7,'r');
b8=wextend('1d','PER',a,7);
b9=wextend('1d','PER',a,7,'b');
b10=wextend('1d','PER',a,7,'l');
b11=wextend('1d','PER',a,7,'r');
b12=wextend('1D','PER',a,7);
b13=wextend('1D','PER',a,7,'b');
b14=wextend('1D','PER',a,7,'l');
b15=wextend('1D','PER',a,7,'r');
b16=wextend(1,'PER',a',7);
b17=wextend(1,'PER',a',7,'b');
b18=wextend(1,'PER',a',7,'l');
b19=wextend(1,'PER',a',7,'r');
b20=wextend('1','PER',a',7);
b21=wextend('1','PER',a',7,'b');
b22=wextend('1','PER',a',7,'l');
b23=wextend('1','PER',a',7,'r');
b24=wextend('1d','PER',a',7);
b25=wextend('1d','PER',a',7,'b');
b26=wextend('1d','PER',a',7,'l');
b27=wextend('1d','PER',a',7,'r');
b28=wextend('1D','PER',a',7);
b29=wextend('1D','PER',a',7,'b');
b30=wextend('1D','PER',a',7,'l');
b31=wextend('1D','PER',a',7,'r');
aa=[a a($)];
c=[aa($-6:$) aa a(1:7)];
c1=[aa($-6:$) aa];
c2=[aa a(1:7)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector PER passes!");
else
   disp("vector PER failes!");
end

b=wextend(1,'per',a,7);
b1=wextend(1,'per',a,7,'b');
b2=wextend(1,'per',a,7,'l');
b3=wextend(1,'per',a,7,'r');
b4=wextend('1','per',a,7);
b5=wextend('1','per',a,7,'b');
b6=wextend('1','per',a,7,'l');
b7=wextend('1','per',a,7,'r');
b8=wextend('1d','per',a,7);
b9=wextend('1d','per',a,7,'b');
b10=wextend('1d','per',a,7,'l');
b11=wextend('1d','per',a,7,'r');
b12=wextend('1D','per',a,7);
b13=wextend('1D','per',a,7,'b');
b14=wextend('1D','per',a,7,'l');
b15=wextend('1D','per',a,7,'r');
b16=wextend(1,'per',a',7);
b17=wextend(1,'per',a',7,'b');
b18=wextend(1,'per',a',7,'l');
b19=wextend(1,'per',a',7,'r');
b20=wextend('1','per',a',7);
b21=wextend('1','per',a',7,'b');
b22=wextend('1','per',a',7,'l');
b23=wextend('1','per',a',7,'r');
b24=wextend('1d','per',a',7);
b25=wextend('1d','per',a',7,'b');
b26=wextend('1d','per',a',7,'l');
b27=wextend('1d','per',a',7,'r');
b28=wextend('1D','per',a',7);
b29=wextend('1D','per',a',7,'b');
b30=wextend('1D','per',a',7,'l');
b31=wextend('1D','per',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector per passes!");
else
   disp("vector per failes!");
end

a=rand(1,50,'normal');
b=wextend(1,'PER',a,7);
b1=wextend(1,'PER',a,7,'b');
b2=wextend(1,'PER',a,7,'l');
b3=wextend(1,'PER',a,7,'r');
b4=wextend('1','PER',a,7);
b5=wextend('1','PER',a,7,'b');
b6=wextend('1','PER',a,7,'l');
b7=wextend('1','PER',a,7,'r');
b8=wextend('1d','PER',a,7);
b9=wextend('1d','PER',a,7,'b');
b10=wextend('1d','PER',a,7,'l');
b11=wextend('1d','PER',a,7,'r');
b12=wextend('1D','PER',a,7);
b13=wextend('1D','PER',a,7,'b');
b14=wextend('1D','PER',a,7,'l');
b15=wextend('1D','PER',a,7,'r');
b16=wextend(1,'PER',a',7);
b17=wextend(1,'PER',a',7,'b');
b18=wextend(1,'PER',a',7,'l');
b19=wextend(1,'PER',a',7,'r');
b20=wextend('1','PER',a',7);
b21=wextend('1','PER',a',7,'b');
b22=wextend('1','PER',a',7,'l');
b23=wextend('1','PER',a',7,'r');
b24=wextend('1d','PER',a',7);
b25=wextend('1d','PER',a',7,'b');
b26=wextend('1d','PER',a',7,'l');
b27=wextend('1d','PER',a',7,'r');
b28=wextend('1D','PER',a',7);
b29=wextend('1D','PER',a',7,'b');
b30=wextend('1D','PER',a',7,'l');
b31=wextend('1D','PER',a',7,'r');
c=[a($-6:$) a a(1:7)];
c1=[a($-6:$) a];
c2=[a a(1:7)];
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector PER passes!");
else
   disp("vector PER failes!");
end

b=wextend(1,'per',a,7);
b1=wextend(1,'per',a,7,'b');
b2=wextend(1,'per',a,7,'l');
b3=wextend(1,'per',a,7,'r');
b4=wextend('1','per',a,7);
b5=wextend('1','per',a,7,'b');
b6=wextend('1','per',a,7,'l');
b7=wextend('1','per',a,7,'r');
b8=wextend('1d','per',a,7);
b9=wextend('1d','per',a,7,'b');
b10=wextend('1d','per',a,7,'l');
b11=wextend('1d','per',a,7,'r');
b12=wextend('1D','per',a,7);
b13=wextend('1D','per',a,7,'b');
b14=wextend('1D','per',a,7,'l');
b15=wextend('1D','per',a,7,'r');
b16=wextend(1,'per',a',7);
b17=wextend(1,'per',a',7,'b');
b18=wextend(1,'per',a',7,'l');
b19=wextend(1,'per',a',7,'r');
b20=wextend('1','per',a',7);
b21=wextend('1','per',a',7,'b');
b22=wextend('1','per',a',7,'l');
b23=wextend('1','per',a',7,'r');
b24=wextend('1d','per',a',7);
b25=wextend('1d','per',a',7,'b');
b26=wextend('1d','per',a',7,'l');
b27=wextend('1d','per',a',7,'r');
b28=wextend('1D','per',a',7);
b29=wextend('1D','per',a',7,'b');
b30=wextend('1D','per',a',7,'l');
b31=wextend('1D','per',a',7,'r');

e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c1));
e4=sum(abs(b3-c2));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c1));
e8=sum(abs(b7-c2));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c1));
e12=sum(abs(b11-c2));
e13=sum(abs(b12-c));
e14=sum(abs(b13-c));
e15=sum(abs(b14-c1));
e16=sum(abs(b15-c2));
e17=sum(abs(b16'-c));
e18=sum(abs(b17'-c));
e19=sum(abs(b18'-c1));
e20=sum(abs(b19'-c2));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c1));
e24=sum(abs(b23'-c2));
e25=sum(abs(b24'-c));
e26=sum(abs(b25'-c));
e27=sum(abs(b26'-c1));
e28=sum(abs(b27'-c2));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c1));
e32=sum(abs(b31'-c2));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9+e10;
e=e+e11+e12+e13+e14+e15+e16+e17+e18+e19+e20;
e=e+e21+e22+e23+e24+e25+e26+e27+e28+e29+e30+e31+e32;
if (e<1E-8)
   disp("vector per passes!");
else
   disp("vector per failes!");
end

clear a;
clear aa;
clear ae;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear b6;
clear b7;
clear b8;
clear b9;
clear b10;
clear b11;
clear b12;
clear b13;
clear b14;
clear b15;
clear b16;
clear b17;
clear b18;
clear b19;
clear b20;
clear b21;
clear b22;
clear b23;
clear b24;
clear b25;
clear b26;
clear b27;
clear b28;
clear b29;
clear b30;
clear b31;
clear c;
clear c1;
clear c2;
clear ind;
clear ind1;
clear e;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;
clear e7;
clear e8;
clear e9;
clear e10;
clear e11;
clear e12;
clear e13;
clear e14;
clear e15;
clear e16;
clear e17;
clear e18;
clear e19;
clear e20;
clear e21;
clear e22;
clear e23;
clear e24;
clear e25;
clear e26;
clear e27;
clear e28;
clear e29;
clear e30;
clear e31;
clear e32;

disp("-->Matrix Input<--");
// symh
a=rand(50,51,'normal');
b=wextend(2,'symh',a,7);
b1=wextend('2','symh',a,7);
b2=wextend('2d','symh',a,7);
b3=wextend('2D','symh',a,7);
b4=wextend(2,'symh',a',7);
b5=wextend('2','symh',a',7);
b6=wextend('2d','symh',a',7);
b7=wextend('2D','symh',a',7);
b8=wextend(2,'SYMH',a,7);
b9=wextend('2','SYMH',a,7);
b10=wextend('2d','SYMH',a,7);
b11=wextend('2D','SYMH',a,7);
b12=wextend(2,'SYMH',a',7);
b13=wextend('2','SYMH',a',7);
b14=wextend('2d','SYMH',a',7);
b15=wextend('2D','SYMH',a',7);
b16=wextend(2,'sym',a,7);
b17=wextend('2','sym',a,7);
b18=wextend('2d','sym',a,7);
b19=wextend('2D','sym',a,7);
b20=wextend(2,'sym',a',7);
b21=wextend('2','sym',a',7);
b22=wextend('2d','sym',a',7);
b23=wextend('2D','sym',a',7);
b24=wextend(2,'SYM',a,7);
b25=wextend('2','SYM',a,7);
b26=wextend('2d','SYM',a,7);
b27=wextend('2D','SYM',a,7);
b28=wextend(2,'SYM',a',7);
b29=wextend('2','SYM',a',7);
b30=wextend('2d','SYM',a',7);
b31=wextend('2D','SYM',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'symh',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'symh',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e17=sum(abs(b16-c));
e18=sum(abs(b17-c));
e19=sum(abs(b18-c));
e20=sum(abs(b19-c));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c));
e24=sum(abs(b23'-c));
e25=sum(abs(b24-c));
e26=sum(abs(b25-c));
e27=sum(abs(b26-c));
e28=sum(abs(b27-c));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c));
e32=sum(abs(b31'-c));
e=e1+e2+e3+e4+e9+e10;
e=e+e11+e12+e17+e18+e19+e20;
e=e+e25+e26+e27+e28;
if (e<1E-8)
   disp("Matrix symh passes!");
else
   disp("Matrix symh failes!");
end


// asymh
b=wextend(2,'asymh',a,7);
b1=wextend('2','asymh',a,7);
b2=wextend('2d','asymh',a,7);
b3=wextend('2D','asymh',a,7);
b4=wextend(2,'asymh',a',7);
b5=wextend('2','asymh',a',7);
b6=wextend('2d','asymh',a',7);
b7=wextend('2D','asymh',a',7);
b8=wextend(2,'ASYMH',a,7);
b9=wextend('2','ASYMH',a,7);
b10=wextend('2d','ASYMH',a,7);
b11=wextend('2D','ASYMH',a,7);
b12=wextend(2,'ASYMH',a',7);
b13=wextend('2','ASYMH',a',7);
b14=wextend('2d','ASYMH',a',7);
b15=wextend('2D','ASYMH',a',7);
b16=wextend(2,'asym',a,7);
b17=wextend('2','asym',a,7);
b18=wextend('2d','asym',a,7);
b19=wextend('2D','asym',a,7);
b20=wextend(2,'asym',a',7);
b21=wextend('2','asym',a',7);
b22=wextend('2d','asym',a',7);
b23=wextend('2D','asym',a',7);
b24=wextend(2,'ASYM',a,7);
b25=wextend('2','ASYM',a,7);
b26=wextend('2d','ASYM',a,7);
b27=wextend('2D','ASYM',a,7);
b28=wextend(2,'ASYM',a',7);
b29=wextend('2','ASYM',a',7);
b30=wextend('2d','ASYM',a',7);
b31=wextend('2D','ASYM',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'asymh',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'asymh',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e17=sum(abs(b16-c));
e18=sum(abs(b17-c));
e19=sum(abs(b18-c));
e20=sum(abs(b19-c));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c));
e24=sum(abs(b23'-c));
e25=sum(abs(b24-c));
e26=sum(abs(b25-c));
e27=sum(abs(b26-c));
e28=sum(abs(b27-c));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c));
e32=sum(abs(b31'-c));
e=e1+e2+e3+e4+e9+e10;
e=e+e11+e12+e17+e18+e19+e20;
e=e+e25+e26+e27+e28;
if (e<1E-8)
   disp("Matrix asymh passes!");
else
   disp("Matrix asymh failes!");
end


// SPD
b=wextend(2,'spd',a,7);
b1=wextend('2','spd',a,7);
b2=wextend('2d','spd',a,7);
b3=wextend('2D','spd',a,7);
b4=wextend(2,'spd',a',7);
b5=wextend('2','spd',a',7);
b6=wextend('2d','spd',a',7);
b7=wextend('2D','spd',a',7);
b8=wextend(2,'SPD',a,7);
b9=wextend('2','SPD',a,7);
b10=wextend('2d','SPD',a,7);
b11=wextend('2D','SPD',a,7);
b12=wextend(2,'SPD',a',7);
b13=wextend('2','SPD',a',7);
b14=wextend('2d','SPD',a',7);
b15=wextend('2D','SPD',a',7);
b16=wextend(2,'sp1',a,7);
b17=wextend('2','sp1',a,7);
b18=wextend('2d','sp1',a,7);
b19=wextend('2D','sp1',a,7);
b20=wextend(2,'sp1',a',7);
b21=wextend('2','sp1',a',7);
b22=wextend('2d','sp1',a',7);
b23=wextend('2D','sp1',a',7);
b24=wextend(2,'SP1',a,7);
b25=wextend('2','SP1',a,7);
b26=wextend('2d','SP1',a,7);
b27=wextend('2D','SP1',a,7);
b28=wextend(2,'SP1',a',7);
b29=wextend('2','SP1',a',7);
b30=wextend('2d','SP1',a',7);
b31=wextend('2D','SP1',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'spd',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'spd',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e17=sum(abs(b16-c));
e18=sum(abs(b17-c));
e19=sum(abs(b18-c));
e20=sum(abs(b19-c));
e21=sum(abs(b20'-c));
e22=sum(abs(b21'-c));
e23=sum(abs(b22'-c));
e24=sum(abs(b23'-c));
e25=sum(abs(b24-c));
e26=sum(abs(b25-c));
e27=sum(abs(b26-c));
e28=sum(abs(b27-c));
e29=sum(abs(b28'-c));
e30=sum(abs(b29'-c));
e31=sum(abs(b30'-c));
e32=sum(abs(b31'-c));
e=e1+e2+e3+e4+e9+e10;
e=e+e11+e12+e17+e18+e19+e20;
e=e+e25+e26+e27+e28;
if (e<1E-8)
   disp("Matrix spd passes!");
else
   disp("Matrix spd failes!");
end

// sp0
b=wextend(2,'sp0',a,7);
b1=wextend('2','sp0',a,7);
b2=wextend('2d','sp0',a,7);
b3=wextend('2D','sp0',a,7);
b4=wextend(2,'sp0',a',7);
b5=wextend('2','sp0',a',7);
b6=wextend('2d','sp0',a',7);
b7=wextend('2D','sp0',a',7);
b8=wextend(2,'SP0',a,7);
b9=wextend('2','SP0',a,7);
b10=wextend('2d','SP0',a,7);
b11=wextend('2D','SP0',a,7);
b12=wextend(2,'SP0',a',7);
b13=wextend('2','SP0',a',7);
b14=wextend('2d','SP0',a',7);
b15=wextend('2D','SP0',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'sp0',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'sp0',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e=e1+e2+e3+e4+e9+e10;
e=e+e11+e12;
if (e<1E-8)
   disp("Matrix sp0 passes!");
else
   disp("Matrix sp0 failes!");
end

// symw
b=wextend(2,'symw',a,7);
b1=wextend('2','symw',a,7);
b2=wextend('2d','symw',a,7);
b3=wextend('2D','symw',a,7);
b4=wextend(2,'symw',a',7);
b5=wextend('2','symw',a',7);
b6=wextend('2d','symw',a',7);
b7=wextend('2D','symw',a',7);
b8=wextend(2,'SYMW',a,7);
b9=wextend('2','SYMW',a,7);
b10=wextend('2d','SYMW',a,7);
b11=wextend('2D','SYMW',a,7);
b12=wextend(2,'SYMW',a',7);
b13=wextend('2','SYMW',a',7);
b14=wextend('2d','SYMW',a',7);
b15=wextend('2D','SYMW',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'symw',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'symw',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e=e1+e2+e3+e4+e9+e10;
e=e+e11+e12;
if (e<1E-8)
   disp("Matrix symw passes!");
else
   disp("Matrix symw failes!");
end

// asymw
b=wextend(2,'asymw',a,7);
b1=wextend('2','asymw',a,7);
b2=wextend('2d','asymw',a,7);
b3=wextend('2D','asymw',a,7);
b4=wextend(2,'asymw',a',7);
b5=wextend('2','asymw',a',7);
b6=wextend('2d','asymw',a',7);
b7=wextend('2D','asymw',a',7);
b8=wextend(2,'ASYMW',a,7);
b9=wextend('2','ASYMW',a,7);
b10=wextend('2d','ASYMW',a,7);
b11=wextend('2D','ASYMW',a,7);
b12=wextend(2,'ASYMW',a',7);
b13=wextend('2','ASYMW',a',7);
b14=wextend('2d','ASYMW',a',7);
b15=wextend('2D','ASYMW',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'asymw',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'asymw',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e=e1+e2+e3+e4+e9+e10;
e=e+e11+e12;
if (e<1E-8)
   disp("Matrix asymw passes!");
else
   disp("Matrix asymw failes!");
end

// zpd
b=wextend(2,'zpd',a,7);
b1=wextend('2','zpd',a,7);
b2=wextend('2d','zpd',a,7);
b3=wextend('2D','zpd',a,7);
b4=wextend(2,'zpd',a',7);
b5=wextend('2','zpd',a',7);
b6=wextend('2d','zpd',a',7);
b7=wextend('2D','zpd',a',7);
b8=wextend(2,'ZPD',a,7);
b9=wextend('2','ZPD',a,7);
b10=wextend('2d','ZPD',a,7);
b11=wextend('2D','ZPD',a,7);
b12=wextend(2,'ZPD',a',7);
b13=wextend('2','ZPD',a',7);
b14=wextend('2d','ZPD',a',7);
b15=wextend('2D','ZPD',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'zpd',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'zpd',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e=e1+e2+e3+e4+e9+e10;
e=e+e11+e12;
if (e<1E-8)
   disp("Matrix zpd passes!");
else
   disp("Matrix zpd failes!");
end

// ppd
b=wextend(2,'ppd',a,7);
b1=wextend('2','ppd',a,7);
b2=wextend('2d','ppd',a,7);
b3=wextend('2D','ppd',a,7);
b4=wextend(2,'ppd',a',7);
b5=wextend('2','ppd',a',7);
b6=wextend('2d','ppd',a',7);
b7=wextend('2D','ppd',a',7);
b8=wextend(2,'PPD',a,7);
b9=wextend('2','PPD',a,7);
b10=wextend('2d','PPD',a,7);
b11=wextend('2D','PPD',a,7);
b12=wextend(2,'PPD',a',7);
b13=wextend('2','PPD',a',7);
b14=wextend('2d','PPD',a',7);
b15=wextend('2D','PPD',a',7);
c=zeros(64,65);
for i=1:50,
c(i+7,:)=wextend(1,'ppd',a(i,:),7,'b');
end
c=c';
for i=1:65,
c(i,:)=wextend(1,'ppd',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4'-c));
e6=sum(abs(b5'-c));
e7=sum(abs(b6'-c));
e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
e13=sum(abs(b12'-c));
e14=sum(abs(b13'-c));
e15=sum(abs(b14'-c));
e16=sum(abs(b15'-c));
e=e1+e2+e3+e8+e9+e10;
e=e+e11+e12;
if (e<1E-8)
   disp("Matrix ppd passes!");
else
   disp("Matrix ppd failes!");
end

// per
b=wextend(2,'per',a,7);
b1=wextend('2','per',a,7);
b2=wextend('2d','per',a,7);
b3=wextend('2D','per',a,7);
//b4=wextend(2,'per',a',7);
//b5=wextend('2','per',a',7);
//b6=wextend('2d','per',a',7);
//b7=wextend('2D','per',a',7);
b8=wextend(2,'PER',a,7);
b9=wextend('2','PER',a,7);
b10=wextend('2d','PER',a,7);
b11=wextend('2D','PER',a,7);
//b12=wextend(2,'PER',a',7);
//b13=wextend('2','PER',a',7);
//b14=wextend('2d','PER',a',7);
//b15=wextend('2D','PER',a',7);
c=zeros(64,66);
for i=1:50,
c(i+7,:)=wextend(1,'per',a(i,:),7,'b');
end
c=c';
for i=1:66,
c(i,:)=wextend(1,'per',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
//e5=sum(abs(b4'-c));
//e6=sum(abs(b5'-c));
//e7=sum(abs(b6'-c));
//e8=sum(abs(b7'-c));
e9=sum(abs(b8-c));
e10=sum(abs(b9-c));
e11=sum(abs(b10-c));
e12=sum(abs(b11-c));
//e13=sum(abs(b12'-c));
//e14=sum(abs(b13'-c));
//e15=sum(abs(b14'-c));
//e16=sum(abs(b15'-c));
e=e1+e2+e3+e8+e9+e10;
e=e+e11+e12;
if (e<1E-8)
   disp("Matrix per passes!");
else
   disp("Matrix per failes!");
end

clear a;
clear aa;
clear ae;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear b6;
clear b7;
clear b8;
clear b9;
clear b10;
clear b11;
clear b12;
clear b13;
clear b14;
clear b15;
clear b16;
clear b17;
clear b18;
clear b19;
clear b20;
clear b21;
clear b22;
clear b23;
clear b24;
clear b25;
clear b26;
clear b27;
clear b28;
clear b29;
clear b30;
clear b31;
clear c;
clear e;
clear e1;
clear e2;
clear e3;
clear e4;
clear e5;
clear e6;
clear e7;
clear e8;
clear e9;
clear e10;
clear e11;
clear e12;
clear e13;
clear e14;
clear e15;
clear e16;
clear e17;
clear e18;
clear e19;
clear e20;
clear e21;
clear e22;
clear e23;
clear e24;
clear e25;
clear e26;
clear e27;
clear e28;
clear e29;
clear e30;
clear e31;
clear e32;

disp("Matrix 2D Extension Passes");

disp("-->Matrix Input, 1D Extension<--");
a=rand(50,51,'normal');
b=wextend(2,'symh',a,[7 6]);
b1=wextend('2','symh',a,[7 6]);
b2=wextend('2d','symh',a,[7 6]);
b3=wextend('2D','symh',a,[7 6]);
b4=wextend(2,'symh',a,[7 6]');
b5=wextend('2','symh',a,[7 6]');
b6=wextend('2d','symh',a,[7 6]');
b7=wextend('2D','symh',a,[7 6]');
c=zeros(64,63);
for i=1:50,
c(i+7,:)=wextend(1,'symh',a(i,:),6,'b');
end
c=c';
for i=1:63,
c(i,:)=wextend(1,'symh',c(i,8:57),7,'b');
end
c=c';
e1=sum(abs(b-c));
e2=sum(abs(b1-c));
e3=sum(abs(b2-c));
e4=sum(abs(b3-c));
e5=sum(abs(b4-c));
e6=sum(abs(b5-c));
e7=sum(abs(b6-c));
e8=sum(abs(b7-c));
e=e1+e2+e3+e4+e5+e6+e7+e8;
if (e<1E-8)
   disp("Matrix Input passes");
else
   disp("Matrix Input failes");
end

b=wextend(2,'symh',a,[7 6],['b' 'b']);
b1=wextend(2,'symh',a,[7 6],['b' 'r']);
b2=wextend(2,'symh',a,[7 6],['b' 'l']);
b3=wextend(2,'symh',a,[7 6],['r' 'b']);
b4=wextend(2,'symh',a,[7 6],['r' 'r']);
b5=wextend(2,'symh',a,[7 6],['r' 'l']);
b6=wextend(2,'symh',a,[7 6],['l' 'b']);
b7=wextend(2,'symh',a,[7 6],['l' 'r']);
b8=wextend(2,'symh',a,[7 6],['l' 'l']);
b9=wextend(2,'symh',a,[7 6],'bb');
b10=wextend(2,'symh',a,[7 6],'br');
b11=wextend(2,'symh',a,[7 6],'bl');
b12=wextend(2,'symh',a,[7 6],'rb');
b13=wextend(2,'symh',a,[7 6],'rr');
b14=wextend(2,'symh',a,[7 6],'rl');
b15=wextend(2,'symh',a,[7 6],'lb');
b16=wextend(2,'symh',a,[7 6],'lr');
b17=wextend(2,'symh',a,[7 6],'ll');
c1=zeros(64,63);
c2=zeros(64,57);
c3=zeros(64,57);
c4=zeros(57,63);
c5=zeros(57,57);
c6=zeros(57,57);
c7=zeros(57,63);
c8=zeros(57,57);
c9=zeros(57,57);
for i=1:50,
c1(i+7,:)=wextend(1,'symh',a(i,:),6,'b');
end
c1=c1';
for i=1:63,
c1(i,:)=wextend(1,'symh',c1(i,8:57),7,'b');
end
c1=c1';
for i=1:50,
c2(i+7,:)=wextend(1,'symh',a(i,:),6,'r');
end
c2=c2';
for i=1:57,
c2(i,:)=wextend(1,'symh',c2(i,8:57),7,'b');
end
c2=c2';
for i=1:50,
c3(i+7,:)=wextend(1,'symh',a(i,:),6,'l');
end
c3=c3';
for i=1:57,
c3(i,:)=wextend(1,'symh',c3(i,8:57),7,'b');
end
c3=c3';
for i=1:50,
c4(i+7,:)=wextend(1,'symh',a(i,:),6,'b');
end
c4=c4';
for i=1:63,
c4(i,:)=wextend(1,'symh',c4(i,8:57),7,'r');
end
c4=c4';
for i=1:50,
c5(i+7,:)=wextend(1,'symh',a(i,:),6,'r');
end
c5=c5';
for i=1:57,
c5(i,:)=wextend(1,'symh',c5(i,8:57),7,'r');
end
c5=c5';
for i=1:50,
c6(i+7,:)=wextend(1,'symh',a(i,:),6,'l');
end
c6=c6';
for i=1:57,
c6(i,:)=wextend(1,'symh',c6(i,8:57),7,'r');
end
c6=c6';
for i=1:50,
c7(i+7,:)=wextend(1,'symh',a(i,:),6,'b');
end
c7=c7';
for i=1:63,
c7(i,:)=wextend(1,'symh',c7(i,8:57),7,'l');
end
c7=c7';
for i=1:50,
c8(i+7,:)=wextend(1,'symh',a(i,:),6,'r');
end
c8=c8';
for i=1:57,
c8(i,:)=wextend(1,'symh',c8(i,8:57),7,'l');
end
c8=c8';
for i=1:50,
c9(i+7,:)=wextend(1,'symh',a(i,:),6,'l');
end
c9=c9';
for i=1:57,
c9(i,:)=wextend(1,'symh',c9(i,8:57),7,'l');
end
c9=c9';
e1=sum(abs(b-c1));
e2=sum(abs(b1-c2));
e3=sum(abs(b2-c3));
e4=sum(abs(b3-c4));
e5=sum(abs(b4-c5));
e6=sum(abs(b5-c6));
e7=sum(abs(b6-c7));
e8=sum(abs(b7-c8));
e9=sum(abs(b8-c9));
e10=sum(abs(b9-c1));
e11=sum(abs(b10-c2));
e12=sum(abs(b11-c3));
e13=sum(abs(b12-c4));
e14=sum(abs(b13-c5));
e15=sum(abs(b14-c6));
e16=sum(abs(b15-c7));
e17=sum(abs(b16-c8));
e18=sum(abs(b17-c9));
e=e1+e2+e3+e4+e5+e6+e7+e8+e9;
e=e+e10+e11+e12+e13+e14+e15+e16+e17+e18;
if (e<1E-8)
  disp("Matrix Input passes");
else
  disp("Matrix Input fails");
end

clear a;
clear b;
clear b1;
clear b2;
clear b3;
clear b4;
clear b5;
clear b6;
clear b7;
clear b8;
clear b9;
clear b10;
clear b11;
clear b12;
clear b13;
clear b14;
clear b15;
clear b16;
clear b17;
clear c1;
clear c2;
clear c3;
clear c4;
clear c5;
clear c6;
clear c7;
clear c8;
clear c9;
clear e;
clear e1;
clear e2; 
clear e3;
clear e4;
clear e5;
clear e6;
clear e7;
clear e8;
clear e9;
clear e10;
clear e11;
clear e12;
clear e13;
clear e14;
clear e15;
clear e16;
clear e17;
clear e18;
clear i;

a=rand(50,51,'normal');
b=wextend('ar','symh',a,7);
b1=wextend('ar','symh',a,7,'b');
b2=wextend('ar','symh',a,7,'l');
b3=wextend('ar','symh',a,7,'r');
b4=wextend('addrow','symh',a,7);
b5=wextend('addrow','symh',a,7,'b');
b6=wextend('addrow','symh',a,7,'l');
b7=wextend('addrow','symh',a,7,'r');
c1=zeros(64,51);
c1=c1';
aa=a';
for i=1:51,
c1(i,:)=wextend(1,'symh',aa(i,:),7,'b');
end
c1=c1';

c2=zeros(57,51);
c2=c2';
aa=a';
for i=1:51,
c2(i,:)=wextend(1,'symh',aa(i,:),7,'l');
end
c2=c2';

c3=zeros(57,51);
c3=c3';
aa=a';
for i=1:51,
c3(i,:)=wextend(1,'symh',aa(i,:),7,'r');
end
c3=c3';

e1=sum(abs(b-c1));
e2=sum(abs(b1-c1));
e3=sum(abs(b2-c2));
e4=sum(abs(b3-c3));
e5=sum(abs(b4-c1));
e6=sum(abs(b5-c1));
e7=sum(abs(b6-c2));
e8=sum(abs(b7-c3));

e=e1+e2+e3+e4+e5+e6+e7+e8;
if (e<1E-8)
  disp("row extension passes");
else
  disp("row extension fails");
end

b=wextend('ac','symh',a,7);
b1=wextend('ac','symh',a,7,'b');
b2=wextend('ac','symh',a,7,'l');
b3=wextend('ac','symh',a,7,'r');
b4=wextend('addcol','symh',a,7);
b5=wextend('addcol','symh',a,7,'b');
b6=wextend('addcol','symh',a,7,'l');
b7=wextend('addcol','symh',a,7,'r');
c1=zeros(50,65);
for i=1:50,
c1(i,:)=wextend(1,'symh',a(i,:),7,'b');
end
c2=zeros(50,58);
for i=1:50,
c2(i,:)=wextend(1,'symh',a(i,:),7,'l');
end
c3=zeros(50,58);
for i=1:50,
c3(i,:)=wextend(1,'symh',a(i,:),7,'r');
end

e1=sum(abs(b-c1));
e2=sum(abs(b1-c1));
e3=sum(abs(b2-c2));
e4=sum(abs(b3-c3));
e5=sum(abs(b4-c1));
e6=sum(abs(b5-c1));
e7=sum(abs(b6-c2));
e8=sum(abs(b7-c3));

e=e1+e2+e3+e4+e5+e6+e7+e8;
if (e<1E-8)
  disp("col extension passes");
else
  disp("col extension fails");
end

disp("------------>Utility Test Finish<---------------");
