/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2006 - INRIA - Djalel Abdemouche
 * Copyright (C) 2006 - INRIA - Jean-Baptiste Silvy
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

/*------------------------------------------------------------------------*/
/* file: sciCall.h                                                        */
/* desc : Graphic subroutines interface                                   */
/*------------------------------------------------------------------------*/

#include "BOOL.h"
#include "ObjectStructure.h"

#ifndef _SCI_CALL_H_
#define _SCI_CALL_H_

void Objrect ( double * x         ,
               double * y         ,
               double * width     ,
               double * height    ,
               int    * foreground,
               int    * background,
               BOOL     isfilled  ,
               BOOL     isline    ,
               long   * hdl       ) ;

void Objarc( double * angle1    ,
             double * angle2    ,
             double * x         ,
             double * y         ,
             double * width     ,
             double * height    ,
             int    * foreground,
             int    * background,
             BOOL     isfilled  ,
             BOOL     isline    ,
             long   * hdl        ) ;

void Objpoly ( double  * x     ,
               double  * y     ,
               int   n     ,
               int   closed,
               int       mark  ,
               long    * hdl    ) ;

void Objfpoly ( double  * x    ,
                double  * y    ,
                int   n    ,
                int * style,
                long    * hdl  ,
                int   shading ) ;

void Objsegs ( int * style,
               int   flag ,
               int   n1   ,
               double  * x    ,
               double  * y    ,
               double    arsize ) ;

void Objstring( char            ** fname      ,
                int                nbRow      ,
                int                nbCol      ,
                double             x          ,
                double             y          ,
                double           * angle      ,
                double             box[4]     ,
                BOOL               autoSize   ,
                double             userSize[2],
                long             * hdl        ,
                BOOL               centerPos  ,
                int              * foreground ,
                int              * background ,
                BOOL               isboxed    ,
                BOOL               isline     ,
                BOOL               isfilled   ,
                sciTextAlignment   alignment   ) ;


void Objplot2d ( int       ptype     ,
                 char      logflags[],
                 double    x[]       ,
                 double    y[]       ,
                 int * n1        ,
                 int * n2        ,
                 int   style[]   ,
                 char      strflag[] ,
                 char      legend[]  ,
                 double    brect[]   ,
                 int   aaint[]   ,
                 BOOL      flagNax    ) ;

void Objgrayplot ( double    x[]      ,
                   double    y[]      ,
                   double    z[]      ,
                   int * n1       ,
                   int * n2       ,
                   char      strflag[],
                   double    brect[]  ,
                   int   aaint[]  ,
                   BOOL      flagNax   ) ;

void Objmatplot (double    z[]      ,
                 int * n1       ,
                 int * n2       ,
                 char      strflag[],
                 double    brect[]  ,
                 int   aaint[]  ,
                 BOOL      flagNax   ) ;

void Objmatplot1 ( double    z[],
                   int * n1 ,
                   int * n2 ,
                   double    xrect[] ) ;

void Objplot3d ( char    * fname ,
                 int * isfac ,
                 int * izcol ,
                 double    x[]   ,
                 double    y[]   ,
                 double    z[]   ,
                 double  * zcol  ,
                 int * m     ,
                 int * n     ,
                 double  * theta ,
                 double  * alpha ,
                 char    * legend,
                 int * iflag ,
                 double  * ebox  ,
                 int * m1    , /*Adding F.Leray 12.03.04 and 19.03.04*/
                 int * n1    ,
                 int * m2    ,
                 int * n2    ,
                 int * m3    ,
                 int * n3    ,
                 int * m3n   ,
                 int * n3n    ) ;

void Objdrawaxis ( char     dir    ,
                   char     tics   ,
                   double * x      ,
                   int    * nx     ,
                   double * y      ,
                   int    * ny     ,
                   char   * val[]  ,
                   int      subint ,
                   char   * format ,
                   int      font   ,
                   int      textcol,
                   int      ticscol,
                   char     flag   ,
                   int      seg    ,
                   int      nb_tics_labels ) ;

void Objnumb( char          * fname    ,
              unsigned long   fname_len,
              int         n        ,
              int         flag     ,
              double          x        ,
              double          y        ,
              double        * angle    ,
              double        * box       ) ;

void Objfec ( double    x[]        ,
              double    y[]        ,
              double    noeud[]    ,
              double  * fun        ,
              int * n          ,
              int * m          ,
              char      strflag[]  ,
              char      legend[]   ,
              double    brect[]    ,
              int   aaint[]    ,
              double    Zminmax[]  ,
              int   Colminmax[],
              int   ColOut[]   ,
              BOOL      WithMesh   ,
              BOOL      flagNax     ) ;

#endif /* _SCI_CALL_H_ */
