/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2006 - INRIA - Allan CORNET
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#ifndef _Included_javasci_SciStringArray
#define _Included_javasci_SciStringArray

#include "javasci_globals.h"
#ifdef __cplusplus
extern "C" {
#endif

/* private static native void Initialize(); */
JNIEXPORT void JNICALL Java_javasci_SciStringArray_Initialize (JNIEnv *env, jclass cl);

/*! private native int getRowFromScilab(String name); */
JNIEXPORT jint JNICALL Java_javasci_SciStringArray_getRowFromScilab(JNIEnv *, jobject, jstring);

/*! private native int getColFromScilab(String name); */
JNIEXPORT jint JNICALL Java_javasci_SciStringArray_getColFromScilab(JNIEnv *, jobject, jstring);

/* public native void Job(String job); */
JNIEXPORT void JNICALL Java_javasci_SciStringArray_Job (JNIEnv *, jobject, jstring);

/* public native String GetString(int indx, int indy); */
JNIEXPORT jstring JNICALL Java_javasci_SciStringArray_GetString(JNIEnv *env , jobject obj_this,jint indxarg, jint indyarg);

/* private native void SendString(String str,int indx, int indy); */
JNIEXPORT void JNICALL Java_javasci_SciStringArray_SendString(JNIEnv *env , jobject obj_this,jstring strarg,jint indxarg, jint indyarg);

#ifdef __cplusplus
}
#endif
#endif
/*****************************************************************************/
