
/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2007-2008 - INRIA - Sylvestre LEDRU <sylvestre.ledru@inria.fr>
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#ifndef __SCHUR_H__
#define __SCHUR_H__

#include "machine.h"
#include "linear_FTables.h"

/***********************************
 * Search Table for schsel
 ***********************************/

#define ARGS_schsel double *,double*
typedef int * (*schself)(ARGS_schsel);

/** 
 * function call : schsel  
 * @param alpha
 * @param beta
 * @return
 */
int *C2F(schsel)(double *alpha, double *beta);

/** 
 * fixes the function associated to name 
 * @param len
 * @param name
 * @param rep
 */
void C2F(setschsel)(int *len, char *name, int *rep);

/**************** schsel ***************/
extern void C2F(sb02mv)(ARGS_schsel);
extern void C2F(sb02mw)(ARGS_schsel);
 
FTAB FTab_schsel[] ={
{"sb02mv", (voidf)  C2F(sb02mv)},
{"sb02mw", (voidf)  C2F(sb02mw)},
{(char *) 0, (voidf) 0}};


/***********************************
* Search Table for gschur uses : gshsel
***********************************/
/**
 * @TODO : add comment
 *
 * @param alphar
 * @param alphai
 * @param beta
 * @return <ReturnValue>
 */
int *C2F(gshsel)(double *alphar, double *alphai, double *beta);

/**
 *  fixes the function associated to name 
 *
 * @param len   
 * @param name  
 * @param rep   
 */
void C2F(setgshsel)(int *len, char *name, int *rep);


/***********************************
* Search Table for schur uses : fschur
***********************************/

/**
 * @TODO : add comment
 *
 * @param alpha 
 * @param beta
 * @return <ReturnValue>
 */
int *C2F(gzhsel)(doublecmplx *alpha, doublecmplx *beta);

/**
 *  fixes the function associated to name 
 *
 * @param len   
 * @param name  
 * @param rep   
 */
void C2F(setgzhsel)(int *len, char *name, int *rep);

/***********************************
* Search Table for gschur uses : gzhsel
***********************************/
/**
 * @TODO : add comment
 *
 * @param alpha 
 * @param beta
 * @return <ReturnValue>
 */
int *C2F(gzhsel)(doublecmplx *alpha, doublecmplx *beta);

/**
 *  fixes the function associated to name 
 *
 * @param len   
 * @param name  
 * @param rep   
 */
void C2F(setgzhsel)(int *len, char *name, int *rep);


/***********************************
* Search Table for schur uses : zchsel
***********************************/
/**
 * @TODO : add comment
 *
 * @param alpha 
 * @return <ReturnValue>
 */
int *C2F(zchsel)(doublecmplx *alpha);

/**
 *  fixes the function associated to name 
 *
 * @param len   
 * @param name  
 * @param rep   
 */
 void C2F(setzchsel)(int *len, char *name, int *rep);

/***********************************
* Search Table for schur uses : fschur
***********************************/

/**
 * @TODO add comment
 *
 * @param lsize 
 * @param alpha 
 * @param beta  
 * @param s 
 * @param p 
 * @return <ReturnValue>
 */
int *C2F(fschur)(int *lsize, double *alpha, double *beta, double *s, double *p);

/**
 *  fixes the function associated to name 
 *
 * @param name  
 * @param rep   
 */
void C2F(setfschur)(char *name, int *rep);



/***********************************
 * Search Table for zchsel
 ***********************************/

#define ARGS_zchsel doublecmplx *
typedef int * (*zchself)(ARGS_zchsel);


/**************** zchsel ***************/
extern void C2F(zb02mv)(ARGS_zchsel);
extern void C2F(zb02mw)(ARGS_zchsel);
 
FTAB FTab_zchsel[] ={
{"zb02mv", (voidf)  C2F(zb02mv)},
{"zb02mw", (voidf)  C2F(zb02mw)},
{(char *) 0, (voidf) 0}};

#endif /* __SCHUR_H__ */
