// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL <pierre.marechal@inria.fr>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- JVM NOT MANDATORY -->

// unit tests for dec2bin function
// =============================================================================

// Test 0
// =============================================================================

if dec2bin(0) <> "0"  then pause,end
if dec2bin(1) <> "1"  then pause,end
if dec2bin(2) <> "10" then pause,end
if dec2bin(3) <> "11" then pause,end

if dec2bin(0)              <> "0"                                             then pause,end
if dec2bin(1)              <> "1"                                             then pause,end
if dec2bin(3)              <> "11"                                            then pause,end
if dec2bin(7)              <> "111"                                           then pause,end
if dec2bin(15)             <> "1111"                                          then pause,end
if dec2bin(255)            <> "11111111"                                      then pause,end
if dec2bin(26556445876512) <> "110000010011100100111100001011110000100100000" then pause,end
if dec2bin((2^32)-1)       <> "11111111111111111111111111111111"              then pause,end
if dec2bin(2^32)           <> "100000000000000000000000000000000"             then pause,end

if dec2bin(0,4)  <> "0000" then pause,end
if dec2bin(1,4)  <> "0001" then pause,end
if dec2bin(3,4)  <> "0011" then pause,end
if dec2bin(7,4)  <> "0111" then pause,end
if dec2bin(15,4) <> "1111" then pause,end

if dec2bin(0,8)  <> "00000000" then pause,end
if dec2bin(1,8)  <> "00000001" then pause,end
if dec2bin(3,8)  <> "00000011" then pause,end
if dec2bin(7,8)  <> "00000111" then pause,end
if dec2bin(15,8) <> "00001111" then pause,end

if dec2bin(0,16)  <> "0000000000000000" then pause,end
if dec2bin(1,16)  <> "0000000000000001" then pause,end
if dec2bin(3,16)  <> "0000000000000011" then pause,end
if dec2bin(7,16)  <> "0000000000000111" then pause,end
if dec2bin(15,16) <> "0000000000001111" then pause,end

// Test 1
// =============================================================================
A = [ 1 2 3 ; 89 23 65 ];
B = [ "0000001"  "0000010" "0000011" ; "1011001" "0010111" "1000001" ];
if dec2bin(A) <> B then pause,end

// Test 2
// =============================================================================
A = [ 1 2 3 ; 89 23 65 ];
B = [ "00000001"  "00000010" "00000011" ; "01011001" "00010111" "01000001" ];
if dec2bin(A,8) <> B then pause,end

// Test 3
// =============================================================================
A = [ 1 2 3 89 23 65 ];
B = [ "0000001"  "0000010" "0000011" "1011001" "0010111" "1000001" ];
if dec2bin(A) <> B then pause,end

// Test 4
// =============================================================================
A = [ 1 ; 2 ; 3 ; 89 ; 23 ; 65 ];
B = [ "0000001" ; "0000010" ; "0000011" ; "1011001" ; "0010111" ; "1000001" ];
if dec2bin(A) <> B then pause,end

// Test 5
// =============================================================================
A = [0 0 0 ; 0 0 0];
B = [ "0" "0" "0" ; "0" "0" "0" ];
if dec2bin(A) <> B then pause,end

// Test 6
// =============================================================================
A = [0 0 0 ; 0 0 0];
B = [ "000000" "000000" "000000" ; "000000" "000000" "000000" ];
if dec2bin(A,6) <> B then pause,end

// Test 7
// =============================================================================
A = [0 0 0 0 0 0];
B = [ "000000" "000000" "000000" "000000" "000000" "000000" ];
if dec2bin(A,6) <> B then pause,end

// Test 8
// =============================================================================
A = [0 ; 0 ; 0 ; 0 ; 0 ; 0];
B = [ "000000" ; "000000" ; "000000" ; "000000" ; "000000" ; "000000" ];
if dec2bin(A,6) <> B then pause,end

// Test 9
// =============================================================================
A = floor(rand(50,50) * 10^9);
if or(bin2dec(dec2bin(A)) <> A ) then pause,end


// Test 10
// =============================================================================

A = [ ..
	72382879; ..
	62585558; ..
	192060314; ..
	157382293; ..
	273842472; ..
	293995449; ..
	366110429; ..
	363811959; ..
	271401453; ..
	140508362; ..
	284776179; ..
	281454; ..
	369269139; ..
	253874005; ..
	223581659; ..
	252171935; ..
	149395915; ..
	175135204; ..
	115829971; ..
	370920879; ..
	16940954; ..
	211242109; ..
	70802958; ..
	306135248; ..
	193688853; ..
	319282761; ..
	140825068; ..
	65896534; ..
	149801847; ..
	137978582; ..
	210007643; ..
	222184726; ..
	200564141; ..
	29438453; ..
	6937514; ..
	101777108; ..
	323433902; ..
	418439; ..
	92959563; ..
	222205851; ..
	140926801; ..
	5106237; ..
	222487305; ..
	137566436; ..
	258980243; ..
	73439460; ..
	17108867; ..
	35746653; ..
	248574665; ..
	132938839; ..
	34038028; ..
	265515619; ..
	344180948; ..
	104840986; ..
	199021362; ..
	165240297; ..
	51494243; ..
	339846431; ..
	231136831; ..
	201296090; ..
	105195508; ..
	68514970; ..
	50851311; ..
	305759650; ..
	97953423; ..
	57788826; ..
	34907253; ..
	48757821; ..
	58207265; ..
	127866817; ..
	270963672; ..
	199134067; ..
	132973055; ..
	120821473; ..
	336700503; ..
	19323793; ..
	194260934; ..
	353809371; ..
	55070447; ..
	70206094; ..
	114118705; ..
	89108476; ..
	335721713; ..
	85670148; ..
	193949463; ..
	162113571; ..
	250910446; ..
	245443706; ..
	129330497; ..
	109417772; ..
	74110292; ..
	234526006; ..
	177932742; ..
	124961603; ..
	167656151; ..
	275886166; ..
	182750430; ..
	202563405; ..
	324643987; ..
	240957695; ..
];

B = [ ..
	"00100010100000111100110011111"; ..
	"00011101110101111101011010110"; ..
	"01011011100101001101110011010"; ..
	"01001011000010111011010010101"; ..
	"10000010100101000000100101000"; ..
	"10001100001100000001110111001"; ..
	"10101110100100110011011011101"; ..
	"10101101011110101010001110111"; ..
	"10000001011010100000111101101"; ..
	"01000010111111111110011001010"; ..
	"10000111110010101011011110011"; ..
	"00000000001000100101101101110"; ..
	"10110000000101001100110010011"; ..
	"01111001000011100111101010101"; ..
	"01101010100111001010111011011"; ..
	"01111000001111101011010011111"; ..
	"01000111001111001100111001011"; ..
	"01010011100000101100111100100"; ..
	"00110111001110110110011010011"; ..
	"10110000110111100110110101111"; ..
	"00001000000100111111110011010"; ..
	"01100100101110100110001111101"; ..
	"00100001110000101111000001110"; ..
	"10010001111110100000011010000"; ..
	"01011100010110111010100010101"; ..
	"10011000001111101111001001001"; ..
	"01000011001001101000111101100"; ..
	"00011111011011000000001010110"; ..
	"01000111011011100101101110111"; ..
	"01000001110010110001011010110"; ..
	"01100100001000111011001011011"; ..
	"01101001111100100010100010110"; ..
	"01011111101000101110110101101"; ..
	"00001110000010011000111110101"; ..
	"00000011010011101101110101010"; ..
	"00110000100001111111011010100"; ..
	"10011010001110011010110101110"; ..
	"00000000001100110001010000111"; ..
	"00101100010100111001101001011"; ..
	"01101001111101001011110011011"; ..
	"01000011001100101111101010001"; ..
	"00000010011011110101000111101"; ..
	"01101010000101110001100001001"; ..
	"01000001100110001100011100100"; ..
	"01111011011111011100110010011"; ..
	"00100011000001001100011100100"; ..
	"00001000001010000111110000011"; ..
	"00010001000010111001101011101"; ..
	"01110110100001111001011001001"; ..
	"00111111011000111110001010111"; ..
	"00010000001110110000100001100"; ..
	"01111110100110111001001100011"; ..
	"10100100000111100100011010100"; ..
	"00110001111111011111100011010"; ..
	"01011110111001101001100110010"; ..
	"01001110110010101110111101001"; ..
	"00011000100011011110101100011"; ..
	"10100010000011010010100011111"; ..
	"01101110001101101111000111111"; ..
	"01011111111111000100011011010"; ..
	"00110010001010010011111110100"; ..
	"00100000101010111010010011010"; ..
	"00011000001111110110111101111"; ..
	"10010001110011000010110100010"; ..
	"00101110101101010011010001111"; ..
	"00011011100011100100110011010"; ..
	"00010000101001010010001110101"; ..
	"00010111001111111110000111101"; ..
	"00011011110000010110000100001"; ..
	"00111100111110001011111000001"; ..
	"10000001001101001001111011000"; ..
	"01011110111101000101101110011"; ..
	"00111111011010000000111111111"; ..
	"00111001100111001011011100001"; ..
	"10100000100011010010001010111"; ..
	"00001001001101101101110010001"; ..
	"01011100101000010111111000110"; ..
	"10101000101101011001111011011"; ..
	"00011010010000100111011101111"; ..
	"00100001011110100001010001110"; ..
	"00110110011010101000000110001"; ..
	"00101010011111010111111111100"; ..
	"10100000000101011010011110001"; ..
	"00101000110110011100100000100"; ..
	"01011100011110110111100010111"; ..
	"01001101010011010100000100011"; ..
	"01110111101001001011011101110"; ..
	"01110101000010010110001111010"; ..
	"00111101101010110110101000001"; ..
	"00110100001011001010100101100"; ..
	"00100011010101101010101010100"; ..
	"01101111110101001010100110110"; ..
	"01010100110110000100111000110"; ..
	"00111011100101100001101000011"; ..
	"01001111111100011101011010111"; ..
	"10000011100011011000001010110"; ..
	"01010111001001000110011011110"; ..
	"01100000100101101111101001101"; ..
	"10011010110011010110010010011"; ..
	"01110010111001011100011111111"; ..
];

if or(dec2bin(A)<>B) then pause,end

// Test 11
// =============================================================================

A = [ ..
	4584808 364817334 236212556 301738566 ; ..
	152308246 160607770 4566259 180760301 ; ..
	117831956 24836512 55341867 24797893 ; ..
	351858890 318016166 284524814 305996335 ; ..
	204598915 226195135 89696399 168572870 ; ..
	47837611 83140003 317345941 205156554 ; ..
	200537634 131907940 123698314 294462329 ; ..
	16610047 248212243 4421794 21194855 ; ..
	240400073 240634350 322933422 20078815 ; ..
	28612616 327499681 200839116 146444573 ; ..
	352336193 256180984 171242467 331565579 ; ..
	201567645 83137777 264932409 33537056 ; ..
	309332912 354628808 202109926 357170523 ; ..
	65139306 146826363 189697572 265676941 ; ..
	278734303 313395886 187509766 295344351 ; ..
	188978625 191931560 316539206 56749194 ; ..
	59936406 266843124 76828009 88549023 ; ..
	221713301 277667126 234993597 201419989 ; ..
	161218605 33606559 160356064 362786251 ; ..
	116744336 52658968 23693802 53447743 ; ..
	34658271 225803728 37988761 99797578 ; ..
	586 227686334 365474520 278734890 ; ..
	168452716 180354782 201449737 357431341 ; ..
	372286343 145359439 41551031 59593245 ; ..
	39573058 118379040 148142268 261286359 ; ..
	23416661 10506361 90076844 184635267 ; ..
	44112921 250432908 174792013 160857257 ; ..
	303091877 198485815 214305001 337750149 ; ..
	51660039 252293763 64918223 51660626 ; ..
	107350593 57763239 330395517 275803309 ; ..
	238118021 159215749 260605146 237774859 ; ..
	304575188 302156177 297368104 344148246 ; ..
	47905712 72880868 232805100 71322374 ; ..
	83387230 322881945 255957641 127500151 ; ..
	200685348 58120150 288357408 131147720 ; ..
	256605965 130032905 96268365 308266005 ; ..
	9697164 161186588 359926631 117047757 ; ..
	218949827 317692643 20221561 84438343 ; ..
	104278887 280826707 322213203 36224571 ; ..
	210353379 246951802 7743312 258259092 ; ..
	319832671 240548413 329581467 30590396 ; ..
	190800854 212909603 158090547 18856697 ; ..
	271029754 73818451 150004418 155006215 ; ..
	203851356 246272783 90642715 213548521 ; ..
	34829867 77939841 330596278 253779694 ; ..
	23002980 350817840 338218038 127281868 ; ..
	259015042 287801736 163506440 96738917 ; ..
	162124034 171249753 354998010 109327200 ; ..
	39168662 311949972 139917597 229969516 ; ..
	152230071 298008145 248826214 50630320 ; ..
	371826596 26201128 205636535 203048448 ; ..
	272473912 296279251 43967464 307303779 ; ..
	1589588 1934238 188453969 24592569 ; ..
	352752078 154042502 151874438 239137616 ; ..
	69214734 315380878 335876534 231338769 ; ..
	114001126 318245040 340665969 153169788 ; ..
	257565507 107954062 10509799 37166074 ; ..
	33332702 259336014 87796395 32529794 ; ..
	285537143 293432931 235578243 185381550 ; ..
	217082677 279545708 120055825 218672265 ; ..
	281479946 308509794 243264834 261602520 ; ..
	89922792 22509768 128110631 159137527 ; ..
	337890646 91357661 17846791 79262267 ; ..
	36973196 358512761 232432056 294538703 ; ..
	93837318 242941856 331704778 127170021 ; ..
	129648366 46871668 159699816 42556004 ; ..
	340304599 22648554 227937554 184757772 ; ..
	302194262 347993380 30800532 211044704 ; ..
	283873670 274065367 100017719 1166958 ; ..
	296575135 228128351 160304485 261836277 ; ..
	319486012 178151277 341098545 356459209 ; ..
	164034533 200901096 278368408 257871852 ; ..
	71213448 237443681 12412369 200861814 ; ..
	284315350 172112185 243417818 251990444 ; ..
	194760740 98725868 64118711 124325497 ; ..
	74089743 94919244 335370201 357963413 ; ..
	368984612 62758416 359130372 292930243 ; ..
	290886768 146805352 182137016 237743275 ; ..
	324956630 150606056 221572980 116361659 ; ..
	351507153 127311883 1604007 50091096 ; ..
	364755564 14016376 250952911 276441410 ; ..
	186128562 121741224 155802350 8259797 ; ..
	220467093 219921062 132585294 294556836 ; ..
	314840307 95325991 279890745 311195414 ; ..
	158084408 266391612 231496153 76341671 ; ..
	40567460 41003665 314084947 365524090 ; ..
	191609721 163028422 109256245 170487370 ; ..
	290340305 110860252 220578466 282466365 ; ..
	124876628 98901872 186278271 311005191 ; ..
	220643097 342080621 319264988 68480685 ; ..
	189372178 79220778 363037522 131582980 ; ..
	174546770 270298762 70148890 332631178 ; ..
	164060870 301645044 36343345 204628331 ; ..
	342648709 350428292 197522917 161628926 ; ..
	140827209 306779162 332116296 58538010 ; ..
	45009909 180065258 341004377 169886538 ; ..
	278967131 154653143 108262225 126980724 ; ..
	124104259 54897708 195461409 313476438 ; ..
	134118487 185869427 72429914 308665257 ; ..
	83538685 142578805 268666931 247599555];

B = [ ..
	"00000010001011111010101101000" "10101101111101010101110110110" "01110000101000101000101001100" "10001111111000010101001000110" ; ..
	"01001000101000000101000010110" "01001100100101010111000011010" "00000010001011010110011110011" "01010110001100010111011101101" ; ..
	"00111000001011111100100010100" "00001011110101111100110100000" "00011010011000111001100101011" "00001011110100110001011000101" ; ..
	"10100111110001111000011001010" "10010111101001000101010100110" "10000111101011000000100001110" "10010001111010010001000101111" ; ..
	"01100001100011110111010000011" "01101011110110111011010111111" "00101010110001010100010001111" "01010000011000011011111000110" ; ..
	"00010110110011111000110101011" "00100111101001001110110100011" "10010111010100101000010010101" "01100001110100111000011001010" ; ..
	"01011111100111111011000100010" "00111110111001100000101100100" "00111010111110111110010001010" "10001100011010010001101111001" ; ..
	"00000111111010111001011111111" "01110110010110110101100010011" "00000010000110111100010100010" "00001010000110110100001100111" ; ..
	"01110010101000011011011001001" "01110010101111100100111101110" "10011001111111001001010101110" "00001001100100110000011011111" ; ..
	"00001101101001001100000001000" "10011100001010011111110100001" "01011111110001000111111001100" "01000101110101001000100011101" ; ..
	"10101000000000011100101000001" "01111010001010000001011111000" "01010001101001111001111100011" "10011110000110100101000001011" ; ..
	"01100000000111010110110011101" "00100111101001001010011110001" "01111110010101000110000111001" "00001111111111011110000100000" ; ..
	"10010011100000000101110110000" "10101001000110011010011001000" "01100000010111111001111100110" "10101010010011111110101011011" ; ..
	"00011111000011111001001101010" "01000110000000110010001111011" "01011010011101000111000100100" "01111110101011110100010001101" ; ..
	"10000100111010010010111011111" "10010101011100000101010101110" "01011001011010010110000000110" "10001100110101001100011011111" ; ..
	"01011010000111001010111000001" "01011011100001010010010101000" "10010110111100000000101000110" "00011011000011110110010001010" ; ..
	"00011100100101000111010010110" "01111111001111011001111110100" "00100100101000100110101101001" "00101010001110010011010011111" ; ..
	"01101001101110001001110010101" "10000100011001101110100110110" "01110000000011011011110111101" "01100000000010110110011010101" ; ..
	"01001100111000000000000101101" "00010000000001100101110011111" "01001100011101101011011100000" "10101100111111010110111001011" ; ..
	"00110111101010110000010010000" "00011001000111000001100011000" "00001011010011000100111101010" "00011001011111000110000111111" ; ..
	"00010000100001101011111011111" "01101011101010111110111010000" "00010010000111010100110011001" "00101111100101100101001001010" ; ..
	"00000000000000000001001001010" "01101100100100011011110111110" "10101110010001011001011011000" "10000100111010010100000101010" ; ..
	"01010000010100110001001101100" "01010101111111111111011011110" "01100000000011110000100001001" "10101010011011111100000101101" ; ..
	"10110001100001010001110000111" "01000101010100000001001001111" "00010011110100000010010110111" "00011100011010101001000011101" ; ..
	"00010010110111101011001000010" "00111000011100101001000100000" "01000110101000111100010111100" "01111100100101110100111010111" ; ..
	"00001011001010100111101010101" "00000101000000101000001111001" "00101010111100111011010101100" "01011000000010100111110000011" ; ..
	"00010101000010001110000011001" "01110111011010100110110001100" "01010011010110001110101001101" "01001100101100111110010101001" ; ..
	"10010000100001101000010100101" "01011110101001010011100110111" "01100110001100000100011101001" "10100001000011010100010000101" ; ..
	"00011000101000100010100000111" "01111000010011011001010000011" "00011110111101001001011001111" "00011000101000100011101010010" ; ..
	"00110011001100000101001000001" "00011011100010110010110100111" "10011101100010110111101111101" "10000011100000110110010101101" ; ..
	"01110001100010110010010000101" "01001011111010111000010000101" "01111100010001000010011011010" "01110001011000010100000001011" ; ..
	"10010001001110111001011010100" "10010000000101000100110010001" "10001101110010111101000101000" "10100100000110100100100010110" ; ..
	"00010110110101111101110110000" "00100010110000001001011100100" "01101111000000101001011101100" "00100010000000100101100000110" ; ..
	"00100111110000110001101011110" "10011001111101100100110011001" "01111010000011001101010001001" "00111100110010111111101110111" ; ..
	"01011111101100011011100100100" "00011011101101101011111010110" "10001001011111111110000100000" "00111110100010010011111001000" ; ..
	"01111010010110111111100001101" "00111110000000010010100001001" "00101101111001111000001001101" "10010010111111100010000010101" ; ..
	"00000100100111111011110001100" "01001100110111000001100011100" "10101011101000000101101100111" "00110111110100000000111001101" ; ..
	"01101000011001110100011000011" "10010111011111001101011100011" "00001001101001000111001111001" "00101000010000110110101000111" ; ..
	"00110001101110010101101100111" "10000101111010001001101010011" "10011001101001001010101010011" "00010001010001011111000111011" ; ..
	"01100100010011011110011100011" "01110101110000010111101111010" "00000011101100010011101010000" "01111011001001011100010010100" ; ..
	"10011000100000100001001011111" "01110010101100111101000111101" "10011101001010000001110011011" "00001110100101100010110111100" ; ..
	"01011010111110110001111010110" "01100101100001011111000100011" "01001011011000100010100110011" "00001000111111011101011111001" ; ..
	"10000001001111001010111111010" "00100011001100110000101010011" "01000111100001110001011000010" "01001001111010011010100000111" ; ..
	"01100001001101000011001011100" "01110101011011101001100001111" "00101011001110001100100011011" "01100101110100111110111101001" ; ..
	"00010000100110111011000101011" "00100101001010100010010000001" "10011101101000111111110110110" "01111001000000101111011101110" ; ..
	"00001010111101111111101100100" "10100111010010000111000110000" "10100001010001100110000110110" "00111100101100010101011001100" ; ..
	"01111011100000100000110000010" "10001001001111000000110001000" "01001101111101110100100001000" "00101110001000001111001100101" ; ..
	"01001101010011101000100000010" "01010001101010001000001011001" "10101001010001101011011111010" "00110100001000011001101100000" ; ..
	"00010010101011010101010010110" "10010100101111111101010010100" "01000010101101111100100011101" "01101101101010000111001101100" ; ..
	"01001000100101101100010110111" "10001110000110011111001010001" "01110110101001100100101100110" "00011000001001000111010110000" ; ..
	"10110001010011001111110100100" "00001100011111100110000101000" "01100010000011100001110110111" "01100000110100100011000000000" ; ..
	"10000001111011001111100111000" "10001101010001101110011010011" "00010100111101110001111101000" "10010010100010001010101100011" ; ..
	"00000000110000100000101010100" "00000000111011000001110011110" "01011001110111001010001010001" "00001011101110100000010111001" ; ..
	"10101000001101001000111001110" "01001001011101000000010000110" "01001000011010110101110000110" "01110010000001111001101010000" ; ..
	"00100001000000010001000001110" "10010110011000101010010001110" "10100000001010001000110110110" "01101110010011111001100010001" ; ..
	"00110110010111000010011100110" "10010111110000000100010110000" "10100010011100010011001110001" "01001001000010010111101111100" ; ..
	"01111010110100010001101000011" "00110011011110011111110001110" "00000101000000101110111100111" "00010001101110001101111111010" ; ..
	"00001111111001001110111011110" "01111011101010010011101001110" "00101001110111010101010101011" "00001111100000101110110000010" ; ..
	"10001000001001111001101110111" "10001011111010110111001100011" "01110000010101010001110000011" "01011000011001011001010101110" ; ..
	"01100111100000110101100110101" "10000101010011000011101101100" "00111001001111110100000010001" "01101000010001010110010001001" ; ..
	"10000110001110000101100001010" "10010011000110111110001100010" "01110011111111110110101000010" "01111100101111011110011011000" ; ..
	"00101010111000001110011101000" "00001010101110111100011001000" "00111101000101101000000100111" "01001011111000011111011110111" ; ..
	"10100001000111100110101010110" "00101011100100000000111011101" "00001000100000101001000000111" "00100101110010111001000111011" ; ..
	"00010001101000010101010001100" "10101010111100111100001111001" "01101110110101010000110111000" "10001100011100100110111001111" ; ..
	"00101100101111101100000000110" "01110011110101111111110100000" "10011110001010110100111001010" "00111100101000111010111100101" ; ..
	"00111101110100100011011101110" "00010110010110011010001110100" "01001100001001101001101101000" "00010100010010101101001100100" ; ..
	"10100010010001010001011010111" "00001010110011001011011101010" "01101100101100000110100010010" "01011000000110010111000001100" ; ..
	"10010000000110001111001010110" "10100101111011111010100100100" "00001110101011111101010010100" "01100100101000100100101100000" ; ..
	"10000111010111001000110000110" "10000010101011110011111010111" "00101111101100010011000110111" "00000000100011100111001101110" ; ..
	"10001101011010110000010011111" "01101100110001111011001011111" "01001100011100000110101100101" "01111100110110100110111110101" ; ..
	"10011000010101111100000111100" "01010100111100101111101101101" "10100010101001100000000110001" "10101001111110010001011001001" ; ..
	"01001110001101111011111100101" "01011111110011000000111101000" "10000100101111001000010011000" "01111010111101100111111101100" ; ..
	"00100001111101010000110001000" "01110001001110001101001100001" "00000101111010110010111010001" "01011111110001110100001110110" ; ..
	"10000111100100100111011010110" "01010010000100011100100111001" "01110100000100100001011011010" "01111000001010001000110101100" ; ..
	"01011100110111101000000100100" "00101111000100110111111101100" "00011110100100101111110110111" "00111011010010000111001111001" ; ..
	"00100011010101000010100001111" "00101101010000101101001001100" "10011111111010101011111011001" "10101010101100001011010010101" ; ..
	"10101111111100100001000100100" "00011101111011001111000010000" "10101011001111110010100000100" "10001011101011100001011000011" ; ..
	"10001010101101001010001110000" "01000110000000001001001101000" "01010110110110011000010111000" "01110001010111010110010101011" ; ..
	"10011010111100111000111010110" "01000111110100001000011101000" "01101001101001110111101110100" "00110111011111000100110111011" ; ..
	"10100111100111001001011010001" "00111100101101010000000001011" "00000000110000111100110100111" "00010111111000101010001011000" ; ..
	"10101101111011011101001101100" "00000110101011101111101111000" "01110111101010011110011001111" "10000011110100010100101000010" ; ..
	"01011000110000001100010110010" "00111010000011001111110101000" "01001010010010101101011101110" "00000011111100000100011010101" ; ..
	"01101001001000000111110010101" "01101000110111011101010100110" "00111111001110001011101001110" "10001100011101001010010100100" ; ..
	"10010110001000001010011110011" "00101101011101000111100100111" "10000101011101100101100111001" "10010100011000111011100010110" ; ..
	"01001011011000010110100111000" "01111111000001101000000111100" "01101110011000101100111011001" "00100100011001110000110100111" ; ..
	"00010011010110000001010100100" "00010011100011010101010010001" "10010101110001000111001010011" "10101110010010111010001111010" ; ..
	"01011011010111011101101111001" "01001101101111001110111000110" "00110100000110001111000110101" "01010001010010110111001001010" ; ..
	"10001010011100011110111010001" "00110100110111001011111011100" "01101001001011100001010100010" "10000110101100001100000111101" ; ..
	"00111011100010111011101010100" "00101111001010001111101110000" "01011000110100110000101111111" "10010100010011001000000000111" ; ..
	"01101001001101011111100011001" "10100011000111011110001101101" "10011000001111001100011011100" "00100000101001110111010101101" ; ..
	"01011010010011001011100010010" "00100101110001101000000101010" "10101101000111000001101010010" "00111110101111100110000000100" ; ..
	"01010011001110101111101010010" "10000000111000110111010001010" "00100001011100110001100011010" "10011110100111000110010001010" ; ..
	"01001110001110101111011000110" "10001111110101011110011110100" "00010001010101000111000110001" "01100001100100110000101101011" ; ..
	"10100011011000110011110000101" "10100111000110001110010000100" "01011110001011111010111100101" "01001101000100100001011111110" ; ..
	"01000011001001101101001001001" "10010010010010001010000011010" "10011110010111011000101001000" "00011011111010011100000011010" ; ..
	"00010101011101100101111110101" "01010101110111001001111101010" "10100010100110101000001011001" "01010001000000100001101001010" ; ..
	"10000101000001011001101011011" "01001001101111101000111010111" "00110011100111111001101010001" "00111100100011001001001110100" ; ..
	"00111011001011010111001000011" "00011010001011010110000101100" "01011101001101000000100100001" "10010101011110100010101010110" ; ..
	"00111111111100111110001010111" "01011000101000010010001110011" "00100010100010011000101011010" "10010011001011101101110101001" ; ..
	"00100111110101011001011111101" "01000011111111001010001110101" "10000000000111000100000110011" "01110110000100001000111000011"];

if or(dec2bin(A)<>B) then pause,end
