#include "Juigetfile.hxx"
/* Generated by GIWS (version 1.0.1) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_gui_filechooser {

// Returns the current env

JNIEnv * Juigetfile::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);
return curEnv;
}
// Destructor

Juigetfile::~Juigetfile() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors

Juigetfile::Juigetfile(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
std::cerr << "Could not get the Class " << this->className() <<  std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass) ;

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
std::cerr << "Could not create a Global Ref of " << this->className() <<  std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
std::cerr << "Could not retrieve the constructor of the class " << this->className() << " with the profile : " << construct << param << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
std::cerr << "Could not instantiate the object " << this->className() << " with the constructor : " << construct << param << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
std::cerr << "Could not create a new global ref of " << this->className() << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiduigetfileID=NULL; 
voiduigetfilejobjectArrayjobjectArrayID=NULL; 
voiduigetfilejobjectArrayjobjectArrayjstringID=NULL; 
voiduigetfilejobjectArrayjobjectArrayjstringjstringID=NULL; 
voiduigetfilejobjectArrayjobjectArrayjstringjstringjbooleanID=NULL; 
jstringgetTitleBoxID=NULL; 
jobjectArraygetMaskID=NULL; 
jobjectArraygetMaskDescriptionID=NULL; 
jstringgetInitialDirectoryID=NULL; 
jintgetSelectionSizeID=NULL; 
jobjectArraygetSelectionID=NULL; 
jobjectArraygetSelectionFileNamesID=NULL; 
jbooleanisMultipleSelectionID=NULL; 
jstringgetSelectionPathNameID=NULL; 
jintgetFilterIndexID=NULL; 
jstringgetMenuCallbackID=NULL; 
voiduigetdirID=NULL; 
voiduigetdirjstringID=NULL; 
voiduigetdirjstringjstringID=NULL; 


}

Juigetfile::Juigetfile(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass);
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {

std::cerr << "Could not create a Global Ref of " << this->className() <<  std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){

std::cerr << "Could not create a new global ref of " << this->className() << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
        }
        /* Methods ID set to NULL */
        voiduigetfileID=NULL; 
voiduigetfilejobjectArrayjobjectArrayID=NULL; 
voiduigetfilejobjectArrayjobjectArrayjstringID=NULL; 
voiduigetfilejobjectArrayjobjectArrayjstringjstringID=NULL; 
voiduigetfilejobjectArrayjobjectArrayjstringjstringjbooleanID=NULL; 
jstringgetTitleBoxID=NULL; 
jobjectArraygetMaskID=NULL; 
jobjectArraygetMaskDescriptionID=NULL; 
jstringgetInitialDirectoryID=NULL; 
jintgetSelectionSizeID=NULL; 
jobjectArraygetSelectionID=NULL; 
jobjectArraygetSelectionFileNamesID=NULL; 
jbooleanisMultipleSelectionID=NULL; 
jstringgetSelectionPathNameID=NULL; 
jintgetFilterIndexID=NULL; 
jstringgetMenuCallbackID=NULL; 
voiduigetdirID=NULL; 
voiduigetdirjstringID=NULL; 
voiduigetdirjstringjstringID=NULL; 


}

// Generic methods


void Juigetfile::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
std::cerr << "Fail to enter monitor." << std::endl;
exit(EXIT_FAILURE);
}
}


void Juigetfile::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
std::cerr << "Fail to exit monitor." << std::endl;
exit(EXIT_FAILURE);
}
}

// Method(s)

void Juigetfile::uigetfile (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetfileID = curEnv->GetStaticMethodID(cls, "uigetfile", "()V" ) ;
if (voiduigetfileID == NULL) {
std::cerr << "Could not access to the method " << "uigetfile" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voiduigetfileID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void Juigetfile::uigetfile (JavaVM * jvm_, char ** mask, int maskSize, char ** description, int descriptionSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetfilejobjectArrayjobjectArrayID = curEnv->GetStaticMethodID(cls, "uigetfile", "([Ljava/lang/String;[Ljava/lang/String;)V" ) ;
if (voiduigetfilejobjectArrayjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "uigetfile" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray mask_ = curEnv->NewObjectArray( maskSize, stringArrayClass, NULL);
if (mask_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < maskSize; i++)
{
jstring TempString = curEnv->NewStringUTF( mask[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( mask_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}

// create java array of strings.
jobjectArray description_ = curEnv->NewObjectArray( descriptionSize, stringArrayClass, NULL);
if (description_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < descriptionSize; i++)
{
jstring TempString = curEnv->NewStringUTF( description[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( description_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voiduigetfilejobjectArrayjobjectArrayID ,mask_, description_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(mask_);
curEnv->DeleteLocalRef(description_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void Juigetfile::uigetfile (JavaVM * jvm_, char ** mask, int maskSize, char ** description, int descriptionSize, char * initialDirectory){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetfilejobjectArrayjobjectArrayjstringID = curEnv->GetStaticMethodID(cls, "uigetfile", "([Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voiduigetfilejobjectArrayjobjectArrayjstringID == NULL) {
std::cerr << "Could not access to the method " << "uigetfile" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray mask_ = curEnv->NewObjectArray( maskSize, stringArrayClass, NULL);
if (mask_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < maskSize; i++)
{
jstring TempString = curEnv->NewStringUTF( mask[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( mask_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}

// create java array of strings.
jobjectArray description_ = curEnv->NewObjectArray( descriptionSize, stringArrayClass, NULL);
if (description_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < descriptionSize; i++)
{
jstring TempString = curEnv->NewStringUTF( description[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( description_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring initialDirectory_ = curEnv->NewStringUTF( initialDirectory );

                         curEnv->CallStaticVoidMethod(cls, voiduigetfilejobjectArrayjobjectArrayjstringID ,mask_, description_, initialDirectory_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(mask_);
curEnv->DeleteLocalRef(description_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void Juigetfile::uigetfile (JavaVM * jvm_, char ** mask, int maskSize, char ** description, int descriptionSize, char * initialDirectory, char * boxtTitle){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetfilejobjectArrayjobjectArrayjstringjstringID = curEnv->GetStaticMethodID(cls, "uigetfile", "([Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voiduigetfilejobjectArrayjobjectArrayjstringjstringID == NULL) {
std::cerr << "Could not access to the method " << "uigetfile" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray mask_ = curEnv->NewObjectArray( maskSize, stringArrayClass, NULL);
if (mask_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < maskSize; i++)
{
jstring TempString = curEnv->NewStringUTF( mask[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( mask_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}

// create java array of strings.
jobjectArray description_ = curEnv->NewObjectArray( descriptionSize, stringArrayClass, NULL);
if (description_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < descriptionSize; i++)
{
jstring TempString = curEnv->NewStringUTF( description[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( description_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring initialDirectory_ = curEnv->NewStringUTF( initialDirectory );

jstring boxtTitle_ = curEnv->NewStringUTF( boxtTitle );

                         curEnv->CallStaticVoidMethod(cls, voiduigetfilejobjectArrayjobjectArrayjstringjstringID ,mask_, description_, initialDirectory_, boxtTitle_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(mask_);
curEnv->DeleteLocalRef(description_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void Juigetfile::uigetfile (JavaVM * jvm_, char ** mask, int maskSize, char ** description, int descriptionSize, char * initialDirectory, char * boxtTitle, bool multipleSelection){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetfilejobjectArrayjobjectArrayjstringjstringjbooleanID = curEnv->GetStaticMethodID(cls, "uigetfile", "([Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V" ) ;
if (voiduigetfilejobjectArrayjobjectArrayjstringjstringjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "uigetfile" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray mask_ = curEnv->NewObjectArray( maskSize, stringArrayClass, NULL);
if (mask_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < maskSize; i++)
{
jstring TempString = curEnv->NewStringUTF( mask[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( mask_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}

// create java array of strings.
jobjectArray description_ = curEnv->NewObjectArray( descriptionSize, stringArrayClass, NULL);
if (description_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < descriptionSize; i++)
{
jstring TempString = curEnv->NewStringUTF( description[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( description_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring initialDirectory_ = curEnv->NewStringUTF( initialDirectory );

jstring boxtTitle_ = curEnv->NewStringUTF( boxtTitle );

jboolean multipleSelection_ = ((bool) multipleSelection ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voiduigetfilejobjectArrayjobjectArrayjstringjstringjbooleanID ,mask_, description_, initialDirectory_, boxtTitle_, multipleSelection_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(mask_);
curEnv->DeleteLocalRef(description_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char * Juigetfile::getTitleBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetTitleBoxID = curEnv->GetStaticMethodID(cls, "getTitleBox", "()Ljava/lang/String;" ) ;
if (jstringgetTitleBoxID == NULL) {
std::cerr << "Could not access to the method " << "getTitleBox" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetTitleBoxID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

char ** Juigetfile::getMask (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArraygetMaskID = curEnv->GetStaticMethodID(cls, "getMask", "()[Ljava/lang/String;" ) ;
if (jobjectArraygetMaskID == NULL) {
std::cerr << "Could not access to the method " << "getMask" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod(cls, jobjectArraygetMaskID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

curEnv->DeleteLocalRef(res);
return arrayOfString;

}

char ** Juigetfile::getMaskDescription (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArraygetMaskDescriptionID = curEnv->GetStaticMethodID(cls, "getMaskDescription", "()[Ljava/lang/String;" ) ;
if (jobjectArraygetMaskDescriptionID == NULL) {
std::cerr << "Could not access to the method " << "getMaskDescription" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod(cls, jobjectArraygetMaskDescriptionID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

curEnv->DeleteLocalRef(res);
return arrayOfString;

}

char * Juigetfile::getInitialDirectory (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetInitialDirectoryID = curEnv->GetStaticMethodID(cls, "getInitialDirectory", "()Ljava/lang/String;" ) ;
if (jstringgetInitialDirectoryID == NULL) {
std::cerr << "Could not access to the method " << "getInitialDirectory" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetInitialDirectoryID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

int Juigetfile::getSelectionSize (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetSelectionSizeID = curEnv->GetStaticMethodID(cls, "getSelectionSize", "()I" ) ;
if (jintgetSelectionSizeID == NULL) {
std::cerr << "Could not access to the method " << "getSelectionSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetSelectionSizeID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

char ** Juigetfile::getSelection (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArraygetSelectionID = curEnv->GetStaticMethodID(cls, "getSelection", "()[Ljava/lang/String;" ) ;
if (jobjectArraygetSelectionID == NULL) {
std::cerr << "Could not access to the method " << "getSelection" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod(cls, jobjectArraygetSelectionID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

curEnv->DeleteLocalRef(res);
return arrayOfString;

}

char ** Juigetfile::getSelectionFileNames (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArraygetSelectionFileNamesID = curEnv->GetStaticMethodID(cls, "getSelectionFileNames", "()[Ljava/lang/String;" ) ;
if (jobjectArraygetSelectionFileNamesID == NULL) {
std::cerr << "Could not access to the method " << "getSelectionFileNames" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod(cls, jobjectArraygetSelectionFileNamesID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

curEnv->DeleteLocalRef(res);
return arrayOfString;

}

bool Juigetfile::isMultipleSelection (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisMultipleSelectionID = curEnv->GetStaticMethodID(cls, "isMultipleSelection", "()Z" ) ;
if (jbooleanisMultipleSelectionID == NULL) {
std::cerr << "Could not access to the method " << "isMultipleSelection" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisMultipleSelectionID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

char * Juigetfile::getSelectionPathName (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetSelectionPathNameID = curEnv->GetStaticMethodID(cls, "getSelectionPathName", "()Ljava/lang/String;" ) ;
if (jstringgetSelectionPathNameID == NULL) {
std::cerr << "Could not access to the method " << "getSelectionPathName" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetSelectionPathNameID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

int Juigetfile::getFilterIndex (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFilterIndexID = curEnv->GetStaticMethodID(cls, "getFilterIndex", "()I" ) ;
if (jintgetFilterIndexID == NULL) {
std::cerr << "Could not access to the method " << "getFilterIndex" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetFilterIndexID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

char * Juigetfile::getMenuCallback (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetMenuCallbackID = curEnv->GetStaticMethodID(cls, "getMenuCallback", "()Ljava/lang/String;" ) ;
if (jstringgetMenuCallbackID == NULL) {
std::cerr << "Could not access to the method " << "getMenuCallback" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetMenuCallbackID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

void Juigetfile::uigetdir (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetdirID = curEnv->GetStaticMethodID(cls, "uigetdir", "()V" ) ;
if (voiduigetdirID == NULL) {
std::cerr << "Could not access to the method " << "uigetdir" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voiduigetdirID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void Juigetfile::uigetdir (JavaVM * jvm_, char * initialDirectory){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetdirjstringID = curEnv->GetStaticMethodID(cls, "uigetdir", "(Ljava/lang/String;)V" ) ;
if (voiduigetdirjstringID == NULL) {
std::cerr << "Could not access to the method " << "uigetdir" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring initialDirectory_ = curEnv->NewStringUTF( initialDirectory );

                         curEnv->CallStaticVoidMethod(cls, voiduigetdirjstringID ,initialDirectory_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void Juigetfile::uigetdir (JavaVM * jvm_, char * initialDirectory, char * title){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduigetdirjstringjstringID = curEnv->GetStaticMethodID(cls, "uigetdir", "(Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voiduigetdirjstringjstringID == NULL) {
std::cerr << "Could not access to the method " << "uigetdir" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring initialDirectory_ = curEnv->NewStringUTF( initialDirectory );

jstring title_ = curEnv->NewStringUTF( title );

                         curEnv->CallStaticVoidMethod(cls, voiduigetdirjstringjstringID ,initialDirectory_, title_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

}
