#include "Jxgetmouse.hxx"
/* Generated by GIWS (version 1.0.1) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_gui_events {

// Returns the current env

JNIEnv * Jxgetmouse::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);
return curEnv;
}
// Destructor

Jxgetmouse::~Jxgetmouse() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors

Jxgetmouse::Jxgetmouse(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass) ;

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidxgetmouseID=NULL; 
voidxgetmousejbooleanjbooleanID=NULL; 
jintgetMouseButtonNumberID=NULL; 
jintgetWindowsIDID=NULL; 
jdoublegetXCoordinateID=NULL; 
jdoublegetYCoordinateID=NULL; 


}

Jxgetmouse::Jxgetmouse(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass);
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidxgetmouseID=NULL; 
voidxgetmousejbooleanjbooleanID=NULL; 
jintgetMouseButtonNumberID=NULL; 
jintgetWindowsIDID=NULL; 
jdoublegetXCoordinateID=NULL; 
jdoublegetYCoordinateID=NULL; 


}

// Generic methods


void Jxgetmouse::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
std::cerr << "Fail to enter monitor." << std::endl;
exit(EXIT_FAILURE);
}
}


void Jxgetmouse::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
std::cerr << "Fail to exit monitor." << std::endl;
exit(EXIT_FAILURE);
}
}

// Method(s)

void Jxgetmouse::xgetmouse (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxgetmouseID = curEnv->GetStaticMethodID(cls, "xgetmouse", "()V" ) ;
if (voidxgetmouseID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xgetmouse");
}

                         curEnv->CallStaticVoidMethod(cls, voidxgetmouseID );
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Jxgetmouse::xgetmouse (JavaVM * jvm_, bool withMotion, bool withRelease){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxgetmousejbooleanjbooleanID = curEnv->GetStaticMethodID(cls, "xgetmouse", "(ZZ)V" ) ;
if (voidxgetmousejbooleanjbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xgetmouse");
}

jboolean withMotion_ = ((bool) withMotion ? JNI_TRUE : JNI_FALSE);

jboolean withRelease_ = ((bool) withRelease ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidxgetmousejbooleanjbooleanID ,withMotion_, withRelease_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int Jxgetmouse::getMouseButtonNumber (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMouseButtonNumberID = curEnv->GetStaticMethodID(cls, "getMouseButtonNumber", "()I" ) ;
if (jintgetMouseButtonNumberID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMouseButtonNumber");
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetMouseButtonNumberID );
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int Jxgetmouse::getWindowsID (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetWindowsIDID = curEnv->GetStaticMethodID(cls, "getWindowsID", "()I" ) ;
if (jintgetWindowsIDID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getWindowsID");
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetWindowsIDID );
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

double Jxgetmouse::getXCoordinate (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetXCoordinateID = curEnv->GetStaticMethodID(cls, "getXCoordinate", "()D" ) ;
if (jdoublegetXCoordinateID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getXCoordinate");
}

                        jdouble res =  (jdouble) curEnv->CallStaticDoubleMethod(cls, jdoublegetXCoordinateID );
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

double Jxgetmouse::getYCoordinate (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetYCoordinateID = curEnv->GetStaticMethodID(cls, "getYCoordinate", "()D" ) ;
if (jdoublegetYCoordinateID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getYCoordinate");
}

                        jdouble res =  (jdouble) curEnv->CallStaticDoubleMethod(cls, jdoublegetYCoordinateID );
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

}
