#include "XlFontManager.hxx"
/* Generated by GIWS (version 1.0.1) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_renderer_utils_textRendering {

// Returns the current env

JNIEnv * XlFontManager::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);
return curEnv;
}
// Destructor

XlFontManager::~XlFontManager() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors

XlFontManager::XlFontManager(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass) ;

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jobjectArraygetInstalledFontsNameID=NULL; 
jintgetSizeInstalledFontsNameID=NULL; 
jintgetSizeAvailableFontsNameID=NULL; 
jobjectArraygetAvailableFontsNameID=NULL; 
jbooleanisAvailableFontNamejstringID=NULL; 
jintaddFontjstringID=NULL; 
jintchangeFontjintjstringID=NULL; 
jintchangeFontWithPropertyjintjstringjbooleanjbooleanID=NULL; 
voidresetXlFontManagerID=NULL; 
jintaddFontFromFilenamejstringID=NULL; 
jintchangeFontFromFilenamejintjstringID=NULL; 


}

XlFontManager::XlFontManager(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass);
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jobjectArraygetInstalledFontsNameID=NULL; 
jintgetSizeInstalledFontsNameID=NULL; 
jintgetSizeAvailableFontsNameID=NULL; 
jobjectArraygetAvailableFontsNameID=NULL; 
jbooleanisAvailableFontNamejstringID=NULL; 
jintaddFontjstringID=NULL; 
jintchangeFontjintjstringID=NULL; 
jintchangeFontWithPropertyjintjstringjbooleanjbooleanID=NULL; 
voidresetXlFontManagerID=NULL; 
jintaddFontFromFilenamejstringID=NULL; 
jintchangeFontFromFilenamejintjstringID=NULL; 


}

// Generic methods


void XlFontManager::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
std::cerr << "Fail to enter monitor." << std::endl;
exit(EXIT_FAILURE);
}
}


void XlFontManager::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
std::cerr << "Fail to exit monitor." << std::endl;
exit(EXIT_FAILURE);
}
}

// Method(s)

char ** XlFontManager::getInstalledFontsName (){

JNIEnv * curEnv = getCurrentEnv();

if (jobjectArraygetInstalledFontsNameID==NULL) { /* Use the cache Luke */ jobjectArraygetInstalledFontsNameID = curEnv->GetMethodID(this->instanceClass, "getInstalledFontsName", "()[Ljava/lang/String;" ) ;
if (jobjectArraygetInstalledFontsNameID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getInstalledFontsName");
}
}
                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod( this->instance, jobjectArraygetInstalledFontsNameID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;

}

int XlFontManager::getSizeInstalledFontsName (){

JNIEnv * curEnv = getCurrentEnv();

if (jintgetSizeInstalledFontsNameID==NULL) { /* Use the cache Luke */ jintgetSizeInstalledFontsNameID = curEnv->GetMethodID(this->instanceClass, "getSizeInstalledFontsName", "()I" ) ;
if (jintgetSizeInstalledFontsNameID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getSizeInstalledFontsName");
}
}
                        jint res =  (jint) curEnv->CallIntMethod( this->instance, jintgetSizeInstalledFontsNameID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int XlFontManager::getSizeAvailableFontsName (){

JNIEnv * curEnv = getCurrentEnv();

if (jintgetSizeAvailableFontsNameID==NULL) { /* Use the cache Luke */ jintgetSizeAvailableFontsNameID = curEnv->GetMethodID(this->instanceClass, "getSizeAvailableFontsName", "()I" ) ;
if (jintgetSizeAvailableFontsNameID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getSizeAvailableFontsName");
}
}
                        jint res =  (jint) curEnv->CallIntMethod( this->instance, jintgetSizeAvailableFontsNameID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char ** XlFontManager::getAvailableFontsName (){

JNIEnv * curEnv = getCurrentEnv();

if (jobjectArraygetAvailableFontsNameID==NULL) { /* Use the cache Luke */ jobjectArraygetAvailableFontsNameID = curEnv->GetMethodID(this->instanceClass, "getAvailableFontsName", "()[Ljava/lang/String;" ) ;
if (jobjectArraygetAvailableFontsNameID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getAvailableFontsName");
}
}
                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod( this->instance, jobjectArraygetAvailableFontsNameID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;

}

bool XlFontManager::isAvailableFontName (char * fontname){

JNIEnv * curEnv = getCurrentEnv();

if (jbooleanisAvailableFontNamejstringID==NULL) { /* Use the cache Luke */ jbooleanisAvailableFontNamejstringID = curEnv->GetMethodID(this->instanceClass, "isAvailableFontName", "(Ljava/lang/String;)Z" ) ;
if (jbooleanisAvailableFontNamejstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isAvailableFontName");
}
}
jstring fontname_ = curEnv->NewStringUTF( fontname );

                        jboolean res =  (jboolean) curEnv->CallBooleanMethod( this->instance, jbooleanisAvailableFontNamejstringID ,fontname_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int XlFontManager::addFont (char * fontName){

JNIEnv * curEnv = getCurrentEnv();

if (jintaddFontjstringID==NULL) { /* Use the cache Luke */ jintaddFontjstringID = curEnv->GetMethodID(this->instanceClass, "addFont", "(Ljava/lang/String;)I" ) ;
if (jintaddFontjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "addFont");
}
}
jstring fontName_ = curEnv->NewStringUTF( fontName );

                        jint res =  (jint) curEnv->CallIntMethod( this->instance, jintaddFontjstringID ,fontName_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int XlFontManager::changeFont (int index, char * fontName){

JNIEnv * curEnv = getCurrentEnv();

if (jintchangeFontjintjstringID==NULL) { /* Use the cache Luke */ jintchangeFontjintjstringID = curEnv->GetMethodID(this->instanceClass, "changeFont", "(ILjava/lang/String;)I" ) ;
if (jintchangeFontjintjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "changeFont");
}
}
jstring fontName_ = curEnv->NewStringUTF( fontName );

                        jint res =  (jint) curEnv->CallIntMethod( this->instance, jintchangeFontjintjstringID ,index, fontName_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int XlFontManager::changeFontWithProperty (int index, char * fontName, bool isBold, bool isItalic){

JNIEnv * curEnv = getCurrentEnv();

if (jintchangeFontWithPropertyjintjstringjbooleanjbooleanID==NULL) { /* Use the cache Luke */ jintchangeFontWithPropertyjintjstringjbooleanjbooleanID = curEnv->GetMethodID(this->instanceClass, "changeFontWithProperty", "(ILjava/lang/String;ZZ)I" ) ;
if (jintchangeFontWithPropertyjintjstringjbooleanjbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "changeFontWithProperty");
}
}
jstring fontName_ = curEnv->NewStringUTF( fontName );

jboolean isBold_ = ((bool) isBold ? JNI_TRUE : JNI_FALSE);

jboolean isItalic_ = ((bool) isItalic ? JNI_TRUE : JNI_FALSE);

                        jint res =  (jint) curEnv->CallIntMethod( this->instance, jintchangeFontWithPropertyjintjstringjbooleanjbooleanID ,index, fontName_, isBold_, isItalic_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void XlFontManager::resetXlFontManager (){

JNIEnv * curEnv = getCurrentEnv();

if (voidresetXlFontManagerID==NULL) { /* Use the cache Luke */ voidresetXlFontManagerID = curEnv->GetMethodID(this->instanceClass, "resetXlFontManager", "()V" ) ;
if (voidresetXlFontManagerID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "resetXlFontManager");
}
}
                         curEnv->CallVoidMethod( this->instance, voidresetXlFontManagerID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int XlFontManager::addFontFromFilename (char * FontFilename){

JNIEnv * curEnv = getCurrentEnv();

if (jintaddFontFromFilenamejstringID==NULL) { /* Use the cache Luke */ jintaddFontFromFilenamejstringID = curEnv->GetMethodID(this->instanceClass, "addFontFromFilename", "(Ljava/lang/String;)I" ) ;
if (jintaddFontFromFilenamejstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "addFontFromFilename");
}
}
jstring FontFilename_ = curEnv->NewStringUTF( FontFilename );

                        jint res =  (jint) curEnv->CallIntMethod( this->instance, jintaddFontFromFilenamejstringID ,FontFilename_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int XlFontManager::changeFontFromFilename (int index, char * FontFilename){

JNIEnv * curEnv = getCurrentEnv();

if (jintchangeFontFromFilenamejintjstringID==NULL) { /* Use the cache Luke */ jintchangeFontFromFilenamejintjstringID = curEnv->GetMethodID(this->instanceClass, "changeFontFromFilename", "(ILjava/lang/String;)I" ) ;
if (jintchangeFontFromFilenamejintjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "changeFontFromFilename");
}
}
jstring FontFilename_ = curEnv->NewStringUTF( FontFilename );

                        jint res =  (jint) curEnv->CallIntMethod( this->instance, jintchangeFontFromFilenamejintjstringID ,index, FontFilename_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

}
