/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009 - DIGITEO - Vincent COUVERT
 * Copyright (C) 2010 - DIGITEO - Clément DAVID
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

package org.scilab.modules.xcos.actions;

import java.awt.event.ActionEvent;
import java.util.Map;

import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.VertexSelectionDependantAction;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;

import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;

/**
 * Block shadow handling
 */
public class ShowHideShadowAction extends VertexSelectionDependantAction {
	public static final String NAME = XcosMessages.SHOWHIDE_SHADOW;
	public static final String SMALL_ICON = "";
	public static final int MNEMONIC_KEY = 0;
	public static final int ACCELERATOR_KEY = 0;

	/**
	 * Constructor
	 * @param scilabGraph associated diagram
	 */
	public ShowHideShadowAction(ScilabGraph scilabGraph) {
		super(scilabGraph);
	}

	/**
	 * Menu added to the menubar
	 * @param scilabGraph associated diagram
	 * @return the menu
	 */
	public static MenuItem createMenu(ScilabGraph scilabGraph) {
		return createMenu(scilabGraph, ShowHideShadowAction.class);
	}
	
	/**
	 * @param e parameter
	 * @see org.scilab.modules.graph.actions.base.DefaultAction#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
	    if (((XcosDiagram) getGraph(null)).getSelectionCells().length != 0) {
		
		Object[] allCells = ((XcosDiagram) getGraph(null)).getSelectionCells();
		
		for (int i = 0; i < allCells.length; ++i) {
		    if (allCells[i] instanceof BasicBlock) {
			//((BasicBlock) allCells[i])
				mxCellState state = getGraph(null).getView().getState(allCells[i]);
				Map<String, Object> style;
				if (state != null) {
					style = state.getStyle();
				} else {
					style = getGraph(null).getCellStyle(allCells[i]);
				}

				if (style != null) {
					String value = Boolean.toString(mxUtils.isTrue(style, mxConstants.STYLE_SHADOW, false));
					getGraph(null).setCellStyles(mxConstants.STYLE_SHADOW, value, new Object[] {allCells[i]});
				}
		    }
		}
	    }
	}

}
