#ifndef SCIMBRIDGEAGENTCLIENTPEERPROTECTED_H_
#define SCIMBRIDGEAGENTCLIENTPEERPROTECTED_H_

#define Uses_SCIM_HOTKEY

#include <scim.h>

#include "scim-bridge.h"
#include "scim-bridge-agent-exception.h"

class ScimBridgeAgentClientListener;
class ScimBridgeAgentIMContext;

class ScimBridgeAgentClientPeerProtected
{

    public:

        virtual  void connection_closed () = 0;

        virtual const scim::KeyboardLayout &get_keyboard_layout () = 0;

        virtual ScimBridgeAgentIMContext *alloc_imcontext () = 0;
        virtual void free_imcontext (ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException) = 0;
        virtual void reset_imcontext (ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException) = 0;
        virtual void focus_changed (ScimBridgeAgentIMContext &ic, bool focus_in) throw (ScimBridgeAgentException) = 0;
        virtual bool keyevent_occured (ScimBridgeAgentIMContext &ic, const scim::KeyEvent &keyevent) throw (ScimBridgeAgentException) = 0;
        virtual void cursor_location_changed (ScimBridgeAgentIMContext &ic, int cursor_x, int cursor_y) throw (ScimBridgeAgentException) = 0;

    protected:

        ScimBridgeAgentClientPeerProtected () {}
        virtual ~ScimBridgeAgentClientPeerProtected () {};

};
#endif                                            /*SCIMBRIDGEAGENTCLIENTPEERPROTECTED_H_*/
