#include <assert.h>

#include "scim-bridge-agent-imcontext.h"
#include "scim-bridge-agent-kernel.h"
#include "scim-bridge-imcontext-manager.h"

using namespace scim;

/* Class members */
bool ScimBridgeAgentIMContext::on_the_spot = true;
bool ScimBridgeAgentIMContext::imengine_shared = false;

IMEngineInstancePointer ScimBridgeAgentIMContext::shared_imengine = NULL;

bool ScimBridgeAgentIMContext::is_on_the_spot_enabled ()
{
    return on_the_spot;
}


void ScimBridgeAgentIMContext::set_on_the_spot_enabled (bool enabled)
{
    on_the_spot = enabled;
}


bool ScimBridgeAgentIMContext::is_imengine_shared ()
{
    return imengine_shared;
}


void ScimBridgeAgentIMContext::set_imengine_shared (bool shared)
{
    imengine_shared = shared;
}


IMEngineInstancePointer ScimBridgeAgentIMContext::get_shared_imengine ()
{
    return shared_imengine;
}


void ScimBridgeAgentIMContext::set_shared_imengine (IMEngineInstancePointer new_imengine)
{
    shared_imengine = new_imengine;
}


void ScimBridgeAgentIMContext::release_shared_imengine ()
{
    set_shared_imengine (NULL);
}


/* Object members */
ScimBridgeAgentIMContext::ScimBridgeAgentIMContext (): preedit_shown (false), client_peer (NULL)
{
    static bool static_initialized = false;
    if (!static_initialized) {
        static_initialized = true;
        scim_bridge_initialize_imcontext_manager ();
    }

    status = false;

    scim_bridge_add_imcontext (this);
}


ScimBridgeAgentIMContext::~ScimBridgeAgentIMContext ()
{
    free ();
}


void ScimBridgeAgentIMContext::free ()
{
    if (!imengine) {
        imengine->reset ();
        imengine = NULL;
    }

    client_peer = NULL;

    scim_bridge_remove_imcontext (this);
}


ScimBridgeAgentIMContext *ScimBridgeAgentIMContext::find (ScimBridgeIMContextID id)
{
    ScimBridgeAgentIMContext *imcontext = static_cast<ScimBridgeAgentIMContext*> (scim_bridge_find_imcontext (id));
    assert (imcontext != NULL && imcontext->get_id () == id);
    return imcontext;
}


void ScimBridgeAgentIMContext::reset_preedit ()
{
    preedit_string.clear ();
    preedit_caret = 0;
    preedit_shown = false;
    preedit_attribute_list.clear ();
}


void ScimBridgeAgentIMContext::set_preedit_caret (int caret_pos)
{
    preedit_caret = caret_pos;
}


const int ScimBridgeAgentIMContext::get_preedit_caret () const
{
    return preedit_caret;
}


const bool ScimBridgeAgentIMContext::is_on () const
{
    return status;
}


void ScimBridgeAgentIMContext::turn_on ()
{
    status = true;
}


void ScimBridgeAgentIMContext::turn_off ()
{
    status = false;
}


const ScimBridgeIMContextID ScimBridgeAgentIMContext::get_id () const
{
    return parent.id;
}


const ScimBridgeIMContextID ScimBridgeAgentIMContext::get_opponent_id () const
{
    return parent.opponent_id;
}


void ScimBridgeAgentIMContext::set_opponent_id (ScimBridgeIMContextID new_opponent_id)
{
    parent.opponent_id = new_opponent_id;
}


const IMEngineInstancePointer ScimBridgeAgentIMContext::get_imengine () const
{
    return imengine;
}


void ScimBridgeAgentIMContext::set_imengine (scim::IMEngineInstancePointer new_imengine)
{
    imengine = new_imengine;
    update_capabilities ();

    imengine->set_frontend_data (static_cast <void*> (this));

    if (imengine_shared) {
        set_shared_imengine (new_imengine);
    } else {
        set_shared_imengine (NULL);
    }
}


const WideString &ScimBridgeAgentIMContext::get_preedit_string ()
{
    return preedit_string;
}


void ScimBridgeAgentIMContext::set_preedit_string (const WideString &wstr)
{
    preedit_string = wstr;
}


const AttributeList &ScimBridgeAgentIMContext::get_preedit_attribute_list ()
{
    return preedit_attribute_list;
}


void ScimBridgeAgentIMContext::set_preedit_attribute_list (const AttributeList &attr_list)
{
    preedit_attribute_list = attr_list;
}


const bool ScimBridgeAgentIMContext::is_preedit_shown () const
{
    return preedit_shown;
}


void ScimBridgeAgentIMContext::set_preedit_shown (bool shown)
{
    assert ((shown && on_the_spot) || !shown);
    preedit_shown = shown;

    update_capabilities ();
}


void ScimBridgeAgentIMContext::update_capabilities ()
{
    if (imengine) {
        unsigned int cap = SCIM_CLIENT_CAP_ALL_CAPABILITIES;

        if (!preedit_shown)
            cap -= SCIM_CLIENT_CAP_ONTHESPOT_PREEDIT;

        imengine->update_client_capabilities (cap);
    }
}


const ScimBridgeAgentClientPeer *ScimBridgeAgentIMContext::get_client_peer () const
{
    return client_peer;
}


ScimBridgeAgentClientPeer *ScimBridgeAgentIMContext::get_client_peer ()
{
    return client_peer;
}


void ScimBridgeAgentIMContext::set_client_peer (ScimBridgeAgentClientPeer *new_client_peer)
{
    client_peer = new_client_peer;
}


/* Calls for imengine instance */

const int ScimBridgeAgentIMContext::get_cursor_x () const
{
    return cursor_x;
}


const int ScimBridgeAgentIMContext::get_cursor_y () const
{
    return cursor_y;
}


void ScimBridgeAgentIMContext::set_cursor_x (int x)
{
    cursor_x = x;
}


void ScimBridgeAgentIMContext::set_cursor_y (int y)
{
    cursor_y = y;
}


void ScimBridgeAgentIMContext::set_cursor_location (int x, int y)
{
    cursor_x = x;
    cursor_y = y;
}


bool ScimBridgeAgentIMContext::process_key_event (const KeyEvent &keyevent)
{
    return imengine->process_key_event (keyevent);
}


void ScimBridgeAgentIMContext::update_lookup_table_page_size (int page_size)
{
    imengine->update_lookup_table_page_size (page_size);
}


void ScimBridgeAgentIMContext::lookup_table_page_up ()
{
    imengine->lookup_table_page_up ();
}


void  ScimBridgeAgentIMContext::lookup_table_page_down ()
{
    imengine->lookup_table_page_down ();
}


void ScimBridgeAgentIMContext::trigger_property (const String &property)
{
    imengine->trigger_property (property);
}


const String ScimBridgeAgentIMContext::get_factory_uuid () const
{
    return imengine->get_factory_uuid ();
}


void ScimBridgeAgentIMContext::process_helper_event (const String &helper_uuid, const Transaction &trans)
{
    imengine->process_helper_event (helper_uuid, trans);
}


void ScimBridgeAgentIMContext::move_preedit_caret (int caret_pos)
{
    imengine->move_preedit_caret (caret_pos);
}


void ScimBridgeAgentIMContext::select_candidate (int cand_index)
{
    imengine->select_candidate (cand_index);
}


void ScimBridgeAgentIMContext::focus_in ()
{
    imengine->focus_in ();
}


void ScimBridgeAgentIMContext::focus_out ()
{
    imengine->focus_out ();
}


void ScimBridgeAgentIMContext::reset ()
{
    reset_preedit ();
    imengine->reset ();
}


bool ScimBridgeAgentIMContext::process_keyevent (const scim::KeyEvent &keyevent)
{
    return imengine->process_key_event (keyevent);
}
