#ifndef SCIMBRIDGECLIENTKERNEL_H_
#define SCIMBRIDGECLIENTKERNEL_H_

#include "scim-bridge.h"
#include "scim-bridge-attribute.h"
#include "scim-bridge-exception.h"
#include "scim-bridge-imcontext-common.h"
#include "scim-bridge-keyevent.h"
#include "scim-bridge-string.h"

#ifdef __cplusplus
extern "C"
{
#endif

    int scim_bridge_client_initialize_kernel (ScimBridgeException *except);
    int scim_bridge_client_finalize_kernel (ScimBridgeException *except);
    int scim_bridge_client_trigger_kernel_finalizer (ScimBridgeException *except);
    int scim_bridge_client_kernel_cleanup (ScimBridgeException *except);

    /* Called from subclasses */
    int scim_bridge_client_kernel_alloc_imcontext (ScimBridgeException *except, ScimBridgeIMContext *context);
    int scim_bridge_client_kernel_free_imcontext (ScimBridgeException *except, ScimBridgeIMContext *context);

    ScimBridgeIMContext *scim_bridge_client_kernel_get_first_imcontext ();
    ScimBridgeIMContext *scim_bridge_client_kernel_get_next_imcontext (ScimBridgeIMContext *imcontext);

    int scim_bridge_client_kernel_reset_imcontext (ScimBridgeException *except, ScimBridgeIMContext *context);

    int scim_bridge_client_kernel_focus_changed (ScimBridgeException *except, ScimBridgeIMContext *context, int focus_in);
    int scim_bridge_client_kernel_keyevent_occured (ScimBridgeException *except, ScimBridgeIMContext *context, const ScimBridgeKeyEvent *keyevent, int *consumed);
    int scim_bridge_client_kernel_cursor_location_changed (ScimBridgeException *except, ScimBridgeIMContext *ic, int cursor_x, int cusor_y);

    /* Please implement them for your own immodules */
    void scim_bridge_client_kernel_impl_commit (ScimBridgeIMContext* ic);

    void scim_bridge_client_kernel_impl_set_preedit_string (ScimBridgeIMContext *context, ucs4_t *wstr, size_t wstr_len);
    void scim_bridge_client_kernel_impl_set_preedit_attributes (ScimBridgeIMContext *context, ScimBridgeAttribute *attrs, size_t attr_length);
    void scim_bridge_client_kernel_impl_set_preedit_cursor_position (ScimBridgeIMContext *context, int cursor_position);
    void scim_bridge_client_kernel_impl_set_preedit_shown (ScimBridgeIMContext *context, int shown);
    void scim_bridge_client_kernel_impl_update_preedit (ScimBridgeIMContext *ic);

    void scim_bridge_client_kernel_impl_forward_keyevent (ScimBridgeIMContext *ic, const ScimBridgeKeyEvent *keyevent);
    void scim_bridge_client_kernel_impl_beep (ScimBridgeIMContext *ic);

    void scim_bridge_client_kernel_impl_get_surrounding_string (ScimBridgeIMContext *ic, ucs4_t *wstr, size_t max_length, size_t *fetch_length, int *cursor_position);
    void scim_bridge_client_kernel_impl_delete_surrounding_string (ScimBridgeIMContext *ic, size_t offset, size_t length, int *retval);
    void scim_bridge_client_kernel_impl_get_cursor_location (ScimBridgeIMContext *context, int *x, int *y);

    void scim_bridge_client_kernel_impl_exception_occured (ScimBridgeException *except);
    void scim_bridge_client_kernel_impl_cleanup ();
    void scim_bridge_client_kernel_impl_finalized ();

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGECLIENTKERNEL_H_*/
