#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include "scim-bridge-client-keyevent-utility-gtk.h"
#include "scim-bridge-keyevent.h"
#include "scim-bridge-utility.h"

static GdkKeymap *get_gdk_keymap (GdkWindow *window)
{
#if GDK_MULTIHEAD_SAFE
    if (window) return gdk_keymap_get_for_display (gdk_drawable_get_display (window));
#endif

    return gdk_keymap_get_default ();
}


GdkEventKey scim_bridge_keyevent_bridge_to_gdk (GdkWindow *client_window, const ScimBridgeKeyEvent *keyevent)
{
    GdkEventKey gdkevent;

    gdkevent.state = 0;
    if (scim_bridge_keyevent_is_shift_down (keyevent)) gdkevent.state |= GDK_SHIFT_MASK;
    if (scim_bridge_keyevent_is_caps_lock_down (keyevent)) gdkevent.state |= GDK_LOCK_MASK;
    if (scim_bridge_keyevent_is_control_down (keyevent)) gdkevent.state |= GDK_CONTROL_MASK;
    if (scim_bridge_keyevent_is_alt_down (keyevent)) gdkevent.state |= GDK_MOD1_MASK;
    /*if (scim_bridge_keyevent_is_num_lock_down (keyevent)) gdkevent.state |= GDK_MOD2_MASK;*/

    if (scim_bridge_keyevent_is_key_pressed (keyevent)) {
        gdkevent.type = GDK_KEY_PRESS;
    } else {
        gdkevent.type = GDK_KEY_RELEASE;
        gdkevent.state |= GDK_RELEASE_MASK;
    }

    gdkevent.window = client_window;

    gdkevent.send_event = TRUE;
    gdkevent.time = scim_bridge_get_milliseconds_since_the_epoch ();
    gdkevent.keyval = keyevent->code;
    gdkevent.length = 0;
    gdkevent.string = 0;

    GdkKeymap *keymap = get_gdk_keymap (gdkevent.window);

    GdkKeymapKey *keys;
    gint n_keys;

    if (gdk_keymap_get_entries_for_keyval (keymap, gdkevent.keyval, &keys, &n_keys)) {
        gdkevent.hardware_keycode = keys[0].keycode;
        gdkevent.group = keys [0].group;
    } else {
        gdkevent.hardware_keycode = 0;
        gdkevent.group = 0;
    }

    return gdkevent;
}


ScimBridgeKeyEvent scim_bridge_keyevent_gdk_to_bridge (GdkWindow *window, const GdkEventKey *keyevent)
{
    ScimBridgeKeyEvent bridge_keyevent;

    // Use Key Symbole provided by gtk.
    bridge_keyevent.code = (ScimBridgeKeyCode) keyevent->keyval;

    bridge_keyevent.mod_state = 0;
    if (keyevent->state & GDK_SHIFT_MASK) bridge_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_SHIFT;
    if (keyevent->state & GDK_LOCK_MASK) bridge_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_CAPS_LOCK;
    if (keyevent->state & GDK_CONTROL_MASK) bridge_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_CONTROL;
    if (keyevent->state & GDK_MOD1_MASK) bridge_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_ALT;
    /*if (keyevent->state & GDK_MOD2_MASK) bridge_keyevent.mod_state |= SCIM_BRIDGE_MODIFIER_MASK_NUM_LOCK;*/

    if (keyevent->type == GDK_KEY_RELEASE) {
        bridge_keyevent.pressed = FALSE;
    } else {
        bridge_keyevent.pressed = TRUE;
    }

    return bridge_keyevent;
}
