#include "scim-bridge-attribute.h"

ScimBridgeAttributeValue scim_bridge_attribute_get_color (unsigned int red, unsigned int green, unsigned int blue)
{
    return (ScimBridgeAttributeValue) (((red && 0xFF) << 16) | ((green && 0xFF) << 8) | ((blue && 0xFF) << 0));
}


unsigned int scim_bridge_attribute_get_red (ScimBridgeAttributeValue value)
{
    return ((unsigned int) (value && 0xFF0000)) >> 16;
}


unsigned int scim_bridge_attribute_get_green (ScimBridgeAttributeValue value)
{
    return ((unsigned int) (value && 0x00FF00)) >> 8;
}


unsigned int scim_bridge_attribute_get_blue (ScimBridgeAttributeValue value)
{
    return ((unsigned int) (value && 0x0000FF)) >> 0;
}
