#ifndef SCIMBRIDGEENVIRONMENT_H_
#define SCIMBRIDGEENVIRONMENT_H_

#include "scim-bridge.h"
#include "scim-bridge-output.h"

static const char SCIM_BRIDGE_ENV_NAME_DEBUG_LEVEL[] = "SCIM_BRIDGE_DEBUG_LEVEL";
static const char SCIM_BRIDGE_ENV_NAME_DEBUG_FLAGS[] = "SCIM_BRIDGE_DEBUG_FLAGS";
static const char SCIM_BRIDGE_ENV_NAME_DISPLAY_NUMBER[] = "SCIM_BRIDGE_DISPLAY_NUMBER";
static const char SCIM_BRIDGE_ENV_NAME_SCREEN_NUMBER[] = "SCIM_BRIDGE_SCREEN_NUMBER";

static const char SCIM_BRIDGE_ENV_VALUE_DEBUG_FLAGS_NONE[] = "none";
static const char SCIM_BRIDGE_ENV_VALUE_DEBUG_FLAGS_ALL[] = "all";
static const char SCIM_BRIDGE_ENV_VALUE_DEBUG_FLAGS_IMCONTEXT[] = "imcontext";
static const char SCIM_BRIDGE_ENV_VALUE_DEBUG_FLAGS_MESSENGER[] = "messenger";
static const char SCIM_BRIDGE_ENV_VALUE_DEBUG_FLAGS_AGENT[] = "agent";
static const char SCIM_BRIDGE_ENV_VALUE_DEBUG_FLAGS_CLIENT[] = "client";
static const char SCIM_BRIDGE_ENV_VALUE_DEBUG_FLAGS_SCIM[] = "scim";

#ifdef __cplusplus

#include <cstddef>
extern "C"
{
#endif

    /* Functions */
    const char *scim_bridge_environment_get_agent_to_client_socket_path ();
    const char *scim_bridge_environment_get_client_to_agent_socket_path ();

    const char *scim_bridge_environment_get_lockfile_path ();

    const char *scim_bridge_environment_get_display_name ();
    unsigned int scim_bridge_environment_get_display_number ();
    unsigned int scim_bridge_environment_get_screen_number ();

    ScimBridgeDebugLevel scim_bridge_environment_get_debug_level ();
    ScimBridgeDebugFlag scim_bridge_environment_get_debug_flags ();

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEENVIRONMENT_H_*/
