#ifndef SCIMBRIDGEOUTPUT_H_
#define SCIMBRIDGEOUTPUT_H_

#include "scim-bridge.h"

typedef unsigned int ScimBridgeDebugLevel;
typedef unsigned int ScimBridgeDebugFlag;

static const ScimBridgeDebugFlag SCIM_BRIDGE_DEBUG_NONE = 0;
static const ScimBridgeDebugFlag SCIM_BRIDGE_DEBUG_ALL = 0xFF;
static const ScimBridgeDebugFlag SCIM_BRIDGE_DEBUG_IMCONTEXT = 1 << 0;
static const ScimBridgeDebugFlag SCIM_BRIDGE_DEBUG_MESSENGER = 1 << 1;
static const ScimBridgeDebugFlag SCIM_BRIDGE_DEBUG_CLIENT = 1 << 2;
static const ScimBridgeDebugFlag SCIM_BRIDGE_DEBUG_AGENT = 1 << 3;
static const ScimBridgeDebugFlag SCIM_BRIDGE_DEBUG_SCIM = 1 << 4;

#ifdef __cplusplus
extern "C"
{
#endif

    void scim_bridge_println (const char* format,...);
    void scim_bridge_perrorln (const char* format,...);
    void scim_bridge_pdebugln (ScimBridgeDebugFlag flag, ScimBridgeDebugLevel level, const char* format,...);
    void scim_bridge_print (const char* format,...);
    void scim_bridge_perror (const char* format,...);
    void scim_bridge_pdebug (ScimBridgeDebugFlag flag, ScimBridgeDebugLevel level, const char* format,...);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEOUTPUT_H_*/
