/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTCLIENTLISTENER_H_
#define SCIMBRIDGEAGENTCLIENTLISTENER_H_

#define Uses_SCIM_EVENT
#include <scim.h>

#include "scim-bridge-agent-event-client.h"

class ScimBridgeAgentClientListener: public ScimBridgeAgentEventClient
{

    public:

        static scim::KeyboardLayout get_keyboard_layout ();
        static void set_keyboard_layout (scim::KeyboardLayout new_layout);

        static ScimBridgeAgentClientListener *alloc (int new_socket_fd);

        virtual ~ScimBridgeAgentClientListener () {}

    protected:

        ScimBridgeAgentClientListener () {}

        virtual void do_close_event_client () = 0;

};
#endif                                            /*SCIMBRIDGEAGENTCLIENTLISTENER_H_*/
