/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

/**
 * @file
 * @author Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 * @brief This header describes about the data type of attributes.
 *
 * @mainpage
 *
 * ScimBridge is a wrapper library that allows the apps
 * which use SCIM as a input method to become binary independent with SCIM.\n
 * This will help the maintainers of SCIM, by simplify the complicated dependency around SCIM, libstdc++, and GUI libraries.
 *
 * <ul>
 *  <li><a href="user/index.html">User Manual</a></li>
 *  <li><a href="developer/index.html">Developer Manual</a></li>
 *  <li><a href="files.html">The API Document</a></li>
 * </ul>
 */
#ifndef SCIMBRIDGEAGENT_H_
#define SCIMBRIDGEAGENT_H_

#include "scim-bridge.h"
#include "scim-bridge-agent-exception.h"

/**/
class ScimBridgeAgent
{

    public:

        static ScimBridgeAgent *alloc (bool noexit_enabled);

        virtual ~ScimBridgeAgent () {}

        virtual retval_t create_lockfile (pid_t pid) = 0;

        virtual void launch () throw (ScimBridgeAgentException) = 0;

    protected:

        ScimBridgeAgent () {}

};
#endif                                            /*SCIMBRIDGEAGENT_H_*/
