/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: testpanel.cpp,v 1.9 2004/06/20 07:35:52 suzhe Exp $
 *
 */

#define Uses_SCIM_SOCKET
#define Uses_SCIM_SOCKET_TRANSACTION
#define Uses_SCIM_PANEL
#define Uses_STL_IOSTREAM

#include "scim_private.h"
#include "scim.h"
#include "scim_socket_transaction.h"
#include <ctype.h>
#include <unistd.h>

using namespace scim;

const char * str1 = "SCIM shurufamianbanceshichengxu \n\n";
const char * str2 = "It's a forwarded string.\n\n";
const char * str3 = "直接提交给客户程序的字符串.\n\n";

int main (int argc, char *argv[])
{
	SocketAddress address;
	SocketClient client;
	SocketTransaction trans;

	uint32 magic;
	int cmd;

	address.set_address (scim_get_default_panel_socket_address ());

	if (client.connect (address)) {
		if (!scim_socket_trans_open_connection (magic, "GUI", "Panel", client))
			client.close ();
	}

	if (!client.is_connected ()) {
		std::cout << "Failed to connect to panel.\n";
		return -1;
	}

	PropertyList properties;

	Property prop1 ("/TestPanel/Menu1", "Menu1", "", "This is menu1.");
	Property prop2 ("/TestPanel/Menu1/Item1", "Item 1", "", "This is item 1 of menu1.");
	Property prop3 ("/TestPanel/Menu1/Item2", "Item 2", "", "This is item 2 of menu1.");
	Property prop4 ("/TestPanel/Menu1/Item3", "Item 3", "", "This is item 3 of menu1.");
	Property prop5 ("/TestPanel/Menu1/Submenu1", "Submenu 1", "", "This is a submenu of menu1.");
	Property prop6 ("/TestPanel/Menu1/Submenu1/Item4", "Item 4", "", "This is item 4 of menu1.");
	Property prop7 ("/TestPanel/Menu1/Submenu1/Item5", "Item 5", "", "This is item 5 of menu1.");
	Property prop8 ("/TestPanel/Menu1/Submenu1/TestInput", "TestInput", "", "Test input emulation.");
	Property prop9 ("/TestPanel/Menu1/Item6", "Item 6", "", "This is item 6 of menu1.");
	Property prop10 ("/TestPanel/Button1", "Button1", "", "This is button1.");

	properties.push_back (prop1);
	properties.push_back (prop2);
	properties.push_back (prop3);
	properties.push_back (prop4);
	properties.push_back (prop5);
	properties.push_back (prop6);
	properties.push_back (prop7);
	properties.push_back (prop8);
	properties.push_back (prop9);
	properties.push_back (prop10);

	trans.clear ();
	trans.put_command (SCIM_TRANS_CMD_REQUEST);
	trans.put_data (magic);
	trans.put_command (SCIM_TRANS_CMD_REGISTER_PROPERTIES);
	trans.put_data (properties);
	trans.write_to_socket (client);

	int i = 0;
	char name [32];
	String property;
	String display;
	uint32 screen;

	while (i < 20) {
		if (trans.read_from_socket (client, -1) &&
			trans.get_command (cmd) && cmd == SCIM_TRANS_CMD_REPLY &&
			trans.get_command (cmd) && cmd == SCIM_TRANS_CMD_TRIGGER_PROPERTY &&
			trans.get_data (property)) {

			std::cout << "Property activated: " << property << " on ";

			if (trans.get_data (display) && trans.get_data (screen)) {
				std::cout << display << ":" << screen;
			}
			std::cout << "\n";

			if (property == prop10) {
				prop1.show (! prop1.visible ());

				trans.clear ();
				trans.put_command (SCIM_TRANS_CMD_REQUEST);
				trans.put_data (magic);
				trans.put_command (SCIM_TRANS_CMD_UPDATE_PROPERTY);
				trans.put_data (prop1);
				trans.write_to_socket (client);
			} else if (property == prop2) {
				prop8.set_active (!prop8.active ());

				trans.clear ();
				trans.put_command (SCIM_TRANS_CMD_REQUEST);
				trans.put_data (magic);
				trans.put_command (SCIM_TRANS_CMD_UPDATE_PROPERTY);
				trans.put_data (prop8);
				trans.write_to_socket (client);
			} else if (property == prop8) {
				sleep (1);
			
				for (const char *p = str1; *p; ++p) {
					KeyEvent key;
			
					key.code = *p;
			
					if (isupper (*p)) key.mask = SCIM_KEY_ShiftMask;
					if (*p == '\n') key.code = SCIM_KEY_Return;
			
					trans.clear ();
					trans.put_command (SCIM_TRANS_CMD_REQUEST);
					trans.put_data (magic);
					trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
					trans.put_data (key);
					key.mask |= SCIM_KEY_ReleaseMask;
					trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
					trans.put_data (key);
					trans.write_to_socket (client);
					usleep (100000);
				}
			
				sleep (3);
			
				for (const char *p = str2; *p; ++p) {
					KeyEvent key;
			
					key.code = *p;
			
					if (isupper (*p)) key.mask = SCIM_KEY_ShiftMask;
					if (*p == '\n') key.code = SCIM_KEY_Return;
			
					trans.clear ();
					trans.put_command (SCIM_TRANS_CMD_REQUEST);
					trans.put_data (magic);
					trans.put_command (SCIM_TRANS_CMD_FORWARD_KEY_EVENT);
					trans.put_data (key);
					key.mask |= SCIM_KEY_ReleaseMask;
					trans.put_command (SCIM_TRANS_CMD_FORWARD_KEY_EVENT);
					trans.put_data (key);
					trans.write_to_socket (client);
					usleep (100000);
				}
			
				sleep (3);
			
				trans.clear ();
				trans.put_command (SCIM_TRANS_CMD_REQUEST);
				trans.put_data (magic);
				trans.put_command (SCIM_TRANS_CMD_COMMIT_STRING);
				trans.put_data (String (str3));
				trans.write_to_socket (client);
			}

			++i;
		}
	}

	return 0;
}
/*
vi:ts=4:nowrap:ai
*/

