;====================================================================
;
;    scmhob.scm defines several procedures recognized
;    by the hobbit compiler as primitives, but not defined in scm or slib.
;      
;    Use scmhob when running code (meant for compilation by
;    hobbit) under interpreter. Never compile scmhob.scm!
;      
;    Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997 Tanel Tammet
;    tammet@cs.chalmers.se
;
;                        version 5x
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 1, or (at your option)
; any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
; 
;====================================================================

; bitwise operations: logical shift left and logical shift right

(define (logsleft x y) (ash x y))
(define (logsright x y) (ash x (- 0 y)))

; immediate-integer (30-bit signed int) versions of arithmetic primitives:

(define %eqv? eqv?)
(define %zero? zero?)
(define %negative? negative?)
(define %positive? positive?)
(define %number? number?)
(define %= =)
(define %< <)
(define %> >)
(define %<= <=)
(define %>= >=)
(define %+ +)
(define %- -)
(define %* *)
(define %/ /)

