.TH scmxx 1 2003-03-11 SCMxx
.SH ИМЯ
scmxx \- осуществляет обмен данными с вашим мобильным телефоном Siemens
.SH СИНТАКСИС
.HP 6
.B scmxx 
.RB [ \-\-device " устройство]"
.RB [ \-\-baud " скорость_передачи]"
.RB [ \-\-quiet ]
.RB [ \-\-verbose ]
.BR \-\-reset | \-\-help | \-\-set\-time | \-\-mem\-info
.PP
.HP 6
.B scmxx 
.RB [ \-\-device " устройство]"
.RB [ \-\-baud " скорость_передачи]"
.RB [ \-\-quiet ]
.RB [ \-\-verbose ]
.BR \-\-set\-smsc
.BR \-\-number " номер"
.PP
.HP 6
.B scmxx 
.RB [ \-\-device " устройство]"
.RB [ \-\-baud " скорость_передачи]"
.RB [ \-\-quiet ]
.RB [ \-\-verbose ]
.RB [ \-\-out " файл]"
.RB [ \-\-pipe " канал]"
.BR \-\-remove | \-\-send | \-\-get
.B  \-\-binary
.BR \-\-mem " тип_памяти"
.BR \-\-slot " слот"
[файл ...]
.PP
.HP 6
.B scmxx 
.RB [ \-\-device " устройство]"
.RB [ \-\-baud " скорость_передачи]"
.RB [ \-\-quiet ]
.RB [ \-\-verbose ]
.RB [ \-\-out " файл]"
.RB [ \-\-pipe " канал]"
.RB [ \-\-pin " PIN-код]"
.BR \-\-remove | \-\-send | \-\-get
.B  \-\-pbook
.BR \-\-mem " тип_памяти"
[файл ...]
.PP 
.HP 6
.B scmxx 
.RB [ \-\-device " устройство]"
.RB [ \-\-baud " скорость_передачи]"
.RB [ \-\-quiet ]
.RB [ \-\-verbose ]
.RB [ \-\-out " файл]"
.RB [ \-\-pipe " канал]"
.BR \-\-remove | \-\-send | \-\-get
.B  \-\-sms
.BR \-\-mem " тип_памяти"
.BR \-\-slot " слот"
.RB [ \-\-text " текст]"
.RB [ \-\-number " номер]" 
.RB [ \-\-direct ]
.RB [ \-\-flash ]
.RB [ \-\-srr ]
.RB [ \-\-unicode ]
[файл ...]
.PP
.HP 6
.B scmxx 
.BR \-\-help | \-\-version 

.SH ОПИСАНИЕ
SCMxx может копировать файлы в мобильный телефон Siemens и обратно, а также
удалять сохраненные файлы. Файлы могут быть прочитаны из указанного файла или
получены через стандартный ввод и сохранены в конкретном файле или переданы на
стандартный вывод. SMS могут быть также напрямую переданы или приняты без
сохранения в мобильном телефоне. SCMxx была протестирована с несколькими
мобильными телефонами, произведенными Siemens (только S25 и поздние), а при
работе с неподдерживаемыми телефонами будет выведено предупреждение.

.SH ОПЦИИ
.TP 20
.B --device (-d)
определить отличное от вкомпилированного имя устройства. Опция перекрывает
переменную окружения SCMXX_TTY и вкомпилированное значение. Для системы linux
может быть, к примеру, /dev/ttyS0 для последовательного соединения и
/dev/ircomm0 для соединения по инфракрасному порту.
.TP 20
.B --baud (-b)
определить скорость устройства. Подходящие значения зависят от системы, но
могут быть 9600, 19200, 38400, 57600 или 115200. Значение по умолчанию 19200.
Телефоны S25 и *35i работают только при скорости 19200, все поздние модели
также работают при полной скорости последовательного канала. Соединения по 
инфракрасному порту могут содержать исключения из этих правил (зависит от
реализации порта). Опция перекрывает значение переменной окружения SCMXX_BAUD
и вкомпилированное значение.
.TP 20
.B --out (-o)
определить используемый файл. При получении бинарных файлов с параметром "all"
к каждому файлу присоединяется номер слота, точка и тип файла (SMS составляет
исключение). При отправке или удалении, опция не будет использоваться, но в
качестве параметра должны быть указаны корректные файлы. Стандартный вывод
должен быть однозначно выбран через дефис ("-"): по умолчанию ничего не
выводится на стандартный вывод. Ничего не добавляется к "-", когда идет
получение группы файлов.
.TP 20
.B --pipe (-p)
определить канал к другой программе. При получении данных с параметром "all",
каждый файл будет передан по каналу к этим программам сам собой (только для
опций --binary и --sms).
.TP 20
.B --quiet (-q)
уменьшить степень подробности вывода на 1
.TP 20
.B --pin
использовать эту опцию, если требуется ввести PIN код для доступа
.TP 20
.B --verbose (-v)
увеличить степень подробности вывода на 1
.TP 20
.B --reset
попытаться сбросить телефон, и он снова станет доступен. Это может понадобится
в случае, если телефон не отвечает больше по последовательному интерфейсу,
особенно при прерванной перед этим пользователем передачи файла. Произойдет
просто слепая передача некоторых специальных символов.
.TP 20
.B --help (-h)
вывести текст помощи
.TP 20
.B --version
вывести номер версии
.TP 20
.B --remove (-r)
удалить запись в телефоне. "Слот" выбирается либо числом, либо ключевым словом
"all". Когда опция определена с опциями --sms и --get, будет произведено
получение и удаление. Когда опция определена с опцией --sms, может быть получен
также статус сообщений. Статус может принимать следующие значения: "unread"
(непрочитанные), "read" (прочитанные), "unsent" (неотправленные) и "sent"
(отправленные).
.TP 20
.B --get (-g)
получить запись и сохранить ее в файл. "Слот" выбирается либо числом, либо
ключевым словом "all". Когда опция определена с опцией --sms, может быть
получен также статус сообщений. Статус может принимать следующие значения:
"unread" (непрочитанные), "read" (прочитанные), "unsent" (неотправленные) и
"sent" (отправленные).
.TP 20
.B --send (-s)
отправить файл в телефон. "Слот" является числом. Без параметра будет
произведена попытка поиска первого свободного слота (возможно, что это займет
длительный промежуток времени). Когда определены слот и группа файлов для
загрузки, то данный слот является начальной точкой для поиска пустых слотов.
Групповая перезапись, запись в непустые слоты не поддерживается. Если опция
определена с --sms, то это также может определять статус. Статус может
принимать следующие значения: "unread" (непрочитанные), "read" (прочитанные),
"unsent" (неотправленные), "sent" (отправленные), но только два последних в
данный момент работают правильно (и необходимо использовать --direct, иначе
сообщение только скопируется).
.TP 20
.B --info (-i)
собрать информацию о телефоне, --mem-info может быть использована для
переключения вывода между кратким и более сложным списком доступных типов
памяти
.TP 20
.B --mem-info
отобразить информацию о доступных типах памяти и их слотах, а также другую
информацию. Опция использует такой же формат, как и --mem=? (смотрите ниже), и
также может быть использована как переключатель для --info, чтобы заместить
краткий список типов памяти.
.TP 20
.B --set-time
синхронизировать время в телефоне. Рекомендуется использовать инструменты
типа ntpdate перед синхронизацией.
.TP 20
.B --set-smsc
установить номер SMS-центра (требует опцию --number)
.TP 20
.B --binary (-N)
выбрать режим обмена бинарными файлами
.TP 20
.B --pbook (-P)
выбрать режим передачи телефонной книги
.TP 20
.B --sms (-S)
выбрать режим службы коротких сообщений
.TP 20
.B --mem
выбрать тип памяти, к которой осуществляется доступ. Номера слотов могут
варьироваться в зависимости от выбранного типа памяти. Смотрите вывод опции
--info для определения поддерживаемых типов памяти. Без использования этой
опции срабатывает поведение по умолчанию (если таковое было определено).
Специальная строка "?" предназначена для вывода в таком же формате, как и
--mem-info, но только для выбранного режима.
.TP 20
.B --slot
выбрать слот, к которому осуществляется доступ. Смотрите вывод --mem-info или
--mem=?. Без использования этой опции включается поведение по умолчанию (если
таковое было определено). Специальная строка "all" определяет полный диапазон
всех доступных слотов для выбранных типа памяти и режима. Для SMS, доступны
четыре дополнительных специальных строки: "read" (прочитанные), "unread"
(непрочитанные), "sent" (отправленные) и "unsent" (неотправленные).
.TP 20
.B --text (-t)
определить содержание текста SMS (только в режиме отправки). Заметьте, что
длина ограничена 160 символами в кодировке GSM (минус 1 на каждый используемый
символ, который нуждается в 14-битном кодировании) или 140 символами в
кодировке UCS-2. Программа откажет в отправке, если текст слишком длинный.
.TP 20
.B --number (-n)
определить номер для отправки SMS (только в режиме отправки). Заметьте, что
номер может иметь вначале '+' для международных номеров. Он ограничен 20
цифрами (без '+'), которых действительно достаточно.
.TP 20
.B --direct
отправить/получить короткие сообщения без сохранения в памяти телефона. Это не
выполняется по умолчанию, так как вы будете несомненно заняты сообщением, при
отправке. При непосредственном получении, SMS, тип которого не соответствует
DELIVER, все еще сохраняется в памяти телефона (scmxx не может пока что
декодировать такие сообщения).
.TP 20
.B --unicode
переслать сообщение и ипользовать UCS-2 (16бит unicode) как таблицу символов.
Эта опция ограничит длину сообщения до 70 символов. Если опция не определена,
то будет использовано кодирование символов 7бит GSM с максимальным ограничением
в 160 символов. Необязательно применять эту опцию для декодирования сообщений,
написанных в кодировке unicode.
.TP 20
.B --flash
установить Class0 в поле схемы кодирования данных, что обычно интерпретируется
как "немедленное отображение". Не все принимающие аппараты дают право делать
это. Заметьте, что очередное sms обычно перезаписывает предыдущее
сообщение без вопросов такого типа! Использование опции не рекомендуется.
.TP 20
.B --srr
установить StatusReportRequest бит в поле pdutype из sms pdu. Это зависит от
SMSC, если это принимать во внимание. С некоторыми провайдерами это потребует
дополнительных затрат!
.SH ИСПОЛЬЗОВАНИЕ
.TP 5
Отправить файл растрового изображения в телефон как Картинку:
.br
scmxx --send --binary --mem="bmp" --slot=0 myfile.bmp
.TP 5
Получить Картинку из телефона и сохранить ее в новом файле:
.br
scmxx --get --binary --mem="bmp" --slot=0 --out=myfile.bmp
.TP 5
Получить все непрочитанные (режим по умолчанию при get) короткие сообщения и вывести их на стандартный вывод:
.br
scmxx --get --sms --output=-

.SH ЗАМЕЧАНИЯ
Выводимый текст (телефонная книга и сообщения) зависит от таблицы символов
текущей локализации. Вводимый аналогично. Такое преимущество у локализации, но
есть и недостаток, что все остальные символы должны вводиться через
последовательность вида \eXXXX, где X - шестнадцатиричный символ (например,
\e20ac для знака Euro). Это 16битное представление значения unicode.
Представление \eXXXX используется только для вывода с целью его последующего
прочтения. При нормальном выводе, символы, которые не могут быть отображены в
текущей локализации, заменяются на символ '?'. Использование локализации,
базирующейся на UTF-8, гарантирует, что все символы могут быть перекодированы.
Символ новой строки может быть введен, используя общее представление \en, а
символ '\e' должен быть экранирован сам собой. В bash в результате необходимо
вводить строку подобно "\e\e\e\e".

.SH ПРОБЛЕМЫ СОЕДИНЕНИЯ
Здесь описываются дополнительные параметры --ignore-serial-bits (по умолчанию)
и --keep-serial-bits. Используйте его только тогда, когда вообще нет ответа от
телефона. Такие установки зависят от кабеля и последовательного порта и не
могут быть определены автоматически.
.P
Если при первой команде происходят таймауты, следует попробовать параметр
--start-delay=<секунды>.
.P
Другой параметр --device-timeout=<секунды> предназначен для случая, когда
телефону когда-либо потребуется больше времени на ответ, чем определенные
по умолчанию 10 секунд. Действительно, это было более чем достаточно, но
кто знает. Минимальное значение равно 1, значения, превышающие 25,
подразумевают ожидание ответа до тех пор, пока он не будет получен.

.SH БЕЗОПАСНОСТЬ
Опцию --pin необходимо использовать с осторожностью. Опция и ее аргумент будут
видны в списке процессов.

.SH ПЕРЕМЕННЫЕ ОКРУЖЕНИЯ
.P
.TP 20
.B SCMXX_TTY
смотрите описание опции --device
.P
.TP 20
.B SCMXX_BAUD
смотрите описание опции --baud

.SH АВТОР
Hendrik Sattler <post@hendrik-sattler.de>.
Перевод выполнен Andy Shevchenko <andy@smile.org.ua> и Irina
Yeresko <mecec@yandex.ru>

