/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include "common.h"
#include "helpers.h"

void add_at_command(char *at_command_p, char *addon_p,...){
  va_list arg_list;

  if (at_command_p == NULL || addon_p == NULL) {
    return;
  }
  va_start(arg_list,addon_p);
  vsprintf(at_command_p+strlen(at_command_p),addon_p,arg_list);
  va_end(arg_list);
}

void new_at_command(char *at_command_p, char *addon_p){
  memcpy(at_command_p,AT_PREFIX,sizeof(AT_PREFIX));
  add_at_command(at_command_p,addon_p);
}

char** parse_at_stringlist (char* stringlist) {
  char* endoflist;
  char* temp;
  char* start;
  char* end;
  char** retval;
  size_t count = 0;

  if (stringlist[0] != '(') {
    return NULL;
  } else {
    if (stringlist[1] != ')') {
      endoflist = index(stringlist,')');
      if (endoflist == NULL) {
	return NULL;
      } else {
	temp = stringlist+1;
	//count the number of entries
	while ((start = index(temp,'"')) != NULL &&
	       (end = index(start+1,'"')) != NULL &&
	       end < endoflist) {
	  ++count;
	  temp = end+1;
	}
	retval = mem_alloc(sizeof(*retval)*(count+1),0);
	count = 0;
	temp = stringlist+1;;
	while ((start = index(temp,'"')) != NULL &&
	       (end = index(start+1,'"')) != NULL &&
	       end < endoflist) {
	  ++start;
	  retval[count++] = strn_dup(start,end-start);
	  temp = end+1;
	}
      }
    } else {
      retval = mem_alloc(sizeof(*retval),0);
    }
    retval[count]=NULL;
    return retval;
  }
}

/* checks output and returns
 * 1 on "OK" and ecode is unchanged
 * 0 on error and ecode is set to error message
 * -1 if neither 0 or 1 is the case
 */
int check_return_code (char* output, char* errorcode, size_t esize) {
  char* fullstrings[] = { "ERROR", "OK", NULL };
  char* partstrings[] = { "+CME ERROR: ", "+CMS ERROR: ", NULL };
  unsigned int i = 0;

  if (output == NULL) {
    return -1;
  }

  while (fullstrings[i] != NULL &&
	 strcmp(output,fullstrings[i])) {
    ++i;
  }
  if (fullstrings[i] != NULL) {
    if (i==0) {
      if (errorcode != NULL && esize > 0) {
	memset(errorcode,0,esize);
	strncpy(errorcode,"undefined error",esize-1);
      }
      return 0;
    } else {
      return 1;
    }
  } else {
    i=0;
    while (partstrings[i] != NULL &&
	   strncmp(output,partstrings[i],strlen(partstrings[i]))) {
      ++i;
    }
    if (partstrings[i] != NULL) {
      if (errorcode != NULL && esize > 0) {
	memset(errorcode,0,esize);
	strncpy(errorcode,output+12,esize-1);
      }
      return 0;
    } else {
      return -1;
    }
  }  
}

int verify_command (char* command, char* errorcode, size_t esize) {
  char* temp;
  int retval;

  temp = NULL;
  temp = tty_write_read(command);
  retval = check_return_code(temp,errorcode,esize);
  mem_realloc(temp,0);
  return retval;
}

char* get_value (char* command) {
  char* temp;

  temp = NULL;
  temp = tty_write_read(command);
  switch (check_return_code(temp,NULL,0)) {
  case -1:
    mem_realloc(tty_read(command),0);
    return temp;
    break;
  default:
    mem_realloc(temp,0);
    return NULL;
    break;
  }
}
