/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "options.h"
#include "helpers.h"

#include <popt.h>

char** args_parse (int argc, char** argv, struct args_t* args) {
  int arg;
  poptContext pcon;
  int argcount = 0;
  char** temp;
  char** retval;
  int i;

  struct poptOption myoptions[] = {
    /* the fith arg (myoptions.val) MUST be in correct order!
     * values start from 1 (not 0)
     */
    {"remove",'r',POPT_ARG_NONE,NULL,1,NULL,NULL},
    {"send",'s',POPT_ARG_NONE,NULL,2,NULL,NULL},
    {"get",'g',POPT_ARG_NONE,NULL,3,NULL,NULL},
    
    {"binary",'N',POPT_ARG_NONE,NULL,4,NULL,NULL},
    {"pbook",'P',POPT_ARG_NONE,NULL,5,NULL,NULL},
    {"sms",'S',POPT_ARG_NONE,NULL,6,NULL,NULL},
    
    {"info",'i',POPT_ARG_NONE,NULL,7,NULL,NULL},
    {"set-time",0,POPT_ARG_NONE,NULL,8,NULL,NULL},
    {"set-smsc",0,POPT_ARG_NONE,NULL,9,NULL,NULL},
    {"reset",0,POPT_ARG_NONE,NULL,10,NULL,NULL},
    
    {"mem",0,POPT_ARG_STRING,NULL,11,NULL,NULL},
    {"slot",0,POPT_ARG_STRING,NULL,12,NULL,NULL},    
    {"text",'t',POPT_ARG_STRING,NULL,13,NULL,NULL},
    {"number",'n',POPT_ARG_STRING,NULL,14,NULL,NULL},
    {"unicode",0,POPT_ARG_NONE,NULL,15,NULL,NULL},
    {"flash",0,POPT_ARG_NONE,NULL,16,NULL,NULL},
    {"srr",0,POPT_ARG_NONE,NULL,17,NULL,NULL},
    {"direct",0,POPT_ARG_NONE,NULL,18,NULL,NULL},
    
    {"device",'d',POPT_ARG_STRING,NULL,19,NULL,NULL},
    {"baud",'b',POPT_ARG_STRING,NULL,20,NULL,NULL},
    {"device-timeout",0,POPT_ARG_STRING,NULL,21,NULL,NULL},
    {"ignore-serial-bits",0,POPT_ARG_STRING,NULL,22,NULL,NULL},
    {"keep-serial-bits",0,POPT_ARG_STRING,NULL,23,NULL,NULL},
    
    {"out",'o',POPT_ARG_STRING,NULL,24,NULL,NULL},
    {"pipe",'p',POPT_ARG_STRING,NULL,25,NULL,NULL},
    
    {"pin",0,POPT_ARG_STRING,NULL,26,NULL,NULL},
    
    {"verbose",'v',POPT_ARG_NONE,NULL,27,NULL,NULL},
    {"quiet",'q',POPT_ARG_NONE,NULL,28,NULL,NULL},
    {"help",'h',POPT_ARG_NONE,NULL,29,NULL,NULL},
    {"version",0,POPT_ARG_NONE,NULL,30,NULL,NULL},
    
    {"mem-info",0,POPT_ARG_NONE,NULL,31,NULL,NULL},
    {"start-delay",0,POPT_ARG_STRING,NULL,32,NULL,NULL},

    POPT_TABLEEND
  };

  pcon = poptGetContext(NULL,argc,(const char **)argv,
			(const struct poptOption*)&myoptions,
			POPT_CONTEXT_POSIXMEHARDER);
  while ((arg = poptGetNextOpt(pcon)) > 0) {
    arg_fill(myoptions[arg-1].shortName,myoptions[arg-1].longName,
	     (char*)poptGetOptArg(pcon),args);
  }
  if (arg < -1) {
    fprintf(stderr, "%s: %s\n",
	    poptBadOption(pcon, POPT_BADOPTION_NOALIAS),
	    poptStrerror(arg));
  }
  
  temp = (char**) poptGetArgs(pcon);
  if (temp != NULL) {
    while (*temp != NULL) {
      ++argcount;
    }
  }
  retval = mem_alloc(argcount+1,0);
  for (i=0; i < argcount;++i) {
    retval[i] = temp[i];
  }
  retval[i]=NULL;

  poptFreeContext(pcon);
  return retval;
}
