/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMSCODING_H
#define SMSCODING_H

#include <charsets.h>
#include <smspdu.h>

/* This calls all functions that are needed to encode the userdata.
 * Returns NULL on parameter errors or if the data doesn't fit
 * else a char* that must be freed and which contains the data already as HEXSTRING!
 * Headersize MUST include the length field (means: must be value of
 * length field + 1)!
 * There is enough space left at the beginning to fit a header of
 * size headersize. Headersize also influences the encoding itself!
 * enc_len then contains the value suitable for user data length field
 */
char* sms_data_encode (enum sms_encoding charset,
		       ucs4char_t* input,
		       uint8_t* enc_len,
		       uint8_t headersize);

/* This calls all functions that are needed to decode the userdata
 * returns NULL on parameter errors else a ucs4char_t* that must be freed
 * udl must be the user data length field from the PDU
 * (encoded character count for GSM, byte count else),
 * _not_ the string length of input which certainly differs
 */
ucs4char_t* sms_data_decode (enum sms_encoding charset,
			     char* input,
			     unsigned int udl,
			     int header_present);

#endif
