/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GNU_SOURCE
# define _GNU_SOURCE
#endif
#ifndef _REENTRANT
# define _REENTRANT
#endif

#include <common.h>
#include <charsets.h>
#include <helper.h>
#include <smspdu.h>
#include "smscoding.h"
#include "smsudh.h"
#include <gtincl.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

unsigned int sms_pdu_len (char* pdu) {
  //short but does not look for invalid PDUs
  return str_len(pdu)/2;
}

unsigned int sms_tpdu_len (char* tpdu) {
  return sms_pdu_len(tpdu+2+hexstr2int(tpdu,2));
}

char* sms_pdu_create_submit (char* text, char* number,
			     struct smsopts* opts)
{
  uint8_t sca_len = 0;
  struct sms_number sca; //short message service center address
  uint8_t pdutype; //PDU type
  uint8_t mr; //message reference
  uint8_t da_len = 0;
  struct sms_number da; //destination address
  uint8_t pid = 0; //protocol identifier (normally 0)
  uint8_t dcs; //data coding scheme
  uint8_t vp_rel = 0xff; //validity period (0xff = max = 63 weeks)
  //char vp_abs[15]; //validity period (YYMMDDhhmmssTZ)
  uint8_t udl; //user data length
  unsigned char* ud; //user data

  ucs4char_t* wide_str;
  unsigned int i;

  char* pdu;

  /* not yet supported
   * zero length means that the phone will use its default
   */
  struct_sms_number_init(&sca);
  sca.type = numtype(sca.digits);
  sca_len = strlen(sca.digits)/2;
  if (sca_len) {
    ++sca_len;
  }
  
  /* set PDU type to standard values
   */
  pdutype = 1; //message type SMS-SUBMIT
  pdutype |= (1<<4); //validity period format: relative
  if (opts->srr) {
    pdutype |= (1<<5); //status report request;
  }

  /* message reference must be zero for Siemens phones!
   */
  mr = 0;

  /* destination number
   */
  struct_sms_number_init(&da);
  da.type = numtype(number);
  if (is_telephone_number(number) == 0) {
    fprintf(stderr,"%s: %s\n",_("Error"),_("No valid number specified."));
    exit(EXIT_FAILURE);
  }
  if ((da.type&SMS_NUMBER_TYPEMASK) == SMS_NUMTYPE_INTERNAT) {
    i = 1;
  } else {
    i = 0;
  }
  if (strlen(number+i) > sizeof(da.digits)-1) {
    fprintf(stderr,_("Error: sms number cannot have more than %d digits.\n"),sizeof(da.digits)-1);
    exit(EXIT_FAILURE);
  }
  strncpy(da.digits,number+i,sizeof(da.digits)-1);
  da_len = strlen(da.digits);

  /* support "flash-SMS" and unicode here
   */
  dcs = 0;
  if (opts->flash) {
    dcs &= 0xec; //clear all affected bits
    dcs |= 0x10; //set class 0 message (immediate display)
  }
  if (opts->unicode) {
    dcs &= 0xf3; //clear all affected bits
    dcs |= 0x08; //set unicode charset
  }

  //leave pid and vp_rel as is

  /* proces user data
   */
  wide_str = convert_from_system(text);
  ud = sms_data_encode((opts->unicode) ? SMS_CHARSET_UCS2 : SMS_CHARSET_GSM,
		       wide_str,&udl,0);
  mem_realloc(wide_str,0);
  if (ud == NULL) {
    fprintf(stderr,_("SMS text is too long (max. %d characters).\n"),
	    (opts->unicode) ? 140/2 : 140*8/7);
    if (!opts->unicode) {
      fprintf(stderr,"%s\n",
	      _("Please be aware that some characters "
	        "are encoded as 14bit (instead of 7bit), "
	        "e.g. the euro character."));
    }
    exit(EXIT_FAILURE);
  }

  //create PDU
  pdu = mem_alloc((176*2)+1,1);
  sprintf(pdu,"%02X",sca_len);
  if (sca_len) {
    sprintf(pdu+2,"%02X%s",sca.type,sca.digits);
  }
  sprintf(pdu+strlen(pdu),"%02X%02X%02X%02X",
	  pdutype,mr,da_len,da.type);
  for (i = 0; i+2 < strlen(da.digits); i += 2) {
    sprintf(pdu+strlen(pdu),"%c%c",
	    da.digits[i+1],da.digits[i]);
  }
  sprintf(pdu+strlen(pdu),"%c%c",
	  ((strlen(da.digits)%2) ? 'F' : da.digits[i+1]),
	  da.digits[i]);
  sprintf(pdu+strlen(pdu),"%02X%02X%02X%02X%s",
	  pid,dcs,vp_rel,udl,ud);
  mem_realloc(ud,0);
  struct_sms_number_delete(&sca);
  struct_sms_number_delete(&da);
  return pdu;
}

