#!/usr/bin/python
# -*- coding: utf-8 -*-

import gestClasse
from PyQt4.QtGui import *
from PyQt4.QtCore import *


class gestClasseTreeView(QTreeView):
    def __init__(self, parent=None):
        """
        Le constructeur
        @param parent un parent pour le widget
        """
        QTreeView.__init__(self, parent)
        self.gest=None
        model=QStandardItemModel()
        self.setModel(model)
        self.root = self.model().invisibleRootItem()
        return

    def connecteGestionnaire(self, fichier, gestionnaire=gestClasse.Sconet, renew=False):
        """
        @param fichier le nom d'un fichier, ou un fichier ouvert en lecture, pour
        récupérer des données SCONET
        @param gestionnaire un gestionnaire pour exploiter les données du fichier
        @param renew vrai si on doit tout effacer avant de recommencer
        """
        if renew:
            m=self.model()
            m.removeRows(0, m.rowCount())
            self.root = self.model().invisibleRootItem()
        self.gest=gestionnaire(fichier)
        for c in self.gest.collectClasses():
            rowClasse=[QStandardItem(c)]
            self.root.appendRow(rowClasse)
            for e in self.gest.elevesDeClasse(c):
                name=self.gest.showable_name(e)
                eleveItem=QStandardItem(name)
                eleveItem.setCheckable(True)
                eleveItem.unique_name=self.gest.unique_name(e)
                rowEleve=[eleveItem]
                rowClasse[0].appendRow(rowEleve)
        self.setExpanded(self.model().index(0,0),True)
        return

    def expandedItems(self):
        """
        @return la liste des items non repliés (donc visibles)
        """
        result=[]
        m=self.model()
        for r in range(m.rowCount()):
            cl=m.item(r)
            if self.isExpanded(cl.index()):
                for r1 in range(cl.rowCount()):
                    e=cl.child(r1)
                    result.append(e)
        return result

    def allItems(self):
        """
        @return la liste de tous les élèves
        """
        result=[]
        m=self.model()
        for r in range(m.rowCount()):
            cl=m.item(r)
            for r1 in range(cl.rowCount()):
                e=cl.child(r1)
                result.append(e)
        return result

    def checkedItems(self):
        """
        @return la liste de tous les élèves sélectionnés
        """
        result=[]
        m=self.model()
        for r in range(m.rowCount()):
            cl=m.item(r)
            for r1 in range(cl.rowCount()):
                e=cl.child(r1)
                if e.checkState():
                    result.append(e)
        return result

