package Scoop;
use strict;
my $DEBUG = 0;

sub _comment_rating_select {
	my $S = shift;
	my $rating = $S->session('commentrating') || 'dontcare';
	
	my ($selected_l, $selected_d, $selected_h);
	
	if ($rating eq 'highest') {
		$selected_h = ' SELECTED';
	} elsif ($rating eq 'lowest') {
		$selected_l = ' SELECTED';
	} elsif ($rating eq 'dontcare') {
		$selected_d = ' SELECTED';
	}
	
	my $select = qq|<SELECT NAME="commentrating" SIZE=1>
		<OPTION VALUE="unrate_highest">Unrated, then Highest
		<OPTION VALUE="highest"$selected_h>Highest Rated First
		<OPTION VALUE="lowest"$selected_l>Lowest Rated First
		<OPTION VALUE="dontcare"$selected_d>Ignore Ratings
		</SELECT>|;
	
	return $select;
}


sub _comment_rating_choice {
	my $S = shift;
	my $comment_rating_choice = $S->session('ratingchoice') || 'yes';
	
	my $sel_no;
	if ($comment_rating_choice eq 'no') {
		$sel_no = ' SELECTED';
	}
	
	my $select = qq|<SELECT NAME="ratingchoice" SIZE=1>
		<OPTION VALUE="yes">Yes
		<OPTION VALUE="no"$sel_no>No
		</SELECT>|;
	
	return $select;
}


sub _rating_form {
	my $S = shift;
	my $rating = shift;
	my $cid = shift;
	return '' unless ($S->have_perm('comment_rate'));

	my $op = $S->{CGI}->param('op');
	my $dynamic = ($op eq 'dynamic');
	my $dispmode = $S->session('commentmode');
	my $tool = $S->{CGI}->param('tool');
	return '' if( $op eq 'comments' && $tool eq 'post' );
	
	my $min = $S->{UI}->{VARS}->{rating_min};
	
	if (($S->{UI}->{VARS}->{use_mojo}) &&
		($S->{TRUSTLEV} == 2 || $S->have_perm('super_mojo'))) {
		$min--;
	}
	
	my $max = $S->{UI}->{VARS}->{rating_max};
	
	# Make sure if we haven't rated that the rating doesn't match any of the num values
	if ($rating eq 'none') {
		$rating = $max + 1;
	}

	my($form,$form_onchange,$form_submit);
	if($dynamic || $dispmode eq 'dthreaded' || $dispmode eq 'dminimal') {
		$form_onchange  = qq| onchange="toggle($cid,0,1,this.value)"|;
		$form_submit    = '';
	} else {
		$form_onchange  = '';
		$form_submit    = qq|<INPUT TYPE="submit" NAME="rate" VALUE="Rate All">|;
	}
	$form = qq|
		<SMALL>
		<SELECT NAME="rating_$cid" SIZE=1$form_onchange>
		<OPTION VALUE="none">none|;
		
	my ($i, $select);
	for ($i = $min; $i <= $max; $i++) {
		$select = ($rating == $i) ? ' SELECTED' : '';
		
		$form .= qq|
			<OPTION VALUE="$i"$select>$i|;
	}
		
	$form .= qq|
		</SELECT>$form_submit
		</SMALL>|;
	
	return $form;
}			

sub _set_current_ratings {
	my $S = shift;
	my $sid = shift;
	my $uid = shift;
	$S->{CURRENT_RATINGS}->{$sid} = {};
	
	# Get all ratings by this user for this article
	my ($rv, $sth) = $S->db_select({
		DEBUG => 0,
		WHAT => 'cid, rating',
		FROM => 'commentratings',
		WHERE => qq|sid = "$sid" AND uid = $uid|});
	
	while (my ($cid, $rating) = $sth->fetchrow()) {
		$S->{CURRENT_RATINGS}->{$sid}->{$cid} = $rating;
	}
	
	$sth->finish();
	
	return;
}


sub _get_current_rating {
	my $S = shift;
	my ($sid, $cid, $uid) = @_;
	
	unless (defined($S->{CURRENT_RATINGS}->{$sid})) {
		$S->_set_current_ratings($sid, $uid);
	}
	
	my $rating = 'none';
	if (defined($S->{CURRENT_RATINGS}->{$sid}->{$cid})) {
		$rating =  $S->{CURRENT_RATINGS}->{$sid}->{$cid};
	}
	
	return $rating;
}

# This is now an iterator for multi-comment ratings
sub rate_comment {
	my $S = shift;
	my $sid = $S->{CGI}->param('sid');
	my $qid = $S->{CGI}->param('qid');
	
	return undef unless $S->have_perm('comment_rate');
	
	# if its a poll or a story will depend on whether or not $sid or $qid is set.
	# since $sid is used so much below, I use this "test", so that the sid is itself
	# if set, else its the poll qid
	$sid = $sid || $qid;
	
	# Now run through all rating fields.
	my $params = $S->{CGI}->Vars();
	
	my $mojo_update = {};
	foreach my $key (keys %{$params}) {
		next unless ($key =~ /^rating_/);
		my ($trash, $cid) = split /_/, $key;
		my $rating = $params->{$key};
		
		next if ($rating eq 'none' || $rating !~ /^\d+$/);
		warn "New rating is $rating\n" if $DEBUG;
		my $c_uid = $S->_write_one_rating($sid, $cid, $rating);
		$mojo_update->{$c_uid} = 1;
	}
	
	# Update mojo of affected users
	if ($S->{UI}->{VARS}->{use_mojo}) {
		$S->update_mojo($mojo_update);
	}
	
	# Mark the story modified in the cache
	unless ($qid) {
		my $time = time();
		my $r = $sid.'_mod';
		$S->cache->stamp_cache($r, $time);
	}
	
	return;
}		


sub _write_one_rating {
	my $S = shift;
	my ($sid, $cid, $rating) = @_;
	my $sys_rate = shift;
	
		
	# Rating range check
	$rating = $S->_verify_rating($rating);
	
	my $uid = $S->{UID};
	my $comm_uid = 0;

	# $test_uid is to make sure people aren't rating their own comments
	# if it matches $S->{UID} return.  else, set $comm_uid to it at the bottom
	my $test_uid = $S->_get_uid_of_comment($sid, $cid);
	
	return unless (defined($test_uid));
	return $comm_uid if ($test_uid == $uid);	
	return $comm_uid unless ($S->_check_rating_perm($sid, $cid) || $sys_rate);
	#return if ($rating == 0);
	
	my ($rv, $sth);
	# First record the rating record-- check for existing
	my $flag = $S->_is_current_rating($sid, $cid);
	if ($flag) {
		($rv, $sth) = $S->db_update({
			DEBUG => 0,
			WHAT => 'commentratings',
			SET => qq|rating = $rating, rating_time = NOW()|,
			WHERE => qq|sid = "$sid" AND cid = $cid AND uid = $uid|});
	} else {
		($rv, $sth) = $S->db_insert({
			DEBUG => 0,
			INTO => 'commentratings',
			COLS => 'uid, sid, cid, rating, rating_time',
			VALUES => qq|$uid, "$sid", $cid, $rating, NOW()|});
	}
	$sth->finish;
	
	$comm_uid = $S->recalculate_one_rating($sid, $cid, $comm_uid, $test_uid, $flag);
	
	$S->run_hook('comment_rate', $sid, $cid, $uid, $rating);

	return $comm_uid;
}	
	
sub recalculate_one_rating {
	my $S = shift;	
	my ($sid, $cid, $comm_uid, $test_uid, $flag) = @_;

	# Then update the story's total rating
	my ($rating_total, $num_ratings) = $S->_current_rating_stats($sid, $cid);
	
	$num_ratings = undef unless ($num_ratings >= 1);
	
	my $new_av = undef;
	if ($num_ratings >= 1) {
		$new_av = ($rating_total / $num_ratings);
	}
	
	#warn "Rating is now $new_av\n";
	
	# Now file the new rating.
	$S->_update_comment_rating($sid, $cid, $new_av, $num_ratings, $flag);
	
	# Get the uid of the poster for mojo...
	if ($S->{UI}->{VARS}->{use_mojo}) {
		$comm_uid = $test_uid;
	}
	
	return $comm_uid;
}


sub _get_uid_of_comment {
	my $S = shift;
	my ($sid, $cid) = @_;
	
	my $f_sid = $S->{DBH}->quote($sid);
	my $f_cid = $S->{DBH}->quote($cid);
	
	my ($rv, $sth) = $S->db_select({
		WHAT => 'uid',
		FROM => 'comments',
		WHERE => qq|sid = $f_sid AND cid = $f_cid|});
	
	my $uid = $sth->fetchrow();
	$sth->finish();
	return $uid;
}


sub _verify_rating {
	my $S = shift;
	my $rating = shift;
	
	if ($rating > $S->{UI}->{VARS}->{rating_max}) {
		$rating = $S->{UI}->{VARS}->{rating_max};
	}
	
	my $min = $S->{UI}->{VARS}->{rating_min};
	if (($S->{UI}->{VARS}->{use_mojo}) &&
		($S->{TRUSTLEV} == 2 || $S->have_perm('super_mojo'))) {
		$min--;
	}
	
	if ($rating < $min) {
		$rating = $min;
	}
	
	return $rating;
}


sub _update_comment_rating {
	my $S = shift;
	my ($sid, $cid, $rating, $num, $flag) = @_;
	$rating = 'NULL' unless (defined($rating));
	$num = '-1' unless (defined($num));
	
	# Hack to make mysql work right.
	my ($rv, $sth) = $S->db_update({
		WHAT => 'comments',
		SET => qq|points = "1"|,
		WHERE => qq|sid = "$sid" AND cid = $cid|,
		DEBUG => 0});
	$sth->finish();
	
	my $r = ($rating eq 'NULL') ? 'NULL' : qq|"$rating"|;
	
	my $rate_q = {
		WHAT => 'comments',
		SET => qq|points = $r|,
		WHERE => qq|sid = "$sid" AND cid = $cid|,
		DEBUG => 0};
	
	unless ($flag) {
		$rate_q->{SET} .= qq|, lastmod = "$num"|;
	}
	
	($rv, $sth) = $S->db_update($rate_q);
	$sth->finish;
	
	return;
}

sub _current_rating_stats {
	my $S = shift;
	my ($sid, $cid) = @_;
	
	my ($rv, $sth) = $S->db_select({
		WHAT => 'rating',
		FROM => 'commentratings',
		WHERE => qq|sid = "$sid" AND cid = $cid|});
	if ($rv eq '0E0') {
		$rv = 0;
	}
	
	my $total = 0;
	while (my $rating = $sth->fetchrow_hashref) {
		$total += $rating->{rating};
	}
	$sth->finish;
	
	return ($total, $rv);
}


sub _is_current_rating {
	my $S = shift;
	my ($sid, $cid) = @_;
	my $uid = $S->{UID};
	
	my ($rv, $sth) = $S->db_select({
		DEBUG => 0,
		WHAT => 'rating',
		FROM => 'commentratings',
		WHERE => qq|sid = "$sid" AND cid = $cid AND uid = $uid|});
	
	if ($rv eq '0E0') {
		$rv = 0;
	}
	$sth->finish;

	return $rv;
}

sub _check_rating_perm {
	my $S = shift;
	my ($sid, $cid) = @_;
	
	return 0 unless ($S->have_perm('comment_rate'));
	
	my ($rv, $sth) = $S->db_select({
		WHAT => 'uid',
		FROM => 'comments',
		WHERE => qq|sid = "$sid" AND cid = $cid|});
	
	my $row = $sth->fetchrow_hashref;
	$sth->finish;
	my $comp_uid = $row->{uid};
	
	if ($S->{UID} == $comp_uid) {
		return 0;
	}
	
	return 1;
}

sub _delete_ratings {
	my $S = shift;
	my $sid = shift;
	my $cid = shift;
	my $uid = shift;
	
	my ($rv, $sth) = $S->db_delete({
		FROM => 'commentratings',
		WHERE => qq|sid = "$sid" AND cid = $cid|});
	
	if ($rv) {
		$S->update_mojo({$uid => 1});
	}
	
	return;
}


1;
